require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_PTRACE_H)) {
    eval 'sub _LINUX_PTRACE_H {1;}' unless defined(&_LINUX_PTRACE_H);
    eval 'sub PTRACE_TRACEME {0;}' unless defined(&PTRACE_TRACEME);
    eval 'sub PTRACE_PEEKTEXT {1;}' unless defined(&PTRACE_PEEKTEXT);
    eval 'sub PTRACE_PEEKDATA {2;}' unless defined(&PTRACE_PEEKDATA);
    eval 'sub PTRACE_PEEKUSR {3;}' unless defined(&PTRACE_PEEKUSR);
    eval 'sub PTRACE_POKETEXT {4;}' unless defined(&PTRACE_POKETEXT);
    eval 'sub PTRACE_POKEDATA {5;}' unless defined(&PTRACE_POKEDATA);
    eval 'sub PTRACE_POKEUSR {6;}' unless defined(&PTRACE_POKEUSR);
    eval 'sub PTRACE_CONT {7;}' unless defined(&PTRACE_CONT);
    eval 'sub PTRACE_KILL {8;}' unless defined(&PTRACE_KILL);
    eval 'sub PTRACE_SINGLESTEP {9;}' unless defined(&PTRACE_SINGLESTEP);
    eval 'sub PTRACE_ATTACH {0x10;}' unless defined(&PTRACE_ATTACH);
    eval 'sub PTRACE_DETACH {0x11;}' unless defined(&PTRACE_DETACH);
    eval 'sub PTRACE_SYSCALL {24;}' unless defined(&PTRACE_SYSCALL);
    eval 'sub PTRACE_SETOPTIONS {0x4200;}' unless defined(&PTRACE_SETOPTIONS);
    eval 'sub PTRACE_GETEVENTMSG {0x4201;}' unless defined(&PTRACE_GETEVENTMSG);
    eval 'sub PTRACE_GETSIGINFO {0x4202;}' unless defined(&PTRACE_GETSIGINFO);
    eval 'sub PTRACE_SETSIGINFO {0x4203;}' unless defined(&PTRACE_SETSIGINFO);
    eval 'sub PTRACE_O_TRACESYSGOOD {0x1;}' unless defined(&PTRACE_O_TRACESYSGOOD);
    eval 'sub PTRACE_O_TRACEFORK {0x2;}' unless defined(&PTRACE_O_TRACEFORK);
    eval 'sub PTRACE_O_TRACEVFORK {0x4;}' unless defined(&PTRACE_O_TRACEVFORK);
    eval 'sub PTRACE_O_TRACECLONE {0x8;}' unless defined(&PTRACE_O_TRACECLONE);
    eval 'sub PTRACE_O_TRACEEXEC {0x10;}' unless defined(&PTRACE_O_TRACEEXEC);
    eval 'sub PTRACE_O_TRACEVFORKDONE {0x20;}' unless defined(&PTRACE_O_TRACEVFORKDONE);
    eval 'sub PTRACE_O_TRACEEXIT {0x40;}' unless defined(&PTRACE_O_TRACEEXIT);
    eval 'sub PTRACE_O_MASK {0x7f;}' unless defined(&PTRACE_O_MASK);
    eval 'sub PTRACE_EVENT_FORK {1;}' unless defined(&PTRACE_EVENT_FORK);
    eval 'sub PTRACE_EVENT_VFORK {2;}' unless defined(&PTRACE_EVENT_VFORK);
    eval 'sub PTRACE_EVENT_CLONE {3;}' unless defined(&PTRACE_EVENT_CLONE);
    eval 'sub PTRACE_EVENT_EXEC {4;}' unless defined(&PTRACE_EVENT_EXEC);
    eval 'sub PTRACE_EVENT_VFORK_DONE {5;}' unless defined(&PTRACE_EVENT_VFORK_DONE);
    eval 'sub PTRACE_EVENT_EXIT {6;}' unless defined(&PTRACE_EVENT_EXIT);
    require 'asm/ptrace.ph';
    if(defined(&__KERNEL__)) {
	eval 'sub PT_PTRACED {0x1;}' unless defined(&PT_PTRACED);
	eval 'sub PT_DTRACE {0x2;}' unless defined(&PT_DTRACE);
	eval 'sub PT_TRACESYSGOOD {0x4;}' unless defined(&PT_TRACESYSGOOD);
	eval 'sub PT_PTRACE_CAP {0x8;}' unless defined(&PT_PTRACE_CAP);
	eval 'sub PT_TRACE_FORK {0x10;}' unless defined(&PT_TRACE_FORK);
	eval 'sub PT_TRACE_VFORK {0x20;}' unless defined(&PT_TRACE_VFORK);
	eval 'sub PT_TRACE_CLONE {0x40;}' unless defined(&PT_TRACE_CLONE);
	eval 'sub PT_TRACE_EXEC {0x80;}' unless defined(&PT_TRACE_EXEC);
	eval 'sub PT_TRACE_VFORK_DONE {0x100;}' unless defined(&PT_TRACE_VFORK_DONE);
	eval 'sub PT_TRACE_EXIT {0x200;}' unless defined(&PT_TRACE_EXIT);
	eval 'sub PT_ATTACHED {0x400;}' unless defined(&PT_ATTACHED);
	eval 'sub PT_TRACE_MASK {0x3f4;}' unless defined(&PT_TRACE_MASK);
	eval 'sub PT_SINGLESTEP_BIT {31;}' unless defined(&PT_SINGLESTEP_BIT);
	eval 'sub PT_SINGLESTEP {(1<< &PT_SINGLESTEP_BIT);}' unless defined(&PT_SINGLESTEP);
	eval 'sub PT_BLOCKSTEP_BIT {30;}' unless defined(&PT_BLOCKSTEP_BIT);
	eval 'sub PT_BLOCKSTEP {(1<< &PT_BLOCKSTEP_BIT);}' unless defined(&PT_BLOCKSTEP);
	require 'linux/compiler.ph';
	require 'linux/sched.ph';
	eval 'sub ptrace_link {
	    my($child,$new_parent) = @_;
    	    eval q({  &if ( &unlikely( ($child->{ptrace})))  &__ptrace_link($child, $new_parent); });
	}' unless defined(&ptrace_link);
	eval 'sub ptrace_unlink {
	    my($child) = @_;
    	    eval q({  &if ( &unlikely( ($child->{ptrace})))  &__ptrace_unlink($child); });
	}' unless defined(&ptrace_unlink);
	unless(defined(&force_successful_syscall_return)) {
	    eval 'sub force_successful_syscall_return () {
	        eval q( &do { }  &while (0));
	    }' unless defined(&force_successful_syscall_return);
	}
    }
}
1;
