require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SMB_FS_SB)) {
    eval 'sub _SMB_FS_SB {1;}' unless defined(&_SMB_FS_SB);
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	require 'linux/smb.ph';
	eval 'sub MAX_REQUEST_HARD {256;}' unless defined(&MAX_REQUEST_HARD);
	eval("sub SMB_RECV_START () { 0; }") unless defined(&SMB_RECV_START);
	eval("sub SMB_RECV_HEADER () { 1; }") unless defined(&SMB_RECV_HEADER);
	eval("sub SMB_RECV_HCOMPLETE () { 2; }") unless defined(&SMB_RECV_HCOMPLETE);
	eval("sub SMB_RECV_PARAM () { 3; }") unless defined(&SMB_RECV_PARAM);
	eval("sub SMB_RECV_DATA () { 4; }") unless defined(&SMB_RECV_DATA);
	eval("sub SMB_RECV_END () { 5; }") unless defined(&SMB_RECV_END);
	eval("sub SMB_RECV_DROP () { 6; }") unless defined(&SMB_RECV_DROP);
	eval("sub SMB_RECV_REQUEST () { 7; }") unless defined(&SMB_RECV_REQUEST);
	eval 'sub server_from_inode {
	    my($inode) = @_;
    	    eval q( &SMB_SB(($inode)-> &i_sb));
	}' unless defined(&server_from_inode);
	eval 'sub server_from_dentry {
	    my($dentry) = @_;
    	    eval q( &SMB_SB(($dentry)-> &d_sb));
	}' unless defined(&server_from_dentry);
	eval 'sub SB_of {
	    my($server) = @_;
    	    eval q((($server)-> &super_block));
	}' unless defined(&SB_of);
	eval 'sub smb_lock_server_interruptible {
	    my($server) = @_;
    	    eval q({  &down_interruptible(( ($server->{sem}))); });
	}' unless defined(&smb_lock_server_interruptible);
	eval 'sub smb_lock_server {
	    my($server) = @_;
    	    eval q({  &down(( ($server->{sem}))); });
	}' unless defined(&smb_lock_server);
	eval 'sub smb_unlock_server {
	    my($server) = @_;
    	    eval q({  &up(( ($server->{sem}))); });
	}' unless defined(&smb_unlock_server);
    }
}
1;
