require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_TTY_H)) {
    eval 'sub _LINUX_TTY_H {1;}' unless defined(&_LINUX_TTY_H);
    eval 'sub MIN_NR_CONSOLES {1;}' unless defined(&MIN_NR_CONSOLES);
    eval 'sub MAX_NR_CONSOLES {63;}' unless defined(&MAX_NR_CONSOLES);
    eval 'sub MAX_NR_USER_CONSOLES {63;}' unless defined(&MAX_NR_USER_CONSOLES);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/fs.ph';
	require 'linux/major.ph';
	require 'linux/termios.ph';
	require 'linux/workqueue.ph';
	require 'linux/tty_driver.ph';
	require 'linux/tty_ldisc.ph';
	require 'linux/screen_info.ph';
	require 'asm/system.ph';
	eval 'sub NR_PTYS { &CONFIG_LEGACY_PTY_COUNT;}' unless defined(&NR_PTYS);
	eval 'sub NR_UNIX98_PTY_DEFAULT {4096;}' unless defined(&NR_UNIX98_PTY_DEFAULT);
	eval 'sub NR_UNIX98_PTY_MAX {(1<<  &MINORBITS);}' unless defined(&NR_UNIX98_PTY_MAX);
	eval 'sub NR_LDISCS {16;}' unless defined(&NR_LDISCS);
	eval 'sub __DISABLED_CHAR {ord(\'\\0\');}' unless defined(&__DISABLED_CHAR);
	eval 'sub TTY_FLIPBUF_SIZE {512;}' unless defined(&TTY_FLIPBUF_SIZE);
	eval 'sub PTY_BUF_SIZE {4* &TTY_FLIPBUF_SIZE;}' unless defined(&PTY_BUF_SIZE);
	eval 'sub TTY_NORMAL {0;}' unless defined(&TTY_NORMAL);
	eval 'sub TTY_BREAK {1;}' unless defined(&TTY_BREAK);
	eval 'sub TTY_FRAME {2;}' unless defined(&TTY_FRAME);
	eval 'sub TTY_PARITY {3;}' unless defined(&TTY_PARITY);
	eval 'sub TTY_OVERRUN {4;}' unless defined(&TTY_OVERRUN);
	eval 'sub INTR_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VINTR]})));
	}' unless defined(&INTR_CHAR);
	eval 'sub QUIT_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VQUIT]})));
	}' unless defined(&QUIT_CHAR);
	eval 'sub ERASE_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VERASE]})));
	}' unless defined(&ERASE_CHAR);
	eval 'sub KILL_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VKILL]})));
	}' unless defined(&KILL_CHAR);
	eval 'sub EOF_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VEOF]})));
	}' unless defined(&EOF_CHAR);
	eval 'sub TIME_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VTIME]})));
	}' unless defined(&TIME_CHAR);
	eval 'sub MIN_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VMIN]})));
	}' unless defined(&MIN_CHAR);
	eval 'sub SWTC_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VSWTC]})));
	}' unless defined(&SWTC_CHAR);
	eval 'sub START_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VSTART]})));
	}' unless defined(&START_CHAR);
	eval 'sub STOP_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VSTOP]})));
	}' unless defined(&STOP_CHAR);
	eval 'sub SUSP_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VSUSP]})));
	}' unless defined(&SUSP_CHAR);
	eval 'sub EOL_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VEOL]})));
	}' unless defined(&EOL_CHAR);
	eval 'sub REPRINT_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VREPRINT]})));
	}' unless defined(&REPRINT_CHAR);
	eval 'sub DISCARD_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VDISCARD]})));
	}' unless defined(&DISCARD_CHAR);
	eval 'sub WERASE_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VWERASE]})));
	}' unless defined(&WERASE_CHAR);
	eval 'sub LNEXT_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[&VLNEXT]})));
	}' unless defined(&LNEXT_CHAR);
	eval 'sub EOL2_CHAR {
	    my($tty) = @_;
    	    eval q((($tty)-> ($termios->{c_cc[VEOL2]})));
	}' unless defined(&EOL2_CHAR);
	eval 'sub _I_FLAG {
	    my($tty,$f) = @_;
    	    eval q((($tty)-> ($termios->{c_iflag}) & ($f)));
	}' unless defined(&_I_FLAG);
	eval 'sub _O_FLAG {
	    my($tty,$f) = @_;
    	    eval q((($tty)-> ($termios->{c_oflag}) & ($f)));
	}' unless defined(&_O_FLAG);
	eval 'sub _C_FLAG {
	    my($tty,$f) = @_;
    	    eval q((($tty)-> ($termios->{c_cflag}) & ($f)));
	}' unless defined(&_C_FLAG);
	eval 'sub _L_FLAG {
	    my($tty,$f) = @_;
    	    eval q((($tty)-> ($termios->{c_lflag}) & ($f)));
	}' unless defined(&_L_FLAG);
	eval 'sub I_IGNBRK {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IGNBRK));
	}' unless defined(&I_IGNBRK);
	eval 'sub I_BRKINT {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &BRKINT));
	}' unless defined(&I_BRKINT);
	eval 'sub I_IGNPAR {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IGNPAR));
	}' unless defined(&I_IGNPAR);
	eval 'sub I_PARMRK {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &PARMRK));
	}' unless defined(&I_PARMRK);
	eval 'sub I_INPCK {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &INPCK));
	}' unless defined(&I_INPCK);
	eval 'sub I_ISTRIP {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &ISTRIP));
	}' unless defined(&I_ISTRIP);
	eval 'sub I_INLCR {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &INLCR));
	}' unless defined(&I_INLCR);
	eval 'sub I_IGNCR {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IGNCR));
	}' unless defined(&I_IGNCR);
	eval 'sub I_ICRNL {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &ICRNL));
	}' unless defined(&I_ICRNL);
	eval 'sub I_IUCLC {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IUCLC));
	}' unless defined(&I_IUCLC);
	eval 'sub I_IXON {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IXON));
	}' unless defined(&I_IXON);
	eval 'sub I_IXANY {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IXANY));
	}' unless defined(&I_IXANY);
	eval 'sub I_IXOFF {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IXOFF));
	}' unless defined(&I_IXOFF);
	eval 'sub I_IMAXBEL {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IMAXBEL));
	}' unless defined(&I_IMAXBEL);
	eval 'sub I_IUTF8 {
	    my($tty) = @_;
    	    eval q( &_I_FLAG(($tty), &IUTF8));
	}' unless defined(&I_IUTF8);
	eval 'sub O_OPOST {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &OPOST));
	}' unless defined(&O_OPOST);
	eval 'sub O_OLCUC {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &OLCUC));
	}' unless defined(&O_OLCUC);
	eval 'sub O_ONLCR {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &ONLCR));
	}' unless defined(&O_ONLCR);
	eval 'sub O_OCRNL {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &OCRNL));
	}' unless defined(&O_OCRNL);
	eval 'sub O_ONOCR {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &ONOCR));
	}' unless defined(&O_ONOCR);
	eval 'sub O_ONLRET {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &ONLRET));
	}' unless defined(&O_ONLRET);
	eval 'sub O_OFILL {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &OFILL));
	}' unless defined(&O_OFILL);
	eval 'sub O_OFDEL {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &OFDEL));
	}' unless defined(&O_OFDEL);
	eval 'sub O_NLDLY {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &NLDLY));
	}' unless defined(&O_NLDLY);
	eval 'sub O_CRDLY {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &CRDLY));
	}' unless defined(&O_CRDLY);
	eval 'sub O_TABDLY {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &TABDLY));
	}' unless defined(&O_TABDLY);
	eval 'sub O_BSDLY {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &BSDLY));
	}' unless defined(&O_BSDLY);
	eval 'sub O_VTDLY {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &VTDLY));
	}' unless defined(&O_VTDLY);
	eval 'sub O_FFDLY {
	    my($tty) = @_;
    	    eval q( &_O_FLAG(($tty), &FFDLY));
	}' unless defined(&O_FFDLY);
	eval 'sub C_BAUD {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &CBAUD));
	}' unless defined(&C_BAUD);
	eval 'sub C_CSIZE {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &CSIZE));
	}' unless defined(&C_CSIZE);
	eval 'sub C_CSTOPB {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &CSTOPB));
	}' unless defined(&C_CSTOPB);
	eval 'sub C_CREAD {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &CREAD));
	}' unless defined(&C_CREAD);
	eval 'sub C_PARENB {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &PARENB));
	}' unless defined(&C_PARENB);
	eval 'sub C_PARODD {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &PARODD));
	}' unless defined(&C_PARODD);
	eval 'sub C_HUPCL {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &HUPCL));
	}' unless defined(&C_HUPCL);
	eval 'sub C_CLOCAL {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &CLOCAL));
	}' unless defined(&C_CLOCAL);
	eval 'sub C_CIBAUD {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &CIBAUD));
	}' unless defined(&C_CIBAUD);
	eval 'sub C_CRTSCTS {
	    my($tty) = @_;
    	    eval q( &_C_FLAG(($tty), &CRTSCTS));
	}' unless defined(&C_CRTSCTS);
	eval 'sub L_ISIG {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ISIG));
	}' unless defined(&L_ISIG);
	eval 'sub L_ICANON {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ICANON));
	}' unless defined(&L_ICANON);
	eval 'sub L_XCASE {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &XCASE));
	}' unless defined(&L_XCASE);
	eval 'sub L_ECHO {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ECHO));
	}' unless defined(&L_ECHO);
	eval 'sub L_ECHOE {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ECHOE));
	}' unless defined(&L_ECHOE);
	eval 'sub L_ECHOK {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ECHOK));
	}' unless defined(&L_ECHOK);
	eval 'sub L_ECHONL {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ECHONL));
	}' unless defined(&L_ECHONL);
	eval 'sub L_NOFLSH {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &NOFLSH));
	}' unless defined(&L_NOFLSH);
	eval 'sub L_TOSTOP {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &TOSTOP));
	}' unless defined(&L_TOSTOP);
	eval 'sub L_ECHOCTL {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ECHOCTL));
	}' unless defined(&L_ECHOCTL);
	eval 'sub L_ECHOPRT {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ECHOPRT));
	}' unless defined(&L_ECHOPRT);
	eval 'sub L_ECHOKE {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &ECHOKE));
	}' unless defined(&L_ECHOKE);
	eval 'sub L_FLUSHO {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &FLUSHO));
	}' unless defined(&L_FLUSHO);
	eval 'sub L_PENDIN {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &PENDIN));
	}' unless defined(&L_PENDIN);
	eval 'sub L_IEXTEN {
	    my($tty) = @_;
    	    eval q( &_L_FLAG(($tty), &IEXTEN));
	}' unless defined(&L_IEXTEN);
	eval 'sub N_TTY_BUF_SIZE {4096;}' unless defined(&N_TTY_BUF_SIZE);
	eval 'sub TTY_MAGIC {0x5401;}' unless defined(&TTY_MAGIC);
	eval 'sub TTY_THROTTLED {0;}' unless defined(&TTY_THROTTLED);
	eval 'sub TTY_IO_ERROR {1;}' unless defined(&TTY_IO_ERROR);
	eval 'sub TTY_OTHER_CLOSED {2;}' unless defined(&TTY_OTHER_CLOSED);
	eval 'sub TTY_EXCLUSIVE {3;}' unless defined(&TTY_EXCLUSIVE);
	eval 'sub TTY_DEBUG {4;}' unless defined(&TTY_DEBUG);
	eval 'sub TTY_DO_WRITE_WAKEUP {5;}' unless defined(&TTY_DO_WRITE_WAKEUP);
	eval 'sub TTY_PUSH {6;}' unless defined(&TTY_PUSH);
	eval 'sub TTY_CLOSING {7;}' unless defined(&TTY_CLOSING);
	eval 'sub TTY_DONT_FLIP {8;}' unless defined(&TTY_DONT_FLIP);
	eval 'sub TTY_LDISC {9;}' unless defined(&TTY_LDISC);
	eval 'sub TTY_HW_COOK_OUT {14;}' unless defined(&TTY_HW_COOK_OUT);
	eval 'sub TTY_HW_COOK_IN {15;}' unless defined(&TTY_HW_COOK_IN);
	eval 'sub TTY_PTY_LOCK {16;}' unless defined(&TTY_PTY_LOCK);
	eval 'sub TTY_NO_WRITE_SPLIT {17;}' unless defined(&TTY_NO_WRITE_SPLIT);
	eval 'sub TTY_HUPPED {18;}' unless defined(&TTY_HUPPED);
	eval 'sub TTY_WRITE_FLUSH {
	    my($tty) = @_;
    	    eval q( &tty_write_flush(($tty)));
	}' unless defined(&TTY_WRITE_FLUSH);
	eval 'sub tty_devnum {
	    my($tty) = @_;
    	    eval q({  &MKDEV( ($tty->{driver}->{major}),  ($tty->{driver}->{minor_start})) +  ($tty->{index}); });
	}' unless defined(&tty_devnum);
    }
}
1;
