#! /bin/sh
### BEGIN INIT INFO
# Provides:          hostname
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Set hostname.
# Description:
### END INIT INFO
#
# Version:	@(#)hostname.sh  1.10  26-Feb-2001  miquels@cistron.nl
#

. /lib/lsb/init-functions
. /etc/default/rcS

do_start () {
	[ -f /etc/hostname ] && HOSTNAME=`cat /etc/hostname`

	# Keep current name if /etc/hostname is missing.
	[ -z "$HOSTNAME" ] && HOSTNAME=`hostname`

	# And set it to 'localhost' if no setting was found
	[ -z "$HOSTNAME" ] && HOSTNAME=localhost

	[ "$VERBOSE" != no ] && log_action_begin_msg "Setting hostname '$HOSTNAME'"
	hostname "$HOSTNAME"
	[ "$VERBOSE" != no ] && log_action_end_msg $?
}

case "$1" in
    start)
        do_start
        ;;
    restart|reload|force-reload)
        echo "Error: argument '$1' not supported" >&2
        exit 3
        ;;
    stop)
        ;;
    *)
        echo "Usage: $0 start|stop" >&2
        exit 3
        ;;
esac
