#! /bin/sh
### BEGIN INIT INFO
# Provides:          umountnfs
# Required-Start:    sendsigs
# Required-Stop:
# Default-Start:     6
# Default-Stop:
# Short-Description: Unmount all network filesystems except the root file system.
# Description:       Also unmounts all virtual filesystems (proc, devfs,
#		     devpts, usbfs, sysfs) that are not mounted at the
#		     top-level.
#
#		     Also unmounts all virtual filesystems (proc,
#		     devfs, devpts, usbfs, sysfs) that are not mounted
#		     at the top-level.
### END INIT INFO
#
# Version:      @(#)umountnfs  2.85-23  29-Jul-2004  miquels@cistron.nl
#

PATH=/sbin:/bin:/usr/sbin:/usr/bin

. /lib/lsb/init-functions

KERNEL=`uname -s`
RELEASE=`uname -r`

case "${KERNEL}:${RELEASE}" in
	Linux:[01].*|Linux:2.[01].*)
		FLAGS=""
		;;
	Linux:2.[23].*|Linux:2.4.?|Linux:2.4.?-*|Linux:2.4.10|Linux:2.4.10-*)
		FLAGS="-f"
		;;
	*)
		FLAGS="-f -l"
		;;
esac

do_stop () {
	# Write a reboot record to /var/log/wtmp before unmounting
	halt -w

	# Remove any .clean files in auto-clean dirs.
	rm -f /tmp/.clean /var/lock/.clean /var/run/.clean

	log_action_begin_msg "Unmounting remote filesystems"

	#
	#	Read mtab file and add the directories we want to
	#	unmount in reverse to a list.
	#
	(
	DIRS=""
		while read DEV DIR TYPE REST
		do
			case "$DIR" in
				/|/proc|/dev|/dev/shm|/dev/pts|/proc/*|/sys|/var/run|/var/lock)
					continue
					;;
			esac
			case "$TYPE" in
				nfs|nfs4|smbfs|ncp|ncpfs|cifs|coda)
					DIRS="$DIR $DIRS"
					;;
				proc|procfs|linprocfs|devfs|devpts|usbfs|usbdevfs|sysfs)
					DIRS="$DIR $DIRS"
					;;
			esac
		done
		exec </dev/null
		if [ -n "$DIRS" ]
		then
			umount $FLAGS $DIRS
		fi
	) </etc/mtab

	log_action_end_msg 0
}

case "$1" in
    start)
        ;;
    restart|reload|force-reload)
        echo "Error: argument '$1' not supported" >&2
        exit 3
        ;;
    stop)
        do_stop
        ;;
    *)
        echo "Usage: $0 start|stop" >&2
        exit 3
        ;;
esac

: exit 0
