#! /bin/sh
### BEGIN INIT INFO
# Provides:          mountall
# Required-Start:    checkfs
# Required-Stop: 
# Should-Start:      lvm
# Should-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Mount all filesystems.
# Description:
### END INIT INFO
#
# Version:	@(#)mountall.sh  2.85-23  29-Jul-2004  miquels@cistron.nl
#

[ -z "$VERBOSE" ] && VERBOSE=yes
[ -z "$TMPTIME" ] && TMPTIME=0
[ -f /etc/default/rcS ] && . /etc/default/rcS
. /etc/init.d/bootclean.sh
. /lib/init/functions.sh
. /lib/lsb/init-functions

do_start () {
	#
	# Mount local file systems in /etc/fstab.
	#
	[ "$VERBOSE" != no ] && log_action_begin_msg "Mounting local filesystems"

	pre_mountall

	# Accept 96 (32/mount failure + 64/some mount succeeded)
	# as a valid exit code from mount in mountall.sh.
	# It seems to be returned when some mount points were already mounted.
	MOUNT_MESSAGES="$(mount -av -t nonfs,nonfs4,nosmbfs,nocifs,noncp,noncpfs,nocoda,noocfs2,nogfs 2>&1)"
	ES=$?

	post_mountall

	if [ "$VERBOSE" != no ]; then
	    echo "$MOUNT_MESSAGES" | egrep -v '(already|nothing was) mounted' | while read MOUNT_MESSAGE_TO_PRINT ; do
			log_warning_msg $MOUNT_MESSAGE_TO_PRINT
		done
	fi

	case `uname -s` in
		*FreeBSD)
			INITCTL=/etc/.initctl
			;;
		*)
			INITCTL=/dev/initctl
			;;
	esac

	#
	# We might have mounted something over /dev, see if
	# /dev/initctl is there.
	#
	if [ ! -p $INITCTL ]
	then
		rm -f $INITCTL
		mknod -m 600 $INITCTL p
	fi
	kill -USR1 1

	#
	# Execute swapon command again, in case we want to swap to
	# a file on a now mounted filesystem.
	#
	doswap=yes
	case "`uname -sr`" in
		Linux\ 2.[0123].*)
			if grep -qs resync /proc/mdstat
			then
				doswap=no
			fi
			;;
	esac
	if [ "$doswap" = yes ]
	then
		swapon -a -e
	fi

	#
	#	Clean /tmp
	#
	bootclean mountall
}

case "$1" in
    start)
        do_start
        ;;
    restart|reload|force-reload)
        echo "Error: argument '$1' not supported" >&2
        exit 3
        ;;
    stop)
        ;;
    *)
        echo "Usage: $0 start|stop" >&2
        exit 3
        ;;
esac

: exit 0
