#
# Functions used by several scripts in initscripts package.  The API
# provided here is not stable, and should only be used by the scripts
# in the initscripts package.
#

#
#	Helper: is a directory writable ?
#
dir_writable () {
	if [ -d "$1/" ] && [ -w "$1/" ] && touch -a "$1/" 2>/dev/null
	then
		return 0
	fi
	return 1
}

#
# Return true if SELinux is enabled, false otherwise.
#
selinux_enabled () {
    [ -x /usr/sbin/selinuxenabled ] && /usr/sbin/selinuxenabled
}

#
# Get options from /etc/fstab
#
fstab_opts ()
{
	# Get the options from /etc/fstab.
	OPTS=
	if [ -f /etc/fstab ]
	then
		exec 9<&0 0</etc/fstab
		while read FDEV FDIR FTYPE FOPTS REST
		do
			case "$FDEV" in
				""|\#*)
					continue
					;;
			esac
			if [ "$2" != "$FDIR" ] || [ "$1" != "$FTYPE" ]
			then
				continue
			fi
			case "$FOPTS" in
				noauto|*,noauto|noauto,*|*,noauto,*)
					return
					;;
				?*)
					OPTS="-o$FOPTS"
					;;
			esac
			break
		done
		exec 0<&9 9<&-
	fi
}

#
# Mount a filesystem
#
domount ()
{
	# Directory present?
	if [ ! -d $2 ]
	then
		return
	fi

	# Already mounted?
	if mountpoint -q $2
	then
		return
	fi

	# Mount the filesystem without updating /etc/mtab
	fstab_opts $1 $2
	mount -n -t $1 $OPTS $3 $1 $2
}

#
# Preserve /var/run and /var/lock mountpoints
#
pre_mountall ()
{
	# We may end up mounting something over top of /var, either directly
	# or because /var is a symlink to something that's mounted.  So keep
	# copies of the /var/run and /var/lock mounts elsewhere on the root
	# filesystem so they can be moved back.
	mkdir /dev/shm/var.run /dev/shm/var.lock
	mount -n --bind /var/run /dev/shm/var.run
	mount -n --bind /var/lock /dev/shm/var.lock
}

#
# Restore /var/run and /var/lock mountpoints
#
post_mountall ()
{
	# Make sure the new filesystem has a /var/run and /var/lock
	[ -d /var/run ] || mkdir /var/run
	[ -d /var/lock ] || mkdir /var/lock
	
	# Move the mountpoints back.  Fortunately mount seems to not care
	# if these are the same thing (ie. /var didn't get changed) so we
	# do this regardless
	mount -n --move /dev/shm/var.run /var/run
	mount -n --move /dev/shm/var.lock /var/lock
	
	# Clean up after ourselves
	rmdir /dev/shm/var.run /dev/shm/var.lock
}
