

Manuel de l'utilisateur d'aptitude


Version 0.2.15.9


Daniel Burrows

<dburrows@debian.org>

Copyright  2004 Daniel Burrows

This manual is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This manual is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this manual; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA

--------------------------------------------------------------------------------
Table of Contents



  Introduction


        Qu'est-ce qu'aptitude, au fait ?

        Qu'est-ce qu'un gestionnaire de paquets ?

        Qu'est-ce que le systme apt ?

        Comment se procure-t-on aptitude ?


              Paquets prcompils d'aptitude, ``ce que 99% des utilisateurs
              devraient utiliser''

              Construire aptitude depuis les sources

              Rcuprer aptitude depuis le dpt Subversion



  1. Notions pour commencer


        Utiliser aptitude


              Les bases d'aptitude

              Naviguer dans la liste des paquets d'aptitude

              Rechercher des paquets par leur nom

              Grer les paquets

              Mettre  jour la liste de paquets et installer des paquets


        Utiliser aptitude depuis la ligne de commande


  2. Guide de rfrence d'aptitude


        L'interface utilisateur d'aptitude


              Utiliser les menus

              Commandes du menu

              Travailler avec plusieurs vues

              Devenir administrateur ( root )


        Gestion des paquets


              Grer la liste des paquets

              Accder aux informations des paquets

              Modifier l'tat d'un paquet

              Tlcharger, installer et supprimer des paquets

              Grer les paquets automatiquement installs


        Motifs de recherche

        Personnalisation d'aptitude


              Personnaliser la liste des paquets

              Personnaliser les raccourcis clavier

              Personnaliser les couleurs

              Personnaliser la disposition de l'affichage

              Rfrence du fichier de configuration

              Thmes


        Jouer au dmineur


  3. FAQ d'aptitude

  4. Crdits

  I. Rfrence de la ligne de commande d'aptitude


        aptitude - interface volue pour le gestionnaire de paquets.


List of Figures



  2.1. Commandes disponibles dans le menu Actions

  2.2. Commandes disponibles dans le menu Dfaire

  2.3. Commandes disponibles dans le menu Paquet

  2.4. Commandes disponibles dans le menu Rechercher

  2.5. Commandes disponibles dans le menu Options

  2.6. Commandes disponibles dans le menu Vues

  2.7. Commandes disponibles dans le menu Aide

  2.8. Valeurs de l'indicateur de ``l'tat courant''

  2.9. Valeur de l'indicateur ``d'action''

  2.10. Couleurs personnalisables dans aptitude


Introduction

Table of Contents



  Qu'est-ce qu'aptitude, au fait ?

  Qu'est-ce qu'un gestionnaire de paquets ?

  Qu'est-ce que le systme apt ?

  Comment se procure-t-on aptitude ?


        Paquets prcompils d'aptitude, ``ce que 99% des utilisateurs devraient
        utiliser''

        Construire aptitude depuis les sources

        Rcuprer aptitude depuis le dpt Subversion



   Matre, est-ce qu'Emacs connais la nature du Bouddha ?  demanda le         
  novice.

   Je ne vois pas pourquoi pas  rpondit le matre.  Il fait sacrment bien
  tout le reste  . Plusieurs annes plus tard, le novice eut l'illumination.

                                                                   -- John Fouhy


Voici le manuel de l'utilisateur d'aptitude ! Cette introduction explique ce
qu'est aptitude et  quoi il sert. Pour accder aux informations sur la manire
de l'utiliser, allez directement  Chapter 1, Notions_pour_commencer.


Qu'est-ce qu'aptitude, au fait ?

aptitude est un gestionnaire de paquets pour les systmes Debian GNU/Linux aux
multiples fonctionnalits et bas sur la fameuse infrastructure de gestion de
paquets apt. aptitude fournit les fonctionnalits de dselect et apt-get, ainsi
que beaucoup d'autres introuvables dans ces programmes.


Qu'est-ce qu'un gestionnaire de paquets ?

Un gestionnaire de paquets garde la trace des programmes installs sur votre
ordinateur et vous permet facilement d'en installer de nouveaux, de les mettre 
jour vers de nouvelles versions ou de supprimer ceux que vous aviez prcdemment
installs. Comme le nom le suggre, un gestionnaire de paquets traite des
paquets qui sont des rassemblements de fichiers qui sont empaquets ensemble et
qui peuvent tre installs ou supprims en bloc.

Gnralement, un paquet fournit un programme particulier. Par exemple le client
de messagerie instantane gaim est contenu dans le paquet Debian du mme nom.
D'un autre ct, il est frquent qu'un programme se compose de plusieurs paquets
apparents. Par exemple, l'diteur d'image gimp n'est pas constitu que du
paquet gimp, mais aussi du paquet gimp-data ; de plus plusieurs paquets
optionnels supplmentaires (contenant des donnes diverses, de la documentation
et bien d'autres encore) sont aussi disponibles. Il arrive aussi que plusieurs
petits programmes apparents soient fournis dans un unique paquet. Par exemple,
le paquet fileutils contient plusieurs commandes Unix usuelles telles que ls,
cp, etc.

Quelques paquet requirent d'autres paquets pour fonctionner.  l'intrieur de
Debian, les paquets peuvent dpendre ( depend ), recommander ( recommend ),
suggrer ( suggest ) ou tre en conflit avec ( conflict ) d'autres paquets.


* Si un paquet A dpend d'un paquet B, alors B est ncessaire au bon
  fonctionnement de A. Par exemple, le paquet gimp dpend du paquet gimp-data
  pour s'assurer que l'diteur de graphismes GIMP aura accs  ses fichiers de
  donnes.

* Si un paquet A recommande un autre paquet B, alors B fournit une
  fonctionnalit importante  A qui est apprcie dans la plupart des
  circonstances. Par exemple, le paquet mozilla-browser recommande le paquet
  mozilla-psm qui ajoute la gestion des transferts de donnes scuriss au
  navigateur web Mozilla. Bien que mozilla-psm ne soit pas absolument ncessaire
  pour que Mozilla fonctionne, la plupart des utilisateurs veulent que Mozilla
  gre la transmission scurise de donnes confidentielles (tel que leur numro
  de carte bancaire).

* Si un paquet A suggre un autre paquet B, alors le paquet B fournit une
  fonctionnalit qui peut amliorer A sans qu'elle ne soit gnralement
  ncessaire. Par exemple le paquet kmail suggre le paquet gnupg qui contient
  un logiciel de chiffrement que KMail peut utiliser.

* Si un paquet A est en conflit avec un autre paquet B, alors les deux paquets
  ne peuvent pas tre installs au mme moment. Par exemple, fb-music-hi est en
  conflit avec fb-music-low car ils fournissent tout deux des jeux de musiques
  de remplacement pour le jeu Frozen Bubble.


Le travail du gestionnaire de paquets est de prsenter une interface qui aide
l'utilisateur  grer l'ensemble des paquets installs sur son systme. aptitude
fournit une telle interface en tirant parti du systme de gestion de paquets
apt.


Qu'est-ce que le systme apt ?

tre capable d'installer et de supprimer des paquets, c'est formidable, mais le
programme basique charg de faire cela (connu sous le nom de dpkg) ne fait que
cela et rien de plus. C'est trs bien si vous tlchargez un ou deux paquets 
la main, mais cela devient vite fatiguant quand vous essayez de grer un grand
nombre de paquets. De plus, si un nouveau paquet intressant ncessite des
programmes que vous n'avez pas encore installs, vous devez tlcharger les
nouveaux paquets requis  la main. Et si vous dcidez par la suite de supprimer
le paquet auparavant intressant, les paquets additionnels vont rester sur votre
systme et occuper de la place sur vos disques  moins que vous ne les
supprimiez vous-mme.

videment, toutes ces oprations sont fastidieuses, et donc la plupart des
systmes de gestion de paquets sont accompagns de programmes qui se chargent de
tout cela  votre place. apt est la base commune sur laquelle sont construits
ces programmes : en plus d'aptitude, des programmes comme synaptic et apt-watch
utilisent apt.

apt fonctionne grce  une liste des paquets qui peuvent tre tlchargs depuis
Debian sur votre ordinateur. Cette liste est utilise pour trouver les paquets
qui ont besoin d'tre mis  jour et pour installer de nouveaux paquets. apt peut
aussi rsoudre de nombreux problmes de dpendances automatiquement : par
exemple, quand vous choisissez d'installer un paquet, il va rechercher tous les
paquets supplmentaires requis et les installer en mme temps.

Avec un gestionnaire de paquet bas sur apt, tel qu'aptitude, vous aller
typiquement effectuer trois oprations de base : mettre  jour la liste des
paquets disponibles en tlchargeant de nouvelles listes depuis les serveurs
Debian, slectionner quels paquets doivent tre installs, mis  jour ou
supprims, et enfin mettre  excution votre slection en procdant rellement
aux installations, suppressions, etc.

Les gestionnaires de paquets bass sur apt lisent la liste des ``sources''
(dpt de paquets Debian) dans le fichier /etc/apt/sources.list. Le format et le
contenu de ce fichier sont hors de la porte de ce document, mais sont dcrits
dans la page de manuel sources.list(5).


 Comment se procure-t-on aptitude ?

Si vous lisez ce document sans qu'aptitude ne soit install sur votre systme,
cette section explique comment vous sortir de cette mauvaise passe. La plupart
des gens devraient aller directement  la section sur les paquets binaires.


Paquets prcompils d'aptitude, ``ce que 99% des utilisateurs devraient
utiliser''

Les paquets prcompils, ou ``binaires'', sont le moyen le plus facile et le
plus courant d'installer aptitude. Vous devriez uniquement tenter d'installer
depuis les sources si aucun paquet binaire n'est disponible pour une raison ou
une autre, ou si vous avez des besoins particuliers qui ne sont pas satisfaits
par les paquets binaires.

Si vous tes en train d'utiliser un systme Debian, excutez la commande
suivante en tant que root : apt-get install aptitude. Sinon, le fournisseur de
votre systme a d crer un paquet pour aptitude. Dans le doute, vous pouvez le
contacter pour qu'il vous conseille davantage.


Construire aptitude depuis les sources

Vous pouvez aussi construire aptitude depuis les sources. Nanmoins, il est
probable que ce ne soit pas utile si apt est dj install sur votre systme. Si
ce n'est pas le cas vous pouvez installer aptitude depuis les sources en suivant
les tapes suivantes :


  1. Installer les programmes suivants :


     * Un compilateur C++, comme g++.

     * Les fichiers de dveloppement d'apt, habituellement disponibles dans le
       paquet nomm libapt-pkg-dev.

     * Les bibliothques libsigc++, disponibles depuis http://
       libsigc.sourceforge.net.

     * Enfin, tlcharger le code source le plus rcent d'aptitude, disponible
       sur http://packages.debian.org/unstable/admin/aptitude (faites dfiler
       l'cran jusqu'en bas et tlcharger le fichier ``.orig.tar.gz'').



Une fois tous ces composants runis, ouvrez un terminal et excutez la
commande : tar zxf aptitude-0.2.15.9.tar.gz pour dsarchiver le code source. Une
fois les sources dsarchives, tapez cd aptitude-0.2.15.9 && ./configure && make
pour compiler aptitude. Si cela russit, assurez-vous que vous tre sous
l'utilisateur root (en utilisant, par exemple, su), tapez alors make install
pour installer aptitude sur votre ordinateur. Une fois qu'aptitude est
correctement install, taper aptitude  l'invite de la ligne de commande devrait
lancer le programme.


Rcuprer aptitude depuis le dpt Subversion

Si vous souhaitez tester le tout dernier code source en date ou aider au
dveloppement d'aptitude, vous pouvez tlcharger le code source non encore
publi d'aptitude en utilisant Subversion. Installez Subversion (disponible 
http://subversion.tigris.org) et excutez la commande svn checkout svn://
svn.debian.org/aptitude/trunk/aptitude pour rcuprer le code source le plus
rcent. Une fois le code source sur votre ordinateur, vous pouvez aller dans le
rpertoire des sources et taper svn update pour les synchroniser avec tous les
changements intervenus sur le dpt central.

Pour construire aptitude depuis le dpt Subversion, vous devez avoir les
programmes autoconf et automake installs. Tapez ./autogen.sh pour gnrer les
fichiers ncessaires pour compiler aptitude, puis excutez make et make install.


 [Warning]  Warning

            Le dpt Subversion d'aptitude est un arbre de dveloppement actif ;
            il est modifi au fur et  mesure des corrections de bogues et
            d'ajout de fonctionnalits, sans qu'il ne soit absolument garanti
            qu'il se compile ! Les rapports de bogues sont les bienvenus, mais
            soyez conscient que vous utilisez du code de dveloppement  vos
            propres risques et prils ![1]




--------------------------------------------------------------------------------
[1]Bien sr, vous utilisez tous les logiciels libres  vos propres risques, mais
le risque induit par l'utilisation d'un arbre de dveloppement actif est encore
plus grand.


Chapter 1. Notions pour commencer

Table of Contents



  Utiliser aptitude


        Les bases d'aptitude

        Naviguer dans la liste des paquets d'aptitude

        Rechercher des paquets par leur nom

        Grer les paquets

        Mettre  jour la liste de paquets et installer des paquets


  Utiliser aptitude depuis la ligne de commande


  Un voyage de mille lieues commence toujours par un premier pas.  

                                                        -- Lao Tseu


aptitude est un assez gros programme avec de nombreuses fonctionnalits et il
peut tre un peu lourd pour les nouveaux utilisateurs qui veulent l'aborder. Ce
chapitre ne dcrit pas de faon exhaustive les fonctionnalits d'aptitude
(consultez Chapter 2, Guide_de_rfrence_d'aptitude pour cela), mais il fournit
un aperu des fonctionnalits de base les plus utilises de ce programme.


Utiliser aptitude

Cette section dcrit comment utiliser l'interface graphique d'aptitude. Pour des
informations sur l'utilisation de l'interface d'aptitude en ligne de commande,
consultez the section called ``Utiliser aptitude depuis la ligne de commande''.


Les bases d'aptitude

Pour lancer aptitude, ouvrez votre terminal prfr et tapez sur la ligne de
commande :

toto$ aptitude

Une fois que le cache est charg (ce qui peut prendre un peu de temps sur les
machines les plus lentes), l'cran principal d'aptitude apparat :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--- Paquets installs
--- Paquets non installs
--- Paquets obsoltes ou crs localement
--- Paquets virtuels
--- Tches






Ces paquets sont actuellement installs sur votre ordinateur.








Comme vous pouvez le voir, l'cran principal d'aptitude est divis en plusieurs
parties. La ligne bleue en haut du terminal est la barre de menu, et la ligne
bleue juste au dessous contient des informations sur quelques commandes
importantes. La zone noire qui les suit contient la liste de tous les paquets
disponibles dans laquelle des groupes de paquets sont lists. Le groupe
actuellement slectionn (``Paquets installs'') est mis en vidence et sa
description est indique dans l'espace noir du bas.

Comme le suggre la ligne la plus en haut de l'cran, vous pouvez accder au
menu d'aptitude en pressant F10 ; vous pouvez aussi cliquer avec la souris sur
un onglet du menu si votre systme le gre. Appuyer sur F10 va ouvrir le menu
Actions :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
+------------------------------------------------+Tlch./Inst./Suppr. Pqts
|Installer/enlever des paquets                  g|
|Mettre  jour les listes de paquets            u|
|Oublier les nouveaux paquets                   f|
|Nettoyer le cache des paquets                   |
|Nettoyer les fichiers prims                   |
|Marquer comme tant susceptible de mise  jour U|
|Jouer au dmineur                               |
|Devenir administrateur                          |
+------------------------------------------------+
|Quitter                                        Q|
+------------------------------------------------+
Ces paquets sont actuellement installs sur votre ordinateur.










Effectuer toutes les actions d'installation ou de suppression demandes

Utilisez les flches et Entre pour slectionner un onglet du menu (ou, si votre
systme le gre, cliquez sur celui-ci avec la souris) ; pour fermer le menu sans
rien slectionner, appuyez  nouveau sur F10. Le menu surlign est expliqu en
bas de l'cran. Si une option du menu peut tre utilise via un raccourci
clavier, celui-ci est affich dans le menu : par exemple, la commande ``Mettre 
jour les listes de paquets'' peut tre lanc en appuyant sur u.

 tout moment, appuyer sur ? vous permet d'afficher une rfrence en ligne des
raccourcis clavier disponibles.


Naviguer dans la liste des paquets d'aptitude

La liste des paquets est l'interface principale d'aptitude. Quand aptitude
dmarre, la liste est organise suivant un certain nombre de groupes comme on
peut le voir sur la capture suivante :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--- Paquets installs
--- Paquets non installs
--- Paquets obsoltes ou crs localement
--- Paquets virtuels
--- Tches





Ces paquets sont actuellement installs sur votre ordinateur.









 [Note]  Note

         Les groupes de paquets vides sont automatiquement cachs par aptitude,
         donc vous pourriez voir plus ou moins de groupes que ceux prsents sur
         cette capture.


Sur la capture prcdente, le premier groupe (``Paquets installs'') est
surlign pour indiquer qu'il est actuellement slectionn. Vous pouvez modifier
la slection avec les flches haut et bas. Notez que la description affiche en
bas change en consquence. Pour ``dployer'' un groupe, appuyer sur Entre alors
que le groupe est slectionn :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--\ Paquets installs
  --- admin - Utilitaires d'administration (installation de logiciels, gestion d
  --- base - Le systme de base Debian
  --- devel - Utilitaires et logiciels pour le dveloppement de programmes
  --- doc - Documentation et programmes pour l'affichage de la documentation
  --- editors - diteurs de texte et traitement de texte
  --- games - Jeux, jouets et programmes de divertissement
  --- graphics - Utilitaires pour crer, afficher et diter les images

Ces paquets sont actuellement installs sur votre ordinateur.








Comme vous pouvez le voir, le groupe ``Paquets installs'' a t dploy pour
faire apparatre son contenu : il contient un certain nombre de sous-groupes
sommairement dfinis par le type de programmes qu'ils contiennent. Dployer la
section ``admin'' en la slectionnant et en appuyant sur Entre affiche :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--\ Paquets installs
  --\ admin - Utilitaires d'administration (installation de logiciels, gestion d
    --- main - L'archive principale de Debian
  --- base - Le systme de base Debian
  --- devel - Utilitaires et logiciels pour le dveloppement de programmes
  --- doc - Documentation et programmes pour l'affichage de la documentation
  --- editors - diteurs de texte et traitement de texte
  --- games - Jeux, jouets et programmes de divertissement
  --- graphics - Utilitaires pour crer, afficher et diter les images

Les paquets dans la section  admin  vous permettent d'effectuer des tches
d'administration telles que l'installation de logiciels, la gestion des
utilisateurs, la configuration et la surveillance de votre systme, l'examen
du trafic du rseau ainsi que d'autres tches du mme genre.






le groupe ``admin'' contient un unique sous-groupe, l'archive Debian ``main''.
Dployer ce groupe rvle quelques paquets !


 [Tip]  Tip

        Pour aller plus vite, vous pouvez utiliser la touche [ pour dployer
        d'un seul coup tous les sous-groupes d'un groupe donn. Slectionner
        ``Paquets installs'' et appuyer sur [ fait immdiatement apparatre les
        paquets sur la capture suivante.


 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--\ Paquets installs
  --\ admin - Utilitaires d'administration (installation de logiciels, gestion d
    --\ main - L'archive principale de Debian
i     acpid                                               1.0.3-19   1.0.3-19
i     alien                                               8.44       8.44
i     anacron                                             2.3-9      2.3-9
i     apt-show-versions                                   0.07       0.07
i A   apt-utils                                           0.5.25     0.5.25
i     apt-watch                                           0.3.2-2    0.3.2-2
i     aptitude                                            0.2.15.2-1 0.2.15.2-1

La distribution Debian est constitue des paquets de la section  main .
Chaque paquet de  main  est un logiciel libre.

Pour plus d'informations sur ce que Debian considre comme tant un logiciel
libre, voir http://www.debian.org/social_contract#guidelines




En plus des touches de flches, vous pouvez naviguer  travers la liste de
paquets, page aprs page, en utilisant les touches Page prcdente et Page
suivante.


Rechercher des paquets par leur nom

Pour trouver rapidement un paquet dont vous connaissez le nom, appuyez sur /
pour ouvrir une bote de recherche :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
i     frozen-bubble                                        1.0.0-5    1.0.0-5
i A   frozen-bubble-data                                   1.0.0-5    1.0.0-5
i     geekcode                                             1.7.3-1    1.7.3-1
i     gfpoken                                              0.25-3     0.25-3
i     ggz-gnome-client                                     0.0.7-2    0.0.7-2
i     ggz-gtk-client                                       0.0.7-1    0.0.7-1
i     ggz-gtk-game-data                                    0.0.7-2    0.0.7-2
i +-------------------------------------------------------------------------+
i |Recherche de :                                                           |
i |froz                                                                     |
Po|                        [ Continuer ]                         [ Abandon ]|
Fr+-------------------------------------------------------------------------+
attempt to shoot bubbles into groups of the same color to cause them to pop.
It features 100 single-player levels, a two-player mode, music and striking
graphics.

This game is widely rumored to be responsible for delaying the Woody release.

URL: http://www.frozen-bubble.org/

Comme vous pouvez le voir sur la capture prcdente, une recherche de froz
trouve le paquet frozen-bubble. En utilisant le langage de recherche volu
d'aptitude, dcrit dans the section called ``Motifs de recherche'', il est
possible de trouver des paquets grce  de nombreux critres complexes.


 [Tip]  Tip

        Vous pouvez rpter la dernire recherche en appuyant sur n ou \ aprs
        avoir ferm la bote de recherche.


Parfois il est plus pratique de cacher tous les paquets  l'exception de ceux
qui correspondent  quelques critres particuliers. Pour ce faire, appuyer sur
l :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--- Paquets installs
--- Paquets non installs
--- Paquets obsoltes ou crs localement
--- Paquets virtuels
--- Tches


  +-------------------------------------------------------------------------+
  |Entrer la profondeur de l'arborescence des nouveaux paquets :            |
  |apti                                                                     |
  |                        [ Continuer ]                         [ Abandon ]|
Ce+-------------------------------------------------------------------------+








Cette bote de dialogue fonctionne exactement comme la bote de recherche, sauf
qu'au lieu de mettre en vidence le paquet suivant qui correspond  ce que vous
tapez dans la bote de dialogue, il cache tous les paquets qui ne correspondent
pas. Par exemple, taper apti dans cette bote de dialogue et appuyer sur Entre
va cacher tous les paquets sauf ceux dont le nom contient ``apti'' :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--\ Paquets installs
  --\ admin - Utilitaires d'administration (installation de logiciels, gestion d
    --\ main - L'archive principale de Debian
i     aptitude                                            0.2.15.2-1 0.2.15.2-1
i A   synaptic                                            0.51-1     0.51-1
  --\ x11 - Le systme X window et les logiciels s'y rapportant
    --\ main - L'archive principale de Debian
i     xfree86-driver-synaptics                            0.13.3-1   0.13.3-1
--- Paquets non installs
--- Paquets virtuels



Ces paquets ne sont pas installs sur votre ordinateur.









Grer les paquets

Maintenant que vous pouvez vous dplacer dans la liste des paquets, il est temps
de commencer  utiliser aptitude pour installer ou supprimer des paquets. Dans
cette section, vous allez apprendre  slectionner les paquets  installer,
supprimer et mettre  jour.


 [Tip]  Tip

        Vous pouvez uniquement changer la configuration globale de votre systme
        sous l'utilisateur root. Si vous voulez vous familiariser avec aptitude,
        vous pouvez, sans danger, le lancer en tant qu'utilisateur normal avec
        l'assurance de ne pouvoir endommager votre systme de quelque manire
        que ce soit. aptitude vous informera quand vous essaierez de faire
        quelque chose que seul le root peut faire, et si vous souhaitez
        continuer, il vous faudra donner le mot de passe de root.


Tous les changements sur un paquet se font en le mettant d'abord en surbrillance
dans la liste des paquets, puis en pressant la touche correspondant  l'action 
effectuer. Les touches d'actions de base [2] sont + pour installer ou mettre 
jour un paquet, - pour supprimer un paquet et = pour empcher un paquet d'tre
automatiquement mis  jour (on appelle cela geler un paquet). Ces actions ne
sont pas excuter immdiatement. aptitude va uniquement mettre  jour la liste
des paquets pour montrer les changements qui ont t demands.

Par exemple, dans la capture ci-dessous, le paquet kaffeine a t slectionn et
on a press +. Le paquet est maintenant mis en surbrillance en vert et la lettre
``i'' est apparue  gauche de son nom pour indiquer qu'il sera install. De
plus, une estimation de l'espace qu'il va utiliser est affiche.

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2
  --\ kde - L'environnement KDE
    --\ main - L'archive principale de Debian
p     bibletime-i18n                                       <aucun>     1.4.1-1
p     education-desktop-kde                                <aucun>     0.771
p     junior-kde                                           <aucun>     1.4
piA   kaffeine                                     +2843kB <aucun>     0.4.3-1
pi    kaffeine-mozilla                             +81.9kB <aucun>     0.4.3-1
p     karamba                                              <aucun>     0.17-5
p     kde-devel                                            <aucun>     4:3.1.2
p     kde-devel-extras                                     <aucun>     4:3.1.2
The K Desktop Environment (development files)
A metapackage containing dependencies for the core development suite of KDE
including kdesdk, qt3-designer, and all core KDE -dev packages.








 [Tip]  Tip

         tout moment vous pouvez utiliser Dfaire->Dfaire (Contrle+u) pour
        ``dfaire'' les changements fait sur un ou plusieurs paquets. C'est trs
        utile si une action  des consquences imprvues que vous souhaitez
        ``annuler''.


En plus des actions qui affectent des paquets individuels, une autre action
importante est disponible : taper U va tenter de mettre  jour tous les paquets
qui peuvent l'tre. Vous devriez utiliser cette commande rgulirement pour
maintenir votre systme  jour.

Parfois, changer l'tat d'un paquet va engendrer des relations de dpendances
non-satisfaites. Des paquets avec des dpendances non-satisfaites sont dit
casss. aptitude vous avertira quand cela arrive en expliquant pourquoi cela est
arriv. Par exemple voici ce qui arrive si vous tentez de supprimer libpopt0 :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2   #Cass : 3   Librera 2609ko d'espace disqu
idA   libpopt0                                    -446kB  1.7-4      1.7-4
i A   libstdc++5                                          1:3.3.4-3  1:3.3.4-3
i     libwrap0                                            7.6.dbs-4  7.6.dbs-4
i     locales                                             2.3.2.ds1- 2.3.2.ds1-
i     login                                               1:4.0.3-30 1:4.0.3-30
i     makedev                                             2.3.1-74   2.3.1-74
i     mawk                                                1.3.3-11   1.3.3-11
i     mbr                                                 1.1.5-2    1.1.5-2
i     modconf                                             0.2.45.1   0.2.45.1
i     modutils                                            2.4.26-1   2.4.26-1
lib for parsing cmdline parameters
libpopt0 sera enlev.
Ceci librera 446ko d'espace disque.


Les paquets suivants dpendent de libpopt0 et seront casss par sa
suppression :


  * logrotate  dpend de libpopt0 (>= 1.7)
  * whiptail  dpend de libpopt0 (>= 1.7)

Comme vous pouvez le voir, aptitude affiche deux indicateurs qui montrent que
quelque chose s'est mal pass : premirement, le nombre de paquets casss est
affich dans la zone bleue en haut ; deuximement, la seconde moiti de l'cran
a chang pour montrer les paquets casss qui sont lis au paquet actuellement en
surbrillance. Pour trouver rapidement les paquets casss  travers la liste des
paquets, vous pouvez effectuer une recherche sur ~b.


 [Tip]  Tip

        Quand toutes les informations ne peuvent tre affiches dans la moiti
        basse de l'cran, les touches a et z peuvent tre utilise pour faire
        dfiler cette zone.


Si vous n'arrivez pas  rsoudre la situation vous-mme, aptitude essaiera de la
corriger quand vous mettrez  excution votre slection. Nanmoins, il est
difficile de rsoudre automatiquement des problmes de dpendances, et vous
pourriez ne pas tre satisfait du rsultat, si bien qu'il est gnralement
prfrable de rsoudre ce genre de problmes avant de mettre  excution votre
slection.


Mettre  jour la liste de paquets et installer des paquets

Arriv ici, vous connaissez assez aptitude pour rellement faire des
modifications sur votre systme.

Vous devriez priodiquement mettre  jour la liste des paquets disponibles
depuis les serveurs Debian, afin d'avoir connaissance des nouveaux paquets et
des nouvelles versions des paquets. Pour ce faire, appuyez sur u.  tout moment
pendant le tlchargement, presser q vous permettra de l'abandonner.

Une fois que vous avez une liste de paquets rcente, vous pouvez choisir les
paquets  mettre  jour,  installer ou  supprimer comme cela est dcrit dans
la section prcdente. Pour passer en revue les actions que vous avez demandes,
appuyez sur g une seule fois. Si vous installez le paquet kaffeine-mozilla
(comme dans l'exemple prcdent), l'cran suivant apparat :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.2                Utilisera 11,5Mo d'espace disq 5109ko  tlch
--\ Paquets ajouts automatiquement pour satisfaire des dpendances
piA kaffeine                                       +2843kB <aucun>     0.4.3-1
--\ Paquets  installer
pi  kaffeine-mozilla                               +81.9kB <aucun>     0.4.3-1






Ces paquets ont t installs parce qu'ils sont ncessaires  un nouveau
paquet dont vous avez demand l'installation.

Si vous slectionnez un paquet, une explication de son tat courant apparatra
 cet endroit.




Comme vous pouvez le voir, aptitude a dcid d'installer automatiquement
kaffeine car kaffeine-mozilla le requiert.  ce moment, vous avez le choix entre
continuer l'installation en appuyant sur g ou l'abandonner en appuyant sur q.


Utiliser aptitude depuis la ligne de commande

En plus de son interface ``visuelle'' dcrite dans la section prcdente,
aptitude peut tre utilis pour grer les paquets directement depuis la ligne de
commande de la mme manire que vous utiliseriez apt-get. Cette section couvre
les actions en ligne de commande les plus courantes d'aptitude. Pour plus
d'informations, consultez la rfrence pour la ligne de commande d'aptitude.

En gnral, une invocation d'aptitude sur la ligne de commande ressemble 
ceci :

aptitude action [arguments...]

action indique  aptitude quelle action il doit faire et les arguments restants
sont utiliss de faon spcifique  chaque action. Typiquement, ils vont tre
constitus de noms de paquets et d'options courtes[3].

Les actions les plus importantes sont :



  aptitude update

      Cette commande met  jour la liste des paquets comme si vous tiez entr
      dans l'interface graphique et aviez appuy sur u.


  aptitude upgrade

      Cette commande met  jour autant de paquets que possible. S'il y a des
      problmes de dpendances, il ne met pas  jour les paquets (au lieu de les
      supprimer, par exemple).


  aptitude dist-upgrade

      Cette commande tente elle aussi de mettre  jour les paquets, mais elle
      est plus agressive au niveau de la rsolution des problmes de
      dpendances : elle installe et supprime les paquets jusqu' ce que toutes
      les dpendances soient satisfaites. De part la nature de cette commande,
      il est possible qu'elle fasse des choses indsirables et vous devriez tre
      prudent lorsque vous l'utilisez.


  aptitude [ install | remove | purge ] pqt1 [pqt2...]

      Ces commandes installent, suppriment ou purgent[4] le paquet spcifi.
      ``Installer'' un paquet qui est dj install mais qui peut tre mis 
      jour entranera sa mise  jour.


  aptitude search motif1 [motif2...]

      Cette commande recherche les paquets dont le nom contient un ou plusieurs
      des motifs donns, et en affiche le rsultat dans le terminal. Au del
      d'une simple chane de texte, chaque motif peut tre un motif de recherche
      comme dcrit dans the section called ``Motifs de recherche''. [5]


  aptitude show pqt1 [pqt2...]

      Afficher les informations sur chaque pqt sur le terminal.


Les commandes qui installent, mettent  jour et suppriment des paquets acceptent
toutes le paramtre ``-s'', qui signifie ``simuler''. Quand ``-s'' est pass sur
la ligne de commande, le programme excute les actions qu'il devrait normalement
effectuer sans rellement tlcharger ou installer/supprimer aucun fichier.

aptitude prsentera parfois une invite comme celle-ci :

Les NOUVEAUX paquets suivants vont tre automatiquement installs :
  space-orbit-common
Les NOUVEAUX paquets suivants vont tre installs :
  space-orbit space-orbit-common
0 paquets mis  jour, 2 nouvellement installs, 0  enlever et 0 non mis  jour.
Il est ncessaire de tlcharger 3200ko d'archives. Aprs dpaquetage, 8413ko
seront utiliss.

Voulez-vous continuer ? [O/n/?]

En plus des options ``Oui'' et ``Non'' qui sont videntes, un certain nombre de
commandes sont disponibles et peuvent tre utilises pour modifier les
informations affiches  l'invite ou pour spcifier des options supplmentaires.
Pas exemple, taper ``s'' affichera ou cachera l'information sur l'espace que
chaque paquet va utiliser :

Voulez-vous continuer ? [O/n/?] s

Les changements de taille seront affichs.

Les NOUVEAUX paquets suivants vont tre automatiquement installs :
  space-orbit-common <+8020kB>
Les NOUVEAUX paquets suivants vont tre installs :
  space-orbit <+393kB> space-orbit-common <+8020kB>
0 paquets mis  jour, 2 nouvellement installs, 0  enlever et 0 non mis  jour.
Il est ncessaire de tlcharger 3200ko d'archives. Aprs dpaquetage, 8413ko
seront utiliss.
Voulez-vous continuer ? [O/n/?]

De manire analogue, taper ``d'' affichera des informations sur les paquets
automatiquement installs ou supprims :

Les NOUVEAUX paquets suivants vont tre automatiquement installs :
  space-orbit-common (D: space-orbit)
Les NOUVEAUX paquets suivants vont tre installs :
  space-orbit space-orbit-common
0 paquets mis  jour, 2 nouvellement installs, 0  enlever et 0 non mis  jour.
Il est ncessaire de tlcharger 3200ko d'archives. Aprs dpaquetage, 8413ko
seront utiliss.

Cela indique que space-orbit-common est sur le point d'tre install parce que
space-orbit dpend de lui. Vous pouvez voir la liste complte des options
possibles en entrant ``?''  l'invite.

Pour une documentation complte des caractristiques de la ligne de commande
d'aptitude, consultez la Rfrence de la ligne de commande d'aptitude.



--------------------------------------------------------------------------------
[2] Vous pouvez aussi modifier l'tat des paquets en utilisant le menu Paquet.
Consultez the section called ``Le menu Paquet'' pour plus de dtails.

[3]Une ``option courte'' est une lettre prcde d'un tiret, par exemple, ``-
a'', ``-v'', etc.

[4]Purger un paquet supprime le paquet ainsi que tous ses fichiers de
configuration.

[5] En fait, c'est aussi vrai pour les commandes qui prennent des paquets en
argument, comme install ou show.


Chapter 2. Guide de rfrence d'aptitude

Table of Contents



  L'interface utilisateur d'aptitude


        Utiliser les menus

        Commandes du menu

        Travailler avec plusieurs vues

        Devenir administrateur ( root )


  Gestion des paquets


        Grer la liste des paquets

        Accder aux informations des paquets

        Modifier l'tat d'un paquet

        Tlcharger, installer et supprimer des paquets

        Grer les paquets automatiquement installs


  Motifs de recherche

  Personnalisation d'aptitude


        Personnaliser la liste des paquets

        Personnaliser les raccourcis clavier

        Personnaliser les couleurs

        Personnaliser la disposition de l'affichage

        Rfrence du fichier de configuration

        Thmes


  Jouer au dmineur


  Le Lapin Blanc mit ses lunettes.  O dois-je commencer votre Majest ?   
  demanda-t-il.

   Commence au commencement , rpondit gravement le Roi,  et continue
  jusqu' ce que tu arrives  la fin, alors arrte-toi. 

                                -- Lewis Carrol, Alice au pays des merveilles


aptitude est un programme imposant aux nombreuses possibilits, et il est
parfois difficile de se rappeler comment faire telle chose ou mme de se
rappeler si une chose est possible. En effet, l'auteur reoit de nombreuses
demandes d'ajout de fonctionnalits qui sont dj prsentes mais difficiles 
trouver.

Dans une tentative pour combattre cette opacit, ce guide de rfrence dcrit
toutes les fonctionnalits et les paramtres de configuration d'aptitude. Pour
un guide plus abordable sur les fonctionnalits les plus importantes d'aptitude,
consultez Chapter 1, Notions_pour_commencer.


 [Note]  Note

         Le comportement et l'apparence d'aptitude peuvent tre configurs de
         nombreuses faons. Ce manuel dcrit comment le programme fonctionne
         avec la configuration par dfaut. La description de la manire dont
         diffrentes configurations affectent son comportement est donne dans
         the section called ``Personnalisation d'aptitude''.



L'interface utilisateur d'aptitude

Cette section dcrit la partie de l'interface utilisateur d'aptitude qui ne
s'occupe pas de la gestion des paquets.


Utiliser les menus

La barre de menu en haut de l'cran liste les commandes les plus importantes
d'aptitude. Pour activer la barre de menu, appuyez sur F10, vous pouvez alors
vous y dplacer avec les touches de flches et slectionner une entre du menu
avec Entre.

Certaines entres du menu ont aussi des ``cls d'accs rapide'' : lettres ou
chiffres qui peuvent tre utiliss pour slectionner une entre alors que le
menu est actif. Ces cls d'accs rapide sont affiches avec une nuance de blanc
plus clair que le reste du menu.

En plus, certaines entres du menu ont des ``raccourcis clavier'' qui effectuent
la mme action que l'entre du menu mme lorsque le menu n'est pas actif. Ces
raccourcis sont indiqus  droite des entres du menu.

Dans le reste de ce manuel, les commandes du menu seront crites comme ceci :
Menu->Entre (cl). Cela indique que vous devez utiliser l'Entre du menu Menu
et que la cl est le raccourci pour cette commande.


Commandes du menu


Le menu Actions

Figure 2.1. Commandes disponibles dans le menu Actions

 ______________________________________________________________________________
|Commande                              |Description                            |
|______________________________________|_______________________________________|
|                                      |Si un aperu d'installation n'est pas  |
|Actions->Installer/enlever des paquets|visible, en affiche un. Sinon lance un |
|(g)                                   |processus d'installation comme dcrit  |
|                                      |dans the section called ``Tlcharger, |
|                                      |installer et supprimer des paquets''.  |
|______________________________________|_______________________________________|
|Actions->Mettre  jour les listes de  |Met  jour la liste des paquets.       |
|paquets (u)                           |                                       |
|______________________________________|_______________________________________|
|                                      |Marque tous les paquets susceptibles de|
|Actions->Marquer comme tant          |l'tre,  l'exception de ceux qui sont |
|susceptible de mise  jour (U)        |gels ou interdits de mise  jour,     |
|                                      |comme devant tre mis  jour.          |
|______________________________________|_______________________________________|
|Actions->Oublier les nouveaux paquets |Oublie quels paquets sont ``nouveaux'' |
|(f)                                   |(i.e. vide l'arborescence ``Nouveaux   |
|                                      |paquets'').                            |
|______________________________________|_______________________________________|
|                                      |Supprime toutes les archives de paquets|
|Actions->Nettoyer le cache des paquets|qui ont t tlcharges par aptitude  |
|                                      |[a].                                   |
|______________________________________|_______________________________________|
|                                      |Supprime toutes les archives de paquets|
|                                      |qui ont t tlcharges par aptitude  |
|                                      |[a] et qui ne sont plus disponibles    |
|                                      |dans les archives Debian. On peut      |
|Actions->Nettoyer les fichiers prims|supposer que ce sont des paquets       |
|                                      |obsoltes et qui peuvent tre supprims|
|                                      |pour librer de l'espace disque sans   |
|                                      |que cela ne ncessite de               |
|                                      |tlchargements inutiles par ailleurs. |
|______________________________________|_______________________________________|
|                                      |Lance le dmineur, comme cela est      |
|Actions->Jouer au dmineur            |dcrit dans the section called ``Jouer |
|                                      |au dmineur''.                         |
|______________________________________|_______________________________________|
|                                      |Continue  travailler en tant          |
|Actions->Devenir administrateur       |qu'utilisateur root. Voir the section  |
|                                      |called ``Devenir administrateur        |
|                                      |( root )''.                          |
|______________________________________|_______________________________________|
|Actions->Quitter (Q)                  |Quitte le programme et enregistre les  |
|                                      |modifications des tats des paquets.   |
|______________________________________|_______________________________________|
|[a] ou tout autre utilitaire apt.                                             |
|______________________________________________________________________________|


Le menu Dfaire

Figure 2.2. Commandes disponibles dans le menu Dfaire

 ______________________________________________________________________________
|Commande                     |Description                                     |
|_____________________________|________________________________________________|
|                             |Annule, un  un, les effets du dernier          |
|                             |changement effectu sur l'tat d'un paquet avec |
|Dfaire->Dfaire (Contrle+u)|la possibilit de remonter jusqu' la dernire  |
|                             |fois que le programe a t dmarr, que la liste|
|                             |des paquets  t mise  jour ou qu'un processus|
|                             |d'installation a t lanc.                     |
|_____________________________|________________________________________________|


Le menu Paquet

Figure 2.3. Commandes disponibles dans le menu Paquet

 ______________________________________________________________________________
|Commande                           |Description                               |
|___________________________________|__________________________________________|
|Paquet->Installer (+)              |Marque le paquet actuellement slectionn |
|                                   |pour installation.                        |
|___________________________________|__________________________________________|
|Paquet->Supprimer (-)              |Marque le paquet actuellement slectionn |
|                                   |pour suppression.                         |
|___________________________________|__________________________________________|
|Paquet->Purger (_)                 |Marque le paquet actuellement slectionn |
|                                   |pour purge.                               |
|___________________________________|__________________________________________|
|                                   |Annule toute installation, mise  jour ou |
|Paquet->Garder (:)                 |suppression prvue pour le paquet         |
|                                   |actuellement slectionn.                 |
|___________________________________|__________________________________________|
|Paquet->Geler (=)                  |Gle le paquet actuellement slectionn.  |
|___________________________________|__________________________________________|
|                                   |Marque le paquet actuellement slectionn |
|                                   |comme tant un paquet ``install          |
|                                   |automatiquement''. Pour plus              |
|Paquet->Marquer automatique (M)    |d'informations sur les paquets installs  |
|                                   |manuellement et automatiquement, consultez|
|                                   |the section called ``Grer les paquets    |
|                                   |automatiquement installs''.              |
|___________________________________|__________________________________________|
|                                   |Marque le paquet actuellement slectionn |
|                                   |comme tant un paquet ``install          |
|                                   |manuellement''. Pour plus d'informations  |
|Paquet->Marquer manuel (m)         |sur les paquets installs manuellement et |
|                                   |automatiquement, consultez the section    |
|                                   |called ``Grer les paquets automatiquement|
|                                   |installs''.                              |
|___________________________________|__________________________________________|
|                                   |Si un paquet qui peut tre mis  jour est |
|                                   |slectionn, cela interdit sa mise  jour |
|Paquet->Interdire version (F)      |vers la version actuellement disponible   |
|                                   |uniquement. Si une version du paquet est  |
|                                   |slectionne, cela interdit au paquet     |
|                                   |d'tre mis  jour vers cette version.     |
|___________________________________|__________________________________________|
|                                   |Affiche un cran contenant des            |
|                                   |informations sur le paquet actuellement   |
|Paquet->Information (entre)       |slectionn, comme les paquets dont il    |
|                                   |dpend, les paquets qui en dpendent, et  |
|                                   |ses versions disponibles.                 |
|___________________________________|__________________________________________|
|                                   |Affiche la liste des modifications du     |
|                                   |paquet Debian actuellement slectionn.   |
|Paquet->Liste des modifications (C)|Pour voir les modifications d'une version |
|                                   |particulire, slectionnez cette version  |
|                                   |avant d'excuter cette commande.          |
|___________________________________|__________________________________________|


Le menu Rechercher

Figure 2.4. Commandes disponibles dans le menu Rechercher

 ______________________________________________________________________________
|Commande                           |Description                               |
|___________________________________|__________________________________________|
|                                   |Recherche le premier paquet qui correspond|
|Rechercher->Rechercher (/)         |au motif de recherche (voir the section   |
|                                   |called ``Motifs de recherche'').          |
|___________________________________|__________________________________________|
|Rechercher->Rechercher encore (\)  |Rpte la dernire recherche.             |
|___________________________________|__________________________________________|
|                                   |Filtre la liste de paquets en omettant    |
|Rechercher->Affichage restreint (l)|tous les paquets qui ne correspondent pas |
|                                   |au motif de recherche (voir the section   |
|                                   |called ``Motifs de recherche'').          |
|___________________________________|__________________________________________|
|Rechercher->Affichage complet (l)  |Retire le filtrage de la liste de paquets |
|                                   |(tous les paquets sont affichs).         |
|___________________________________|__________________________________________|
|Rechercher->Rechercher casss (b)  |Recherche le paquet cass suivant. C'est  |
|                                   |quivalent  rechercher ~b.               |
|___________________________________|__________________________________________|


Le menu Options

Figure 2.5. Commandes disponibles dans le menu Options

 _________________________________________________________________________
|Commande                        |Description                             |
|________________________________|________________________________________|
|                                |Appelle une bote de dialogue dans      |
|Options->Options de l'Interface |laquelle vous pouvez configurer les     |
|Utilisateur                     |options relatives  l'interface (manire|
|                                |d'afficher les messages, organisation   |
|                                |des paquets, etc.).                     |
|________________________________|________________________________________|
|                                |Appelle une bote de dialogue dans      |
|                                |laquelle vous pouvez configurer les     |
|Options->Gestion des Dpendances|options relatives au traitement des     |
|                                |dpendances : par exemple, s'il faut    |
|                                |installer automatiquement les paquets   |
|                                |recommands par d'autres paquets.       |
|________________________________|________________________________________|
|                                |Appelle une bote de dialogue dans      |
|                                |laquelle vous pouvez configurer les     |
|                                |options qui ne tombent pas dans les deux|
|Options->Divers                 |catgories prcdentes : par exemple,   |
|                                |s'il faut marquer automatiquement les   |
|                                |paquets pour mise  jour au dmarrage   |
|                                |d'aptitude.                             |
|________________________________|________________________________________|
|Options->Revenir aux valeurs    |Revient aux options de configuration par|
|prcdentes des options         |dfaut.                                 |
|________________________________|________________________________________|


Le menu Vues


 [Note]  Note

         Pour un aperu de la manire de fonctionner des vues, voir the section
         called ``Travailler avec plusieurs vues''.


Figure 2.6. Commandes disponibles dans le menu Vues

 ______________________________________________________________________________
|Commande                         |Description                                 |
|_________________________________|____________________________________________|
|Vues->Suivant (F6)               |Aller  la vue active suivante.             |
|_________________________________|____________________________________________|
|Vues->Prcdent (F7)             |Aller  la prcdente vue active.           |
|_________________________________|____________________________________________|
|Vues->Fermer (q)                 |Fermer la vue actuelle.                     |
|_________________________________|____________________________________________|
|Vues->Nouvelle Vue des Paquets   |Crer une nouvelle vue de la liste des      |
|                                 |paquets.                                    |
|_________________________________|____________________________________________|
|Vues->Nouvelle vue par Catgories|Voir la liste des paquets, organise par    |
|                                 |catgorie.                                  |
|_________________________________|____________________________________________|
|                                 |D'autres entres du menu apparaissent. Il   |
|Entres supplmentaires          |s'agit des vues actuellement actives. Pour  |
|                                 |atteindre directement une vue, slectionnez-|
|                                 |la dans ce menu.                            |
|_________________________________|____________________________________________|


Le menu Aide

Figure 2.7. Commandes disponibles dans le menu Aide

 ____________________________________________________________________________
|Commande                     |Description                                   |
|_____________________________|______________________________________________|
|Aide-> propos               |Affiche des informations de copyright.        |
|_____________________________|______________________________________________|
|Aide->Aide (?)               |Affiche l'aide en ligne.                      |
|_____________________________|______________________________________________|
|Aide->Manuel Utilisateur     |Affiche le manuel de l'utilisateur (ce        |
|                             |document).                                    |
|_____________________________|______________________________________________|
|Aide->FAQ                    |Affiche la FAQ d'aptitude.                    |
|_____________________________|______________________________________________|
|Aide->Liste des modifications|Affiche la liste des principales modifications|
|                             |apportes  aptitude.                         |
|_____________________________|______________________________________________|
|                             |Affiche les termes de la licence sous laquelle|
|Aide->Licence                |vous pouvez copier, modifier et distribuer    |
|                             |aptitude.                                     |
|_____________________________|______________________________________________|


Travailler avec plusieurs vues

aptitude vous permet de travailler avec plusieurs ``vues''  la fois. Une
``vue'' (parfois appele ``cran'') est simplement quelque chose qui apparat
dans une zone de l'cran en dessous de la barre de menu. La vue la plus courante
est la liste des paquets, la vue des tlchargements est aussi assez courante.

Quand plusieurs vues sont ouvertes en mme temps, vous pouvez fermer la vue
courante avec Vues->Fermer (q). Pour atteindre les vues prcdentes et
suivantes, utilisez Vues->Suivant (F6) et Vues->Prcdent (F7). Vous pouvez
aussi trouver une liste de toutes les vues actives dans le menu Vues.

Certaines commandes (par exemple, voir les informations d'un paquet) vont crer
automatiquement de nouvelles vues. Vous pouvez aussi demander la cration d'une
nouvelle vue avec Vues->Nouvelle Vue des Paquets ou Vues->Nouvelle vue par
Catgories.


Devenir administrateur ( root )

Certaines actions, telles que la mise  jour de la liste des paquets, ne peuvent
tre ralises qu'en tant que root. Si vous n'tes pas root alors que vous
essayez de mettre  jour la liste des paquets, aptitude va vous demander de le
devenir.

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.6
--- Paquets installs
--- Paquets non installs
--- Paquets obsoltes ou crs localement
--- Paquets virtuels
--- Tches

  +--------------------------------------------------------------------------+
  |La mise  jour des listes de paquets exige des privilges d'administration|
  |que vous n'avez pas pour le moment. Voulez-vous utiliser le compte        |
  |administrateur ?                                                          |
  |                                                                          |
Ce|   [ Devenir administrateur ]        [ Ne pas devenir administrateur ]    |
  +--------------------------------------------------------------------------+








Si vous slectionnez ``Devenir administrateur'', aptitude va vous demander de
saisir le mot de passe de root. Une fois que vous l'aurez correctement saisi,
aptitude effectuera les actions qui ont ncessit les droits d'administration.
Vous resterez root aprs la fin de l'action.

Vous pouvez passer sous le compte root  tout moment en utilisant la commande
Actions->Devenir administrateur. Tous les changements que vous avez apports 
l'tat des paquets sont prservs (mais ne seront pas sauvegards avant que vous
ne quittiez aptitude).


Gestion des paquets

Cette section dcrit comment manipuler la liste des paquets, comment installer
de nouveaux paquets sur votre systme et comment supprimer de vieux paquets.


Grer la liste des paquets

Pour garder la liste des paquets  jour, il est recommand de la mettre  jour
rgulirement. Vous pouvez le faire grce  la commande Actions->Mettre  jour
les listes de paquets (u).


Accder aux informations des paquets

Les informations sur les paquets sont prsentes  plusieurs endroits dans
aptitude : la liste des paquets donne un aperu rapide de l'tat de chaque
paquet, et des vues supplmentaires fournissant des informations dtailles sur
chaque paquet sont aussi disponibles.


La liste des paquets

La liste des paquets montre un rsum succint de l'tat d'un paquet. Par
exemple, le paquet autobook pourrait avoir le rsum suivant :

iuA  autobook                                       +139kB  1.4.1-1    1.4.2-1

Les trois caractres sur la gauche indiquent que le paquet est install, qu'il
est sur le point d'tre mis  jour et qu'il a t install automatiquement. 
droite, on peut lire la version actuellement installe et la version la plus
rcente disponible, ainsi qu'une indication de l'espace supplmentaire que la
mise  jour va utiliser.


 [Tip]  Tip

        Vous pouvez personnaliser la manire d'afficher ce rsum. Consultez the
        section called ``Personnaliser la manire d'afficher les paquets'' pour
        plus de dtails.


Les trois indicateurs d'tat sur la gauche de l'cran donnent les informations
de base sur l'tat d'un paquet. Le premier caractre indique l'tat courant du
paquet, le second indique l'action qui sera entreprise sur le paquet et le
troisime indique si le paquet a t automatiquement install ou pas (voir the
section called ``Grer les paquets automatiquement installs'').

Les valeurs possibles pour l'indicateur de ``l'tat courant'' sont donnes dans
Figure 2.8, ``Valeurs de l'indicateur de ``l'tat courant'''' et les valeurs
possibles de l'indicateur ``d'action'' sont donnes dans Figure 2.9, ``Valeur de
l'indicateur ``d'action''''.

Figure 2.8. Valeurs de l'indicateur de ``l'tat courant''


i - le paquet est install et toutes ses dpendances sont satisfaites.

c - le paquet a t supprim mais ses fichiers de configuration sont toujours
    prsents.

p - le paquet et tous ses fichiers de configuration ont t supprims ou le
    paquet n'a jamais t install.

v - le paquet est virtuel.

B - le paquet a des dpendances casses.

u - le paquet a t depaquet mais pas configur.

C -  moiti configur : la configuration du paquet  t interrompue.

H -  moiti install : l'installation du paquet  t interrompue.


Figure 2.9. Valeur de l'indicateur ``d'action''


i - le paquet va tre install.

u - le paquet va tre mis  jour.

d - le paquet va tre supprim : il sera supprim mais ses fichiers de
    configuration resteront sur le systme.

p - le paquet va tre purg : lui et ses fichiers de configuration seront
    supprims.

h - le paquet est gel : il sera gard dans sa version actuelle, mme si une
    version plus rcente est disponible, jusqu' que le gel soit retir.

F - toute mise  jour du paquet est interdite.

r - le paquet va tre rinstall.

    le paquet est ``cass'' : certaines de ses dpendances ne sont pas
B - satisfaites. aptitude ne vous permettra pas d'installer, supprimer ou mettre
     jour quoique ce soit tant que des paquets sont casss.


aptitude va, de plus, utiliser des couleurs pour indiquer l'tat d'un paquet si
le terminal l'accepte. La distinction entre les tats se fait principalement
grce  la couleur de l'arrire plan :



  Noir
      Le paquet ne peut pas tre mise  jour (ou il ne sera pas install) et il
      n'a pas de problme de dpendance. Si le paquet est dj install, son nom
      est en surbrillance.


  Vert
      Le paquet est sur le point d'tre install.


  Bleu
      Le paquet est actuellement install et il va tre mis  jour.


  Magenta
      Le paquet est actuellement install, mais il va tre supprim.


  Blanc
      Le paquet est actuellement install et il est ``gel'' dans sa version
      courante : les mises  jours automatiques l'ignoreront.


  Rouge
      Le paquet est cass : certaines de ces dpendances ne sont pas
      satisfaites.


Enfin, la moiti infrieure de l'cran affiche la description longue. aptitude
tentera de dtecter si le paquet est impliqu dans des problmes de dpendances.
Si c'est le cas, des informations concernant ces problmes de dpendances y
seront affiches. Pour passer des informations de dpendances  la description
du paquet, et inversement, appuyez sur i.


Information dtaille d'un paquet

Appuyer sur Entre pendant qu'un paquet est en surbrillance affichera l'cran
d'information du paquet :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
aptitude 0.2.15.6
i A --\ apt                                                0.5.26     0.5.26
  Description : Advanced front-end for dpkg
    This is Debian's next generation front-end for the dpkg package manager. It
    provides the apt-get utility and APT dselect method that provides a simpler,
    safer way to install and upgrade packages.

    APT features complete installation ordering, multiple source capability and
    several other unique features, see the Users Guide in apt-doc.
  Essentiel : oui
  Priorit : important
  Section : base
  Responsable : APT Development Team <deity@lists.debian.org>
  Taille compresse : 1094k
  Taille dcompresse : 3420k
  Paquet source : apt
  --\ Dpend
    --- libc6 (>= 2.3.2.ds1-4)
    --- libgcc1 (>= 1:3.4.1-3)
    --- libstdc++5 (>= 1:3.3.4-1)
  --\ Suggre
    --- aptitude | synaptic | gnome-apt | wajig
    --- dpkg-dev
    --\ apt-doc (NON SATISFAITE)
p     0.5.27
p     0.5.26
  --\ Remplace
    --- libapt-pkg-doc (< 0.3.7)
    --- libapt-pkg-dev (< 0.3.7)
  --- Noms de paquet fournis par apt
  --- Paquets dpendants de apt
  --\ Versions
p A 0.5.27
i A 0.5.26

On peut naviguer dans cet cran de manire similaire  la liste des paquets :
par exemple, dans la capture prcdente, l'arbre des dpendances sur apt-doc
fait apparatre les versions disponibles d'apt-doc qui peuvent satisfaire la
dpendance. Ces versions peuvent tre manipules de la mme manire que les
paquets : par exemple, pour installer la version 0.5.25 de apt-doc, il vous
suffit de la mettre en surbrillance et d'appuyer sur +.


 [Tip]  Tip

        Pour satisfaire rapidement une dpendance, slectionnez-la et appuyez
        sur +. aptitude tentera automatiquement de la satisfaire.


En plus des dpendances d'un paquet, vous pouvez voir le nom des paquets qu'ils
fournit, les paquets qui dpendent de lui, ainsi que les versions disponibles du
paquet (en incluant tous les paquets qui le fournissent).

Comme d'habitude, vous pouvez quitter cet cran et retourner  la vue principale
en appyant sur q. Par commodit, quelques autres crans d'information (qui
n'affichent que quelques informations courantes et cachent le reste) sont
disponibles : appuyer sur v pour voir les versions d'un paquet, d pour voir les
dpendances d'un paquet et r pour voir les ``dpendances inverses'' d'un paquet
(i.e. les paquets qui dpendent de ce paquet).


Modifier l'tat d'un paquet

Les commandes suivantes sont disponibles pour modifier l'tat des paquets. Ces
commandes prennent effet au prochain lancement d'un processus d'installation.
Jusqu' ce que vous le fassiez, toutes ces commandes peuvent tre annules en
utilisant Dfaire->Dfaire (Contrle+u).

Pour appliquer une commande  un paquet, il suffit de le slectionner dans une
liste de paquets et d'excuter la commande. Ces commandes peuvent aussi tre
appliques  un groupe de paquets en slectionnant l'en-tte du groupe (par
exemple : ``Paquets pouvant tre mis  jour'') et en excutant la commande.

 _____________________________________________________________________________
|Commande                            |Description                             |
|____________________________________|________________________________________|
|                                    |Marque le paquet courant pour           |
|                                    |installation.                           |
|                                    |                                        |
|Installation : Paquet->Installer (+)|Si le paquet n'est pas install, il le  |
|                                    |sera. S'il est dj install, il sera   |
|                                    |mis  jour, si possible, et les         |
|                                    |ventuels marquages empchant sa mise  |
|                                    |jour (p. ex. Gel) seront annuls.       |
|____________________________________|________________________________________|
|                                    |Marque le paquet courant pour           |
|                                    |suppression.                            |
|Suppresion : Paquet->Supprimer (-)  |                                        |
|                                    |Si le paquet est install, il sera      |
|                                    |supprim.                               |
|____________________________________|________________________________________|
|                                    |Marque le paquet courant pour purge.    |
|                                    |                                        |
|                                    |Si le paquet est install, il sera      |
|Purge : Paquet->Purger (_)          |supprim. De plus, s'il est dj        |
|                                    |supprim, tout fichier restant (comme   |
|                                    |les fichiers de configuration) li  ce |
|                                    |paquet sera supprim du systme.        |
|____________________________________|________________________________________|
|                                    |Marque le paquet courant pour qu'il soit|
|                                    |gard dans sa version actuelle.         |
|Garde : Paquet->Garder (:)          |                                        |
|                                    |Toute action qui tait prvue sur le    |
|                                    |paquet (installation, suppression ou mis|
|                                    | jour) est annule.                    |
|____________________________________|________________________________________|
|                                    |Place un gel persistant sur le paquet.  |
|                                    |                                        |
|                                    |Comme avec Garde, toute action prvue   |
|                                    |sur le paquet est annule. De plus, le  |
|Gel : Paquet->Geler (=)             |paquet ne sera pas mis automatiquement |
|                                    |jour[a] jusqu' ce que le gel soit      |
|                                    |retir. Vous pouvez retirer le gel en   |
|                                    |excutant la commande Installation sur  |
|                                    |le paquet.                              |
|____________________________________|________________________________________|
|                                    |Le paquet ne sera pas automatiquement   |
|                                    |mis  jour[a] vers la version vers      |
|                                    |laquelle il peut actuellement l'tre.   |
|                                    |S'il est sur le point d'tre install,  |
|                                    |sa mise  jour sera annule.            |
|                                    |                                        |
|                                    |Si vous lancez cette commande sur une   |
|                                    |version particulire d'un paquet, le    |
|                                    |paquet ne sera pas mis  jour vers la   |
|Paquet->Interdire version (F)       |version slectionne. Remarquez qu'on ne|
|                                    |peut interdire qu'une seule version  la|
|                                    |fois.                                   |
|                                    |                                        |
|                                    |Cette fonction est principalement       |
|                                    |fournie par commodit pour les          |
|                                    |utilisateurs de la distribution         |
|                                    |``unstable'', afin qu'ils puissent se   |
|                                    |prmunir de paquets aux versions connues|
|                                    |comme tant dfectueuses.               |
|____________________________________|________________________________________|
|                                    |Rinstalle le paquet.                   |
|                                    |                                        |
|                                    |Remarquez que la marque de              |
|                                    |rinstallation ne sera pas sauvegarde  |
|                                    |quand vous quitterez aptitude ou        |
|Rinstaller : appuyer sur L         |lancerez un processus d'installation    |
|                                    |pour des raisons techniques.            |
|                                    |(Brivement, les couches logicielles    |
|                                    |sous-jacentes (dpkg et apt) ne          |
|                                    |fournissent aucun moyen de savoir si une|
|                                    |rinstallation a russi ou non).        |
|____________________________________|________________________________________|
|                                    |Indique si le paquet doit tre trait   |
|                                    |comme ayant t automatiquement         |
|                                    |install. Les paquets automatiquement   |
|Paquet->Marquer automatique (M),    |installs sont supprims quand plus     |
|Paquet->Marquer manuel (m)          |aucun paquet ne les requiert. Pour plus |
|                                    |d'informations, consultez the section   |
|                                    |called ``Grer les paquets              |
|                                    |automatiquement installs''.            |
|____________________________________|________________________________________|
|[a] Plus prcisment, il ne sera pas affect par la commande Actions->Marquer|
|comme tant susceptible de mise  jour (U) ou par les actions en ligne de    |
|commande dist-upgrade et upgrade.                                            |
|_____________________________________________________________________________|

En plus de ces commandes qui affecte le paquet slectionn, il y a deux
commandes qui affectent un grand nombre de paquets d'un seul coup quelque soit
ce qui est slectionn. Actions->Oublier les nouveaux paquets (f) enlve l'tat
``nouveau'' de tous les paquets de la liste de paquets et Actions->Marquer comme
tant susceptible de mise  jour (U) marque tous les paquets qui peuvent l'tre
pour mise  jour,  l'exception des paquets qui sont gels ou qui seraient mis 
jour vers une version interdite.


 [Note]  Note

         Tout changement de l'tat des paquets est enregistr quand vous quittez
         aptitude, mettez  jour la liste des paquets ou lancez un processus
         d'installation. Si vous ne voulez pas enregistrer vos changements, vous
         pouvez toujours abandonner aptitude en pressant Ctrl-C.



Tlcharger, installer et supprimer des paquets

Changer l'tat des paquets comme dcrit dans la section prcdente n'affecte pas
rellement ce qui est install sur votre systme. De cette manire vous pouvez
ajuster l'tat des paquets sans affecter votre systme jusqu' ce que vous soyez
satisfait. Une fois que vous l'tes, vous pouvez les ``appliquer'' pour vraiment
installer et supprimer les paquets.[6]

Pour appliquer vos changements, utilisez la commande Actions->Installer/enlever
des paquets (g). Slectionner cette commande va afficher un aperu dcrivant les
changements qui seront effectus. Cet cran n'est qu'une liste de paquets et
vous pouvez manipuler les paquets (par exemple, annuler des suppressions non-
dsires) de la mme manire que vous le feriez dans la liste principale.

Quand vous tes prt, utilisez Vues->Fermer (q) pour annuler l'installation ou
Actions->Installer/enlever des paquets (g) pour la lancer. aptitude tlchargera
tous les fichiers qui le ncessite, puis vous demandera s'il faut continuer le
processus. Si vous validez par ``Continuer'', les installations et suppressions
vont dbuter.

Les paquets qui sont tlchargs par aptitude sont placs dans un rpertoire de
cache (habituellement /var/cache/apt/archives). Normalement, ils y sont laisss
ad infinitum. Pour supprimer tous les fichiers de ce rpertoires, utilisez
Actions->Nettoyer le cache des paquets, pour ne supprimer que les fichiers qui
ne peuvent plus tre tlchargs (i.e. les paquets obsoltes), utilisez Actions-
>Nettoyer les fichiers prims.


Grer les paquets automatiquement installs

Pour installer un paquet, il est souvent ncessaire d'en installer plusieurs
autres (pour satisfaire ses dpendances). Par exemple, si vous voulez installer
le paquet clanbomber, vous devez aussi installer le paquet libclanlib2. Lorsque
vous supprimez clanbomber, vous n'avez probablement plus besoin du paquet
libclanlib2. aptitude tentera de le dtecter et de supprimer automatiquement le
paquet libclanlib2.

Il fonctionne comme cela : quand vous installez un paquet, aptitude va
automatiquement installer tout autre paquet dont il dpend. Ces paquets sont
marqus comme ayant t ``automatiquement installs''. aptitude va les
surveiller et les supprimer quand plus aucun paquet manuellement install n'en
dpendra. [7]. Ils apparatront dans l'aperu comme des ``paquets qui vont tre
supprims parce qu'ils ne sont plus utiliss''.

Comme pour tout procd automatique, les choses peuvent potentiellement mal
tourner. Par exemple, mme si un paquet a t install automatiquement pour
commencer, il peut s'avrer utile par lui-mme. Vous pouvez retirer la marque
``automatique''  tout moment en appuyant sur m et, si le paquet est dj marqu
 supprimer, vous pouvez annuler la suppression et retirer la marque
``automatique'' avec Paquet->Installer (+).


Motifs de recherche

Quand vous recherchez un paquet ou restreignez l'affichage dans aptitude, la
chane que vous entrez est appele ``motif de recherche''. Bien que
l'utilisation de base des motifs de recherche soit de chercher le nom exact de
paquets, aptitude permet de crer des recherches bien plus labores.

Un motif de recherche consiste en une ou plusieurs conditions (parfois appeles
``mots''). Un paquet correspond  un motif s'il correspond  tous ses mots. Les
mots commmencent gnralement par le caractre tilde (``~'') suivi par un
caractre indiquant le type de mot, puis par tout texte supplmentaire
ncessaire au mot.

La plupart des recherches textuelles (de noms de paquets, descriptions, etc.)
sont ralises en utilisant des expressions rationnelles insensibles  la casse.
Cela signifie que vous devez protger par un backslash les caractres spciaux
des expressions rationnelles [8] dans vos recherches. Par exemple, pour
rechercher ``g++'', vous devrez utiliser le motif ``g\+\+''.

Les types de mots suivants sont disponibles :



  nom
      Est en correspondance avec les paquets dont le nom correspond 
      l'expression rationnelle nom. C'est le mode de recherche par ``dfaut'',
      utilis pour les motifs qui ne commencent pas par ~.


       [Note]  Note

               Pour correspondre avec les paquets dont le nom contient plusieurs
               sous-chanes diffrentes, utiliser le motif (dcrit ci-dessous)
               ~n ; par exemple, ``~napti~ntude''.



  !mot
      Est en correspondance avec les paquets qui ne correspondent pas avec le
      mot mot. Par exemple, ``!~b'' slectionne les paquets qui ne sont pas
      ``casss''.


       [Note]  Note

               Pour inclure un ``!'' dans une expression rationnelle, il doit
               tre ``dspcialis'' pour viter qu'aptitude ne considre qu'il
               effectue la ngation d'un mot. Pour ce faire, crivez : ``~!''.



  mot1 | mot2
      Correspond aux paquets qui correspondent soit  mot1, soit  mot2.


       [Note]  Note

               Pour inclure un ``|'' dans une expression rationnelle, il doit
               tre ``dspcialis'' pour viter qu'aptitude ne fasse un OU
               logique sur les mots. pour ce faire, crivez : ``~|''.



  (mot)
      Correspond avec mot. C'est trs utile pour grouper explicitement des
      expressions complexes. Par exemple, ``~D(perl|python)'' entre en
      correspondance avec tout paquet qui dpend d'un paquet dont le nom
      contient soit perl, soit python.


  ~Aarchive
      Correspond avec les paquets qui sont disponibles depuis une archive qui
      correspond  l'expression rationnelle archive. Par exemple, ``~Atesting''
      correspond avec tous les paquets disponibles dans l'archive testing.


  ~aaction
      Correspond avec les paquets sur lesquels l'action donne va tre
      effectue. action peut tre ``install'', ``upgrade'', ``remove'',
      ``purge'' ou ``hold''.


  ~Btype
      Correspond avec les paquets qui ont des dpendances non-satisfaites
      (``casses'') du type donn. Le type peut tre ``depends'',
      ``predepends'', ``recommends'', ``suggests'', ``conflicts'' ou
      ``replaces''.


  ~b
      Correspond aux paquets qui sont ``casss'' : ils ont une dpendance, une
      pr-dpendance ou un conflit non-satisfait.


  ~Cmot
      Correspond aux paquets qui entrent en conflit avec un paquet correspondant
      au mot donn. Par exemple, ``~C~mdburrows@debian.org'' correspond  tous
      les paquets qui entre en conflit avec un paquet que je maintient.


  ~c
      Correspond aux paquets qui ont t supprims mais dont les fichiers de
      configuration restent sur le systme (i.e. ils ont t supprims, mais pas
      purgs).


  ~D[type:]mot
      type peut tre soit ``provides'', soit un des champs de dpendances donns
      dans la documentation de ~B. Si type n'est pas prsent, il prend sa valeur
      par dfaut : depends.

      Si type est ``provides'', correspond aux paquets qui fournissent un paquet
      correspondant  mot (quivalent  ~P). Sinon, correspond aux paquets qui
      dclarent une dpendance du type type sur un paquet qui correspond au mot.


  ~ddescription
      Correspond aux paquets dont la description correspond  l'expression
      rationnelle description.


  ~E
      Correspond aux paquets Essentiels.


  ~F
      Ce mot ne correspond avec aucun paquet (``F'' signifie ``faux''). [9]


  ~g
      Correspond aux paquets qui ne sont pas installs, ou qui ont t installs
      automatiquement mais desquels aucun paquet install ne dpend.


  ~i
      Correspond aux paquets qui sont actuellement installs.


  ~M
      Correspond aux paquets qui ont t automatiquement installs.


  ~mresponsable
      Correspond aux paquets dont le champ Responsable (du paquet Debian)
      correspond  l'expression rationnelle responsable. Par exemple,
      ``~mjoeyh'' va rechercher tous les paquets maintenus par Joey Hess.


  ~N
      Correspond aux paquets qui sont ``nouveaux''.


  ~nnom
      Correspond aux paquets dont le nom correspond  l'expression rationnelle
      nom. Par exemple, la plupart des paquets qui correspondent  ``~n^lib''
      sont des bibliothques ( libraries ) sous un forme quelconque.


  ~Oorigine
      Correspond aux paquets dont l'origine correspond  l'expression
      rationnelle origine. Par exemple, ``!~Odebian'' va rechercher tous les
      paquets non-officiels sur votre systme (paquets qui ne proviennent pas de
      l'archive Debian).


  ~Pmot
      Correspond aux paquets qui fournissent un paquet qui correspond  mot. Par
      exemple, ``~Pmail-transport-agent'' correspondra  tous les paquets qui
      fournissent ``mail-transport-agent''.


  ~ppriorit
      Correspond aux paquets dont la priorit est priorit. Priorit doit tre
      extra, important, optional, required ou standard. Par exemple,
      ``~prequired'' correspond aux paquets dont la priorit est ``required''.


  ~R[type:]mot
      type peut tre soit ``provides'', soit un des types de dpendance
      prsents dans la documentation de ~B. Si type n'est pas prsent, il prend
      sa valeur par dfaut : depends.

      Si type est ``provides'', correspond aux paquets dont le nom est fournit
      par un paquet correspondant  mot. Sinon, correspond aux paquets sur
      lequels un paquet correspondant  mot dclare une dpendance du type type.


  ~ssection
      Correspond aux paquets dont la section correspond  l'expression
      rationnelle section.


  ~T
      Ce mot correspond  n'importe quel paquet. Par exemple, ``~i~P~T''
      correspond aux paquets installs qui sont fournis par un paquet
      quelconque.


  ~U
      Ce mot correspond  tout paquet install qui peut tre mis  jour.


  ~Vversion
      Correspond  tout paquet dont la version correspond  l'expression
      rationnelle version. Par exemple, ``~Vdebian'' correspond  tous les
      paquets dont la version contient ``debian''.


       [Note]  Note

               Si plusieurs versions d'un paquet sont disponibles, la version
               prise en compte dpend du contexte. Nanmoins, c'est gnralement
               soit la version actuelle, soit la version vers laquelle on peut
               mettre  jour.



  ~v
      Correspond  tout paquet qui est uniquement virtuel : c'est--dire, son
      nom est fournit ou mentionn par un paquet comme dpendance, mais aucun
      paquet de ce nom n'existe. Par exemple, ``~v!~P~T'' correspond aux paquets
      qui sont virtuels et qui ne sont fournis par aucun paquet, i.e., les
      paquets sur lequels il y a une dpendance mais qui n'existe pas.



Personnalisation d'aptitude


Personnaliser la liste des paquets

La liste de paquets peut tre normment personnalise : la manire d'afficher
les paquets, de les ranger, de les trier et mme l'organisation de l'affichage
sont toutes modifiables.


Personnaliser la manire d'afficher les paquets

Cette section dcrit la manire de configurer le contenu et le formatage de la
liste des paquets, de la ligne d'tat, et de la ligne d'en-tte.

Le format de chacune de ces zones est dfini par une ``chane de format''. Une
chane de format est une chane de texte contenant des commandes de format
dbutant par % comme %p, %S, etc. L'affichage correspondant est cr en
remplaant les commandes dbutant par % en fonction de leur signification
(donne ci-dessous).

Une commande de format (commanant par %) peut soit avoir une taille fixe et
dans ce cas elle est toujours remplace par la mme quantit de texte (avec
l'ajout d'espaces pour le complter si ncessaire), soit elle est ``tirable''
ce qui signifie qu'elle prend tout l'espace laiss libre par les colonnes de
texte  taille fixe. S'il y a plusieurs colonnes tirables, l'espace
supplmentaire est divis quitablement entre les colonnes.

Toutes les commandes de format possdent une taille fixe et/ou tirable par
dfaut. La taille d'une commande de format peut tre modifie en insrant la
valeur de la taille voulue entre le signe pourcentage (%) et le caractre
identifiant le format. Par exemple, %20V produit une colonne version installable
des paquets d'une largeur de 20 caractres.

Si vous souhaitez qu'une commande de format soit tirable, mme si elle possde
normalement une largeur fixe, placez un signe dise (``#'') immdiatement aprs
elle. Par exemple, pour afficher la version installable d'un paquet sans vous
soucier de sa longueur, utilisez la commande de format %V#. Vous pouvez aussi
mettre un # aprs autre chose qu'une commande de format ; aptitude va alors
``tirer'' le texte qui prcde ce texte en insrant des espaces additionnelles
aprs lui.

Les variables de configuration Aptitude::UI::Package-Display-Format, Aptitude::
UI::Package-Status-Format et Aptitude::UI::Package-Header-Format dfinissent les
formats par dfaut de la liste de paquets, de l'en-tte au-dessus de la liste de
paquets et de la ligne d'tat en-dessous de la liste de paquets.

Les commandes de format (dbutant par %) suivantes sont disponibles :


 [Note]  Note

         Plusieurs des descriptions ci-dessous font rfrence ``au paquet''.
         Dans l'interface graphique, c'est soit le paquet qui est affich, soit
         le paquet actuellement slectionn. Dans la recherche avec l'interface
         en ligne de commande, c'est le paquet qui est affich.



Commande Nom                  Taille par dfaut  tirable Description

                                                          Ce n'est pas vraiment
                                                          une commande de
                                                          format, cela insert
%%       % litral            1                  Non      simplement un signe
                                                          pourcentage dans
                                                          l'affichage 
                                                          l'endroit o elle est
                                                          place.

                                                          Un unique caractre
                                                          rsumant l'action 
                                                          excuter sur le
%a       Marque d'action      1                  Non      paquet, comme dcrit
                                                          dans Figure 2.9,
                                                          ``Valeur de
                                                          l'indicateur
                                                          ``d'action''''.

                                                          Une description plus
%A       Action               10                 Non      lisible de l'action 
                                                          excuter sur le
                                                          paquet.

                                                          S'il n'y a pas de
                                                          paquet cass, cela ne
                                                          produit rien. Sinon,
%B       Comptage des casss  12                 Non      cela produit une
                                                          chane telle que
                                                          ``Cass : 10''
                                                          indiquant le nombre de
                                                          paquets casss.

                                                          Un unique caractre
                                                          rsumant l'tat actuel
         Marqueur d'tat                                  du paquet, comme
%c       actuel               1                  Non      dcrit dans
                                                          Figure 2.8, ``Valeurs
                                                          de l'indicateur de
                                                          ``l'tat courant''''.

                                                          Une description plus
%C       tat actuel          11                 Non      lisible de l'tat
                                                          actuel du paquet.

%d       Description          40                 Oui      La description courte
                                                          du paquet.

%D       Taille du paquet     6                  Non      La taille de l'archive
                                                          contenant le paquet.

                                                          Le nom d'hte de
%H       Nom d'hte           15                 Non      l'ordinateur sur
                                                          lequel aptitude
                                                          fonctionne.

                                                          Affiche la priorit
                                                          maximale assigne  la
                                                          version du paquet.
                                                          Pour les paquets, cela
%i       Pin priority         4                  Non      affiche la priorit de
                                                          la version dans
                                                          laquelle le paquet est
                                                          forc d'tre install
                                                          (s'il y en a une).

                                                          L'espace (estim) que
%I       Taille installe     6                  Non      prend le paquet sur le
                                                          disque.

%m       Responsable          30                 Oui      Le responsable du
                                                          paquet.

                                                          Si le paquet a t
                                                          install
%M       Marquage automatique 1                  Non      automatiquement,
                                                          affiche ``A'', et
                                                          sinon n'affiche rien.

                                                          Affiche la version du
%n       Version du programme Longueur de        Non      programme,
                              ``0.2.15.9''                actuellement
                                                          ``0.2.15.9''.

                                                          Affiche le nom du
%N       Nom du programme     Longueur du nom du Non      programme,
                              programme                   gnralement
                                                          ``aptitude''.

                                                          Si aucun paquet ne
                                                          doit tre install,
                                                          n'affiche rien. Sinon,
                                                          affiche une chane
                                                          indiquant la taille
%o       Taille  tlcharger 15                 Non      totale prise par les
                                                          paquets  installer
                                                          (i.e. une estimation
                                                          de ce qu'il faut
                                                          tlcharger) ; par
                                                          exemple, ``28,5ko 
                                                          tlcharger''.

                                                          Affiche le nom du
                                                          paquet. Quand un
                                                          paquet est affich
%p       Nom du paquet        30                 Oui      dans une arborescence,
                                                          le nom sera indent,
                                                          si possible, en
                                                          fonction de la
                                                          profondeur de l'arbre.

%P       Priorit             9                  Non      Affiche la priorit du
                                                          paquet.

                                                          Affiche le nombre
%r       Compteur des         2                  Non      approximatif de
         dpendances inverses                             paquets installs qui
                                                          dpendent du paquet.

                                                          Affiche la description
         Abrviation de la                                abrge de la priorit
%R       priorit             3                  Non      du paquet : par
                                                          exemple, ``Important''
                                                          devient ``Imp''.

%s       Section              10                 Non      Affiche la section du
                                                          paquet.

                                                          L'archive dans
%t       Archive              10                 Oui      laquelle se trouve le
                                                          paquet.

                                                          Affiche ``*'' si le
%T       tiquetage           1                  Non      paquet est tiquet,
                                                          rien sinon[10].

                                                          Si l'action prvue
                                                          doit modifier l'espace
         Modification de                                  disque utilis, cela
%u       l'utilisation du     30                 Non      indique le changement,
         disque                                           par exemple,
                                                          ``Utilisera 20,0Mo
                                                          d'espace disque''

                                                          Affiche la version
                                                          actuellement installe
%v       Version actuelle     10                 Non      du paquet, ou <aucun>
                                                          si le paquet n'est pas
                                                          actuellement install.

                                                          Affiche la version du
                                                          paquet qui serait
                                                          install si Paquet-
%V       Version installable  10                 Non      >Installer (+) tait
                                                          excut sur le paquet,
                                                          ou <aucun> si le
                                                          paquet n'est pas
                                                          actuellement install.

                                                          Affiche l'espace
                                                          supplmentaire utilis
%Z       Changement de taille 7                  Non      ou l'espace libr par
                                                          l'installation, la
                                                          mise  jour ou la
                                                          suppression du paquet.



Personnaliser la hirarchie des paquets

La hirarchie des paquets est produite par une politique de groupement : des
rgles dcrivant la manire de construire la hirarchie. La politique de
groupement dcrit une ``succession'' de rgles. Chaque rgle peut retirer des
paquets, crer une sous-hirarchie dans laquelle on place des paquets ou encore
manipuler l'arborescence. Les variables de configuration Aptitude::UI::Default-
Grouping et Aptitude::UI::Default-Preview-Grouping dfinissent les politiques de
groupement lors de la cration, respectivement, de nouvelles listes de paquets
et de nouveaux crans de prvisualisation. Vous pouvez dfinir la politique de
groupement pour la liste de paquets actuelle en appuyant sur G.

La politique de groupement est dcrite par une liste de rgles spares par des
virgules : rgle1,rgle2,.... Chaque rgle est constitue du nom de la rgle,
ventuellement suivi d'arguments : par exemple, versions ou section(subdir). Le
fait que des arguments soient requis et le nombre d'arguments requis (ou permis)
dpend du type de rgle.

Une rgle peut tre non-terminale ou terminale. Une rgle non-terminale va
traiter un paquet en produisant une partie de la hirarchie, puis en le passant
 la rgle suivante. Une rgle terminale, au contraire, va aussi traiter une
partie de l'arborescence (typiquement les entres correspondant au paquet), mais
ne passera pas le paquet  la rgle qui suit. Si aucune rgle terminale n'est
spcifie, aptitude va utiliser la rgle par dfaut qui cre les ``entres de
paquet'' standards.



  action

      Groupe les paquets suivant l'action prvue sur ceux-ci. Les paquets qui ne
      peuvent tre mis  jour ou qui sont inchangs sont ignors. C'est le
      groupement qui est utilis dans l'arborescence d'aperu d'installation.


  deps

      C'est une rgle terminale.

      Cre les entres de paquets standards qui peuvent tre dplies pour
      laisser apparatre les dpendances d'un paquet.


  filter(missing)

      Ne prend pas en compte les paquets qui n'existent que par le jeu des
      dpendances, c'est--dire, les paquets qui sont ni installs, ni fournis
      par un quelconque paquet, et qui sont virtuels.


  firstchar

      Groupe les paquets en fonction de la premire lettre de leur nom.


  hier

      Groupe les paquets en fonction d'un fichier de donnes annexe qui dcrit
      une ``hirarchie'' de paquets.


  priority

      Groupe les paquets en fonction de leur priorit.


  section[(mode[,passthrough])]

      Groupe les paquets en fonction de leur champ Section.

      mode peut prendre les valeurs suivantes :



        none
            Groupe en fonction de la totalit du champ Section, si bien que des
            catgories comme ``non-free/games'' seront cres.


        topdir
            Groupe en fonction de la partie du champ Section prcdant le ``/''.
            S'il n'y en a pas, main est utilise  la place.


        subdir
            Groupe en fonction de la partie du champ Section suivant le ``/''.
            S'il n'y en a pas, la totalit du champ est utilise.


      Si passthrough est prsent, les paquets qui, pour une raison ou une autre,
      ne possdent pas de vritable Section (par exemple, les paquets virtuels)
      sont passs directement au niveau de groupement suivant sans tre placs
      en premier dans une sous-catgorie.


  status

      Trie les paquets dans les catgories suivantes :


      * Installs

      * Non installs

      * Mise  jour de scurit

      * Pouvant tre mis  jour

      * Obsoltes ou crs localement

      * Virtuels



  task

      Cre une arborescence appele ``Tches'' qui contient les tches
      disponibles (les informations sur les tches sont lues depuis debian-
      tasks.desc du paquet tasksel). La rgle suivant task va crer ses
      catgories comme des enfants de Tches.


  versions

      C'est une rgle terminale.

      Cre des entres de paquets standards qui peuvent tre dplies pour
      laisser apparatre les versions du paquet.



Personnaliser la manire de trier les paquets

Par dfaut, les paquets, dans la liste de paquets, sont tris par ordre
alphabtique. Nanmoins, il est souvent utile de les trier suivant d'autres
critres (par exemple, la taille du paquet), et aptitude vous autorise  le
faire en modifiant la politique de tri.

Comme la politique de groupement dcrite dans la section prcdente, la
politique de tri est une liste spare par des virgules. Chaque entre de la
liste est le nom d'un rgle de tri ; si les paquets sont identiques selon la
premire rgle, la seconde tente de les trier, et ainsi de suite. Placer un
caratre tilde (~) avant la rgle inverse la signification habituelle de la
rgle. Par exemple, priority,~name va trier les paquets par priorit, et les
paquets de mme priorit seront placs dans l'ordre alphabtique inverse.

Pour changer la politique de tri d'une liste de paquets active, appuyez sur S.

Les rgles disponibles sont :



  installsize
      Trie les paquets selon l'estimation de la taille ncessaire 
      l'installation.


  name
      Trie les paquets selon leur nom.


  priority
      Trie les paquets selon leur priorit.



Personnaliser les raccourcis clavier

Les touches utilises pour lancer des commandes d'aptitude peuvent tre
personnalises dans le fichier de configuration. Chaque commande possde une
variable de configuration associe sous Aptitude::UI::Keybindings . Pour changer
la squence de touches lie  une commande, il suffit de modifier la variable
correspondant  la squence de touches. Par exemple, pour associer la touche s 
une recherche, mettez Aptitude::UI::Keybindings::Search  ``s''. Vous pouvez
demander  ce que la touche Contrle soit appuyer en plaant ``C-'' devant la
touche : par exemple mettre ``C-s''  la place de ``s'' va lier la recherche 
Control+s au lieu de s. Enfin, vous pouvez lier une commande  plusieurs
squences de touches en une seule fois en les sparant par des virgules : par
exemple utiliser ``s,C-s'' aura pour consquence que s et Control+s lanceront
une recherche.

Les commandes suivantes peuvent tre lies  une squence de touches en
configurant les variables Aptitude::UI::Keybindings::commande, o commande est
le nom de la commande  lier :

 ______________________________________________________________________________
|Commande              |Valeur par dfaut|Description                          |
|______________________|_________________|_____________________________________|
|                      |                 |Se dplace au dbut de l'affichage   |
|Begin                 |home,C-a         |courant : au dbut de la liste ou   |
|                      |                 |gauche d'un champ de saisie de texte.|
|______________________|_________________|_____________________________________|
|                      |                 |Envoie un rapport de bogue contre le |
|BugReport             |B                |paquet couramment slectionn, en    |
|                      |                 |utilisant reportbug.                 |
|______________________|_________________|_____________________________________|
|                      |                 |Annule l'interaction courante. Par   |
|Cancel                |C-g,escape,C-[   |exemple, sort d'une bote de dialogue|
|                      |                 |ou du menu.                          |
|______________________|_________________|_____________________________________|
|                      |                 |Affiche le fichier changelog.Debian  |
|Changelog             |C                |du paquet actuellement slectionn ou|
|                      |                 |de la version du paquet.             |
|______________________|_________________|_____________________________________|
|                      |                 |Change la politique de groupement de |
|ChangePkgTreeGrouping |G                |la liste de paquets actuellement     |
|                      |                 |active.                              |
|______________________|_________________|_____________________________________|
|                      |                 |Change la restriction d'affichage de |
|ChangePkgTreeLimit    |l                |la liste de paquets actuellement     |
|                      |                 |active.                              |
|______________________|_________________|_____________________________________|
|ChangePkgTreeSorting  |S                |Change la politique de tri de la     |
|                      |                 |liste de paquets actuellement active.|
|______________________|_________________|_____________________________________|
|                      |                 |Marque le paquet actuellement        |
|ClearAuto             |m                |slectionn comme ayant t install |
|                      |                 |manuellement.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Reduit toute l'arborescence          |
|CollapseAll           |]                |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Rduit la racine de l'arborescence   |
|CollapseTree          |Aucune squence  |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Dans l'diteur de hirarchie , garde |
|Commit                |N                |en mmoire l'emplacement hirarchique|
|                      |                 |du paquet actuel et passe au paquet  |
|                      |                 |suivant.                             |
|______________________|_________________|_____________________________________|
|                      |                 |Dans les botes de dialogue, c'est   |
|                      |                 |quivalent  ``Ok''. Lors d'une      |
|Confirm               |entre           |interaction en ligne de commande avec|
|                      |                 |une question  choix multiples, cela |
|                      |                 |choisit l'option par dfaut.         |
|______________________|_________________|_____________________________________|
|Cycle                 |tab              |Change le focus clavier vers le      |
|                      |                 |``widget'' suivant.                  |
|______________________|_________________|_____________________________________|
|CycleNext             |f6               |Change vers la vue active suivante.  |
|______________________|_________________|_____________________________________|
|CyclePrev             |f7               |Change vers la vue active prcdente.|
|______________________|_________________|_____________________________________|
|DelBOL                |C-u              |Supprime tout le texte entre le      |
|                      |                 |curseur et le dbut de la ligne.     |
|______________________|_________________|_____________________________________|
|DelBack               |ret. arr.,C-h    |Supprime le caractre prcdent lors |
|                      |                 |de la saisie de texte.               |
|______________________|_________________|_____________________________________|
|DelEOL                |C-k              |Supprime tout le texte depuis le     |
|                      |                 |curseur jusqu' la fin de la ligne.  |
|______________________|_________________|_____________________________________|
|DelForward            |supprime,C-d     |Supprime le caractre sous le curseur|
|                      |                 |lors de la saisie de texte.          |
|______________________|_________________|_____________________________________|
|Dependencies          |d                |Affiche les dpendances du paquet    |
|                      |                 |actuellement slectionn.            |
|______________________|_________________|_____________________________________|
|                      |                 |Dans la liste de paquets, alterne les|
|DescriptionCycle      |i                |vues disponibles dans la zone        |
|                      |                 |d'information.                       |
|______________________|_________________|_____________________________________|
|                      |                 |Dans la liste de paquets, descend    |
|DescriptionDown       |z                |d'une ligne dans la zone             |
|                      |                 |d'information.                       |
|______________________|_________________|_____________________________________|
|DescriptionUp         |a                |Dans la liste de paquets, monte d'une|
|                      |                 |ligne dans la zone d'information.    |
|______________________|_________________|_____________________________________|
|                      |                 |En dehors d'un aperu d'installation,|
|DoInstallRun          |g                |affiche cet aperu [a]. Dans un      |
|                      |                 |aperu d'installation, lance un      |
|                      |                 |processus d'installation.            |
|______________________|_________________|_____________________________________|
|                      |                 |Descend : par exemple, descend dans  |
|Down                  |bas,j            |un affichage de texte, ou slectionne|
|                      |                 |l'entre suivante dans une liste.    |
|______________________|_________________|_____________________________________|
|DpkgReconfigure       |R                |Lance ``dpkg-reconfigure'' sur le    |
|                      |                 |paquet actuellement slectionn.     |
|______________________|_________________|_____________________________________|
|EditHier              |E                |Ouvre l'diteur hirarchique.        |
|______________________|_________________|_____________________________________|
|                      |                 |Se dplace  la fin de l'affichage   |
|End                   |fin,C-e          |courant :  la fin de la liste ou   |
|                      |                 |droite d'un champ de saisie de texte.|
|______________________|_________________|_____________________________________|
|                      |                 |Dploie toute l'arborescence         |
|ExpandAll             |[                |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Dploie la racine de l'arborescence  |
|ExpandTree            |Aucune squence  |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Interdit  un paquet d'tre mis     |
|ForbidUpgrade         |F                |jour vers la version actuelle d'un   |
|                      |                 |paquet (ou une version particulire).|
|______________________|_________________|_____________________________________|
|                      |                 |Oublie quels paquets sont            |
|ForgetNewPackages     |f                |``nouveaux'' (ce qui implique que la |
|                      |                 |liste des ``nouveaux'' paquets       |
|                      |                 |devienne vide).                      |
|______________________|_________________|_____________________________________|
|Help                  |?                |Affiche l'aide en ligne  l'cran.   |
|______________________|_________________|_____________________________________|
|                      |                 |Dans un diteur comportant un        |
|HistoryNext           |bas,C-n          |historique, descend dans             |
|                      |                 |l'historique.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Dans un diteur comportant un        |
|HistoryPrev           |haut,C-p         |historique, remonte dans             |
|                      |                 |l'historique.                        |
|______________________|_________________|_____________________________________|
|Hold                  |=                |Gle un paquet.                      |
|______________________|_________________|_____________________________________|
|Install               |+                |Marque un paquet pour installation.  |
|______________________|_________________|_____________________________________|
|                      |                 |Marque un unique paquet pour         |
|InstallSingle         |I                |installation. Tout les autres paquets|
|                      |                 |sont gards dans leur version        |
|                      |                 |actuelle.                            |
|______________________|_________________|_____________________________________|
|Keep                  |:                |Annule toute demande d'installation  |
|                      |                 |ou de suppression d'un paquet.       |
|______________________|_________________|_____________________________________|
|                      |                 |Se dplace vers la gauche : par      |
|                      |                 |exemple, se dplace vers la gauche   |
|Left                  |gauche,h         |dans la barre de menu, ou dplace le |
|                      |                 |curseur vers la gauche lors de la    |
|                      |                 |saisie de texte.                     |
|______________________|_________________|_____________________________________|
|                      |                 |Dans un liste hirarchique,          |
|                      |                 |slectionne l'enfant prcdent       |
|LevelDown             |K                |l'entre actuellement slectionne   |
|                      |                 |(l'entre prcdente au mme niveau  |
|                      |                 |avec le mme parent).                |
|______________________|_________________|_____________________________________|
|                      |                 |Dans un liste hirarchique,          |
|                      |                 |slectionne l'enfant suivant l'entre|
|LevelUp               |J                |actuellement slectionne (l'entre  |
|                      |                 |suivante au mme niveau avec le mme |
|                      |                 |parent).                             |
|______________________|_________________|_____________________________________|
|                      |                 |Essaie de mettre  jour tous les     |
|MarkUpgradable        |U                |paquets qui ne sont pas gels ou     |
|                      |                 |interdits de mise  jour.            |
|______________________|_________________|_____________________________________|
|MineFlagSquare        |f                |Dans le dmineur, place ou enlve le |
|                      |                 |drapeau d'une case.                  |
|______________________|_________________|_____________________________________|
|MineLoadGame          |L                |Charge une partie dedmineur.        |
|______________________|_________________|_____________________________________|
|MineSaveGame          |S                |Sauvegarde une partie de dmineur.   |
|______________________|_________________|_____________________________________|
|MineSweepSquare       |aucune squence  |Fait le mnage autour de la case     |
|                      |                 |actuelle dans le dmineur.           |
|______________________|_________________|_____________________________________|
|MineUncoverSquare     |aucune squence  |Dcouvre la case actuelle dans le    |
|                      |                 |dmineur                             |
|______________________|_________________|_____________________________________|
|                      |                 |Dcouvre la case actuelle dans le    |
|MineUncoverSweepSquare|enter            |dmineur si elle est couverte, sinon |
|                      |                 |fait le mnage autour d'elle.        |
|______________________|_________________|_____________________________________|
|NextPage              |page suiv.,C-f   |Va  la page suivante de l'affichage |
|                      |                 |courant.                             |
|______________________|_________________|_____________________________________|
|No                    |n[b]             |Slectionne la rponse ``non'' dans  |
|                      |                 |une bote de dialogue oui/non.       |
|______________________|_________________|_____________________________________|
|                      |                 |Slectionne le parent de l'entre    |
|Parent                |^                |slectionne dans une liste          |
|                      |                 |hirarchique.                        |
|______________________|_________________|_____________________________________|
|PrevPage              |page prc.,C-b   |Va  la page prcdente de           |
|                      |                 |l'affichage courant.                 |
|______________________|_________________|_____________________________________|
|Purge                 |_                |Marque le paquet actuellement        |
|                      |                 |slectionn pour purge.              |
|______________________|_________________|_____________________________________|
|                      |                 |Active le bouton actuellement        |
|PushButton            |espace,entre    |slectionn, ou modifie l'tat d'une |
|                      |                 |bote  cocher.                      |
|______________________|_________________|_____________________________________|
|Quit                  |q                |Ferme la vue actuelle.               |
|______________________|_________________|_____________________________________|
|QuitProgram           |Q                |Quitte le programme.                 |
|______________________|_________________|_____________________________________|
|Refresh               |C-l              |Redessine la totalit de l'cran.    |
|______________________|_________________|_____________________________________|
|Remove                |-                |Marque un paquet pour suppression.   |
|______________________|_________________|_____________________________________|
|ReInstall             |L                |Marque le paquet actuellement        |
|                      |                 |slectionn pour rinstallation.     |
|______________________|_________________|_____________________________________|
|ReSearch              |\,n              |Rpter la dernire recherche.       |
|______________________|_________________|_____________________________________|
|ReverseDependencies   |r                |Affiche les paquets qui dpendent du |
|                      |                 |paquet actuellement slectionn.     |
|______________________|_________________|_____________________________________|
|                      |                 |Se dplace vers la droite : par      |
|                      |                 |exemple, se dplace vers la droite   |
|Right                 |right,l          |dans la barre de menu, ou dplace le |
|                      |                 |curseur vers la droite lors de la    |
|                      |                 |saisie de texte.                     |
|______________________|_________________|_____________________________________|
|SaveHier              |S                |Dans l'diteur de hirarchie,        |
|                      |                 |sauvegarde la hirarchie actuelle.   |
|______________________|_________________|_____________________________________|
|                      |                 |Active la fonction de ``recherche''  |
|Search                |/                |sur l'lment de l'interface         |
|                      |                 |actuellement actif.                  |
|______________________|_________________|_____________________________________|
|SearchBroken          |b                |Dans une arborescence de paquets,    |
|                      |                 |recherche le paquet cass suivant.   |
|______________________|_________________|_____________________________________|
|SetAuto               |M                |Marque le paquet courant comme ayant |
|                      |                 |t automatiquement install.        |
|______________________|_________________|_____________________________________|
|                      |                 |Dans une liste de paquets, dfinit si|
|ShowHideDescription   |D                |la zone d'information est visible ou |
|                      |                 |non.                                 |
|______________________|_________________|_____________________________________|
|                      |                 |Dploie ou rduit l'arborescence     |
|ToggleExpanded        |entre           |actuellement slectionne dans une   |
|                      |                 |liste hirarchique.                  |
|______________________|_________________|_____________________________________|
|ToggleMenuActive      |f10,C-space      |Active ou dsactive le menu          |
|                      |                 |principal.                           |
|______________________|_________________|_____________________________________|
|                      |                 |Annule la dernire action, en pouvant|
|                      |                 |remonter jusqu'au dmarrage du       |
|Undo                  |C-_,C-u          |programme OU  la dernire mise     |
|                      |                 |jour de la liste de paquets ou       |
|                      |                 |installation.                        |
|______________________|_________________|_____________________________________|
|                      |                 |Monte : par exemple, dans un cran de|
|Up                    |haut,k           |slection, va au texte prcdent, ou |
|                      |                 |dans une liste, va  l'entre        |
|                      |                 |prcdente.                          |
|______________________|_________________|_____________________________________|
|                      |                 |Met  jour la liste de paquets en    |
|UpdatePackageList     |u                |tlchargeant de nouvelles listes    |
|                      |                 |depuis Internet si ncessaire.       |
|______________________|_________________|_____________________________________|
|Versions              |v                |Affiche les versions disponibles du  |
|                      |                 |paquet actuellement slectionn.     |
|______________________|_________________|_____________________________________|
|                      |                 |Cette squence va slectionner le    |
|Yes                   |y [b]            |bouton ``Oui'' dans les botes de    |
|                      |                 |dialogue oui/non.                    |
|______________________|_________________|_____________________________________|
|[a]  moins que Aptitude::Display-Planned-Action soit  false  (faux).       |
|                                                                              |
|[b] Cette valeur par dfaut peut varier suivant la locale (i.e. la langue du  |
|systme).                                                                     |
|______________________________________________________________________________|

En plus des touches de lettres, chiffres et ponctuations, les touches
``spciales'' suivantes peuvent tre lies dans une squence :

 ____________________________________________________________________________
|Nom de la touche|Description                                                |
|________________|___________________________________________________________|
|a1              |La touche A1.                                              |
|________________|___________________________________________________________|
|a3              |La touche A3.                                              |
|________________|___________________________________________________________|
|b2              |La touche B2.                                              |
|________________|___________________________________________________________|
|backspace       |La touche Retour Arrire.                                  |
|________________|___________________________________________________________|
|backtab         |La touche Back-tab                                         |
|________________|___________________________________________________________|
|begin           |La touche Begin (pas Origine, i.e.  Home ).              |
|________________|___________________________________________________________|
|break           |La touche ``break''.                                       |
|________________|___________________________________________________________|
|c1              |La touche C1.                                              |
|________________|___________________________________________________________|
|c3              |La touche C3.                                              |
|________________|___________________________________________________________|
|cancel          |La touche Annuler ( kCancel ).                           |
|________________|___________________________________________________________|
|create          |La touche Cration ( Create ).                           |
|________________|___________________________________________________________|
|                |Virgule (,) -- notez que comme les virgules sont utilises |
|comma           |pour lister les squences, c'est l'unique moyen de lier une|
|                |virgule dans une squence de touches.                      |
|________________|___________________________________________________________|
|command         |La touche Command.                                         |
|________________|___________________________________________________________|
|copy            |La touche Copier.                                          |
|________________|___________________________________________________________|
|delete          |La touche Supprime.                                        |
|________________|___________________________________________________________|
|delete_line     |La touche ``delete line''.                                 |
|________________|___________________________________________________________|
|down            |La touche flche ``bas''.                                  |
|________________|___________________________________________________________|
|end             |La touche Fin.                                             |
|________________|___________________________________________________________|
|entry           |La touche Entre.                                          |
|________________|___________________________________________________________|
|exit            |La touche Sortie ( Exit ).                               |
|________________|___________________________________________________________|
|f1, f2, ..., f10|Les touches F1  F10.                                      |
|________________|___________________________________________________________|
|find            |La touche Recherche.                                       |
|________________|___________________________________________________________|
|home            |La touche Origine.                                         |
|________________|___________________________________________________________|
|insert          |La touche Insrer.                                         |
|________________|___________________________________________________________|
|insert_exit     |La touche ``insert exit''.                                 |
|________________|___________________________________________________________|
|clear           |La touche ``clear''.                                       |
|________________|___________________________________________________________|
|clear_eol       |La touche ``clear to end of line''.                        |
|________________|___________________________________________________________|
|clear_eos       |La touche ``clear to end of screen''.                      |
|________________|___________________________________________________________|
|insert_line     |La touche ``insert line''.                                 |
|________________|___________________________________________________________|
|left            |La touche flche ``gauche''.                               |
|________________|___________________________________________________________|
|mark            |La touche Mark.                                            |
|________________|___________________________________________________________|
|message         |La touche Message.                                         |
|________________|___________________________________________________________|
|move            |La touche Move.                                            |
|________________|___________________________________________________________|
|next            |La touche Suivant.                                         |
|________________|___________________________________________________________|
|open            |la touche Open.                                            |
|________________|___________________________________________________________|
|previous        |La touche Prcdent.                                       |
|________________|___________________________________________________________|
|print           |La touche Imprimer.                                        |
|________________|___________________________________________________________|
|redo            |La touche Refaire.                                         |
|________________|___________________________________________________________|
|reference       |La touche Reference.                                       |
|________________|___________________________________________________________|
|refresh         |La touche Refresh.                                         |
|________________|___________________________________________________________|
|replace         |The Replace key.                                           |
|________________|___________________________________________________________|
|restart         |La touche Restart.                                         |
|________________|___________________________________________________________|
|resume          |La touche Resume.                                          |
|________________|___________________________________________________________|
|return          |La touche Retour.                                          |
|________________|___________________________________________________________|
|right           |La touche flche ``droite''.                               |
|________________|___________________________________________________________|
|save            |La touche Save.                                            |
|________________|___________________________________________________________|
|scrollf         |La touche ``scroll forward''.                              |
|________________|___________________________________________________________|
|scrollr         |La touche ``scroll backwards''.                            |
|________________|___________________________________________________________|
|select          |La touche Select.                                          |
|________________|___________________________________________________________|
|suspend         |La touche Suspend.                                         |
|________________|___________________________________________________________|
|pagedown        |La touche ``Page Suivante''.                               |
|________________|___________________________________________________________|
|pageup          |La touche ``Page Prcdente''.                             |
|________________|___________________________________________________________|
|space           |La touche Espace.                                          |
|________________|___________________________________________________________|
|tab             |La touche Tab.                                             |
|________________|___________________________________________________________|
|undo            |La touche Annuler.                                         |
|________________|___________________________________________________________|
|up              |La touche flche ``haut''.                                 |
|________________|___________________________________________________________|

En plus des squences de touches globales, il est possible de changer les
squences de touches pour une partie particulire (ou domaine) du programme :
par exemple, pour faire de Tab un quivalent de la touche flche droite dans les
barres de menu, donner la valeur ``tab,right''  Aptitude::UI::Keybindings::
Menubar::Right. Les domaines suivants sont disponibles :

 _____________________________________________________________________________
|Domaine      |Description                                                    |
|_____________|_______________________________________________________________|
|EditLine     |Utilis par les botes de saisie de texte, comme le champ de   |
|             |saisie de la bote de dialogue de ``recherche''.               |
|_____________|_______________________________________________________________|
|Menu         |Utilis par les onglets de menus.                              |
|_____________|_______________________________________________________________|
|Menubar      |Utilis par la barre de menu du haut de l'cran.               |
|_____________|_______________________________________________________________|
|Minesweeper  |Utilis par le mode dmineur.                                  |
|_____________|_______________________________________________________________|
|             |Utilis par les questions  choix multiples qui apparaissent si|
|MinibufChoice|vous avez choisi de voir des questions apparatre dans la ligne|
|             |d'tat.                                                        |
|_____________|_______________________________________________________________|
|Pager        |Utilis pour afficher un fichier prsent sur le disque (par    |
|             |exemple, le fichier texte d'aide).                             |
|_____________|_______________________________________________________________|
|             |Utilis par les paquets, les arborescences de paquets, les     |
|PkgNode      |versions et les dpendances de paquets quand ils apparaissent  |
|             |dans des listes de paquets.                                    |
|_____________|_______________________________________________________________|
|PkgTree      |Utilis par les listes de paquets.                             |
|_____________|_______________________________________________________________|
|Table        |Utilis par dans les prsentations d'objets graphiques (par    |
|             |exemple, les botes de dialogue).                              |
|_____________|_______________________________________________________________|
|TextLayout   |Utilis par les affichages formats de texte, tels que les     |
|             |descriptions de paquets.                                       |
|_____________|_______________________________________________________________|
|Tree         |Utilis par tous les affichages d'arborescence (dont les listes|
|             |de paquets pour lesquelles PkgTree reste prpondrant).        |
|_____________|_______________________________________________________________|


Personnaliser les couleurs

Les couleurs utilises par aptitude pour afficher diffrentes choses  l'cran
peuvent tre modifies selon vos prfrences. Pour changer la couleur de
l'lment d'interface utilisateur lt, vous devez modifier la variable de
configuration Aptitude::UI::Colors::lt compose de deux lments : la couleur
du premier plan et la couleur de l'arrire-plan. Autrement dit, pour afficher
les paquets casss en rouge sur fond noir au lieu de noir sur fond rouge, mettez
ceci dans votre fichier de configuration :

Aptitude::UI::Colors::PkgBroken {red; black;};

Les couleurs disponibles sont black (noir), blue (bleu), cyan, green (vert),
magenta, red (rouge), white (blanc) et yellow (jaune) [11]. Vous pouvez faire
apparatre l'lment en texte gras en plaant ``bold'' devant la couleur de
premier plan, comme, par exemple, boldwhite. Enfin, vous pouvez utiliser des
entiers qui seront utiliss directement comme des attributs de texte.

En rsum, une simple, mais extrmement hideuse, redfinition de quelques
couleurs ressemblerait  ceci :

Aptitude::UI::Colors {
DefaultWidgetBackground {boldwhite; magenta;};
ScreenStatusColor {green; cyan;};
ScreenHeaderColor {red; yellow;};
Progress {cyan; white;};
};

Ceci aurait pour rsultat la capture suivante :

Malheureusement vous utilisez un afficheur non graphique, et cette capture
pleine de couleurs ne peut pas tre reprsente utilement en mode texte.

Les couleurs qui peuvent tre personnalises sont dcrites dans Figure 2.10,
``Couleurs personnalisables dans aptitude''. La valeur par dfaut de chaque
couleur est donne par un couple premier plan,arrire-plan.

Figure 2.10. Couleurs personnalisables dans aptitude

 ______________________________________________________________________________
|Couleur                |Valeur par dfaut|Description                         |
|_______________________|_________________|____________________________________|
|Bullet                 |yellow,black     |La couleur utilise pour afficher la|
|                       |                 |puce dans les listes  puces.       |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour dessiner   |
|DefaultWidgetBackground|white,black      |les zones vides de l'cran et la    |
|                       |                 |couleur par dfaut utilise pour    |
|                       |                 |afficher du texte.                  |
|_______________________|_________________|____________________________________|
|DepBroken              |black,red        |La couleur utilise pour afficher   |
|                       |                 |les dpendances non satisfaites.    |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour indiquer   |
|                       |                 |qu'un fichier tait ``dj          |
|DownloadHit            |black,green      |rcupr'', c'est--dire qu'il a t|
|                       |                 |examin mais qu'il est inchang et  |
|                       |                 |donc non tlcharg.                |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher   |
|DownloadProgress       |black,yellow     |l'indicateur d'avancement d'un      |
|                       |                 |tlchargement.                     |
|_______________________|_________________|____________________________________|
|Error                  |boldwhite,red    |La couleur utilise pour afficher   |
|                       |                 |les messages d'erreur.              |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher le|
|HighlightedMenuBar     |boldwhite,blue   |menu slectionn dans la barre de   |
|                       |                 |menu.                               |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher le|
|HighlightedMenuEntry   |boldblue,white   |choix actuellement slectionn dans |
|                       |                 |un menu.                            |
|_______________________|_________________|____________________________________|
|MediaChange            |boldyellow,red   |La couleur utilise lors des        |
|                       |                 |demandes de changements de CD.      |
|_______________________|_________________|____________________________________|
|MenuBar                |boldblue,white   |La couleur utilise pour afficher la|
|                       |                 |barre de menu.                      |
|_______________________|_________________|____________________________________|
|MenuBorder             |boldwhite,blue   |La couleur utilise pour dessiner   |
|                       |                 |les bordures autour des menus.      |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher   |
|MenuEntry              |white,blue       |les choix dans les menus. Cette     |
|                       |                 |couleur est mise en gras pour les   |
|                       |                 |lettres des cls d'accs rapide.    |
|_______________________|_________________|____________________________________|
|MineBombColor          |boldred,black    |La couleur utilise pour afficher   |
|                       |                 |les mines dans le dmineur.         |
|_______________________|_________________|____________________________________|
|MineFlagColor          |boldred,black    |La couleur utilise pour afficher   |
|                       |                 |les drapeaux dans le dmineur.      |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher   |
|PkgBroken              |black,red        |les paquets qui ont des dpendances |
|                       |                 |non satisfaites.                    |
|_______________________|_________________|____________________________________|
|PkgToHold              |black,white      |La couleur utilise pour afficher   |
|                       |                 |les paquets gels.                  |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher   |
|PkgToInstall           |black,green      |les paquets qui vont tre installs |
|                       |                 |(hors mise  jour) ou rinstalls.  |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher   |
|PkgToRemove            |black,magenta    |les paquets qui vont tre supprims |
|                       |                 |ou purgs.                          |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher   |
|PkgToUpgrade           |black,cyan       |les paquets qui vont tre mis      |
|                       |                 |jour.                               |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher   |
|Progress               |blue,yellow      |les indicateurs d'avancement comme  |
|                       |                 |celui qui apparat lorsque le cache |
|                       |                 |des paquets est charg.             |
|_______________________|_________________|____________________________________|
|                       |                 |La couleur utilise pour afficher   |
|ScreenHeaderColor      |boldwhite,blue   |les en-ttes de l'cran             |
|                       |                 |(l'information en haut de l'cran). |
|_______________________|_________________|____________________________________|
|ScreenStatusColor      |boldwhite,blue   |La couleur utilise pour afficher la|
|                       |                 |ligne d'tat en bas de l'cran.     |
|_______________________|_________________|____________________________________|


Personnaliser la disposition de l'affichage

Il est possible de rordonner la liste des paquets d'aptitude en apportant les
modifications appropries au fichier de configuration.


lments d'affichage

La disposition est conserve dans le groupe de configuration Aptitude::UI::
Default-Package-View, et consiste en une liste d'lments d'affichage :

Nom Type {
  Row ligne;
  Column colonne;
  Width largeur;
  Height hauteur;

  options supplmentaires...
};

Cela cre un lment d'affichage nomm Nom dont le type est donn par Type. Les
options Row, Column, Width, et Height doivent tre prsentes. Elle dtermine o
l'lment d'affichage est situ. Voyez ci-dessous pour une explication dtaille
sur la manire dont les lments d'affichage sont disposs.

Pour des exemples sur la manire de changer la disposition de l'affichage,
consultez la dfinition du thme par dfaut dans le fichier /usr/share/aptitude/
aptitude-defaults.

Les types d'lments d'affichage suivants sont disponibles :



  Description
      Cet lment d'affichage contient la ``zone d'information'' (typiquement
      une description du paquet actuellement slectionn).

      L'option PopUpDownKey donne le nom d'une commande clavier qui va montrer
      ou cacher l'lment d'affichage. Par exemple, mettre cette option 
      ShowHideDescription va donner  l'lment d'affichage actuel le mme
      comportement que celui par dfaut pour la zone d'information. L'option
      PopUpDownLinked donne le nom d'un autre lment d'affichage ; l'lment
      courant sera montr ou cach  chaque fois que l'autre lment le sera.


  MainWidget
      C'est une rfrence  l'lment d'affichage ``principal'' : typiquement
      c'est une liste de paquets. Une disposition d'affichage doit contenir
      exactement un lment MainWidget : pas un de plus, pas un de moins.


  Static
      Une zone de l'cran qui affiche du texte, et pouvant contenir du code
      format tel que dcrit dans the section called ``Personnaliser la manire
      d'afficher les paquets''. Le texte  afficher peut tre donn dans
      l'option Columns, ou tre stock dans la variable spcifie par l'option
      ColumnsCfg. La couleur du texte est dtermine par le nom de la couleur
      pass  l'option Color.

      Les objets Static peuvent tre affichs et cachs de la mme manire que
      les objets Description en utilisant les options PopUpDownKey et
      PopUpDownLinked.



Placement des lments d'affichage

Les lments d'affichage sont disposs dans une ``table''. Le coin suprieur
gauche d'un lment est dans la cellule donne par les options Row et Column
(commenant habituellement  la ligne 0 et la colonne 0 bien que ce ne soit pas
obligatoire). La largeur d'un lment en cellule est donne par son option
Width, et sa hauteur est donne par son option Height.

Une fois que l'lment d'affichage est dispos et qu'il a reu un tendue
initiale  l'cran, il est possible qu'il reste de l'espace. S'il y a de
l'espace libre verticalement chaque ligne contenant un lment d'affichage dont
l'option RowExpand est  true se verra allouer une partie de l'espace libre. De
faon analogue, s'il y a de l'espace libre horizontalement, chaque colonne
contenant un lment d'affichage dont l'option ColExpand est  true se verra
allouer une partie de l'espace libre.

Dans le cas ou il n'y a pas assez d'espace, chaque ligne ou colonne dont tous
les objets ont leurs options RowShrink ou ColShrink  true sera rtrcie. S'il
n'y en a pas assez, toutes les lignes et colonnes sont rtrcies pour s'ajuster
 l'espace disponible.

Si un lment d'affichage n'est pas agrandi, mais ses lignes ou colonnes le
sont, son alignement est dtermin par les options RowAlign et ColAlign. Les
configurer  Left (gauche), Right (droite), Top (haut), Bottom (bas), ou Center
(centr) va indiquer  aptitude o placer l'lment verticalement et
horizontalement.

Par exemple, le groupe de configuration suivant cre un lment Static nomm
``Header'', qui est large de trois cellules et qui s'agrandit horizontalement
mais pas verticalement. Il a la mme couleur que les autres lignes d'en-tte et
utilise le format standard des lignes d'en-tte :

Header Static {
  Row 0;
  Column 0;
  Width 3;
  Height 1;

  ColExpand true;
  ColAlign Center;

  RowAlign Center;

  Color ScreenHeaderColor;
  ColumnsCfg HEADER;
};


Rfrence des options de la disposition de l'affichage

Les options suivantes sont disponibles pour les lments d'affichage :



  ColAlign alignement;
      Alignement doit tre Left (gauche), Right (droite), ou Center (centr). Si
      la ligne contenant l'lment d'affichage courant est plus large que
      l'lment lui-mme et que ColExpand est false, l'lment sera plac dans
      la ligne selon la valeur alignement.

      Si cette option est absente, la valeur par dfaut est Left.


  ColExpand true|false;
      Si cette option est mise  true (vrai), la colonne contenant l'lment
      d'affichage se verra allouer une partie de l'espace horizontal libre qui
      serait disponible.

      Si cette option est absente, la valeur par dfaut est false (faux).


  Color couleur;
      Cette option s'applique  l'lment Static. Couleur est le nom d'une
      couleur (par exemple, ScreenStatusColor) qui devrait tre utilis comme
      couleur par dfaut pour afficher l'lment d'affichage.

      Si cette option est absente, la valeur par dfaut est
      DefaultWidgetBackground.


  ColShrink true|false;
      Si cette option est mise  true sur chaque lment d'une colonne, et s'il
      n'y a pas assez d'espace horizontal, la colonne sera rtrcie autant qu'il
      faut pour rentrer dans l'espace disponible. Remarquez qu'une colonne peut
      tre rtrcie mme si ColShrink est false ; cela indique simplement
      qu'aptitude devrait essayer de rduire une colonne particulire avec les
      autres.

      Si cette option est absente, la valeur par dfaut est false.


  Column colonne;
      Spcifie la colonne la plus  gauche pouvant contenir cet lment
      d'affichage.


  Columns format;
      Cette option s'applique aux lments d'affichage Static pour lesquels
      l'option ColumnsCfg n'est pas configure. Elle configure le contenu de
      l'affichage de la ligne d'tat. C'est une chane de format comme dcrit
      dans the section called ``Personnaliser la manire d'afficher les
      paquets''.


  ColumnsCfg HEADER|STATUS|nom;
      Cette option s'applique aux lments d'affichage Static. Il configure le
      format d'affichage de l'lment courant  la valeur d'une autre variable
      de configuration. Si c'est HEADER ou STATUS, les options, respectivement,
      Aptitude::UI::Package-Header-Format et Aptitude::UI::Package-Status-
      Format, sont utilises. Sinon l'option nom est utilise.

      Si cette option est absente, la valeur de l'option Columns est utilise
      pour contrler le contenu de l'lment statique.


  Height hauteur;
      Spcifie la hauteur hauteur de l'lment d'affichage courant.


  PopUpDownKey commande;
      Cette option s'applique aux lments d'affichage Description et Static.

      Commande est le nom d'une commande clavier (par exemple,
      ShowHideDescription). Quand cette squence de touches est presse,
      l'lment d'affichage est cach s'il est visible et affich s'il est
      cach.


  PopUpDownLinked lment;
      Cette option s'applique aux lments d'affichage Description et Static.

      lment est le nom d'un lment d'affichage. Quand lment est affich,
      l'lment courant sera aussi affich et quand lment est cach, l'lment
      courant sera aussi cach.


  Row ligne;
      Spcifie la ligne la plus en haut pouvant contenir cet lment
      d'affichage.


  RowAlign alignement;
      alignement doit tre Top (haut), Bottom (bas) ou Center (centr). Si la
      ligne contenant l'lment d'affichage courant est plus haute que l'lment
      lui-mme et que RowExpand est false, l'lment sera plac dans la ligne
      selon la valeur alignement.

      Si cette option est absente, la valeur de l'option est Top.


  RowExpand true|false;
      Si cette option est mise  true (vrai), la ligne contenant l'lment
      d'affichage se verra allouer une partie de l'espace horizontal libre qui
      serait disponible.

      Si cette option est absente, la valeur de l'option est false.


  RowShrink true|false;
      Si cette option est mise  true sur chaque lment d'une ligne, et s'il
      n'y a pas assez d'espace horizontal, la ligne sera rtrcie autant qu'il
      faut pour rentrer dans l'espace disponible. Remarquez qu'une ligne peut
      tre rtrcie mme si RowShrink est false ; cela indique simplement
      qu'aptitude devrait essayer de rduire une ligne particulire avec les
      autres.

      Si cette option est absente, la valeur de l'option est false.


  Visible true|false;
      Configur  false (faux), cet lment d'affichage sera initialement cach.
      Ce n'est probablement utile que combin avec PopUpDownKey et/ou
      PopUpDownLinked.

      Si cette option est absente, la valeur de l'option est true.


  Width largeur;
      Spcifie la largeur de l'lment d'affichage courant.



Rfrence du fichier de configuration


Format du fichier de configuration

Basiquement, le fichier de configuration d'aptitude est une liste des couples
d'options et de leurs valeurs. Chaque ligne du fichier devrait avoir la forme
``Option Valeur;'' : par exemple, dans le fichier de configuration, la ligne
suivante met l'option Aptitude::Theme  ``Dselect''.

Aptitude::Theme "Dselect";

Une option peut ``contenir'' d'autres options si elles sont crites entre
accolades places entre l'option et le point-virgule qui la suit, comme ceci :

Aptitude::UI {
  Package-Status-Format "";
  Package-Display-Format "";
};

Une option qui contient d'autres options est parfois appele groupe. En fait, le
deux-points doubl, qui apparat dans les noms d'options est une manire
simplifie pour indiquer l'inclusion : l'option Aptitude::UI::Default-Grouping
est contenu dans le groupe Aptitude::UI, qui est lui-mme dans le groupe
Aptitude. Ainsi, si vous le souhaitez, vous pourriez configurer cette option 
"" comme cela :

Aptitude {
  UI {
    Default-Grouping "";
  };
};

Pour plus d'informations sur le format du fichier de configuration, consultez la
page de manuel apt.conf(5).


Emplacement du fichier de configuration

La configuration d'aptitude est lue, dans l'ordre, depuis les sources
suivantes :


  1. Le fichier de configuation de l'utilisateur, ~/.aptitude/config. Ce fichier
     est cras quand l'utilisateur modifie la configuration dans le menu
     Options.

  2. Le fichier de configuration du systme, /etc/apt/apt.conf.

  3. Les valeurs par dfaut conserves dans /usr/share/aptitude/aptitude-
     defaults.

  4. Les valeurs par dfaut contenues dans le programme.


Quand une option est value, ces sources sont consultes dans l'ordre, et la
premire qui fournit une valeur pour l'option est utilise. Par exemple,
configurer une option dans /etc/apt/apt.conf va craser la valeur par dfaut
d'aptitude pour cette option, mais cela n'crasera pas la configuration de
l'utilisateur dans ~/.aptitude/config.


Options de configuration disponibles

Les options de configuration suivantes sont utilises par aptitude. Notez que ce
ne sont pas les seules options de configuration disponibles ; les options
utilises par le systme sous-jacent ne sont pas listes ici. Consultez les
pages de manuel apt(8) et apt.conf(5) pour les informations sur les options
d'apt.

Option:Dir::Aptitude::state

Valeur par dfaut:/var/lib/aptitude

Description: Le rpertoire dans lequel les informations d'tat persistant
d'aptitude sont conserves.

Option:Aptitude::Allow-Null-Upgrade

Valeur par dfaut:false

Description: Normalement, si vous essayez de dmarrer un processus
d'installation alors qu'aucune action n'est prvue, aptitude affiche un
avertissement et revient  la liste des paquets. Si cette option est true,
aptitude affichera l'aperu d'installation mme s'il y a des paquets pouvant
tre mis  jour, plutt qu'afficher un rappel sur la commande Actions->Marquer
comme tant susceptible de mise  jour (U).

Option:Aptitude::Autoclean-After-Update

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude fera le mnage parmi les
fichiers obsoltes (consultez Actions->Nettoyer les fichiers prims) chaque
fois que vous mettez  jour la liste des paquets.

Option:Aptitude::Auto-Install

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude essaiera automatiquement
de satisfaire les dpendances d'un paquet quand vous le slectionnez pour
installation.

Option:Aptitude::Auto-Fix-Broken

Valeur par dfaut:true

Description: Si cette option est mise  false, aptitude demandera la permission
avant de tenter de corriger un paquet cass.

Option:Aptitude::Auto-Upgrade

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude marquera automatiquement
tous les paquets pouvant tre mis  jour pour qu'il le soit au dmarrage du
programme, comme si vous aviez excut la commande Actions->Marquer comme tant
susceptible de mise  jour (U).

Option:Aptitude::CmdLine::Always-Prompt

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est  ``true'', aptitude
demandera toujours confirmation avant de commencer  installer ou supprimer des
paquets, mme si la confirmation aurait normalement t saute. C'est quivalent
 l'option -P de la ligne de commande.

Option:Aptitude::CmdLine::Assume-Yes

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est  ``true'', aptitude
agira comme si l'utilisateur rpondait ``oui''  chaque invite, causant le saut
de la plupart des questions. C'est quivalent  l'option -y de la ligne de
commande.

Option:Aptitude::CmdLine::Download-Only

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est  ``true'', aptitude
tlchargera les paquets sans les installer. C'est quivalent  l'option -d de
la ligne de commande.

Option:Aptitude::CmdLine::Fix-Broken

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est  ``true'', aptitude
sera plus agressif lorsqu'il tentera de corriger les dpendances de paquets
casss. C'est quivalent  l'option -f de la ligne de commande.

Option:Aptitude::CmdLine::Package-Display-Format

Valeur par dfaut:%c%a%M %p# - %d#

Description: C'est une chane de format, tel que dcrit dans the section called
``Personnaliser la manire d'afficher les paquets'', qui est utilise pour
afficher le rsultat d'une recherche en ligne de commande. C'est quivalent 
l'option -F de la ligne de commande.

Option:Aptitude::CmdLine::Package-Display-Width

Valeur par dfaut:

Description: Cette option donne la largeur en caractres avec laquelle les
recherches en ligne de commande doivent tre formates. Une chane vide (la
valeur par dfaut, i.e. "") indique que les rsultats des recherches sont
formats pour la taille du terminal actuel ou pour un affichage de 80 colonnes
si la taille ne peut pas tre dtermine.

Option:Aptitude::CmdLine::Show-Deps

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est  ``true'', aptitude
affichera un rsum des dpendances (s'il y en a) li  l'tat d'un paquet.
C'est quivalent  l'option -D de la ligne de commande.

Option:Aptitude::CmdLine::Show-Versions

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est  ``true'', aptitude
affichera la version d'un paquet qui est sur le point d'tre install ou
supprim. C'est quivalent  l'option -V de la ligne de commande.

Option:Aptitude::CmdLine::Show-Size-Changes

Valeur par dfaut:false

Description: En mode ligne de commande, si cette option est  ``true'', aptitude
affichera les changements attendus dans l'espace disque utilis par chaque
paquet. C'est quivalent  l'option -Z de la ligne de commande.

Option:Aptitude::CmdLine::Simulate

Valeur par dfaut:false

Description: En mode ligne de commande, fait qu'aptitude affiche uniquement les
actions qui seraient effectues sur les paquets (plutt que le faire
rellement). C'est quivalent  l'option -s de la ligne de commande.

Option:Aptitude::CmdLine::Visual-Preview

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude va entrer dans le mode
graphique pour afficher l'aperu du processus d'installation et pour tlcharger
les paquets.

Option:Aptitude::CmdLine::Verbose

Valeur par dfaut:0

Description: Cette option contrle le niveau de verbosit du mode ligne de
commande d'aptitude. Chaque occurence de l'option -v sur la ligne de commande
ajoute 1  cette valeur.

Option:Aptitude::Delete-Unused

Valeur par dfaut:true

Description: Si cette option est mise  true, les paquets automatiquement
installs qui ne sont plus ncessaires seront automatiquement supprims. Pour
plus d'informations, consultez the section called ``Grer les paquets
automatiquement installs''.

Option:Aptitude::Delete-Unused-Pattern

Valeur par dfaut:

Description: Si Aptitude::Delete-Unused est  true, seuls les paquets inutiliss
qui correspondent au motif donn (voir the section called ``Motifs de
recherche'') sont supprims. Si la valeur de cette option est une chane vide
(la valeur par dfaut), tous les paquets inutiliss sont supprims.

Option:Aptitude::Display-Planned-Action

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude affichera un aperu
d'installation avant de rellement excuter les actions que vous avez demandes.

Option:Aptitude::Forget-New-On-Update

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude videra la liste des
nouveaux paquets  chaque fois que la liste des paquets est mise  jour, comme
si vous aviez excut la commande Actions->Oublier les nouveaux paquets (f).

Option:Aptitude::Forget-New-On-Install

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude videra la liste des
nouveaux paquets  chaque fois que vous installez, mettez  jour ou supprimez
des paquets, comme si vous aviez excut la commande Actions->Oublier les
nouveaux paquets (f).

Option:Aptitude::Keep-Suggests

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude gardera les paquets
automatiquement installs sur le systme tant qu'un paquet install les suggre.
Pour plus d'informations, consultez the section called ``Grer les paquets
automatiquement installs''.

Option:Aptitude::Log

Valeur par dfaut:/var/log/aptitude

Description: Si cette option est une chane non-vide, aptitude journalisera les
installations, suppressions et mises  jour de paquets qu'il effectue. Si la
valeur de Aptitude::Log commence par le caractre ``|'', le reste de cette
valeur est utilis comme le nom d'une commande  travers laquelle le journal est
envoy : par exemple, |mail -s 'Aptitude install run' root enverra le journal au
compte root. Pour journaliser dans plusieurs fichiers ou commandes, vous pouvez
configurer cette option sour la forme d'une liste de cibles pour la
journalisation.

Option:Aptitude::Pkg-Display-Limit

Valeur par dfaut:

Description: Le filtre par dfaut s'appliquant  la liste des paquets ;
consultez the section called ``Motifs de recherche'' pour plus de dtails sur
son format.

Option:Aptitude::Recommends-Important

Valeur par dfaut:true

Description: Si cette option est mise  true et Aptitude::Auto-Install est aussi
 true, installer un nouveau paquet induira l'installation de tous les paquets
qu'il recommande.

Option:Aptitude::Suggests-Important

Valeur par dfaut:false

Description: Cette option est obsolte, utilisez Aptitude::Keep-Suggests  la
place. Mettre cette option  true a le mme effet que mettre Aptitude::Keep-
Suggests  true.

Option:Aptitude::Theme

Valeur par dfaut:

Description: Le thme qu'aptitude doit utiliser. Consultez the section called
``Thmes'' pour plus d'informations.

Option:Aptitude::Track-Dselect-State

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude essaiera de dtecter si
un changement a t apport  l'tat du paquet par l'utilisation de dselect ou
dpkg : par exemple, si vous supprimez un paquet avec dpkg, aptitude n'essaiera
pas de le rinstaller. Notez que cela peut ne pas toujours fonctionner
parfaitement.

Option:Aptitude::UI::Advance-On-Action

Valeur par dfaut:false

Description: Si cette option est mise  true, changer l'tat d'un paquet (par
exemple, le marquer pour installation) basculera la mise en surbrillance vers le
prochain paquet dans le groupe courant.

Option:Aptitude::UI::Auto-Show-Reasons

Valeur par dfaut:true

Description: Si cette option est mise  true, slectionner un paquet qui est
cass, ou qui semble tre la cause du cassage d'autres paquets, va entrainer
l'affichage dans la zone d'information des raisons expliquant pourquoi ce paquet
est cass.

Option:Aptitude::UI::Colors

Valeur par dfaut:

Description: C'est un groupe de configuration dont le contenu dfinit le schma
des couleurs d'aptitude. Pour plus d'informations, consultez the section called
``Personnaliser les couleurs''.

Option:Aptitude::UI::Default-Grouping

Valeur par dfaut:filter(missing),status,section(subdir,passthrough),section
(topdir)

Description: Configure la politique de groupement par dfaut utilise pour la
liste des paquets. Consultez the section called ``Personnaliser la hirarchie
des paquets'' pour des informations supplmentaires sur les politiques de
groupement.

Option:Aptitude::UI::Default-Preview-Grouping

Valeur par dfaut:action

Description: Configure la politique de groupement par dfaut utilise pour les
crans d'aperu. Consultez the section called ``Personnaliser la hirarchie des
paquets'' pour des informations supplmentaires sur les politiques de
groupement.

Option:Aptitude::UI::Description-Visible-By-Default

Valeur par dfaut:true

Description: Quand une liste de paquets est affiche pour la premire fois, la
zone d'information (qui contient gnralement la description longue du paquet
courant) sera visible si cette option est mise  true et cache si elle est 
false.

Option:Aptitude::UI::Default-Package-View

Valeur par dfaut:

Description: Cette option est un groupe dont les membres dfinissent l'apparence
par dfaut de l'affichage d'aptitude. Consultez the section called
``Personnaliser la disposition de l'affichage'' pour plus d'informations.

Option:Aptitude::UI::Exit-On-Last-Close

Valeur par dfaut:true

Description: Si cette option est mise  true, fermer toutes les vues actives
quittera aptitude. Sinon, aptitude ne quittera pas avant que vous excutiez la
commande Actions->Quitter (Q). Consultez the section called ``Travailler avec
plusieurs vues'' pour plus d'informations.

Option:Aptitude::UI::Fill-Text

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude formatera les lignes pour
qu'elles occupent exactement la largeur de l'cran.

Option:Aptitude::UI::HelpBar

Valeur par dfaut:true

Description: Si cette option est mise  true, une ligne d'information sur les
raccourcis clavier importants est affiche en haut de l'cran.

Option:Aptitude::UI::Incremental-Search

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude effectuera des recherches
``incrmentales'' : pendant que vous tapez le motif de recherche, il cherchera
le paquet suivant qui correspond  ce que vous avez tap jusque l.

Option:Aptitude::UI::Keybindings

Valeur par dfaut:

Description: C'est un groupe de configuration dont les membres dfinissent les
relations entre squences de touches et commandes dans aptitude. Pour plus
d'informations, consultez the section called ``Personnaliser les raccourcis
clavier''.

Option:Aptitude::UI::Menubar-Autohide

Valeur par dfaut:false

Description: Si cette option est mise  true, la barre de menu sera cache
lorsqu'elle ne sera pas utilise.

Option:Aptitude::UI::Minibuf-Download-Bar

Valeur par dfaut:false

Description: Si cette option est mise  true, aptitude utilisera un mcanisme
plus discret pour afficher la progression des tlchargements : une barre en bas
de l'cran apparatra pour afficher l'tat actuel du tlchargement. Pendant que
le tlchargement est actif, appuyer sur q l'arrtera.

Option:Aptitude::UI::Minibuf-Prompts

Valeur par dfaut:false

Description: Si cette option est mise  true, certaines questions (comme les
questions oui/non ou  choix multiples) seront affiches en bas de l'cran
plutt que dans une bote de dialogue.

Option:Aptitude::UI::New-Package-Commands

Valeur par dfaut:true

Description: Si cette option est mise  false, des commandes comme Paquet-
>Installer (+) auront le comportement dpass qu'elles avaient dans d'anciennes
versions d'aptitude.

Option:Aptitude::UI::Package-Display-Format

Valeur par dfaut:%c%a%M %p %Z %v %V

Description: Cette option contrle la chane de format utilise pour afficher
les paquets dans les listes de paquets. Pour plus d'informations sur les chanes
de format, consultez the section called ``Personnaliser la manire d'afficher
les paquets''.

Option:Aptitude::UI::Package-Header-Format

Valeur par dfaut:%N %n

Description: Cette option contrle la chane de format utilise pour afficher la
ligne d'en-tte de la liste des paquets (c'est--dire la ligne qui apparat
entre la liste de paquets et la barre de menu). Pour plus d'informations sur les
chanes de format, consultez the section called ``Personnaliser la manire
d'afficher les paquets''.

Option:Aptitude::UI::Package-Status-Format

Valeur par dfaut:%d

Description: Cette option contrle la chane de format utilise pour afficher la
ligne d'tat de la liste des paquets (c'est--dire la ligne qui apparat entre
la liste de paquets et la zone d'information). Pour plus d'informations sur les
chanes de format, consultez the section called ``Personnaliser la manire
d'afficher les paquets''.

Option:Aptitude::UI::Pause-After-Download

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude affichera un message
aprs avoir fini de tlcharger les paquets, vous demandant si vous souhaitez
continuer l'installation. Dans le cas contraire (option mise  false), il
commencera automatiquement l'installation des paquets.

Option:Aptitude::Preview-Limit

Valeur par dfaut:

Description: Le filtre par dfaut appliqu  l'cran d'aperu d'installation.
Consultez the section called ``Motifs de recherche'' pour plus de dtails
concernant son format.

Option:Aptitude::UI::Prompt-On-Exit

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude affichera une demande de
confirmation avant de quitter.

Option:Aptitude::Warn-Not-Root

Valeur par dfaut:true

Description: Si cette option est mise  true, aptitude dtectera quand vous avez
besoin des privilges d'administration et vous demandera si vous souhaitez
passer sous le compte administrateur (root) si vous ne l'tes pas dj.
Consultez the section called ``Devenir administrateur ( root )'' pour plus
d'informations.


Thmes

Dans aptitude, un thme est juste une runion d'options de configuration. Les
thmes sont utiliss pour venir recouvrir les valeurs par dfaut de certaines
options. Si une option n'est pas configure dans le fichier de configuration du
systme ou dans votre fichier de configuration personnel, aptitude utilisera les
valeurs des options provenant du thme actuel, s'il y en a un de disponible,
avant d'utiliser les valeurs par dfaut standards.

Un thme est simplement un groupe nomm sous Aptitude::Themes dont chaque option
de configuration qu'il contient recouvrira l'option correspondante de la
configuration globale. Par exemple, si le thme Dselect est slectionn,
l'option Aptitude::Themes::Dselect::Aptitude::UI::Package-Display-Format
recouvrira la valeur par dfaut de l'option Aptitude::UI::Package-Display-
Format.

Pour slectionner un thme, donner le nom du thme  la valeur de l'option de
configuration d'Aptitude::Theme. Par exemple :

Aptitude::Theme Vertical-Split;

Les thmes suivants sont fournis avec aptitude dans /usr/share/aptitude/
aptitude-defaults :



  Dselect
      Ce thme donne  aptitude une apparence et un comportement proche du
      vnrable gestionnaire de paquet dselect :

       Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
      f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr.
      Pqts
      --\ Paquets installs
        --\ Priorit : ncessaire
          --\ base - Le systme de base Debian
      c   base  base-file 3.1         3.1         Debian base system
      miscellaneous fil
      c   base  base-pass 3.5.7       3.5.7       Debian base system master
      password a
      c   base  bash      3.0-5       3.0-5       The GNU Bourne Again SHell
      c   base  bsdutils  1:2.12-7    1:2.12-7    Basic utilities from 4.4BSD-
      Lite
      c   base  coreutils 5.2.1-2     5.2.1-2     The GNU core utilities
      c   base  debianuti 2.8.4       2.8.4       Miscellaneous utilities
      specific to
      c   base  diff      2.8.1-6     2.8.1-6     File comparison utilities
      base-files                      install  ; aucun
      ncessair
      This package contains the basic filesystem hierarchy of a Debian system,
      and
      several important miscellaneous files, such as /etc/debian_version,
      /etc/host.conf, /etc/issue, /etc/motd, /etc/profile, /etc/nsswitch.conf,
      and
      others, and the text of several common licenses in use on Debian systems.







  Vertical-Split
      Ce thme arrange l'affichage de manire  ce qu'au lieu d'avoir la
      description du paquet courant en dessous de la liste des paquets, elle
      s'affiche  droite de la liste des paquets. Ce thme est utile dans des
      terminaux trs larges, et peut-tre aussi lors de l'dition de la
      hirarchie des paquets intgre.

       Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
      f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr.
      Pqts
      aptitude 0.2.15.6
      --\ Paquets installs                   Modern computers support the
      Advanced  #
        --\ admin - Utilitaires d'administrat Configuration and Power Interface
          --\ main - L'archive principale de  (ACPI) to allow intelligent power
      i   acpid         1.0.3-19   1.0.3-19   management on your system and to
      query
      i   alien         8.44       8.44       battery and configuration status.
      i   anacron       2.3-9      2.3-9
      i   apt-show-vers 0.07       0.07       ACPID is a completely flexible,
      totally
      i A apt-utils     0.5.25     0.5.25     extensible daemon for delivering
      ACPI
      i   apt-watch     0.3.2-2    0.3.2-2    events. It listens on a file
      i   aptitude      0.2.14.1-2 0.2.14.1-2 (/proc/acpi/event) and when an
      event
      i   at            3.1.8-11   3.1.8-11   occurs, executes programs to
      handle the
      i   auto-apt      0.3.20     0.3.20     event. The programs it executes
      are
      i   cron          3.0pl1-83  3.0pl1-83  configured through a set of
      i   debconf       1.4.29     1.4.29     configuration files, which can be
      i   debconf-i18n  1.4.29     1.4.29     dropped into place by packages or
      by
      i A debootstrap   0.2.39     0.2.39     the admin.
      i A deborphan     1.7.3      1.7.3
      i   debtags       0.16       0.16       In order to use this package you
      need a
      i A defoma        0.11.8     0.11.8     recent Kernel (=>2.4.7). This can
      be
      i   discover      2.0.4-5    2.0.4-5    one including the patches on
      Utilities for using ACPI power management



Jouer au dmineur

Au cas o vous seriez fatigu d'installer et supprimer des paquets, aptitude
inclut une version du jeu classique ``dmineur''. Pour le lancer, slectionner
Actions->Jouer au dmineur. Le plateau initial du dmineur apparatra alors :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
Dmineur                                                10/10 mines  13 secondes





                                   +--------+
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   +--------+





 l'intrieur du rectangle qui apparat  l'cran sont caches dix mines. Votre
but est de dterminer, grce  votre intuition, votre logique et la chance, o
ces mines se trouvent sans en faire exploser une seule ! Pour ce faire, vous
devez dcouvrir toutes les cases qui ne contiennent pas de mines. Ce faisant,
vous aller obtenir des informations importantes concernant les cases qui
contiennent des mines. Attention tout de mme, dcouvrir une case qui contient
une mine la fera exploser, mettant fin au jeu immdiatement !

Pour dcouvrir une case (et savoir si une mine y est cache), slectionnez la
case avec les flches et appuyer sur Entre :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
Dmineur                                                10/10 mines 387 secondes





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |    1...|
                                   | 1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Comme vous pouvez le voir, une partie de la zone cache (vide) du plateau a t
rvle dans cette capture d'cran. Les cases contenant un . sont les cases qui
ne sont adjacentes  aucune mine. Les chiffres dans les autres cases indiquent
combien de mines il y a dans les cases adjacentes.

Si vous pensez savoir o une mine se trouve, vous pouvez placer un drapeau sur
celle-ci. Pour faire cela, slectionner la case suspecte et appuyer sur f. Par
exemple, dans la capture suivante, j'ai dcid que la case sur la partie gauche
de l'cran avait l'air suspecte...

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
Dmineur                                                9/10 mines 961 secondes





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |    1...|
                                   |F1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Comme vous pouvez le voir, un F est apparu sur la case slectionne. Il n'est
plus possible de dcouvrir cette case, mme accidentellement, jusqu' ce que le
drapeau soit enlev (en appuyant  nouveau sur f). Une fois que vous avez plac
un drapeau sur toutes les mines qui sont  ct d'une case (par exemple, les
cases avec un 1  ct du drapeau au dessus), pour pouvez ``faire le mnage''
autour de la case. Ce n'est qu'une facilit pour dcouvrir toutes les cases
adjacentes ( l'exception de celles contenant un drapeau, bien sr). Par
exemple, faisons le mnage autour du 1 ci-dessus :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
Dmineur                                                9/10 mines 2290 secondes





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |221 1...|
                                   |F1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Heureusement, ma supposition sur l'emplacement de cette mine tait bon. Si
j'avais eu tort, j'aurais perdu immdiatement :

 Actions  Dfaire  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M--J  g : Tlch./Inst./Suppr. Pqts
Dmineur                                         Dmineur Perdu en 3878 secondes






                                   +--------+
                                   |^2......|
                                   |^2111...|
                                   |221^1...|
                                   |^1111...|
                                   |11...111|
                                   |...113^ |
                                   |1122* ^ |
                                   | ^ ^   ^|
                                   +--------+





Quand vous avez perdu, l'emplacement de toutes les mines est rvl : les mines
non exploses sont indiques par un accent grave (^), et celle sur laquelle vous
avez ``march'' est indique par une asterisque (*).



--------------------------------------------------------------------------------
[6]Cela est parfois appel ``processus d'installation'', mme s'il se peut que
vous mettiez  jour ou supprimiez des paquets en plus d'en installer.

[7] Plus prcisment, ils seront supprims quand il n'y aura plus de chemin via
les champs Dpend, Pr-Dpend ou Recommande pour les atteindre depuis un paquet
install manuellement. Si Aptitude::Keep-Suggests est vrai ( true ), une
relation Suggre est alors suffisante pour qu'un paquet soit conserv.

[8] Les caractres spciaux des expressions rationnelles sont ``+'', ``-'',
``.'', ``('', ``)'', ``|'', ``['', ``]'', ``^'', ``$'' et ``?''. Remarquez que
certains de ceux-ci sont aussi des caractres spciaux d'aptitude, donc si vous
voulez, par exemple, taper un ``|'' littral, il vous faudra, le dspcialiser
deux fois comme cela : ``\~|''.

[9] C'est principalement fourni par symtrie avec ~T.

[10]Actuellement l'tiquetage n'est pas gr, cette commande est destine  un
usage futur.

[11] Jaune qui devient marron sur certains terminaux quand c'est la couleur
d'arrire-plan.


Chapter 3. FAQ d'aptitude


  ``Quel .... est ton nom ?''                                              

  ``Arthur, roi des Anglais.''

  ``Quelle ... est ta qute ?''

  ``Je cherche le Saint Graal !''

  ``Quelle ... la vitesse d'un moineau  vide ?''

  ``Qu'est-ce que vous voulez dire ? Un moineau d'Afrique ou d'Europe ?''

  ``Euh ? Je ... je n'sais pa--AAAAAAAS !''

                                               -- Monty Python, sacr Graal




  3.1. Comment puis-je trouver un paquet par son nom exact ?

  3.2. Comment puis-je trouver les paquets casss ?

  3.3. Je veux slectionner du texte avec la souris, pourquoi aptitude ne me
  laisse-t-il pas faire ?


3.1. Comment puis-je trouver un paquet par son nom exact ?

     Comme signal dans the section called ``Motifs de recherche'', quand vous
     recherchez un paquet par son nom, le texte que vous tapez est en fait un
     expression rationnelle. Donc, le motif de recherche ``^nom$'' correspondra
     uniquement au paquet nomm nom.

     Par exemple, vous pouvez rechercher apt (mais pas aptitude ou synaptic) en
     tapant ^apt$. Vous pouvez rechercher g++ (mais pas g++-2.95 ou g++-3.0) en
     tapant ^g\+\+$.

3.2. Comment puis-je trouver les paquets casss ?

     Utiliser la commande Rechercher->Rechercher casss (b).

3.3. Je veux slectionner du texte avec la souris, pourquoi aptitude ne me
     laisse-t-il pas faire ?

     Quand un programme lanc dans un xterm utilise la souris, l'xterm dsactive
     la slection de texte. Nanmoins, vous pouvez passer outre ce comportement
     et faire une slection en gardant la touche Maj enfonce.



Chapter 4. Crdits


  Personne ne se rappelle du chanteur. La chanson reste.  

                      -- Terry Pratchett, Le dernier hros


Cette section garde le souvenir des personnes qui ont contribu  aptitude un
jour ou l'autre.


 [Note]  Note

         Cette section est pour le moment plutt incomplte et sera
         vraisemblablement mise  jour et tendue au fur et  mesure (en
         particulier, il manque de nombreux crdits pour les traducteurs du fait
         du grand nombre des sources de traduction [12]). Si vous penser que
         vous devriez tre dans cette liste, envoyer, s'il vous plat, un
         courriel  <dburrows@debian.org> avec la raison de cette demande.


Traduction et internationalisation



  Traduction brsilienne
      Andre Luis Lopes, Gustavo Silva


  Traduction chinoise
      Carlos Z.F. Liu


  Traduction tchque
      Miroslav Kure


  Traduction danoise
      Morten Brix Pedersen, Morten Bo Johansen


  Traduction nerlandaise
      Luk Claes


  Traduction finnoise
      Jaakko Kangasharju


  Traduction franaise
      Martin Quinson, Jean-Luc Coulon


  Traduction allemande
      Sebastian Schaffert, Erich Schubert, Sebastian Kapfe


  Traduction italienne
      Danilo Piazzalunga


  Traduction japonaise
      YasuoEto


  Traduction lituanienne
      Darius &#381;itkevicius


  Traduction polonaise
      Michal Politowski


  Traduction portugaise
      Nuno Snica, Miguel Figueiredo


  Traduction norvgienne
      Hvard Korsvoll


  Traduction espagnole
      Jordi Malloch, Ruben Porras


  Correctif initial d'internationalisation (i18n)
      Masato Taruishi


  Maintenance et tri de l'i18n
      Christian Perrier


Documentation



  Manuel de l'utilisateur
      Daniel Burrows


Programmation



  conception et mise en &#339;uvre du programme
      Daniel Burrows




--------------------------------------------------------------------------------
[12] Il devrait tre possible de crer une liste plutt complte des
contributeurs de l'internationalisation en se basant sur le ChangeLog via ses
rfrences au systme de gestion des bogues Debian et aux rvisions de
l'historique d'aptitude, mais cela demanderait un norme investissement en temps
qui n'est pas possible actuellement.



Rfrence de la ligne de commande d'aptitude

--------------------------------------------------------------------------------
Table of Contents



  aptitude - interface volue pour le gestionnaire de paquets.


Name

aptitude --; interface volue pour le gestionnaire de paquets.


Synopsis

aptitude [ options ...] { autoclean | clean | forget-new | update | upgrade }

aptitude [ options ...] { dist-upgrade | download | forbid-version | hold |
markauto | purge | reinstall | remove | show | unmarkauto } paquets ...

aptitude [ options ...] search motifs ...

aptitude [ -S fname ] [ -u | -i ]

aptitude help


Description

aptitude est une interface en mode texte pour le gestionnaire de paquets de
Debian GNU/Linux.

Elle permet  l'utilisateur de connatre la liste des paquets, et de raliser
des tches d'administration comme l'installation, la mise  jour ou l'effacement
de paquets. Ces tches peuvent tre ralises en mode  interactif  ou  partir
de la  ligne de commande .


Commandes en ligne de commande

Le premier argument qui ne commence pas par un tiret ( - ) sera considr
comme tant la commande que le programme doit raliser. Si aucune commande n'est
donne, aptitude dmarrera en mode interactif.

Commandes disponibles :



  install
      Installe un ou plusieurs paquets. Les paquets doivent tre numrs aprs
      la commande  install  ; si le nom d'un paquet contient un tilde, il sera
      considr comme un motif de recherche, et tout paquet correspondant  ce
      motif sera install (voir la section ``Motifs de recherche'' dans le
      manuel de rfrence d'aptitude).

      Pour selectionner une version prcise d'un paquet, ajoutez  =version  au
      nom du paquet : par exemple,  aptitude install apt=0.3.1 . De la mme
      faon, pour choisir un paquet d'une archive prcise, ajoutez  /archive 
      au nom du paquet : par exemple,  aptitude install apt/experimental .

      L'ajout de  - ,  + ,  _ , ou  =  au nom d'un paquet entranera
      respectivement sa suppression, son installation, sa purge, ou son gel. 
      utiliser pour raliser plusieurs actions en une seule ligne de commande,
      par exemple.

      Cas particulier,  install  sans autre argument rsoudra les commandes en
      suspens ou diffres.


       [Note]  Note

               La commande  install  modifie les informations enregistes sur
               les actions qu'aptitude doit raliser. De ce fait, si vous lancez
               la commande  aptitude install toto titi  puis que vous annulez
               l'installation, vous devrez lancer (par exemple)  aptitude
               remove toto titi  pour l'annuler.



  remove, purge, hold, reinstall
      Ces commandes fonctionnent comme  install , en excutant l'action
      demande sur tous les paquets si rien d'autre n'est indiqu.

      Par exemple,  aptitude remove '~ndeity'  supprimera tous les paquets
      dont le nom contient  deity ).


  markauto, unmarkauto
      Indique que les paquets ont t respectivement installs automatiquement,
      ou  la main. Vous pouvez choisir les paquets grce  la syntaxe vue plus
      haut, et mme indiquer les commandes  raliser. Par exemple,  aptitude
      markauto '~slibs'  marquera tous les paquets de la section  libs  comme
      ayant t installs automatiquement.

      Pour plus d'informations sur les paquets installs automatiquement,
      consultez la section ``Grer les paquets automatiquement installs'' dans
      le manuel de rfrence d'aptitude.


  forbid-version
      Empche la mise  jour vers une version prcise d'un paquet. Cette option
      interdit  aptitude la mise  jour automatique vers cette version, mais
      permettra le passage aux versions suivantes. Par dfaut, aptitude choisira
      la version vers laquelle ce paquet aurait normalement d tre mis  jour.
      Vous pouvez modifier ce choix en ajoutant  =version  au nom du paquet :
      par exemple,  aptitude forbid-version vim=1.2.3.broken-4 .

      Cette commande est pratique pour viter les versions bogues des paquets
      sans avoir  dfinir ou supprimer des gels  la main. Si vous dcidez
      finalement d'installer la version que vous aviez interdite, la commande
       install  mettra fin  l'interdiction.


  update
      Met  jour la liste des paquets disponibles sur les serveurs matres.
      (C'est l'quivalent de  apt-get update ).


  upgrade
      Met les paquets installs  jour, avec leur version la plus rcente. Les
      paquets installs ne seront pas retirs, sauf si ils sont inutiliss.
      (voir la section ``Grer les paquets automatiquement installs'' dans le
      manuel de rfrence d'aptitude).Les paquets qui ne sont pas actuellement
      prsents ne seront pas installs.

      Si un paquet ne peut tre mis  jour sans enfreindre ces contraintes, il
      restera dans son tat actuel.


  forget-new
      Ignore les  nouveaux  paquets (quivaut  presser  f  en mode
      interactif).


  search
      Recherche les paquets qui correspondent  un ou plusieurs motifs donns
      sur la ligne de commande. Tous les paquets correspondant aux expressions
      demandes seront affichs. Par exemple,  aptitude search '~N'  affichera
      tous les  nouveaux  paquets. Les expressions de recherche sont
      expliques en dtail dans ``Motifs de recherche'' dans le manuel de
      rfrence d'aptitude).


  show
      Afficher des informations dtailles sur un ou plusieurs paquets dont les
      noms sont indiqus aprs la commande search. Si un nom de paquet contient
      un caractre tilde, il sera alors trait comme un motif de recherche, et
      tous les paquets correspondants seront affichs (voir la section ``Motifs
      de recherche'' dans le manuel de rfrence d'aptitude).


  clean
      Supprime tous les paquets .deb tlchargs et enregistrs dans le
      rpertoire cache (normalement /var/cache/apt/archives).


  autoclean
      Supprime tout paquet enregistr dans le cache et qui n'est plus propos au
      tlchargement. Cela vous permet d'empcher que le cache ne grossisse
      dmesurment avec le temps, sans avoir  le vider compltement.


  download
      Tlcharge le fichier .deb de la version la plus rcente du paquet, et le
      range dans le rpertoire courant.


  help
      Affiche un bref rsum des commandes et options disponibles.



Options

Les options qui suivent peuvent tre utilises afin de modifier le comportement
des commandes ci-dessus. Remarquez que les commandes ne vont pas toutes ragir 
chaque option (en effet, certaines options n'ont aucun sens pour certaines
commandes).



  -D, --show-deps
      Affiche un bref rsum sur la raison pour laquelle des paquets vont tre
      automatiquement installs ou supprims.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Deps.


  -d, --download-only
      N'installe ni ne supprime aucun paquet. Tlcharge simplement les paquets
      ncessaires dans le cache.

      Directive du fichier de configuration : Aptitude::CmdLine::Download-Only.


  -F format, --display-format format
      Dfinit le format qui sera utilis pour afficher les rsultats de la
      commande search. Par exemple,  %p %V %v  affichera le nom du paquet,
      suivi du numro de la version installe, ainsi que les versions
      disponibles. Pour plus d'informations, consultez la section
      ``Personnaliser la manire d'afficher les paquets'' dans le manuel de
      rfrence d'aptitude.

      Directive du fichier de configuration : Aptitude::CmdLine::Package-
      Display-Format.


  -f
      Essaye tmrairement de rsoudre les dpendances des paquets corrompus.

      Directive du fichier de configuration : Aptitude::CmdLine::Fix-Broken.


  -h, --help
      Affiche un court message d'aide. Identique  l'action help.


  -P, --prompt
      Affiche toujours une invite de commande, mme si aucune autre commande que
      celles explicitement demandes n'est entreprise.

      Directive du fichier de configuration : linkend="configcmdline-always-
      prompt">Aptitude::CmdLine::Always-Prompt.


  -R, --without-recommends
      Ne gre pas les recommandations ou les suggestions comme si elles taient
      des dpendances lors de l'installation de nouveaux paquets (prioritaire
      sur les rglages de /etc/apt/apt.conf and ~/.aptitude/config).

      Directive du fichier de configuration : Aptitude::Recommends-Important


  -r, --with-recommends
      Traite les suggestions ou les recommandations en tant que dpendances lors
      de l'installation des nouveaux paquets. (Prioritaire sur les rglages de /
      etc/apt.conf et ~/.aptitude/config).

      Directive du fichier de configuration : Aptitude::Recommends-Important


  -s, --simulate
      Affiche la liste des actions qui seraient ralises, mais ne les lance pas
      rellement. Il n'est pas ncessaire d'avoir les privilges
      d'administration.

      Directive du fichier de configuration : Aptitude::CmdLine::Simulate.


  -t version, --target-release version
      Dfinit la version  partir de laquelle les paquets devront tre
      installs. Par exemple,  aptitude -t exprimental ...  installera les
      paquets de la distribution exprimentale, si rien d'autre n'est prcis.

      Directive du fichier de configuration : APT::Default-Release.


  -O ordre, --sort ordre
      Dfinit l'ordre dans lequel le rsultat de la commande search doit tre
      affich. Par exemple,  installsize  triera les paquets dans l'ordre
      croissant de la taille de leur installation. Pour plus d'informations,
      consultez le chapitre ``Personnaliser la manire de trier les paquets''
      dans le manuel de rfrence d'aptitude.


  -o clef=valeur
      Dfinit une option du fichier de configuration  la vole. Utilisez par
      exemple -o Aptitude::Log=/tmp/mes-logs afin de consigner (logs) les
      vnements d'aptitude dans le fichier /tmp/mes-logs. Pour plus
      d'informations sur les options du fichier de configuration, consultez le
      chapitre ``Rfrence du fichier de configuration'' dans le manuel de
      rfrence d'aptitude.


  -V, --show-versions
      Indique quelle versions du paquet sera installe.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Versions.


  -v, --verbose
      Force quelques commandes (show par exemple)  afficher des informations
      supplmentaires. Peut tre invoqu plusieurs fois afin d'obtenir des
      informations de plus en plus compltes.

      Directive du fichier de configuration : Aptitude::CmdLine::Verbose.


  --version
      Affiche la version et quelques informations sur l'environnement de
      compilation d'aptitude.


  --visual-preview
      Lance l'interface visuelle et affiche l'cran d'accueil, plutt que
      d'afficher l'habituelle invite de commande en ligne.


  -w largeur, --width largeur
      Dfinit la largeur utilise pour l'affichage du rsultat de la commande
      search. (Par dfaut, c'est la largeur du terminal).

      Directive du fichier de configuration : Aptitude::CmdLine::Package-
      Display-Width


  -y, --assume-yes
      Rpond  oui   toute question de type oui/non. En fait, cette option
      supprime l'invite (le prompt) qui apparat quand on installe, met  jour
      ou supprime des paquets. N'affecte pas les rponses aux questions
      particulirement dangereuses, telles que la suppression des paquets
      essentiels. A priorit sur -P.

      Directive du fichier de configuration : Aptitude::CmdLine::Assume-Yes.


  -Z
      Affiche l'espace disque qui sera utilis ou libr par chacun des paquets
       installer, mettre  jour ou supprimer.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Size-
      Changes.


Les options suivantes s'appliquent au mode visuel du programme. Toutefois, elles
ne sont utilises qu'en interne. Normalement, vous n'en aurez pas besoin.



  -S nom-fichier
      Charge les informations supplmentaires  partir de nom-fichier plutt
      qu' partir du fichier standard.


  -u
      Lance la mise  jour de la liste des paquets ds le dmarrage du
      programme. On ne peut pas se servir en mme temps de cette option et de -
      i.


  -i
      Affiche l'cran de tlchargement au dmarrage du programme (quivalent au
      lancement du programme, puis  l'appui sur  g ). On ne peut pas se
      servir en mme temps de cette option et de -u.



Voir aussi

apt-get(8), apt(8), /usr/share/doc/aptitude/html/index.html

