" Vim syntax file
" Language:	Debian sources.list
" Maintainer:	Matthijs Mohlmann <matthijs@cacholong.nl>
" Last Change:	$Date: 2005/08/13 11:51:26 $
" URL: http://www.cacholong.nl/~matthijs/vim/syntax/debsources.vim
" $Revision: 1.4 $

" this is a very simple syntax file - I will be improving it
" add entire DEFINE syntax

" Standard syntax initialization
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" case sensitive
syn case match

" deb-src is a keyword
setlocal iskeyword+=-

" A bunch of useful keywords
syn keyword sourcesKeyword      deb deb-src
syn keyword sourcesKeyword      main contrib non-free restricted universe multiverse

" Match comments
syn match sourcesComment        /#.*/

" Match uri's
syn match sourcesUri            +\(http://\|ftp://\|file:///\)[^' 	<>"]\++
syn match sourcesDistrKeyword   +\([[:alnum:]_./]*\)\(woody\|sarge\|etch\|old-stable\|stable\|testing\|unstable\|sid\|experimental\|warty\|hoary\|breezy\|dapper\|edgy\)\([[:alnum:]_./]*\)+

" Associate our matches and regions with pretty colours
if version >= 508 || !exists("did_debsources_syn_inits")
  if version < 508
    let did_debchangelog_syn_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink sourcesLine            Error
  HiLink sourcesKeyword         Statement
  HiLink sourcesDistrKeyword    Type
  HiLink sourcesComment         Comment
  HiLink sourcesUri             Constant

  delcommand HiLink
endif

let b:current_syntax = "debsources"

" vim: ts=8
