#! /bin/sh
### BEGIN INIT INFO
# Provides:          checkfs
# Required-Start:    modutils checkroot
# Required-Stop:
# Should-Start:      lvm cryptdisks
# Should-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Check all filesystems.
### END INIT INFO
#
# Version:	@(#)checkfs  2.85-13  22-Mar-2004  miquels@cistron.nl
#

[ -z "$FSCKFIX" ] && FSCKFIX=no
[ -f /etc/default/rcS ] && . /etc/default/rcS
. /lib/lsb/init-functions
. /lib/init/functions.sh

do_start () {
    # See if we're on AC Power
    # If not, we're not gonna run our check
    if [ -x /usr/bin/on_ac_power ]; then
        /usr/bin/on_ac_power >/dev/null 2>&1
        if [ $? -eq 1 ]; then
            log_success_msg "On battery, not fscking!"
            ac=no
        fi
    fi

    #
    # Check the rest of the file systems.
    #
    if [ ! -f /fastboot ] && [ -z "$ac" ]
    then
        if [ -f /forcefsck ]
        then
            force="-f"
        else
            force=""
        fi
        if [ "$FSCKFIX"  = yes ]
        then
    	fix="-y"
        else
    	fix="-a"
        fi
        spinner="-C"
        case "$TERM" in
    	dumb|network|unknown|"") spinner="" ;;
        esac
        [ `uname -m` = s390 ] && spinner="" # This should go away
	log_action_begin_msg "Checking all filesystems"
	fsck $spinner -T -R -A $fix $force
        if [ $? -gt 1 ]
        then
		log_action_end_msg "$?" || true
		log_failure_msg "File system check failed.  Please repair manually."
		log_failure_msg "CONTROL-D will exit from this shell and continue system startup."
		# Start a single user shell on the console
		/sbin/sulogin $CONSOLE
	else
		log_action_end_msg 0
        fi
    fi
    rm -f /fastboot /forcefsck
}

case "$1" in
    start)
        do_start
        ;;
    restart|reload|force-reload)
        echo "Error: argument '$1' not supported" >&2
        exit 3
        ;;
    stop)
        ;;
    *)
        echo "Usage: $0 start|stop" >&2
        exit 3
        ;;
esac

: exit 0
