#! /bin/sh
# /etc/init.d/procps: Set kernel variables from /etc/sysctl.conf
#
# written by Elrond <Elrond@Wunder-Nett.org>

### BEGIN INIT INFO
# Provides:          procps
# Required-Start:    mountvirtfs
# Required-Stop: 
# Default-Start:     S 1 2 3 4 5
# Default-Stop:      0 6
### END INIT INFO


# Check for existance of the default file and exit if not there,
# Closes #52839 for the boot-floppy people
[ -r /etc/default/rcS ] || exit 0
. /etc/default/rcS
. /lib/lsb/init-functions


PATH=/sbin:$PATH
which sysctl > /dev/null || exit 0

case "$1" in
       start|reload|restart|force-reload)
               if [ ! -r /etc/sysctl.conf ]
               then
                       exit 0
               fi
               if [ "$VERBOSE" = "yes" ]
               then
	               quiet=""
		       log_begin_msg "Setting kernel variables..."
               else
	       	       quiet="-q"
               fi
               sysctl $quiet -p
               if [ "$VERBOSE" = "yes" ]
               then
		       log_end_msg $?
		fi
               ;;
       stop|show)
               ;;
       *)
	       log_success_msg "Usage: /etc/init.d/procps.sh {start|stop|reload|restart}" >&2
               exit 1
               ;;
esac


