#!/bin/bash
#  Copyright (C) 2000-2007 SWsoft. All rights reserved.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# This script configure IP alias(es) inside Gentoo like VE.
#
# Parameters are passed in environment variables.
# Required parameters:
#   IP_ADDR       - IP address(es) to add
#                   (several addresses should be divided by space)
# Optional parameters:
#   VE_STATE      - state of VE; could be one of:
#                     starting | stopping | running | stopped
#   IPDELALL	  - delete all old interfaces
#
VENET_DEV=venet0


IFCFG_DIR=/etc/conf.d
IFCFG=${IFCFG_DIR}/net

SCRIPT=/etc/runlevels/default/net.${VENET_DEV}

HOSTFILE=/etc/hosts

function fix_net()
{
	[ -f "${SCRIPT}" ] && return 0
	rc-update del net.eth0 &>/dev/null
	ln -sf /etc/init.d/net.lo /etc/init.d/net.${VENET_DEV}
	rc-update add net.lo boot &>/dev/null
	rc-update add net.${VENET_DEV} default &>/dev/null
	if ! grep -qe "^config_eth" ${IFCFG} 2>/dev/null; then
		return 0
	fi
	cp -pf ${IFCFG} ${IFCFG}.$$ || error "Unable to copy ${IFCFG}"
	sed -e 's/^config_eth/#config_eth/' -e 's/^routes_eth/#routes_eth/' < ${IFCFG} > ${IFCFG}.$$ && mv -f ${IFCFG}.$$ ${IFCFG} 2>/dev/null
	if [ $? -ne 0 ]; then
		rm -f ${IFCFG}.$$ 2>/dev/null
		error "Unable to create ${IFCFG}"
	fi
}

function setup_network()
{
	fix_net
	put_param3 ${IFCFG} "config_${VENET_DEV}" ""
	# add fake route
	put_param3 ${IFCFG} "routes_${VENET_DEV}" \
		"-net ${FAKEGATEWAYNET}/24" # dev ${VENET_DEV}
	add_param3 ${IFCFG} "routes_${VENET_DEV}" "default via ${FAKEGATEWAY}"
	# Set up /etc/hosts
	if [ ! -f ${HOSTFILE} ]; then
		echo "127.0.0.1 localhost.localdomain localhost" > $HOSTFILE
	fi
}

function add_ip()
{
	local ip
	local new_ips

	# In case we are starting VE
	if [ "x${VE_STATE}" = "xstarting" ]; then
		setup_network
	fi

	if [ "x${IPDELALL}" = "xyes" ]; then
		put_param3 "${IFCFG}" "config_${VENET_DEV}" ""
	fi

	for ip in ${IP_ADDR}; do
		grep -qw "config_${VENET_DEV}=\(.*\"${ip}[\"\/].*\)" ${IFCFG} || \
			add_param3 "${IFCFG}" "config_${VENET_DEV}" "${ip}/32"
	done

	if [ "x${VE_STATE}" = "xrunning" ]; then
		# synchronyze config files & interfaces
		/etc/init.d/net.${VENET_DEV} restart 
	fi
}

add_ip
exit 0
# end of script
