// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (C) 2013-2016 Canonical Ltd.

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _OXIDE_QT_CORE_GLUE_WEB_VIEW_PROXY_H_
#define _OXIDE_QT_CORE_GLUE_WEB_VIEW_PROXY_H_

#include <QByteArray>
#include <QImage>
#include <QList>
#include <QPoint>
#include <QSize>
#include <QString>
#include <QtGlobal>
#include <QUrl>

#include "qt/core/api/oxideqglobal.h"
#include "qt/core/glue/edit_capability_flags.h"
#include "qt/core/glue/oxide_qt_proxy_base.h"
#include "qt/core/glue/web_contents_id.h"

class OxideQNewViewRequest;
class OxideQWebPreferences;

namespace oxide {
namespace qt {

class AuxiliaryUIFactory;
class ContentsViewClient;
class ScriptMessageHandlerProxy;
class WebContextProxy;
class WebFrameProxy;
class WebViewProxyClient;
class WebView;

enum ContentTypeFlags {
  CONTENT_TYPE_NONE = 0,
  CONTENT_TYPE_MIXED_DISPLAY = 1 << 0,
  CONTENT_TYPE_MIXED_SCRIPT = 1 << 1
};

enum RestoreType {
  RESTORE_LAST_SESSION_EXITED_CLEANLY,
  RESTORE_LAST_SESSION_CRASHED,
  RESTORE_CURRENT_SESSION,
};

enum WebProcessStatus {
  WEB_PROCESS_RUNNING,
  WEB_PROCESS_KILLED,
  WEB_PROCESS_CRASHED,
  WEB_PROCESS_UNRESPONSIVE
};

enum EditingCommands {
  EDITING_COMMAND_UNDO,
  EDITING_COMMAND_REDO,
  EDITING_COMMAND_CUT,
  EDITING_COMMAND_COPY,
  EDITING_COMMAND_PASTE,
  EDITING_COMMAND_ERASE,
  EDITING_COMMAND_SELECT_ALL
};

class OXIDE_QTCORE_EXPORT WebViewProxy : public ProxyBase<WebView> {
 public:
  static WebViewProxy* create(
      WebViewProxyClient* client, // Must outlive returned proxy
      ContentsViewClient* view_client, // Must outlive returned proxy
      AuxiliaryUIFactory* aux_ui_factory, // Must outlive returned proxy
      QObject* handle,
      QObject* context,
      bool incognito,
      const QByteArray& restore_state,
      RestoreType restore_type);
  static WebViewProxy* create(WebViewProxyClient* client,
                              ContentsViewClient* view_client,
                              AuxiliaryUIFactory* aux_ui_factory,
                              QObject* handle,
                              OxideQNewViewRequest* new_view_request,
                              OxideQWebPreferences* initial_prefs);

  virtual ~WebViewProxy();

  virtual WebContentsID webContentsID() const = 0;

  virtual QUrl url() const = 0;
  virtual void setUrl(const QUrl& url) = 0;

  virtual QString title() const = 0;

  virtual QUrl favIconUrl() const = 0;

  virtual bool canGoBack() const = 0;
  virtual bool canGoForward() const = 0;

  virtual bool incognito() const = 0;

  virtual bool loading() const = 0;

  virtual bool fullscreen() const = 0;
  virtual void setFullscreen(bool fullscreen) = 0;

  virtual QObject* rootFrame() const = 0;

  virtual QObject* context() const = 0;

  virtual void goBack() = 0;
  virtual void goForward() = 0;
  virtual void stop() = 0;
  virtual void reload() = 0;

  virtual void loadHtml(const QString& html, const QUrl& base_url) = 0;

  virtual QList<QObject*>& messageHandlers() = 0;

  virtual QByteArray currentState() const = 0;

  virtual OxideQWebPreferences* preferences() = 0;
  virtual void setPreferences(OxideQWebPreferences* prefs) = 0;

  virtual void syncWebPreferences() = 0;

  virtual QPoint compositorFrameScrollOffset() = 0;
  virtual QSize compositorFrameContentSize() = 0;
  virtual QSize compositorFrameViewportSize() = 0;

  virtual void setCanTemporarilyDisplayInsecureContent(bool allow) = 0;
  virtual void setCanTemporarilyRunInsecureContent(bool allow) = 0;;

  virtual ContentTypeFlags blockedContent() const = 0;

  virtual void prepareToClose() = 0;

  virtual void terminateWebProcess() = 0;

  virtual WebProcessStatus webProcessStatus() const = 0;

  virtual void executeEditingCommand(EditingCommands command) const = 0;

  virtual QUrl targetUrl() const = 0;

  virtual EditCapabilityFlags editFlags() const = 0;

  virtual qreal zoomFactor() const = 0;
  virtual void setZoomFactor(qreal factor) = 0;
  static qreal minimumZoomFactor();
  static qreal maximumZoomFactor();

  virtual void teardownFrameTree() = 0;
};

} // namespace qt
} // namespace oxide

#endif // _OXIDE_QT_CORE_GLUE_WEB_VIEW_PROXY_H_
