// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/ui/public/cpp/tests/test_window_tree_client_setup.h"

#include "services/ui/public/cpp/tests/test_window_tree.h"
#include "services/ui/public/cpp/tests/window_tree_client_private.h"
#include "services/ui/public/cpp/window_tree_client.h"
#include "ui/display/display.h"

namespace ui {

TestWindowTreeClientSetup::TestWindowTreeClientSetup() {}

TestWindowTreeClientSetup::~TestWindowTreeClientSetup() {}

void TestWindowTreeClientSetup::Init(
    WindowTreeClientDelegate* window_tree_delegate) {
  CommonInit(window_tree_delegate, nullptr);
  WindowTreeClientPrivate(window_tree_client_.get())
      .OnEmbed(window_tree_.get());
}

void TestWindowTreeClientSetup::InitForWindowManager(
    WindowTreeClientDelegate* window_tree_delegate,
    WindowManagerDelegate* window_manager_delegate) {
  CommonInit(window_tree_delegate, window_manager_delegate);
  WindowTreeClientPrivate(window_tree_client_.get())
      .SetTreeAndClientId(window_tree_.get(), 1);
}

std::unique_ptr<WindowTreeClient>
TestWindowTreeClientSetup::OwnWindowTreeClient() {
  DCHECK(window_tree_client_);
  return std::move(window_tree_client_);
}

WindowTreeClient* TestWindowTreeClientSetup::window_tree_client() {
  return window_tree_client_.get();
}

void TestWindowTreeClientSetup::CommonInit(
    WindowTreeClientDelegate* window_tree_delegate,
    WindowManagerDelegate* window_manager_delegate) {
  window_tree_.reset(new TestWindowTree);
  window_tree_client_.reset(new WindowTreeClient(
      window_tree_delegate, window_manager_delegate, nullptr));
}

}  // namespace ui
