/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.ConversionException;
import org.mvel2.ConversionHandler;
import org.mvel2.conversion.Converter;

public class LongCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        public Object convert(Object o) {
            if (((String)o).length() == 0) {
                return 0L;
            }
            return Long.parseLong((String)o);
        }
    };

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Long.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object o) {
                return stringConverter.convert(String.valueOf(o));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Long convert(Object o) {
                return ((BigDecimal)o).longValue();
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public Long convert(Object o) {
                return ((BigInteger)o).longValue();
            }
        });
        CNV.put(Short.class, new Converter(){

            public Object convert(Object o) {
                return ((Short)o).longValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            public Object convert(Object o) {
                return new Long((Long)o);
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Object convert(Object o) {
                return ((Integer)o).longValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            public Object convert(Object o) {
                return ((Double)o).longValue();
            }
        });
        CNV.put(Float.class, new Converter(){

            public Object convert(Object o) {
                return ((Float)o).longValue();
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Long convert(Object o) {
                if (((Boolean)o).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
        });
    }
}

