#!/usr/bin/bash

set -e

GIR_FILE=

if [ -f /usr/share/gir-1.0/UnityWebapps-0.2.gir ]
then
    GIR_FILE="/usr/share/gir-1.0/UnityWebapps-0.2.gir"
fi

if [ -f /usr/local/share/gir-1.0/UnityWebapps-0.2.gir ]
then
    GIR_FILE="/usr/local/share/gir-1.0/UnityWebapps-0.2.gir"
fi

if [ $GIR_DIR ]
then
    GIR_FILE="$GIR_DIR/UnityWebapps-0.2.gir"
fi

if ! [ -f "$GIR_FILE" ]
then
    echo 'error: UnityWebapps-0.2.gir not found'
    exit 2
fi

# Disable temporarily the automatic generation of bindings to handle the small issue with
# generated (but private) functions *_gen_* that have been removed from the exported symbols
# in recent versions.

# echo "Generating unity-webapps.js from $GIR_FILE"
# xsltproc -novalid tools/gir-ctypes.xslt $GIR_FILE | perl tools/post-process.pl > content/unity-webapps.js

zip -x build.sh -x COPYING -r unity.xpi *

