/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;

public class PageSizePager
extends AbstractPager {
    private final int increment;
    private final FlexTable layout = new FlexTable();
    private final Anchor showMoreButton = new Anchor("Show More");
    private final Anchor showLessButton = new Anchor("Show Less");

    @UiConstructor
    public PageSizePager(final int increment) {
        this.increment = increment;
        this.initWidget(this.layout);
        this.layout.setCellPadding(0);
        this.layout.setCellSpacing(0);
        this.showMoreButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HasRows display = PageSizePager.this.getDisplay();
                if (display != null) {
                    Range range = display.getVisibleRange();
                    int pageSize = Math.min(range.getLength() + increment, display.getRowCount() + (display.isRowCountExact() ? 0 : increment));
                    display.setVisibleRange(range.getStart(), pageSize);
                }
            }
        });
        this.showLessButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HasRows display = PageSizePager.this.getDisplay();
                if (display != null) {
                    Range range = display.getVisibleRange();
                    int pageSize = Math.max(range.getLength() - increment, increment);
                    display.setVisibleRange(range.getStart(), pageSize);
                }
            }
        });
        this.layout.setWidget(0, 0, this.showLessButton);
        this.layout.setText(0, 1, " | ");
        this.layout.setWidget(0, 2, this.showMoreButton);
        this.setDisplay(null);
    }

    public void setDisplay(HasRows display) {
        if (display == null) {
            this.showLessButton.setVisible(false);
            this.showMoreButton.setVisible(false);
        }
        super.setDisplay(display);
    }

    public void setPageSize(int pageSize) {
        super.setPageSize(pageSize);
    }

    protected void onRangeOrRowCountChanged() {
        HasRows display = this.getDisplay();
        int pageSize = display.getVisibleRange().getLength();
        boolean hasLess = pageSize > this.increment;
        boolean hasMore = !display.isRowCountExact() || pageSize < display.getRowCount();
        this.showLessButton.setVisible(hasLess);
        this.showMoreButton.setVisible(hasMore);
        this.layout.setText(0, 1, hasLess && hasMore ? " | " : "");
    }

    boolean isShowLessButtonVisible() {
        return this.showLessButton.isVisible();
    }

    boolean isShowMoreButtonVisible() {
        return this.showMoreButton.isVisible();
    }
}

