/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.internal.subsystems.files.core.model.SystemFileTransferModeMapping;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeMapping;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeRegistry;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class SystemFileTransferModeRegistry
implements ISystemFileTransferModeRegistry {
    private static SystemFileTransferModeRegistry instance;
    private HashMap typeModeMappings;
    private RSEUIPlugin plugin = RSEUIPlugin.getDefault();
    private static final String FILENAME = "fileTransferMode.xml";
    private static final String ENCODING;
    private static final String ROOT_NODE = "mode";
    private static final String INFO_NODE = "info";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String EXTENSION_ATTRIBUTE = "extension";
    private static final String MODE_ATTRIBUTE = "mode";
    private static final String BINARY_VALUE = "binary";
    private static final String TEXT_VALUE = "text";
    private static final String XML_VALUE = "xml";
    private static final String PRIORITY_ATTRIBUTE = "priority";

    static {
        ENCODING = SystemEncodingUtil.ENCODING_UTF_8;
    }

    private SystemFileTransferModeRegistry() {
        this.initialize();
    }

    public static SystemFileTransferModeRegistry getInstance() {
        if (instance == null) {
            instance = new SystemFileTransferModeRegistry();
        }
        return instance;
    }

    public void renit() {
        this.deleteAssociations();
        this.initialize();
    }

    private void initialize() {
        this.loadAssociations();
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = extRegistry.getConfigurationElementsFor("org.eclipse.rse.subsystems.files.core", "remoteFileTypes");
        int i = 0;
        while (i < elements.length) {
            String type;
            IConfigurationElement element = elements[i];
            String extension = element.getAttribute(EXTENSION_ATTRIBUTE);
            if (extension != null && !extension.equals("") && (type = element.getAttribute("type")) != null && !type.equals("")) {
                SystemFileTransferModeMapping mapping = new SystemFileTransferModeMapping(extension);
                if (type.equalsIgnoreCase(TEXT_VALUE)) {
                    mapping.setAsText();
                }
                if (type.equalsIgnoreCase(BINARY_VALUE)) {
                    mapping.setAsBinary();
                }
                if (type.equalsIgnoreCase(XML_VALUE)) {
                    mapping.setAsXML();
                }
                int priority = Integer.MAX_VALUE;
                String priorityStr = element.getAttribute(PRIORITY_ATTRIBUTE);
                try {
                    if (priorityStr != null && !priorityStr.equals("")) {
                        priority = Integer.parseInt(priorityStr);
                    }
                }
                catch (Exception exception) {}
                mapping.setPriority(priority);
                String key = this.getMappingKey(mapping);
                if (!this.typeModeMappings.containsKey(key)) {
                    this.typeModeMappings.put(key, mapping);
                } else {
                    SystemFileTransferModeMapping existingMapping = (SystemFileTransferModeMapping)this.typeModeMappings.get(key);
                    int existingPriority = existingMapping.getPriority();
                    if (priority < existingPriority) {
                        if (mapping.isBinary() && existingMapping.isText()) {
                            existingMapping.setAsBinary();
                        } else if (mapping.isText() && existingMapping.isBinary()) {
                            existingMapping.setAsText();
                        }
                        existingMapping.setPriority(priority);
                    }
                }
            }
            ++i;
        }
    }

    public ISystemFileTransferModeMapping[] getModeMappings() {
        List sortedMappings = this.sortedTypeModeMappings();
        ISystemFileTransferModeMapping[] array = new ISystemFileTransferModeMapping[sortedMappings.size()];
        sortedMappings.toArray(array);
        return array;
    }

    private List sortedTypeModeMappings() {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((ISystemFileTransferModeMapping)o1).getLabel().toUpperCase();
                String s2 = ((ISystemFileTransferModeMapping)o2).getLabel().toUpperCase();
                return s1.compareTo(s2);
            }
        };
        TreeSet s = new TreeSet(c);
        s.addAll(this.typeModeMappings.values());
        ArrayList result = new ArrayList(s);
        return result;
    }

    public void setModeMappings(SystemFileTransferModeMapping[] newMappings) {
        this.typeModeMappings = new HashMap();
        int i = 0;
        while (i < newMappings.length) {
            SystemFileTransferModeMapping mapping = newMappings[i];
            this.typeModeMappings.put(this.getMappingKey(mapping), mapping);
            ++i;
        }
    }

    private String getMappingKey(ISystemFileTransferModeMapping mapping) {
        return mapping.getLabel().toLowerCase();
    }

    public boolean isBinary(String fileName) {
        return this.getMapping(fileName).isBinary();
    }

    public boolean isBinary(File file) {
        return this.isBinary(file.getName());
    }

    public boolean isBinary(IFile file) {
        return this.isBinary(file.getName());
    }

    public boolean isBinary(IRemoteFile remoteFile) {
        return this.isBinary(remoteFile.getName());
    }

    public boolean isText(String fileName) {
        return this.getMapping(fileName).isText();
    }

    public boolean isText(File file) {
        return this.isText(file.getName());
    }

    public boolean isText(IFile file) {
        return this.isText(file.getName());
    }

    public boolean isText(IRemoteFile remoteFile) {
        return this.isText(remoteFile.getName());
    }

    public boolean isXML(String fileName) {
        return this.getMapping(fileName).isXML();
    }

    public boolean isXML(File file) {
        return this.isXML(file.getName());
    }

    public boolean isXML(IFile file) {
        return this.isXML(file.getName());
    }

    public boolean isXML(IRemoteFile remoteFile) {
        return this.isXML(remoteFile.getName());
    }

    private SystemFileTransferModeMapping getMapping(String fileName) {
        SystemFileTransferModeMapping mapping = (SystemFileTransferModeMapping)this.typeModeMappings.get(fileName.toLowerCase());
        if (mapping == null) {
            mapping = this.createMappingFromModeMappings(fileName);
        }
        if (mapping == null) {
            return this.getDefaultMapping(fileName);
        }
        return mapping;
    }

    private SystemFileTransferModeMapping createMappingFromModeMappings(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        String name = null;
        String extension = null;
        if (extIndex == -1 || extIndex == fileName.length() - 1) {
            name = fileName;
        } else {
            name = fileName.substring(0, extIndex);
            extension = fileName.substring(extIndex + 1);
        }
        SystemFileTransferModeMapping mapping = (SystemFileTransferModeMapping)this.typeModeMappings.get(this.getMappingKey(new SystemFileTransferModeMapping(name, extension)));
        if (mapping == null) {
            mapping = (SystemFileTransferModeMapping)this.typeModeMappings.get(this.getMappingKey(new SystemFileTransferModeMapping(extension)));
        }
        if (mapping == null) {
            return null;
        }
        SystemFileTransferModeMapping fileMapping = new SystemFileTransferModeMapping(name, extension);
        if (mapping.isText()) {
            fileMapping.setAsText();
        } else if (mapping.isXML()) {
            fileMapping.setAsXML();
        } else {
            fileMapping.setAsBinary();
        }
        return fileMapping;
    }

    public static int getFileTransferModeDefaultPreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getInt("org.eclipse.rse.subsystems.files.core.preferences.filetransfermodedefault");
    }

    private SystemFileTransferModeMapping getDefaultMapping(String fileName) {
        String extension;
        String name;
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex == -1 || extIndex == fileName.length() - 1 || extIndex == 0) {
            name = fileName;
            extension = null;
        } else {
            name = fileName.substring(0, extIndex);
            extension = fileName.substring(extIndex + 1);
        }
        SystemFileTransferModeMapping mapping = new SystemFileTransferModeMapping(name, extension);
        int defaultFileTransferMode = SystemFileTransferModeRegistry.getFileTransferModeDefaultPreference();
        if (defaultFileTransferMode == 0) {
            mapping.setAsBinary();
        } else if (defaultFileTransferMode == 1) {
            mapping.setAsText();
        }
        return mapping;
    }

    public boolean loadAssociations() {
        this.typeModeMappings = new HashMap();
        String location = this.getFileLocation();
        File file = new File(location);
        if (!file.exists()) {
            return false;
        }
        FileInputStream stream = null;
        InputStreamReader reader = null;
        boolean result = false;
        try {
            try {
                stream = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)stream, ENCODING);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento[] mementos = memento.getChildren(INFO_NODE);
                int i = 0;
                while (i < mementos.length) {
                    String name = mementos[i].getString(NAME_ATTRIBUTE);
                    String extension = mementos[i].getString(EXTENSION_ATTRIBUTE);
                    String mode = mementos[i].getString("mode");
                    SystemFileTransferModeMapping mapping = new SystemFileTransferModeMapping(name, extension);
                    if (mode.equals(TEXT_VALUE)) {
                        mapping.setAsText();
                    } else if (mode.equals(XML_VALUE)) {
                        mapping.setAsXML();
                    } else {
                        mapping.setAsBinary();
                    }
                    try {
                        Integer priorityInt = mementos[i].getInteger(PRIORITY_ATTRIBUTE);
                        if (priorityInt != null) {
                            int priority = priorityInt;
                            mapping.setPriority(priority);
                        }
                    }
                    catch (Exception exception) {}
                    this.typeModeMappings.put(this.getMappingKey(mapping), mapping);
                    ++i;
                }
                result = true;
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Could not read transfer mode xml file", (Throwable)e);
                result = false;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e2) {
                    SystemBasePlugin.logError((String)"Could not close reader for transfer mode xml file", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Could not close reader for transfer mode xml file", (Throwable)e);
            }
        }
        return result;
    }

    private void deleteAssociations() {
        String location = this.getFileLocation();
        File assFile = new File(location);
        assFile.delete();
    }

    public void saveAssociations() {
        String location = this.getFileLocation();
        XMLMemento memento = XMLMemento.createWriteRoot((String)"mode");
        for (ISystemFileTransferModeMapping mapping : this.typeModeMappings.values()) {
            IMemento infoMemento = memento.createChild(INFO_NODE);
            infoMemento.putString(NAME_ATTRIBUTE, mapping.getName());
            infoMemento.putString(EXTENSION_ATTRIBUTE, mapping.getExtension());
            if (mapping.isText()) {
                infoMemento.putString("mode", TEXT_VALUE);
            } else if (mapping.isXML()) {
                infoMemento.putString("mode", XML_VALUE);
            } else {
                infoMemento.putString("mode", BINARY_VALUE);
            }
            infoMemento.putInteger(PRIORITY_ATTRIBUTE, mapping.getPriority());
        }
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            try {
                stream = new FileOutputStream(location);
                writer = new OutputStreamWriter((OutputStream)stream, ENCODING);
                memento.save((Writer)writer);
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Could not write to transfer mode xml file", (Throwable)e);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e2) {
                    SystemBasePlugin.logError((String)"Could not close writer for transfer mode xml file", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Could not close writer for transfer mode xml file", (Throwable)e);
            }
        }
    }

    private String getFileLocation() {
        return this.plugin.getStateLocation().append(FILENAME).toOSString();
    }
}

