/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.cuda.ide.debug.model.CudaFocusChangedEvent;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.ContainerVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.GdbExecutionContextLabelText;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.MessagesForGdbLaunchVM;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.ui.DebugUITools;

public class CudaContainerVMNode
extends ContainerVMNode
implements IVMNode {
    private static boolean isCudaFocusLost(Object e) {
        IDMContext adapter;
        IAdaptable debugContext;
        CudaFocusChangedEvent focusEvent;
        if (e instanceof CudaFocusChangedEvent && (focusEvent = (CudaFocusChangedEvent)((Object)e)).getOldFocus() != null && focusEvent.getNewFocus() == null && (debugContext = DebugUITools.getDebugContext()) != null && (adapter = (IDMContext)debugContext.getAdapter(IDMContext.class)) != null) {
            return DMContexts.getAncestorOfType((IDMContext)adapter, ICudaRuntimeObject.class) != null;
        }
        return false;
    }

    public CudaContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public void buildDelta(Object e, final VMDelta parentDelta, int nodeOffset, final RequestMonitor requestMonitor) {
        if (CudaContainerVMNode.isCudaFocusLost(e)) {
            IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
            ICommandControlService controlService = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
            if (processService == null || controlService == null) {
                requestMonitor.done();
            } else {
                processService.getProcessesBeingDebugged((IDMContext)controlService.getContext(), (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>(this.getExecutor(), requestMonitor){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleSuccess() {
                        if (this.getData() != null && ((IDMContext[])this.getData()).length == 1) {
                            parentDelta.setFlags(parentDelta.getFlags() | 0x100000);
                            parentDelta.addNode((Object)CudaContainerVMNode.this.createVMContext(((IDMContext[])this.getData())[0]), 0x200000);
                        }
                        requestMonitor.done();
                    }
                });
            }
        } else if (!this.filtered(e)) {
            super.buildDelta(e, parentDelta, nodeOffset, requestMonitor);
        } else {
            requestMonitor.done();
        }
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new GdbExecutionContextLabelText("{0,choice,0#Host Process|1#Host Process [{1}]}{2,choice,0#|1# [{3}]}{4,choice,0#|1# [cores: {5}]}", new String[]{"name_known", "name", "id_known", "id", "cores_id_known", "cores_id"}), new LabelText(MessagesForGdbLaunchVM.ContainerVMNode_No_columns__Error__label, new String[0]), new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_r.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(1) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_g.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(0) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_b.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(2) : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.FALSE.equals(properties.get("is_suspended"));
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_r.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(1) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_g.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(0) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_b.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(2) : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_SUSPENDED"))}));
        return provider;
    }

    private boolean filtered(Object e) {
        if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
            return service != null && service.getFocus() != null;
        }
        return false;
    }

    public int getDeltaFlags(Object e) {
        if (CudaContainerVMNode.isCudaFocusLost(e)) {
            return 0x300000;
        }
        return super.getDeltaFlags(e);
    }
}

