/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelHierarchy;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;

public final class FilteredKernelList
implements KernelHierarchy.IDelegate {
    private final DsfServicesTracker tracker;

    public FilteredKernelList(DsfServicesTracker tracker) {
        this.tracker = tracker;
    }

    private boolean filteredMode(DataRequestMonitor<IDMContext[]> rm) {
        IDebuggerUIState service = (IDebuggerUIState)this.tracker.getService(IDebuggerUIState.class);
        if (service != null) {
            TreeSet<Kernel> kernels = new TreeSet<Kernel>(Arrays.asList(service.getVisibleKernels()));
            DeviceThread focus = service.getFocus();
            if (focus != null) {
                kernels.add((Kernel)DMContexts.getAncestorOfType((IDMContext)focus, Kernel.class));
            }
            rm.done((Object)kernels.toArray(new IDMContext[kernels.size()]));
            return true;
        }
        return false;
    }

    @Override
    public void getChildren(ICudaRuntimeObject parent, int offset, int length, DataRequestMonitor<IDMContext[]> rm, ICudaElementFilter filter) {
        ICudaApplication root = KernelHierarchy.isDebugHierarchyRoot(parent);
        if (root != null && this.filteredMode(rm)) {
            return;
        }
        new KernelList().getChildren(parent, offset, length, rm, filter);
    }

    @Override
    public void getChildrenCount(ICudaRuntimeObject parent, DataRequestMonitor<Tuple<Integer, Integer, ?>> drm) {
        ICudaApplication root = KernelHierarchy.isDebugHierarchyRoot(parent);
        if (root != null) {
            final int[] returnValues = new int[]{-1, -1};
            final CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), (RequestMonitor)drm, (DataRequestMonitor)drm, returnValues){
                private final /* synthetic */ DataRequestMonitor val$drm;
                private final /* synthetic */ int[] val$returnValues;
                {
                    this.val$drm = dataRequestMonitor;
                    this.val$returnValues = nArray;
                    super($anonymous0, $anonymous1);
                }

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    this.val$drm.done((Object)Tuple.pair((Object)this.val$returnValues[0], (Object)this.val$returnValues[1]));
                }
            };
            crm.setDoneCount(2);
            if (!this.filteredMode(new DataRequestMonitor<IDMContext[]>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    IDMContext[] filteredKernels = (IDMContext[])this.getData();
                    returnValues[0] = filteredKernels == null ? 0 : filteredKernels.length;
                    crm.done();
                }
            })) {
                crm.done();
            }
            root.getKernels((DataRequestMonitor<? super Kernel[]>)new DataRequestMonitor<Kernel[]>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    returnValues[1] = this.getData() == null ? 0 : ((Kernel[])this.getData()).length;
                    crm.done();
                }
            });
        } else {
            drm.done(null);
        }
    }

    @Override
    public boolean isCdpStackVisible() {
        return true;
    }

    protected void selectOrExpandNewKernel(Kernel kernel, List<Object> list, VMDelta delta, int nodeOffset, boolean select, boolean collapseOthers) {
        int i = 0;
        for (Object object : list) {
            block3: {
                int flags;
                block5: {
                    block4: {
                        if (!(object instanceof IDMVMContext)) break block3;
                        IDMContext context = ((IDMVMContext)object).getDMContext();
                        if (!kernel.equals(context)) break block4;
                        flags = (select ? 0x4200000 : 0) | 0x100000;
                        break block5;
                    }
                    if (!collapseOthers) break block3;
                    flags = 0x2000000;
                }
                delta.addNode(object, i, flags);
            }
            ++i;
        }
    }

    @Override
    public Kernel getAncestor(Kernel element, VMDelta delta) {
        IDMContext context;
        Object e = delta.getElement();
        if (e instanceof IDMVMContext && (context = ((IDMVMContext)e).getDMContext()) instanceof ICudaRuntimeObject && KernelHierarchy.isDebugHierarchyRoot((ICudaRuntimeObject)context) != null) {
            return element;
        }
        return null;
    }

    @Override
    public boolean isParent(Kernel kernel, VMDelta delta) {
        Object element = delta.getElement();
        return !(element instanceof IDMVMContext) || !(((IDMVMContext)element).getDMContext() instanceof ICudaRuntimeObject);
    }
}

