/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.Commit;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.util.Util;

class CheckedInHandler
extends ResponseHandler {
    CheckedInHandler() {
    }

    public String getResponseID() {
        return "Checked-in";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        String repositoryFile = session.readLine();
        String entryLine = session.readLine();
        session.setModTime(null);
        String fileName = repositoryFile.substring(repositoryFile.lastIndexOf("/") + 1);
        ICVSFolder mParent = session.getLocalRoot().getFolder(localDir);
        ICVSFile mFile = mParent.getFile(fileName);
        monitor.subTask(NLS.bind((String)CVSMessages.CheckInHandler_checkedIn, (Object[])new String[]{Util.toTruncatedPath(mFile, session.getLocalRoot(), 3)}));
        mFile.checkedIn(entryLine, session.getCurrentCommand() instanceof Commit);
    }
}

