/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.ui.cview.CViewContentProvider;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class CNavigatorContentProvider
extends CViewContentProvider
implements IPipelinedTreeContentProvider {
    private Object fRealInput;
    private IPropertyChangeListener fPropertyChangeListener;
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        IMemento memento = commonContentExtensionSite.getMemento();
        this.restoreState(memento);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                boolean refreshViewer = false;
                String property = event.getProperty();
                Object newValue = event.getNewValue();
                if (property.equals("org.eclipse.cdt.ui.editor.CUChildren")) {
                    boolean showCUChildren = newValue instanceof Boolean ? (Boolean)newValue : false;
                    CNavigatorContentProvider.this.setProvideMembers(showCUChildren);
                    refreshViewer = true;
                } else if (property.equals("org.eclipse.cdt.ui.cview.groupincludes")) {
                    boolean groupIncludes = newValue instanceof Boolean ? (Boolean)newValue : false;
                    CNavigatorContentProvider.this.setIncludesGrouping(groupIncludes);
                    refreshViewer = true;
                } else if (property.equals("org.eclipse.cdt.ui.cview.groupmacros")) {
                    boolean groupMacros = newValue instanceof Boolean ? (Boolean)newValue : false;
                    CNavigatorContentProvider.this.setMacroGrouping(groupMacros);
                    refreshViewer = true;
                }
                if (refreshViewer && CNavigatorContentProvider.this.getViewer() != null) {
                    CNavigatorContentProvider.this.getViewer().refresh();
                }
            }
        };
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        this.fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("org.eclipse.cdt.core.showSourceRootsAtTopLevelOfProject")) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CNavigatorContentProvider.this.getViewer().refresh();
                        }
                    });
                }
            }
        };
        InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").addPreferenceChangeListener(this.fPreferenceChangeListener);
    }

    @Override
    public void dispose() {
        InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").removePreferenceChangeListener(this.fPreferenceChangeListener);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }

    public void restoreState(IMemento memento) {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.cdt.ui.editor.CUChildren");
        boolean groupIncludes = store.getBoolean("org.eclipse.cdt.ui.cview.groupincludes");
        boolean groupMacros = store.getBoolean("org.eclipse.cdt.ui.cview.groupmacros");
        this.setProvideMembers(showCUChildren);
        this.setIncludesGrouping(groupIncludes);
        this.setMacroGrouping(groupMacros);
        this.setProvideWorkingCopy(true);
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            memento.putString("org.eclipse.cdt.ui.editor.CUChildren", String.valueOf(this.getProvideMembers()));
            memento.putString("org.eclipse.cdt.ui.cview.groupincludes", String.valueOf(this.areIncludesGroup()));
            memento.putString("org.eclipse.cdt.ui.cview.groupmacros", String.valueOf(this.isMacroGroupingEnabled()));
        }
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fRealInput = newInput;
        super.inputChanged(viewer, oldInput, this.findInputElement(newInput));
    }

    private Object findInputElement(Object newInput) {
        if (newInput instanceof IWorkspaceRoot) {
            return CoreModel.create((IWorkspaceRoot)((IWorkspaceRoot)newInput));
        }
        return newInput;
    }

    @Override
    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (parent instanceof ICModel) {
            return this.getViewerInput() != null ? this.fRealInput : parent;
        }
        if (parent instanceof ICProject) {
            return ((ICProject)parent).getProject();
        }
        return parent;
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    @Override
    public Object[] getElements(Object parent) {
        if (parent instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)parent).getProjects();
        }
        if (parent instanceof IProject) {
            return super.getChildren(CoreModel.getDefault().create((IProject)parent));
        }
        return super.getElements(parent);
    }

    @Override
    public Object[] getChildren(Object element) {
        if (element instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)element).getProjects();
        }
        if (element instanceof IProject) {
            return super.getChildren(CoreModel.getDefault().create((IProject)element));
        }
        Object[] children = super.getChildren(element);
        return children;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return project.isAccessible();
        }
        return super.hasChildren(element);
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        this.customizeCElements(this.getChildren(parent), currentChildren);
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        this.customizeCElements(this.getElements(input), currentElements);
    }

    private void customizeCElements(Object[] cChildren, Set<Object> proposedChildren) {
        List<Object> elementList = Arrays.asList(cChildren);
        for (Object element : proposedChildren) {
            int i;
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
            if (resource == null || (i = elementList.indexOf(resource)) < 0) continue;
            cChildren[i] = null;
        }
        Object[] objectArray = cChildren;
        int n = cChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object element;
            element = objectArray[n2];
            if (element instanceof ICElement) {
                ICElement cElement = (ICElement)element;
                IResource resource = cElement.getResource();
                if (resource != null) {
                    proposedChildren.remove(resource);
                }
                proposedChildren.add(element);
            } else if (element != null) {
                proposedChildren.add(element);
            }
            ++n2;
        }
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        Object parent = addModification.getParent();
        if (parent instanceof ICProject) {
            if (this.fRealInput instanceof IWorkspaceRoot) {
                addModification.setParent((Object)((ICProject)parent).getProject());
            }
        } else if (parent instanceof IProject || parent instanceof IFolder) {
            IProject project = ((IResource)parent).getProject();
            if (CoreModel.hasCNature((IProject)project)) {
                addModification.getChildren().clear();
                return addModification;
            }
        } else if (parent instanceof IWorkspaceRoot) {
            Iterator iterator = addModification.getChildren().iterator();
            while (iterator.hasNext()) {
                Object child = iterator.next();
                if (!(child instanceof IProject) || !CoreModel.hasCNature((IProject)((IProject)child))) continue;
                iterator.remove();
            }
        }
        this.convertToCElements(addModification);
        return addModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        Set refreshTargets = refreshSynchronization.getRefreshTargets();
        return this.convertToCElements(refreshTargets);
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        Set children = removeModification.getChildren();
        this.convertToCElements(children);
        return removeModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        Set refreshTargets = updateSynchronization.getRefreshTargets();
        return this.convertToCElements(refreshTargets);
    }

    private boolean convertToCElements(PipelinedShapeModification modification) {
        ICElement element;
        IContainer container;
        IProject project;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (project = (container = (IContainer)parent).getProject()) != null && CoreModel.hasCNature((IProject)project) && (element = CoreModel.getDefault().create((IResource)container)) != null) {
            if (!(element instanceof ICModel) && !(element instanceof ICProject)) {
                modification.setParent((Object)element);
            }
            Set children = modification.getChildren();
            return this.convertToCElements(children);
        }
        return false;
    }

    private boolean convertToCElements(Set<Object> currentChildren) {
        LinkedHashSet<ICElement> convertedChildren = new LinkedHashSet<ICElement>();
        Iterator<Object> iter = currentChildren.iterator();
        while (iter.hasNext()) {
            ICElement newChild;
            IResource resource;
            Object child = iter.next();
            if (!(child instanceof IFile) && !(child instanceof IFolder) || !(resource = (IResource)child).isAccessible() || !CoreModel.hasCNature((IProject)resource.getProject()) || (newChild = CoreModel.getDefault().create(resource)) == null) continue;
            iter.remove();
            convertedChildren.add(newChild);
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    @Override
    protected void postContainerRefresh(IParent container, ICProject cproject) {
        this.postRefreshable(new CElementContentProvider.RefreshContainer(this, container, cproject.getProject()));
    }

    @Override
    protected void postRefresh(Object element) {
        if (!(element instanceof ICModel)) {
            IProject project;
            if (element instanceof ICProject) {
                super.postRefresh(((ICProject)element).getProject());
            } else if (element instanceof ICElement) {
                super.postRefresh(element);
            } else if (element instanceof IResource && CoreModel.hasCNature((IProject)(project = ((IResource)element).getProject()))) {
                super.postRefresh(element);
            }
        }
    }

    @Override
    protected void postAdd(Object parent, Object element) {
        IProject project;
        if (parent instanceof ICModel) {
            if (element instanceof ICElement) {
                super.postAdd(this.fRealInput, element);
            } else if (element instanceof IProject && CoreModel.hasCNature((IProject)((IProject)element))) {
                super.postAdd(this.fRealInput, element);
            }
        } else if (parent instanceof ICProject) {
            super.postAdd(((ICProject)parent).getProject(), element);
        } else if (parent instanceof ICElement) {
            super.postAdd(parent, element);
        } else if (element instanceof IResource && CoreModel.hasCNature((IProject)(project = ((IResource)element).getProject()))) {
            super.postAdd(parent, element);
        }
    }

    @Override
    protected void postRemove(Object element) {
        this.postRefresh(this.internalGetParent(element));
    }

    @Override
    protected void postProjectStateChanged(Object element) {
        if (element instanceof ICModel) {
            super.postProjectStateChanged(this.fRealInput);
        } else if (element instanceof ICProject) {
            super.postProjectStateChanged(((ICProject)element).getProject());
        } else {
            super.postProjectStateChanged(element);
        }
    }
}

