/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.StructRefValue;

abstract class AbstractLibraryRecord
extends SimpleRecord {
    protected Module module;
    protected Library library;

    AbstractLibraryRecord(Module module, Library library) {
        this.module = module;
        this.library = library;
    }

    AbstractLibraryRecord(Module module) {
        this.module = module;
    }

    @Override
    public DesignElement getTarget() {
        return this.module;
    }

    public void updateReferenceableClients(int updateSize) {
        List<Library> libraries = this.module.getLibraries();
        int i = 0;
        while (i < updateSize) {
            this.updateReferenceableClients(libraries.get(i));
            ++i;
        }
    }

    public void updateReferenceableClients(Library library) {
        this.updateReferenceableClients(library, 0);
        this.updateReferenceableClients(library, 2);
        this.updateReferenceableClients(library, 3);
        this.updateReferenceableClients(library, 6);
        List<Object> images = library.getListProperty(library, "images");
        if (images == null || images.isEmpty()) {
            return;
        }
        boolean sendEvent = false;
        int i = 0;
        while (i < images.size()) {
            EmbeddedImage image = (EmbeddedImage)images.get(i);
            List<Structure> clients = image.getClientStructures();
            if (clients != null && !clients.isEmpty()) {
                int j = 0;
                while (j < clients.size()) {
                    Structure client = clients.get(j);
                    StructRefValue value = (StructRefValue)client.getLocalProperty(this.module, "libReference");
                    assert (value != null);
                    value.unresolved(value.getName());
                    image.dropClientStructure(client);
                    sendEvent = true;
                    ++j;
                }
                List<BackRef> clientsRef = image.getClientList();
                if (clientsRef != null && !clientsRef.isEmpty()) {
                    int j2 = 0;
                    while (j2 < clientsRef.size()) {
                        BackRef client = clientsRef.get(j2);
                        DesignElement element = client.getElement();
                        StructRefValue value = (StructRefValue)element.getLocalProperty(this.module, client.getPropertyName());
                        assert (value != null);
                        value.unresolved(value.getName());
                        image.dropClient(element);
                        element.broadcast(new PropertyEvent(this.module, client.getPropertyName()));
                        ++j2;
                    }
                }
            }
            ++i;
        }
        if (sendEvent) {
            this.module.broadcast(new PropertyEvent(this.module, "images"));
        }
    }

    private void updateReferenceableClients(DesignElement target, int slotId) {
        ContainerSlot slot = target.getSlot(slotId);
        Iterator<DesignElement> iter = slot.iterator();
        while (iter.hasNext()) {
            DesignElement element = iter.next();
            assert (element instanceof IReferencableElement);
            IReferencableElement referenceableElement = (IReferencableElement)((Object)element);
            referenceableElement.updateClientReferences();
            if (!(referenceableElement instanceof Theme)) continue;
            this.updateReferenceableClients((DesignElement)((Object)referenceableElement), 0);
            List<CssStyleSheet> csses = ((ICssStyleSheetOperation)((Object)referenceableElement)).getCsses();
            for (CssStyleSheet styleSheet : csses) {
                List<CssStyle> styles = styleSheet.getStyles();
                for (CssStyle cssStyle : styles) {
                    cssStyle.updateClientReferences();
                }
            }
        }
    }
}

