/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;

public class SessionManager
implements IDebugEventSetListener {
    public SessionManager() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public Object getAdapter(Class adapter) {
        if (SessionManager.class.equals((Object)adapter)) {
            return this;
        }
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object element;
            DebugEvent event = events[i];
            if (event.getKind() == 8 && (element = event.getSource()) instanceof IDebugTarget && ((IDebugTarget)element).getAdapter(ICDITarget.class) != null) {
                this.handleTerminateEvent(((IDebugTarget)element).getLaunch(), ((ICDITarget)((IDebugTarget)element).getAdapter(ICDITarget.class)).getSession());
            }
            ++i;
        }
    }

    private void handleTerminateEvent(ILaunch launch, ICDISession session) {
        IDebugTarget[] targets = launch.getDebugTargets();
        boolean terminate = true;
        int i = 0;
        while (i < targets.length) {
            if (targets[i].getAdapter(ICDITarget.class) != null && session.equals(((ICDITarget)targets[i].getAdapter(ICDITarget.class)).getSession()) && !targets[i].isTerminated() && !targets[i].isDisconnected()) {
                terminate = false;
            }
            ++i;
        }
        if (terminate) {
            try {
                session.terminate();
            }
            catch (CDIException e) {
                CDebugCorePlugin.log(e);
            }
        }
    }
}

