/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.simpleapi.IHideRule;
import org.eclipse.birt.report.model.simpleapi.HideRuleImpl;

public class HideRuleMethodUtil {
    public static IHideRule[] getHideRules(DesignElementHandle handle) {
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        Iterator iterator = propHandle.iterator();
        ArrayList<HideRuleImpl> rList = new ArrayList<HideRuleImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            HideRuleHandle ruleHandle = (HideRuleHandle)iterator.next();
            HideRuleImpl rule = new HideRuleImpl(ruleHandle);
            rList.add(rule);
            ++count;
        }
        return rList.toArray(new IHideRule[count]);
    }

    public static void removeHideRule(DesignElementHandle handle, IHideRule rule) throws SemanticException {
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        propHandle.removeItem(rule.getStructure());
    }

    public static void addHideRule(DesignElementHandle handle, IHideRule rule) throws SemanticException {
        if (rule == null) {
            return;
        }
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        propHandle.addItem(rule.getStructure());
    }

    public static void removeHideRules(DesignElementHandle handle) throws SemanticException {
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        propHandle.clearValue();
    }
}

