/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.SystemFilterReference;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class SystemFilterContainerReferenceCommonMethods {
    private ISystemFilterContainerReference parentRef = null;
    private List filterReferences = new ArrayList(10);

    public SystemFilterContainerReferenceCommonMethods(ISystemFilterContainerReference parentRef) {
        this.parentRef = parentRef;
    }

    public boolean hasFilters() {
        return this.getFilterCount() > 0;
    }

    public int getFilterCount() {
        List filters = this.getFiltersFromParent();
        int count = filters.size();
        return count;
    }

    public List getSystemFilterReferences(ISubSystem subSystem) {
        this.generateSystemFilterReferences(subSystem);
        return this.filterReferences;
    }

    private void generateSystemFilterReferences(ISubSystem subSystem) {
        List filters = this.getFiltersFromParent();
        if (this.mustGenerate(filters)) {
            this.generateFilterReferences(subSystem, filters);
        }
    }

    private boolean mustGenerate(List filters) {
        boolean result = true;
        List referencedFilters = this.getReferencedFilters();
        if (filters.size() == referencedFilters.size()) {
            int n = filters.size();
            int i = 0;
            result = false;
            while (i < n && !result) {
                ISystemFilter referencedFilter;
                ISystemFilter filter = (ISystemFilter)filters.get(i);
                if (filter != (referencedFilter = (ISystemFilter)referencedFilters.get(i))) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    private List getReferencedFilters() {
        ArrayList<ISystemFilter> result = new ArrayList<ISystemFilter>(this.filterReferences.size());
        for (ISystemFilterReference reference : this.filterReferences) {
            result.add(reference.getReferencedFilter());
        }
        return result;
    }

    private void generateFilterReferences(ISubSystem subSystem, List filters) {
        List referencedFilters = this.getReferencedFilters();
        ArrayList<ISystemFilterReference> newReferences = new ArrayList<ISystemFilterReference>(filters.size());
        for (ISystemFilter filter : filters) {
            int i = referencedFilters.indexOf(filter);
            ISystemFilterReference reference = i >= 0 ? (ISystemFilterReference)this.filterReferences.get(i) : this.generateFilterReference(subSystem, filter);
            newReferences.add(reference);
        }
        this.filterReferences = newReferences;
    }

    private ISystemFilterReference generateFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        ISystemFilterReference result = SystemFilterReference.createSystemFilterReference(subSystem, this.parentRef, filter, false);
        return result;
    }

    public ISystemFilterReference generateAndRecordFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        this.generateSystemFilterReferences(subSystem);
        ISystemFilterReference reference = this.getExistingSystemFilterReference(subSystem, filter);
        if (reference == null) {
            reference = this.generateFilterReference(subSystem, filter);
            this.filterReferences.add(reference);
        }
        return reference;
    }

    public ISystemFilterReference getExistingSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        ISystemFilterReference result = null;
        Iterator z = this.filterReferences.iterator();
        while (z.hasNext() && result == null) {
            ISystemFilterReference reference = (ISystemFilterReference)z.next();
            if (reference.getReferencedFilter() != filter || reference.getSubSystem() != subSystem) continue;
            result = reference;
        }
        return result;
    }

    private List getFiltersFromParent() {
        ISystemFilterContainer parent = this.parentRef.getReferencedSystemFilterContainer();
        ISystemFilter[] filters = null;
        filters = parent instanceof ISystemFilterPool ? ((ISystemFilterPool)parent).getFilters() : (parent instanceof ISystemFilter ? ((ISystemFilter)parent).getNestedFilters() : new ISystemFilter[]{});
        List<ISystemFilter> result = Arrays.asList(filters);
        return result;
    }
}

