/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RegionArea;

public class ForeignHtmlRegionArea
extends RegionArea
implements IContainerArea {
    public ForeignHtmlRegionArea() {
    }

    public ForeignHtmlRegionArea(IForeignContent content, LayoutContext context) {
        this.context = context;
        this.content = content;
        this.setPageBreakInside(IStyle.AVOID_VALUE);
    }

    ForeignHtmlRegionArea(ForeignHtmlRegionArea area) {
        super(area);
    }

    @Override
    public void initialize() throws BirtException {
        this.calculateSpecifiedWidth(this.content);
        this.calculateSpecifiedHeight(this.content);
        this.buildProperties(this.content, this.context);
    }

    @Override
    public void close() throws BirtException {
        this.finished = true;
        this.height = this.specifiedHeight > 0 ? this.specifiedHeight : this.currentBP + this.localProperties.getPaddingBottom();
        if (this.parent != null && this.height > this.parent.getMaxAvaHeight()) {
            this.height = this.parent.getMaxAvaHeight();
        }
    }

    @Override
    public ContainerArea.SplitResult split(int height, boolean force) throws BirtException {
        if (force) {
            BlockContainerArea newArea = this.cloneArea();
            newArea.children.addAll(this.children);
            this.children.clear();
            this.height = 0;
            return new ContainerArea.SplitResult(newArea, 0);
        }
        return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
    }

    @Override
    public void update(AbstractArea area) throws BirtException {
        int aHeight = area.getAllocatedHeight();
        this.currentBP += aHeight;
        if (this.currentIP + area.getAllocatedWidth() > this.maxAvaWidth) {
            this.setNeedClip(true);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

