/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.util.ProgressMonitorDialogWithHideButton;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.DsfTerminateCommand;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public final class CudaTerminateHandler
extends DsfTerminateCommand {
    private final DsfSession session;

    public CudaTerminateHandler(DsfSession session) {
        super(session);
        this.session = session;
    }

    public boolean execute(IDebugCommandRequest request) {
        this.trackSession(this.session);
        return super.execute(request);
    }

    private void trackSession(DsfSession session) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                display.timerExec(500, new Runnable(){

                    @Override
                    public void run() {
                        CudaTerminateHandler.this.startProgressDisplay();
                    }
                });
            }
        });
    }

    private void startProgressDisplay() {
        final Object mutex = new Object();
        if (this.session.isActive()) {
            DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)new DsfSession.SessionEndedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void sessionEnded(DsfSession session) {
                    if (session == CudaTerminateHandler.this.session) {
                        Object object = mutex;
                        synchronized (object) {
                            mutex.notifyAll();
                        }
                    }
                }
            });
            try {
                new ProgressMonitorDialogWithHideButton(SWTUtil.getShell()).run(true, true, new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Terminating the application", -1);
                        Object object = mutex;
                        synchronized (object) {
                            while (CudaTerminateHandler.this.session.isActive() && !monitor.isCanceled()) {
                                mutex.wait(500L);
                            }
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.log(e);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
        }
    }
}

