/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui;

import com.nvidia.cuda.ide.debug.core.Activator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CudaBreakOnLaunchItemsLayout
extends ContributionItem
implements IPropertyChangeListener,
SelectionListener {
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private final MenuItem[] menuItems = new MenuItem[ATTRS.length];
    private static final String[][] ATTRS = new String[][]{{"All", "all"}, {"Application", "application"}, {"System", "system"}, {"None", "none"}};

    private MenuItem createMenuItem(Menu menu, String label) {
        MenuItem mi = new MenuItem(menu, 32);
        mi.setText(label);
        mi.addSelectionListener((SelectionListener)this);
        return mi;
    }

    public final void fill(Menu menu, int index) {
        int idx = 0;
        while (idx < ATTRS.length) {
            this.menuItems[idx] = this.createMenuItem(menu, ATTRS[idx][0]);
            ++idx;
        }
        this.updateSelection(this.getCurrentValue());
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        MenuItem[] menuItemArray = this.menuItems;
        int n = this.menuItems.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!"break_on_launch".equals(event.getProperty())) {
            return;
        }
        String value = (String)event.getNewValue();
        this.updateSelection(value);
    }

    private String getCurrentValue() {
        return this.preferenceStore.getString("break_on_launch");
    }

    private void updateSelection(String value) {
        int idx = 0;
        while (idx < ATTRS.length) {
            this.menuItems[idx].setSelection(ATTRS[idx][1].equals(value));
            ++idx;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        int idx = 0;
        while (idx < this.menuItems.length) {
            if (this.menuItems[idx] == source) {
                this.preferenceStore.setValue("break_on_launch", ATTRS[idx][1]);
            }
            ++idx;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

