/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.filters;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class LogicalElementsFilter
implements ICudaElementFilter {
    public static final String ID = LogicalElementsFilter.class.getName();

    @Override
    public void updateChildren(boolean inLogicalMode, ICudaRuntimeObject object, int offset, int length, ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
        object.accept(new GetChildren(rm, offset, length, sorter));
    }

    @Override
    public void updateChildrenCount(boolean isLogical, ICudaRuntimeObject object, ICoordSorter sorter, DataRequestMonitor<Integer> drm) {
        object.accept(new GetChildrenCount((RequestMonitor)drm, (DataRequestMonitor)drm){
            private final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
                super($anonymous0);
            }

            @Override
            protected void setCount(int count) {
                this.val$drm.setData((Object)count);
                this.val$drm.done();
            }
        });
    }

    @Override
    public void updateHasChildren(boolean isLogical, ICudaRuntimeObject object, DataRequestMonitor<Boolean> drm) {
        object.accept(new GetChildrenCount((RequestMonitor)drm, (DataRequestMonitor)drm){
            private final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
                super($anonymous0);
            }

            @Override
            protected void setCount(int count) {
                this.val$drm.setData((Object)(count > 0 ? 1 : 0));
                this.val$drm.done();
            }
        });
    }

    private static final class CoordComparator
    implements Comparator<IDMContext> {
        private final CudaDim dim;
        private final ICoordSorter sorter;

        private CoordComparator(ICoordSorter sorter, CudaDim dim) {
            this.sorter = sorter;
            this.dim = dim;
        }

        @Override
        public int compare(IDMContext o1, IDMContext o2) {
            CudaCoord coord2;
            CudaCoord coord1;
            if (o1 instanceof Block) {
                coord1 = ((Block)o1).getBlockIdx();
                coord2 = ((Block)o2).getBlockIdx();
            } else {
                coord1 = ((DeviceThread)o1).getThreadIdx();
                coord2 = ((DeviceThread)o2).getThreadIdx();
            }
            long l1 = this.sorter.ordinal(this.dim, coord1);
            long l2 = this.sorter.ordinal(this.dim, coord2);
            return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        }
    }

    private static final class GetChildren
    implements ICudaVisitor {
        private final int length;
        private final int offset;
        private final DataRequestMonitor<IDMContext[]> rm;
        private final ICoordSorter sorter;

        public GetChildren(DataRequestMonitor<IDMContext[]> rm, int offset, int length, ICoordSorter sorter) {
            this.rm = rm;
            this.sorter = sorter;
            this.offset = offset > 0 ? offset : 0;
            this.length = length > 0 ? length : Integer.MAX_VALUE;
        }

        @Override
        public void visitApplication(ICudaApplication application) {
            application.getKernels((DataRequestMonitor<? super Kernel[]>)new DataRequestMonitor<Kernel[]>(application.getExecutor(), this.rm){

                protected void handleSuccess() {
                    IDMContext[] context = new IDMContext[Math.min(((Kernel[])this.getData()).length - GetChildren.this.offset, GetChildren.this.length)];
                    int i = 0;
                    while (i < context.length) {
                        context[i] = ((Kernel[])this.getData())[GetChildren.this.offset + i];
                        ++i;
                    }
                    GetChildren.this.rm.setData((Object)context);
                    GetChildren.this.rm.done();
                }
            });
        }

        @Override
        public void visitBlock(Block block) {
            try {
                CudaDim dim = ((Kernel)DMContexts.getAncestorOfType((IDMContext)block, Kernel.class)).getBlockDim();
                TreeSet<IDMContext> set = new TreeSet<IDMContext>(new CoordComparator(this.sorter, dim));
                int count = Math.min(this.length, dim.elementCount() - this.offset);
                int i = 0;
                while (i < count) {
                    set.add(block.getThread(this.sorter.getCoord(dim, i + this.offset)));
                    ++i;
                }
                this.rm.setData((Object)set.toArray(new IDMContext[set.size()]));
            }
            catch (CudaException e) {
                this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
            }
            this.rm.done();
        }

        @Override
        public void visitDevice(Device device) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitKernel(Kernel kernel) {
            try {
                CudaDim dim = kernel.getGridDim();
                int count = Math.min(this.length, dim.elementCount() - this.offset);
                TreeSet<IDMContext> set = new TreeSet<IDMContext>(new CoordComparator(this.sorter, dim));
                int i = 0;
                while (i < count) {
                    set.add(kernel.getBlock(this.sorter.getCoord(dim, i + this.offset)));
                    ++i;
                }
                this.rm.setData((Object)set.toArray(new IDMContext[set.size()]));
            }
            catch (CudaException e) {
                this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
            }
            this.rm.done();
        }

        @Override
        public void visitLane(Lane lane) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitSM(StreamingMultiprocessor sm) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitThread(DeviceThread deviceThread) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitWarp(Warp warp) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }
    }

    private static abstract class GetChildrenCount
    implements ICudaVisitor {
        private final RequestMonitor rm;

        public GetChildrenCount(RequestMonitor rm) {
            this.rm = rm;
        }

        protected abstract void setCount(int var1);

        @Override
        public void visitApplication(ICudaApplication application) {
            application.getKernels((DataRequestMonitor<? super Kernel[]>)new DataRequestMonitor<Kernel[]>(application.getExecutor(), this.rm){

                protected void handleSuccess() {
                    GetChildrenCount.this.setCount(this.getData() != null ? ((Kernel[])this.getData()).length : 0);
                }
            });
        }

        @Override
        public void visitBlock(Block block) {
            this.setCount(((Kernel)DMContexts.getAncestorOfType((IDMContext)block, Kernel.class)).getBlockDim().elementCount());
        }

        @Override
        public void visitDevice(Device device) {
            this.setCount(0);
        }

        @Override
        public void visitKernel(final Kernel kernel) {
            kernel.getActiveBlocksCount(new DataRequestMonitor<Integer>(((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)kernel, ICudaApplication.class)).getExecutor(), this.rm){

                protected void handleSuccess() {
                    if ((Integer)this.getData() > 0) {
                        GetChildrenCount.this.setCount(kernel.getGridDim().elementCount());
                    } else {
                        GetChildrenCount.this.setCount(0);
                    }
                }
            });
        }

        @Override
        public void visitLane(Lane lane) {
            this.setCount(0);
        }

        @Override
        public void visitSM(StreamingMultiprocessor sm) {
            this.setCount(0);
        }

        @Override
        public void visitThread(DeviceThread deviceThread) {
            this.setCount(0);
        }

        @Override
        public void visitWarp(Warp warp) {
            this.setCount(0);
        }
    }
}

