/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PdmInputDialog
extends TitleAreaDialog {
    private Text txtSize;
    private Text txtStartTime;
    private int pdmSize;
    private long startTime;

    public PdmInputDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Show the part of timeline ");
        this.setMessage("Specify the data size and start time", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.createSizeControl(container);
        this.createStartTimeControl(container);
        return area;
    }

    private void createSizeControl(Composite container) {
        Label label = new Label(container, 0);
        label.setText("Size");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.txtSize = new Text(container, 2048);
        this.txtSize.setLayoutData((Object)data);
        this.txtSize.setText("1");
        this.txtSize.setToolTipText("Enter size of the data in megabytes");
        this.txtSize.addVerifyListener((VerifyListener)new InputVerifyListener());
        label = new Label(container, 0);
        label.setText("Megabytes");
        label.setLayoutData((Object)new GridData(-1, -1));
    }

    private void createStartTimeControl(Composite container) {
        Label label = new Label(container, 0);
        label.setText("Start time");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.txtStartTime = new Text(container, 2048);
        this.txtStartTime.setLayoutData((Object)data);
        this.txtStartTime.setText("0");
        this.txtStartTime.setToolTipText("Enter the start time in milliseconds");
        this.txtStartTime.addVerifyListener((VerifyListener)new InputVerifyListener());
        label = new Label(container, 0);
        label.setText("Milliseconds");
        label.setLayoutData((Object)new GridData(-1, -1));
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.pdmSize = Integer.parseInt(this.txtSize.getText());
        this.startTime = Long.parseLong(this.txtStartTime.getText());
        super.okPressed();
    }

    public int getPdmSize() {
        return this.pdmSize;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private class InputVerifyListener
    implements VerifyListener {
        private InputVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            e.doit = e.text.isEmpty() ? true : e.text.matches("[0-9]+");
        }
    }
}

