/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;

public class CallbackIdUtils {
    public static final int CUPTI_CB_DOMAIN_DRIVER_API = 1;
    public static final int CUPTI_CB_DOMAIN_RUNTIME_API = 2;

    public static String getName(int domain, int cbid, boolean includeVersion) {
        try {
            String callbackName = NativeCupti.cuptiGetCallbackName(domain, cbid);
            if (callbackName == null) {
                return "CBID: " + cbid;
            }
            if (!includeVersion) {
                int vidx = callbackName.lastIndexOf(95);
                return vidx > 0 ? callbackName.substring(0, vidx) : callbackName;
            }
            return callbackName;
        }
        catch (CuptiException e) {
            ViperExceptionHandler.logError("failed to get callback name", e);
            return "CBID: " + cbid;
        }
    }

    public static String getRuntimeName(int cbid, boolean includeVersion) {
        return CallbackIdUtils.getName(2, cbid, includeVersion);
    }

    public static String getDriverName(int cbid, boolean includeVersion) {
        return CallbackIdUtils.getName(1, cbid, includeVersion);
    }
}

