/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.sdk.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public final class CheckboxListFieldEditor
extends FieldEditor {
    private boolean isValid = true;
    private final String[][] labelsValues;
    private Composite pane;
    private String value;

    public CheckboxListFieldEditor(String name, String labelText, String[][] labelsValues, Composite parent) {
        super(name, labelText, parent);
        this.labelsValues = labelsValues;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Composite pane = this.getButtons(null);
        pane.setLayoutData((Object)new GridData(4, 4, true, true, numColumns, 1));
        pane.layout(true);
    }

    public void checkStateChanged(Button button) {
        Control[] children;
        boolean needsSeparator = false;
        StringBuilder builder = new StringBuilder();
        Control[] controlArray = children = this.pane.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button && ((Button)control).getSelection()) {
                if (needsSeparator) {
                    builder.append(",");
                }
                builder.append(control.getData());
                needsSeparator = true;
            }
            ++n2;
        }
        this.validateNotEmpty(builder.length() == 0);
        this.fireValueChanged("field_editor_value", this.value, builder.toString());
        this.value = builder.toString();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.doAddButtons(this.getButtons(parent));
        this.adjustForNumColumns(numColumns);
    }

    private void doAddButtons(Composite buttons) {
        Control[] children;
        Iterator values = Arrays.asList(this.labelsValues == null ? new String[][]{} : this.labelsValues).iterator();
        Control[] controlArray = children = buttons.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Button) {
                if (values.hasNext()) {
                    String[] val = (String[])values.next();
                    child.setData((Object)val[1]);
                    ((Button)child).setText(val[0]);
                } else {
                    child.dispose();
                }
            }
            ++n2;
        }
        while (values.hasNext()) {
            String[] device = (String[])values.next();
            Button button = new Button(this.pane, 32);
            button.setLayoutData((Object)new GridData(768));
            button.setText(device[0]);
            button.setData((Object)device[1]);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CheckboxListFieldEditor.this.checkStateChanged((Button)e.widget);
                }
            });
        }
        this.pane.getParent().layout(true);
        this.pane.layout(true);
    }

    protected void doLoad() {
        this.value = this.getPreferenceStore().getString(this.getPreferenceName());
        this.selectEnabled();
    }

    protected void doLoadDefault() {
        this.value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.selectEnabled();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
    }

    private Composite getButtons(Composite parent) {
        if (this.pane == null || parent != null && parent != this.pane.getParent()) {
            if (this.pane != null) {
                this.pane.dispose();
            }
            this.pane = new Group(parent, 0);
            ((Group)this.pane).setText(this.getLabelText());
            GridLayout layout = new GridLayout(2, true);
            this.pane.setLayout((Layout)layout);
        }
        return this.pane;
    }

    public int getNumberOfControls() {
        return 1;
    }

    private void selectEnabled() {
        int n;
        int n2;
        String[][] stringArray;
        HashSet<String> enabled = new HashSet<String>();
        if (this.value == null || this.value.trim().length() == 0) {
            stringArray = this.labelsValues;
            n2 = this.labelsValues.length;
            n = 0;
            while (n < n2) {
                String[] value = stringArray[n];
                enabled.add(value[1]);
                ++n;
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this.value.trim(), ",", false);
            while (tokenizer.hasMoreTokens()) {
                enabled.add(tokenizer.nextToken().trim());
            }
        }
        this.validateNotEmpty(enabled.isEmpty());
        stringArray = this.pane.getChildren();
        n2 = stringArray.length;
        n = 0;
        while (n < n2) {
            String[] control = stringArray[n];
            if (control instanceof Button) {
                ((Button)control).setSelection(enabled.contains(control.getData()));
            }
            ++n;
        }
    }

    private void validateNotEmpty(boolean isEmpty) {
        if (this.isValid != !isEmpty) {
            this.fireValueChanged("field_editor_is_valid", this.isValid, !isEmpty);
            boolean bl = this.isValid = !isEmpty;
            if (!this.isValid) {
                this.showErrorMessage("No CUDA devices selected");
            } else {
                this.clearErrorMessage();
            }
        }
    }
}

