/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.project.MultiCubin;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public final class AddModuleToAllConfigs
extends Composite
implements SelectionListener {
    private final CLabel label;
    private final Composite buttonsPane;
    private final Collection<Button> buttons = new LinkedList<Button>();
    private MultiCubin cubin;

    public AddModuleToAllConfigs(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout(1, false));
        this.label = new CLabel((Composite)this, 0);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.label.setImage(sharedImages.getImage("IMG_OBJS_WARN_TSK"));
        this.buttonsPane = new Composite((Composite)this, 0);
        this.buttonsPane.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.buttonsPane.setLayout((Layout)new GridLayout(1, false));
    }

    public void setModule(MultiCubin cubin) {
        String[] configurationNames;
        this.cubin = cubin;
        this.label.setText(String.format("Module %s is not defined in all build configurations", cubin.getPath()));
        for (Button button : this.buttons) {
            button.dispose();
        }
        this.buttons.clear();
        String[] stringArray = configurationNames = cubin.getConfigurationNames();
        int n = configurationNames.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Button button = new Button(this.buttonsPane, 0);
            button.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            button.setText(String.format("Copy using \"%s\" as a template", string));
            button.setData((Object)string);
            button.addSelectionListener((SelectionListener)this);
            this.buttons.add(button);
            ++n2;
        }
        this.buttonsPane.layout();
        this.layout();
    }

    public void widgetSelected(SelectionEvent e) {
        Object data = e.widget.getData();
        if (data instanceof String && this.cubin != null) {
            try {
                this.cubin.addToAllConfigurations((String)data);
            }
            catch (CoreException e1) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", e1.getMessage(), (Throwable)e1), 3);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

