/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.core.Activator;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.core.runtime.CoreException;

public final class FindKernelsVisitor
implements ICElementVisitor {
    private final Collection<IFunctionDeclaration> kernels = new TreeSet<IFunctionDeclaration>(new Comparator<IFunctionDeclaration>(){

        @Override
        public int compare(IFunctionDeclaration o1, IFunctionDeclaration o2) {
            try {
                return o1.getSignature().compareTo(o2.getSignature());
            }
            catch (CModelException e) {
                Activator.log((Exception)((Object)e));
                return 0;
            }
        }
    });

    public boolean visit(ICElement element) throws CoreException {
        IFunctionDeclaration functionDeclaration;
        String source;
        int openingBracket;
        if (element.getElementType() == 74 && (openingBracket = (source = (functionDeclaration = (IFunctionDeclaration)element).getSource()).indexOf("(")) > 0) {
            boolean isKernel;
            String substring = source.substring(0, openingBracket);
            boolean bl = isKernel = substring.indexOf("__global__") >= 0;
            if (isKernel) {
                this.kernels.add(functionDeclaration);
            }
        }
        return true;
    }

    public Collection<IFunctionDeclaration> getKernels() {
        return this.kernels;
    }
}

