# Set default packages list for GameMaker games.
# USAGE: packages_list_gamemaker
packages_list_gamemaker() {
	printf '%s\n' \
		'PKG_BIN' \
		'PKG_DATA'
}

# Set default package id for GameMaker games.
# USAGE: package_id_gamemaker $package
package_id_gamemaker() {
	local package
	package="$1"

	local package_id game_id
	game_id=$(game_id)
	case "$package" in
		('PKG_DATA')
			package_id="${game_id}-data"
		;;
	esac

	printf '%s' "${package_id:-}"
}

# Set default package description for GameMaker games.
# USAGE: package_description_gamemaker $package
package_description_gamemaker() {
	local package
	package="$1"

	local package_description
	case "$package" in
		('PKG_DATA')
			package_description='data'
		;;
	esac

	printf '%s' "${package_description:-}"
}

# Set default list of dependencies on sibling packages for GameMaker games.
# USAGE: dependencies_siblings_list_gamemaker $package
dependencies_siblings_list_gamemaker() {
	local package
	package="$1"

	local package_dependencies
	case "$package" in
		('PKG_BIN')
			package_dependencies='
			PKG_DATA'
		;;
	esac

	printf '%s' "${package_dependencies:-}"
}

# Set default list of dependencies on native libraries for GameMaker games.
# USAGE: dependencies_libraries_list_gamemaker $package
dependencies_libraries_list_gamemaker() {
	local package
	package="$1"

	local package_dependencies
	case "$package" in
		('PKG_BIN')
			package_dependencies='
			libc.so.6
			libdl.so.2
			libgcc_s.so.1
			libGL.so.1
			libGLU.so.1
			libm.so.6
			libopenal.so.1
			libpthread.so.0
			librt.so.1
			libssl.so.1.0.0
			libstdc++.so.6
			libX11.so.6
			libXext.so.6
			libXrandr.so.2
			libXxf86vm.so.1
			libz.so.1'
		;;
	esac

	printf '%s' "${package_dependencies:-}"
}

