; Script generated by the HM NIS Edit Script Wizard.

; Other definitions
!define UPXDIR "E:\UPX"
!define GTK_MIN_VER "2.6.10"
!define GTK_PKG_VER "-rc1"

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "TiEmu"
!define PRODUCT_VERSION "3.02a"
!define PRODUCT_PUBLISHER "The TiEmu Team"
!define PRODUCT_WEB_SITE "http://lpg.ticalc.org/prj_tiemu/index.html"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\tiemu.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

SetCompressor /SOLID lzma

!packhdr tmpexe.tmp "${UPXDIR}\upx.exe --best -q tmpexe.tmp"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; Version comparisons
!include "vercmp.nsi"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "..\..\COPYING"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "TiEmu"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\bin\tiemu.exe"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\share\tiemu\Readme.txt"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Setup.exe"
InstallDir "$PROGRAMFILES\TiEmu"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
; Check if GTK+ is installed
  ReadRegStr $0 HKLM "Software\GTK\2.0" "Path"
  StrCmp $0 "" 0 gtkfound
  ReadRegStr $0 HKCU "Software\GTK\2.0" "Path"
  StrCmp $0 "" 0 gtkfound
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION 'GTK+ not found. Please install the "GTK+ 2.6.x Runtime Environment" (${GTK_MIN_VER} or higher). If you proceed, the setup program will be downloaded and launched automatically.' IDOK installgtk IDCANCEL abortinstall
gtkfound:
  ReadRegStr $0 HKLM "Software\GTK\2.0" "Version"
  StrCmp $0 "" 0 gtkverfound
  ReadRegStr $0 HKCU "Software\GTK\2.0" "Version"
  StrCmp $0 "" gtkvernotok
gtkverfound:
  Push "${GTK_MIN_VER}"
  Push $0
  Call CompareVersions
  Pop $0
  IntCmp $0 1 gtkverok
gtkvernotok:
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION 'Wrong GTK+ package version. You need at least version ${GTK_MIN_VER}. If you proceed, the setup program will be downloaded and launched automatically.' IDCANCEL abortinstall
installgtk:
; Connect to the Internet
  ClearErrors
  Dialer::AttemptConnect
  IfErrors gtkinstallfailed
  Pop $0
  StrCmp $0 "online" 0 gtkinstallfailed
; Fetch installer
; Do the download quietly because the GUI isn't even loaded at that point, and because I can't get
; the progress meters to work with the "Modern UI" anyway.
  NSISdl::download_quiet "http://kent.dl.sourceforge.net/gladewin32/gtk-win32-${GTK_MIN_VER}${GTK_PKG_VER}.exe" "$TEMP\gtksetup.exe"
  Pop $0
  StrCmp $0 "cancel" abortinstall
  StrCmp $0 "success" 0 gtkinstallfailed
; Run the installer
  ExecWait '"$TEMP\gtksetup.exe"' $0
  Delete "$TEMP\gtksetup.exe"
; The GTK+ installer is a NSIS installer as well. Errorlevel 1 means canceled by the user.
  IntCmp $0 1 abortinstall
  IntCmp $0 0 0 gtkinstallfailed gtkinstallfailed
; Check again if GTK+ is installed
  ReadRegStr $0 HKLM "Software\GTK\2.0" "Path"
  StrCmp $0 "" 0 gtkverok
  ReadRegStr $0 HKCU "Software\GTK\2.0" "Path"
  StrCmp $0 "" 0 gtkverok
gtkinstallfailed:
  MessageBox MB_OK|MB_ICONSTOP "GTK+ installation failed."
abortinstall:
  Abort
gtkverok:
; Check if libxml is present
  ReadRegStr $0 HKLM "Software\GTK\2.0" "DllPath"
  StrCmp $0 "" 0 gtkdllpathok
  ReadRegStr $0 HKCU "Software\GTK\2.0" "DllPath"
  StrCmp $0 "" 0 gtkdllpathok
  MessageBox MB_OK|MB_ICONSTOP "Invalid GTK+ installation (cannot locate GTK+ DLL path)."
  Abort
gtkdllpathok:
  IfFileExists "$0\libxml2.dll" libxmlfound 0
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION 'Incomplete GTK+ installation: libxml2.dll not found. If you proceed, libxml2-2.6.27.zip will be downloaded and unpacked automatically.' IDOK 0 IDCANCEL abortinstall
; Connect to the Internet
  ClearErrors
  Dialer::AttemptConnect
  IfErrors gtkinstallfailed
  Pop $1
  StrCmp $1 "online" 0 gtkinstallfailed
; Fetch and extract ZIP
  NSISdl::download_quiet "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/libxml2-2.6.27.zip" "$TEMP\libxml2-2.6.27.zip"
  Pop $1
  StrCmp $1 "cancel" abortinstall
  StrCmp $1 "success" 0 gtkinstallfailed
  nsisunz::UnzipToStack /noextractpath /file "bin/libxml2.dll" "$TEMP\libxml2-2.6.27.zip" $0
  Pop $1
  Delete "$TEMP\libxml2-2.6.27.zip"
  StrCmp $1 "success" 0 gtkinstallfailed
libxmlfound:
; Check if libglade is present
  IfFileExists "$0\libglade-2.0-0.dll" libgladefound 0
; Check GTK+ version to get a matching libglade
  ReadRegStr $1 HKLM "Software\GTK\2.0" "Version"
  StrCmp $1 "" 0 gtkverfound2
  ReadRegStr $1 HKCU "Software\GTK\2.0" "Version"
  StrCmp $1 "" 0 gtkverfound2
  MessageBox MB_OK|MB_ICONSTOP "Invalid GTK+ installation (cannot check version)."
  Abort
gtkverfound2:
  Push "2.8.0"
  Push $1
  Call CompareVersions
  Pop $1
  IntCmp $1 1 gtkis28
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION 'Incomplete GTK+ installation: libglade-2.0-0.dll not found. If you proceed, libglade-2.4.0-bin.zip will be downloaded and unpacked automatically.' IDOK 0 IDCANCEL abortinstall
  StrCpy $2 "http://kent.dl.sourceforge.net/gladewin32/libglade-2.4.0-bin.zip"
  Goto gtkis26
gtkis28:
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION 'Incomplete GTK+ installation: libglade-2.0-0.dll not found. If you proceed, libglade-2.6.0.zip will be downloaded and unpacked automatically.' IDOK 0 IDCANCEL abortinstall
  StrCpy $2 "http://ftp.gnome.org/pub/gnome/binaries/win32/libglade/2.6/libglade-2.6.0.zip"
gtkis26:
; Connect to the Internet
  ClearErrors
  Dialer::AttemptConnect
  IfErrors gtkinstallfailed
  Pop $1
  StrCmp $1 "online" 0 gtkinstallfailed
; Fetch and extract ZIP
  NSISdl::download_quiet $2 "$TEMP\libglade-bin.zip"
  Pop $1
  StrCmp $1 "cancel" abortinstall
  StrCmp $1 "success" 0 gtkinstallfailed
  nsisunz::UnzipToStack /noextractpath /file "bin/libglade-2.0-0.dll" "$TEMP\libglade-bin.zip" $0
  Pop $1
  Delete "$TEMP\libglade-bin.zip"
  StrCmp $1 "success" 0 gtkinstallfailed
libgladefound:
; If $INSTDIR points to a Bin\ directory, fix it to point to the root of the tree.
  StrLen $0 $INSTDIR
  IntCmp $0 4 notbin notbin
  IntOp $0 $0 - 4
  StrCpy $1 $INSTDIR "" $0
  StrCmp $1 "\bin" 0 notbin
  StrCpy $INSTDIR $INSTDIR $0
notbin:
FunctionEnd

Section "MainSection" SEC01
; Delete obsolete files
  Delete "$INSTDIR\share\tiemu\skins\emuti92plus.skn"
  Delete "$INSTDIR\share\tiemu\skins\emuti89.skn"
  Delete "$INSTDIR\share\tiemu\glade\comm-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\comm-2.glade"
  Delete "$INSTDIR\include\tilp\update.h"
  Delete "$INSTDIR\include\tilp\tnode.h"
  Delete "$INSTDIR\include\tilp\tikeys.h"
  Delete "$INSTDIR\include\tilp\ticalcs.h"
  Delete "$INSTDIR\include\tilp\pause.h"
  Delete "$INSTDIR\include\tilp\keys92p.h"
  Delete "$INSTDIR\include\tilp\keys89.h"
  Delete "$INSTDIR\include\tilp\keys83p.h"
  Delete "$INSTDIR\include\tilp\keys73.h"
  Delete "$INSTDIR\include\tilp\headers.h"
  Delete "$INSTDIR\include\tilp\calc_ver.h"
  Delete "$INSTDIR\include\tilp\calc_int.h"
  Delete "$INSTDIR\include\tilp\calc_err.h"
  Delete "$INSTDIR\include\tilp\calc_def.h"
  Delete "$INSTDIR\include\tilp\typesxx.h"
  Delete "$INSTDIR\include\tilp\typesv2.h"
  Delete "$INSTDIR\include\tilp\types92p.h"
  Delete "$INSTDIR\include\tilp\types92.h"
  Delete "$INSTDIR\include\tilp\types89.h"
  Delete "$INSTDIR\include\tilp\types86.h"
  Delete "$INSTDIR\include\tilp\types85.h"
  Delete "$INSTDIR\include\tilp\types83p.h"
  Delete "$INSTDIR\include\tilp\types83.h"
  Delete "$INSTDIR\include\tilp\types82.h"
  Delete "$INSTDIR\include\tilp\types73.h"
  Delete "$INSTDIR\include\tilp\tifiles.h"
  Delete "$INSTDIR\include\tilp\stdints.h"
  Delete "$INSTDIR\include\tilp\macros.h"
  Delete "$INSTDIR\include\tilp\grp_ops.h"
  Delete "$INSTDIR\include\tilp\filesxx.h"
  Delete "$INSTDIR\include\tilp\files9x.h"
  Delete "$INSTDIR\include\tilp\files8x.h"
  Delete "$INSTDIR\include\tilp\file_ver.h"
  Delete "$INSTDIR\include\tilp\file_int.h"
  Delete "$INSTDIR\include\tilp\file_err.h"
  Delete "$INSTDIR\include\tilp\file_def.h"
  Delete "$INSTDIR\include\tilp\timeout.h"
  Delete "$INSTDIR\include\tilp\ticables.h"
  Delete "$INSTDIR\include\tilp\export.h"
  Delete "$INSTDIR\include\tilp\cabl_ver.h"
  Delete "$INSTDIR\include\tilp\cabl_int.h"
  Delete "$INSTDIR\include\tilp\cabl_err.h"
  Delete "$INSTDIR\include\tilp\cabl_def.h"
  RMDir "$INSTDIR\include\tilp"
  Delete "$INSTDIR\bin\libticalcs-4.dll"
  Delete "$INSTDIR\bin\libtifiles-0.dll"
  Delete "$INSTDIR\bin\libticables-3.dll"
  Delete "$INSTDIR\lib\libticalcs.la"
  Delete "$INSTDIR\lib\libticalcs.dll.a"
  Delete "$INSTDIR\lib\libtifiles.la"
  Delete "$INSTDIR\lib\libtifiles.dll.a"
  Delete "$INSTDIR\lib\pkgconfig\ticalcs.pc"
  Delete "$INSTDIR\lib\pkgconfig\tifiles.pc"
  Delete "$INSTDIR\lib\pkgconfig\ticables.pc"
  Delete "$INSTDIR\lib\libticables.la"
  Delete "$INSTDIR\lib\libticables.dll.a"
  Delete "$INSTDIR\bin\libticables2-0.dll"
  Delete "$INSTDIR\bin\libticalcs2-0.dll"
  Delete "$INSTDIR\bin\libticalcs2-1.dll"
  Delete "$INSTDIR\bin\libticalcs2-2.dll"
  Delete "$INSTDIR\bin\libticalcs2-6.dll"
  Delete "$INSTDIR\bin\libticonv-0.dll"
  Delete "$INSTDIR\bin\libticonv-1.dll"
  Delete "$INSTDIR\bin\libticonv-2.dll"
  Delete "$INSTDIR\bin\libtifiles2-0.dll"
  Delete "$INSTDIR\bin\libtifiles2-1.dll"
  Delete "$INSTDIR\bin\libtifiles2-2.dll"
  Delete "$INSTDIR\bin\libtifiles2-3.dll"
  Delete "$INSTDIR\bin\libtifiles2-4.dll"
  Delete "$INSTDIR\include\tilp2\stdints.h"
  Delete "$INSTDIR\include\tilp2\macros.h"
  Delete "$INSTDIR\include\tilp2\tnode.h"
  Delete "$INSTDIR\man\man1\tiemu.1"
  RMDir "$INSTDIR\man\man1"
  Delete "$INSTDIR\share\tiemu\glade\about-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\calc-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\device-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_bkpts-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_cause-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_code-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_data-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_entry-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_heap-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_ioports-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_mem-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_pclog-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_regs-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_stack-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dbg_vectors-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\dboxes-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\infos-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\manpage-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\pbars-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\popup-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\quicksend-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\release-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\romversion-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\scroptions-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\wizard-2.gladep"
  Delete "$INSTDIR\share\tiemu\glade\about-2.glade"
  Delete "$INSTDIR\share\tiemu\pixmaps\bkpt_tmp.xpm"
  Delete "$INSTDIR\share\tiemu\pixmaps\run.xpm"

; Install files
  SetOutPath "$INSTDIR\lib"
  File "..\..\..\..\TiEmu\lib\libticables2.dll.a"
  File "..\..\..\..\TiEmu\lib\libticables2.la"
  SetOutPath "$INSTDIR\lib\pkgconfig"
  File "..\..\..\..\TiEmu\lib\pkgconfig\ticables2.pc"
  File "..\..\..\..\TiEmu\lib\pkgconfig\tifiles2.pc"
  File "..\..\..\..\TiEmu\lib\pkgconfig\ticalcs2.pc"
  File "..\..\..\..\TiEmu\lib\pkgconfig\ticonv.pc"
  SetOutPath "$INSTDIR\lib"
  File "..\..\..\..\TiEmu\lib\libtifiles2.dll.a"
  File "..\..\..\..\TiEmu\lib\libtifiles2.la"
  File "..\..\..\..\TiEmu\lib\libticalcs2.dll.a"
  File "..\..\..\..\TiEmu\lib\libticalcs2.la"
  File "..\..\..\..\TiEmu\lib\libticonv.dll.a"
  File "..\..\..\..\TiEmu\lib\libticonv.la"
  SetOutPath "$INSTDIR\lib\dde1.2"
  File "..\..\..\..\TiEmu\lib\dde1.2\tcldde12.dll"
  File "..\..\..\..\TiEmu\lib\dde1.2\pkgIndex.tcl"
  SetOutPath "$INSTDIR\lib\reg1.1"
  File "..\..\..\..\TiEmu\lib\reg1.1\tclreg11.dll"
  File "..\..\..\..\TiEmu\lib\reg1.1\pkgIndex.tcl"
  SetOutPath "$INSTDIR\lib"
  File "..\..\..\..\TiEmu\lib\tclConfig.sh"
  File "..\..\..\..\TiEmu\lib\libtcl84.a"
  File "..\..\..\..\TiEmu\lib\libtclstub84.a"
  SetOutPath "$INSTDIR\lib\tk8.4"
  File "..\..\..\..\TiEmu\lib\tk8.4\pkgIndex.tcl"
  SetOutPath "$INSTDIR\lib"
  File "..\..\..\..\TiEmu\lib\tkConfig.sh"
  File "..\..\..\..\TiEmu\lib\libtk84.a"
  File "..\..\..\..\TiEmu\lib\libtkstub84.a"
  SetOutPath "$INSTDIR\lib\itcl3.2"
  File "..\..\..\..\TiEmu\lib\itcl3.2\pkgIndex.tcl"
  SetOutPath "$INSTDIR\lib"
  File "..\..\..\..\TiEmu\lib\libitclstub32.a"
  SetOutPath "$INSTDIR\lib\itk3.2"
  File "..\..\..\..\TiEmu\lib\itk3.2\pkgIndex.tcl"
  SetOutPath "$INSTDIR\lib"
  File "..\..\..\..\TiEmu\lib\libitkstub32.a"
  SetOutPath "$INSTDIR\bin"
  File "..\..\..\..\TiEmu\bin\libticables2-1.dll"
  File "..\..\..\..\TiEmu\bin\libtifiles2-5.dll"
  File "..\..\..\..\TiEmu\bin\libticalcs2-7.dll"
  File "..\..\..\..\TiEmu\bin\libticonv-3.dll"
  File "..\..\..\..\TiEmu\bin\libusb0.dll"
  File "..\..\..\..\TiEmu\bin\tiemu.exe"
  File "..\..\..\..\TiEmu\bin\tiemu.tlb"
  File "..\..\..\..\TiEmu\bin\tiemups.dll"
  File "..\..\..\..\TiEmu\bin\tcl84.dll"
  File "..\..\..\..\TiEmu\bin\tclsh84.exe"
  File "..\..\..\..\TiEmu\bin\tclpip84.dll"
  File "..\..\..\..\TiEmu\bin\tk84.dll"
  File "..\..\..\..\TiEmu\bin\wish84.exe"
  File "..\..\..\..\TiEmu\bin\itcl32.dll"
  File "..\..\..\..\TiEmu\bin\itk32.dll"
  SetOutPath "$INSTDIR\include\tilp2"
  File "..\..\..\..\TiEmu\include\tilp2\export1.h"
  File "..\..\..\..\TiEmu\include\tilp2\export2.h"
  File "..\..\..\..\TiEmu\include\tilp2\export3.h"
  File "..\..\..\..\TiEmu\include\tilp2\export4.h"
  File "..\..\..\..\TiEmu\include\tilp2\ticables.h"
  File "..\..\..\..\TiEmu\include\tilp2\timeout.h"
  File "..\..\..\..\TiEmu\include\tilp2\files8x.h"
  File "..\..\..\..\TiEmu\include\tilp2\files9x.h"
  File "..\..\..\..\TiEmu\include\tilp2\stdints1.h"
  File "..\..\..\..\TiEmu\include\tilp2\stdints2.h"
  File "..\..\..\..\TiEmu\include\tilp2\stdints3.h"
  File "..\..\..\..\TiEmu\include\tilp2\stdints4.h"
  File "..\..\..\..\TiEmu\include\tilp2\tifiles.h"
  File "..\..\..\..\TiEmu\include\tilp2\types73.h"
  File "..\..\..\..\TiEmu\include\tilp2\types82.h"
  File "..\..\..\..\TiEmu\include\tilp2\types83.h"
  File "..\..\..\..\TiEmu\include\tilp2\types83p.h"
  File "..\..\..\..\TiEmu\include\tilp2\types84p.h"
  File "..\..\..\..\TiEmu\include\tilp2\types85.h"
  File "..\..\..\..\TiEmu\include\tilp2\types86.h"
  File "..\..\..\..\TiEmu\include\tilp2\types89.h"
  File "..\..\..\..\TiEmu\include\tilp2\types89t.h"
  File "..\..\..\..\TiEmu\include\tilp2\types92.h"
  File "..\..\..\..\TiEmu\include\tilp2\types92p.h"
  File "..\..\..\..\TiEmu\include\tilp2\typesv2.h"
  File "..\..\..\..\TiEmu\include\tilp2\typesnsp.h"
  File "..\..\..\..\TiEmu\include\tilp2\typesxx.h"
  File "..\..\..\..\TiEmu\include\tilp2\keys73.h"
  File "..\..\..\..\TiEmu\include\tilp2\keys83p.h"
  File "..\..\..\..\TiEmu\include\tilp2\keys89.h"
  File "..\..\..\..\TiEmu\include\tilp2\keys92p.h"
  File "..\..\..\..\TiEmu\include\tilp2\ticalcs.h"
  File "..\..\..\..\TiEmu\include\tilp2\charset.h"
  File "..\..\..\..\TiEmu\include\tilp2\ticonv.h"
  SetOutPath "$INSTDIR\include"
  File "..\..\..\..\TiEmu\include\tcl.h"
  File "..\..\..\..\TiEmu\include\tclDecls.h"
  File "..\..\..\..\TiEmu\include\tclPlatDecls.h"
  SetOutPath "$INSTDIR\include\X11"
  File "..\..\..\..\TiEmu\include\X11\X.h"
  File "..\..\..\..\TiEmu\include\X11\Xatom.h"
  File "..\..\..\..\TiEmu\include\X11\Xfuncproto.h"
  File "..\..\..\..\TiEmu\include\X11\Xlib.h"
  File "..\..\..\..\TiEmu\include\X11\Xutil.h"
  File "..\..\..\..\TiEmu\include\X11\cursorfont.h"
  File "..\..\..\..\TiEmu\include\X11\keysym.h"
  File "..\..\..\..\TiEmu\include\X11\keysymdef.h"
  SetOutPath "$INSTDIR\include"
  File "..\..\..\..\TiEmu\include\tk.h"
  File "..\..\..\..\TiEmu\include\tkPlatDecls.h"
  File "..\..\..\..\TiEmu\include\tkIntXlibDecls.h"
  File "..\..\..\..\TiEmu\include\tkDecls.h"
  File "..\..\..\..\TiEmu\include\itcl.h"
  File "..\..\..\..\TiEmu\include\itclDecls.h"
  File "..\..\..\..\TiEmu\include\itclInt.h"
  File "..\..\..\..\TiEmu\include\itclIntDecls.h"
  File "..\..\..\..\TiEmu\include\itk.h"
  File "..\..\..\..\TiEmu\include\itkDecls.h"
  SetOutPath "$INSTDIR\share\tiemu\glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\calc-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\device-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_bits-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_bkpts-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_cause-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_code-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_data-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_dock-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_entry-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_heap-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_ioports-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_mem-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_pclog-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_regs-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_stack-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dbg_vectors-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\dboxes-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\infos-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\log_link-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\manpage-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\pbars-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\popup-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\quicksend-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\release-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\romversion-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\scroptions-2.glade"
  File "..\..\..\..\TiEmu\share\tiemu\glade\wizard-2.glade"
  SetOutPath "$INSTDIR\share\tiemu\help"
  File "..\..\..\..\TiEmu\share\tiemu\help\FAQ.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\Manual_en.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter01.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter02.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter03.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter04.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter05.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter06.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter07.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter08.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter09.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter10.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter11.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter20.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter21.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\chapter22.html"
  File "..\..\..\..\TiEmu\share\tiemu\help\calc_infos.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\dbg_bkpts.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\dbg_heap.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\dbg_mem.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\dbg_registers.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\dbg_search.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\dbg_source.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\dbg_sr.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\dbg_stack.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\linkport.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\log_link.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\logo_lpg.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\logo_tiemu.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\no_skin.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\popup_menu.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\romversion.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\screenshot.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\wizard.png"
  File "..\..\..\..\TiEmu\share\tiemu\help\skinedit.jpg"
  File "..\..\..\..\TiEmu\share\tiemu\help\tiemu.jpg"
  SetOutPath "$INSTDIR\share\tiemu\pedrom"
  File "..\..\..\..\TiEmu\share\tiemu\pedrom\pedrom89.tib"
  File "..\..\..\..\TiEmu\share\tiemu\pedrom\pedrom89ti.tib"
  File "..\..\..\..\TiEmu\share\tiemu\pedrom\pedrom9x.tib"
  File "..\..\..\..\TiEmu\share\tiemu\pedrom\pedromv2.tib"
  File "..\..\..\..\TiEmu\share\tiemu\pedrom\pedrom.txt"
  SetOutPath "$INSTDIR\share\tiemu\misc"
  File "..\..\..\..\TiEmu\share\tiemu\misc\iodefs_ti89_hw1.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\iodefs_ti89_hw2.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\iodefs_ti89t_hw3.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\iodefs_ti89t_hw4.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\iodefs_ti92_hw1.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\iodefs_ti92p_hw1.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\iodefs_ti92p_hw2.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\iodefs_v200_hw2.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\memmap_ti89_hw1.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\memmap_ti89_hw2.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\memmap_ti89t_hw3.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\memmap_ti89t_hw4.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\memmap_ti92_hw1.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\memmap_ti92p_hw1.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\memmap_ti92p_hw2.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\memmap_v200_hw2.txt"
  File "..\..\..\..\TiEmu\share\tiemu\misc\romcalls.txt"
  SetOutPath "$INSTDIR\share\tiemu\pixmaps"
  File "..\..\..\..\TiEmu\share\tiemu\pixmaps\bkpt.xpm"
  File "..\..\..\..\TiEmu\share\tiemu\pixmaps\icon.xpm"
  File "..\..\..\..\TiEmu\share\tiemu\pixmaps\logo.xpm"
  File "..\..\..\..\TiEmu\share\tiemu\pixmaps\romdump.ico"
  File "..\..\..\..\TiEmu\share\tiemu\pixmaps\romdump.xpm"
  File "..\..\..\..\TiEmu\share\tiemu\pixmaps\run_1.xpm"
  File "..\..\..\..\TiEmu\share\tiemu\pixmaps\run_2.xpm"
  File "..\..\..\..\TiEmu\share\tiemu\pixmaps\void.xpm"
  SetOutPath "$INSTDIR\share\tiemu\skins"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ipaq_89.skn"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ipaq_92.skn"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ipaq_v200plt.skn"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ti89.skn"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ti89t.skn"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ti92.skn"
  File "..\..\..\..\TiEmu\share\tiemu\skins\v200plt.skn"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ti89.map"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ti89_fr.map"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ti92.map"
  File "..\..\..\..\TiEmu\share\tiemu\skins\ti92_fr.map"
  SetOutPath "$INSTDIR\share\tiemu"
  File "..\..\..\..\TiEmu\share\tiemu\COPYING"
  File "..\..\..\..\TiEmu\share\tiemu\RELEASE"
  File "..\..\..\..\TiEmu\share\tiemu\AUTHORS"
  File "..\..\..\..\TiEmu\share\tiemu\LICENSES"
  File "..\..\..\..\TiEmu\share\tiemu\Manpage.txt"
  File "Readme.txt"
  SetOutPath "$INSTDIR\share\tcl8.4\http1.0"
  File "..\..\..\..\TiEmu\share\tcl8.4\http1.0\http.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\http1.0\pkgIndex.tcl"
  SetOutPath "$INSTDIR\share\tcl8.4\http2.4"
  File "..\..\..\..\TiEmu\share\tcl8.4\http2.4\http.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\http2.4\pkgIndex.tcl"
  SetOutPath "$INSTDIR\share\tcl8.4\opt0.4"
  File "..\..\..\..\TiEmu\share\tcl8.4\opt0.4\optparse.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\opt0.4\pkgIndex.tcl"
  SetOutPath "$INSTDIR\share\tcl8.4\encoding"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\ascii.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\big5.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1250.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1251.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1252.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1253.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1254.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1255.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1256.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1257.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp1258.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp437.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp737.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp775.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp850.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp852.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp855.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp857.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp860.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp861.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp862.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp863.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp864.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp865.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp866.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp869.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp874.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp932.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp936.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp949.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\cp950.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\dingbats.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\ebcdic.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\euc-cn.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\euc-jp.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\euc-kr.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\gb12345.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\gb1988.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\gb2312.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso2022-jp.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso2022-kr.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso2022.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-1.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-10.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-13.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-14.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-15.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-16.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-2.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-3.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-4.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-5.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-6.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-7.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-8.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\iso8859-9.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\jis0201.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\jis0208.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\jis0212.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\koi8-r.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\koi8-u.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\ksc5601.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macCentEuro.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macCroatian.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macCyrillic.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macDingbats.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macGreek.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macIceland.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macJapan.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macRoman.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macRomania.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macThai.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macTurkish.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\macUkraine.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\shiftjis.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\symbol.enc"
  File "..\..\..\..\TiEmu\share\tcl8.4\encoding\tis-620.enc"
  SetOutPath "$INSTDIR\share\tcl8.4\msgcat1.3"
  File "..\..\..\..\TiEmu\share\tcl8.4\msgcat1.3\msgcat.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\msgcat1.3\pkgIndex.tcl"
  SetOutPath "$INSTDIR\share\tcl8.4\tcltest2.2"
  File "..\..\..\..\TiEmu\share\tcl8.4\tcltest2.2\pkgIndex.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\tcltest2.2\tcltest.tcl"
  SetOutPath "$INSTDIR\share\tcl8.4"
  File "..\..\..\..\TiEmu\share\tcl8.4\auto.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\history.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\init.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\ldAout.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\package.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\parray.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\safe.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\word.tcl"
  File "..\..\..\..\TiEmu\share\tcl8.4\tclIndex"
  SetOutPath "$INSTDIR\share\tk8.4\images"
  File "..\..\..\..\TiEmu\share\tk8.4\images\README"
  File "..\..\..\..\TiEmu\share\tk8.4\images\logo.eps"
  File "..\..\..\..\TiEmu\share\tk8.4\images\logo100.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\logo64.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\logoLarge.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\logoMed.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\pwrdLogo.eps"
  File "..\..\..\..\TiEmu\share\tk8.4\images\pwrdLogo100.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\pwrdLogo150.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\pwrdLogo175.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\pwrdLogo200.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\pwrdLogo75.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\images\tai-ku.gif"
  SetOutPath "$INSTDIR\share\tk8.4\msgs"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\cs.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\de.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\el.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\en.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\en_gb.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\es.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\fr.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\it.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\nl.msg"
  File "..\..\..\..\TiEmu\share\tk8.4\msgs\ru.msg"
  SetOutPath "$INSTDIR\share\tk8.4"
  File "..\..\..\..\TiEmu\share\tk8.4\bgerror.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\button.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\choosedir.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\clrpick.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\comdlg.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\console.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\dialog.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\entry.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\focus.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\listbox.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\menu.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\mkpsenc.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\msgbox.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\obsolete.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\optMenu.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\palette.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\panedwindow.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\safetk.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\scale.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\scrlbar.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\spinbox.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\tearoff.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\text.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\tk.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\tkfbox.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\unsupported.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\xmfbox.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\prolog.ps"
  File "..\..\..\..\TiEmu\share\tk8.4\tclIndex"
  File "..\..\..\..\TiEmu\share\tk8.4\tkAppInit.c"
  SetOutPath "$INSTDIR\share\tk8.4\demos\images"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\earth.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\earthris.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\face.bmp"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\flagdown.bmp"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\flagup.bmp"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\gray25.bmp"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\letters.bmp"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\noletter.bmp"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\pattern.bmp"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\tcllogo.gif"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\images\teapot.ppm"
  SetOutPath "$INSTDIR\share\tk8.4\demos"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\README"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\arrow.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\bind.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\bitmap.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\browse"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\button.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\check.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\clrpick.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\colors.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\cscroll.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\ctext.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\dialog1.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\dialog2.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\entry1.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\entry2.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\entry3.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\filebox.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\floor.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\form.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\hello"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\hscale.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\icon.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\image1.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\image2.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\items.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\ixset"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\label.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\labelframe.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\license.terms"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\menu.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\menubu.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\msgbox.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\paned1.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\paned2.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\plot.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\puzzle.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\radio.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\rmt"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\rolodex"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\ruler.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\sayings.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\search.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\spin.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\square"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\states.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\style.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\tclIndex"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\tcolor"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\text.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\timer"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\twind.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\vscale.tcl"
  File "..\..\..\..\TiEmu\share\tk8.4\demos\widget"
  SetOutPath "$INSTDIR\share\itcl3.2"
  File "..\..\..\..\TiEmu\share\itcl3.2\itcl.tcl"
  SetOutPath "$INSTDIR\share\itk3.2"
  File "..\..\..\..\TiEmu\share\itk3.2\Archetype.itk"
  File "..\..\..\..\TiEmu\share\itk3.2\Toplevel.itk"
  File "..\..\..\..\TiEmu\share\itk3.2\Widget.itk"
  File "..\..\..\..\TiEmu\share\itk3.2\itk.tcl"
  File "..\..\..\..\TiEmu\share\itk3.2\tclIndex"
  SetOutPath "$INSTDIR\share\iwidgets4.0.1\scripts"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\buttonbox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\calendar.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\canvasprintbox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\canvasprintdialog.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\checkbox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\combobox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\dateentry.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\datefield.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\dialog.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\dialogshell.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\disjointlistbox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\entryfield.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\extbutton.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\extfileselectionbox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\extfileselectiondialog.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\feedback.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\fileselectionbox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\fileselectiondialog.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\finddialog.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\hierarchy.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\hyperhelp.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\labeledframe.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\labeledwidget.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\mainwindow.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\menubar.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\messagebox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\messagedialog.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\notebook.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\optionmenu.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\pane.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\panedwindow.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\promptdialog.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\pushbutton.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\radiobox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\regexpfield.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\scrolledcanvas.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\scrolledframe.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\scrolledhtml.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\scrolledlistbox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\scrolledtext.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\scrolledwidget.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\selectionbox.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\selectiondialog.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\shell.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\spindate.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\spinint.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\spinner.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\spintime.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\tabnotebook.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\tabset.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\timeentry.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\timefield.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\toolbar.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\watch.itk"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\colors.itcl"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\roman.itcl"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\scopedobject.itcl"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\tclIndex"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\scripts\unknownimage.gif"
  SetOutPath "$INSTDIR\share\iwidgets4.0.1"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\iwidgets.tcl"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\pkgIndex.tcl"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\license.terms"
  SetOutPath "$INSTDIR\share\iwidgets4.0.1\demos\images"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\box.xbm"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\clear.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\close.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\copy.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\cut.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\exit.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\find.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\help.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\line.xbm"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\mag.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\new.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\open.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\oval.xbm"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\paste.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\points.xbm"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\poly.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\print.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\ruler.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\save.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\select.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\images\text.xbm"
  SetOutPath "$INSTDIR\share\iwidgets4.0.1\demos\html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\buttonbox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\calendar.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\canvasprintbox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\canvasprintdialog.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\checkbox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\combobox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\dateentry.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\datefield.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\dialog.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\dialogshell.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\disjointlistbox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\entryfield.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\extbutton.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\extfileselectionbox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\extfileselectiondialog.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\feedback.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\fileselectionbox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\fileselectiondialog.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\finddialog.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\hierarchy.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\hyperhelp.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\iwidgets4.0.0UserCmds.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\labeledframe.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\labeledwidget.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\mainwindow.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\menubar.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\messagebox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\messagedialog.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\notebook.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\optionmenu.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\panedwindow.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\promptdialog.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\pushbutton.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\radiobox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\scopedobject.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\scrolledcanvas.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\scrolledframe.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\scrolledhtml.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\scrolledlistbox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\scrolledtext.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\selectionbox.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\selectiondialog.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\shell.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\spindate.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\spinint.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\spinner.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\spintime.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\tabnotebook.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\tabset.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\timeentry.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\timefield.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\toolbar.n.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\html\watch.n.html"
  SetOutPath "$INSTDIR\share\iwidgets4.0.1\demos"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\buttonbox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\calendar"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\canvasprintbox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\canvasprintdialog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\catalog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\checkbox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\combobox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\dateentry"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\datefield"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\demo.html"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\dialog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\dialogshell"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\disjointlistbox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\entryfield"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\extbutton"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\extfileselectionbox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\extfileselectiondialog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\feedback"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\fileselectionbox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\fileselectiondialog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\finddialog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\hierarchy"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\hyperhelp"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\iwidgets.gif"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\labeledframe"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\labeledwidget"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\mainwindow"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\menubar"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\messagebox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\messagedialog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\notebook"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\optionmenu"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\panedwindow"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\promptdialog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\pushbutton"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\radiobox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\scopedobject"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\scrolledcanvas"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\scrolledframe"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\scrolledhtml"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\scrolledlistbox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\scrolledtext"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\selectionbox"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\selectiondialog"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\shell"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\spindate"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\spinint"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\spinner"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\spintime"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\tabnotebook"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\tabset"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\timeentry"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\timefield"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\toolbar"
  File "..\..\..\..\TiEmu\share\iwidgets4.0.1\demos\watch"
  SetOutPath "$INSTDIR\share\redhat\gui"
  File "..\..\..\..\TiEmu\share\redhat\gui\tclIndex"
  File "..\..\..\..\TiEmu\share\redhat\gui\pkgIndex.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\advice.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\balloon.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\bbox.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\bgerror.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\bindings.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\canvas.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\cframe.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\center.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\debug.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\def.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\internet.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\font.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\gensym.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\gettext.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\hooks.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\lframe.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\list.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\looknfeel.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\menu.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\mono.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\multibox.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\parse_args.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\path.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\postghost.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\prefs.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\print.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\sendpr.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\topbind.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\toolbar.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\ulset.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\wframe.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\wingrab.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\ventry.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\combobox.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\pane.tcl"
  File "..\..\..\..\TiEmu\share\redhat\gui\panedwindow.tcl"
  SetOutPath "$INSTDIR\share\insight1.0\images"
  File "..\..\..\..\TiEmu\share\insight1.0\images\Movie_off.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\Movie_on.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\bottom.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\bp.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\check.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\console.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\continue.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\down.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\edit.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\finish.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\gdbtk_icon.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\help.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\home.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\insight.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\less.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\memory.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\more.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\next.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\next_check.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\next_frame.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\next_hit.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\next_line.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\nexti.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\open.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\prev_hit.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\reg.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\rewind.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\run.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\run_expt.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\src.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\stack.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\step.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\stepi.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\stop.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\tdump.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\tp.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\up.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\vars.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\watch.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\watch_movie.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images\icons.txt"
  SetOutPath "$INSTDIR\share\insight1.0\images2"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\Movie_off.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\Movie_on.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\bottom.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\bp.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\check.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\console.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\continue.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\down.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\edit.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\finish.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\function.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\gdbtk_icon.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\help.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\home.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\insight.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\less.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\memory.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\more.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\next.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\next_check.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\next_frame.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\next_hit.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\next_line.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\nexti.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\open.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\prev_hit.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\reg.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\rewind.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\run.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\run_expt.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\src.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\stack.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\step.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\stepi.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\stop.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\target.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\tdump.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\tp.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\up.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\vars.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\watch.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\watch_movie.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\images2\icons.txt"
  SetOutPath "$INSTDIR\share\insight1.0\help\images"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\frame_info.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\mem_menu.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\mem_popup.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\mem_pref.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\src_bal.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\src_bp_bal.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\src_bpop.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\src_menu.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\src_pop.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\src_stat.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\src_thread.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\src_toolbar.gif"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\browser1.png"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\browser2.png"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\insightbwr.png"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\reg.png"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\reg_menu.png"
  File "..\..\..\..\TiEmu\share\insight1.0\help\images\watch.png"
  SetOutPath "$INSTDIR\share\insight1.0\help\trace"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\console.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\gbl_pref.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\help.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\license.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\locals.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\memory.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\reg_pref.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\register.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\source.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\src_pref.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\stack.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\target.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\tdump.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\tp.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\tracedlg.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\watch.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\trace\index.toc"
  SetOutPath "$INSTDIR\share\insight1.0\help"
  File "..\..\..\..\TiEmu\share\insight1.0\help\breakpoint.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\browser.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\console.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\debug.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\gbl_pref.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\help.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\index.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\license.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\locals.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\memory.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\register.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\session.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\source.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\src_pref.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\stack.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\target.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\thread.html"
  File "..\..\..\..\TiEmu\share\insight1.0\help\watch.html"
  SetOutPath "$INSTDIR\share\insight1.0"
  File "..\..\..\..\TiEmu\share\insight1.0\about.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\actiondlg.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\editor.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\helpviewer.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\interface.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\ipc.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\locals.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\main.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\modal.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\prefs.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\session.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\tdump.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\tfind_args.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\tracedlg.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\tty.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\util.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\warning.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\watch.tcl"
  File "..\..\..\..\TiEmu\share\insight1.0\gdbmenubar.itcl"
  File "..\..\..\..\TiEmu\share\insight1.0\gdbtoolbar.itcl"
  File "..\..\..\..\TiEmu\share\insight1.0\pluginwin.itcl"
  File "..\..\..\..\TiEmu\share\insight1.0\srcbar.itcl"
  File "..\..\..\..\TiEmu\share\insight1.0\attachdlg.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\blockframe.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\bpwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\browserwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\console.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\cspref.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\debugwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\download.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\ehandler.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\embeddedwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\gdbevent.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\gdbwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\globalpref.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\ipcpref.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\kod.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\managedwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\mempref.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\memwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\process.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\regwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\srcpref.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\srctextwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\srcwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\stackwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\targetselection.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\toplevelwin.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\vartree.ith"
  File "..\..\..\..\TiEmu\share\insight1.0\attachdlg.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\blockframe.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\bpwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\browserwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\console.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\cspref.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\debugwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\download.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\ehandler.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\gdbevent.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\globalpref.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\ipcpref.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\kod.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\managedwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\mempref.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\memwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\process.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\regwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\srcpref.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\srctextwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\srcwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\stackwin.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\targetselection.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\vartree.itb"
  File "..\..\..\..\TiEmu\share\insight1.0\tclIndex"
  SetOutPath "$INSTDIR\share\man\man1"
  File "..\..\..\..\TiEmu\share\man\man1\tiemu.1"
  SetOutPath "$INSTDIR\man\mann"
  File "..\..\..\..\TiEmu\man\mann\body.n"
  File "..\..\..\..\TiEmu\man\mann\class.n"
  File "..\..\..\..\TiEmu\man\mann\code.n"
  File "..\..\..\..\TiEmu\man\mann\configbody.n"
  File "..\..\..\..\TiEmu\man\mann\delete.n"
  File "..\..\..\..\TiEmu\man\mann\ensemble.n"
  File "..\..\..\..\TiEmu\man\mann\find.n"
  File "..\..\..\..\TiEmu\man\mann\itcl.n"
  File "..\..\..\..\TiEmu\man\mann\itcl_class.n"
  File "..\..\..\..\TiEmu\man\mann\itcl_info.n"
  File "..\..\..\..\TiEmu\man\mann\itclvars.n"
  File "..\..\..\..\TiEmu\man\mann\local.n"
  File "..\..\..\..\TiEmu\man\mann\scope.n"
  File "..\..\..\..\TiEmu\man\mann\Archetype.n"
  File "..\..\..\..\TiEmu\man\mann\Toplevel.n"
  File "..\..\..\..\TiEmu\man\mann\Widget.n"
  File "..\..\..\..\TiEmu\man\mann\itk.n"
  File "..\..\..\..\TiEmu\man\mann\itkvars.n"
  File "..\..\..\..\TiEmu\man\mann\usual.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_buttonbox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_calendar.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_canvasprintbox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_canvasprintdialog.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_checkbox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_combobox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_dateentry.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_datefield.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_dialog.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_dialogshell.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_disjointlistbox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_entryfield.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_extbutton.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_extfileselectionbox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_extfileselectiondialog.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_feedback.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_fileselectionbox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_fileselectiondialog.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_finddialog.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_hierarchy.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_hyperhelp.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_labeledframe.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_labeledwidget.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_mainwindow.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_menubar.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_messagebox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_messagedialog.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_notebook.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_optionmenu.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_panedwindow.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_promptdialog.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_pushbutton.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_radiobox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_scopedobject.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_scrolledcanvas.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_scrolledframe.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_scrolledhtml.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_scrolledlistbox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_scrolledtext.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_selectionbox.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_selectiondialog.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_shell.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_spindate.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_spinint.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_spinner.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_spintime.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_tabnotebook.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_tabset.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_timeentry.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_timefield.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_toolbar.n"
  File "..\..\..\..\TiEmu\man\mann\iwidgets_watch.n"

; OLE Registration
  ExecWait '"$INSTDIR\bin\tiemu.exe" /RegServer'
  RegDLL "$INSTDIR\bin\tiemups.dll"

; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\TiEmu.lnk" "$INSTDIR\bin\tiemu.exe"
  CreateShortCut "$DESKTOP\TiEmu.lnk" "$INSTDIR\bin\tiemu.exe"
  !insertmacro MUI_STARTMENU_WRITE_END

; File associations
  WriteRegStr HKCR ".sav" "" "TiEmu.Sav"
  WriteRegStr HKCR "TiEmu.Sav" "" "TiEmu state"
  WriteRegStr HKCR "TiEmu.Sav\DefaultIcon" "" "$INSTDIR\bin\tiemu.exe,0"
  WriteRegStr HKCR "TiEmu.Sav\shell\open" "" "Open with &TiEmu"
  WriteRegStr HKCR "TiEmu.Sav\shell\open\command" "" '"$INSTDIR\bin\tiemu.exe" "%1"'

  WriteRegStr HKCR ".rom" "" "TiEmu.Rom"
  WriteRegStr HKCR "TiEmu.Rom" "" "Rom Dump"
  WriteRegStr HKCR "TiEmu.Rom\DefaultIcon" "" "$INSTDIR\share\tiemu\pixmaps\romdump.ico"
  WriteRegStr HKCR "TiEmu.Rom\shell\open" "" "Open with &TiEmu"
  WriteRegStr HKCR "TiEmu.Rom\shell\open\command" "" '"$INSTDIR\bin\tiemu.exe" "%1"'
SectionEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Readme.lnk" "$INSTDIR\share\tiemu\Readme.txt"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\bin\tiemu.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\bin\tiemu.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP

; File associations
  DeleteRegKey HKCR "TiEmu.Rom"
  DeleteRegKey HKCR ".rom"
  DeleteRegKey HKCR "TiEmu.Sav"
  DeleteRegKey HKCR ".sav"

; OLE Unregistration
  UnregDLL "$INSTDIR\bin\tiemups.dll"
  ExecWait '"$INSTDIR\bin\tiemu.exe" /UnregServer'

  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\man\mann\iwidgets_watch.n"
  Delete "$INSTDIR\man\mann\iwidgets_toolbar.n"
  Delete "$INSTDIR\man\mann\iwidgets_timefield.n"
  Delete "$INSTDIR\man\mann\iwidgets_timeentry.n"
  Delete "$INSTDIR\man\mann\iwidgets_tabset.n"
  Delete "$INSTDIR\man\mann\iwidgets_tabnotebook.n"
  Delete "$INSTDIR\man\mann\iwidgets_spintime.n"
  Delete "$INSTDIR\man\mann\iwidgets_spinner.n"
  Delete "$INSTDIR\man\mann\iwidgets_spinint.n"
  Delete "$INSTDIR\man\mann\iwidgets_spindate.n"
  Delete "$INSTDIR\man\mann\iwidgets_shell.n"
  Delete "$INSTDIR\man\mann\iwidgets_selectiondialog.n"
  Delete "$INSTDIR\man\mann\iwidgets_selectionbox.n"
  Delete "$INSTDIR\man\mann\iwidgets_scrolledtext.n"
  Delete "$INSTDIR\man\mann\iwidgets_scrolledlistbox.n"
  Delete "$INSTDIR\man\mann\iwidgets_scrolledhtml.n"
  Delete "$INSTDIR\man\mann\iwidgets_scrolledframe.n"
  Delete "$INSTDIR\man\mann\iwidgets_scrolledcanvas.n"
  Delete "$INSTDIR\man\mann\iwidgets_scopedobject.n"
  Delete "$INSTDIR\man\mann\iwidgets_radiobox.n"
  Delete "$INSTDIR\man\mann\iwidgets_pushbutton.n"
  Delete "$INSTDIR\man\mann\iwidgets_promptdialog.n"
  Delete "$INSTDIR\man\mann\iwidgets_panedwindow.n"
  Delete "$INSTDIR\man\mann\iwidgets_optionmenu.n"
  Delete "$INSTDIR\man\mann\iwidgets_notebook.n"
  Delete "$INSTDIR\man\mann\iwidgets_messagedialog.n"
  Delete "$INSTDIR\man\mann\iwidgets_messagebox.n"
  Delete "$INSTDIR\man\mann\iwidgets_menubar.n"
  Delete "$INSTDIR\man\mann\iwidgets_mainwindow.n"
  Delete "$INSTDIR\man\mann\iwidgets_labeledwidget.n"
  Delete "$INSTDIR\man\mann\iwidgets_labeledframe.n"
  Delete "$INSTDIR\man\mann\iwidgets_hyperhelp.n"
  Delete "$INSTDIR\man\mann\iwidgets_hierarchy.n"
  Delete "$INSTDIR\man\mann\iwidgets_finddialog.n"
  Delete "$INSTDIR\man\mann\iwidgets_fileselectiondialog.n"
  Delete "$INSTDIR\man\mann\iwidgets_fileselectionbox.n"
  Delete "$INSTDIR\man\mann\iwidgets_feedback.n"
  Delete "$INSTDIR\man\mann\iwidgets_extfileselectiondialog.n"
  Delete "$INSTDIR\man\mann\iwidgets_extfileselectionbox.n"
  Delete "$INSTDIR\man\mann\iwidgets_extbutton.n"
  Delete "$INSTDIR\man\mann\iwidgets_entryfield.n"
  Delete "$INSTDIR\man\mann\iwidgets_disjointlistbox.n"
  Delete "$INSTDIR\man\mann\iwidgets_dialogshell.n"
  Delete "$INSTDIR\man\mann\iwidgets_dialog.n"
  Delete "$INSTDIR\man\mann\iwidgets_datefield.n"
  Delete "$INSTDIR\man\mann\iwidgets_dateentry.n"
  Delete "$INSTDIR\man\mann\iwidgets_combobox.n"
  Delete "$INSTDIR\man\mann\iwidgets_checkbox.n"
  Delete "$INSTDIR\man\mann\iwidgets_canvasprintdialog.n"
  Delete "$INSTDIR\man\mann\iwidgets_canvasprintbox.n"
  Delete "$INSTDIR\man\mann\iwidgets_calendar.n"
  Delete "$INSTDIR\man\mann\iwidgets_buttonbox.n"
  Delete "$INSTDIR\man\mann\usual.n"
  Delete "$INSTDIR\man\mann\itkvars.n"
  Delete "$INSTDIR\man\mann\itk.n"
  Delete "$INSTDIR\man\mann\Widget.n"
  Delete "$INSTDIR\man\mann\Toplevel.n"
  Delete "$INSTDIR\man\mann\Archetype.n"
  Delete "$INSTDIR\man\mann\scope.n"
  Delete "$INSTDIR\man\mann\local.n"
  Delete "$INSTDIR\man\mann\itclvars.n"
  Delete "$INSTDIR\man\mann\itcl_info.n"
  Delete "$INSTDIR\man\mann\itcl_class.n"
  Delete "$INSTDIR\man\mann\itcl.n"
  Delete "$INSTDIR\man\mann\find.n"
  Delete "$INSTDIR\man\mann\ensemble.n"
  Delete "$INSTDIR\man\mann\delete.n"
  Delete "$INSTDIR\man\mann\configbody.n"
  Delete "$INSTDIR\man\mann\code.n"
  Delete "$INSTDIR\man\mann\class.n"
  Delete "$INSTDIR\man\mann\body.n"
  Delete "$INSTDIR\share\man\man1\tiemu.1"
  Delete "$INSTDIR\share\insight1.0\tclIndex"
  Delete "$INSTDIR\share\insight1.0\vartree.itb"
  Delete "$INSTDIR\share\insight1.0\targetselection.itb"
  Delete "$INSTDIR\share\insight1.0\stackwin.itb"
  Delete "$INSTDIR\share\insight1.0\srcwin.itb"
  Delete "$INSTDIR\share\insight1.0\srctextwin.itb"
  Delete "$INSTDIR\share\insight1.0\srcpref.itb"
  Delete "$INSTDIR\share\insight1.0\regwin.itb"
  Delete "$INSTDIR\share\insight1.0\process.itb"
  Delete "$INSTDIR\share\insight1.0\memwin.itb"
  Delete "$INSTDIR\share\insight1.0\mempref.itb"
  Delete "$INSTDIR\share\insight1.0\managedwin.itb"
  Delete "$INSTDIR\share\insight1.0\kod.itb"
  Delete "$INSTDIR\share\insight1.0\ipcpref.itb"
  Delete "$INSTDIR\share\insight1.0\globalpref.itb"
  Delete "$INSTDIR\share\insight1.0\gdbevent.itb"
  Delete "$INSTDIR\share\insight1.0\ehandler.itb"
  Delete "$INSTDIR\share\insight1.0\download.itb"
  Delete "$INSTDIR\share\insight1.0\debugwin.itb"
  Delete "$INSTDIR\share\insight1.0\cspref.itb"
  Delete "$INSTDIR\share\insight1.0\console.itb"
  Delete "$INSTDIR\share\insight1.0\browserwin.itb"
  Delete "$INSTDIR\share\insight1.0\bpwin.itb"
  Delete "$INSTDIR\share\insight1.0\blockframe.itb"
  Delete "$INSTDIR\share\insight1.0\attachdlg.itb"
  Delete "$INSTDIR\share\insight1.0\vartree.ith"
  Delete "$INSTDIR\share\insight1.0\toplevelwin.ith"
  Delete "$INSTDIR\share\insight1.0\targetselection.ith"
  Delete "$INSTDIR\share\insight1.0\stackwin.ith"
  Delete "$INSTDIR\share\insight1.0\srcwin.ith"
  Delete "$INSTDIR\share\insight1.0\srctextwin.ith"
  Delete "$INSTDIR\share\insight1.0\srcpref.ith"
  Delete "$INSTDIR\share\insight1.0\regwin.ith"
  Delete "$INSTDIR\share\insight1.0\process.ith"
  Delete "$INSTDIR\share\insight1.0\memwin.ith"
  Delete "$INSTDIR\share\insight1.0\mempref.ith"
  Delete "$INSTDIR\share\insight1.0\managedwin.ith"
  Delete "$INSTDIR\share\insight1.0\kod.ith"
  Delete "$INSTDIR\share\insight1.0\ipcpref.ith"
  Delete "$INSTDIR\share\insight1.0\globalpref.ith"
  Delete "$INSTDIR\share\insight1.0\gdbwin.ith"
  Delete "$INSTDIR\share\insight1.0\gdbevent.ith"
  Delete "$INSTDIR\share\insight1.0\embeddedwin.ith"
  Delete "$INSTDIR\share\insight1.0\ehandler.ith"
  Delete "$INSTDIR\share\insight1.0\download.ith"
  Delete "$INSTDIR\share\insight1.0\debugwin.ith"
  Delete "$INSTDIR\share\insight1.0\cspref.ith"
  Delete "$INSTDIR\share\insight1.0\console.ith"
  Delete "$INSTDIR\share\insight1.0\browserwin.ith"
  Delete "$INSTDIR\share\insight1.0\bpwin.ith"
  Delete "$INSTDIR\share\insight1.0\blockframe.ith"
  Delete "$INSTDIR\share\insight1.0\attachdlg.ith"
  Delete "$INSTDIR\share\insight1.0\srcbar.itcl"
  Delete "$INSTDIR\share\insight1.0\pluginwin.itcl"
  Delete "$INSTDIR\share\insight1.0\gdbtoolbar.itcl"
  Delete "$INSTDIR\share\insight1.0\gdbmenubar.itcl"
  Delete "$INSTDIR\share\insight1.0\watch.tcl"
  Delete "$INSTDIR\share\insight1.0\warning.tcl"
  Delete "$INSTDIR\share\insight1.0\util.tcl"
  Delete "$INSTDIR\share\insight1.0\tty.tcl"
  Delete "$INSTDIR\share\insight1.0\tracedlg.tcl"
  Delete "$INSTDIR\share\insight1.0\tfind_args.tcl"
  Delete "$INSTDIR\share\insight1.0\tdump.tcl"
  Delete "$INSTDIR\share\insight1.0\session.tcl"
  Delete "$INSTDIR\share\insight1.0\prefs.tcl"
  Delete "$INSTDIR\share\insight1.0\modal.tcl"
  Delete "$INSTDIR\share\insight1.0\main.tcl"
  Delete "$INSTDIR\share\insight1.0\locals.tcl"
  Delete "$INSTDIR\share\insight1.0\ipc.tcl"
  Delete "$INSTDIR\share\insight1.0\interface.tcl"
  Delete "$INSTDIR\share\insight1.0\helpviewer.tcl"
  Delete "$INSTDIR\share\insight1.0\editor.tcl"
  Delete "$INSTDIR\share\insight1.0\actiondlg.tcl"
  Delete "$INSTDIR\share\insight1.0\about.tcl"
  Delete "$INSTDIR\share\insight1.0\help\watch.html"
  Delete "$INSTDIR\share\insight1.0\help\thread.html"
  Delete "$INSTDIR\share\insight1.0\help\target.html"
  Delete "$INSTDIR\share\insight1.0\help\stack.html"
  Delete "$INSTDIR\share\insight1.0\help\src_pref.html"
  Delete "$INSTDIR\share\insight1.0\help\source.html"
  Delete "$INSTDIR\share\insight1.0\help\session.html"
  Delete "$INSTDIR\share\insight1.0\help\register.html"
  Delete "$INSTDIR\share\insight1.0\help\memory.html"
  Delete "$INSTDIR\share\insight1.0\help\locals.html"
  Delete "$INSTDIR\share\insight1.0\help\license.html"
  Delete "$INSTDIR\share\insight1.0\help\index.html"
  Delete "$INSTDIR\share\insight1.0\help\help.html"
  Delete "$INSTDIR\share\insight1.0\help\gbl_pref.html"
  Delete "$INSTDIR\share\insight1.0\help\debug.html"
  Delete "$INSTDIR\share\insight1.0\help\console.html"
  Delete "$INSTDIR\share\insight1.0\help\browser.html"
  Delete "$INSTDIR\share\insight1.0\help\breakpoint.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\index.toc"
  Delete "$INSTDIR\share\insight1.0\help\trace\watch.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\tracedlg.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\tp.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\tdump.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\target.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\stack.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\src_pref.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\source.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\register.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\reg_pref.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\memory.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\locals.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\license.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\help.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\gbl_pref.html"
  Delete "$INSTDIR\share\insight1.0\help\trace\console.html"
  Delete "$INSTDIR\share\insight1.0\help\images\watch.png"
  Delete "$INSTDIR\share\insight1.0\help\images\reg_menu.png"
  Delete "$INSTDIR\share\insight1.0\help\images\reg.png"
  Delete "$INSTDIR\share\insight1.0\help\images\insightbwr.png"
  Delete "$INSTDIR\share\insight1.0\help\images\browser2.png"
  Delete "$INSTDIR\share\insight1.0\help\images\browser1.png"
  Delete "$INSTDIR\share\insight1.0\help\images\src_toolbar.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\src_thread.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\src_stat.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\src_pop.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\src_menu.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\src_bpop.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\src_bp_bal.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\src_bal.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\mem_pref.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\mem_popup.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\mem_menu.gif"
  Delete "$INSTDIR\share\insight1.0\help\images\frame_info.gif"
  Delete "$INSTDIR\share\insight1.0\images2\icons.txt"
  Delete "$INSTDIR\share\insight1.0\images2\watch_movie.gif"
  Delete "$INSTDIR\share\insight1.0\images2\watch.gif"
  Delete "$INSTDIR\share\insight1.0\images2\vars.gif"
  Delete "$INSTDIR\share\insight1.0\images2\up.gif"
  Delete "$INSTDIR\share\insight1.0\images2\tp.gif"
  Delete "$INSTDIR\share\insight1.0\images2\tdump.gif"
  Delete "$INSTDIR\share\insight1.0\images2\target.gif"
  Delete "$INSTDIR\share\insight1.0\images2\stop.gif"
  Delete "$INSTDIR\share\insight1.0\images2\stepi.gif"
  Delete "$INSTDIR\share\insight1.0\images2\step.gif"
  Delete "$INSTDIR\share\insight1.0\images2\stack.gif"
  Delete "$INSTDIR\share\insight1.0\images2\src.gif"
  Delete "$INSTDIR\share\insight1.0\images2\run_expt.gif"
  Delete "$INSTDIR\share\insight1.0\images2\run.gif"
  Delete "$INSTDIR\share\insight1.0\images2\rewind.gif"
  Delete "$INSTDIR\share\insight1.0\images2\reg.gif"
  Delete "$INSTDIR\share\insight1.0\images2\prev_hit.gif"
  Delete "$INSTDIR\share\insight1.0\images2\open.gif"
  Delete "$INSTDIR\share\insight1.0\images2\nexti.gif"
  Delete "$INSTDIR\share\insight1.0\images2\next_line.gif"
  Delete "$INSTDIR\share\insight1.0\images2\next_hit.gif"
  Delete "$INSTDIR\share\insight1.0\images2\next_frame.gif"
  Delete "$INSTDIR\share\insight1.0\images2\next_check.gif"
  Delete "$INSTDIR\share\insight1.0\images2\next.gif"
  Delete "$INSTDIR\share\insight1.0\images2\more.gif"
  Delete "$INSTDIR\share\insight1.0\images2\memory.gif"
  Delete "$INSTDIR\share\insight1.0\images2\less.gif"
  Delete "$INSTDIR\share\insight1.0\images2\insight.gif"
  Delete "$INSTDIR\share\insight1.0\images2\home.gif"
  Delete "$INSTDIR\share\insight1.0\images2\help.gif"
  Delete "$INSTDIR\share\insight1.0\images2\gdbtk_icon.gif"
  Delete "$INSTDIR\share\insight1.0\images2\function.gif"
  Delete "$INSTDIR\share\insight1.0\images2\finish.gif"
  Delete "$INSTDIR\share\insight1.0\images2\edit.gif"
  Delete "$INSTDIR\share\insight1.0\images2\down.gif"
  Delete "$INSTDIR\share\insight1.0\images2\continue.gif"
  Delete "$INSTDIR\share\insight1.0\images2\console.gif"
  Delete "$INSTDIR\share\insight1.0\images2\check.gif"
  Delete "$INSTDIR\share\insight1.0\images2\bp.gif"
  Delete "$INSTDIR\share\insight1.0\images2\bottom.gif"
  Delete "$INSTDIR\share\insight1.0\images2\Movie_on.gif"
  Delete "$INSTDIR\share\insight1.0\images2\Movie_off.gif"
  Delete "$INSTDIR\share\insight1.0\images\icons.txt"
  Delete "$INSTDIR\share\insight1.0\images\watch_movie.gif"
  Delete "$INSTDIR\share\insight1.0\images\watch.gif"
  Delete "$INSTDIR\share\insight1.0\images\vars.gif"
  Delete "$INSTDIR\share\insight1.0\images\up.gif"
  Delete "$INSTDIR\share\insight1.0\images\tp.gif"
  Delete "$INSTDIR\share\insight1.0\images\tdump.gif"
  Delete "$INSTDIR\share\insight1.0\images\stop.gif"
  Delete "$INSTDIR\share\insight1.0\images\stepi.gif"
  Delete "$INSTDIR\share\insight1.0\images\step.gif"
  Delete "$INSTDIR\share\insight1.0\images\stack.gif"
  Delete "$INSTDIR\share\insight1.0\images\src.gif"
  Delete "$INSTDIR\share\insight1.0\images\run_expt.gif"
  Delete "$INSTDIR\share\insight1.0\images\run.gif"
  Delete "$INSTDIR\share\insight1.0\images\rewind.gif"
  Delete "$INSTDIR\share\insight1.0\images\reg.gif"
  Delete "$INSTDIR\share\insight1.0\images\prev_hit.gif"
  Delete "$INSTDIR\share\insight1.0\images\open.gif"
  Delete "$INSTDIR\share\insight1.0\images\nexti.gif"
  Delete "$INSTDIR\share\insight1.0\images\next_line.gif"
  Delete "$INSTDIR\share\insight1.0\images\next_hit.gif"
  Delete "$INSTDIR\share\insight1.0\images\next_frame.gif"
  Delete "$INSTDIR\share\insight1.0\images\next_check.gif"
  Delete "$INSTDIR\share\insight1.0\images\next.gif"
  Delete "$INSTDIR\share\insight1.0\images\more.gif"
  Delete "$INSTDIR\share\insight1.0\images\memory.gif"
  Delete "$INSTDIR\share\insight1.0\images\less.gif"
  Delete "$INSTDIR\share\insight1.0\images\insight.gif"
  Delete "$INSTDIR\share\insight1.0\images\home.gif"
  Delete "$INSTDIR\share\insight1.0\images\help.gif"
  Delete "$INSTDIR\share\insight1.0\images\gdbtk_icon.gif"
  Delete "$INSTDIR\share\insight1.0\images\finish.gif"
  Delete "$INSTDIR\share\insight1.0\images\edit.gif"
  Delete "$INSTDIR\share\insight1.0\images\down.gif"
  Delete "$INSTDIR\share\insight1.0\images\continue.gif"
  Delete "$INSTDIR\share\insight1.0\images\console.gif"
  Delete "$INSTDIR\share\insight1.0\images\check.gif"
  Delete "$INSTDIR\share\insight1.0\images\bp.gif"
  Delete "$INSTDIR\share\insight1.0\images\bottom.gif"
  Delete "$INSTDIR\share\insight1.0\images\Movie_on.gif"
  Delete "$INSTDIR\share\insight1.0\images\Movie_off.gif"
  Delete "$INSTDIR\share\redhat\gui\panedwindow.tcl"
  Delete "$INSTDIR\share\redhat\gui\pane.tcl"
  Delete "$INSTDIR\share\redhat\gui\combobox.tcl"
  Delete "$INSTDIR\share\redhat\gui\ventry.tcl"
  Delete "$INSTDIR\share\redhat\gui\wingrab.tcl"
  Delete "$INSTDIR\share\redhat\gui\wframe.tcl"
  Delete "$INSTDIR\share\redhat\gui\ulset.tcl"
  Delete "$INSTDIR\share\redhat\gui\toolbar.tcl"
  Delete "$INSTDIR\share\redhat\gui\topbind.tcl"
  Delete "$INSTDIR\share\redhat\gui\sendpr.tcl"
  Delete "$INSTDIR\share\redhat\gui\print.tcl"
  Delete "$INSTDIR\share\redhat\gui\prefs.tcl"
  Delete "$INSTDIR\share\redhat\gui\postghost.tcl"
  Delete "$INSTDIR\share\redhat\gui\path.tcl"
  Delete "$INSTDIR\share\redhat\gui\parse_args.tcl"
  Delete "$INSTDIR\share\redhat\gui\multibox.tcl"
  Delete "$INSTDIR\share\redhat\gui\mono.tcl"
  Delete "$INSTDIR\share\redhat\gui\menu.tcl"
  Delete "$INSTDIR\share\redhat\gui\looknfeel.tcl"
  Delete "$INSTDIR\share\redhat\gui\list.tcl"
  Delete "$INSTDIR\share\redhat\gui\lframe.tcl"
  Delete "$INSTDIR\share\redhat\gui\hooks.tcl"
  Delete "$INSTDIR\share\redhat\gui\gettext.tcl"
  Delete "$INSTDIR\share\redhat\gui\gensym.tcl"
  Delete "$INSTDIR\share\redhat\gui\font.tcl"
  Delete "$INSTDIR\share\redhat\gui\internet.tcl"
  Delete "$INSTDIR\share\redhat\gui\def.tcl"
  Delete "$INSTDIR\share\redhat\gui\debug.tcl"
  Delete "$INSTDIR\share\redhat\gui\center.tcl"
  Delete "$INSTDIR\share\redhat\gui\cframe.tcl"
  Delete "$INSTDIR\share\redhat\gui\canvas.tcl"
  Delete "$INSTDIR\share\redhat\gui\bindings.tcl"
  Delete "$INSTDIR\share\redhat\gui\bgerror.tcl"
  Delete "$INSTDIR\share\redhat\gui\bbox.tcl"
  Delete "$INSTDIR\share\redhat\gui\balloon.tcl"
  Delete "$INSTDIR\share\redhat\gui\advice.tcl"
  Delete "$INSTDIR\share\redhat\gui\pkgIndex.tcl"
  Delete "$INSTDIR\share\redhat\gui\tclIndex"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\watch"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\toolbar"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\timefield"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\timeentry"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\tabset"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\tabnotebook"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\spintime"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\spinner"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\spinint"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\spindate"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\shell"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\selectiondialog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\selectionbox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\scrolledtext"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\scrolledlistbox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\scrolledhtml"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\scrolledframe"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\scrolledcanvas"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\scopedobject"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\radiobox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\pushbutton"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\promptdialog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\panedwindow"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\optionmenu"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\notebook"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\messagedialog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\messagebox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\menubar"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\mainwindow"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\labeledwidget"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\labeledframe"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\iwidgets.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\hyperhelp"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\hierarchy"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\finddialog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\fileselectiondialog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\fileselectionbox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\feedback"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\extfileselectiondialog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\extfileselectionbox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\extbutton"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\entryfield"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\disjointlistbox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\dialogshell"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\dialog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\demo.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\datefield"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\dateentry"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\combobox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\checkbox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\catalog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\canvasprintdialog"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\canvasprintbox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\calendar"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\buttonbox"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\watch.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\toolbar.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\timefield.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\timeentry.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\tabset.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\tabnotebook.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\spintime.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\spinner.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\spinint.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\spindate.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\shell.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\selectiondialog.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\selectionbox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\scrolledtext.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\scrolledlistbox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\scrolledhtml.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\scrolledframe.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\scrolledcanvas.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\scopedobject.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\radiobox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\pushbutton.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\promptdialog.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\panedwindow.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\optionmenu.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\notebook.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\messagedialog.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\messagebox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\menubar.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\mainwindow.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\labeledwidget.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\labeledframe.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\iwidgets4.0.0UserCmds.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\hyperhelp.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\hierarchy.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\finddialog.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\fileselectiondialog.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\fileselectionbox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\feedback.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\extfileselectiondialog.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\extfileselectionbox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\extbutton.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\entryfield.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\disjointlistbox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\dialogshell.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\dialog.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\datefield.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\dateentry.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\combobox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\checkbox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\canvasprintdialog.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\canvasprintbox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\calendar.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\html\buttonbox.n.html"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\text.xbm"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\select.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\save.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\ruler.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\print.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\poly.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\points.xbm"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\paste.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\oval.xbm"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\open.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\new.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\mag.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\line.xbm"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\help.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\find.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\exit.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\cut.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\copy.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\close.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\clear.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\demos\images\box.xbm"
  Delete "$INSTDIR\share\iwidgets4.0.1\license.terms"
  Delete "$INSTDIR\share\iwidgets4.0.1\pkgIndex.tcl"
  Delete "$INSTDIR\share\iwidgets4.0.1\iwidgets.tcl"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\unknownimage.gif"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\tclIndex"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\scopedobject.itcl"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\roman.itcl"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\colors.itcl"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\watch.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\toolbar.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\timefield.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\timeentry.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\tabset.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\tabnotebook.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\spintime.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\spinner.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\spinint.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\spindate.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\shell.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\selectiondialog.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\selectionbox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\scrolledwidget.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\scrolledtext.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\scrolledlistbox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\scrolledhtml.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\scrolledframe.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\scrolledcanvas.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\regexpfield.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\radiobox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\pushbutton.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\promptdialog.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\panedwindow.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\pane.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\optionmenu.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\notebook.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\messagedialog.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\messagebox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\menubar.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\mainwindow.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\labeledwidget.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\labeledframe.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\hyperhelp.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\hierarchy.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\finddialog.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\fileselectiondialog.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\fileselectionbox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\feedback.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\extfileselectiondialog.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\extfileselectionbox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\extbutton.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\entryfield.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\disjointlistbox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\dialogshell.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\dialog.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\datefield.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\dateentry.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\combobox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\checkbox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\canvasprintdialog.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\canvasprintbox.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\calendar.itk"
  Delete "$INSTDIR\share\iwidgets4.0.1\scripts\buttonbox.itk"
  Delete "$INSTDIR\share\itk3.2\tclIndex"
  Delete "$INSTDIR\share\itk3.2\itk.tcl"
  Delete "$INSTDIR\share\itk3.2\Widget.itk"
  Delete "$INSTDIR\share\itk3.2\Toplevel.itk"
  Delete "$INSTDIR\share\itk3.2\Archetype.itk"
  Delete "$INSTDIR\share\itcl3.2\itcl.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\widget"
  Delete "$INSTDIR\share\tk8.4\demos\vscale.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\twind.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\timer"
  Delete "$INSTDIR\share\tk8.4\demos\text.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\tcolor"
  Delete "$INSTDIR\share\tk8.4\demos\tclIndex"
  Delete "$INSTDIR\share\tk8.4\demos\style.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\states.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\square"
  Delete "$INSTDIR\share\tk8.4\demos\spin.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\search.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\sayings.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\ruler.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\rolodex"
  Delete "$INSTDIR\share\tk8.4\demos\rmt"
  Delete "$INSTDIR\share\tk8.4\demos\radio.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\puzzle.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\plot.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\paned2.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\paned1.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\msgbox.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\menubu.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\menu.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\license.terms"
  Delete "$INSTDIR\share\tk8.4\demos\labelframe.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\label.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\ixset"
  Delete "$INSTDIR\share\tk8.4\demos\items.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\image2.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\image1.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\icon.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\hscale.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\hello"
  Delete "$INSTDIR\share\tk8.4\demos\form.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\floor.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\filebox.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\entry3.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\entry2.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\entry1.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\dialog2.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\dialog1.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\ctext.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\cscroll.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\colors.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\clrpick.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\check.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\button.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\browse"
  Delete "$INSTDIR\share\tk8.4\demos\bitmap.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\bind.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\arrow.tcl"
  Delete "$INSTDIR\share\tk8.4\demos\README"
  Delete "$INSTDIR\share\tk8.4\demos\images\teapot.ppm"
  Delete "$INSTDIR\share\tk8.4\demos\images\tcllogo.gif"
  Delete "$INSTDIR\share\tk8.4\demos\images\pattern.bmp"
  Delete "$INSTDIR\share\tk8.4\demos\images\noletter.bmp"
  Delete "$INSTDIR\share\tk8.4\demos\images\letters.bmp"
  Delete "$INSTDIR\share\tk8.4\demos\images\gray25.bmp"
  Delete "$INSTDIR\share\tk8.4\demos\images\flagup.bmp"
  Delete "$INSTDIR\share\tk8.4\demos\images\flagdown.bmp"
  Delete "$INSTDIR\share\tk8.4\demos\images\face.bmp"
  Delete "$INSTDIR\share\tk8.4\demos\images\earthris.gif"
  Delete "$INSTDIR\share\tk8.4\demos\images\earth.gif"
  Delete "$INSTDIR\share\tk8.4\tkAppInit.c"
  Delete "$INSTDIR\share\tk8.4\tclIndex"
  Delete "$INSTDIR\share\tk8.4\prolog.ps"
  Delete "$INSTDIR\share\tk8.4\xmfbox.tcl"
  Delete "$INSTDIR\share\tk8.4\unsupported.tcl"
  Delete "$INSTDIR\share\tk8.4\tkfbox.tcl"
  Delete "$INSTDIR\share\tk8.4\tk.tcl"
  Delete "$INSTDIR\share\tk8.4\text.tcl"
  Delete "$INSTDIR\share\tk8.4\tearoff.tcl"
  Delete "$INSTDIR\share\tk8.4\spinbox.tcl"
  Delete "$INSTDIR\share\tk8.4\scrlbar.tcl"
  Delete "$INSTDIR\share\tk8.4\scale.tcl"
  Delete "$INSTDIR\share\tk8.4\safetk.tcl"
  Delete "$INSTDIR\share\tk8.4\panedwindow.tcl"
  Delete "$INSTDIR\share\tk8.4\palette.tcl"
  Delete "$INSTDIR\share\tk8.4\optMenu.tcl"
  Delete "$INSTDIR\share\tk8.4\obsolete.tcl"
  Delete "$INSTDIR\share\tk8.4\msgbox.tcl"
  Delete "$INSTDIR\share\tk8.4\mkpsenc.tcl"
  Delete "$INSTDIR\share\tk8.4\menu.tcl"
  Delete "$INSTDIR\share\tk8.4\listbox.tcl"
  Delete "$INSTDIR\share\tk8.4\focus.tcl"
  Delete "$INSTDIR\share\tk8.4\entry.tcl"
  Delete "$INSTDIR\share\tk8.4\dialog.tcl"
  Delete "$INSTDIR\share\tk8.4\console.tcl"
  Delete "$INSTDIR\share\tk8.4\comdlg.tcl"
  Delete "$INSTDIR\share\tk8.4\clrpick.tcl"
  Delete "$INSTDIR\share\tk8.4\choosedir.tcl"
  Delete "$INSTDIR\share\tk8.4\button.tcl"
  Delete "$INSTDIR\share\tk8.4\bgerror.tcl"
  Delete "$INSTDIR\share\tk8.4\msgs\ru.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\nl.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\it.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\fr.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\es.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\en_gb.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\en.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\el.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\de.msg"
  Delete "$INSTDIR\share\tk8.4\msgs\cs.msg"
  Delete "$INSTDIR\share\tk8.4\images\tai-ku.gif"
  Delete "$INSTDIR\share\tk8.4\images\pwrdLogo75.gif"
  Delete "$INSTDIR\share\tk8.4\images\pwrdLogo200.gif"
  Delete "$INSTDIR\share\tk8.4\images\pwrdLogo175.gif"
  Delete "$INSTDIR\share\tk8.4\images\pwrdLogo150.gif"
  Delete "$INSTDIR\share\tk8.4\images\pwrdLogo100.gif"
  Delete "$INSTDIR\share\tk8.4\images\pwrdLogo.eps"
  Delete "$INSTDIR\share\tk8.4\images\logoMed.gif"
  Delete "$INSTDIR\share\tk8.4\images\logoLarge.gif"
  Delete "$INSTDIR\share\tk8.4\images\logo64.gif"
  Delete "$INSTDIR\share\tk8.4\images\logo100.gif"
  Delete "$INSTDIR\share\tk8.4\images\logo.eps"
  Delete "$INSTDIR\share\tk8.4\images\README"
  Delete "$INSTDIR\share\tcl8.4\tclIndex"
  Delete "$INSTDIR\share\tcl8.4\word.tcl"
  Delete "$INSTDIR\share\tcl8.4\safe.tcl"
  Delete "$INSTDIR\share\tcl8.4\parray.tcl"
  Delete "$INSTDIR\share\tcl8.4\package.tcl"
  Delete "$INSTDIR\share\tcl8.4\ldAout.tcl"
  Delete "$INSTDIR\share\tcl8.4\init.tcl"
  Delete "$INSTDIR\share\tcl8.4\history.tcl"
  Delete "$INSTDIR\share\tcl8.4\auto.tcl"
  Delete "$INSTDIR\share\tcl8.4\tcltest2.2\tcltest.tcl"
  Delete "$INSTDIR\share\tcl8.4\tcltest2.2\pkgIndex.tcl"
  Delete "$INSTDIR\share\tcl8.4\msgcat1.3\pkgIndex.tcl"
  Delete "$INSTDIR\share\tcl8.4\msgcat1.3\msgcat.tcl"
  Delete "$INSTDIR\share\tcl8.4\encoding\tis-620.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\symbol.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\shiftjis.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macUkraine.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macTurkish.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macThai.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macRomania.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macRoman.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macJapan.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macIceland.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macGreek.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macDingbats.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macCyrillic.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macCroatian.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\macCentEuro.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\ksc5601.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\koi8-u.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\koi8-r.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\jis0212.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\jis0208.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\jis0201.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-9.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-8.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-7.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-6.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-5.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-4.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-3.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-2.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-16.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-15.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-14.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-13.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-10.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso8859-1.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso2022.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso2022-kr.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\iso2022-jp.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\gb2312.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\gb1988.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\gb12345.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\euc-kr.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\euc-jp.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\euc-cn.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\ebcdic.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\dingbats.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp950.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp949.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp936.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp932.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp874.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp869.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp866.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp865.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp864.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp863.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp862.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp861.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp860.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp857.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp855.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp852.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp850.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp775.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp737.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp437.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1258.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1257.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1256.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1255.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1254.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1253.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1252.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1251.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\cp1250.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\big5.enc"
  Delete "$INSTDIR\share\tcl8.4\encoding\ascii.enc"
  Delete "$INSTDIR\share\tcl8.4\opt0.4\pkgIndex.tcl"
  Delete "$INSTDIR\share\tcl8.4\opt0.4\optparse.tcl"
  Delete "$INSTDIR\share\tcl8.4\http2.4\pkgIndex.tcl"
  Delete "$INSTDIR\share\tcl8.4\http2.4\http.tcl"
  Delete "$INSTDIR\share\tcl8.4\http1.0\pkgIndex.tcl"
  Delete "$INSTDIR\share\tcl8.4\http1.0\http.tcl"
  Delete "$INSTDIR\share\tiemu\LICENSES"
  Delete "$INSTDIR\share\tiemu\AUTHORS"
  Delete "$INSTDIR\share\tiemu\RELEASE"
  Delete "$INSTDIR\share\tiemu\COPYING"
  Delete "$INSTDIR\share\tiemu\Manpage.txt"
  Delete "$INSTDIR\share\tiemu\Readme.txt"
  Delete "$INSTDIR\share\tiemu\skins\ti92_fr.map"
  Delete "$INSTDIR\share\tiemu\skins\ti92.map"
  Delete "$INSTDIR\share\tiemu\skins\ti89_fr.map"
  Delete "$INSTDIR\share\tiemu\skins\ti89.map"
  Delete "$INSTDIR\share\tiemu\skins\v200plt.skn"
  Delete "$INSTDIR\share\tiemu\skins\ti92.skn"
  Delete "$INSTDIR\share\tiemu\skins\ti89t.skn"
  Delete "$INSTDIR\share\tiemu\skins\ti89.skn"
  Delete "$INSTDIR\share\tiemu\skins\ipaq_v200plt.skn"
  Delete "$INSTDIR\share\tiemu\skins\ipaq_92.skn"
  Delete "$INSTDIR\share\tiemu\skins\ipaq_89.skn"
  Delete "$INSTDIR\share\tiemu\pixmaps\void.xpm"
  Delete "$INSTDIR\share\tiemu\pixmaps\run_2.xpm"
  Delete "$INSTDIR\share\tiemu\pixmaps\run_1.xpm"
  Delete "$INSTDIR\share\tiemu\pixmaps\romdump.xpm"
  Delete "$INSTDIR\share\tiemu\pixmaps\romdump.ico"
  Delete "$INSTDIR\share\tiemu\pixmaps\logo.xpm"
  Delete "$INSTDIR\share\tiemu\pixmaps\icon.xpm"
  Delete "$INSTDIR\share\tiemu\pixmaps\bkpt.xpm"
  Delete "$INSTDIR\share\tiemu\misc\romcalls.txt"
  Delete "$INSTDIR\share\tiemu\misc\memmap_v200_hw2.txt"
  Delete "$INSTDIR\share\tiemu\misc\memmap_ti92p_hw2.txt"
  Delete "$INSTDIR\share\tiemu\misc\memmap_ti92p_hw1.txt"
  Delete "$INSTDIR\share\tiemu\misc\memmap_ti92_hw1.txt"
  Delete "$INSTDIR\share\tiemu\misc\memmap_ti89t_hw4.txt"
  Delete "$INSTDIR\share\tiemu\misc\memmap_ti89t_hw3.txt"
  Delete "$INSTDIR\share\tiemu\misc\memmap_ti89_hw2.txt"
  Delete "$INSTDIR\share\tiemu\misc\memmap_ti89_hw1.txt"
  Delete "$INSTDIR\share\tiemu\misc\iodefs_v200_hw2.txt"
  Delete "$INSTDIR\share\tiemu\misc\iodefs_ti92p_hw2.txt"
  Delete "$INSTDIR\share\tiemu\misc\iodefs_ti92p_hw1.txt"
  Delete "$INSTDIR\share\tiemu\misc\iodefs_ti92_hw1.txt"
  Delete "$INSTDIR\share\tiemu\misc\iodefs_ti89t_hw4.txt"
  Delete "$INSTDIR\share\tiemu\misc\iodefs_ti89t_hw3.txt"
  Delete "$INSTDIR\share\tiemu\misc\iodefs_ti89_hw2.txt"
  Delete "$INSTDIR\share\tiemu\misc\iodefs_ti89_hw1.txt"
  Delete "$INSTDIR\share\tiemu\pedrom\pedrom.txt"
  Delete "$INSTDIR\share\tiemu\pedrom\pedromv2.tib"
  Delete "$INSTDIR\share\tiemu\pedrom\pedrom9x.tib"
  Delete "$INSTDIR\share\tiemu\pedrom\pedrom89ti.tib"
  Delete "$INSTDIR\share\tiemu\pedrom\pedrom89.tib"
  Delete "$INSTDIR\share\tiemu\help\tiemu.jpg"
  Delete "$INSTDIR\share\tiemu\help\skinedit.jpg"
  Delete "$INSTDIR\share\tiemu\help\wizard.png"
  Delete "$INSTDIR\share\tiemu\help\screenshot.png"
  Delete "$INSTDIR\share\tiemu\help\romversion.png"
  Delete "$INSTDIR\share\tiemu\help\popup_menu.png"
  Delete "$INSTDIR\share\tiemu\help\no_skin.png"
  Delete "$INSTDIR\share\tiemu\help\logo_tiemu.png"
  Delete "$INSTDIR\share\tiemu\help\logo_lpg.png"
  Delete "$INSTDIR\share\tiemu\help\log_link.png"
  Delete "$INSTDIR\share\tiemu\help\linkport.png"
  Delete "$INSTDIR\share\tiemu\help\dbg_stack.png"
  Delete "$INSTDIR\share\tiemu\help\dbg_sr.png"
  Delete "$INSTDIR\share\tiemu\help\dbg_source.png"
  Delete "$INSTDIR\share\tiemu\help\dbg_search.png"
  Delete "$INSTDIR\share\tiemu\help\dbg_registers.png"
  Delete "$INSTDIR\share\tiemu\help\dbg_mem.png"
  Delete "$INSTDIR\share\tiemu\help\dbg_heap.png"
  Delete "$INSTDIR\share\tiemu\help\dbg_bkpts.png"
  Delete "$INSTDIR\share\tiemu\help\calc_infos.png"
  Delete "$INSTDIR\share\tiemu\help\chapter22.html"
  Delete "$INSTDIR\share\tiemu\help\chapter21.html"
  Delete "$INSTDIR\share\tiemu\help\chapter20.html"
  Delete "$INSTDIR\share\tiemu\help\chapter11.html"
  Delete "$INSTDIR\share\tiemu\help\chapter10.html"
  Delete "$INSTDIR\share\tiemu\help\chapter09.html"
  Delete "$INSTDIR\share\tiemu\help\chapter08.html"
  Delete "$INSTDIR\share\tiemu\help\chapter07.html"
  Delete "$INSTDIR\share\tiemu\help\chapter06.html"
  Delete "$INSTDIR\share\tiemu\help\chapter05.html"
  Delete "$INSTDIR\share\tiemu\help\chapter04.html"
  Delete "$INSTDIR\share\tiemu\help\chapter03.html"
  Delete "$INSTDIR\share\tiemu\help\chapter02.html"
  Delete "$INSTDIR\share\tiemu\help\chapter01.html"
  Delete "$INSTDIR\share\tiemu\help\Manual_en.html"
  Delete "$INSTDIR\share\tiemu\help\FAQ.html"
  Delete "$INSTDIR\share\tiemu\glade\wizard-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\scroptions-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\romversion-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\release-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\quicksend-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\popup-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\pbars-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\manpage-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\log_link-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\infos-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dboxes-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_vectors-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_stack-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_regs-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_pclog-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_mem-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_ioports-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_heap-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_entry-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_dock-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_data-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_code-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_cause-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_bkpts-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\dbg_bits-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\device-2.glade"
  Delete "$INSTDIR\share\tiemu\glade\calc-2.glade"
  Delete "$INSTDIR\include\itkDecls.h"
  Delete "$INSTDIR\include\itk.h"
  Delete "$INSTDIR\include\itclIntDecls.h"
  Delete "$INSTDIR\include\itclInt.h"
  Delete "$INSTDIR\include\itclDecls.h"
  Delete "$INSTDIR\include\itcl.h"
  Delete "$INSTDIR\include\tkDecls.h"
  Delete "$INSTDIR\include\tkIntXlibDecls.h"
  Delete "$INSTDIR\include\tkPlatDecls.h"
  Delete "$INSTDIR\include\tk.h"
  Delete "$INSTDIR\include\X11\keysymdef.h"
  Delete "$INSTDIR\include\X11\keysym.h"
  Delete "$INSTDIR\include\X11\cursorfont.h"
  Delete "$INSTDIR\include\X11\Xutil.h"
  Delete "$INSTDIR\include\X11\Xlib.h"
  Delete "$INSTDIR\include\X11\Xfuncproto.h"
  Delete "$INSTDIR\include\X11\Xatom.h"
  Delete "$INSTDIR\include\X11\X.h"
  Delete "$INSTDIR\include\tclPlatDecls.h"
  Delete "$INSTDIR\include\tclDecls.h"
  Delete "$INSTDIR\include\tcl.h"
  Delete "$INSTDIR\include\tilp2\ticonv.h"
  Delete "$INSTDIR\include\tilp2\charset.h"
  Delete "$INSTDIR\include\tilp2\ticalcs.h"
  Delete "$INSTDIR\include\tilp2\keys92p.h"
  Delete "$INSTDIR\include\tilp2\keys89.h"
  Delete "$INSTDIR\include\tilp2\keys83p.h"
  Delete "$INSTDIR\include\tilp2\keys73.h"
  Delete "$INSTDIR\include\tilp2\typesxx.h"
  Delete "$INSTDIR\include\tilp2\typesnsp.h"
  Delete "$INSTDIR\include\tilp2\typesv2.h"
  Delete "$INSTDIR\include\tilp2\types92p.h"
  Delete "$INSTDIR\include\tilp2\types92.h"
  Delete "$INSTDIR\include\tilp2\types89t.h"
  Delete "$INSTDIR\include\tilp2\types89.h"
  Delete "$INSTDIR\include\tilp2\types86.h"
  Delete "$INSTDIR\include\tilp2\types85.h"
  Delete "$INSTDIR\include\tilp2\types84p.h"
  Delete "$INSTDIR\include\tilp2\types83p.h"
  Delete "$INSTDIR\include\tilp2\types83.h"
  Delete "$INSTDIR\include\tilp2\types82.h"
  Delete "$INSTDIR\include\tilp2\types73.h"
  Delete "$INSTDIR\include\tilp2\tifiles.h"
  Delete "$INSTDIR\include\tilp2\stdints4.h"
  Delete "$INSTDIR\include\tilp2\stdints3.h"
  Delete "$INSTDIR\include\tilp2\stdints2.h"
  Delete "$INSTDIR\include\tilp2\stdints1.h"
  Delete "$INSTDIR\include\tilp2\files9x.h"
  Delete "$INSTDIR\include\tilp2\files8x.h"
  Delete "$INSTDIR\include\tilp2\timeout.h"
  Delete "$INSTDIR\include\tilp2\ticables.h"
  Delete "$INSTDIR\include\tilp2\export4.h"
  Delete "$INSTDIR\include\tilp2\export3.h"
  Delete "$INSTDIR\include\tilp2\export2.h"
  Delete "$INSTDIR\include\tilp2\export1.h"
  Delete "$INSTDIR\bin\itk32.dll"
  Delete "$INSTDIR\bin\itcl32.dll"
  Delete "$INSTDIR\bin\wish84.exe"
  Delete "$INSTDIR\bin\tk84.dll"
  Delete "$INSTDIR\bin\tclpip84.dll"
  Delete "$INSTDIR\bin\tclsh84.exe"
  Delete "$INSTDIR\bin\tcl84.dll"
  Delete "$INSTDIR\bin\tiemups.dll"
  Delete "$INSTDIR\bin\tiemu.tlb"
  Delete "$INSTDIR\bin\tiemu.exe"
  Delete "$INSTDIR\bin\libusb0.dll"
  Delete "$INSTDIR\bin\libticonv-3.dll"
  Delete "$INSTDIR\bin\libticalcs2-7.dll"
  Delete "$INSTDIR\bin\libtifiles2-5.dll"
  Delete "$INSTDIR\bin\libticables2-1.dll"
  Delete "$INSTDIR\lib\libitkstub32.a"
  Delete "$INSTDIR\lib\itk3.2\pkgIndex.tcl"
  Delete "$INSTDIR\lib\libitclstub32.a"
  Delete "$INSTDIR\lib\itcl3.2\pkgIndex.tcl"
  Delete "$INSTDIR\lib\libtkstub84.a"
  Delete "$INSTDIR\lib\libtk84.a"
  Delete "$INSTDIR\lib\tkConfig.sh"
  Delete "$INSTDIR\lib\tk8.4\pkgIndex.tcl"
  Delete "$INSTDIR\lib\libtclstub84.a"
  Delete "$INSTDIR\lib\libtcl84.a"
  Delete "$INSTDIR\lib\tclConfig.sh"
  Delete "$INSTDIR\lib\reg1.1\pkgIndex.tcl"
  Delete "$INSTDIR\lib\reg1.1\tclreg11.dll"
  Delete "$INSTDIR\lib\dde1.2\pkgIndex.tcl"
  Delete "$INSTDIR\lib\dde1.2\tcldde12.dll"
  Delete "$INSTDIR\lib\libticonv.la"
  Delete "$INSTDIR\lib\libticonv.dll.a"
  Delete "$INSTDIR\lib\libticalcs2.la"
  Delete "$INSTDIR\lib\libticalcs2.dll.a"
  Delete "$INSTDIR\lib\libtifiles2.la"
  Delete "$INSTDIR\lib\libtifiles2.dll.a"
  Delete "$INSTDIR\lib\pkgconfig\ticonv.pc"
  Delete "$INSTDIR\lib\pkgconfig\ticalcs2.pc"
  Delete "$INSTDIR\lib\pkgconfig\tifiles2.pc"
  Delete "$INSTDIR\lib\pkgconfig\ticables2.pc"
  Delete "$INSTDIR\lib\libticables2.la"
  Delete "$INSTDIR\lib\libticables2.dll.a"

  Delete "$SMPROGRAMS\$ICONS_GROUP\Readme.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$DESKTOP\TiEmu.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\TiEmu.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR\share\tk8.4\msgs"
  RMDir "$INSTDIR\share\tk8.4\images"
  RMDir "$INSTDIR\share\tk8.4\demos\images"
  RMDir "$INSTDIR\share\tk8.4\demos"
  RMDir "$INSTDIR\share\tk8.4"
  RMDir "$INSTDIR\share\tiemu\skins"
  RMDir "$INSTDIR\share\tiemu\pixmaps"
  RMDir "$INSTDIR\share\tiemu\pedrom"
  RMDir "$INSTDIR\share\tiemu\misc"
  RMDir "$INSTDIR\share\tiemu\help"
  RMDir "$INSTDIR\share\tiemu\glade"
  RMDir "$INSTDIR\share\tiemu\images"
  RMDir "$INSTDIR\share\tiemu"
  RMDir "$INSTDIR\share\tcl8.4\tcltest2.2"
  RMDir "$INSTDIR\share\tcl8.4\opt0.4"
  RMDir "$INSTDIR\share\tcl8.4\msgcat1.3"
  RMDir "$INSTDIR\share\tcl8.4\http2.4"
  RMDir "$INSTDIR\share\tcl8.4\http1.0"
  RMDir "$INSTDIR\share\tcl8.4\encoding"
  RMDir "$INSTDIR\share\tcl8.4"
  RMDir "$INSTDIR\share\redhat\gui"
  RMDir "$INSTDIR\share\redhat"
  RMDir "$INSTDIR\share\iwidgets4.0.1\scripts"
  RMDir "$INSTDIR\share\iwidgets4.0.1\demos\images"
  RMDir "$INSTDIR\share\iwidgets4.0.1\demos\html"
  RMDir "$INSTDIR\share\iwidgets4.0.1\demos"
  RMDir "$INSTDIR\share\iwidgets4.0.1"
  RMDir "$INSTDIR\share\itk3.2"
  RMDir "$INSTDIR\share\itcl3.2"
  RMDir "$INSTDIR\share\insight1.0\images2"
  RMDir "$INSTDIR\share\insight1.0\images"
  RMDir "$INSTDIR\share\insight1.0\help\trace"
  RMDir "$INSTDIR\share\insight1.0\help\images"
  RMDir "$INSTDIR\share\insight1.0\help"
  RMDir "$INSTDIR\share\insight1.0"
  RMDir "$INSTDIR\share\man\man1"
  RMDir "$INSTDIR\share\man"
  RMDir "$INSTDIR\share"
  RMDir "$INSTDIR\man\mann"
  RMDir "$INSTDIR\man"
  RMDir "$INSTDIR\lib\tk8.4"
  RMDir "$INSTDIR\lib\reg1.1"
  RMDir "$INSTDIR\lib\pkgconfig"
  RMDir "$INSTDIR\lib\itk3.2"
  RMDir "$INSTDIR\lib\itcl3.2"
  RMDir "$INSTDIR\lib\dde1.2"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\include\X11"
  RMDir "$INSTDIR\include\tilp2"
  RMDir "$INSTDIR\include"
  RMDir "$INSTDIR\bin"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
