; XDOC Documentation System for ACL2
;
; Copyright (C) 2022 Kestrel Institute (http://www.kestrel.edu)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (coglio@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "ACL2")

(include-book "defxdoc-plus")

(include-book "std/testing/assert-equal" :dir :system)
(include-book "std/testing/must-eval-to-t" :dir :system)
(include-book "std/testing/must-fail" :dir :system)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; This is just to ensure the correctness of the implementation of DEFXDOC+,
; which picks all the arguments of DEFXDOC from the DEFXDOC+ call
; and passes them to the call of DEFXDOC generated by DEFXDOC+.
; If the arguments of DEFXDOC change,
; the following test will fail,
; prompting the adaptation of DEFXDOC+ to the change.

(assert-equal (macro-args 'defxdoc (w state))
              '(xdoc::name
                &key
                xdoc::parents
                xdoc::short
                xdoc::long
                xdoc::pkg
                xdoc::no-override))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(must-eval-to-t
 (mv-let (erp form state)
   (trans1 '(defxdoc+ topic
              :parents (parent1 parent2)
              :short "short"
              :long "long"
              :pkg "ACL2"
              :no-override t))
   (declare (ignore erp))
   (value (equal form
                 '(progn
                    (defxdoc topic
                      :parents (parent1 parent2)
                      :short "short"
                      :long "long"
                      :pkg "ACL2"
                      :no-override t))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(must-eval-to-t
 (mv-let (erp form state)
   (trans1 '(defxdoc+ topic
              :parents (parent1 parent2)
              :short "short"
              :long "long"
              :pkg "ACL2"
              :no-override t
              :order-subtopics t))
   (declare (ignore erp))
   (value (equal form
                 '(progn
                    (defxdoc topic
                      :parents (parent1 parent2)
                      :short "short"
                      :long "long"
                      :pkg "ACL2"
                      :no-override t)
                    (xdoc::order-subtopics topic nil t))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(must-eval-to-t
 (mv-let (erp form state)
   (trans1 '(defxdoc+ topic
              :parents (parent1 parent2)
              :short "short"
              :long "long"
              :pkg "ACL2"
              :no-override t
              :default-parent t))
   (declare (ignore erp))
   (value (equal form
                 '(progn
                    (defxdoc topic
                      :parents (parent1 parent2)
                      :short "short"
                      :long "long"
                      :pkg "ACL2"
                      :no-override t)
                    (local (set-default-parents topic)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(must-eval-to-t
 (mv-let (erp form state)
   (trans1 '(defxdoc+ topic
              :parents (parent1 parent2)
              :short "short"
              :long "long"
              :pkg "ACL2"
              :no-override t
              :order-subtopics t
              :default-parent t))
   (declare (ignore erp))
   (value (equal form
                 '(progn
                    (defxdoc topic
                      :parents (parent1 parent2)
                      :short "short"
                      :long "long"
                      :pkg "ACL2"
                      :no-override t)
                    (xdoc::order-subtopics topic nil t)
                    (local (set-default-parents topic)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(must-fail ; malformed keyed options
 (defxdoc+ topic 88))

(must-fail ; malforemed keyed options
 (defxdoc+ topic :malformed))

(must-fail ; malformed keyed options
 (defxdoc+ topic :short))

(must-fail ; unrecognized keyed options
 (defxdoc+ topic :unknown "a"))

(must-fail ; unrecognized keyed options
 (defxdoc+ topic :parents ("legit") :shorter #\c :longer 'doc))
