## lexicon is a python tool for a number of dns providers.

As I'm writing this doc, it supports the following dns api:
The current supported providers are:

* Cloudflare
* DigitalOcean
* DNSimple
* DnsMadeEasy
* DNSPark
* EasyDNS
* Namesilo
* NS1
* PointHQ
* Rage4
* TransIP
* Vultr


You can check its project page: https://github.com/AnalogJ/lexicon

You must install `python` and `lexicon` before using it.

For more examples, please check lexicon page: https://github.com/AnalogJ/lexicon

## Examples:
### 1. Using lexicon cloudflare api:
```
export PROVIDER=cloudflare
export LEXICON_CLOUDFLARE_USERNAME="xxxx@xxx.com"
export LEXICON_CLOUDFLARE_TOKEN="XXXXXXXXXXXXXXX"

acme.sh --issue  -d test.acme.sh  --dns  dns_lexicon
```

### 2. Using lexicon namesilo api:

[Namesilo](https://www.namesilo.com/) applies any submitted changes to DNS records **every 15 minutes**.  To make sure verification aligns with propagation, `--dnssleep` must be set for **16 minutes (960 seconds)**.  You may generate a new API key (namesilo-api-token) at the [api manager](https://www.namesilo.com/account_api.php) under *Account Options* after logging in.

```
export PROVIDER=namesilo
export LEXICON_NAMESILO_TOKEN="namesilo-api-token"

acme.sh --issue  -d test.acme.sh  --dns dns_lexicon  --dnssleep 960
```

### 3. Using lexicon TransIP api:
```
export PROVIDER=TRANSIP
export LEXICON_TRANSIP_USERNAME="username"
export LEXICON_TRANSIP_API_KEY="/path/to/file.key"

acme.sh --issue  -d test.acme.sh  --dns  dns_lexicon
```

### 4. Using Technitium DNS via Lexicon `ddns` API:

In this example, we request a DNS-01-challenged ACME certificate using a custom (internal) ACME server via the Lexicon API via [Technitium DNS](https://technitium.com/dns/). Note that we use `--dnssleep 0` to skip the public DNS check (since this is for an internal DNS setup).

There are some prerequisites to setup TSIG within Technitium. In Technitium's Web UI:

* Create a TSIG Key via Settings>TSIG. Set `<KeyName>`, `<Algorithm>`, and optionally `<SharedSecret>` (if you don't set Shared Secret, Technitium will create one for you when you click "Save"). For example:
   * KeyName: `lexicon`
   * SharedSecret: `12345abcde` (NOTE: this is just an example!)
   * Algorithm: `HMAC-SHA256`
* Enable Zone Transfer and Dynamic Updates at Zones > `example.com` > Options > Zone Options.
   * [Zone Transfer tab] Zone Transfer: `Allow`
   * [Zone Transfer tab] Zone Transfer TSIG Key Names: `<KeyName>` from above - optionally you can select your KeyName from "Quick Add" menu
   * [Dynamic Updates tab] Dynamic Updates: `Allow` (use "Specified IP Addresses" if possible)
   * [Dynamic Updates tab] Add a security policy with the following options:
      * TSIG Key Name: `<KeyName>`
      * Domain Name: `*.example.com`
      * Allowed Record Types: `TXT`

In your `acme.sh` CLI session:

```
export PROVIDER=ddns
# Format: export LEXICON_DDNS_DDNS_SERVER=<DNS Server IP>
export LEXICON_DDNS_DDNS_SERVER=10.1.0.5
# Format: export LEXICON_DDNS_TOKEN=<Algorithm>:<KeyName>:<SharedSecret>
export LEXICON_DDNS_TOKEN=hmac-sha256:lexicon:12345abcde

acme.sh --issue \
    -d test.example.com \
    --dns dns_lexicon \
    --server https://hcv.ff.lan/v1/pki_int/acme/directory \
    --dnssleep 0
```