// ---------------------------------------------------------------------------
// - TlsState.hpp                                                            -
// - afnix:tls service - tls state class definition                          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2015 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_TLSSTATE_HPP
#define  AFNIX_TLSSTATE_HPP

#ifndef  AFNIX_TLSPARAMS_HPP
#include "TlsParams.hpp"
#endif

namespace afnix {

  /// The TlsConnect class is the common connection socket class for the
  /// tls protocol. The class is designed to negotiate a tls connection
  /// which result in the generation of a tls socket object. It is here
  /// the handshake is performed.
  /// @author amaury darsch

  class TlsState : public TlsInfos {
  protected:
    /// the server flag
    bool   d_sflg;
    /// the major version
    t_byte d_vmaj;
    /// the minor version
    t_byte d_vmin;
    /// the selected cipher
    t_word d_cifr;

  public:
    /// create a  default tls state
    TlsState (void);

    /// create a tls state by server flag
    /// @param sflg the server flag
    TlsState (const bool sflg);

    /// create a tls state by server flag and parameters
    /// @param sflg the server flag
    /// @param prms the server flag
    TlsState (const bool sflg, const TlsParams& prms);

    /// copy construct this tls state
    /// @param that the object to copy
    TlsState (const TlsState& that);

    /// assign a tls state to this one
    /// @param that the state to assign
    TlsState& operator = (const TlsState& that);

    /// @return the class name
    String repr (void) const;

    /// reset this state object
    void reset (void);

    /// @return the info plist
    Plist getinfo (void) const;

    /// @return the server flag
    virtual bool getsflg (void) const;

    /// @return the tls major version
    virtual t_byte getvmaj (void) const;

    /// @return the tls minor version
    virtual t_byte getvmin (void) const;

    /// update the tls version at once
    /// @param vmaj the major version
    /// @param vmin the minor version
    virtual void setvers (const t_byte vmaj, const t_byte vmin);

    /// set the selected cipher
    virtual void setcifr (const t_word cifr);

    /// @return the selected cipher
    virtual t_word getcifr (void) const;

  public:
    /// create a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);
    
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;
    
    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
