/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ART_ODREFRESH_INCLUDE_ODR_STATSLOG_ODR_STATSLOG_H_
#define ART_ODREFRESH_INCLUDE_ODR_STATSLOG_ODR_STATSLOG_H_

#include <iosfwd>  // For forward-declaration of std::string.
namespace art {
namespace odrefresh {

// Upload the metrics (if any) generated by odrefresh by passing the data `statsd` process.
//
// Metrics from odrefresh a persisted to the path specified by `OdrefreshMetricsFile`. This method
// reads the saved metrics, passes them to statsd, then removes the file to avoid uploading them
// in future.
//
// Returns true on success. On failure `error_msg` summarizes the failure and this method returns
// false.
bool UploadStatsIfAvailable(/*out*/std::string* error_msg);

}  // namespace odrefresh
}  // namespace art

#endif  // ART_ODREFRESH_INCLUDE_ODR_STATSLOG_ODR_STATSLOG_H_
