/*
 * ***************************************************************************
 * MC = < Manifold Code >
 * Copyright (C) 1994-- Michael Holst 
 *
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Lesser General Public 
 * License as published by the Free Software Foundation; either  
 * version 2.1 of the License, or (at your option) any later version. 
 *
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details. 
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free Software  
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA   
 * 
 * rcsid="$Id: mainFsmooth.c,v 1.6 2010/08/12 05:17:32 fetk Exp $"
 * ***************************************************************************
 */

/*
 * ***************************************************************************
 * File:     main.c
 *
 * Purpose:  Driver program for testing Bvec_fsmooth routine
 *
 * Notes:    A random non-symmetric block problem (with unequal block sizes)
 *           and a random assignment of F and F-points were generated in 
 *           Matlab.  Exact solutions were generated for a random initial
 *           guess and random right hand side using all four permutations of 
 *           key == 0,1 and adj = 0,1.  The exact solutions were generated 
 *           using simple Matlab commands (backslash, tril, triu, diag) to 
 *           ensure correctness.  This routine will expose most all bugs in 
 *           Bvec_fsmooth, if any such bugs exist.  The Matlab code for 
 *           generating the test problem is attached at the end of this file
 *           as a comment.
 *
 * Author:   Stephen Bond
 * ***************************************************************************
 */

#include "mc/mc.h"

VPRIVATE Bmat* Bmat_example( )
{
   int numB,numR[MAXV];
   Mat *Ab;
   double *AD;
   int p, q, *IJA;
   MATmirror mirror[MAXV][MAXV];
   Bmat *thee = VNULL;

   numB = 3;
   VASSERT( numB <= MAXV );
   numR[0] = 50;
   numR[1] = 48;
   numR[2] = 52;
   for( p=0; p<numB; p++ ) {
      for( q=0; q<numB; q++ ) {
         mirror[p][q] = ISNOT_MIRROR;
      }
   }

   thee = Bmat_ctor( VNULL, "A", numB, numR, numR, mirror );

   Ab = thee->AD[0][0];
   IJA = Vmem_malloc(Ab->vmem, 62, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=1;IJA[3]=4;IJA[4]=4;
   IJA[5]=4;IJA[6]=4;IJA[7]=5;IJA[8]=5;IJA[9]=6;
   IJA[10]=6;IJA[11]=6;IJA[12]=6;IJA[13]=6;IJA[14]=6;
   IJA[15]=6;IJA[16]=6;IJA[17]=6;IJA[18]=6;IJA[19]=6;
   IJA[20]=6;IJA[21]=8;IJA[22]=8;IJA[23]=8;IJA[24]=8;
   IJA[25]=8;IJA[26]=9;IJA[27]=9;IJA[28]=9;IJA[29]=9;
   IJA[30]=10;IJA[31]=10;IJA[32]=10;IJA[33]=10;IJA[34]=10;
   IJA[35]=10;IJA[36]=10;IJA[37]=10;IJA[38]=10;IJA[39]=10;
   IJA[40]=10;IJA[41]=10;IJA[42]=10;IJA[43]=10;IJA[44]=10;
   IJA[45]=10;IJA[46]=11;IJA[47]=11;IJA[48]=11;IJA[49]=11;
   IJA[50]=11;
   IJA[51]=7;IJA[52]=13;IJA[53]=18;IJA[54]=35;IJA[55]=34;
   IJA[56]=12;IJA[57]=23;IJA[58]=44;IJA[59]=45;IJA[60]=31;
   IJA[61]=47;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 11, IJA, VNULL);
   AD = Ab->A;

   AD[0]=2.0796148928e+00;AD[1]=2.1665002595e+00;AD[2]=2.1767652882e+00;
   AD[3]=2.4425112433e+00;AD[4]=2.2701485335e+00;AD[5]=2.2374043155e+00;
   AD[6]=2.3662622739e+00;AD[7]=2.4909483203e+00;AD[8]=2.0039275986e+00;
   AD[9]=2.1290855510e+00;AD[10]=2.2926103207e+00;AD[11]=1.9486492051e+00;
   AD[12]=2.0243571076e+00;AD[13]=1.6714732214e+00;AD[14]=1.6306657516e+00;
   AD[15]=1.7187811240e+00;AD[16]=1.6054805027e+00;AD[17]=1.6414258523e+00;
   AD[18]=1.9569683011e+00;AD[19]=2.2881330455e+00;AD[20]=1.7810639761e+00;
   AD[21]=1.7247867307e+00;AD[22]=2.4088747328e+00;AD[23]=1.5073288452e+00;
   AD[24]=2.0887393345e+00;AD[25]=2.0421178703e+00;AD[26]=2.1535239810e+00;
   AD[27]=1.8134349764e+00;AD[28]=1.7311588249e+00;AD[29]=1.9160638311e+00;
   AD[30]=1.7987987878e+00;AD[31]=2.1724363908e+00;AD[32]=2.4382574799e+00;
   AD[33]=1.8431476937e+00;AD[34]=2.0629625720e+00;AD[35]=1.6188885577e+00;
   AD[36]=1.6690212608e+00;AD[37]=1.7788954175e+00;AD[38]=2.0568146577e+00;
   AD[39]=1.9855891609e+00;AD[40]=2.4522232265e+00;AD[41]=1.7319208429e+00;
   AD[42]=1.9786583933e+00;AD[43]=2.0265224007e+00;AD[44]=2.2927207937e+00;
   AD[45]=1.6930076520e+00;AD[46]=2.4096004457e+00;AD[47]=2.4221963927e+00;
   AD[48]=1.5132663655e+00;AD[49]=2.2675496335e+00;
   AD[50]=-1.8070370360e-01;AD[51]=-3.8293984767e-01;AD[52]=3.2338720365e-01;
   AD[53]=1.0211690829e-01;AD[54]=2.5363453439e-01;AD[55]=2.2111763562e-02;
   AD[56]=-4.3468549331e-01;AD[57]=-1.8959777393e-01;AD[58]=-1.9270391508e-01;
   AD[59]=1.2113870579e-01;AD[60]=-4.8806953331e-01;
   AD[61]=-4.5095317187e-01;AD[62]=4.3273619136e-01;AD[63]=-3.6901753088e-01;
   AD[64]=4.4081954229e-01;AD[65]=6.2048676524e-02;AD[66]=-1.2782375988e-01;
   AD[67]=-4.5336385448e-01;AD[68]=9.7913261605e-02;AD[69]=-2.3578233627e-01;
   AD[70]=-3.6905517790e-01;AD[71]=4.2667831064e-01;
   Ab = thee->AD[0][1];
   IJA = Vmem_malloc(Ab->vmem, 85, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=3;IJA[3]=4;IJA[4]=4;
   IJA[5]=5;IJA[6]=5;IJA[7]=5;IJA[8]=6;IJA[9]=9;
   IJA[10]=10;IJA[11]=10;IJA[12]=11;IJA[13]=11;IJA[14]=11;
   IJA[15]=11;IJA[16]=11;IJA[17]=11;IJA[18]=12;IJA[19]=12;
   IJA[20]=12;IJA[21]=13;IJA[22]=14;IJA[23]=15;IJA[24]=15;
   IJA[25]=16;IJA[26]=17;IJA[27]=19;IJA[28]=19;IJA[29]=21;
   IJA[30]=25;IJA[31]=25;IJA[32]=25;IJA[33]=25;IJA[34]=25;
   IJA[35]=26;IJA[36]=27;IJA[37]=27;IJA[38]=28;IJA[39]=29;
   IJA[40]=29;IJA[41]=32;IJA[42]=32;IJA[43]=33;IJA[44]=33;
   IJA[45]=33;IJA[46]=33;IJA[47]=34;IJA[48]=34;IJA[49]=34;
   IJA[50]=34;
   IJA[51]=2;IJA[52]=13;IJA[53]=30;IJA[54]=12;IJA[55]=41;
   IJA[56]=8;IJA[57]=0;IJA[58]=10;IJA[59]=36;IJA[60]=43;
   IJA[61]=6;IJA[62]=6;IJA[63]=35;IJA[64]=44;IJA[65]=8;
   IJA[66]=16;IJA[67]=19;IJA[68]=14;IJA[69]=38;IJA[70]=25;
   IJA[71]=43;IJA[72]=15;IJA[73]=20;IJA[74]=33;IJA[75]=47;
   IJA[76]=28;IJA[77]=19;IJA[78]=11;IJA[79]=12;IJA[80]=17;
   IJA[81]=19;IJA[82]=21;IJA[83]=10;IJA[84]=22;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 34, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-3.0676368638e-01;AD[1]=-4.1883629591e-01;AD[2]=-2.8844090793e-02;
   AD[3]=-2.2784256362e-01;AD[4]=-4.3068176210e-01;AD[5]=-3.4362388061e-01;
   AD[6]=1.6251996920e-02;AD[7]=2.2180028452e-01;AD[8]=4.7808165298e-01;
   AD[9]=3.6516822738e-02;AD[10]=3.2802584181e-01;AD[11]=4.1755720322e-01;
   AD[12]=-2.1472058783e-01;AD[13]=-4.8711369442e-01;AD[14]=-3.7788123333e-01;
   AD[15]=-1.1856481760e-02;AD[16]=-3.8878356177e-01;AD[17]=-3.3845021780e-02;
   AD[18]=1.8133515496e-01;AD[19]=-3.6281068746e-01;AD[20]=-2.2397033658e-01;
   AD[21]=3.6204490015e-01;AD[22]=-4.7625612912e-01;AD[23]=-1.0129694869e-01;
   AD[24]=6.7623313866e-02;AD[25]=4.4238725438e-01;AD[26]=6.5053870855e-02;
   AD[27]=2.5402266585e-01;AD[28]=-8.0567284438e-02;AD[29]=-3.1868367113e-01;
   AD[30]=4.6916627244e-01;AD[31]=3.7021582204e-01;AD[32]=1.5163981659e-01;
   AD[33]=-4.7312340722e-01;
   Ab = thee->AD[0][2];
   IJA = Vmem_malloc(Ab->vmem, 81, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=2;IJA[3]=4;IJA[4]=4;
   IJA[5]=4;IJA[6]=6;IJA[7]=6;IJA[8]=7;IJA[9]=7;
   IJA[10]=7;IJA[11]=7;IJA[12]=7;IJA[13]=7;IJA[14]=7;
   IJA[15]=7;IJA[16]=7;IJA[17]=7;IJA[18]=8;IJA[19]=8;
   IJA[20]=8;IJA[21]=9;IJA[22]=9;IJA[23]=9;IJA[24]=10;
   IJA[25]=11;IJA[26]=11;IJA[27]=11;IJA[28]=12;IJA[29]=14;
   IJA[30]=15;IJA[31]=17;IJA[32]=19;IJA[33]=20;IJA[34]=21;
   IJA[35]=22;IJA[36]=23;IJA[37]=23;IJA[38]=23;IJA[39]=23;
   IJA[40]=24;IJA[41]=25;IJA[42]=25;IJA[43]=25;IJA[44]=26;
   IJA[45]=27;IJA[46]=28;IJA[47]=29;IJA[48]=29;IJA[49]=30;
   IJA[50]=30;
   IJA[51]=12;IJA[52]=35;IJA[53]=20;IJA[54]=40;IJA[55]=25;
   IJA[56]=31;IJA[57]=4;IJA[58]=4;IJA[59]=11;IJA[60]=6;
   IJA[61]=25;IJA[62]=10;IJA[63]=12;IJA[64]=51;IJA[65]=6;
   IJA[66]=3;IJA[67]=22;IJA[68]=1;IJA[69]=25;IJA[70]=9;
   IJA[71]=39;IJA[72]=27;IJA[73]=24;IJA[74]=36;IJA[75]=22;
   IJA[76]=1;IJA[77]=49;IJA[78]=6;IJA[79]=24;IJA[80]=18;
   
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 30, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-1.0020615435e-01;AD[1]=-2.3408114661e-02;AD[2]=-3.0697998214e-01;
   AD[3]=-4.8662327896e-02;AD[4]=1.6189901493e-01;AD[5]=3.0303089826e-01;
   AD[6]=-5.8414514651e-02;AD[7]=-1.6940006407e-02;AD[8]=-1.7727556849e-01;
   AD[9]=-2.8677062349e-01;AD[10]=1.1663323498e-01;AD[11]=3.9664814615e-01;
   AD[12]=5.5222073051e-03;AD[13]=-2.8987846364e-02;AD[14]=-3.9655020404e-01;
   AD[15]=2.7208779994e-01;AD[16]=3.3525939869e-01;AD[17]=-3.4740637796e-01;
   AD[18]=1.8514000023e-01;AD[19]=-1.1562595384e-01;AD[20]=4.1763789545e-02;
   AD[21]=2.1396084453e-01;AD[22]=-2.0313194312e-02;AD[23]=6.1196254813e-02;
   AD[24]=-1.6690493258e-01;AD[25]=3.3302723293e-01;AD[26]=2.6719735697e-01;
   AD[27]=-3.4266333410e-01;AD[28]=6.0816727775e-02;AD[29]=-4.1738738210e-01;
   
   Ab = thee->AD[1][1];
   IJA = Vmem_malloc(Ab->vmem, 63, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=1;IJA[3]=2;IJA[4]=2;
   IJA[5]=3;IJA[6]=3;IJA[7]=4;IJA[8]=4;IJA[9]=4;
   IJA[10]=4;IJA[11]=4;IJA[12]=4;IJA[13]=6;IJA[14]=6;
   IJA[15]=6;IJA[16]=7;IJA[17]=8;IJA[18]=8;IJA[19]=8;
   IJA[20]=8;IJA[21]=8;IJA[22]=8;IJA[23]=8;IJA[24]=9;
   IJA[25]=10;IJA[26]=10;IJA[27]=11;IJA[28]=11;IJA[29]=11;
   IJA[30]=12;IJA[31]=12;IJA[32]=12;IJA[33]=13;IJA[34]=13;
   IJA[35]=13;IJA[36]=13;IJA[37]=13;IJA[38]=13;IJA[39]=13;
   IJA[40]=13;IJA[41]=13;IJA[42]=14;IJA[43]=14;IJA[44]=14;
   IJA[45]=14;IJA[46]=14;IJA[47]=14;IJA[48]=14;
   IJA[49]=31;IJA[50]=18;IJA[51]=31;IJA[52]=37;IJA[53]=27;
   IJA[54]=44;IJA[55]=39;IJA[56]=41;IJA[57]=28;IJA[58]=34;
   IJA[59]=46;IJA[60]=43;IJA[61]=35;IJA[62]=42;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 14, IJA, VNULL);
   AD = Ab->A;

   AD[0]=2.4473426384e+00;AD[1]=2.3133055247e+00;AD[2]=2.4238297938e+00;
   AD[3]=1.6989972586e+00;AD[4]=2.1742716421e+00;AD[5]=2.4271030860e+00;
   AD[6]=1.8438165927e+00;AD[7]=2.0944929379e+00;AD[8]=2.1154870033e+00;
   AD[9]=1.5033740749e+00;AD[10]=2.4820125683e+00;AD[11]=2.3995130918e+00;
   AD[12]=2.1927573476e+00;AD[13]=1.9396536766e+00;AD[14]=2.2010229131e+00;
   AD[15]=2.1097149889e+00;AD[16]=1.7998856615e+00;AD[17]=2.3560371937e+00;
   AD[18]=1.6120721702e+00;AD[19]=1.7915604108e+00;AD[20]=1.5974467275e+00;
   AD[21]=1.8974479697e+00;AD[22]=1.8333126524e+00;AD[23]=2.4442347139e+00;
   AD[24]=2.3385554530e+00;AD[25]=1.7584274030e+00;AD[26]=1.5428981252e+00;
   AD[27]=1.5058847898e+00;AD[28]=2.0744179674e+00;AD[29]=2.2439019523e+00;
   AD[30]=2.3068307838e+00;AD[31]=2.1375706443e+00;AD[32]=1.7512713135e+00;
   AD[33]=1.6443204515e+00;AD[34]=2.1515511325e+00;AD[35]=2.4460869309e+00;
   AD[36]=2.3158867960e+00;AD[37]=2.4302470654e+00;AD[38]=1.8099413594e+00;
   AD[39]=1.7688171111e+00;AD[40]=2.0364510350e+00;AD[41]=1.6632782959e+00;
   AD[42]=1.7109880221e+00;AD[43]=1.7168120903e+00;AD[44]=2.1517898294e+00;
   AD[45]=1.5527761861e+00;AD[46]=1.7292902803e+00;AD[47]=2.1674321285e+00;
   
   AD[48]=-3.5068966449e-01;AD[49]=1.6042739952e-01;AD[50]=-3.6413560582e-01;
   AD[51]=-2.7015135258e-01;AD[52]=3.9520169044e-01;AD[53]=3.8920608446e-01;
   AD[54]=-3.6528202618e-01;AD[55]=3.5293049763e-01;AD[56]=-1.6491662129e-01;
   AD[57]=-1.4158148398e-01;AD[58]=-3.4073518193e-01;AD[59]=-1.3154184680e-01;
   AD[60]=3.6863524403e-01;AD[61]=2.3392625695e-01;
   AD[62]=2.0320333825e-01;AD[63]=-1.2039586667e-01;AD[64]=-2.2356527950e-01;
   AD[65]=-3.8692017087e-01;AD[66]=-2.8700634111e-01;AD[67]=-4.6440003295e-01;
   AD[68]=1.5661853568e-01;AD[69]=4.9264564668e-01;AD[70]=-3.0770857932e-01;
   AD[71]=-2.4932721871e-01;AD[72]=2.1622339196e-02;AD[73]=-6.2636176319e-02;
   AD[74]=3.2498230143e-02;AD[75]=-3.1966932743e-01;
   Ab = thee->AD[1][0];
   IJA = Vmem_malloc(Ab->vmem, 85, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=3;IJA[3]=4;IJA[4]=4;
   IJA[5]=5;IJA[6]=5;IJA[7]=5;IJA[8]=6;IJA[9]=9;
   IJA[10]=10;IJA[11]=10;IJA[12]=11;IJA[13]=11;IJA[14]=11;
   IJA[15]=11;IJA[16]=11;IJA[17]=11;IJA[18]=12;IJA[19]=12;
   IJA[20]=12;IJA[21]=13;IJA[22]=14;IJA[23]=15;IJA[24]=15;
   IJA[25]=16;IJA[26]=17;IJA[27]=19;IJA[28]=19;IJA[29]=21;
   IJA[30]=25;IJA[31]=25;IJA[32]=25;IJA[33]=25;IJA[34]=25;
   IJA[35]=26;IJA[36]=27;IJA[37]=27;IJA[38]=28;IJA[39]=29;
   IJA[40]=29;IJA[41]=32;IJA[42]=32;IJA[43]=33;IJA[44]=33;
   IJA[45]=33;IJA[46]=33;IJA[47]=34;IJA[48]=34;IJA[49]=34;
   IJA[50]=34;
   IJA[51]=2;IJA[52]=13;IJA[53]=30;IJA[54]=12;IJA[55]=41;
   IJA[56]=8;IJA[57]=0;IJA[58]=10;IJA[59]=36;IJA[60]=43;
   IJA[61]=6;IJA[62]=6;IJA[63]=35;IJA[64]=44;IJA[65]=8;
   IJA[66]=16;IJA[67]=19;IJA[68]=14;IJA[69]=38;IJA[70]=25;
   IJA[71]=43;IJA[72]=15;IJA[73]=20;IJA[74]=33;IJA[75]=47;
   IJA[76]=28;IJA[77]=19;IJA[78]=11;IJA[79]=12;IJA[80]=17;
   IJA[81]=19;IJA[82]=21;IJA[83]=10;IJA[84]=22;
   Mat_initStructure(Ab, COL_FORMAT, ISNOT_SYM, 34, IJA, VNULL);
   AD = Ab->A;

   AD[0]=2.5533857179e-01;AD[1]=3.9481276348e-01;AD[2]=-2.1385034955e-01;
   AD[3]=2.0185317357e-01;AD[4]=-4.4908309227e-02;AD[5]=-1.2510073855e-01;
   AD[6]=-4.2630994433e-01;AD[7]=-3.0016200429e-01;AD[8]=-4.5050672034e-01;
   AD[9]=6.6709779124e-02;AD[10]=-3.7807525015e-01;AD[11]=2.6991847758e-01;
   AD[12]=4.4915039449e-01;AD[13]=3.8883261030e-01;AD[14]=-3.9841452189e-01;
   AD[15]=4.3309841845e-01;AD[16]=4.9953167427e-01;AD[17]=-2.8801203748e-01;
   AD[18]=-1.5902014366e-03;AD[19]=1.7275441093e-01;AD[20]=4.5799111991e-01;
   AD[21]=-4.0458698352e-01;AD[22]=-4.8513566254e-01;AD[23]=-2.1180665441e-01;
   AD[24]=3.1673121344e-01;AD[25]=1.5964479881e-01;AD[26]=1.0493711005e-01;
   AD[27]=-3.1663636750e-01;AD[28]=1.3654690533e-01;AD[29]=3.9601105873e-02;
   AD[30]=1.2339418254e-01;AD[31]=1.8588997324e-01;AD[32]=3.7683002419e-01;
   AD[33]=-4.2567850712e-01;
   Ab = thee->AD[1][2];
   IJA = Vmem_malloc(Ab->vmem, 95, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=4;IJA[3]=4;IJA[4]=4;
   IJA[5]=5;IJA[6]=10;IJA[7]=11;IJA[8]=12;IJA[9]=12;
   IJA[10]=13;IJA[11]=13;IJA[12]=15;IJA[13]=15;IJA[14]=17;
   IJA[15]=19;IJA[16]=20;IJA[17]=22;IJA[18]=24;IJA[19]=27;
   IJA[20]=27;IJA[21]=27;IJA[22]=27;IJA[23]=28;IJA[24]=29;
   IJA[25]=30;IJA[26]=30;IJA[27]=30;IJA[28]=30;IJA[29]=30;
   IJA[30]=30;IJA[31]=30;IJA[32]=30;IJA[33]=31;IJA[34]=31;
   IJA[35]=31;IJA[36]=33;IJA[37]=34;IJA[38]=34;IJA[39]=35;
   IJA[40]=36;IJA[41]=38;IJA[42]=39;IJA[43]=39;IJA[44]=39;
   IJA[45]=42;IJA[46]=42;IJA[47]=46;IJA[48]=46;
   IJA[49]=15;IJA[50]=4;IJA[51]=32;IJA[52]=47;IJA[53]=27;
   IJA[54]=12;IJA[55]=16;IJA[56]=42;IJA[57]=46;IJA[58]=50;
   IJA[59]=37;IJA[60]=16;IJA[61]=33;IJA[62]=7;IJA[63]=9;
   IJA[64]=20;IJA[65]=21;IJA[66]=21;IJA[67]=27;IJA[68]=7;
   IJA[69]=9;IJA[70]=23;IJA[71]=14;IJA[72]=44;IJA[73]=4;
   IJA[74]=30;IJA[75]=48;IJA[76]=42;IJA[77]=46;IJA[78]=42;
   IJA[79]=1;IJA[80]=19;IJA[81]=35;IJA[82]=28;IJA[83]=6;
   IJA[84]=32;IJA[85]=0;IJA[86]=11;IJA[87]=3;IJA[88]=4;
   IJA[89]=39;IJA[90]=51;IJA[91]=1;IJA[92]=11;IJA[93]=26;
   IJA[94]=32;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 46, IJA, VNULL);
   AD = Ab->A;

   AD[0]=3.3685155582e-01;AD[1]=1.0810565645e-01;AD[2]=-4.8637364722e-01;
   AD[3]=-1.6888921410e-01;AD[4]=1.5207899473e-02;AD[5]=-3.3069414091e-01;
   AD[6]=3.0346218776e-01;AD[7]=1.1856262419e-01;AD[8]=2.5856859902e-01;
   AD[9]=-1.5902115153e-02;AD[10]=2.7267959720e-01;AD[11]=1.9778483021e-01;
   AD[12]=4.0494922004e-01;AD[13]=-9.2242978043e-02;AD[14]=-1.8894144090e-01;
   AD[15]=-5.4645271822e-02;AD[16]=-4.8704217045e-01;AD[17]=-1.9125820338e-01;
   AD[18]=1.0586579416e-01;AD[19]=-4.4730731231e-01;AD[20]=-3.3146555692e-01;
   AD[21]=3.8070533184e-01;AD[22]=-4.8380251603e-01;AD[23]=2.6170319132e-01;
   AD[24]=-3.2400435866e-01;AD[25]=-3.6979832851e-01;AD[26]=6.4568594016e-02;
   AD[27]=-4.8447904276e-01;AD[28]=-1.1927006232e-01;AD[29]=3.9085396492e-01;
   AD[30]=-3.0813673555e-01;AD[31]=3.2071700872e-01;AD[32]=4.8371191820e-01;
   AD[33]=3.2211740176e-01;AD[34]=-9.2485019911e-02;AD[35]=6.1579369716e-02;
   AD[36]=4.8048127455e-01;AD[37]=2.3399631682e-01;AD[38]=-1.2018225037e-01;
   AD[39]=-4.9797443902e-01;AD[40]=-4.9314220826e-01;AD[41]=-2.9724110434e-01;
   AD[42]=1.3898656788e-01;AD[43]=-8.9095817576e-02;AD[44]=1.0153027043e-02;
   AD[45]=-4.5439061953e-02;
   Ab = thee->AD[2][2];
   IJA = Vmem_malloc(Ab->vmem, 67, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=1;IJA[3]=2;IJA[4]=2;
   IJA[5]=2;IJA[6]=4;IJA[7]=4;IJA[8]=4;IJA[9]=5;
   IJA[10]=5;IJA[11]=5;IJA[12]=5;IJA[13]=6;IJA[14]=7;
   IJA[15]=7;IJA[16]=7;IJA[17]=7;IJA[18]=7;IJA[19]=7;
   IJA[20]=7;IJA[21]=7;IJA[22]=8;IJA[23]=8;IJA[24]=8;
   IJA[25]=9;IJA[26]=9;IJA[27]=9;IJA[28]=10;IJA[29]=11;
   IJA[30]=11;IJA[31]=12;IJA[32]=12;IJA[33]=12;IJA[34]=13;
   IJA[35]=13;IJA[36]=14;IJA[37]=14;IJA[38]=14;IJA[39]=14;
   IJA[40]=14;IJA[41]=14;IJA[42]=14;IJA[43]=14;IJA[44]=14;
   IJA[45]=14;IJA[46]=14;IJA[47]=14;IJA[48]=14;IJA[49]=14;
   IJA[50]=14;IJA[51]=14;IJA[52]=14;
   IJA[53]=17;IJA[54]=38;IJA[55]=7;IJA[56]=36;IJA[57]=28;
   IJA[58]=50;IJA[59]=49;IJA[60]=41;IJA[61]=34;IJA[62]=47;
   IJA[63]=31;IJA[64]=45;IJA[65]=37;IJA[66]=41;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 14, IJA, VNULL);
   AD = Ab->A;

   AD[0]=1.8109336769e+00;AD[1]=1.8066328621e+00;AD[2]=2.2206798841e+00;
   AD[3]=2.4544065100e+00;AD[4]=1.6311383930e+00;AD[5]=1.5682768091e+00;
   AD[6]=1.6252272687e+00;AD[7]=1.6661534151e+00;AD[8]=2.4114174647e+00;
   AD[9]=1.6362602676e+00;AD[10]=2.1169954209e+00;AD[11]=1.7689816463e+00;
   AD[12]=1.7206640326e+00;AD[13]=2.2129010221e+00;AD[14]=2.0489964423e+00;
   AD[15]=2.4413484240e+00;AD[16]=1.8298647780e+00;AD[17]=2.2044863019e+00;
   AD[18]=2.4434254606e+00;AD[19]=2.0815943374e+00;AD[20]=2.3801541848e+00;
   AD[21]=2.2496116446e+00;AD[22]=1.8796173423e+00;AD[23]=2.2255612793e+00;
   AD[24]=1.6627982033e+00;AD[25]=2.4562046126e+00;AD[26]=1.6962288305e+00;
   AD[27]=2.2761925058e+00;AD[28]=2.1132957157e+00;AD[29]=1.6622802311e+00;
   AD[30]=1.5310540534e+00;AD[31]=1.7886288153e+00;AD[32]=2.4710642791e+00;
   AD[33]=2.4504993419e+00;AD[34]=1.7280478078e+00;AD[35]=2.4585260847e+00;
   AD[36]=2.1798582594e+00;AD[37]=1.5549692084e+00;AD[38]=2.0998413175e+00;
   AD[39]=1.8931459933e+00;AD[40]=1.7153661853e+00;AD[41]=1.6823996247e+00;
   AD[42]=1.5767540242e+00;AD[43]=1.5074236960e+00;AD[44]=2.2887829963e+00;
   AD[45]=1.5177876301e+00;AD[46]=2.3779414654e+00;AD[47]=1.8525417684e+00;
   AD[48]=2.2221397679e+00;AD[49]=2.4684508394e+00;AD[50]=1.6556679836e+00;
   AD[51]=1.6629555420e+00;
   AD[52]=-3.8112218412e-02;AD[53]=-4.9892663443e-01;AD[54]=4.4181514986e-01;
   AD[55]=1.5232469369e-01;AD[56]=-1.8224932056e-01;AD[57]=3.0221322488e-01;
   AD[58]=2.7986777945e-01;AD[59]=-3.0433794831e-01;AD[60]=-4.3496564612e-01;
   AD[61]=4.0784436652e-03;AD[62]=1.6784589374e-01;AD[63]=4.0703504090e-01;
   AD[64]=-3.9382420649e-01;AD[65]=2.8714312889e-01;
   AD[66]=2.9183160234e-01;AD[67]=1.6900007931e-01;AD[68]=2.9022400218e-01;
   AD[69]=1.3608501661e-02;AD[70]=-3.5002831585e-01;AD[71]=2.4745490242e-02;
   AD[72]=1.4120266333e-01;AD[73]=3.7535098307e-01;AD[74]=1.1590865550e-01;
   AD[75]=4.6670262965e-01;AD[76]=8.7696771996e-02;AD[77]=-2.4564574298e-01;
   AD[78]=-2.1784114888e-01;AD[79]=4.2234958118e-01;
   Ab = thee->AD[2][0];
   IJA = Vmem_malloc(Ab->vmem, 81, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=2;IJA[3]=4;IJA[4]=4;
   IJA[5]=4;IJA[6]=6;IJA[7]=6;IJA[8]=7;IJA[9]=7;
   IJA[10]=7;IJA[11]=7;IJA[12]=7;IJA[13]=7;IJA[14]=7;
   IJA[15]=7;IJA[16]=7;IJA[17]=7;IJA[18]=8;IJA[19]=8;
   IJA[20]=8;IJA[21]=9;IJA[22]=9;IJA[23]=9;IJA[24]=10;
   IJA[25]=11;IJA[26]=11;IJA[27]=11;IJA[28]=12;IJA[29]=14;
   IJA[30]=15;IJA[31]=17;IJA[32]=19;IJA[33]=20;IJA[34]=21;
   IJA[35]=22;IJA[36]=23;IJA[37]=23;IJA[38]=23;IJA[39]=23;
   IJA[40]=24;IJA[41]=25;IJA[42]=25;IJA[43]=25;IJA[44]=26;
   IJA[45]=27;IJA[46]=28;IJA[47]=29;IJA[48]=29;IJA[49]=30;
   IJA[50]=30;
   IJA[51]=12;IJA[52]=35;IJA[53]=20;IJA[54]=40;IJA[55]=25;
   IJA[56]=31;IJA[57]=4;IJA[58]=4;IJA[59]=11;IJA[60]=6;
   IJA[61]=25;IJA[62]=10;IJA[63]=12;IJA[64]=51;IJA[65]=6;
   IJA[66]=3;IJA[67]=22;IJA[68]=1;IJA[69]=25;IJA[70]=9;
   IJA[71]=39;IJA[72]=27;IJA[73]=24;IJA[74]=36;IJA[75]=22;
   IJA[76]=1;IJA[77]=49;IJA[78]=6;IJA[79]=24;IJA[80]=18;
   
   Mat_initStructure(Ab, COL_FORMAT, ISNOT_SYM, 30, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-1.4428389554e-01;AD[1]=-2.4879945372e-01;AD[2]=3.4767646818e-01;
   AD[3]=-2.9072835934e-01;AD[4]=-4.1892627476e-01;AD[5]=3.5112240092e-01;
   AD[6]=3.6779569791e-01;AD[7]=-1.2494420334e-01;AD[8]=-2.1120234723e-01;
   AD[9]=-2.6570026669e-01;AD[10]=-4.3687210405e-01;AD[11]=-2.0951170477e-01;
   AD[12]=2.6655153444e-01;AD[13]=1.6612373774e-01;AD[14]=4.8548350985e-01;
   AD[15]=-4.8263730696e-01;AD[16]=3.1939293234e-01;AD[17]=6.0222040963e-02;
   AD[18]=-2.5596846600e-01;AD[19]=3.2200758849e-01;AD[20]=-2.3678807204e-01;
   AD[21]=-2.8593714415e-01;AD[22]=1.5950154817e-01;AD[23]=-3.2969088987e-01;
   AD[24]=1.7734595270e-01;AD[25]=-4.8710949978e-01;AD[26]=2.7907924749e-01;
   AD[27]=1.7871987585e-01;AD[28]=-4.2933080865e-01;AD[29]=-2.7284628495e-01;
   
   Ab = thee->AD[2][1];
   IJA = Vmem_malloc(Ab->vmem, 95, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=4;IJA[3]=4;IJA[4]=4;
   IJA[5]=5;IJA[6]=10;IJA[7]=11;IJA[8]=12;IJA[9]=12;
   IJA[10]=13;IJA[11]=13;IJA[12]=15;IJA[13]=15;IJA[14]=17;
   IJA[15]=19;IJA[16]=20;IJA[17]=22;IJA[18]=24;IJA[19]=27;
   IJA[20]=27;IJA[21]=27;IJA[22]=27;IJA[23]=28;IJA[24]=29;
   IJA[25]=30;IJA[26]=30;IJA[27]=30;IJA[28]=30;IJA[29]=30;
   IJA[30]=30;IJA[31]=30;IJA[32]=30;IJA[33]=31;IJA[34]=31;
   IJA[35]=31;IJA[36]=33;IJA[37]=34;IJA[38]=34;IJA[39]=35;
   IJA[40]=36;IJA[41]=38;IJA[42]=39;IJA[43]=39;IJA[44]=39;
   IJA[45]=42;IJA[46]=42;IJA[47]=46;IJA[48]=46;
   IJA[49]=15;IJA[50]=4;IJA[51]=32;IJA[52]=47;IJA[53]=27;
   IJA[54]=12;IJA[55]=16;IJA[56]=42;IJA[57]=46;IJA[58]=50;
   IJA[59]=37;IJA[60]=16;IJA[61]=33;IJA[62]=7;IJA[63]=9;
   IJA[64]=20;IJA[65]=21;IJA[66]=21;IJA[67]=27;IJA[68]=7;
   IJA[69]=9;IJA[70]=23;IJA[71]=14;IJA[72]=44;IJA[73]=4;
   IJA[74]=30;IJA[75]=48;IJA[76]=42;IJA[77]=46;IJA[78]=42;
   IJA[79]=1;IJA[80]=19;IJA[81]=35;IJA[82]=28;IJA[83]=6;
   IJA[84]=32;IJA[85]=0;IJA[86]=11;IJA[87]=3;IJA[88]=4;
   IJA[89]=39;IJA[90]=51;IJA[91]=1;IJA[92]=11;IJA[93]=26;
   IJA[94]=32;
   Mat_initStructure(Ab, COL_FORMAT, ISNOT_SYM, 46, IJA, VNULL);
   AD = Ab->A;

   AD[0]=-4.1795784671e-02;AD[1]=8.2483875016e-02;AD[2]=9.2060018146e-03;
   AD[3]=-4.2571039091e-01;AD[4]=2.7088183623e-01;AD[5]=-1.8607001000e-01;
   AD[6]=1.3819321911e-01;AD[7]=4.8656686410e-01;AD[8]=2.8758035840e-03;
   AD[9]=4.4770337680e-01;AD[10]=3.1212590606e-01;AD[11]=4.0826256311e-01;
   AD[12]=2.6266646976e-01;AD[13]=1.6316200785e-01;AD[14]=3.8349350189e-01;
   AD[15]=3.5056678325e-01;AD[16]=-1.5979655271e-01;AD[17]=4.1376323974e-01;
   AD[18]=-2.7142329415e-01;AD[19]=3.9118280245e-01;AD[20]=-1.2667405946e-01;
   AD[21]=3.1378317841e-02;AD[22]=1.9443351858e-03;AD[23]=-7.7805172600e-02;
   AD[24]=1.7365301114e-01;AD[25]=4.5733018290e-01;AD[26]=-3.0813425429e-01;
   AD[27]=1.9528688375e-02;AD[28]=2.1568904676e-01;AD[29]=4.3386481580e-01;
   AD[30]=2.2578930943e-01;AD[31]=1.2641267464e-01;AD[32]=-2.5882769148e-01;
   AD[33]=1.4050078004e-01;AD[34]=1.6582340850e-01;AD[35]=-4.7750670659e-01;
   AD[36]=-2.3780055064e-01;AD[37]=-3.8348484039e-01;AD[38]=-4.6758143559e-01;
   AD[39]=3.6602060197e-01;AD[40]=-2.4575306538e-01;AD[41]=6.9480596700e-02;
   AD[42]=9.4364416207e-02;AD[43]=-1.6889991886e-01;AD[44]=1.5861265399e-01;
   AD[45]=3.6363421812e-01;
   return thee;
}

VPRIVATE void Bvec_example( Bvec *thee, int key )
{
   int numB = 3, numR[MAXV];
   double *uu;

   VASSERT( numB <= MAXV );
   VASSERT( Bvec_numB(thee) == 3 );

   numR[0] = 50;
   VASSERT(Bvec_numRB(thee,0) == 50);
   numR[1] = 48;
   VASSERT(Bvec_numRB(thee,1) == 48);
   numR[2] = 52;
   VASSERT(Bvec_numRB(thee,2) == 52);
   switch(key) {
     case 0: /* u0 */

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-1.8660263166e-01;uu[1]=-4.7061845175e-01;uu[2]=-1.4237488305e-01;
     uu[3]=-4.7280960172e-01;uu[4]=2.9366701865e-01;uu[5]=4.9923075446e-01;
     uu[6]=-3.8976147545e-01;uu[7]=1.2260115870e-01;uu[8]=-3.6742815477e-01;
     uu[9]=-1.8997021105e-01;uu[10]=-3.6521231217e-01;uu[11]=-2.7667368735e-01;
     uu[12]=-1.0345321169e-01;uu[13]=-3.6485650513e-01;uu[14]=-2.5894131059e-01;
     uu[15]=4.2751614982e-01;uu[16]=-1.0889912601e-01;uu[17]=1.1262773467e-02;
     uu[18]=-4.0710388384e-01;uu[19]=-4.7830108570e-01;uu[20]=-3.4046517333e-01;
     uu[21]=3.4451594383e-01;uu[22]=3.7915348243e-01;uu[23]=-3.1301047414e-01;
     uu[24]=4.9130491903e-01;uu[25]=2.1202984117e-01;uu[26]=3.7136461659e-01;
     uu[27]=-2.0368815237e-02;uu[28]=-3.9950734431e-03;uu[29]=-2.1246813579e-01;
     uu[30]=-4.3905854905e-01;uu[31]=-2.3753229579e-01;uu[32]=-3.1373898295e-01;
     uu[33]=4.1708978682e-01;uu[34]=-3.7672130568e-01;uu[35]=-4.8655461690e-01;
     uu[36]=-1.3030928147e-01;uu[37]=1.9864110832e-01;uu[38]=3.8934721323e-01;
     uu[39]=9.3770519136e-02;uu[40]=-3.4330910327e-01;uu[41]=-1.8331058131e-01;
     uu[42]=-2.6660451417e-01;uu[43]=-4.9157793625e-01;uu[44]=-1.0309620813e-01;
     uu[45]=1.4986813059e-01;uu[46]=-4.1499939379e-01;uu[47]=2.6880950326e-01;
     uu[48]=4.6970170497e-01;uu[49]=2.1479723188e-01;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=2.8196184196e-01;uu[1]=-2.6243491796e-01;uu[2]=-3.0426923622e-01;
     uu[3]=-2.3678608482e-01;uu[4]=2.1378506460e-01;uu[5]=4.7759973944e-01;
     uu[6]=1.3712194085e-01;uu[7]=4.5924155099e-02;uu[8]=3.4805722442e-01;
     uu[9]=3.0209765848e-01;uu[10]=1.6830641007e-01;uu[11]=1.7098263397e-01;
     uu[12]=3.2064368229e-01;uu[13]=4.7047237461e-01;uu[14]=-1.3075004458e-02;
     uu[15]=3.1746853555e-01;uu[16]=1.4157116785e-01;uu[17]=-1.9365064049e-01;
     uu[18]=1.6093213224e-01;uu[19]=-1.4198288661e-01;uu[20]=4.3819943010e-01;
     uu[21]=-1.2333025235e-02;uu[22]=-4.0900964226e-01;uu[23]=1.7383411686e-01;
     uu[24]=1.4880318988e-02;uu[25]=-2.7842065361e-01;uu[26]=2.2500937095e-01;
     uu[27]=-4.3175338903e-01;uu[28]=4.6412426837e-01;uu[29]=-2.9234341163e-01;
     uu[30]=-3.3888177445e-01;uu[31]=1.3822138259e-01;uu[32]=-4.9977182711e-01;
     uu[33]=-1.6436705665e-01;uu[34]=-2.2490017853e-01;uu[35]=-4.5547247961e-01;
     uu[36]=-4.0610350240e-01;uu[37]=-9.0002600228e-02;uu[38]=3.1689231949e-01;
     uu[39]=3.7051707181e-01;uu[40]=-4.7744487954e-01;uu[41]=2.2717698370e-01;
     uu[42]=3.4800944806e-01;uu[43]=2.2860019102e-01;uu[44]=4.5509863328e-01;
     uu[45]=1.5635111060e-01;uu[46]=2.4230513351e-01;uu[47]=-1.5503398610e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=3.8402194968e-01;uu[1]=-1.5275591350e-01;uu[2]=-4.4052331946e-01;
     uu[3]=2.1841459108e-01;uu[4]=4.5821429291e-01;uu[5]=-3.4316513493e-01;
     uu[6]=-8.3646893854e-02;uu[7]=-4.0596513103e-01;uu[8]=-5.0053546051e-02;
     uu[9]=3.6915242558e-01;uu[10]=-1.0838277734e-01;uu[11]=-2.4721634894e-01;
     uu[12]=-1.4561807343e-01;uu[13]=2.4297796820e-01;uu[14]=1.5083202246e-01;
     uu[15]=4.3979304053e-01;uu[16]=3.3279912460e-01;uu[17]=-3.0022133145e-02;
     uu[18]=1.2986560726e-01;uu[19]=-4.4181215219e-01;uu[20]=4.2187397297e-02;
     uu[21]=-4.4274037728e-02;uu[22]=3.6308689222e-01;uu[23]=3.5519696972e-01;
     uu[24]=-2.7744317436e-02;uu[25]=2.8692438967e-01;uu[26]=1.5598213826e-01;
     uu[27]=-4.9996011040e-01;uu[28]=-3.6876283825e-01;uu[29]=-5.1252439974e-03;
     uu[30]=-4.6166684283e-01;uu[31]=-2.7256419050e-01;uu[32]=-1.7211704272e-01;
     uu[33]=3.9946878769e-01;uu[34]=-1.8626951244e-01;uu[35]=-2.4832398811e-01;
     uu[36]=-6.7010868324e-02;uu[37]=3.4238223654e-01;uu[38]=-3.1551100839e-01;
     uu[39]=8.1792123695e-03;uu[40]=-4.7760333285e-02;uu[41]=-1.7441556058e-01;
     uu[42]=-1.1992369303e-01;uu[43]=3.8647996364e-01;uu[44]=2.6126076032e-01;
     uu[45]=3.8376633494e-01;uu[46]=-4.2593744000e-02;uu[47]=2.9920229135e-01;
     uu[48]=-3.6592288019e-01;uu[49]=-4.3468631166e-01;uu[50]=-1.2485534199e-01;
     uu[51]=-1.2647703007e-01;
     break;
     case 1: /* f */

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-1.5977602895e-02;uu[1]=4.6945923205e-01;uu[2]=-1.5793890574e-01;
     uu[3]=-2.4731074386e-01;uu[4]=8.4886916758e-02;uu[5]=2.3703594411e-02;
     uu[6]=-3.3658095357e-01;uu[7]=-1.3601851411e-02;uu[8]=-3.9392505224e-03;
     uu[9]=3.4319408324e-01;uu[10]=3.0619821541e-01;uu[11]=3.5778559630e-01;
     uu[12]=1.0975413783e-01;uu[13]=6.5730367753e-02;uu[14]=1.1189852165e-01;
     uu[15]=-3.9702347773e-01;uu[16]=-3.4168408273e-01;uu[17]=-8.6350140322e-02;
     uu[18]=6.0410448538e-02;uu[19]=-2.3132270856e-01;uu[20]=2.8425416427e-01;
     uu[21]=-1.1212921527e-01;uu[22]=-4.6901637912e-01;uu[23]=8.5501829416e-02;
     uu[24]=5.8558528225e-02;uu[25]=-2.9930442753e-01;uu[26]=-4.1257811486e-01;
     uu[27]=4.3322985930e-01;uu[28]=-2.4062002644e-01;uu[29]=-2.9582860541e-01;
     uu[30]=-4.5079155811e-01;uu[31]=1.0616093977e-01;uu[32]=4.6348740161e-02;
     uu[33]=-4.0416256385e-01;uu[34]=1.3699564688e-01;uu[35]=-5.7051671957e-02;
     uu[36]=-4.3361804114e-01;uu[37]=-1.2570741594e-01;uu[38]=-2.5089727571e-01;
     uu[39]=4.2487529165e-01;uu[40]=1.2949929258e-01;uu[41]=3.7830877650e-01;
     uu[42]=1.4167443103e-01;uu[43]=2.9839063600e-01;uu[44]=-6.4973961451e-02;
     uu[45]=4.8114025132e-01;uu[46]=-4.0404220167e-01;uu[47]=2.7482398964e-02;
     uu[48]=4.5645824716e-02;uu[49]=-2.1565724319e-01;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-1.2919734070e-01;uu[1]=-4.3530739787e-01;uu[2]=4.4809064432e-02;
     uu[3]=3.3637560325e-01;uu[4]=-3.5467800832e-01;uu[5]=-3.2847974319e-01;
     uu[6]=-4.3195281774e-01;uu[7]=3.2401153402e-01;uu[8]=-3.6602924214e-01;
     uu[9]=3.8478628848e-01;uu[10]=1.4737399467e-02;uu[11]=4.6363559620e-01;
     uu[12]=-3.7950533246e-01;uu[13]=-4.5171011782e-01;uu[14]=-1.1984799612e-01;
     uu[15]=-8.7208781942e-02;uu[16]=-9.8608703347e-02;uu[17]=-7.9002869532e-02;
     uu[18]=-1.2304630860e-01;uu[19]=4.0733652646e-01;uu[20]=1.7016214469e-01;
     uu[21]=4.6183852460e-01;uu[22]=-3.3702066391e-01;uu[23]=2.4864940896e-01;
     uu[24]=-1.2593427596e-01;uu[25]=-4.5763488741e-02;uu[26]=-4.6143930413e-01;
     uu[27]=6.2432006451e-02;uu[28]=-1.2768785336e-01;uu[29]=2.9278370735e-01;
     uu[30]=2.9523097285e-01;uu[31]=-1.1708552772e-01;uu[32]=-2.4721019567e-01;
     uu[33]=-1.5707214403e-01;uu[34]=4.6780449335e-01;uu[35]=-2.0191609439e-02;
     uu[36]=-1.3167243709e-01;uu[37]=2.6456715524e-01;uu[38]=-1.2285102975e-01;
     uu[39]=4.0030621565e-01;uu[40]=-3.1656794705e-01;uu[41]=-1.3168268372e-01;
     uu[42]=4.1745703926e-01;uu[43]=1.5916056144e-02;uu[44]=-4.0969273783e-01;
     uu[45]=2.3531148769e-01;uu[46]=-4.9528783767e-01;uu[47]=1.0312311695e-01;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=4.5686666404e-01;uu[1]=-1.0256807074e-01;uu[2]=2.3155078533e-01;
     uu[3]=1.8463882651e-01;uu[4]=4.7850302245e-01;uu[5]=-2.9621483343e-01;
     uu[6]=9.3302839012e-02;uu[7]=4.5156251679e-01;uu[8]=-2.3972759255e-01;
     uu[9]=1.4677620909e-02;uu[10]=1.3633189865e-01;uu[11]=-9.9040893825e-02;
     uu[12]=-1.3388689262e-02;uu[13]=2.5045811318e-01;uu[14]=-3.7380326637e-01;
     uu[15]=-4.5693751839e-01;uu[16]=-1.2906065639e-01;uu[17]=1.9330212077e-01;
     uu[18]=4.3582494285e-01;uu[19]=-2.2424390832e-02;uu[20]=-3.7089990236e-01;
     uu[21]=-1.6168787926e-02;uu[22]=4.4559716171e-01;uu[23]=-1.3225586653e-01;
     uu[24]=-1.7151443108e-01;uu[25]=2.7287548034e-01;uu[26]=-2.0272597795e-01;
     uu[27]=-3.2214564009e-01;uu[28]=1.9079916148e-01;uu[29]=-2.3605514470e-01;
     uu[30]=-4.2260942897e-02;uu[31]=3.4369242456e-01;uu[32]=3.8149866052e-01;
     uu[33]=2.0001995640e-01;uu[34]=2.5569099493e-01;uu[35]=4.7451480138e-01;
     uu[36]=-9.7847316536e-02;uu[37]=-3.6872136180e-01;uu[38]=2.2473388700e-01;
     uu[39]=3.9951820736e-01;uu[40]=-3.2929868542e-01;uu[41]=-4.5697130879e-01;
     uu[42]=-2.0840775074e-02;uu[43]=-4.0606371524e-01;uu[44]=1.5004983165e-01;
     uu[45]=4.5227753892e-01;uu[46]=-4.2287300608e-02;uu[47]=3.6880647006e-02;
     uu[48]=-4.3351285420e-01;uu[49]=-6.1299164175e-03;uu[50]=-8.2459027620e-02;
     uu[51]=-2.0774294973e-01;
     break;
     case 2: /* uexact (key==0,adj==0) */

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-1.4699562954e-02;uu[1]=-4.7061845175e-01;uu[2]=-1.4993129749e-02;
     uu[3]=-1.0125265320e-01;uu[4]=2.9366701865e-01;uu[5]=4.9923075446e-01;
     uu[6]=-3.8976147545e-01;uu[7]=1.2260115870e-01;uu[8]=7.5145461155e-02;
     uu[9]=1.5727237002e-01;uu[10]=1.3355877039e-01;uu[11]=-2.7667368735e-01;
     uu[12]=5.8961688511e-02;uu[13]=-3.6485650513e-01;uu[14]=-2.5894131059e-01;
     uu[15]=4.2751614982e-01;uu[16]=-1.0889912601e-01;uu[17]=-8.2759901215e-02;
     uu[18]=-4.0710388384e-01;uu[19]=-4.7830108570e-01;uu[20]=-3.4046517333e-01;
     uu[21]=6.3518323375e-02;uu[22]=3.7915348243e-01;uu[23]=-3.1301047414e-01;
     uu[24]=4.9130491903e-01;uu[25]=2.1202984117e-01;uu[26]=-2.1847184461e-01;
     uu[27]=-2.0368815237e-02;uu[28]=-3.9950734431e-03;uu[29]=-1.1097391913e-01;
     uu[30]=-4.3905854905e-01;uu[31]=-1.8865509736e-02;uu[32]=-3.1373898295e-01;
     uu[33]=-2.1946377935e-01;uu[34]=-3.7672130568e-01;uu[35]=-4.8655461690e-01;
     uu[36]=-2.5980378520e-01;uu[37]=-9.5081969841e-02;uu[38]=-1.0942351277e-01;
     uu[39]=2.1604474595e-01;uu[40]=-3.4330910327e-01;uu[41]=-1.8331058131e-01;
     uu[42]=-2.6660451417e-01;uu[43]=-4.9157793625e-01;uu[44]=-1.0309620813e-01;
     uu[45]=3.7428546005e-01;uu[46]=-4.1499939379e-01;uu[47]=2.6880950326e-01;
     uu[48]=6.5983155928e-02;uu[49]=2.1479723188e-01;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-1.0023404546e-01;uu[1]=-2.6243491796e-01;uu[2]=-3.0426923622e-01;
     uu[3]=-2.3678608482e-01;uu[4]=-1.3647942262e-01;uu[5]=4.7759973944e-01;
     uu[6]=-3.4270916196e-01;uu[7]=4.5924155099e-02;uu[8]=3.4805722442e-01;
     uu[9]=3.0209765848e-01;uu[10]=5.5502457556e-02;uu[11]=1.7098263397e-01;
     uu[12]=3.2064368229e-01;uu[13]=4.7047237461e-01;uu[14]=-1.3075004458e-02;
     uu[15]=3.1746853555e-01;uu[16]=1.4157116785e-01;uu[17]=-1.9365064049e-01;
     uu[18]=-9.8204126797e-02;uu[19]=-1.4198288661e-01;uu[20]=4.3819943010e-01;
     uu[21]=2.7703328524e-01;uu[22]=-4.0900964226e-01;uu[23]=1.7383411686e-01;
     uu[24]=-4.7423859859e-02;uu[25]=-2.5632745546e-02;uu[26]=2.2500937095e-01;
     uu[27]=-4.3175338903e-01;uu[28]=-6.7758799792e-03;uu[29]=1.4388070670e-01;
     uu[30]=-3.3888177445e-01;uu[31]=-4.4101436758e-02;uu[32]=-7.2162830819e-02;
     uu[33]=-1.0981871472e-01;uu[34]=-2.2490017853e-01;uu[35]=-4.5547247961e-01;
     uu[36]=9.0531305447e-03;uu[37]=5.4301502762e-02;uu[38]=3.1689231949e-01;
     uu[39]=3.7051707181e-01;uu[40]=-4.7744487954e-01;uu[41]=2.2717698370e-01;
     uu[42]=3.4800944806e-01;uu[43]=2.2860019102e-01;uu[44]=4.5509863328e-01;
     uu[45]=1.5635111060e-01;uu[46]=2.4230513351e-01;uu[47]=6.3795317597e-02;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=3.8402194968e-01;uu[1]=-1.9232220773e-01;uu[2]=-4.4052331946e-01;
     uu[3]=2.1841459108e-01;uu[4]=4.5821429291e-01;uu[5]=-6.8001948139e-02;
     uu[6]=-8.3646893854e-02;uu[7]=-4.0596513103e-01;uu[8]=-1.2728379626e-01;
     uu[9]=3.6915242558e-01;uu[10]=6.2382937697e-02;uu[11]=-2.4721634894e-01;
     uu[12]=-1.4561807343e-01;uu[13]=2.4297796820e-01;uu[14]=1.5083202246e-01;
     uu[15]=4.3979304053e-01;uu[16]=-1.1684514488e-01;uu[17]=3.6848666194e-02;
     uu[18]=1.2986560726e-01;uu[19]=1.6887586071e-02;uu[20]=4.2187397297e-02;
     uu[21]=5.0407625030e-03;uu[22]=3.6308689222e-01;uu[23]=-6.1421868227e-02;
     uu[24]=-2.1235353746e-01;uu[25]=2.8692438967e-01;uu[26]=1.5598213826e-01;
     uu[27]=-4.9996011040e-01;uu[28]=9.0249100244e-02;uu[29]=-5.1252439974e-03;
     uu[30]=-1.0029402758e-01;uu[31]=-2.7256419050e-01;uu[32]=-1.7211704272e-01;
     uu[33]=3.9946878769e-01;uu[34]=1.6220882703e-01;uu[35]=-2.4832398811e-01;
     uu[36]=-1.1786971588e-02;uu[37]=3.4238223654e-01;uu[38]=-3.1551100839e-01;
     uu[39]=2.4266152106e-01;uu[40]=-4.7760333285e-02;uu[41]=-2.1040413133e-01;
     uu[42]=-1.1992369303e-01;uu[43]=3.8647996364e-01;uu[44]=5.8975800835e-02;
     uu[45]=2.8175268365e-01;uu[46]=-3.4128215429e-02;uu[47]=8.5553846312e-02;
     uu[48]=-3.6592288019e-01;uu[49]=-4.3468631166e-01;uu[50]=-1.2485534199e-01;
     uu[51]=-1.4353949446e-01;
     break;
     case 3: /* uexact (key==0,adj==1) */

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-1.4699562954e-02;uu[1]=-4.7061845175e-01;uu[2]=-1.4993129749e-02;
     uu[3]=-1.0125265320e-01;uu[4]=2.9366701865e-01;uu[5]=4.9923075446e-01;
     uu[6]=-3.8976147545e-01;uu[7]=1.2260115870e-01;uu[8]=3.3862459493e-02;
     uu[9]=1.5727237002e-01;uu[10]=1.3355877039e-01;uu[11]=-2.7667368735e-01;
     uu[12]=3.1016310988e-02;uu[13]=-3.6485650513e-01;uu[14]=-2.5894131059e-01;
     uu[15]=4.2751614982e-01;uu[16]=-1.0889912601e-01;uu[17]=3.4578352831e-02;
     uu[18]=-4.0710388384e-01;uu[19]=-4.7830108570e-01;uu[20]=-3.4046517333e-01;
     uu[21]=6.3518323375e-02;uu[22]=3.7915348243e-01;uu[23]=-3.1301047414e-01;
     uu[24]=4.9130491903e-01;uu[25]=2.1202984117e-01;uu[26]=-2.1847184461e-01;
     uu[27]=-2.0368815237e-02;uu[28]=-3.9950734431e-03;uu[29]=-1.2997641695e-01;
     uu[30]=-4.3905854905e-01;uu[31]=-3.2722906243e-02;uu[32]=-3.1373898295e-01;
     uu[33]=-2.2658095975e-01;uu[34]=-3.7672130568e-01;uu[35]=-4.8655461690e-01;
     uu[36]=-2.5980378520e-01;uu[37]=-9.5081969841e-02;uu[38]=-1.0942351277e-01;
     uu[39]=2.1485975765e-01;uu[40]=-3.4330910327e-01;uu[41]=-1.8331058131e-01;
     uu[42]=-2.6660451417e-01;uu[43]=-4.9157793625e-01;uu[44]=-1.0309620813e-01;
     uu[45]=3.7428546005e-01;uu[46]=-4.1499939379e-01;uu[47]=2.6880950326e-01;
     uu[48]=6.5983155928e-02;uu[49]=2.1479723188e-01;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-1.7732726919e-01;uu[1]=-2.6243491796e-01;uu[2]=-3.0426923622e-01;
     uu[3]=-2.3678608482e-01;uu[4]=-1.6087868313e-01;uu[5]=4.7759973944e-01;
     uu[6]=-3.2413712058e-01;uu[7]=4.5924155099e-02;uu[8]=3.4805722442e-01;
     uu[9]=3.0209765848e-01;uu[10]=1.9798504193e-03;uu[11]=1.7098263397e-01;
     uu[12]=3.2064368229e-01;uu[13]=4.7047237461e-01;uu[14]=-1.3075004458e-02;
     uu[15]=3.1746853555e-01;uu[16]=1.4157116785e-01;uu[17]=-1.9365064049e-01;
     uu[18]=-2.3275734706e-02;uu[19]=-1.4198288661e-01;uu[20]=4.3819943010e-01;
     uu[21]=2.7703328524e-01;uu[22]=-4.0900964226e-01;uu[23]=1.7383411686e-01;
     uu[24]=-4.7423859859e-02;uu[25]=-2.5632745546e-02;uu[26]=2.2500937095e-01;
     uu[27]=-4.3175338903e-01;uu[28]=-6.7758799792e-03;uu[29]=1.4388070670e-01;
     uu[30]=-3.3888177445e-01;uu[31]=-7.4678039969e-03;uu[32]=-6.8438944882e-02;
     uu[33]=-1.2289229199e-01;uu[34]=-2.2490017853e-01;uu[35]=-4.5547247961e-01;
     uu[36]=-1.4650259366e-01;uu[37]=1.3069551839e-01;uu[38]=3.1689231949e-01;
     uu[39]=3.7051707181e-01;uu[40]=-4.7744487954e-01;uu[41]=2.2717698370e-01;
     uu[42]=3.4800944806e-01;uu[43]=2.2860019102e-01;uu[44]=4.5509863328e-01;
     uu[45]=1.5635111060e-01;uu[46]=2.4230513351e-01;uu[47]=7.8626871480e-02;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=3.8402194968e-01;uu[1]=-1.3159149568e-01;uu[2]=-4.4052331946e-01;
     uu[3]=2.1841459108e-01;uu[4]=4.5821429291e-01;uu[5]=-7.1736394298e-02;
     uu[6]=-8.3646893854e-02;uu[7]=-4.0596513103e-01;uu[8]=-8.9539924144e-02;
     uu[9]=3.6915242558e-01;uu[10]=6.2382937697e-02;uu[11]=-2.4721634894e-01;
     uu[12]=-1.4561807343e-01;uu[13]=2.4297796820e-01;uu[14]=1.5083202246e-01;
     uu[15]=4.3979304053e-01;uu[16]=-1.1684514488e-01;uu[17]=3.6848666194e-02;
     uu[18]=1.2986560726e-01;uu[19]=1.6887586071e-02;uu[20]=4.2187397297e-02;
     uu[21]=1.6605108468e-03;uu[22]=3.6308689222e-01;uu[23]=-6.1421868227e-02;
     uu[24]=-1.2443542472e-01;uu[25]=2.8692438967e-01;uu[26]=1.5598213826e-01;
     uu[27]=-4.9996011040e-01;uu[28]=1.3064221918e-01;uu[29]=-5.1252439974e-03;
     uu[30]=-1.3502941282e-01;uu[31]=-2.7256419050e-01;uu[32]=-1.7211704272e-01;
     uu[33]=3.9946878769e-01;uu[34]=1.4982617975e-01;uu[35]=-2.4832398811e-01;
     uu[36]=-2.8562438434e-02;uu[37]=3.4238223654e-01;uu[38]=-3.1551100839e-01;
     uu[39]=3.2227941224e-01;uu[40]=-4.7760333285e-02;uu[41]=-1.9940177584e-01;
     uu[42]=-1.1992369303e-01;uu[43]=3.8647996364e-01;uu[44]=5.8975800835e-02;
     uu[45]=2.2326644227e-01;uu[46]=-3.4128215429e-02;uu[47]=8.5553846312e-02;
     uu[48]=-3.6592288019e-01;uu[49]=-4.3468631166e-01;uu[50]=-1.2485534199e-01;
     uu[51]=-1.4353949446e-01;
     break;
     case 4: /* uexact (key==1,adj==0) */

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-1.7785959275e-02;uu[1]=-4.7061845175e-01;uu[2]=-1.3356410754e-02;
     uu[3]=-1.0125265320e-01;uu[4]=2.9366701865e-01;uu[5]=4.9923075446e-01;
     uu[6]=-3.8976147545e-01;uu[7]=1.2260115870e-01;uu[8]=-1.4667725266e-02;
     uu[9]=1.5403054839e-01;uu[10]=1.3355877039e-01;uu[11]=-2.7667368735e-01;
     uu[12]=5.4377000327e-02;uu[13]=-3.6485650513e-01;uu[14]=-2.5894131059e-01;
     uu[15]=4.2751614982e-01;uu[16]=-1.0889912601e-01;uu[17]=-4.0276364578e-02;
     uu[18]=-4.0710388384e-01;uu[19]=-4.7830108570e-01;uu[20]=-3.4046517333e-01;
     uu[21]=-1.6760704361e-01;uu[22]=3.7915348243e-01;uu[23]=-3.1301047414e-01;
     uu[24]=4.9130491903e-01;uu[25]=2.1202984117e-01;uu[26]=-1.9309743220e-01;
     uu[27]=-2.0368815237e-02;uu[28]=-3.9950734431e-03;uu[29]=6.4913978867e-03;
     uu[30]=-4.3905854905e-01;uu[31]=8.6546814348e-02;uu[32]=-3.1373898295e-01;
     uu[33]=-2.1822766851e-01;uu[34]=-3.7672130568e-01;uu[35]=-4.8655461690e-01;
     uu[36]=-2.5980378520e-01;uu[37]=-4.0231761301e-02;uu[38]=-1.4327016639e-01;
     uu[39]=2.0285284931e-01;uu[40]=-3.4330910327e-01;uu[41]=-1.8331058131e-01;
     uu[42]=-2.6660451417e-01;uu[43]=-4.9157793625e-01;uu[44]=-1.0309620813e-01;
     uu[45]=2.4941021919e-01;uu[46]=-4.1499939379e-01;uu[47]=2.6880950326e-01;
     uu[48]=5.3578917135e-02;uu[49]=2.1479723188e-01;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-4.5182666257e-02;uu[1]=-2.6243491796e-01;uu[2]=-3.0426923622e-01;
     uu[3]=-2.3678608482e-01;uu[4]=-8.6625051759e-02;uu[5]=4.7759973944e-01;
     uu[6]=-2.5277416501e-01;uu[7]=4.5924155099e-02;uu[8]=3.4805722442e-01;
     uu[9]=3.0209765848e-01;uu[10]=2.3536772328e-02;uu[11]=1.7098263397e-01;
     uu[12]=3.2064368229e-01;uu[13]=4.7047237461e-01;uu[14]=-1.3075004458e-02;
     uu[15]=3.1746853555e-01;uu[16]=1.4157116785e-01;uu[17]=-1.9365064049e-01;
     uu[18]=-3.4379769815e-02;uu[19]=-1.4198288661e-01;uu[20]=4.3819943010e-01;
     uu[21]=3.1038373431e-01;uu[22]=-4.0900964226e-01;uu[23]=1.7383411686e-01;
     uu[24]=-5.5580183402e-02;uu[25]=-2.6849527028e-02;uu[26]=2.2500937095e-01;
     uu[27]=-4.3175338903e-01;uu[28]=3.2605283508e-02;uu[29]=1.3686085923e-01;
     uu[30]=-3.3888177445e-01;uu[31]=-1.1258669153e-01;uu[32]=-1.1301361043e-01;
     uu[33]=-9.5124149976e-02;uu[34]=-2.2490017853e-01;uu[35]=-4.5547247961e-01;
     uu[36]=-3.1456028181e-02;uu[37]=8.0765398489e-02;uu[38]=3.1689231949e-01;
     uu[39]=3.7051707181e-01;uu[40]=-4.7744487954e-01;uu[41]=2.2717698370e-01;
     uu[42]=3.4800944806e-01;uu[43]=2.2860019102e-01;uu[44]=4.5509863328e-01;
     uu[45]=1.5635111060e-01;uu[46]=2.4230513351e-01;uu[47]=4.7375945829e-02;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=3.8402194968e-01;uu[1]=1.2568619245e-02;uu[2]=-4.4052331946e-01;
     uu[3]=2.1841459108e-01;uu[4]=4.5821429291e-01;uu[5]=-1.1317013031e-01;
     uu[6]=-8.3646893854e-02;uu[7]=-4.0596513103e-01;uu[8]=-1.5294117803e-01;
     uu[9]=3.6915242558e-01;uu[10]=6.8215145876e-02;uu[11]=-2.4721634894e-01;
     uu[12]=-1.4561807343e-01;uu[13]=2.4297796820e-01;uu[14]=1.5083202246e-01;
     uu[15]=4.3979304053e-01;uu[16]=-1.5469843609e-01;uu[17]=9.4324945007e-02;
     uu[18]=1.2986560726e-01;uu[19]=5.9403207512e-02;uu[20]=4.2187397297e-02;
     uu[21]=1.2266003756e-01;uu[22]=3.6308689222e-01;uu[23]=-8.3643064198e-02;
     uu[24]=-8.0929096132e-02;uu[25]=2.8692438967e-01;uu[26]=1.5598213826e-01;
     uu[27]=-4.9996011040e-01;uu[28]=9.3200997839e-02;uu[29]=-5.1252439974e-03;
     uu[30]=2.5666005768e-02;uu[31]=-2.7256419050e-01;uu[32]=-1.7211704272e-01;
     uu[33]=3.9946878769e-01;uu[34]=1.2759462866e-01;uu[35]=-2.4832398811e-01;
     uu[36]=-4.2673667132e-02;uu[37]=3.4238223654e-01;uu[38]=-3.1551100839e-01;
     uu[39]=3.3439606295e-01;uu[40]=-4.7760333285e-02;uu[41]=-2.0704752462e-01;
     uu[42]=-1.1992369303e-01;uu[43]=3.8647996364e-01;uu[44]=8.7701115656e-02;
     uu[45]=2.9110171044e-01;uu[46]=-6.0996619254e-02;uu[47]=-2.9163827710e-03;
     uu[48]=-3.6592288019e-01;uu[49]=-4.3468631166e-01;uu[50]=-1.2485534199e-01;
     uu[51]=-4.3648032755e-02;
     break;
     case 5: /* uexact (key==1,adj==1) */

     uu = Vec_addr(thee->VC[0]);
     uu[0]=-1.7785959275e-02;uu[1]=-4.7061845175e-01;uu[2]=-1.3356410754e-02;
     uu[3]=-1.0125265320e-01;uu[4]=2.9366701865e-01;uu[5]=4.9923075446e-01;
     uu[6]=-3.8976147545e-01;uu[7]=1.2260115870e-01;uu[8]=2.9812656103e-03;
     uu[9]=1.5403054839e-01;uu[10]=1.3355877039e-01;uu[11]=-2.7667368735e-01;
     uu[12]=5.8230152117e-02;uu[13]=-3.6485650513e-01;uu[14]=-2.5894131059e-01;
     uu[15]=4.2751614982e-01;uu[16]=-1.0889912601e-01;uu[17]=1.8369625990e-02;
     uu[18]=-4.0710388384e-01;uu[19]=-4.7830108570e-01;uu[20]=-3.4046517333e-01;
     uu[21]=-1.6760704361e-01;uu[22]=3.7915348243e-01;uu[23]=-3.1301047414e-01;
     uu[24]=4.9130491903e-01;uu[25]=2.1202984117e-01;uu[26]=-1.9309743220e-01;
     uu[27]=-2.0368815237e-02;uu[28]=-3.9950734431e-03;uu[29]=4.2641511326e-02;
     uu[30]=-4.3905854905e-01;uu[31]=9.7729558580e-02;uu[32]=-3.1373898295e-01;
     uu[33]=-1.7811934103e-01;uu[34]=-3.7672130568e-01;uu[35]=-4.8655461690e-01;
     uu[36]=-2.5980378520e-01;uu[37]=-4.0231761301e-02;uu[38]=-1.4327016639e-01;
     uu[39]=2.1007088329e-01;uu[40]=-3.4330910327e-01;uu[41]=-1.8331058131e-01;
     uu[42]=-2.6660451417e-01;uu[43]=-4.9157793625e-01;uu[44]=-1.0309620813e-01;
     uu[45]=2.4941021919e-01;uu[46]=-4.1499939379e-01;uu[47]=2.6880950326e-01;
     uu[48]=5.3578917135e-02;uu[49]=2.1479723188e-01;
     uu = Vec_addr(thee->VC[1]);
     uu[0]=-4.2840100356e-02;uu[1]=-2.6243491796e-01;uu[2]=-3.0426923622e-01;
     uu[3]=-2.3678608482e-01;uu[4]=-1.0715194439e-01;uu[5]=4.7759973944e-01;
     uu[6]=-2.1951553692e-01;uu[7]=4.5924155099e-02;uu[8]=3.4805722442e-01;
     uu[9]=3.0209765848e-01;uu[10]=5.5060530358e-02;uu[11]=1.7098263397e-01;
     uu[12]=3.2064368229e-01;uu[13]=4.7047237461e-01;uu[14]=-1.3075004458e-02;
     uu[15]=3.1746853555e-01;uu[16]=1.4157116785e-01;uu[17]=-1.9365064049e-01;
     uu[18]=-1.8774532408e-01;uu[19]=-1.4198288661e-01;uu[20]=4.3819943010e-01;
     uu[21]=3.1038373431e-01;uu[22]=-4.0900964226e-01;uu[23]=1.7383411686e-01;
     uu[24]=-5.5580183402e-02;uu[25]=-2.6849527028e-02;uu[26]=2.2500937095e-01;
     uu[27]=-4.3175338903e-01;uu[28]=3.2605283508e-02;uu[29]=1.3686085923e-01;
     uu[30]=-3.3888177445e-01;uu[31]=-6.1411765451e-02;uu[32]=-1.1778923941e-01;
     uu[33]=-1.0861296393e-01;uu[34]=-2.2490017853e-01;uu[35]=-4.5547247961e-01;
     uu[36]=9.3369875157e-03;uu[37]=1.2410706603e-01;uu[38]=3.1689231949e-01;
     uu[39]=3.7051707181e-01;uu[40]=-4.7744487954e-01;uu[41]=2.2717698370e-01;
     uu[42]=3.4800944806e-01;uu[43]=2.2860019102e-01;uu[44]=4.5509863328e-01;
     uu[45]=1.5635111060e-01;uu[46]=2.4230513351e-01;uu[47]=5.4207425844e-02;
     
     uu = Vec_addr(thee->VC[2]);
     uu[0]=3.8402194968e-01;uu[1]=-1.1571508965e-01;uu[2]=-4.4052331946e-01;
     uu[3]=2.1841459108e-01;uu[4]=4.5821429291e-01;uu[5]=-1.1354734532e-01;
     uu[6]=-8.3646893854e-02;uu[7]=-4.0596513103e-01;uu[8]=-7.6307952274e-02;
     uu[9]=3.6915242558e-01;uu[10]=6.8215145876e-02;uu[11]=-2.4721634894e-01;
     uu[12]=-1.4561807343e-01;uu[13]=2.4297796820e-01;uu[14]=1.5083202246e-01;
     uu[15]=4.3979304053e-01;uu[16]=-1.5469843609e-01;uu[17]=9.4324945007e-02;
     uu[18]=1.2986560726e-01;uu[19]=5.9403207512e-02;uu[20]=4.2187397297e-02;
     uu[21]=1.3314323628e-01;uu[22]=3.6308689222e-01;uu[23]=-8.3643064198e-02;
     uu[24]=-1.0374079480e-01;uu[25]=2.8692438967e-01;uu[26]=1.5598213826e-01;
     uu[27]=-4.9996011040e-01;uu[28]=1.5917930412e-01;uu[29]=-5.1252439974e-03;
     uu[30]=7.8941127385e-02;uu[31]=-2.7256419050e-01;uu[32]=-1.7211704272e-01;
     uu[33]=3.9946878769e-01;uu[34]=1.4098173030e-01;uu[35]=-2.4832398811e-01;
     uu[36]=-2.3539694305e-02;uu[37]=3.4238223654e-01;uu[38]=-3.1551100839e-01;
     uu[39]=3.2038062802e-01;uu[40]=-4.7760333285e-02;uu[41]=-2.3724509078e-01;
     uu[42]=-1.1992369303e-01;uu[43]=3.8647996364e-01;uu[44]=8.7701115656e-02;
     uu[45]=4.2179294947e-01;uu[46]=-6.0996619254e-02;uu[47]=-2.9163827710e-03;
     uu[48]=-3.6592288019e-01;uu[49]=-4.3468631166e-01;uu[50]=-1.2485534199e-01;
     uu[51]=-4.3648032755e-02;
     break;
     default:
     VASSERT(0);
   }
}

VPRIVATE void Bchar_example( Bchar *thee )
{
   char *uu;

   VASSERT((thee->numR)[0] == 50);
   VASSERT((thee->numR)[1] == 48);
   VASSERT((thee->numR)[2] == 52);

   uu = (thee->u)[0];
   uu[0]='f';uu[1]='c';uu[2]='f';uu[3]='f';uu[4]='c';uu[5]='c';
   uu[6]='c';uu[7]='c';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='c';
   uu[12]='f';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='c';uu[17]='f';
   uu[18]='c';uu[19]='c';uu[20]='c';uu[21]='f';uu[22]='c';uu[23]='c';
   uu[24]='c';uu[25]='c';uu[26]='f';uu[27]='c';uu[28]='c';uu[29]='f';
   uu[30]='c';uu[31]='f';uu[32]='c';uu[33]='f';uu[34]='c';uu[35]='c';
   uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='c';uu[41]='c';
   uu[42]='c';uu[43]='c';uu[44]='c';uu[45]='f';uu[46]='c';uu[47]='c';
   uu[48]='f';uu[49]='c';
   uu = (thee->u)[1];
   uu[0]='f';uu[1]='c';uu[2]='c';uu[3]='c';uu[4]='f';uu[5]='c';
   uu[6]='f';uu[7]='c';uu[8]='c';uu[9]='c';uu[10]='f';uu[11]='c';
   uu[12]='c';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='c';uu[17]='c';
   uu[18]='f';uu[19]='c';uu[20]='c';uu[21]='f';uu[22]='c';uu[23]='c';
   uu[24]='f';uu[25]='f';uu[26]='c';uu[27]='c';uu[28]='f';uu[29]='f';
   uu[30]='c';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='c';uu[35]='c';
   uu[36]='f';uu[37]='f';uu[38]='c';uu[39]='c';uu[40]='c';uu[41]='c';
   uu[42]='c';uu[43]='c';uu[44]='c';uu[45]='c';uu[46]='c';uu[47]='f';
   
   uu = (thee->u)[2];
   uu[0]='c';uu[1]='f';uu[2]='c';uu[3]='c';uu[4]='c';uu[5]='f';
   uu[6]='c';uu[7]='c';uu[8]='f';uu[9]='c';uu[10]='f';uu[11]='c';
   uu[12]='c';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='f';uu[17]='f';
   uu[18]='c';uu[19]='f';uu[20]='c';uu[21]='f';uu[22]='c';uu[23]='f';
   uu[24]='f';uu[25]='c';uu[26]='c';uu[27]='c';uu[28]='f';uu[29]='c';
   uu[30]='f';uu[31]='c';uu[32]='c';uu[33]='c';uu[34]='f';uu[35]='c';
   uu[36]='f';uu[37]='c';uu[38]='c';uu[39]='f';uu[40]='c';uu[41]='f';
   uu[42]='c';uu[43]='c';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
   uu[48]='c';uu[49]='c';uu[50]='c';uu[51]='f';
}

int main(int argc, char **argv)
{
    Bmat *A = VNULL;
    Bvec *u = VNULL;
    Bvec *ue = VNULL;
    Bvec *u0 = VNULL;
    Bvec *f = VNULL;
    Bvec *w = VNULL;
    Bchar *ptype = VNULL;
    int key, adj, ioflag=1, meth=1, itmax=1, p, numB, numR[MAXV];
    double r_err;
    char PF;

    /* Load a block matrix */
    A = Bmat_example();
    
    numB = A->numB;

    for( p=0; p<numB; p++ ) {
        numR[p] = Mat_numR( A->AD[p][p] );
    }

    /* Construct some block vectors */
    u  = Bvec_ctor( VNULL, "u",  numB, numR );
    u0 = Bvec_ctor( VNULL, "u0", numB, numR );
    f  = Bvec_ctor( VNULL, "f",  numB, numR );
    ue = Bvec_ctor( VNULL, "ue", numB, numR );
    w  = Bvec_ctor( VNULL, "w",  numB, numR );
    ptype = Bchar_ctor( VNULL, "ptype", numB, numR );

    /* Load the initial guess and right hand side */
    Bvec_example( u0, 0 );
    Bvec_example( f, 1 );

    /* Load the list of F and C points */
    Bchar_example( ptype );

    Vnm_print(1,"P = 1; F = 0; %% 1: Pass Test, 0: Fail Test\n");
    Vnm_print(1,"\n");
    Vnm_print(1,"fsmooth_test = [\n");
    Vnm_print(1,"%% -----------------------------------------\n");
    Vnm_print(1,"%% Test  Pass/Fail  Relative Error  Key  Adj\n"),
    Vnm_print(1,"%% -----------------------------------------\n");

    /* Run the forward smoother with A */
    key = 0; adj = 0;
    Bvec_copy( u, u0 );
    Bvec_fsmooth( u, A, f, w, key, ioflag, meth, adj, itmax, ptype);
    Bvec_example( ue, 2 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d\n", 1, PF, r_err, key, adj);

    /* Run the adjoint smoother with A */
    key = 0; adj = 1;
    Bvec_copy( u, u0 );
    Bvec_fsmooth( u, A, f, w, key, ioflag, meth, adj, itmax, ptype);
    Bvec_example( ue, 3 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d\n", 2, PF, r_err, key, adj);

    /* Run the forward smoother with A' */
    key = 1; adj = 0;
    Bvec_copy( u, u0 );
    Bvec_fsmooth( u, A, f, w, key, ioflag, meth, adj, itmax, ptype);
    Bvec_example( ue, 4 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d\n", 3, PF, r_err, key, adj);

    /* Run the adjoint smoother with A' */
    key = 1; adj = 1;
    Bvec_copy( u, u0 );
    Bvec_fsmooth( u, A, f, w, key, ioflag, meth, adj, itmax, ptype);
    Bvec_example( ue, 5 );
    Bvec_axpy( u, ue, -1.);  /* u = u - uexact */
    r_err = Bvec_nrm2(u)/Bvec_nrm2(ue);
    PF = (r_err < 1.0e-10) ? 'P' : 'F'; /* PASS OR FAIL */
    Vnm_print(1," %4d   %6c   %16.6e  %3d  %3d\n", 4, PF, r_err, key, adj);

    Vnm_print(1,"%% -----------------------------------------\n");
    Vnm_print(1,"];\n");

    /* Destroy the vectors and matrix */
    Bvec_dtor( &u0 );
    Bvec_dtor( &ue );
    Bvec_dtor( &u );
    Bvec_dtor( &f );
    Bvec_dtor( &w );
    Bmat_dtor( &A );

    Bchar_dtor( &ptype );

    Vnm_print(1,"\n");
    Vnm_print(1,"mc_leaks = [\n");
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vnm_print(1,"%%  Footprint        Areas       Malloc         Free"
                "    Highwater   Class\n"),
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vmem_print(VNULL);
    Vmem_printTotal();
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vnm_print(1,"];\n");

    /* normal return */
    return 0;
}

/* ************************************************************************* *
 *                   Matlab code for generating new problems                 *
 * ************************************************************************* *

% Size of each block
N  = cell(1,3);
N{1} = 50; N{2} = 48; N{3} = 52;

% Number of blocks
Nb = length(N);

% Total number of rows
numRT = sum(cell2mat(N));
% Generate a global shifted random matrix
A = sprand(numRT,numRT,1/(numRT));
% Symmetrize the structure
A = 0.5*(A + A');
% Randomize the values
randval = inline('rand(size(x)) - 0.5','x');
A = spfun(randval,A);
A = A + spdiags(1.5 + rand(numRT,1), 0, numRT, numRT);

% Generate a random initial condition and rhs
u0 = rand(numRT,1) - 0.5;
f  = rand(numRT,1) - 0.5;

% Generate a random partitioning of fine and coarse nodes
u = rand(numRT,1);
fc = char('c'*(u > 0.4) + 'f'*(u <= 0.4));

% Get indices of fine and coarse nodes
fp = find(fc' == 'f');
cp = find(fc' == 'c');

% Create Nb x Nb cell arrays
UIA = cell(Nb); UJA = cell(Nb); UA  = cell(Nb);
LIA = cell(Nb); LJA = cell(Nb); LA  = cell(Nb);
DA  = cell(Nb);

si = 0;
for ki = 1:1:Nb
  sj = 0;
  for kj = 1:1:(ki-1)
    % Convert lower off-diagonal to CSC
    Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
    [LIA{ki,kj},LJA{ki,kj},LA{ki,kj}] = sp2csc(Asp);
    sj = sj + N{kj};
  end
  kj = ki;
  % Convert diagonal to DRC
  Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
  [UIA{ki,kj},UJA{ki,kj},UA{ki,kj}] = sp2csr(triu(Asp,1 ));
  [LIA{ki,kj},LJA{ki,kj},LA{ki,kj}] = sp2csc(tril(Asp,-1));
  DA{ki,kj} = diag(Asp);
  sj = sj + N{kj};
  for kj = (ki+1):1:Nb
    % Convert upper off-diagonal to CSR
    Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
    [UIA{ki,kj},UJA{ki,kj},UA{ki,kj}] = sp2csr(Asp);
    sj = sj + N{kj};
  end
  si = si + N{ki};
end

% Print the matrix as FETK C-Code
fid = fopen('problem.c','wt');
fprintf(fid,'VPRIVATE Bmat* Bmat_example( )\n{\n   int numB,numR[MAXV];\n');
fprintf(fid,'   Mat *Ab;\n   double *AD;\n   int p, q, *IJA;\n');
fprintf(fid,'   MATmirror mirror[MAXV][MAXV];\n   Bmat *thee = VNULL;\n\n');
fprintf(fid,'   numB = %d;\n',Nb);
fprintf(fid,'   VASSERT( numB <= MAXV );\n');
for ki = 1:1:Nb
  fprintf(fid,'   numR[%d] = %d;\n',ki-1,N{ki});
end
fprintf(fid,'   for( p=0; p<numB; p++ ) {\n');
fprintf(fid,'      for( q=0; q<numB; q++ ) {\n');
fprintf(fid,'         mirror[p][q] = ISNOT_MIRROR;\n      }\n   }\n\n');
fprintf(fid,'   thee = Bmat_ctor( VNULL, "A", numB, numR, numR, mirror );\n');
fprintf(fid,'\n');
for ki = 1:1:Nb
   fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,ki-1);
   numIJ = length([UIA{ki,ki}; UJA{ki,ki}]);
   fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
   k = 0;
   fprintf(fid,'\n   ');
   for i=1:length(UIA{ki,ki})
     fprintf(fid,'IJA[%d]=%d;',k,UIA{ki,ki}(i)-1);
     k=k+1;
     if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(UJA{ki,ki})
     fprintf(fid,'IJA[%d]=%d;',k,UJA{ki,ki}(i)-1);
     k=k+1;
     if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n');
   fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'DRC_FORMAT', 'ISNOT_SYM', length(UJA{ki,ki}));
   fprintf(fid,'   AD = Ab->A;\n');
   k=0;
   fprintf(fid,'\n   ');
   for i=1:length(DA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,DA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(UA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,UA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(LA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,LA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n');
   for kj = 1:1:(ki-1)
      fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,kj-1);
      numIJ = length([LIA{ki,kj}; LJA{ki,kj}]);
      fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(LIA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,LIA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n   ');
      for i=1:length(LJA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,LJA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
      fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'COL_FORMAT', 'ISNOT_SYM', length(LJA{ki,kj}));
      fprintf(fid,'   AD = Ab->A;\n');
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(LA{ki,kj})
        fprintf(fid,'AD[%d]=%16.10e;',k,LA{ki,kj}(i));
        k=k+1;
        if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
   end
   for kj = (ki+1):1:Nb
      fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,kj-1);
      numIJ = length([UIA{ki,kj}; UJA{ki,kj}]);
      fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(UIA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,UIA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n   ');
      for i=1:length(UJA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,UJA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
      fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'ROW_FORMAT', 'ISNOT_SYM', length(UJA{ki,kj}));
      fprintf(fid,'   AD = Ab->A;\n');
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(UA{ki,kj})
        fprintf(fid,'AD[%d]=%16.10e;',k,UA{ki,kj}(i));
        k=k+1;
        if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
   end
end
fprintf(fid,'   return thee;\n}\n\n');
fprintf(fid,'VPRIVATE void Bvec_example( Bvec *thee, int key )\n{\n');
fprintf(fid,'   int numB = %d, numR[MAXV];\n',Nb);
fprintf(fid,'   double *uu;\n\n');
fprintf(fid,'   VASSERT( numB <= MAXV );\n');
fprintf(fid,'   VASSERT( Bvec_numB(thee) == %d );\n\n',Nb);
for ki = 1:1:Nb
  fprintf(fid,'   numR[%d] = %d;\n',ki-1,N{ki});
  fprintf(fid,'   VASSERT(Bvec_numRB(thee,%d) == %d);\n',ki-1,N{ki});
end
fprintf(fid,'   switch(key) {\n');
fprintf(fid,'     case 0:\n');
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,u0(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 1:\n');
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,f(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 2:\n');
Uff = triu(A(fp,fp),1); Lff = tril(A(fp,fp),-1);
Dff = diag(diag(A(fp,fp))); Afc = A(fp,cp);
uex = u0;
uex(fp) = (Dff + Lff) \ (f(fp) - Uff*u0(fp) - Afc*u0(cp));
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 3:\n');
uex = u0;
uex(fp) = (Dff + Uff) \ (f(fp) - Lff*u0(fp) - Afc*u0(cp));
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 4:\n');
A = A';
Uff = triu(A(fp,fp),1); Lff = tril(A(fp,fp),-1);
Dff = diag(diag(A(fp,fp))); Afc = A(fp,cp);
A = A';
uex = u0;
uex(fp) = (Dff + Lff) \ (f(fp) - Uff*u0(fp) - Afc*u0(cp));
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     case 5:\n');
uex = u0;
uex(fp) = (Dff + Uff) \ (f(fp) - Lff*u0(fp) - Afc*u0(cp));
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n     uu = Vec_addr(thee->VC[%d]);\n     ', ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%16.10e;',i-1,uex(si+i));
    if( 0 == mod(i,3) ) fprintf(fid,'\n     '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'     break;\n     default:\n     VASSERT(0);\n   }\n');
fprintf(fid,'}\n\n');
fprintf(fid,'VPRIVATE void Bchar_example( Bchar *thee )\n{\n');
fprintf(fid,'   char *uu;\n\n');
for ki = 1:1:Nb
fprintf(fid,'   VASSERT((thee->numR)[%d] == %d);\n',ki-1,N{ki});
end
si = 0;
for ki = 1:1:Nb
  fprintf(fid,'\n   uu = (thee->u)[%d];\n   ',ki-1);
  for i=1:1:N{ki}
    fprintf(fid,'uu[%d]=%c%c%c;',i-1,39,fc(si+i),39);
    if( 0 == mod(i,6) ) fprintf(fid,'\n   '); end;
  end
  si = si + N{ki};
end
fprintf(fid,'\n}\n');
fclose(fid);

 * ************************************************************************* *
 *                        Sparse Conversion Functions                        *
 * ************************************************************************* *

function [IA, JA, A] = sp2csc(B)
%
% [IA, JA, A] = sp2csc(B)
%
[m,n] = size(B);
nz = nnz(B);

% Allocate space
IA = zeros(n+1,1);
JA = zeros(nz,1);
A = zeros(nz,1);

IA(1) = 1;
for i = 1:n
  IA(i+1) = IA(i) + nnz(B(:,i));
  jset = find(B(:,i))';
  JA((IA(i)):(IA(i+1)-1)) = jset;
  A((IA(i)):(IA(i+1)-1)) = B(jset,i);
end

function [IA, JA, A] = sp2csr(B)
%
% [IA, JA, A] = sp2csr(B)
%
[m,n] = size(B);
nz = nnz(B);

% Allocate space
IA = zeros(m+1,1);
JA = zeros(nz,1);
A = zeros(nz,1);

IA(1) = 1;
for i = 1:m
  IA(i+1) = IA(i) + nnz(B(i,:));
  jset = find(B(i,:));
  JA((IA(i)):(IA(i+1)-1)) = jset;
  A((IA(i)):(IA(i+1)-1)) = B(i,jset);
end

 * ************************************************************************* *
 *                               End Matlab Code                             *
 * ************************************************************************* */
