/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:11:20 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.LocationParseNode;
import uk.ac.sanger.artemis.io.LocationParseNodeVector;
import uk.ac.sanger.artemis.io.Range;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class LocationParseNode_ESTest extends LocationParseNode_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Range range0 = new Range(0, 0);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(0, range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.reverseComplement((-2646), 0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      // Undeclared exception!
      try { 
        locationParseNode1.setRange(range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getRange() - node is not a RANGE 1
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Range range0 = new Range(1184, 1184);
      assertNotNull(range0);
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      // Undeclared exception!
      try { 
        locationParseNode1.getOrderChildren();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getOrderChildren() - node is not an ORDER
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Range range0 = new Range(1, 1);
      assertNotNull(range0);
      assertEquals(1, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(1, range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(1, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(1, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      // Undeclared exception!
      try { 
        locationParseNode1.getChildren();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getChildren() - node is not a JOIN or ORDER
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      LocationParseNodeVector locationParseNodeVector0 = new LocationParseNodeVector();
      assertNotNull(locationParseNodeVector0);
      assertTrue(locationParseNodeVector0.isEmpty());
      assertEquals("[]", locationParseNodeVector0.toString());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertEquals(0, locationParseNodeVector0.size());
      
      Range range0 = new Range(2, 2);
      assertNotNull(range0);
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      locationParseNodeVector0.addElementAtEnd(locationParseNode0);
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(1, locationParseNodeVector0.size());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      locationParseNodeVector0.addElementAtEnd(locationParseNode0);
      assertEquals(2, locationParseNodeVector0.size());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode("", locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      boolean boolean0 = locationParseNodeVector0.add(locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertTrue(boolean0);
      assertEquals(3, locationParseNodeVector0.size());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = new LocationParseNode(2, locationParseNodeVector0);
      assertNotNull(locationParseNode2);
      assertEquals(3, locationParseNodeVector0.size());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(2, locationParseNode2.getType());
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode3 = locationParseNode2.getCanonical();
      assertNotSame(locationParseNode2, locationParseNode3);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode3, locationParseNode0);
      assertNotSame(locationParseNode3, locationParseNode1);
      assertNotSame(locationParseNode3, locationParseNode2);
      assertNotNull(locationParseNode3);
      assertEquals(3, locationParseNodeVector0.size());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(2, locationParseNode2.getType());
      assertEquals(2, locationParseNode3.getType());
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode3.equals((Object)locationParseNode0));
      assertFalse(locationParseNode3.equals((Object)locationParseNode1));
      assertFalse(locationParseNode3.equals((Object)locationParseNode2));
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Range range0 = new Range(306, 306);
      assertNotNull(range0);
      assertEquals(306, range0.getStart());
      assertEquals(306, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(306, range0.getStart());
      assertEquals(306, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(306, range0.getStart());
      assertEquals(306, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.reverseComplement((-2239), 2);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotNull(locationParseNode2);
      assertEquals(306, range0.getStart());
      assertEquals(306, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(4, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Range range0 = new Range(5, 985);
      assertNotNull(range0);
      assertEquals(985, range0.getEnd());
      assertEquals(981, range0.getCount());
      assertEquals(5, range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(985, range0.getEnd());
      assertEquals(981, range0.getCount());
      assertEquals(5, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.reverseComplement(5, 0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(985, range0.getEnd());
      assertEquals(981, range0.getCount());
      assertEquals(5, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Range range0 = new Range((-1810));
      assertNotNull(range0);
      assertEquals((-1810), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getEnd());
      
      Range range1 = range0.copy();
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertNotNull(range1);
      assertEquals((-1810), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getEnd());
      assertEquals((-1810), range1.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals((-1810), range1.getStart());
      assertFalse(range1.equals((Object)range0));
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals((-1810), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertFalse(range0.equals((Object)range1));
      
      LocationParseNode locationParseNode1 = locationParseNode0.addRangeNode(locationParseNode0);
      assertNotSame(range0, range1);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals((-1810), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertFalse(range0.equals((Object)range1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      boolean boolean0 = locationParseNode1.changeRange(range1, range0);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertTrue(boolean0);
      assertEquals((-1810), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getEnd());
      assertEquals((-1810), range1.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals((-1810), range1.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertFalse(range0.equals((Object)range1));
      assertFalse(range1.equals((Object)range0));
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Range range0 = new Range((-1842), (-1842));
      assertNotNull(range0);
      assertEquals((-1842), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1842), range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals((-1842), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1842), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode((String) null, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals((-1842), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1842), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      Range range1 = new Range(4);
      assertNotNull(range1);
      assertEquals(4, range1.getStart());
      assertEquals(4, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertFalse(range1.equals((Object)range0));
      
      boolean boolean0 = locationParseNode1.changeRange(range0, range1);
      assertNotSame(range0, range1);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(range1, range0);
      assertTrue(boolean0);
      assertEquals((-1842), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1842), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertEquals(4, range1.getStart());
      assertEquals(4, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertFalse(range0.equals((Object)range1));
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(range1.equals((Object)range0));
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Range range0 = new Range((-1810));
      assertNotNull(range0);
      assertEquals((-1810), range0.getEnd());
      assertEquals((-1810), range0.getStart());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals((-1810), range0.getEnd());
      assertEquals((-1810), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      locationParseNode0.setRange(range0);
      assertEquals((-1810), range0.getEnd());
      assertEquals((-1810), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Range range0 = new Range(2, 2);
      assertNotNull(range0);
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode("", locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      String string0 = locationParseNode1.toString();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(string0);
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Range range0 = new Range(0, 0);
      assertNotNull(range0);
      assertEquals(0, range0.getEnd());
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getEnd());
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      Range range1 = locationParseNode0.getRange();
      assertSame(range0, range1);
      assertSame(range1, range0);
      assertNotNull(range1);
      assertEquals(0, range0.getEnd());
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, range1.getCount());
      assertEquals(0, range1.getStart());
      assertEquals(0, range1.getEnd());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Range range0 = new Range((-477), 0);
      assertNotNull(range0);
      assertEquals(0, range0.getEnd());
      assertEquals(478, range0.getCount());
      assertEquals((-477), range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getEnd());
      assertEquals(478, range0.getCount());
      assertEquals((-477), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      Range range1 = locationParseNode0.getRange();
      assertSame(range0, range1);
      assertSame(range1, range0);
      assertNotNull(range1);
      assertEquals(0, range0.getEnd());
      assertEquals(478, range0.getCount());
      assertEquals((-477), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals((-477), range1.getStart());
      assertEquals(0, range1.getEnd());
      assertEquals(478, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Range range0 = new Range(6, 6);
      assertNotNull(range0);
      assertEquals(6, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(6, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(6, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(6, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      Range range1 = locationParseNode0.getRange();
      assertSame(range0, range1);
      assertSame(range1, range0);
      assertNotNull(range1);
      assertEquals(6, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(6, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, range1.getCount());
      assertEquals(6, range1.getStart());
      assertEquals(6, range1.getEnd());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Range range0 = new Range((-2239), (-2239));
      assertNotNull(range0);
      assertEquals((-2239), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals((-2239), range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals((-2239), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals((-2239), range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      Range range1 = locationParseNode0.getRange();
      assertSame(range0, range1);
      assertSame(range1, range0);
      assertNotNull(range1);
      assertEquals((-2239), range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals((-2239), range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals((-2239), range1.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals((-2239), range1.getStart());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Range range0 = new Range((-1842), (-1842));
      assertNotNull(range0);
      assertEquals((-1842), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1842), range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals((-1842), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1842), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode((String) null, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals((-1842), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1842), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.getEntryRangeChild();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotNull(locationParseNode2);
      assertEquals((-1842), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1842), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertEquals(4, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Range range0 = new Range((-1810));
      assertNotNull(range0);
      assertEquals((-1810), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals((-1810), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.copy();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals((-1810), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(4, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode((Range) null);
      assertNotNull(locationParseNode0);
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.toString();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode((Range) null);
      assertNotNull(locationParseNode0);
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.reverseComplement(992, 992);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode((Range) null);
      assertNotNull(locationParseNode0);
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.getNodeComplement();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode((Range) null);
      assertNotNull(locationParseNode0);
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.changeRange((Range) null, (Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Range range0 = new Range(2, 2);
      assertNotNull(range0);
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode("", locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      // Undeclared exception!
      try { 
        locationParseNode1.getRange();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getRange() - node is not a RANGE 5
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode((Range) null);
      assertNotNull(locationParseNode0);
      assertEquals(4, locationParseNode0.getType());
      
      Range range0 = locationParseNode0.getRange();
      assertNull(range0);
      assertEquals(4, locationParseNode0.getType());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode("m", (LocationParseNode) null);
      assertNotNull(locationParseNode0);
      assertEquals(5, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getEntryRangeChild();
      assertNull(locationParseNode1);
      assertEquals(5, locationParseNode0.getType());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Range range0 = new Range(0);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(0, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.getComplementChild();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotNull(locationParseNode2);
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(4, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Range range0 = new Range(1184, 1184);
      assertNotNull(range0);
      assertEquals(1184, range0.getEnd());
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1184, range0.getEnd());
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1184, range0.getEnd());
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertSame(locationParseNode1, locationParseNode2);
      assertSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotNull(locationParseNode2);
      assertEquals(1184, range0.getEnd());
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertEquals(2, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Range range0 = new Range(2, 2);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      int int0 = locationParseNode0.getType();
      assertEquals(4, int0);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Range range0 = new Range(311, 311);
      assertNotNull(range0);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotNull(locationParseNode2);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(2, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      
      boolean boolean0 = locationParseNode2.isValid();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertTrue(boolean0);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(2, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode0.equals((Object)locationParseNode2));
      assertFalse(locationParseNode1.equals((Object)locationParseNode2));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      LocationParseNodeVector locationParseNodeVector0 = new LocationParseNodeVector();
      assertNotNull(locationParseNodeVector0);
      assertEquals(10, locationParseNodeVector0.capacity());
      assertTrue(locationParseNodeVector0.isEmpty());
      assertEquals("[]", locationParseNodeVector0.toString());
      assertEquals(0, locationParseNodeVector0.size());
      
      Range range0 = new Range(2, 2396);
      assertNotNull(range0);
      assertEquals(2, range0.getStart());
      assertEquals(2396, range0.getEnd());
      assertEquals(2395, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(2, range0.getStart());
      assertEquals(2396, range0.getEnd());
      assertEquals(2395, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      boolean boolean0 = locationParseNodeVector0.add(locationParseNode0);
      assertTrue(boolean0);
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(1, locationParseNodeVector0.size());
      assertEquals(2, range0.getStart());
      assertEquals(2396, range0.getEnd());
      assertEquals(2395, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode(3, locationParseNodeVector0);
      assertNotNull(locationParseNode1);
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(1, locationParseNodeVector0.size());
      assertEquals(3, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      boolean boolean1 = locationParseNode1.isValid();
      assertNotSame(locationParseNode1, locationParseNode0);
      assertTrue(boolean1);
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(1, locationParseNodeVector0.size());
      assertEquals(3, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertTrue(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Range range0 = new Range(311, 311);
      assertNotNull(range0);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.getCanonical();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotNull(locationParseNode2);
      assertEquals(311, range0.getEnd());
      assertEquals(311, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(1, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Range range0 = new Range(0, 0);
      assertNotNull(range0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode("#:Ym{ad`US&4ktf'ep", locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      // Undeclared exception!
      try { 
        locationParseNode1.setRange(range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getRange() - node is not a RANGE 5
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Range range0 = new Range(1184, 1184);
      assertNotNull(range0);
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode(1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1184, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      // Undeclared exception!
      try { 
        locationParseNode0.addRangeNode(locationParseNode1);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getRange() - node is not a RANGE 1
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode((Range) null);
      assertNotNull(locationParseNode0);
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.getEntryRangeChild();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getEntryRangeChild() - node is not an ENTRY_RANGE
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Range range0 = new Range((-2239), (-2239));
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals((-2239), range0.getStart());
      assertEquals((-2239), range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getCount());
      assertEquals((-2239), range0.getStart());
      assertEquals((-2239), range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.getOrderChildren();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getOrderChildren() - node is not an ORDER
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode("internal error - unexpected exception: ", (LocationParseNode) null);
      assertNotNull(locationParseNode0);
      assertEquals(5, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.getJoinChildren();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getJoinChildren() - node is not a JOIN
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Range range0 = new Range(306, 306);
      assertNotNull(range0);
      assertEquals(306, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(306, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(306, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(306, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(306, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(306, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNodeVector locationParseNodeVector0 = locationParseNode1.getJoinChildren();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNodeVector0);
      assertEquals(306, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(306, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertEquals(2, locationParseNodeVector0.size());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Range range0 = new Range((-477), 0);
      assertNotNull(range0);
      assertEquals(0, range0.getEnd());
      assertEquals(478, range0.getCount());
      assertEquals((-477), range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getEnd());
      assertEquals(478, range0.getCount());
      assertEquals((-477), range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.getChildren();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getChildren() - node is not a JOIN or ORDER
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode("m", (LocationParseNode) null);
      assertNotNull(locationParseNode0);
      assertEquals(5, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.getComplementChild();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getComplementChild() - node is not a COMPLEMENT
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      LocationParseNodeVector locationParseNodeVector0 = new LocationParseNodeVector();
      assertNotNull(locationParseNodeVector0);
      assertTrue(locationParseNodeVector0.isEmpty());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertEquals(0, locationParseNodeVector0.size());
      assertEquals("[]", locationParseNodeVector0.toString());
      
      Range range0 = new Range(2, 2);
      assertNotNull(range0);
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      locationParseNodeVector0.addElementAtEnd(locationParseNode0);
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertEquals(1, locationParseNodeVector0.size());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode("", locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      boolean boolean0 = locationParseNodeVector0.add(locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertTrue(boolean0);
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertEquals(2, locationParseNodeVector0.size());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = new LocationParseNode(2, locationParseNodeVector0);
      assertNotNull(locationParseNode2);
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertEquals(2, locationParseNodeVector0.size());
      assertEquals(2, locationParseNode2.getType());
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      
      LocationParseNode locationParseNode3 = locationParseNode2.getCanonical();
      assertNotSame(locationParseNode2, locationParseNode3);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode3, locationParseNode1);
      assertNotSame(locationParseNode3, locationParseNode2);
      assertNotSame(locationParseNode3, locationParseNode0);
      assertNotNull(locationParseNode3);
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertEquals(2, locationParseNodeVector0.size());
      assertEquals(2, locationParseNode2.getType());
      assertEquals(2, locationParseNode3.getType());
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode3.equals((Object)locationParseNode1));
      assertFalse(locationParseNode3.equals((Object)locationParseNode2));
      assertFalse(locationParseNode3.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Range range0 = new Range((-1810));
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getStart());
      assertEquals((-1810), range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getStart());
      assertEquals((-1810), range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getCanonical();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1, range0.getCount());
      assertEquals((-1810), range0.getStart());
      assertEquals((-1810), range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(4, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      LocationParseNodeVector locationParseNodeVector0 = new LocationParseNodeVector();
      assertNotNull(locationParseNodeVector0);
      assertEquals(0, locationParseNodeVector0.size());
      assertEquals(10, locationParseNodeVector0.capacity());
      assertTrue(locationParseNodeVector0.isEmpty());
      assertEquals("[]", locationParseNodeVector0.toString());
      
      Range range0 = new Range(2, 2);
      assertNotNull(range0);
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      locationParseNodeVector0.addElementAtEnd(locationParseNode0);
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(1, locationParseNodeVector0.size());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode(2, locationParseNodeVector0);
      assertNotNull(locationParseNode1);
      assertEquals(10, locationParseNodeVector0.capacity());
      assertFalse(locationParseNodeVector0.isEmpty());
      assertEquals(1, locationParseNodeVector0.size());
      assertEquals(2, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      // Undeclared exception!
      try { 
        locationParseNode1.getCanonical();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - a JOIN should have > 1 child
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode((Range) null);
      assertNotNull(locationParseNode0);
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.getCanonical();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Range range0 = new Range(0);
      assertNotNull(range0);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode("0", locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotNull(locationParseNode2);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertEquals(1, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      
      LocationParseNode locationParseNode3 = locationParseNode2.reverseComplement(0, 2860);
      assertNotSame(locationParseNode0, locationParseNode3);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode3);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode3);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode3, locationParseNode0);
      assertNotSame(locationParseNode3, locationParseNode2);
      assertNotSame(locationParseNode3, locationParseNode1);
      assertNotNull(locationParseNode3);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertEquals(1, locationParseNode2.getType());
      assertEquals(5, locationParseNode3.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode0.equals((Object)locationParseNode2));
      assertFalse(locationParseNode1.equals((Object)locationParseNode2));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode3.equals((Object)locationParseNode0));
      assertFalse(locationParseNode3.equals((Object)locationParseNode2));
      assertFalse(locationParseNode3.equals((Object)locationParseNode1));
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      Range range0 = new Range(0, 0);
      assertNotNull(range0);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode("", locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.reverseComplement(2, 0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertSame(locationParseNode1, locationParseNode2);
      assertSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotNull(locationParseNode2);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertEquals(5, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      Range range0 = new Range((-1810));
      assertNotNull(range0);
      assertEquals((-1810), range0.getStart());
      assertEquals((-1810), range0.getEnd());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals((-1810), range0.getStart());
      assertEquals((-1810), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals((-1810), range0.getStart());
      assertEquals((-1810), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.reverseComplement(3, 1);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertSame(locationParseNode2, locationParseNode1);
      assertNotNull(locationParseNode2);
      assertEquals((-1810), range0.getStart());
      assertEquals((-1810), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertEquals(2, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      Range range0 = new Range(0);
      assertNotNull(range0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.reverseComplement(0, 2860);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotNull(locationParseNode2);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(4, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      Range range0 = new Range(0, 0);
      assertNotNull(range0);
      assertEquals(0, range0.getStart());
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getStart());
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = new LocationParseNode("#:Ym{ad`US&4ktf'ep", locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(0, range0.getStart());
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.removeRange(range0);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertSame(locationParseNode2, locationParseNode1);
      assertNotNull(locationParseNode2);
      assertEquals(0, range0.getStart());
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
      assertEquals(5, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      Range range0 = new Range(2, 2);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      // Undeclared exception!
      try { 
        locationParseNode0.removeRange(range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - inconsistent location
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      Range range0 = new Range(0);
      assertNotNull(range0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.reverseComplement(0, 767);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      // Undeclared exception!
      try { 
        locationParseNode1.removeRange(range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - inconsistent location
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      Range range0 = new Range(311, 311);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(311, range0.getStart());
      assertEquals(311, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getCount());
      assertEquals(311, range0.getStart());
      assertEquals(311, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1, range0.getCount());
      assertEquals(311, range0.getStart());
      assertEquals(311, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotNull(locationParseNode2);
      assertEquals(1, range0.getCount());
      assertEquals(311, range0.getStart());
      assertEquals(311, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(2, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      
      LocationParseNode locationParseNode3 = locationParseNode2.copyClean();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode0, locationParseNode3);
      assertNotSame(locationParseNode1, locationParseNode3);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode2, locationParseNode3);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode3, locationParseNode0);
      assertNotSame(locationParseNode3, locationParseNode2);
      assertNotSame(locationParseNode3, locationParseNode1);
      assertNotNull(locationParseNode3);
      assertEquals(1, range0.getCount());
      assertEquals(311, range0.getStart());
      assertEquals(311, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(2, locationParseNode2.getType());
      assertEquals(2, locationParseNode3.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode0.equals((Object)locationParseNode2));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode1.equals((Object)locationParseNode2));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode3.equals((Object)locationParseNode0));
      assertFalse(locationParseNode3.equals((Object)locationParseNode2));
      assertFalse(locationParseNode3.equals((Object)locationParseNode1));
      
      LocationParseNode locationParseNode4 = locationParseNode3.removeRange(range0);
      assertNotSame(locationParseNode0, locationParseNode4);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode0, locationParseNode3);
      assertNotSame(locationParseNode1, locationParseNode3);
      assertNotSame(locationParseNode1, locationParseNode4);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode2, locationParseNode3);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode4);
      assertNotSame(locationParseNode3, locationParseNode0);
      assertNotSame(locationParseNode3, locationParseNode2);
      assertNotSame(locationParseNode3, locationParseNode4);
      assertNotSame(locationParseNode3, locationParseNode1);
      assertNotSame(locationParseNode4, locationParseNode1);
      assertNotSame(locationParseNode4, locationParseNode2);
      assertNotSame(locationParseNode4, locationParseNode3);
      assertNotSame(locationParseNode4, locationParseNode0);
      assertNotNull(locationParseNode4);
      assertEquals(1, range0.getCount());
      assertEquals(311, range0.getStart());
      assertEquals(311, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(2, locationParseNode2.getType());
      assertEquals(2, locationParseNode3.getType());
      assertEquals(1, locationParseNode4.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode0.equals((Object)locationParseNode2));
      assertFalse(locationParseNode0.equals((Object)locationParseNode3));
      assertFalse(locationParseNode1.equals((Object)locationParseNode3));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode1.equals((Object)locationParseNode2));
      assertFalse(locationParseNode2.equals((Object)locationParseNode3));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode3.equals((Object)locationParseNode0));
      assertFalse(locationParseNode3.equals((Object)locationParseNode2));
      assertFalse(locationParseNode3.equals((Object)locationParseNode1));
      assertFalse(locationParseNode4.equals((Object)locationParseNode1));
      assertFalse(locationParseNode4.equals((Object)locationParseNode2));
      assertFalse(locationParseNode4.equals((Object)locationParseNode3));
      assertFalse(locationParseNode4.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      Range range0 = new Range(1184, 1184);
      assertNotNull(range0);
      assertEquals(1184, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getStart());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1184, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(1184, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.removeRange(range0);
      assertSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotNull(locationParseNode2);
      assertEquals(1184, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(1184, range0.getStart());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(2, locationParseNode1.getType());
      assertEquals(4, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      
      // Undeclared exception!
      try { 
        locationParseNode1.removeRange(range0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0 >= 0
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode("p&Ruoq%u;[=@ZLU[q", (LocationParseNode) null);
      assertNotNull(locationParseNode0);
      assertEquals(5, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.addRangeNode((LocationParseNode) null);
      assertSame(locationParseNode0, locationParseNode1);
      assertSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(5, locationParseNode0.getType());
      assertEquals(5, locationParseNode1.getType());
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      Range range0 = new Range(0);
      assertNotNull(range0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.reverseComplement(0, 767);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotNull(locationParseNode1);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode2 = locationParseNode1.getNodeComplement();
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotNull(locationParseNode2);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(4, locationParseNode2.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      
      LocationParseNode locationParseNode3 = locationParseNode2.addRangeNode(locationParseNode0);
      assertNotSame(locationParseNode0, locationParseNode1);
      assertNotSame(locationParseNode0, locationParseNode2);
      assertNotSame(locationParseNode0, locationParseNode3);
      assertNotSame(locationParseNode1, locationParseNode3);
      assertNotSame(locationParseNode1, locationParseNode0);
      assertNotSame(locationParseNode1, locationParseNode2);
      assertNotSame(locationParseNode2, locationParseNode3);
      assertNotSame(locationParseNode2, locationParseNode1);
      assertNotSame(locationParseNode2, locationParseNode0);
      assertNotSame(locationParseNode3, locationParseNode1);
      assertNotSame(locationParseNode3, locationParseNode2);
      assertNotSame(locationParseNode3, locationParseNode0);
      assertNotNull(locationParseNode3);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(1, locationParseNode1.getType());
      assertEquals(4, locationParseNode2.getType());
      assertEquals(2, locationParseNode3.getType());
      assertFalse(locationParseNode0.equals((Object)locationParseNode1));
      assertFalse(locationParseNode0.equals((Object)locationParseNode2));
      assertFalse(locationParseNode1.equals((Object)locationParseNode0));
      assertFalse(locationParseNode1.equals((Object)locationParseNode2));
      assertFalse(locationParseNode2.equals((Object)locationParseNode1));
      assertFalse(locationParseNode2.equals((Object)locationParseNode0));
      assertFalse(locationParseNode3.equals((Object)locationParseNode1));
      assertFalse(locationParseNode3.equals((Object)locationParseNode2));
      assertFalse(locationParseNode3.equals((Object)locationParseNode0));
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      Range range0 = new Range(5);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(5, range0.getStart());
      assertEquals(5, range0.getEnd());
      
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertNotNull(locationParseNode0);
      assertEquals(1, range0.getCount());
      assertEquals(5, range0.getStart());
      assertEquals(5, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      
      Range range1 = new Range(9);
      assertNotNull(range1);
      assertEquals(9, range1.getStart());
      assertEquals(9, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertFalse(range1.equals((Object)range0));
      
      boolean boolean0 = locationParseNode0.changeRange(range1, range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertFalse(boolean0);
      assertEquals(1, range0.getCount());
      assertEquals(5, range0.getStart());
      assertEquals(5, range0.getEnd());
      assertEquals(4, locationParseNode0.getType());
      assertEquals(9, range1.getStart());
      assertEquals(9, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertFalse(range0.equals((Object)range1));
      assertFalse(range1.equals((Object)range0));
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      Range range0 = new Range(0, 0);
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      boolean boolean0 = locationParseNode1.changeRange(range0, range0);
      assertEquals(1, locationParseNode1.getType());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode("internal error - unexpected exception: ", (LocationParseNode) null);
      // Undeclared exception!
      try { 
        locationParseNode0.toString();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // LocationParseNode.toStringChild() was called on the wrong type of Object
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      Range range0 = new Range(1184, 1184);
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      LocationParseNode locationParseNode1 = locationParseNode0.addRangeNode(locationParseNode0);
      locationParseNode1.toString();
      assertEquals(2, locationParseNode1.getType());
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      Range range0 = new Range(99);
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      assertEquals(4, locationParseNode0.getType());
      
      LocationParseNode locationParseNode1 = locationParseNode0.getNodeComplement();
      locationParseNode1.toString();
      assertEquals(1, locationParseNode1.getType());
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      Range range0 = new Range(0);
      LocationParseNode locationParseNode0 = new LocationParseNode(range0);
      LocationParseNode locationParseNode1 = null;
      try {
        locationParseNode1 = new LocationParseNode(3, locationParseNode0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // LocationParseNode constructor was called with the wrong type
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode(1, (LocationParseNode) null);
      // Undeclared exception!
      try { 
        locationParseNode0.getJoinChildren();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // in LocationParseNode.getJoinChildren() - node is not a JOIN
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      LocationParseNodeVector locationParseNodeVector0 = new LocationParseNodeVector();
      LocationParseNode locationParseNode0 = null;
      try {
        locationParseNode0 = new LocationParseNode(3, locationParseNodeVector0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // A functional must have at least one argument
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      LocationParseNode locationParseNode0 = null;
      try {
        locationParseNode0 = new LocationParseNode(3, (LocationParseNodeVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      LocationParseNode locationParseNode0 = null;
      try {
        locationParseNode0 = new LocationParseNode(1997, (LocationParseNodeVector) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // LocationParseNode constructor was called with the wrong type
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode("r<7WQeZf7Mm!|$\"(", (LocationParseNode) null);
      // Undeclared exception!
      try { 
        locationParseNode0.copyClean();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test63()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode((Range) null);
      // Undeclared exception!
      try { 
        locationParseNode0.addRangeNode(locationParseNode0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test64()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode("-", (LocationParseNode) null);
      // Undeclared exception!
      try { 
        locationParseNode0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test65()  throws Throwable  {
      LocationParseNode locationParseNode0 = new LocationParseNode("r<7WQeZf7Mm!|$\"(", (LocationParseNode) null);
      // Undeclared exception!
      try { 
        locationParseNode0.isValid();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }
}
