/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:22:25 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.util.List;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.chado.FeatureLocLazyQualifierValue;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierLazyLoading;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class QualifierLazyLoading_ESTest extends QualifierLazyLoading_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("&L,EF]", (List) null);
      List list0 = qualifierLazyLoading0.getLazyValues();
      assertNull(list0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("", (List) null);
      // Undeclared exception!
      try { 
        qualifierLazyLoading0.removeValue((Object) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.QualifierLazyLoading", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("", (List) null);
      qualifierLazyLoading0.addValues((List) null);
      // Undeclared exception!
      try { 
        qualifierLazyLoading0.getValues();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.QualifierLazyLoading", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue0 = new FeatureLocLazyQualifierValue((org.gmod.schema.sequence.Feature) null, 0);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("q;PO-|Y~", featureLocLazyQualifierValue0);
      String string0 = qualifierLazyLoading0.getName();
      assertEquals("q;PO-|Y~", string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("", (List) null);
      qualifierLazyLoading0.addValue((Object) null);
      qualifierLazyLoading0.removeValue((Object) null);
      assertEquals("", qualifierLazyLoading0.getName());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue0 = new FeatureLocLazyQualifierValue((org.gmod.schema.sequence.Feature) null, 0);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("q;PO-|Y~", featureLocLazyQualifierValue0);
      qualifierLazyLoading0.addValue((Object) "q;PO-|Y~");
      assertFalse(qualifierLazyLoading0.isAllLazyValuesLoaded());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("yUU_p~vCDX6", (List) null);
      qualifierLazyLoading0.addValues((List) null);
      qualifierLazyLoading0.addValues((List) null);
      assertEquals("yUU_p~vCDX6", qualifierLazyLoading0.getName());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue0 = new FeatureLocLazyQualifierValue((org.gmod.schema.sequence.Feature) null, 0);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("q;PO-|Y~", featureLocLazyQualifierValue0);
      StringVector stringVector0 = qualifierLazyLoading0.getValues();
      assertNotNull(stringVector0);
      assertEquals("[LAZY LOADING...;]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      QualifierLazyLoading qualifierLazyLoading0 = null;
      try {
        qualifierLazyLoading0 = new QualifierLazyLoading("{MHIMW;VH", keyVector0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - zero length values vector
         //
         verifyException("uk.ac.sanger.artemis.io.QualifierLazyLoading", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue0 = new FeatureLocLazyQualifierValue((org.gmod.schema.sequence.Feature) null, 0);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("q;PO-|Y~", featureLocLazyQualifierValue0);
      List list0 = qualifierLazyLoading0.getLazyValues();
      assertEquals(1, list0.size());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("", (List) null);
      qualifierLazyLoading0.setForceLoad(true);
      assertEquals("", qualifierLazyLoading0.getName());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue0 = new FeatureLocLazyQualifierValue((org.gmod.schema.sequence.Feature) null, 0);
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("q;PO-|Y~", featureLocLazyQualifierValue0);
      FeatureLocLazyQualifierValue featureLocLazyQualifierValue1 = (FeatureLocLazyQualifierValue)qualifierLazyLoading0.getValue(0);
      assertFalse(featureLocLazyQualifierValue1.isForceLoad());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      QualifierLazyLoading qualifierLazyLoading0 = new QualifierLazyLoading("", (List) null);
      Qualifier qualifier0 = qualifierLazyLoading0.copy();
      assertEquals("", qualifier0.getName());
  }
}
