//
// BAGEL - Parallel electron correlation program.
// Filename: _spin2root_12.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root12(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[12] = {1.134467195048325e+00,3.819881460919284e-01,2.276748747594562e+00,3.826813816328572e+00,5.810974110828223e+00,
    8.266798830552723e+00,1.124800012744174e+01,1.483321205593479e+01,1.914317296231067e+01,2.437894713947816e+01,3.092619411073947e+01,3.977268275765083e+01
    };
  constexpr double aw[12] = {1.836038352743444e-01,4.527360724221062e-02,2.366446214229820e-01,1.436301581705064e-01,4.640569315452939e-02,
    8.267585826302408e-03,8.032259452260129e-04,4.049634194549501e-05,9.616636315697198e-07,9.024198635155481e-09,2.368432887140837e-11,7.226294627350485e-15
    };
  constexpr double x[4608] = {  5.497866052849069e-02, -9.911831126087820e-04,  1.301914851465668e-05, -1.458573622904236e-07,  1.444391748926721e-09,
 -1.257555278767841e-11,  9.159660297452304e-14, -4.604214078819472e-16, -4.779440529887325e-19,  5.322650698979097e-20, -9.125944666996568e-22,  1.116845267534645e-23,
  1.597748803264850e-01, -2.730520961660954e-03,  3.199130358894769e-05, -2.873492979353482e-07,  1.795329157415374e-09, -2.385173603708768e-12, -1.318581141507526e-13,
  2.315068944145879e-15, -2.310599425188703e-17,  1.194872916032740e-19,  6.811073434310798e-22, -2.549741388385595e-23,  3.102572445272121e-01, -4.882102626266825e-03,
  4.719194271341520e-05, -2.589442601299621e-07, -5.826552523171782e-10,  3.114268077149895e-11, -3.399609408607761e-13,  1.010867720150032e-15,  2.652938149900746e-17,
 -4.884424908134152e-19,  3.394245014111479e-21,  1.660071222277595e-23,  4.986979664551004e-01, -6.996484764299954e-03,  4.952203506816590e-05, -8.963251947264428e-09,
 -3.993834458148257e-09,  3.757065731398649e-11,  8.541670012285588e-14, -5.353708657612207e-15,  4.271072937971469e-17,  2.785860271462570e-19, -8.796324665775470e-21,
  5.277413267739697e-23,  7.152307607943402e-01, -8.621709481106511e-03,  3.512841302184219e-05,  3.359494004639037e-07, -4.732707013038164e-09, -9.471564456202774e-12,
  6.047421936576034e-13, -2.273192590535902e-15, -6.778404219756869e-17,  7.257182477350814e-19,  5.413279460275959e-21, -1.417053055641220e-22,  9.482716232525626e-01,
 -9.398429125881499e-03,  7.570098233389797e-06,  5.500576813807407e-07, -1.277489479038336e-09, -5.709413395307564e-11,  2.221754719025575e-13,  7.133492878129970e-15,
 -3.994947627997598e-17, -9.721648485564281e-19,  7.256778460609608e-21,  1.391335166038725e-22,  1.185047392975662e+00, -9.141792256964196e-03, -2.335950353896078e-05,
  4.776533394495231e-07,  3.492664992030697e-09, -3.995707906739033e-11, -5.511698355874868e-13,  3.347345561104536e-15,  8.740690435792188e-17, -1.766504449586955e-19,
 -1.368445877968486e-20, -2.188901463493286e-23,  1.412239351150052e+00, -7.891404601552250e-03, -4.591311743493583e-05,  1.618538933674048e-07,  5.092121181864114e-09,
  2.053961228348675e-11, -4.421799638255497e-13, -6.079464361963073e-15,  1.079216285024916e-17,  9.452412022808621e-19,  6.242517188817628e-21, -8.970155572014306e-23,
  1.616728267161043e+00, -5.914222153450558e-03, -5.197220714922345e-05, -1.796628296538038e-07,  2.386833886063041e-09,  4.442833397049961e-11,  2.446187386812074e-13,
 -2.478275457606474e-15, -6.147718407468147e-17, -4.257957698941309e-19,  3.207803543650178e-21,  1.014829537333739e-22,  1.786407570454530e+00, -3.653828334941704e-03,
 -4.119966885223694e-05, -3.258723323884148e-07, -1.232150175868843e-09,  1.262066002263041e-11,  3.119478601075265e-13,  3.292252344832062e-15,  1.377345027889107e-17,
 -1.911523557364489e-19, -4.806022646497787e-21, -5.216507169245718e-23,  1.911009600565349e+00, -1.632459622578296e-03, -2.141294321833847e-05, -2.321555423191671e-07,
 -2.110562759827875e-09, -1.501612077351268e-11, -5.757758938363984e-14,  4.981196670518105e-16,  1.475011622929607e-17,  2.085832926925073e-19,  2.101508178879399e-21,
  1.417298974223929e-23,  1.982886544369017e+00, -3.261991207206323e-04, -4.627007669877825e-06, -5.762841651658997e-08, -6.629025488527448e-10, -7.177986843705719e-12,
 -7.374753974791772e-14, -7.189246999267846e-16, -6.613746282038527e-18, -5.656101006786839e-20, -4.353696105749740e-22, -2.765685624523860e-24,  5.121167969069916e-02,
 -8.936565639755060e-04,  1.139959680777958e-05, -1.246441347089768e-07,  1.213817378149135e-09, -1.053212333350681e-11,  7.873365533965001e-14, -4.512277627304740e-16,
  8.865617830208500e-19,  2.514905393144071e-20, -5.226037459979855e-22,  6.858410414580621e-24,  1.493435021363008e-01, -2.487899608789540e-03,  2.871338914463122e-05,
 -2.591570135504212e-07,  1.720815900419614e-09, -4.851343051373924e-12, -7.671487115642974e-14,  1.647838642550319e-15, -1.854343651499328e-17,  1.287029736389738e-19,
 -1.228798264218833e-22, -1.209682072894067e-23,  2.914640604498250e-01, -4.517110380455699e-03,  4.404782487619998e-05, -2.637160736199480e-07, -3.866928367546704e-11,
  2.340391464736387e-11, -3.022224775272856e-13,  1.605567231874177e-15,  1.148622092439037e-17, -3.464978743935974e-19,  3.526281170349667e-21, -7.734933428975139e-24,
  4.715022410278794e-01, -6.601767453181836e-03,  4.905609301165784e-05, -6.679000765021911e-08, -3.233234464434716e-09,  3.798321504723490e-11, -4.430037594367766e-14,
 -3.889371261480459e-15,  4.703829940218561e-17, -1.939073340899007e-20, -5.980016553987620e-21,  6.980620024739867e-23,  6.813296795949892e-01, -8.325853299656572e-03,
  3.870170010664036e-05,  2.594734926615876e-07, -4.783315607934826e-09,  4.058683961444977e-12,  5.148813499143495e-13, -3.994471807088651e-15, -3.922865707883147e-17,
  8.220008940581927e-19, -4.093872757199055e-22, -1.160976756091164e-22,  9.108402304999343e-01, -9.311897624030533e-03,  1.401158620080790e-05,  5.208374247194851e-07,
 -2.350746902233962e-09, -4.953958788746955e-11,  3.992171702474848e-13,  5.361873029196927e-15, -6.844310170234313e-17, -5.815087733669615e-19,  1.166746789681462e-20,
  5.626519471652769e-23,  1.148144028992208e+00, -9.304856143447376e-03, -1.732096691950150e-05,  5.264615617949340e-07,  2.570429145948148e-09, -5.175405004682020e-11,
 -4.199970987046452e-13,  5.936905557485656e-15,  7.124024790854192e-17, -7.126251869107204e-19, -1.233959110015263e-20,  8.367531886949423e-23,  1.379953415232485e+00,
 -8.249528306168078e-03, -4.347049424427313e-05,  2.459808110602721e-07,  5.383342702724646e-09,  7.956565215927092e-12, -6.021626555251027e-13, -5.150624819739161e-15,
  4.814597493945658e-17,  1.092208998503899e-18,  5.447946153859062e-22, -1.660156803578665e-22,  1.592227176884120e+00, -6.337904938148888e-03, -5.386874354968140e-05,
 -1.340737347488387e-07,  3.327283301923641e-09,  4.923113189496548e-11,  1.456112300837731e-13, -4.656652125037066e-15, -7.332232974330366e-17, -1.977375165558448e-19,
  8.412379760269754e-21,  1.308052441152938e-22,  1.771107851784786e+00, -3.999380717417762e-03, -4.521868836500243e-05, -3.431285066542617e-07, -8.971774416322320e-10,
  2.125561147790876e-11,  4.089757095037723e-13,  3.581173889319165e-15,  2.859392581378820e-18, -4.311858794185280e-19, -7.214045013469708e-21, -5.441815773416567e-23,
  1.904118670033176e+00, -1.815503991960477e-03, -2.441156212561907e-05, -2.683964105033719e-07, -2.423266758650322e-09, -1.616972975671060e-11, -3.577061282610474e-14,
  1.107706690498545e-15,  2.392143385058859e-17,  3.049227531073928e-19,  2.700247524720937e-21,  1.198806075292216e-23,  1.981503066233852e+00, -3.661732267091631e-04,
 -5.387256085182234e-06, -6.948680173448786e-08, -8.259242551373982e-10, -9.215409449013667e-12, -9.717187634307861e-14, -9.667502240699420e-16, -8.993835346514293e-18,
 -7.652492270176280e-20, -5.649274797300452e-22, -3.044461522312993e-24,  4.781041984354151e-02, -8.081279125077678e-04,  1.001376345136995e-05, -1.068097563114260e-07,
  1.021067240877510e-09, -8.790216450936427e-12,  6.660693987625645e-14, -4.118724371217483e-16,  1.479934631088558e-18,  9.371981860722842e-21, -2.863509123710071e-22,
  4.090588460444320e-24,  1.398322723362929e-01, -2.270171921154975e-03,  2.576521745659913e-05, -2.324856748506978e-07,  1.608786198390518e-09, -6.201654637514910e-12,
 -3.819827693668176e-14,  1.126757718721822e-15, -1.410206541940773e-17,  1.157974861134806e-19, -4.653965736689241e-22, -4.241835137164480e-24,  2.740803706271189e-01,
 -4.177363579067260e-03,  4.089373299714100e-05, -2.609683598925003e-07,  3.606862633735326e-10,  1.672100624611217e-11, -2.538069906803057e-13,  1.799860046059699e-15,
  1.433661312547866e-18, -2.159777939443440e-19,  2.929537602490493e-21, -1.746863372265887e-23,  4.458738265368758e-01, -6.213346881529797e-03,  4.796901035615813e-05,
 -1.125362023433917e-07, -2.492152566220057e-09,  3.578112048001367e-11, -1.325290614990070e-13, -2.435513743403657e-15,  4.276685164055146e-17, -1.983263530687616e-19,
 -3.030194076245082e-21,  6.134168667440961e-23,  6.486633901776198e-01, -8.005075699678023e-03,  4.136092802117682e-05,  1.842210054212386e-07, -4.588248105638951e-09,
  1.495884099692293e-11,  3.898340767304815e-13, -4.788625013817325e-15, -1.103266731843150e-17,  7.179496126456586e-19, -4.408346798734218e-21, -6.371615107595707e-23,
  8.738554116101915e-01, -9.175515824623254e-03,  2.000508203906123e-05,  4.758660964471624e-07, -3.234914934861365e-09, -3.842031072276502e-11,  5.162019785654450e-13,
  2.929987509002930e-15, -8.063424353691964e-17, -9.310473911168238e-20,  1.208105260117506e-20, -3.531332202498655e-23,  1.110688359237053e+00, -9.417536493209004e-03,
 -1.079243386009376e-05,  5.588209224652761e-07,  1.449232754786204e-09, -5.960847535718599e-11, -2.263337380753489e-13,  7.719790141679055e-15,  3.784847967941990e-17,
 -1.104575550542393e-18, -6.640327299673204e-21,  1.677558160659751e-22,  1.346280545084019e+00, -8.584014148623351e-03, -3.999934123923345e-05,  3.325566867030749e-07,
  5.387326630927544e-09, -8.015742924535796e-12, -7.189572460487575e-13, -2.991870662798286e-15,  8.595797360267901e-17,  9.534373132816784e-19, -7.730509379239647e-21,
 -1.992833134539935e-22,  1.566004845229170e+00, -6.774309579499507e-03, -5.512523430611169e-05, -7.281950437067017e-08,  4.334902549862858e-09,  5.089205814826483e-11,
 -1.816482289355934e-14, -7.040571034844750e-15, -7.298748311992571e-17,  2.541233531077068e-19,  1.408419563756711e-20,  1.170178293749942e-22,  1.754360454785923e+00,
 -4.377808482234426e-03, -4.940651010300070e-05, -3.535150688907205e-07, -3.658039816626740e-10,  3.226819633636703e-11,  5.077729028827970e-13,  3.364167870963009e-15,
 -1.839633131258068e-17, -7.629613907797186e-19, -9.194555265811694e-21, -2.930340768264854e-23,  1.896444707695716e+00, -2.024363467116091e-03, -2.787574291863427e-05,
 -3.097902412803809e-07, -2.752241146976051e-09, -1.655862373872361e-11,  7.766157931319601e-15,  2.070567193240676e-15,  3.694782863941862e-17,  4.208679718708144e-19,
  3.007672503927109e-21, -4.548056710890597e-25,  1.979946559514431e+00, -4.128461721207856e-04, -6.306905688676241e-06, -8.431259020195289e-08, -1.035925751330408e-09,
 -1.190759215354510e-11, -1.287168704724952e-13, -1.303251200276164e-15, -1.218715311148580e-17, -1.017165934043445e-19, -6.901839328968708e-22, -2.407127725203577e-24,
  4.473038602905221e-02, -7.328797588092783e-04,  8.824538161027208e-06, -9.179608110575411e-08,  8.603431689780244e-10, -7.324446819433835e-12,  5.577434686478654e-14,
 -3.610100950293842e-16,  1.649243652174340e-18,  9.497999819522953e-22, -1.472389372430249e-22,  2.371103903757473e-24,  1.311467642185173e-01, -2.074781604483521e-03,
  2.312560559757577e-05, -2.077773136537740e-07,  1.477893319797030e-09, -6.787099678890180e-12, -1.236737578965711e-14,  7.383221841569980e-16, -1.030013478291417e-17,
  9.486273555218641e-20, -5.519369373643771e-22, -1.805740116590417e-25,  2.580055518510726e-01, -3.862618738873526e-03,  3.780674920024551e-05, -2.528358394295988e-07,
  6.382739204495470e-10,  1.123316155324245e-11, -2.037852437470127e-13,  1.742392992107016e-15, -4.425075890419103e-18, -1.149026847979841e-19,  2.117814260737677e-21,
 -1.842413537126546e-23,  4.217785036022291e-01, -5.835621241502264e-03,  4.640232816442807e-05, -1.468789775723413e-07, -1.813092285740024e-09,  3.192942691743431e-11,
 -1.827749540942852e-13, -1.199634288779079e-15,  3.404810337912210e-17, -2.708835795048171e-19, -7.395416612098168e-22,  4.203178065721326e-23,  6.173171349959810e-01,
 -7.666567858841513e-03,  4.314250211431836e-05,  1.136647814200147e-07, -4.206481360542964e-09,  2.268853409370215e-11,  2.544258786398851e-13, -4.766675460815014e-15,
  1.111109337783210e-17,  5.015951701633142e-19, -6.029471845149915e-21, -1.181730569991221e-23,  8.375082818983760e-01, -8.993567401014757e-03,  2.538180995970674e-05,
  4.186559752039549e-07, -3.874295669752035e-09, -2.533842373519305e-11,  5.622543226818733e-13,  3.849571761198974e-16, -7.586161705038773e-17,  3.377144583167499e-19,
  9.005333579550061e-21, -9.745704285537378e-23,  1.072888439801933e+00, -9.476750517697993e-03, -3.987548396623661e-06,  5.722516203590229e-07,  2.207975523793299e-10,
 -6.234797781678494e-11,  5.207288193645534e-16,  8.258676905714235e-15, -4.803307499416640e-18, -1.210966077952501e-18,  1.473875794993790e-21,  1.886066530847290e-22,
  1.311331818191223e+00, -8.886599197024388e-03, -3.549986843298585e-05,  4.165113650338953e-07,  5.049408311073075e-09, -2.593599970993764e-11, -7.595838684860318e-13,
  2.314534218038513e-16,  1.126586631657143e-16,  4.762853963210583e-19, -1.578018271538394e-20, -1.515909962352199e-22,  1.538021834848252e+00, -7.217550846180662e-03,
 -5.554959993655762e-05,  4.586352568376978e-09,  5.331102928134502e-09,  4.783911889635527e-11, -2.457954668302071e-13, -9.112063344268276e-15, -5.262701787813520e-17,
  9.006876557690749e-19,  1.760486010032280e-20,  2.914034814569075e-23,  1.736031779352470e+00, -4.790075282601652e-03, -5.366028240222585e-05, -3.535124055501127e-07,
  4.085944938707810e-10,  4.549062332059084e-11,  5.890829310324796e-13,  2.263494283572141e-15, -5.264013606896679e-17, -1.138844259301055e-18, -9.056170860444262e-21,
  4.559636930704945e-23,  1.887876608052709e+00, -2.263012946677999e-03, -3.186827679798157e-05, -3.564430495011564e-07, -3.076100810651376e-09, -1.552810089019166e-11,
  8.473561341870989e-14,  3.518059827180031e-15,  5.419103230312553e-17,  5.328538474398684e-19,  2.346573540524139e-21, -3.437364008522706e-23,  1.978187433466986e+00,
 -4.676494487670992e-04, -7.426544261295883e-06, -1.029737088040239e-07, -1.308168237022203e-09, -1.548233671360929e-11, -1.712572611222243e-13, -1.757329468451191e-15,
 -1.636585955464398e-17, -1.307871730740511e-19, -7.409722162090373e-22,  7.174351759179796e-25,  4.193339937075131e-02, -6.664663293377992e-04,  7.800970455759284e-06,
 -7.913310162485202e-08,  7.264521271677894e-10, -6.101202617753479e-12,  4.640303680207366e-14, -3.086413368157106e-16,  1.599344620153997e-18, -3.199080075052624e-21,
 -6.776821896818927e-23,  1.328666293132799e-24,  1.232024102314778e-01, -1.899358472632844e-03,  2.076964154417994e-05, -1.852266858839267e-07,  1.340678018526070e-09,
 -6.870082157056449e-12,  4.174319649788613e-15,  4.591235331038368e-16, -7.278273794536955e-18,  7.327134309922107e-20, -5.148868484541912e-22,  1.585821816574499e-24,
  2.431410348914711e-01, -3.572111826090958e-03,  3.484059105550925e-05, -2.410756306244233e-07,  8.178835296697667e-10,  6.908482531802908e-12, -1.574949541772905e-13,
  1.549410786398907e-15, -7.225747972100006e-18, -4.566566398352467e-20,  1.366815174332531e-21, -1.534305151892748e-23,  3.991666588342129e-01, -5.471899032061088e-03,
  4.448599882718554e-05, -1.710274065977135e-07, -1.220492927177152e-09,  2.725373692046509e-11, -2.025987192113779e-13, -2.685773904825331e-16,  2.415469307532106e-17,
 -2.694663522872210e-19,  6.670393514570954e-22,  2.242527112231486e-23,  5.873482147416527e-01, -7.317079674945131e-03,  4.411858459063123e-05,  5.027855777873470e-08,
 -3.702186942004944e-09,  2.724833944179131e-11,  1.283172653192076e-13, -4.169031075783209e-15,  2.481216356350886e-17,  2.618328299683384e-19, -5.702794228381801e-21,
  2.326512563912770e-23,  8.019704065994278e-01, -8.771504995214624e-03,  3.001939937339523e-05,  3.533451724161678e-07, -4.246611704258596e-09, -1.197578911288331e-11,
  5.413191116492256e-13, -1.787507467759565e-15, -5.833318836255170e-17,  6.040840062205456e-19,  4.197601427635247e-21, -1.134611863515393e-22,  1.034961088398764e+00,
 -9.481217147377234e-03,  2.859733107533949e-06,  5.658871851472924e-07, -1.007564298291368e-09, -5.961741551874583e-11,  2.232306944785265e-13,  7.434530557447427e-15,
 -4.542413561498909e-17, -9.966004047345722e-19,  8.861270759849627e-21,  1.364874881044711e-22,  1.275250957312129e+00, -9.149277976546162e-03, -3.003729108091483e-05,
  4.921713310509877e-07,  4.351068915825062e-09, -4.366967176897410e-11, -7.009893732281054e-13,  3.977896265310828e-15,  1.171304030908346e-16, -2.548988907456695e-19,
 -1.982276938861100e-20, -2.113019087554657e-23,  1.508265326277400e+00, -7.660207250769174e-03, -5.495248657698239e-05,  9.712800219560278e-08,  6.207389641580725e-09,
  3.872291083985247e-11, -5.186644503427511e-13, -1.014145026385366e-14, -7.609679268479477e-18,  1.586467712163731e-18,  1.547045241238676e-20, -1.366638813937751e-22,
  1.715986301222834e+00, -5.236140771811218e-03, -5.783064457198507e-05, -3.389106145362280e-07,  1.463767294140140e-09,  6.015855379923298e-11,  6.222489686973198e-13,
 -1.408680040501517e-16, -9.935257146373259e-17, -1.424561561151708e-18, -4.210648297180228e-21,  1.852417505051953e-22,  1.878286362949456e+00, -2.535927830288936e-03,
 -3.645068918773611e-05, -4.079974133368969e-07, -3.357257313354394e-09, -1.209814206234899e-11,  2.105098385248506e-13,  5.573249076516256e-15,  7.454228619021938e-17,
  5.786447821690303e-19, -5.807690230835794e-22, -1.065903938556031e-22,  1.976189649664355e+00, -5.323854342662633e-04, -8.798803050877728e-06, -1.266227461109977e-07,
 -1.663227377894976e-09, -2.024670411142998e-11, -2.285420931524286e-13, -2.361915599754070e-15, -2.158223229661731e-17, -1.577250554508021e-19, -5.401493589216373e-22,
  9.862578336239592e-24,  3.938660267369906e-02, -6.076682544628604e-04,  6.917274071955378e-06, -6.842838619321060e-08,  6.148941823692786e-10, -5.085572522755185e-12,
  3.845714078032380e-14, -2.597266660538767e-16,  1.447546237100705e-18, -4.947335289914883e-21, -2.415233739725442e-23,  7.070749829308267e-25,  1.159237144990811e-01,
 -1.741737944059633e-03,  1.867112064969794e-05, -1.648656802121573e-07,  1.205193324719220e-09, -6.639652376437445e-12,  1.413817952367175e-14,  2.645988809963952e-16,
 -4.992322405667008e-18,  5.428662978541154e-20, -4.307040229451729e-22,  2.096006853957623e-24,  2.293920416141074e-01, -3.304727025735396e-03,  3.203013378285712e-05,
 -2.270752460525458e-07,  9.216282466433308e-10,  3.621904208303309e-12, -1.175277953328991e-13,  1.301186782485345e-15, -8.037311508789660e-18, -3.282988056023435e-21,
  7.827507891544714e-22, -1.118752892987165e-23,  3.779774243810309e-01, -5.124512628476979e-03,  4.233363086674051e-05, -1.864599823473665e-07, -7.242368404117503e-10,
  2.237973188926439e-11, -2.007095014677636e-13,  3.559451029300251e-16,  1.512761872974647e-17, -2.278415212750990e-19,  1.305914133702222e-21,  7.568759444220619e-24,
  5.587882486689484e-01, -6.962682307862762e-03,  4.438493890771944e-05, -4.467351736343203e-09, -3.135384274872326e-09,  2.902407240269778e-11,  2.381685825018328e-14,
 -3.265878646748358e-15,  3.043358013549347e-17,  5.992798861856632e-20, -4.285389005738360e-21,  3.804973336848750e-23,  7.673899021999586e-01, -8.515558026452697e-03,
  3.384619417879139e-05,  2.841685938381173e-07, -4.361266376326210e-09,  2.253489796923791e-13,  4.685804446566152e-13, -3.283354083805216e-15, -3.473036310426400e-17,
  6.766358030038670e-19, -4.020820464340436e-22, -9.075820384039454e-23,  9.971244793819002e-01, -9.431539144392636e-03,  9.515433988051692e-06,  5.405858859136437e-07,
 -2.130455527084392e-09, -5.195657295787417e-11,  4.062020845706459e-13,  5.485510601171593e-15, -7.371455865052344e-17, -5.488517627337251e-19,  1.281416411507886e-20,
  3.952657164160496e-23,  1.238212229850722e+00, -9.364840688823388e-03, -2.374519398370051e-05,  5.539325233776749e-07,  3.320592935134467e-09, -5.874724234593729e-11,
 -5.396008379776499e-13,  7.427273447939961e-15,  9.389611980564630e-17, -1.018131458331138e-18, -1.714019156323057e-20,  1.420654120001415e-22,  1.476755094336465e+00,
 -8.093422603463926e-03, -5.316793829925016e-05,  2.018692371179609e-07,  6.834463738552693e-09,  2.289660762220643e-11, -7.966817784379255e-13, -9.366928391541879e-15,
  5.866874158462957e-17,  2.027536215489508e-18,  5.180924971892927e-21, -3.273147906568605e-22,  1.694091379858914e+00, -5.714558815529713e-03, -6.171473782553863e-05,
 -3.050619758781060e-07,  2.813898053056174e-09,  7.463784161867985e-11,  5.659608296948082e-13, -4.154144067509364e-15, -1.512274139735036e-16, -1.377239856857508e-18,
  7.919621077960813e-21,  3.681424559719780e-22,  1.867527121958556e+00, -2.848046715400553e-03, -4.167589325381369e-05, -4.633165785942721e-07, -3.534584354260647e-09,
 -4.884923164298615e-12,  4.029930432202468e-13,  8.276341682633302e-15,  9.353056428755385e-17,  4.284141608204242e-19, -7.861764055358666e-21, -2.344582567847053e-22,
  1.973909021913888e+00, -6.093389771058581e-04, -1.049233898631576e-05, -1.567958336485228e-07, -2.128794439736433e-09, -2.660872871427211e-11, -3.052215705637718e-13,
 -3.146422627004693e-15, -2.749837691222616e-17, -1.653266675988379e-19,  3.242648344029286e-22,  3.264460779159933e-23,  3.706163180742031e-02, -5.554547893689650e-04,
  6.151962710218474e-06, -5.935600335569393e-08,  5.218497191763219e-10, -4.244804848026219e-12,  3.180550498545175e-14, -2.163881058207242e-16,  1.258403560736798e-18,
 -5.414282900680286e-21, -1.890047073270957e-24,  3.352919066087626e-25,  1.092434205145663e-01, -1.599964680157061e-03,  1.680411474451750e-05, -1.466242790154686e-07,
  1.076307498393077e-09, -6.227791688337485e-12,  1.958152892876597e-14,  1.329694568511662e-16, -3.325858541337614e-18,  3.889913370558374e-20, -3.395755912244972e-22,
  1.976908394890445e-24,  2.166687179147370e-01, -3.059130315424271e-03,  2.939563374992410e-05, -2.118910807128838e-07,  9.686608006876901e-10,  1.209457266896524e-12,
 -8.467519568350424e-14,  1.047252135562455e-15, -7.699912028363382e-18,  1.933991397002883e-20,  3.756415857533543e-22, -7.454826890076460e-24,  3.581423056272837e-01,
 -4.794958315840468e-03,  4.004051859147127e-05, -1.947244605600137e-07, -3.237533016791322e-10,  1.772979690913692e-11, -1.851242497172657e-13,  7.193327593181038e-16,
  7.917026211979663e-18, -1.720307188731530e-19,  1.418070737051159e-21, -1.590156292965689e-24,  5.316461931935679e-01, -6.608625881902951e-03,  4.404951013430891e-05,
 -4.998768807639408e-08, -2.556020634391139e-09,  2.860928255702898e-11, -5.388576174487043e-14, -2.287236384399576e-15,  2.991662893465891e-17, -7.735163037230850e-20,
 -2.585363722426822e-21,  3.723986985434190e-23,  7.338891365411713e-01, -8.232330495995118e-03,  3.683957352529967e-05,  2.150021853095245e-07, -4.252301258640619e-09,
  1.026470315690794e-11,  3.646851841537799e-13, -4.015227734494099e-15, -1.152038554998564e-17,  5.921413105867446e-19, -3.523154845600847e-21, -4.997265792787019e-23,
  9.595907366866828e-01, -9.330122327429339e-03,  1.576549605335535e-05,  4.987624611699694e-07, -3.061099344590716e-09, -4.064581258690560e-11,  5.245179908123380e-13,
  2.911032539140311e-15, -8.410048150077093e-17, -3.118693747980160e-20,  1.237126430438660e-20, -5.566960433544881e-23,  1.200416194938682e+00, -9.527403771389451e-03,
 -1.682007236734709e-05,  5.970351507646436e-07,  2.034583842363340e-09, -6.890081837127649e-11, -2.959419920102533e-13,  9.727913643464837e-15,  4.678368410710506e-17,
 -1.538640548620352e-18, -8.038465613163262e-21,  2.572772267126363e-22,  1.443548720270713e+00, -8.507189783171755e-03, -5.007788492002594e-05,  3.137607566126352e-07,
  7.081333483169781e-09,  9.092290293404000e-13, -1.021590463156997e-12, -6.312505043191049e-15,  1.315244416776181e-16,  1.905166194932261e-18, -1.208358584437807e-20,
 -4.330777410840428e-22,  1.670223759943221e+00, -6.222036306620809e-03, -6.505382869465333e-05, -2.474094838027543e-07,  4.430053994179844e-09,  8.623548460457178e-11,
  3.750754796179269e-13, -9.690912461260522e-15, -1.907569815504804e-16, -6.889847743510619e-19,  2.747244228642795e-20,  4.997163465147163e-22,  1.855431546482887e+00,
 -3.204658058631009e-03, -4.757630382262605e-05, -5.200409806583452e-07, -3.514995040853065e-09,  7.917494441511490e-12,  6.783868606094519e-13,  1.143225895106233e-14,
  1.003530873188929e-16, -1.428602961478175e-19, -2.202737384645724e-20, -4.154465241087719e-22,  1.971290997869797e+00, -7.014261084225174e-04, -1.259719057513170e-05,
 -1.955437620025692e-07, -2.741894918141120e-09, -3.509600650198580e-11, -4.064979600125430e-13, -4.115592548394909e-15, -3.276207997183488e-17, -1.112070716470774e-19,
  2.757615494142381e-21,  8.471962674479458e-23,  3.493392520810074e-02, -5.089524252746903e-04,  5.487115581598754e-06, -5.164608270065523e-08,  4.441189281196842e-10,
 -3.549808740650297e-12,  2.628114051697127e-14, -1.792282527576677e-16,  1.064978547102287e-18, -5.270733399808495e-21,  7.382583955154082e-24,  1.032079719933329e-25,
  1.031016852218853e-01, -1.472286266841996e-03,  1.514392425835632e-05, -1.303732062119031e-07,  9.566958154115919e-10, -5.723979243141089e-12,  2.200747680063809e-14,
  4.649039558834306e-17, -2.149967559015507e-18,  2.694897603144387e-20, -2.609134606569448e-22,  1.571136550504562e-24,  2.048867966147178e-01, -2.833871373060271e-03,
  2.694639884706835e-05, -1.962999331418599e-07,  9.747622302873409e-10, -4.979814580466948e-13, -5.867979968548015e-14,  8.143076251783961e-16, -6.804058005630760e-18,
  2.869162387560337e-20,  1.119809966133074e-22, -4.702269165453588e-24,  3.395882308796407e-01, -4.484043585347590e-03,  3.768368424781621e-05, -1.973018542875008e-07,
 -1.183065771247138e-11,  1.355180231865528e-11, -1.622903910714362e-13,  8.842955136991195e-16,  2.712735576668795e-18, -1.183343366605004e-19,  1.233534989863226e-21,
 -6.175161483998959e-24,  5.059117578872605e-01, -6.259281518212961e-03,  4.322287951422179e-05, -8.639666762910108e-08, -2.001409204796866e-09,  2.665248178065414e-11,
 -1.050687278422242e-13, -1.391344397990073e-15,  2.564485632507782e-17, -1.503359569185671e-19, -1.131789546406332e-21,  2.801379621573993e-23,  7.015639792443573e-01,
 -7.928431928852901e-03,  3.901958824400915e-05,  1.490445346702663e-07, -3.968724841280480e-09,  1.764500504728034e-11,  2.500871379461218e-13, -4.073572461338915e-15,
  6.841156257168555e-18,  4.193248803757593e-19, -4.833802056794455e-21, -1.117415511259425e-23,  9.225591500835467e-01, -9.180947602387418e-03,  2.143223196556059e-05,
  4.439877740275766e-07, -3.743093146014287e-09, -2.738114678057937e-11,  5.688279113941452e-13,  2.912926027015579e-16, -7.709642915246399e-17,  3.944520340625772e-19,
  8.496475682980960e-21, -1.123752785687719e-22,  1.162083473983952e+00, -9.632860022942035e-03, -9.506796205218586e-06,  6.182734334571608e-07,  6.082551450288263e-10,
 -7.261851280957220e-11, -1.123843892654551e-14,  1.029962787812783e-14, -1.155410640481802e-17, -1.623107583212020e-18,  3.860019777647149e-21,  2.634565413533095e-22,
  1.408745270629271e+00, -8.890833757295690e-03, -4.563680484503827e-05,  4.258246479790524e-07,  6.842731329886537e-09, -2.519523388026461e-11, -1.129987005456663e-12,
 -1.136650393631870e-15,  1.868748626288862e-16,  1.050091817061641e-18, -3.003845553121843e-20, -3.460560375138315e-22,  1.644277827676967e+00, -6.753003870340065e-03,
 -6.753924000650037e-05, -1.623467218801600e-07,  6.219171757352079e-09,  9.127710739673130e-11,  1.630443855296381e-14, -1.593674720735100e-14, -1.904821218948796e-16,
  8.454638202112271e-19,  4.860289704411593e-20,  4.080094980382482e-22,  1.841810844310864e+00, -3.611168186614917e-03, -5.414583123730433e-05, -5.740142500352953e-07,
 -3.166073883799431e-09,  2.839111591691122e-11,  1.041239261954956e-12,  1.435214496633310e-14,  7.444440141605359e-17, -1.443684564731113e-18, -4.422374321070682e-20,
 -5.782350682911192e-22,  1.968267749255167e+00, -8.123925221112269e-04, -1.523193031385656e-05, -2.456008651765565e-07, -3.551333245495154e-09, -4.635599460131504e-11,
 -5.368124642762934e-13, -5.197934609941232e-15, -3.364463850410134e-17,  1.007096034471350e-19,  8.643691715891444e-21,  1.961241950097685e-22,  3.298214795234352e-02,
 -4.674188934959363e-04,  4.907761643900746e-06, -4.507551783568904e-08,  3.790429036436697e-10, -2.975604222391128e-12,  2.171177773957100e-14, -1.481219524925498e-16,
  8.812020988850938e-19, -4.931459700193104e-21,  8.616472140217649e-24, -2.778968394535823e-26,  9.744529071622889e-02, -1.357141077745580e-03,  1.366760461165656e-05,
 -1.159528985754421e-07,  8.475668386836043e-10, -5.187125698354478e-12,  2.247825200133841e-14, -8.673268535042345e-18, -1.352256674936401e-18,  1.775824366661808e-20,
 -2.018281160314526e-22,  1.138483281257422e-24,  1.939679074384601e-01, -2.627458661082130e-03,  2.468382043558243e-05, -1.808526109342580e-07,  9.524432769545925e-10,
 -1.656316786272947e-12, -3.876812279926860e-14,  6.136008551947886e-16, -5.734842420720887e-18,  2.963283572694780e-20, -5.123818334813955e-23, -2.808247851996699e-24,
  3.222400214797857e-01, -4.192028552147565e-03,  3.532320825179871e-05, -1.955259353142542e-07,  2.222964642696202e-10,  9.960155725896908e-12, -1.368906260260113e-13,
  9.118932607508929e-16, -7.305819683764926e-19, -7.503989342315333e-20,  9.210921147570327e-22, -7.562803152584850e-24,  4.815589154166541e-01, -5.918150343034311e-03,
  4.201109872611488e-05, -1.143034713504157e-07, -1.496274558807197e-09,  2.375081524110354e-11, -1.334004069724883e-13, -6.638293037578641e-16,  1.968443104890732e-17,
 -1.743051600147634e-19, -1.489204984167875e-22,  1.681039814483518e-23,  6.704844061327427e-01, -7.610171829393001e-03,  4.043972261948068e-05,  8.865608170676953e-08,
 -3.564860557725851e-09,  2.231571423648203e-11,  1.410923970002111e-13, -3.650861857572716e-15,  1.841912824538324e-17,  2.248411085571413e-19, -4.701142202318607e-21,
  1.483224798912484e-23,  8.862105323005242e-01, -8.989233261032155e-03,  2.638507539677738e-05,  3.804569984308204e-07, -4.154914084676863e-09, -1.389496458844094e-11,
  5.449892480775164e-13, -1.893067870472564e-15, -5.802710394709725e-17,  6.298800040168708e-19,  3.225044460543270e-21, -1.193925988987788e-22,  1.123447002443543e+00,
 -9.679181816340294e-03, -2.076833574704041e-06,  6.164685229172576e-07, -8.238921904967128e-10, -6.952172670000036e-11,  2.635283176816305e-13,  9.046179403796425e-15,
 -6.461609685953400e-17, -1.260516535668062e-18,  1.351978427407901e-20,  1.616244894502046e-22,  1.372486674448930e+00, -9.233675263092506e-03, -3.989140827974470e-05,
  5.298053057828651e-07,  6.068660035866735e-09, -5.199512082936309e-11, -1.074215973235952e-12,  5.190666010879552e-15,  2.000278500281994e-16, -3.822896043032209e-19,
 -3.943686474687453e-20, -5.385573467183764e-23,  1.616175416283580e+00, -7.299280740880857e-03, -6.883049173355745e-05, -4.837798734646410e-08,  8.009093396412307e-09,
  8.566718662524599e-11, -5.078347313374033e-13, -2.114079066750164e-14, -1.216615840256068e-16,  3.039921524525604e-18,  5.769301999667118e-20, -6.171220649975491e-23,
  1.826455066264674e+00, -4.072696021259196e-03, -6.131442561563886e-05, -6.186303469138405e-07, -2.314664530763685e-09,  5.841088867637965e-11,  1.465909911297839e-12,
  1.551073594790882e-14, -1.561027308629487e-17, -3.728691356256913e-18, -6.954918235408541e-20, -5.060436839134182e-22,  1.964754339967850e+00, -9.470780321141171e-04,
 -1.855307146969571e-05, -3.105907628129897e-07, -4.619681382807558e-09, -6.110144908092304e-11, -6.962938014612852e-13, -6.129830537035153e-15, -2.123131275613484e-17,
  6.741317560553827e-19,  2.163516196738044e-20,  4.180138274956912e-22,  3.118771063811151e-02, -4.302216712825220e-04,  4.401367640901037e-06, -3.945997076630963e-08,
  3.244214855005466e-10, -2.501265838075674e-12,  1.793291030369201e-14, -1.227003244547674e-16,  7.095321511308839e-19, -4.612588907470816e-21,  7.808619722096695e-24,
  4.326804374827678e-26,  9.222691096839929e-02, -1.253143136541703e-03,  1.235420726849863e-05, -1.031926211327877e-07,  7.491764746337994e-10, -4.654914278274311e-12,
  2.171513558037530e-14, -4.318077470538329e-17, -8.467419737064130e-19,  1.063806157719248e-20, -1.539819473551686e-22,  1.182248272302384e-24,  1.838396311615043e-01,
 -2.438412776866761e-03,  2.260378182337896e-05, -1.659236019856154e-07,  9.113011794780415e-10, -2.400352888727668e-12, -2.400020363420833e-14,  4.465482369820000e-16,
 -4.729952323547880e-18,  2.564681620932647e-20, -1.333064358015601e-22, -7.457579400997403e-25,  3.060223225454375e-01, -3.918753643887769e-03,  3.300425650615723e-05,
 -1.905454682488791e-07,  3.906906313824941e-10,  6.976277191437226e-12, -1.120440589948829e-13,  8.517621261129436e-16, -2.847132687586158e-18, -4.459192549178368e-20,
  6.145441028213544e-22, -5.703271334927973e-24,  4.585492761314973e-01, -5.587920161892000e-03,  4.051091241984965e-05, -1.346228014427882e-07, -1.054436701573544e-09,
  2.039153122355515e-11, -1.441129878048728e-13, -1.341967837826255e-16,  1.345560924627853e-17, -1.681155842512461e-19,  4.044573999082784e-22,  9.516074236164401e-24,
  6.406961693550104e-01, -7.283333250759466e-03,  4.117660143433352e-05,  3.533933694839226e-08, -3.092592905165147e-09,  2.454806460181028e-11,  4.808701717980397e-14,
 -2.966656062191143e-15,  2.333094213744795e-17,  5.467125386655207e-20, -3.702720490502919e-21,  2.940293519319306e-23,  8.507030575520101e-01, -8.761037465613719e-03,
  3.054476125328209e-05,  3.124443228002946e-07, -4.307302492107774e-09, -1.639524484315196e-12,  4.695160002894763e-13, -3.372103108238423e-15, -3.423156908866218e-17,
  6.613521197214252e-19, -1.399968552952352e-21, -8.504477571941292e-23,  1.084743445063919e+00, -9.666533126188004e-03,  5.197147950479194e-06,  5.925878305646443e-07,
 -2.131934103711367e-09, -6.042908285146667e-11,  4.818637232776567e-13,  6.368161960355253e-15, -9.893249383256023e-17, -6.200544643920902e-19,  1.743919292527110e-20,
  1.709735926247670e-23,  1.334956191131494e+00, -9.525813035175190e-03, -3.298984174073245e-05,  6.172460277167274e-07,  4.786362713926056e-09, -7.533253505350800e-11,
 -8.434990459679814e-13,  1.106883628335661e-14,  1.583009046187278e-16, -1.896940262885416e-18, -3.355696190104384e-20,  3.190126812973256e-22,  1.585876569223826e+00,
 -7.849943459360556e-03, -6.858832519677959e-05,  9.260431400784116e-08,  9.550821873894924e-09,  6.605260135024783e-11, -1.134746092866476e-12, -2.285550526322269e-14,
  2.672097297779186e-17,  5.077291781561608e-18,  3.849284321146000e-20, -8.340198393000301e-22,  1.809135480213665e+00, -4.593433344994840e-03, -6.891505722457961e-05,
 -6.442628286122135e-07, -7.603410885269376e-10,  9.860371368649953e-11,  1.868993400199263e-12,  1.229066130349686e-14, -2.040556139219657e-16, -6.809671827531124e-18,
 -7.938542767249548e-20,  2.036621280854686e-22,  1.960643669603574e+00, -1.111766581157273e-03, -2.276708015208927e-05, -3.952492475573072e-07, -6.023000021515177e-09,
 -7.991950333726285e-11, -8.723646743261258e-13, -6.212072491430256e-15,  2.395554018407537e-17,  2.009982020890398e-18,  4.806412624144832e-20,  8.178512547602664e-22,
  2.953436662729550e-02, -3.968202217230916e-04,  3.957414282667932e-06, -3.464716890750238e-08,  2.784343999722434e-10, -2.109688709625312e-12,  1.479068905645075e-14,
 -1.025819342156531e-16,  5.505544162356075e-19, -4.144191565635730e-21,  1.968387837380605e-23,  6.077322650600270e-25,  8.740444168364671e-02, -1.159065841956157e-03,
  1.118483499104302e-05, -9.192272931682152e-08,  6.611774193947383e-10, -4.151007440667238e-12,  2.017649213998340e-14, -6.522081079490022e-17, -5.596426753403395e-19,
  5.815608239286112e-21, -7.633287642915070e-23,  2.682947842549724e-24,  1.744353752669658e-01, -2.265302813227601e-03,  2.069850880098210e-05, -1.517541818558289e-07,
  8.584619349340017e-10, -2.842605313975863e-12, -1.348450216766175e-14,  3.089266927268975e-16, -3.901521511157637e-18,  2.069627593883787e-20, -8.242945436597478e-23,
  3.657039020794792e-24,  2.908610574764446e-01, -3.663749812314407e-03,  3.075936992851726e-05, -1.833164131133952e-07,  5.051984791421156e-10,  4.561792392065977e-12,
 -8.968014661083918e-14,  7.393140128634619e-16, -4.055945145025704e-18, -2.333892903627535e-20,  5.026987854088088e-22,  1.845534661028437e-24,  4.368351731689089e-01,
 -5.270551792615554e-03,  3.880706101927356e-05, -1.484195395578802e-07, -6.812693542563921e-10,  1.693092409974300e-11, -1.427253370683038e-13,  2.034708007747537e-16,
  7.793796493938918e-18, -1.435698456835598e-19,  8.472618827188329e-22,  1.297033931493297e-23,  6.122232097527933e-01, -6.953027749929914e-03,  4.132011591773765e-05,
 -1.017846469567952e-08, -2.596378887388836e-09,  2.479058460966332e-11, -2.441925802535177e-14, -2.214405634986000e-15,  2.297946593927911e-17, -6.368658201928476e-20,
 -2.106704075558702e-21,  4.454436457172610e-23,  8.161697171550879e-01, -8.502852316168567e-03,  3.388140076568034e-05,  2.438433551070696e-07, -4.235605376488082e-09,
  8.393501043851616e-12,  3.632259735008354e-13, -4.103711422470679e-15, -1.217964887454266e-17,  5.477281101599362e-19, -3.803998956661184e-21, -1.957891049837382e-23,
  1.046204569316348e+00, -9.597179108578211e-03,  1.206583811495197e-05,  5.494905538214446e-07, -3.212344323331230e-09, -4.709820758548677e-11,  6.134523470087639e-13,
  2.979104825651118e-15, -1.088402032045316e-16,  5.821439074448937e-20,  1.578032044882314e-20, -7.702773284713742e-23,  1.296373690900168e+00, -9.758923158776188e-03,
 -2.517637022254225e-05,  6.807894836024422e-07,  3.105035700737605e-09, -9.135654084836732e-11, -4.745783937936916e-13,  1.481599321782915e-14,  7.009806701386337e-17,
 -2.865662024998904e-18, -1.287383553695833e-20,  5.927613922843743e-22,  1.553390206586479e+00, -8.391517509315537e-03, -6.652197841086643e-05,  2.542925767394067e-07,
  1.054894684508147e-08,  3.141335818223462e-11, -1.733613690873855e-12, -1.886375585491668e-14,  2.263934943695684e-16,  5.671320615806414e-18, -1.320425349551134e-20,
 -1.427494380058809e-21,  1.789610068151508e+00, -5.175719003320525e-03, -7.664594983881940e-05, -6.381139021417013e-07,  1.683315061479966e-09,  1.466037941837046e-10,
  2.080710667136377e-12,  1.267508228762414e-15, -5.004067946120376e-16, -9.373090616027143e-18, -3.605258571899664e-20,  1.949386331019298e-21,  1.955799808406650e+00,
 -1.314642594442030e-03, -2.814486654248305e-05, -5.055985109888051e-07, -7.844060752232542e-09, -1.027748448359274e-10, -1.021592658233064e-12, -3.836700812816795e-15,
  1.410711270752635e-16,  4.817307037321056e-18,  9.672211625053768e-20,  1.421931736649881e-21,  2.800787402718305e-02, -3.667513235415378e-04,  3.567045453635587e-06,
 -3.051142410571696e-08,  2.395674640430189e-10, -1.787319684485006e-12,  1.214409206917719e-14, -8.712821221331084e-17,  4.249003216914305e-19, -2.490624605941959e-21,
  7.251104520367115e-23,  1.906500061240771e-24,  8.294039533315935e-02, -1.073825754595364e-03,  1.014257905301302e-05, -8.198239663934057e-08,  5.828420146477146e-10,
 -3.690530435761741e-12,  1.812845685965119e-14, -8.008473219127994e-17, -3.684945252271312e-19,  6.067213816617551e-21,  1.163063711716148e-22,  6.420731430114989e-24,
  1.656941306625569e-01, -2.106769863302900e-03,  1.895794533014741e-05, -1.384884957032007e-07,  7.990041525092519e-10, -3.075866128471414e-12, -6.472527242695445e-15,
  1.958042513256523e-16, -3.157362073454961e-18,  2.283895756834069e-20,  2.521765369227525e-22,  1.220885990226011e-23,  2.766844783209229e-01, -3.426330418734112e-03,
  2.861072257619479e-05, -1.746135276916046e-07,  5.765092939923640e-10,  2.642582556891800e-12, -7.089302699751088e-14,  6.003497565686724e-16, -4.479013837400485e-18,
  2.421610529912300e-21,  8.993354320624675e-22,  1.741407847829766e-23,  4.163623699026602e-01, -4.967380210317620e-03,  3.697120260952749e-05, -1.567946297518714e-07,
 -3.763171434331961e-10,  1.359755470324840e-11, -1.342592550679902e-13,  3.780794567407864e-16,  3.411664221207358e-18, -9.377629296779418e-20,  1.781455948164201e-21,
  3.192481294832152e-23,  5.850704993341616e-01, -6.623624227841670e-03,  4.096492653552617e-05, -4.780549429663027e-08, -2.111031428949151e-09,  2.354097829047655e-11,
 -7.656423580042299e-14, -1.527763181153813e-15,  1.970649248450697e-17, -1.014701018793654e-19,  4.268566772291106e-22,  7.317580930168010e-23,  7.827173363827039e-01,
 -8.221233074685457e-03,  3.640786872296337e-05,  1.778506390988689e-07, -3.990022517748471e-09,  1.570519062361030e-11,  2.456179331935458e-13, -4.207549242516211e-15,
  4.817786148865358e-18,  4.034335123461907e-19, -2.753406787777256e-21,  7.028336463200507e-23,  1.008049346333411e+00, -9.475216894578474e-03,  1.832290669655809e-05,
  4.913786198672647e-07, -4.002333781161716e-09, -3.176181831269916e-11,  6.492501449613595e-13, -3.554010787538920e-16, -9.624137443109534e-17,  6.188439096980808e-19,
  1.240971764406659e-20, -5.560209546126656e-23,  1.256987921403566e+00, -9.926953823739922e-03, -1.677071927165384e-05,  7.153785212977837e-07,  1.198505504297592e-09,
 -9.761233793034377e-11, -4.423579639220199e-14,  1.536269009588137e-14, -3.567835338896230e-17, -2.821132515223269e-18,  1.567328821856143e-20,  6.718912593930025e-22,
  1.518783205370997e+00, -8.908585741786296e-03, -6.244480863548170e-05,  4.256787324012423e-07,  1.072337190508209e-08, -1.553102974378948e-11, -2.131129147269821e-12,
 -8.578795570122092e-15,  4.057756000298216e-16,  3.886954454831345e-18, -7.400218905901816e-20, -1.146543442802046e-21,  1.767633322575880e+00, -5.818817828474622e-03,
 -8.403622522969952e-05, -5.850355477538840e-07,  5.106940938875188e-09,  1.948404541061246e-10,  1.840486036807204e-12, -2.021259768785759e-14, -8.366364063713426e-16,
 -8.380872245598894e-18,  1.040437258722345e-19,  4.441784834179972e-21,  1.950049265527389e+00, -1.566368848587418e-03, -3.503729776327997e-05, -6.489046231672297e-07,
 -1.015001757574115e-08, -1.278819010275948e-10, -1.033659205463858e-12,  4.333080996894085e-15,  4.009743154477501e-16,  1.012837485236148e-17,  1.731186473682052e-19,
  1.995162004752441e-21,  2.659571112887137e-02, -3.396169637692258e-04,  3.222776304880160e-06, -2.694928258161723e-08,  2.065457221276137e-10, -1.523658366459231e-12,
  9.886457763698483e-15, -7.421408704418133e-17,  4.119075559263361e-19,  2.548691811534806e-21,  1.899475131855315e-22,  3.306652571302790e-24,  7.880135952174004e-02,
 -9.964672040761529e-04,  9.212381816888196e-06, -7.322455312806041e-08,  5.131947388233298e-10, -3.283439294605436e-12,  1.576384047900363e-14, -8.684939311161690e-17,
  1.415977399509567e-20,  1.771786248124557e-20,  4.969032911772018e-22,  1.051038608478140e-23,  1.575601538037721e-01, -1.961541141020976e-03,  1.737073499058477e-05,
 -1.262033387268702e-07,  7.363220735656880e-10, -3.175974898529240e-12, -2.260048135095359e-15,  1.111016866166067e-16, -1.996855955182974e-18,  4.663192273860099e-20,
  1.004859523120075e-21,  2.121087892402601e-23,  2.634238835310376e-01, -3.205665833602572e-03,  2.657216471110834e-05, -1.650535825394293e-07,  6.136258913446125e-10,
  1.127043328017529e-12, -5.601691667114508e-14,  4.671885921913163e-16, -3.509556899222593e-18,  5.916714727647034e-20,  2.062869000761548e-21,  3.412585738726450e-23,
  3.970723532449001e-01, -4.679219540445166e-03,  3.506195817432278e-05, -1.608113826233909e-07, -1.356782317962601e-10,  1.051215265483397e-11, -1.225359086466856e-13,
  4.501952207553855e-16,  1.726303312098751e-18,  1.314794521900850e-20,  3.740906327262108e-21,  5.539570438671442e-23,  5.592270436707411e-01, -6.298738613341913e-03,
  4.020377848162199e-05, -7.792858343307506e-08, -1.661697329364911e-09,  2.125827699273334e-11, -1.109991809392734e-13, -9.453795039412152e-16,  1.723218261641502e-17,
 -9.644363886116101e-21,  4.399622021485922e-21,  1.044400576093701e-22,  7.504269483176079e-01, -7.922492824599342e-03,  3.817032881677246e-05,  1.168038184514541e-07,
 -3.626368335904022e-09,  2.021654620997337e-11,  1.320400218494415e-13, -3.834542069167578e-15,  1.835618826453012e-17,  3.824675904563838e-19,  2.325856669544159e-21,
  1.539232729358125e-22,  9.704773963697434e-01, -9.306178920767058e-03,  2.381698204941848e-05,  4.230966626444353e-07, -4.484255187877076e-09, -1.662331631481925e-11,
  6.001954009262377e-13, -2.985975157789809e-15, -6.535714911875914e-17,  1.095682451726506e-18,  1.223819774877076e-20,  5.216078820331004e-23,  1.217066408376197e+00,
 -1.002660344825331e-02, -8.135339971688106e-06,  7.190217354678562e-07, -7.305599122909140e-10, -9.372924441987855e-11,  3.558612936698364e-13,  1.277396494365107e-14,
 -1.189767658788493e-16, -1.621646001219198e-18,  4.351085438608024e-20,  5.627259958763791e-22,  1.482186160595704e+00, -9.384836829809128e-03, -5.632662894062169e-05,
  5.919348918471256e-07,  9.889874112548496e-09, -6.798655842822646e-11, -2.173065951727229e-12,  5.993724981750462e-15,  4.832098348211399e-16,  2.550907544979861e-19,
 -9.758321176247558e-20,  2.114661890823152e-22,  1.742971378682871e+00, -6.517489686292101e-03, -9.043068042602528e-05, -4.700000869657038e-07,  9.382943585697889e-09,
  2.289555174073583e-10,  8.624894352639402e-13, -5.058978801046344e-14, -1.010874405106603e-15,  2.570224953377126e-19,  3.373222030087874e-19,  5.678284740156014e-21,
  1.943169712099204e+00, -1.880778267760612e-03, -4.388713722424839e-05, -8.330417455625393e-07, -1.293679541950177e-08, -1.493948919936769e-10, -6.673479569243472e-13,
  2.450799871122574e-14,  9.115078580038465e-16,  1.879640696088872e-17,  2.565345024198763e-19,  1.432462387876014e-21,  2.528683591070964e-02, -3.150743740536383e-04,
  2.918247586667811e-06, -2.387612248902603e-08,  1.782852586603041e-10, -1.309685469460430e-12,  8.018925593686250e-15, -5.780893805914220e-17,  6.759682449275384e-19,
  1.305718551243828e-20,  3.283519488794628e-22,  2.255894671963809e-24,  7.495751439850241e-02, -9.261482004689487e-04,  8.380851153428388e-06, -6.551904835646752e-08,
  4.511156386333324e-10, -2.933488036942480e-12,  1.346696369301309e-14, -7.143665665655198e-17,  1.122398876358439e-18,  4.681497798990910e-20,  9.357470106152390e-22,
  7.242204120171138e-24,  1.499826059105638e-01, -1.828437583578247e-03,  1.592487878184150e-05, -1.149323379026115e-07,  6.724825663441969e-10, -3.198231899000997e-12,
  2.746746744457897e-16,  8.368107797618712e-17,  6.339375646753051e-19,  1.055642788309167e-19,  1.898955770720838e-21,  1.488191741331144e-23,  2.510140680788003e-01,
 -3.000842921842325e-03,  2.465094870963605e-05, -1.551240367014364e-07,  6.237273607079298e-10, -7.046569900854051e-14, -4.405668420612298e-14,  4.079072340137776e-16,
  4.768719374960337e-19,  1.721627868532665e-19,  3.520185810171613e-21,  2.417022012395021e-23,  3.789042124335869e-01, -4.406464763760360e-03,  3.312562891698244e-05,
 -1.614556618749365e-07,  4.621551160070044e-11,  7.730389192729992e-12, -1.088517903550265e-13,  5.467581019382485e-16,  5.490879248257856e-18,  2.117888267641419e-19,
  6.076078902521220e-21,  3.831162972748530e-23,  5.346688303769357e-01, -5.981269607073359e-03,  3.912265226503341e-05, -1.012670286771679e-07, -1.264989893317010e-09,
  1.834007895995290e-11, -1.295072997859816e-13, -3.564880722083584e-16,  2.116232733891052e-17,  2.571403751606269e-19,  8.727999614249148e-21,  7.344062845590267e-23,
  7.193552285536152e-01, -7.612478310966145e-03,  3.923764743949144e-05,  6.215361391898635e-08, -3.198644087877202e-09,  2.217718126052598e-11,  3.517417098601708e-14,
 -2.995063092011640e-15,  3.550721331959024e-17,  6.170245712202488e-19,  9.251276457625481e-21,  1.303463400648223e-22,  9.336641586933860e-01, -9.096574481232300e-03,
  2.845513052069016e-05,  3.494393264736695e-07, -4.680500796789211e-09, -3.418281304595392e-12,  4.939449653363069e-13, -4.345867112098423e-15, -1.634057283840134e-17,
  1.651310114805067e-18,  1.567914469045539e-20,  6.573121418632845e-23,  1.176884010921249e+00, -1.005751072031711e-02,  3.627413501794581e-07,  6.929134449590112e-07,
 -2.493171707096168e-09, -8.136755393673416e-11,  6.541083534321062e-13,  8.412521244074015e-15, -1.407629074395898e-16,  5.326085387273557e-19,  6.161112911459920e-20,
  2.024940370460448e-22,  1.443794213037676e+00, -9.804468280002030e-03, -4.832780118273454e-05,  7.365496976889834e-07,  8.031172064855863e-09, -1.163964166692624e-10,
 -1.792504179051548e-12,  2.089751478326104e-14,  4.288003404210172e-16, -2.982576915646729e-18, -5.347344339550257e-20,  1.665767916266954e-21,  1.715422876896746e+00,
 -7.260590308550283e-03, -9.501663708049276e-05, -2.826616819964457e-07,  1.403583567889409e-08,  2.291150945595295e-10, -9.842314747068632e-13, -7.972414812108901e-14,
 -7.031922830056499e-16,  1.814703301413576e-17,  5.307549869102538e-19,  2.008431353386206e-21,  1.934875821155064e+00, -2.275611482498042e-03, -5.522619087207486e-05,
 -1.064502540287413e-06, -1.600931983571701e-08, -1.531822815100757e-10,  5.435607881662847e-13,  6.655775120515833e-14,  1.780156459906584e-15,  2.936554658339501e-17,
  2.370315329565110e-19, -3.462525468697880e-21,  2.407148170998711e-02, -2.928278789665196e-04,  2.648017597288430e-06, -2.122315123141741e-08,  1.538997975566014e-10,
 -1.133682500312224e-12,  6.792558866378668e-15, -2.601491643125116e-17,  1.392471896233671e-18,  2.653580535653126e-20,  2.899596497083066e-22, -5.429796257165736e-24,
  7.138220325714727e-02, -8.621279499210799e-04,  7.636048823196328e-06, -5.875357979020337e-08,  3.955444916385116e-10, -2.628398663823633e-12,  1.227679488941434e-14,
 -9.711404618793093e-19,  3.516110658285152e-18,  8.563976497823728e-20,  8.369390094929143e-22, -1.604912059489331e-23,  1.429151706112827e-01, -1.706377244974996e-03,
  1.460814176544014e-05, -1.046830875766923e-07,  6.088023712337671e-10, -3.157172582257394e-12,  3.582442987925232e-15,  1.801742166397992e-16,  5.873211823505360e-18,
  1.844438368154187e-19,  1.699437400790326e-21, -3.287430328524986e-23,  2.393935610679052e-01, -2.810912092750503e-03,  2.284911635811653e-05, -1.452091258724740e-07,
  6.127064483400667e-10, -9.823110107876772e-13, -3.128847384557240e-14,  5.506664339381611e-16,  9.317953581044908e-18,  3.167688038876339e-19,  3.113504949515477e-21,
 -5.828433946826283e-23,  3.617961249213652e-01, -4.149186177917857e-03,  3.119725524374817e-05, -1.596156246328975e-07,  1.760777191106605e-10,  5.330289881422228e-12,
 -8.958994534791620e-14,  8.931811622664572e-16,  1.765958539743300e-17,  4.605441325532739e-19,  5.407280525675206e-21, -9.360602171134314e-23,  5.113615676926406e-01,
 -5.673466514647773e-03,  3.779756063432681e-05, -1.187432147145562e-07, -9.296376413199659e-10,  1.519972510650634e-11, -1.281106926040058e-13,  5.401854889804197e-16,
  3.710958927026741e-17,  6.269119735646133e-19,  8.275261314671975e-21, -1.318346710004283e-22,  6.895366577222842e-01, -7.296429913044012e-03,  3.969113477031262e-05,
  1.454361135221335e-08, -2.752690775409931e-09,  2.216671395443219e-11, -2.888223664065695e-14, -1.424037431744384e-15,  6.524161827954662e-17,  1.039778092394124e-18,
  9.737284963550190e-21, -1.666706257925160e-22,  8.977579011018646e-01, -8.853434663841810e-03,  3.219879073837009e-05,  2.746068039068680e-07, -4.640232301580133e-09,
  6.976433986304939e-12,  3.747556742127340e-13, -3.794562370875261e-15,  5.449681268676270e-17,  2.263900253583723e-18,  1.224334355498467e-20, -3.094025490287575e-22,
  1.136711320307593e+00, -1.002214486221450e-02,  8.387616191964648e-06,  6.409281719534726e-07, -3.946949853759386e-09, -6.331639837473113e-11,  8.329158526105551e-13,
  4.696377485477237e-15, -7.689367023111769e-17,  2.967496140873948e-18,  5.384772143378500e-20, -6.646273597073420e-22,  1.403861905791328e+00, -1.015374283760148e-02,
 -3.880199773466065e-05,  8.443130530587688e-07,  5.327988997625678e-09, -1.509546303823197e-10, -1.033475035881510e-12,  3.264118262719577e-14,  3.018398017665526e-16,
 -3.551874839216968e-18,  2.317336410796720e-20,  1.394469540315315e-21,  1.684844600806348e+00, -8.030137424640727e-03, -9.691624257376909e-05, -2.350886926549210e-08,
  1.819106755577117e-08,  1.769152291473747e-10, -3.403831560656919e-12, -8.765230757198717e-14,  3.303123689482838e-16,  3.850006241708825e-17,  4.101266287223181e-19,
 -8.446571146102025e-21,  1.924802409670814e+00, -2.773096237047243e-03, -6.963388183082043e-05, -1.343689508487611e-06, -1.875394057019767e-08, -1.103049384760796e-10,
  3.374006317867414e-12,  1.417755760782990e-13,  2.940727690408611e-15,  3.225831484666056e-17, -2.047745845983302e-19, -1.900652361516364e-20,  2.294098241328360e-02,
 -2.726222551734980e-04,  2.407394191798312e-06, -1.893343127775623e-08,  1.328273694996472e-10, -9.734201801663203e-13,  6.843648106932012e-15,  3.535541664117194e-17,
  2.460992845048181e-18,  2.906119703969228e-20, -2.853729040359551e-22, -2.204553812593396e-23,  6.805154972056617e-02, -8.037560332047489e-04,  6.967295859891205e-06,
 -5.282914487882507e-08,  3.459992367788309e-10, -2.318335447126624e-12,  1.432278150650105e-14,  1.652126626514581e-16,  6.916671024985543e-18,  9.199735375113425e-20,
 -8.872365233675540e-22, -6.632414304344460e-23,  1.363156634889046e-01, -1.594376063009224e-03,  1.340832692637522e-05, -9.544054595513577e-08,  5.470645382003264e-10,
 -2.982910978910578e-12,  1.232649958015586e-14,  4.831237667908502e-16,  1.315173754555925e-17,  1.967387882156551e-19, -1.842996644944898e-21, -1.364213929931259e-22,
  2.285046956771174e-01, -2.634924272982080e-03,  2.116466227121261e-05, -1.355978020138130e-07,  5.870213453018631e-10, -1.503292276810194e-12, -9.851528574882866e-15,
  1.047672617781175e-15,  2.193431415824003e-17,  3.435050882548950e-19, -3.096500722271214e-21, -2.385023223412513e-22,  3.456864829036279e-01, -3.907214402173442e-03,
  2.930193722549426e-05, -1.560524993240066e-07,  2.636072681130536e-10,  3.560633454156192e-12, -5.394644967292873e-14,  1.753019468845700e-15,  3.648310003859966e-17,
  5.201377471973799e-19, -4.536679943105751e-21, -3.816032168547549e-22,  4.892631102760273e-01, -5.377016510764041e-03,  3.629290800865796e-05, -1.313446740414858e-07,
 -6.543754944237794e-10,  1.246349844127253e-11, -9.260935799260587e-14,  2.134819867631934e-15,  6.322779139564040e-17,  7.275486857107101e-19, -6.483373865026116e-21,
 -5.742733484182737e-22,  6.609860885618252e-01, -6.978918073170135e-03,  3.961588201259976e-05, -2.599927636176504e-08, -2.318143804074623e-09,  2.126772261755748e-11,
 -3.349380198362666e-14,  1.313751168944100e-15,  1.064133800674687e-16,  1.112349765048561e-18, -1.094744069463087e-20, -8.273544283911033e-22,  8.628784491488385e-01,
 -8.583911736935141e-03,  3.505470948818331e-05,  2.019364098318639e-07, -4.418020838456120e-09,  1.497044392705715e-11,  3.056297106756232e-13, -6.921410596329072e-16,
  1.394495097706884e-16,  2.244784119036051e-18, -2.002662712494660e-20, -1.241439393336571e-21,  1.096804019885017e+00, -9.925441928791984e-03,  1.566168963015412e-05,
  5.687735759712011e-07, -5.003696418465746e-09, -4.191475451581970e-11,  9.485435490028117e-13,  4.279881496293839e-15,  5.799832359757055e-17,  4.124878502068349e-18,
 -7.340983196705506e-21, -2.216724286664846e-21,  1.362692004644730e+00, -1.042241916906887e-02, -2.826185641434358e-05,  9.043894342077003e-07,  2.140062958830649e-09,
 -1.638085873665849e-10, -1.730404318535473e-15,  4.051529578927404e-14,  1.994625459244950e-16, -2.093406387817854e-18,  2.777705088780579e-20, -1.597662571139970e-21,
  1.651178903257454e+00, -8.801411742267637e-03, -9.535181081888223e-05,  2.906204326125294e-07,  2.072560655575403e-08,  6.833817135240040e-11, -5.484507737402053e-12,
 -5.269387668350415e-14,  1.887655575511134e-15,  4.372534292987531e-17, -2.363224132193224e-19, -2.023856775963554e-20,  1.912486384801148e+00, -3.399897015939245e-03,
 -8.761290711139755e-05, -1.655447816693197e-06, -1.976958152976306e-08,  2.990914396605704e-11,  8.812760375507224e-12,  2.507800555439945e-13,  3.681269314715925e-15,
 -7.631487280639277e-19, -1.673623542990215e-18, -4.996876334892709e-20,  2.188762188974985e-02, -2.542371965544237e-04,  2.192332223938295e-06, -1.695450860084022e-08,
  1.151312633107595e-10, -7.875599004408832e-13,  9.064953458869814e-15,  1.263894685794485e-16,  3.013853875854825e-18, -7.657807227466562e-21, -1.689113215595826e-21,
 -4.065526017616795e-23,  6.494411568895191e-02, -7.504627462531205e-04,  6.365097905147429e-06, -4.764335552516241e-08,  3.035855371489541e-10, -1.891412520126695e-12,
  2.245809248981152e-14,  4.259002258942104e-16,  8.722769840997356e-18, -1.972148217377391e-20, -5.118008358373523e-21, -1.226538661657900e-22,  1.301456432450649e-01,
 -1.491546195266011e-03,  1.231365671112901e-05, -8.714317416767587e-08,  4.917310448013538e-10, -2.471484917674340e-12,  3.263031003833067e-14,  9.891077235889450e-16,
  1.712323769024916e-17, -3.386984887427186e-20, -1.055256346074935e-20, -2.526520240042755e-22,  2.182935501148595e-01, -2.471958312186292e-03,  1.959283989152833e-05,
 -1.264472994059188e-07,  5.574206918072827e-10, -1.298404732568647e-12,  3.086052864877689e-14,  1.899119680359606e-15,  2.895334869920347e-17, -5.448440778716707e-20,
 -1.831291907540849e-20, -4.413788441551858e-22,  3.305147041989026e-01, -3.680212674824572e-03,  2.745678743790439e-05, -1.513161635821240e-07,  3.265963401562354e-10,
  3.001977978981413e-12,  1.382708791107836e-14,  3.146011608930261e-15,  4.695402902051714e-17, -9.987703366116553e-20, -2.888026269827874e-20, -7.062907982799431e-22,
  4.683255214182803e-01, -5.093137502652233e-03,  3.466185265314189e-05, -1.399165664696798e-07, -4.212166727730047e-10,  1.120781724619168e-11, -1.260725259563018e-15,
  4.468195145595413e-15,  7.721914930696081e-17, -1.946613021647594e-19, -4.333409441791030e-20, -1.072567488944374e-21,  6.337014466431229e-01, -6.663837382547692e-03,
  3.909529589334631e-05, -5.971055931226137e-08, -1.895720060780610e-09,  2.132203546242446e-11,  5.589933862625350e-14,  5.189708248578750e-15,  1.276370903966640e-16,
 -2.901159092898180e-19, -6.475334804479136e-20, -1.577325316864175e-21,  8.291173614700708e-01, -8.294957463431025e-03,  3.706499364672722e-05,  1.340452499504055e-07,
 -4.043937470658317e-09,  2.264336373100739e-11,  3.590494476916259e-13,  4.781170271948189e-15,  1.895462861527050e-16,  8.889205559553649e-21, -9.987728113079977e-20,
 -2.331405447074285e-21,  1.057394070973773e+00, -9.774263736354476e-03,  2.198308472373404e-05,  4.832911869065453e-07, -5.602992477173484e-09, -1.737207656188554e-11,
  1.115021589930209e-12,  8.232484263047926e-15,  1.728803695083112e-16,  1.355341990582853e-18, -1.433429738943099e-19, -3.858432065286950e-21,  1.320619367750181e+00,
 -1.060476826947832e-02, -1.731077487710200e-05,  9.128166403862581e-07, -1.041190372912643e-09, -1.495824659658930e-10,  1.211094215048208e-12,  4.569465270467181e-14,
  1.157913315262587e-16, -3.637346420182156e-18, -1.354468703178243e-19, -5.704303730965606e-21,  1.614477749149074e+00, -9.544583603770581e-03, -8.985380713243757e-05,
  6.256512341077196e-07,  2.069764395837808e-08, -7.282547337263729e-11, -5.901288899200776e-12,  2.922042830384969e-14,  3.061454731816771e-15,  1.496772961440059e-17,
 -1.210412097483947e-18, -2.132134258577562e-20,  1.897351754246970e+00, -4.185506162636263e-03, -1.093121073932034e-04, -1.952862683964911e-06, -1.642093779679065e-08,
  3.383837896223916e-10,  1.735964908939383e-11,  3.503147552703981e-13,  1.828441934432890e-15, -1.212866826048707e-16, -4.537666482094029e-18, -7.378688936252739e-20,
  2.090450461353719e-02, -2.374821530222382e-04,  1.999452964777180e-06, -1.522520652224646e-08,  1.018955615408300e-10, -5.174465576714332e-13,  1.379865287175426e-14,
  2.017469250999255e-16,  1.073288441605402e-18, -1.123754216312117e-19, -3.503309247854796e-21, -3.373165935872921e-23,  6.204059842872643e-02, -7.017489311362703e-04,
  5.821380775342758e-06, -4.305472994703887e-08,  2.722673843823104e-10, -1.180113177714659e-12,  3.783929984499903e-14,  6.431879231267744e-16,  2.973489071043224e-18,
 -3.365942623996193e-19, -1.059622425834256e-20, -1.019994759497167e-22,  1.243700383724484e-01, -1.397089492182445e-03,  1.131367976459354e-05, -7.961788225945585e-08,
  4.526787375019661e-10, -1.298695738998298e-12,  6.710184372491048e-14,  1.413471042091747e-15,  5.515044502539647e-18, -6.871398514133889e-19, -2.184926218544914e-20,
 -2.107859031926513e-22,  2.087098042047612e-01, -2.321135059966235e-03,  1.812831186171410e-05, -1.176761882739478e-07,  5.436781804042055e-10,  1.772075971514987e-13,
  9.547599728925978e-14,  2.613364615789911e-15,  8.928682123868357e-18, -1.191105933607191e-18, -3.807220938589872e-20, -3.698181468923839e-22,  3.162217938422716e-01,
 -3.467727876141747e-03,  2.567447534803840e-05, -1.455594035728899e-07,  3.979188961249883e-10,  4.547822793268315e-12,  1.204554619068828e-13,  4.304813077645718e-15,
  1.475413491115861e-17, -1.902348027722197e-18, -6.055528012590532e-20, -5.953978261473529e-22,  4.484967883718378e-01, -4.822655991463662e-03,  3.294993675552532e-05,
 -1.448170847137593e-07, -1.858646108394533e-10,  1.293729485353123e-11,  1.544490779123544e-13,  6.396389117312409e-15,  2.713187871619725e-17, -2.912993573559249e-18,
 -9.159904500607070e-20, -9.127061319403660e-22,  6.076663995521221e-01, -6.354423597064382e-03,  3.821124302577259e-05, -8.650027887070237e-08, -1.441825219716574e-09,
  2.483788739060934e-11,  2.524404039053670e-13,  8.465375149300227e-15,  5.305400026120330e-17, -4.333922915347121e-18, -1.361153082413714e-19, -1.359244503139931e-21,
  7.965392556248277e-01, -7.993065558341868e-03,  3.830193333129473e-05,  7.349092942996402e-08, -3.490628098622623e-09,  3.351999865487875e-11,  5.711808834473622e-13,
  9.871281486367604e-15,  9.206618577477016e-17, -6.135036350520345e-18, -2.054287832404864e-19, -2.018059944326778e-21,  1.018683301580429e+00, -9.576741619231752e-03,
  2.723817753678628e-05,  3.924075053085917e-07, -5.660906801510088e-09,  1.277673384084583e-11,  1.420439399083755e-12,  1.309468776995747e-14,  7.599240901091952e-17,
 -7.897691264879256e-18, -3.158227287959459e-19, -3.300553719590219e-21,  1.277992012345127e+00, -1.069993739498381e-02, -6.549335806441878e-06,  8.742441937828105e-07,
 -3.637069078597822e-09, -1.049155189193306e-10,  2.512206178925569e-12,  4.572368981650310e-14, -1.794772721637023e-16, -1.468382210481415e-17, -4.202431214652088e-19,
 -6.030414482393915e-21,  1.574917044947704e+00, -1.022791153173949e-02, -8.043076417685110e-05,  9.379462833945728e-07,  1.794906891414004e-08, -1.934463710069354e-10,
 -3.706903129885195e-12,  1.248246090528053e-13,  2.534052993769454e-15, -4.849984981681875e-17, -1.837226083856770e-18, -4.096660560911592e-21,  1.878706896563262e+00,
 -5.157528691658171e-03, -1.340169502965458e-04, -2.135430520768698e-06, -4.680431233309359e-09,  8.738957657952645e-10,  2.704675707653350e-11,  2.980638092302508e-13,
 -6.501312788943405e-15, -3.559567606291652e-16, -6.589008630796320e-18,  1.258086844544489e-20,  1.998544838311540e-02, -2.221902836188149e-04,  1.826254522595949e-06,
 -1.365774292110827e-08,  9.531635684784842e-11, -1.193717562314965e-13,  1.911498610320660e-14,  1.423483446610895e-16, -5.701712152881355e-18, -2.641456980478254e-19,
 -3.439961127353980e-21,  5.577059413167318e-23,  5.932357526397349e-02, -6.571718978450996e-04,  5.330259466068436e-06, -3.883178438226712e-08,  2.592021453193591e-10,
 -5.939688480494183e-14,  5.473822458059521e-14,  4.566906265084864e-16, -1.740111379779060e-17, -7.958262525910264e-19, -1.041984530063380e-20,  1.678867714047062e-22,
  1.189568203448435e-01, -1.310279922272117e-03,  1.040118550225355e-05, -7.248185279663690e-08,  4.459979611798301e-10,  7.773794945948396e-13,  1.041505026665107e-13,
  1.013110756730718e-15, -3.625742159502491e-17, -1.634961355672240e-18, -2.154378318680019e-20,  3.438897590922986e-22,  1.997065838618108e-01, -2.181607939633901e-03,
  1.676897900706534e-05, -1.087996391007397e-07,  5.760220907895422e-10,  3.328262768540811e-12,  1.639713114380276e-13,  1.897267879002115e-15, -6.366866448269163e-17,
 -2.845633599896340e-18, -3.770561586427796e-20,  5.943618397964665e-22,  3.027507748776179e-01, -3.269202553582522e-03,  2.396958525780021e-05, -1.382670168062979e-07,
  5.274909942709860e-10,  8.857532021189988e-12,  2.337495282179499e-13,  3.178321268602500e-15, -1.010824936125950e-16, -4.541210499057571e-18, -6.035199631882432e-20,
  9.362671360431252e-22,  4.297223138694314e-01, -4.566036995102205e-03,  3.120364714208979e-05, -1.454583929451631e-07,  1.244547532343913e-10,  1.876765246354553e-11,
  3.245536254710486e-13,  4.824865983012895e-15, -1.495136025647612e-16, -6.917678103328743e-18, -9.198597480448433e-20,  1.398713140581035e-21,  5.828530103350368e-01,
 -6.053237543917063e-03,  3.705250747188188e-05, -1.051844304979054e-07, -8.650470442318110e-10,  3.374863447202225e-11,  4.817785469891113e-13,  6.533804926976514e-15,
 -2.097507717095315e-16, -1.029771094108240e-17, -1.376136930054890e-19,  2.037960690181019e-21,  7.651841430890738e-01, -7.684015708469437e-03,  3.887352436241131e-05,
  2.384566486327277e-08, -2.660119979691238e-09,  5.061379751370775e-11,  8.435463627755441e-13,  7.574922390127728e-15, -2.898693797525783e-16, -1.513786912293490e-17,
 -2.088402979075450e-19,  2.966666382081290e-21,  9.808398366514762e-01, -9.341508326201097e-03,  3.141839648802921e-05,  3.058548646894107e-07, -5.034798873435944e-09,
  5.118631486344838e-11,  1.759733607185206e-12,  8.333456011173286e-15, -4.580656638888386e-16, -2.191626782231608e-17, -3.303643296889414e-19,  4.308553298119376e-21,
  1.235152338424915e+00, -1.071149374292642e-02,  3.534948339993191e-06,  8.029566521334500e-07, -5.034633784257298e-09, -3.052375585411072e-11,  3.606991090732786e-12,
  2.787317196205151e-14, -1.056020493690698e-15, -3.453665682007643e-17, -4.870990203447078e-19,  5.835706026595743e-21,  1.532796263615909e+00, -1.082177303803013e-02,
 -6.759204209213289e-05,  1.190673703395059e-06,  1.351224945463977e-08, -2.334276060540796e-10,  5.603107298190331e-13,  1.639605414025920e-13, -4.978602851244237e-16,
 -1.165135596020174e-16, -1.305291095348488e-18,  3.144557849533750e-20,  1.855770474973747e+00, -6.331868784711504e-03, -1.593940518211302e-04, -2.032979282924038e-06,
  1.978665959552288e-08,  1.586104194906880e-09,  3.021825888314322e-11, -1.603834514131398e-13, -2.323099419470825e-14, -5.279593784093708e-16,  4.885591970866208e-19,
  3.529296207479887e-19,  1.912490590472023e-02, -2.082099077468619e-04,  1.671516482012940e-06, -1.212599107029823e-08,  9.769260914174399e-11,  3.570374177104917e-13,
  1.897007675600926e-14, -2.109575184082827e-16, -1.662262853046730e-17, -2.991765292237937e-19,  3.177950576066374e-21,  2.569872769865025e-22,  5.677732062658070e-02,
 -6.163228555915108e-04,  4.889361836482478e-06, -3.461982259992485e-08,  2.717407868682271e-10,  1.316021646981852e-12,  5.497770394318410e-14, -6.153130010128650e-16,
 -5.034236752243668e-17, -9.033282921692138e-19,  9.546740309701217e-21,  7.760994307650954e-22,  1.138767849795367e-01, -1.230426156037535e-03,  9.575191127152839e-06,
 -6.507915321583228e-08,  4.879127372181222e-10,  3.427033115764571e-12,  1.065035096255325e-13, -1.206598160865000e-15, -1.040345607544212e-16, -1.861270460081940e-18,
  1.951343472084446e-20,  1.598455723410831e-21,  1.912404166911243e-01, -2.052515295760603e-03,  1.552160728172650e-05, -9.882432552557007e-08,  6.846198475227553e-10,
  7.567628661658573e-12,  1.715519630195931e-13, -1.986051657753032e-15, -1.818201483247786e-16, -3.250395723067317e-18,  3.368567553457648e-20,  2.786098739840383e-21,
  2.900471926787714e-01, -3.083923650656013e-03,  2.236791585393102e-05, -1.280835408563409e-07,  7.653684127721684e-10,  1.500515097900282e-11,  2.502810566874303e-13,
 -3.004621622354562e-15, -2.898986109721148e-16, -5.205247616801451e-18,  5.308247308356567e-20,  4.441658016476151e-21,  4.119464584883804e-01, -4.323324515064507e-03,
  2.948394686476296e-05, -1.400080317419934e-07,  5.847941877312186e-10,  2.738637584116318e-11,  3.512512613951409e-13, -4.453847337307609e-15, -4.375148791225788e-16,
 -7.959968522179484e-18,  7.935967586561269e-20,  6.738262113158621e-21,  5.592246471495660e-01, -5.762046012917678e-03,  3.573168579343608e-05, -1.129533175435978e-07,
 -6.512041944588832e-11,  4.637416804682302e-11,  5.090408694040895e-13, -6.878156063238723e-15, -6.395230444029544e-16, -1.192416875251302e-17,  1.150492739074636e-19,
  9.986599259591476e-21,  7.350709581792880e-01, -7.372522137322441e-03,  3.894140562786380e-05, -9.471751166121914e-09, -1.435947320703630e-09,  7.180419968647463e-11,
  8.346886510669587e-13, -1.160200277908857e-14, -9.264953971196661e-16, -1.779394821617978e-17,  1.634544891622643e-19,  1.479906660548894e-20,  9.439979309502028e-01,
 -9.076756636498618e-03,  3.464665329984747e-05,  2.358219929480082e-07, -3.581778803646390e-09,  9.375737652432382e-11,  1.654504285203110e-12, -2.086054042868665e-14,
 -1.397617413916145e-15, -2.662053110553746e-17,  2.294156224842062e-19,  2.249665353699941e-20,  1.192421992567446e+00, -1.064605651138540e-02,  1.268271873507265e-05,
  7.224029963790215e-07, -4.741251606267955e-09,  6.032784495116203e-11,  3.705640649177760e-12, -2.863379198342279e-14, -2.520092649697648e-15, -4.114675379046038e-17,
  3.791222886261539e-19,  3.600475201847226e-20,  1.488522925966604e+00, -1.130202433190527e-02, -5.215440446679937e-05,  1.371727902246479e-06,  9.323233674321133e-09,
 -1.708427503253540e-10,  4.245682180200334e-12,  7.442104939367088e-14, -5.163943967900082e-15, -1.259685386540609e-16,  1.238782115088734e-18,  8.666028888852723e-20,
  1.827749270267688e+00, -7.696569823179587e-03, -1.807240984020391e-04, -1.426466272790416e-06,  5.789204865149044e-08,  2.156920301427736e-09,  1.270396589349254e-11,
 -1.165982503926955e-12, -3.698243236455783e-14, -7.423014675545699e-17,  2.461247322429898e-17,  6.623606759666620e-19,  1.831792737618273e-02, -1.953925624272757e-04,
  1.535690511510058e-06, -1.048425014242725e-08,  1.085599958934463e-10,  6.728665660667292e-13,  4.316811027533171e-15, -8.652660559222281e-16, -2.190089477113261e-17,
  1.025842532381297e-19,  1.750909720717287e-20,  3.278008776449430e-22,  5.438773540686215e-02, -5.787933763686313e-04,  4.501087230939734e-06, -2.999919301276558e-08,
  3.088075221531231e-10,  2.221136353155703e-12,  1.126942239634262e-14, -2.596113652983830e-15, -6.630612050148518e-17,  3.087068097203394e-19,  5.288656023802758e-20,
  9.929557788290042e-22,  1.091035326554710e-01, -1.156809689750945e-03,  8.843743377605122e-06, -5.660430876422758e-08,  5.771025134826064e-10,  5.148789004152078e-12,
  1.801325073861563e-14, -5.298899413789592e-15, -1.370275503953728e-16,  6.315161379184369e-19,  1.089712585498734e-19,  2.054816964535257e-21,  1.832714702894570e-01,
 -1.932886978649523e-03,  1.440707527548032e-05, -8.646786091903993e-08,  8.688389120633302e-10,  1.026791525069242e-11,  2.032232228013065e-14, -9.140300071871366e-15,
 -2.397321237251560e-16,  1.087576862674063e-18,  1.900970204725083e-19,  3.605673728489085e-21,  2.780599767509818e-01, -2.910895451013353e-03,  2.091522136822156e-05,
 -1.131599101811599e-07,  1.112659208030588e-09,  1.880616959319349e-11,  1.353807484668429e-14, -1.442879065742308e-14, -3.833962228739724e-16,  1.698923730504697e-18,
  3.034938206293834e-19,  5.800438030903722e-21,  3.951145457525514e-01, -4.093969995447575e-03,  2.787935831772205e-05, -1.258853868967996e-07,  1.197551963917314e-09,
  3.251108331356410e-11, -4.359455493293306e-15, -2.175609988152295e-14, -5.822464776621264e-16,  2.493807696669997e-18,  4.613602887255813e-19,  8.903874746513552e-21,
  5.367396583621862e-01, -5.481557707488438e-03,  3.440246238773599e-05, -1.060232544709394e-07,  9.554904612354705e-10,  5.362659225787048e-11, -2.258774548576023e-14,
 -3.232654228278998e-14, -8.600099986434602e-16,  3.516374200444410e-18,  6.852002317970152e-19,  1.339497613799905e-20,  7.062028126784105e-01, -7.061720717545219e-03,
  3.874034815230262e-05, -2.004738800151212e-08,  1.546001592509855e-10,  8.407698461692742e-11,  1.588081765240388e-14, -4.875556702726173e-14, -1.261952146375953e-15,
  4.898223679930946e-18,  1.015798246901046e-18,  2.022390003047365e-20,  9.082620017880463e-01, -8.789083061682587e-03,  3.720075074292710e-05,  1.953723735431765e-07,
 -1.386334839098126e-09,  1.206345624229105e-10,  3.256901495541863e-13, -7.688304614488119e-14, -1.904094894309690e-15,  7.313087954444221e-18,  1.540993386827199e-18,
  3.151819844969873e-20,  1.150093929944659e+00, -1.051108802071953e-02,  2.095068915243917e-05,  6.605752193366084e-07, -2.762526268204977e-09,  1.293529835783156e-10,
  1.593838550852711e-12, -1.263891191145635e-13, -3.263665070847580e-15,  1.429592560703210e-17,  2.527104632044390e-18,  5.253213974001688e-20,  1.442587895015300e+00,
 -1.165110243918399e-02, -3.489244189056723e-05,  1.499424988923481e-06,  6.981735833306793e-09, -6.625992562167018e-11,  3.450229733607400e-12, -1.454553217226302e-13,
 -7.755798201866037e-15,  1.325914323170771e-17,  5.889330716303128e-18,  1.057636771711636e-19,  1.793989603877017e+00, -9.191764963469106e-03, -1.908428634402400e-04,
 -1.519806004010207e-07,  1.007624091417777e-07,  1.941967522678557e-09, -3.525326751478706e-11, -2.150803881917115e-12, -1.590732584263411e-14,  1.359477520540448e-15,
  4.062007538792695e-17, -2.301708358793814e-19,  1.756017439679085e-02, -1.835797410653478e-04,  1.420737858886537e-06, -8.643568500777394e-09,  1.207157029986338e-10,
  4.153904976837578e-13, -2.806773858320274e-14, -1.349611413024020e-15, -3.110686556218594e-18,  9.704914895596871e-19,  2.128228574253669e-20, -3.015803256595109e-22,
  5.214242234255998e-02, -5.441373118216271e-04,  4.172178679391766e-06, -2.471693443557654e-08,  3.489104996564383e-10,  1.406225933143285e-12, -8.613404735667414e-14,
 -4.064394539689172e-15, -9.555514678228857e-18,  2.933255049262292e-18,  6.443107523281638e-20, -9.088031993439786e-22,  1.046137236346081e-01, -1.088612083624946e-03,
  8.223209749742205e-06, -4.658213788835707e-08,  6.700338417295291e-10,  3.360029587298583e-12, -1.814762043459226e-13, -8.338959321000530e-15, -2.014564663785936e-17,
  6.048871137843600e-18,  1.332264849187811e-19, -1.865749185994430e-21,  1.757642178515295e-01, -1.821529222190732e-03,  1.345945899820561e-05, -7.099865066031089e-08,
  1.054230595572782e-09,  6.912896760491659e-12, -3.251576111056663e-13, -1.447167236869310e-14, -3.606983442217593e-17,  1.056099788937515e-17,  2.335412696669457e-19,
 -3.238112745385580e-21,  2.667429024829107e-01, -2.748674790359750e-03,  1.967615502802871e-05, -9.249139292423674e-08,  1.452722260505808e-09,  1.304759470516987e-11,
 -5.339107726588872e-13, -2.297853047784171e-14, -5.902052948532805e-17,  1.687179425896087e-17,  3.752365737154837e-19, -5.134675529975405e-21,  3.791756917524307e-01,
 -3.876603687646863e-03,  2.650448555804830e-05, -1.017710166261452e-07,  1.787373234765555e-09,  2.321772534752180e-11, -8.317573338865151e-13, -3.477681394730670e-14,
 -9.121501829224177e-17,  2.565421500081108e-17,  5.750992854836396e-19, -7.738452444173379e-21,  5.153562811780693e-01, -5.211087653782020e-03,  3.325624039961415e-05,
 -8.254474663428158e-08,  1.934479382149063e-09,  3.944388267827958e-11, -1.250632344157211e-12, -5.160368564042118e-14, -1.352893942132091e-16,  3.809849793029218e-17,
  8.630936508080535e-19, -1.137526641779842e-20,  6.785744766161508e-01, -6.752592845407190e-03,  3.856872383621911e-05, -4.641863006494586e-09,  1.707626350587540e-09,
  6.399401195455575e-11, -1.823644097765073e-12, -7.706283693850812e-14, -1.944051294194648e-16,  5.653778033499159e-17,  1.296970477931298e-18, -1.668725727907688e-20,
  8.737154377281460e-01, -8.482294253017598e-03,  3.949084367421612e-05,  1.920692197050189e-07,  8.973425623709165e-10,  9.646088790451581e-11, -2.542225795867008e-12,
 -1.194850936254895e-13, -2.792250043407181e-16,  8.642716741216399e-17,  2.001540756406266e-18, -2.519142586759639e-20,  1.108434199769519e+00, -1.031232297613262e-02,
  2.870072450507917e-05,  6.377478411528626e-07, -1.357046847392899e-10,  1.146089763211973e-10, -3.168170516280508e-12, -1.993569957384001e-13, -5.058190497183985e-16,
  1.448322617095613e-16,  3.310675147936089e-18, -4.215188932856650e-20,  1.395541736773802e+00, -1.185645087843916e-02, -1.626320380484139e-05,  1.603164171412284e-06,
  6.018187359089797e-09, -5.811228288263055e-11, -3.657362069649938e-12, -3.333556772610095e-13, -2.234567797721942e-15,  3.025430701812023e-16,  7.029332828402392e-18,
 -1.064783947739269e-19,  1.754199589694148e+00, -1.069584596894464e-02, -1.819176172947194e-04,  1.704133129329586e-06,  1.261949942328570e-07,  3.710094100572004e-10,
 -9.329271207381644e-11, -1.617590573023497e-12,  5.454250416354552e-14,  2.197046008651028e-15, -1.299392468760154e-17, -2.100506759342232e-18,  1.684797713790398e-02,
 -1.725955642234659e-04,  1.328724755568196e-06, -6.694842084860851e-09,  1.193235000828504e-10, -6.857886414626018e-13, -6.107018812909316e-14, -7.707340671330600e-16,
  4.108264328425597e-17,  1.244544075986644e-18, -1.456158918104046e-20, -1.215134916348532e-21,  5.003088511600296e-02, -5.118501736536534e-04,  3.909530971284575e-06,
 -1.905960197611803e-08,  3.474357178757490e-10, -1.948820754956890e-12, -1.855319015973012e-13, -2.318763881268916e-15,  1.241006590909846e-16,  3.765744469236907e-18,
 -4.398591409763170e-20, -3.680020617503053e-21,  1.003875680281017e-01, -1.024876918778032e-03,  7.729784606455529e-06, -3.563844234546219e-08,  6.753594696680595e-10,
 -3.638322206498004e-12, -3.854366516117759e-13, -4.750220387420157e-15,  2.557531127352675e-16,  7.779160126649540e-18, -9.063886571171770e-20, -7.613357042108519e-21,
  1.686884707921269e-01, -1.716967658004206e-03,  1.271149923408836e-05, -5.358396839609257e-08,  1.082646959449389e-09, -5.478781916383345e-12, -6.791518906608421e-13,
 -8.226865539071370e-15,  4.463337613171899e-16,  1.361560784316785e-17, -1.581392516177322e-19, -1.335603811363892e-20,  2.560565694404856e-01, -2.595295761384711e-03,
  1.871148636277903e-05, -6.807096002887287e-08,  1.535022769554436e-09, -7.052806933101621e-12, -1.095995752664026e-12, -1.302953234801637e-14,  7.131888748438737e-16,
  2.182410278829178e-17, -2.525654675377192e-19, -2.148232958369801e-20,  3.640863361930893e-01, -3.668940027714836e-03,  2.546573928075462e-05, -7.086753630542435e-08,
  1.975646091372444e-09, -7.773196489791630e-12, -1.682268779172497e-12, -1.966059905436013e-14,  1.086092596015146e-15,  3.332696272217387e-17, -3.843663405994368e-19,
 -3.297631845147896e-20,  4.950385626043392e-01, -4.948426752617622e-03,  3.247083985620200e-05, -4.739466652146541e-08,  2.309765490539918e-09, -6.932368320168261e-12,
 -2.511938012619086e-12, -2.908107708102622e-14,  1.619051713756598e-15,  4.975195954157456e-17, -5.727688544076122e-19, -4.961825760867208e-20,  6.521816121516262e-01,
 -6.443723169103237e-03,  3.870951044637625e-05,  2.982205756669671e-08,  2.380527247056639e-09, -4.188103171136293e-12, -3.705222578770343e-12, -4.331784183370398e-14,
  2.419055825331067e-15,  7.423293620395873e-17, -8.575939624640789e-19, -7.493244847517624e-20,  8.404332154251503e-01, -8.156784599349782e-03,  4.193168333525819e-05,
  2.174313088662559e-07,  1.954155900224873e-09, -2.369436305987445e-12, -5.456593112253448e-12, -6.719715539283023e-14,  3.725893239840428e-15,  1.137250739148363e-16,
 -1.338630403978429e-18, -1.169359785892637e-19,  1.067692720679142e+00, -1.005200414751988e-02,  3.639781635411373e-05,  6.479214982961449e-07,  9.578338718564390e-10,
 -2.465627500525180e-11, -8.047155757846771e-12, -1.133326683644024e-13,  6.166634850220752e-15,  1.879383793918253e-16, -2.354211924387868e-18, -1.985671739987863e-19,
  1.347979698640740e+00, -1.190810284434653e-02,  3.490003075081118e-06,  1.682214398189415e-06,  3.229044795892971e-09, -2.543234810367719e-10, -1.205421893018315e-11,
 -1.922059011805160e-13,  1.157115657804230e-14,  3.794321525666461e-16, -5.640184876383153e-18, -4.250326626949843e-19,  1.708683172305779e+00, -1.203534891929157e-02,
 -1.495341353637265e-04,  3.649973748297079e-06,  1.088576720079429e-07, -2.149435101646407e-09, -1.040569601443505e-10,  1.106891291633732e-12,  1.016143208957055e-13,
 -1.431191140464141e-16, -9.412552548913654e-17, -7.373324334616182e-19,  1.617838943370924e-02, -1.622562463009504e-04,  1.259118549461030e-06, -4.979222407911255e-09,
  9.012328034114713e-11, -2.227094470571829e-12, -5.891391181119002e-14,  1.045469049283415e-15,  6.299426840693248e-17, -3.172257231978499e-19, -5.651734326462481e-20,
 -2.592422485062224e-22,  4.804471582833961e-02, -4.813988900640659e-04,  3.712061929609175e-06, -1.406695399077122e-08,  2.614538801488690e-10, -6.626662523619453e-12,
 -1.787252984074416e-13,  3.170259667601522e-15,  1.904050223432804e-16, -9.610937688181423e-19, -1.711384718543135e-19, -7.862917613780593e-22,  9.640927613735888e-02,
 -9.645745315853197e-04,  7.362851412221468e-06, -2.594307654855953e-08,  5.050487515481333e-10, -1.334255602516693e-11, -3.705294365203644e-13,  6.569740775946006e-15,
  3.927193003015954e-16, -1.990376298031511e-18, -3.539719059954027e-19, -1.629806846099035e-21,  1.620203089628220e-01, -1.617567548852902e-03,  1.216580825367445e-05,
 -3.806797443196420e-08,  8.014283108048400e-10, -2.254794220309066e-11, -6.511915328521827e-13,  1.154485720771921e-14,  6.859913407634240e-16, -3.499699420823583e-18,
 -6.207247109304288e-19, -2.864123029990874e-21,  2.459701599097317e-01, -2.448474154100350e-03,  1.803250367327186e-05, -4.613761968660459e-08,  1.117383273546947e-09,
 -3.454535262933834e-11, -1.047773597979887e-12,  1.858980898457546e-14,  1.096989815018813e-15, -5.655445223441985e-18, -9.977686142001889e-19, -4.608927155598244e-21,
  3.498133663559918e-01, -3.468105044590515e-03,  2.479244115528779e-05, -4.279850602100035e-08,  1.396234581335228e-09, -4.989425998599154e-11, -1.603381288097501e-12,
  2.852109510445842e-14,  1.670962831786258e-15, -8.760218509165615e-18, -1.530095505249366e-18, -7.053751115812254e-21,  4.757616321979340e-01, -4.690339420026732e-03,
  3.210819417670113e-05, -1.497589004433065e-08,  1.538658132137346e-09, -6.974489290647286e-11, -2.387835204553980e-12,  4.274264766001555e-14,  2.488277470955388e-15,
 -1.340661884572997e-17, -2.298647883999252e-18, -1.049551776502152e-20,  6.270292026863268e-01, -6.132007188887558e-03,  3.927680470983611e-05,  6.218179774004746e-08,
  1.363572392673921e-09, -9.684874731626954e-11, -3.517164093844735e-12,  6.384884187219582e-14,  3.703926715639649e-15, -2.089370061281626e-17, -3.462623190642736e-18,
 -1.537094616731324e-20,  8.084941936316802e-01, -7.810414769053901e-03,  4.470277573701383e-05,  2.408487977689583e-07,  5.283097794118198e-10, -1.392699314417348e-10,
 -5.185358410330028e-12,  9.724784876772795e-14,  5.655295136843690e-15, -3.456970216980645e-17, -5.381372861016196e-18, -2.207775524262312e-20,  1.028116539401508e+00,
 -9.729569984865558e-03,  4.421273524782283e-05,  6.482009018291678e-07, -1.585612889803705e-09, -2.283911726973530e-10, -7.668803913782057e-12,  1.572554256033174e-13,
  9.211944422685741e-15, -6.540293148201570e-17, -9.065873342012491e-18, -2.860320205556633e-20,  1.300531570393707e+00, -1.179905245539986e-02,  2.376491454296491e-05,
  1.676530877167796e-06, -4.925108506868264e-09, -5.561888282467476e-10, -1.071507840023908e-11,  3.180860416953075e-13,  1.699188645488748e-14, -1.690891030198085e-16,
 -1.863745186711648e-17,  8.966240527008093e-22,  1.658463106421268e+00, -1.303088452881719e-02, -9.709822690831393e-05,  4.928925306788787e-06,  4.518875620761692e-08,
 -3.938403997875153e-09, -3.350091344154256e-11,  3.560124763401928e-12,  3.219041092706098e-14, -3.314349712217190e-15, -3.509338546874661e-17,  3.102615545030472e-18,
  1.554916151887038e-02, -1.524016062324172e-04,  1.206337437514222e-06, -3.956645462752026e-09,  3.488922362900953e-11, -3.087917342097901e-12, -6.176011586063996e-15,
  2.460730207753720e-15,  1.433972480808162e-17, -2.127766847354830e-18, -1.833218903595085e-20,  1.800858954633576e-21,  4.617752962081270e-02, -4.523178823471617e-04,
  3.563339977426772e-06, -1.113531924550613e-08,  9.646851756599533e-11, -9.240964139544932e-12, -1.906253299621097e-14,  7.444490521599717e-15,  4.307416613699268e-17,
 -6.441317976231865e-18, -5.532533205174090e-20,  5.461076497066253e-21,  9.266697570098158e-02, -9.068026261215507e-04,  7.089876583143131e-06, -2.039398660378052e-08,
  1.708756321880922e-10, -1.877041984244543e-11, -4.044694218283470e-14,  1.537392154114141e-14,  8.796222634269204e-17, -1.331745488844323e-17, -1.137983968028191e-19,
  1.132140733682717e-20,  1.557420550152742e-01, -1.521889430289235e-03,  1.176869849861239e-05, -2.955057743280865e-08,  2.320735530779606e-10, -3.210246296996271e-11,
 -7.292923221774839e-14,  2.689380583776996e-14,  1.514201393725394e-16, -2.334072432301576e-17, -1.978642645438634e-19,  1.991922851988189e-20,  2.364616269543044e-01,
 -2.306185036064229e-03,  1.755953995564998e-05, -3.490980182243019e-08,  2.358788775292390e-10, -4.993895197055240e-11, -1.200508785933510e-13,  4.306604247131178e-14,
  2.371375785532316e-16, -3.749205239951010e-17, -3.139876499376411e-19,  3.216636241287708e-20,  3.363347937435132e-01, -3.271527727099949e-03,  2.437418179357936e-05,
 -3.016027672498957e-08,  1.066878410562444e-10, -7.345815843081691e-11, -1.858158911353411e-13,  6.565318749096277e-14,  3.505457534824684e-16, -5.744321179598677e-17,
 -4.721084551178026e-19,  4.963980995998029e-20,  4.575132962502892e-01, -4.433897797578119e-03,  3.202155333974323e-05, -4.073401965189915e-09, -2.900626650373428e-10,
 -1.047651444536867e-10, -2.722158622178985e-13,  9.770524146533058e-14,  4.992816129160560e-16, -8.619490106323860e-17, -6.872906342536580e-19,  7.522488268638125e-20,
  6.031346253892499e-01, -5.814610203962205e-03,  4.007731517540013e-05,  6.474735236820378e-08, -1.209889690216340e-09, -1.480495593207236e-10, -3.685570823025134e-13,
  1.448943501036581e-13,  6.924401708724514e-16, -1.296172434049116e-16, -9.810737192604336e-19,  1.147104666891110e-19,  7.779859591828709e-01, -7.441337746359179e-03,
  4.753321184457571e-05,  2.215213901885864e-07, -3.185549892958440e-09, -2.131998646652968e-10, -4.028359325630968e-13,  2.189951725566158e-13,  9.302900639797275e-16,
 -2.007836117029631e-16, -1.374468533695368e-18,  1.814517304445446e-19,  9.899537898413524e-01, -9.345588175790617e-03,  5.166121949742668e-05,  5.783327173630442e-07,
 -7.483297445316993e-09, -3.309006753561460e-10,  2.934981930243223e-14,  3.490856214522486e-13,  1.113775230575828e-15, -3.351627104311123e-16, -1.800977469263835e-18,
  3.137579156970139e-19,  1.253839918563561e+00, -1.153071634836469e-02,  4.300880900005742e-05,  1.498779466770015e-06, -1.762329598400440e-08, -6.555097547925704e-10,
  3.939712679994527e-12,  6.361043273379566e-13, -1.760822162989081e-16, -6.640025674498191e-16, -9.655864909870881e-19,  6.697776066622871e-19,  1.605169906788221e+00,
 -1.356488905821515e-02, -3.625937988339032e-05,  5.012649715432072e-06, -3.342451698598075e-08, -3.542863198593930e-09,  6.234689319050192e-11,  2.687614202196699e-12,
 -7.855902769333778e-14, -1.992124596906854e-15,  8.798800648059663e-17,  1.377874010614282e-18,  1.495856307381238e-02, -1.429359649257822e-04,  1.160207180033888e-06,
 -3.877103677581234e-09, -2.280838085110776e-11, -2.429333682252676e-12,  5.755659048825776e-14,  1.713026806689955e-15, -5.585254405946282e-17, -1.276269257736526e-18,
  5.399812168668004e-20,  8.920781129326784e-22,  4.442444399957522e-02, -4.243332726724835e-04,  3.432991849593699e-06, -1.102435919303878e-08, -7.616260462621768e-11,
 -7.258803390988257e-12,  1.736017402113050e-13,  5.172235624100349e-15, -1.692173360639319e-16, -3.851590537769120e-18,  1.637621740375123e-19,  2.692535083764029e-21,
  8.915168173765549e-02, -8.510441905862492e-04,  6.849394533412388e-06, -2.056968751104320e-08, -1.796416728879716e-10, -1.470678266552650e-11,  3.569500865117965e-13,
  1.064771994047803e-14, -3.502855579457228e-16, -7.923320150942201e-18,  3.395387147853603e-19,  5.539544628982142e-21,  1.498405761871213e-01, -1.429143283730939e-03,
  1.141557610530636e-05, -3.081314503214056e-08, -3.670055058417619e-10, -2.505587083378128e-11,  6.210220903470144e-13,  1.854014793060255e-14, -6.149366343994669e-16,
 -1.378401202138263e-17,  5.974883775423187e-19,  9.636068450627667e-21,  2.275151780133749e-01, -2.167395110562032e-03,  1.713092176606838e-05, -3.887336203812582e-08,
 -6.949858461402085e-10, -3.875521035507588e-11,  9.884607212630543e-13,  2.949392356463815e-14, -9.898259836367591e-16, -2.190573354574030e-17,  9.650157212163981e-19,
  1.530420728197335e-20,  3.236362731303326e-01, -3.078063068492902e-03,  2.397494155899743e-05, -3.982593950005784e-08, -1.259848826663727e-09, -5.652224993773088e-11,
  1.498247416232014e-12,  4.454191806145150e-14, -1.520381431499616e-15, -3.304828175139719e-17,  1.489455080106915e-18,  2.304745429942389e-20,  4.402894217324660e-01,
 -4.178156720268998e-03,  3.187706995557574e-05, -2.490643091759375e-08, -2.232095349068497e-09, -7.955521127413721e-11,  2.221584808475598e-12,  6.538023154703274e-14,
 -2.288104260291386e-15, -4.846499248977787e-17,  2.257183261432725e-18,  3.365262984969081e-20,  5.805215855333229e-01, -5.491434220682164e-03,  4.064261983963055e-05,
  2.258915097468051e-08, -3.936245088322091e-09, -1.100372929980437e-10,  3.301959333252841e-12,  9.491083645312474e-14, -3.452310074740351e-15, -7.030643349834482e-17,
  3.440604324025980e-18,  4.832533309116513e-20,  7.489963329722832e-01, -7.051622674681429e-03,  4.974889619895432e-05,  1.379745509187438e-07, -7.060609515525661e-09,
 -1.525844819825325e-10,  5.075715767122541e-12,  1.383176675556210e-13, -5.368042004548809e-15, -1.023825136610109e-16,  5.433303674220544e-18,  6.861454355203136e-20,
  9.534384534263837e-01, -8.907060329524593e-03,  5.767348863295294e-05,  4.089475792144056e-07, -1.332866983198149e-08, -2.198480461388406e-10,  8.546554730906989e-12,
  2.045901963693165e-13, -9.009768378562796e-15, -1.507146076979305e-16,  9.338850050161393e-18,  9.351621437725453e-20,  1.208511097891263e+00, -1.112043193804940e-02,
  5.890224829944277e-05,  1.122832416268500e-06, -2.843877686647611e-08, -3.688323621168069e-10,  1.834529056168200e-11,  2.948529094084589e-13, -1.830501927533414e-14,
 -2.026311161253789e-16,  1.948263499324895e-17,  7.678990816885236e-20,  1.550692019937962e+00, -1.362820123687810e-02,  1.866498941600073e-05,  4.012178268597441e-06,
 -8.487872487652504e-08, -1.468087074634842e-09,  9.676290798210405e-11, -2.549847007017113e-13, -8.421281895457031e-14,  1.462145738308167e-15,  5.790879286240267e-17,
 -2.167735424290951e-18,  1.440507493605370e-02, -1.338497525151138e-04,  1.110167029992083e-06, -4.543390619612520e-09, -5.486222934861567e-11, -7.008270481199907e-13,
  7.679165442623874e-14, -3.598699652911494e-16, -6.013683683263529e-17,  9.449819879014809e-19,  4.098557523934291e-20, -1.237440861451280e-21,  4.278115922664970e-02,
 -3.974285904800912e-04,  3.289435823445259e-06, -1.314092966923481e-08, -1.714737565656156e-10, -2.046041651376835e-12,  2.314662143237522e-13, -1.099176271487686e-15,
 -1.816746122656725e-16,  2.872800732846349e-18,  1.237423504105928e-19, -3.759245048281567e-21,  8.585543783940777e-02, -7.973041701184115e-04,  6.577330680569574e-06,
 -2.525539436405495e-08, -3.712604978092534e-10, -3.992168075314640e-12,  4.753576246119375e-13, -2.305206284709253e-15, -3.743580406061667e-16,  5.978775541012594e-18,
  2.547277723279474e-19, -7.814967489511499e-21,  1.443041268136726e-01, -1.339429656313872e-03,  1.099704877368756e-05, -3.975201322765343e-08, -6.898258859723195e-10,
 -6.427602013730364e-12,  8.253312337893924e-13, -4.125295152683887e-15, -6.528508600942785e-16,  1.057669441519101e-17,  4.435528685441126e-19, -1.380318317281391e-20,
  2.191164053131217e-01, -2.032452119117618e-03,  1.657691700670865e-05, -5.469518442566351e-08, -1.186524962113069e-09, -9.145803792543737e-12,  1.309131752085396e-12,
 -6.823659134924074e-15, -1.041110160474196e-15,  1.720470332875771e-17,  7.057489521249478e-19, -2.240440255239010e-20,  3.117040141334779e-01, -2.888589413008614e-03,
  2.334600711629592e-05, -6.675804134561940e-08, -1.961182078645105e-09, -1.175777004149428e-11,  1.972856669344594e-12, -1.088971045373889e-14, -1.578442278741221e-15,
  2.680553726278311e-17,  1.066358060065348e-18, -3.480333474058451e-20,  4.240839452247977e-01, -3.925042468335779e-03,  3.132209945017700e-05, -6.999247006763264e-08,
 -3.188938936179019e-09, -1.349520812471021e-11,  2.896691591941544e-12, -1.729493466364970e-14, -2.331711640083688e-15,  4.112915986663145e-17,  1.566776715790694e-18,
 -5.317982636365488e-20,  5.592061548463313e-01, -5.166415424304377e-03,  4.047901551166411e-05, -5.303218792902035e-08, -5.200067939900727e-09, -1.272274300963028e-11,
  4.231744562788409e-12, -2.818227471465452e-14, -3.421983620527241e-15,  6.374061727629023e-17,  2.278249964859421e-18, -8.191725207058813e-20,  7.215933539537648e-01,
 -6.649113124918228e-03,  5.065019932133739e-05,  8.149284092407199e-09, -8.689504815314097e-09, -5.547003521587346e-12,  6.300666015876747e-12, -4.907200533277823e-14,
 -5.088994149951406e-15,  1.029879616608294e-16,  3.327896071665077e-18, -1.310642287235855e-19,  9.187586091553185e-01, -8.429922951879427e-03,  6.119613122915680e-05,
  1.729811610140038e-07, -1.539048699692071e-08,  1.905195009898525e-11,  9.945616622055075e-12, -9.805386354940641e-14, -7.866125935539497e-15,  1.831451857478654e-16,
  4.925155230761036e-18, -2.286485517456569e-19,  1.165045688597820e+00, -1.060344958698911e-02,  6.948489594833585e-05,  6.343030245881361e-07, -3.109525928248669e-08,
  1.028434708810407e-10,  1.833780412992124e-11, -2.659352999561616e-13, -1.302393685714733e-14,  4.074577910080204e-16,  6.844528663578915e-18, -4.804901649248616e-19,
  1.496748239340103e+00, -1.331082725573544e-02,  5.808434356180022e-05,  2.538239574513784e-06, -9.292020524783447e-08,  5.238882295074574e-10,  6.188350267180589e-11,
 -1.851806209327410e-12, -1.317853736893648e-14,  1.901724313148897e-15, -2.761427323071963e-17, -1.128541246524771e-18,  1.388707161106443e-02, -1.252018674497004e-04,
  1.050223672303452e-06, -5.440029218698307e-09, -5.222330512395244e-11,  8.437144598185546e-13,  4.647889403415201e-14, -1.538757048805352e-15, -1.081582112052966e-17,
  1.415771215349746e-18, -1.466682233818609e-20, -8.994378374965310e-22,  4.124300953674656e-02, -3.717917532389236e-04,  3.114856688655496e-06, -1.593083629355339e-08,
 -1.622284796334856e-10,  2.604005112835400e-12,  1.396389967639646e-13, -4.652316022678481e-15, -3.225146754393194e-17,  4.279728949378942e-18, -4.481060091888234e-20,
 -2.713633486067991e-21,  8.276939331032865e-02, -7.460010046102175e-04,  6.237886115333499e-06, -3.125764609970439e-08, -3.481995665877610e-10,  5.539526083126879e-12,
  2.852884943416042e-13, -9.599556188386883e-15, -6.506912125985745e-17,  8.827460934966964e-18, -9.397993477099091e-20, -5.579681052834275e-21,  1.391190704284453e-01,
 -1.253552121962675e-03,  1.045284755317046e-05, -5.081769676478359e-08, -6.400172729873490e-10,  1.007634185771762e-11,  4.916221820650386e-13, -1.677697290217454e-14,
 -1.099570375860080e-16,  1.541620014702503e-17, -1.680514817097974e-19, -9.699048854264717e-21,  2.112472100067170e-01, -1.902788264730281e-03,  1.580584049239884e-05,
 -7.355965592398606e-08, -1.087207249903346e-09,  1.693217361014180e-11,  7.716776960820910e-13, -2.684443252301869e-14, -1.674653517838299e-16,  2.463272463113421e-17,
 -2.772904006171687e-19, -1.539347346157476e-20,  3.005173623128081e-01, -2.705561226271340e-03,  2.235670947808131e-05, -9.763826198941843e-08, -1.772444882792599e-09,
  2.733152302370775e-11,  1.146129292086476e-12, -4.091390480773010e-14, -2.371646235051015e-16,  3.744671883542387e-17, -4.400752850075420e-19, -2.317237313954992e-20,
  4.088783871848868e-01, -3.678690036840320e-03,  3.017861044079147e-05, -1.196929569322468e-07, -2.839440628385058e-09,  4.346396879315698e-11,  1.648685182687218e-12,
 -6.095152890968526e-14, -3.151135975630951e-16,  5.552350509587065e-17, -6.913594126435010e-19, -3.385400837882044e-20,  5.391821472172911e-01, -4.846528877788622e-03,
  3.935170061693287e-05, -1.332097494148404e-07, -4.556070714350278e-09,  6.956284623009861e-11,  2.337323751366578e-12, -9.072880690891548e-14, -3.856313834389204e-16,
  8.191719208755251e-17, -1.104182346512661e-18, -4.877865834167733e-20,  6.958046391183892e-01, -6.245842452351773e-03,  4.993478745516276e-05, -1.243018678683677e-07,
 -7.477727206860159e-09,  1.148359400259559e-10,  3.320219701366570e-12, -1.384397313999378e-13, -3.905380274582641e-16,  1.227877694977309e-16, -1.853782861624557e-18,
 -7.010335881035741e-20,  8.860254286162649e-01, -7.936130212069724e-03,  6.184541033461431e-05, -5.860697287720278e-08, -1.296266556042256e-08,  2.033191769152547e-10,
  4.824501693968395e-12, -2.257340480754735e-13, -8.381836520841399e-17,  1.922733289838331e-16, -3.458832399408786e-18, -1.002513425786127e-19,  1.123780298159945e+00,
 -1.002528547679775e-02,  7.424816714300297e-05,  1.739516336544635e-07, -2.542262191456618e-08,  4.209688297381997e-10,  7.413117808105136e-12, -4.334008572183889e-13,
  2.014339056324231e-15,  3.270554776846201e-16, -8.104359855439906e-18, -1.248612575609075e-19,  1.444593107073505e+00, -1.274835917670298e-02,  8.018139742437783e-05,
  1.198269006845767e-06, -7.180154273662038e-08,  1.393181889957811e-09,  1.252842099826979e-11, -1.450224423484246e-12,  2.914813476916373e-14,  4.128921563452501e-16,
 -3.443741829916638e-17,  5.388494245652886e-19,  1.340263632107057e-02, -1.170738016438517e-04,  9.806425551605952e-07, -6.094800884724339e-09, -2.770593587220796e-11,
  1.444632665661208e-12,  5.068564936057486e-15, -1.236900490184219e-15,  2.355456345533390e-17,  4.177713488556908e-19, -2.662232064500597e-20,  2.513107014766273e-22,
  3.980441362877467e-02, -3.476767874586851e-04,  2.910298793225289e-06, -1.797248556340079e-08, -8.724496794164847e-11,  4.401050156450123e-12,  1.461377078915473e-14,
 -3.728574291779702e-15,  7.139969627720875e-17,  1.252324931314666e-18, -8.049471759127037e-20,  7.700476391776734e-22,  7.988269976625886e-02, -6.976826147720712e-04,
  5.833976002246417e-06, -3.566269019221723e-08, -1.908064828293756e-10,  9.184212333510207e-12,  2.788725682717444e-14, -7.657308997219170e-15,  1.479174912259624e-16,
  2.548642462769736e-18, -1.660868221391091e-19,  1.622111437497593e-21,  1.342680240526611e-01, -1.172523995563476e-03,  9.789880068737264e-06, -5.896557355174608e-08,
 -3.586517383724188e-10,  1.629111156054118e-11,  4.321807543896910e-14, -1.329151260980282e-14,  2.599683565579123e-16,  4.364314189993273e-18, -2.901849884186038e-19,
  2.917828866049917e-21,  2.038829829812736e-01, -1.780137129538670e-03,  1.483248400694711e-05, -8.749647673396772e-08, -6.242588339371627e-10,  2.654489089907165e-11,
  5.743043854886401e-14, -2.106572996284273e-14,  4.190988180736649e-16,  6.781386347075410e-18, -4.639335002637701e-19,  4.850658941614020e-21,  2.900447882636532e-01,
 -2.531826983626315e-03,  2.103670609518535e-05, -1.205202655901882e-07, -1.043249196685794e-09,  4.132064494295604e-11,  6.433922966931396e-14, -3.168509315252912e-14,
  6.450364631599797e-16,  9.906875991204782e-18, -7.057333632729873e-19,  7.768080948837562e-21,  3.946363989675319e-01, -3.443701599097256e-03,  2.850377107521833e-05,
 -1.565993170345878e-07, -1.711640955760334e-09,  6.301526950173296e-11,  5.122854723754946e-14, -4.633435418798721e-14,  9.732262042771706e-16,  1.385739290954030e-17,
 -1.047122617498285e-18,  1.233182525246808e-20,  5.204139445709645e-01, -4.539227334537070e-03,  3.736923362837806e-05, -1.927865169999695e-07, -2.806637141167129e-09,
  9.612296839709142e-11, -1.030880398247248e-14, -6.713315814394448e-14,  1.472871448939791e-15,  1.867384960652010e-17, -1.545693579931226e-18,  1.992125070732772e-20,
  6.716081651744815e-01, -5.854168387205837e-03,  4.781155959584503e-05, -2.225391510474963e-07, -4.690321828911070e-09,  1.500597515585597e-10, -1.920890873963979e-13,
 -9.825306629774723e-14,  2.297072207818056e-15,  2.391406684538532e-17, -2.316578708848805e-18,  3.381373940079190e-20,  8.552614487388875e-01, -7.447366429575780e-03,
  6.004655270407358e-05, -2.292705176227940e-07, -8.228745859402249e-09,  2.482571986190635e-10, -7.142915957898925e-13, -1.491629207856298e-13,  3.856628646482072e-15,
  2.644980475386603e-17, -3.618822087313258e-18,  6.347178901699319e-20,  1.084871483839725e+00, -9.429182276501788e-03,  7.419346673231440e-05, -1.596673513917396e-07,
 -1.613184196110170e-08,  4.690578393542008e-10, -2.522030028598028e-12, -2.467010942693209e-13,  7.687154878967467e-15,  3.502621851539449e-18, -6.085869940154309e-18,
  1.462207829456243e-19,  1.394948921023197e+00, -1.206675781622895e-02,  8.860715375646644e-05,  2.768733237319901e-07, -4.364766351048158e-08,  1.317512517169770e-09,
 -1.437489536679497e-11, -4.922418267827966e-13,  2.585160608424448e-14, -4.100415829567790e-16, -7.133015079505138e-18,  5.109108889347959e-19,  1.294956043717578e-02,
 -1.095265607022060e-04,  9.057918094799483e-07, -6.310476875342543e-09,  7.252478029729082e-14,  1.243111371437110e-12, -1.804639616500482e-14, -4.177129555696940e-16,
  2.332222685541644e-17, -3.059857912313990e-19, -8.436351835531145e-21,  4.205047356975618e-22,  3.845888063334550e-02, -3.252741497787328e-04,  2.689134820550765e-06,
 -1.867569973552805e-08, -2.736043120683280e-12,  3.778765147717713e-12, -5.493353692347219e-14, -1.251468900188795e-15,  7.038643467199113e-17, -9.302248113703377e-19,
 -2.529902717133474e-20,  1.270999438201178e-21,  7.718254759998668e-02, -6.527606393273943e-04,  5.393711183069882e-06, -3.727235919040401e-08, -1.482466206772589e-11,
  7.858981952204303e-12, -1.145149606145779e-13, -2.545226865175517e-15,  1.448144930636291e-16, -1.935822266032359e-18, -5.152060402071418e-20,  2.621036557371710e-21,
  1.297299794749836e-01, -1.097108282485845e-03,  9.058494867203101e-06, -6.214955500586991e-08, -4.739415986836058e-11,  1.387558007059969e-11, -2.029031661764775e-13,
 -4.356225177479594e-15,  2.520056860705463e-16, -3.423610699962109e-18, -8.831466535153660e-20,  4.575631782810663e-21,  1.969929174938413e-01, -1.665806930437929e-03,
  1.373988128342204e-05, -9.333409357291423e-08, -1.189898928953095e-10,  2.247133707472601e-11, -3.303305793379577e-13, -6.769663001187759e-15,  4.007481373144139e-16,
 -5.565091732909167e-18, -1.374431347626753e-19,  7.306332724973661e-21,  2.802445893596993e-01, -2.369540036823438e-03,  1.951713685768001e-05, -1.307742612675153e-07,
 -2.604472166347676e-10,  3.470659659557643e-11, -5.141336815852790e-13, -9.907209602450990e-15,  6.053989374400722e-16, -8.656949481996859e-18, -2.012954808127689e-19,
  1.109421052434865e-20,  3.813052185699475e-01, -3.223559467137433e-03,  2.650102299897408e-05, -1.742108002536270e-07, -5.249332438631196e-10,  5.239982572469402e-11,
 -7.850786133484394e-13, -1.393553821537788e-14,  8.902805212306923e-16, -1.323963713915180e-17, -2.827630275634695e-19,  1.641554279612638e-20,  5.028394025803276e-01,
 -4.250147371989627e-03,  3.484824991896199e-05, -2.228656070020927e-07, -1.010141150083034e-09,  7.888996912642508e-11, -1.202165239317383e-12, -1.906003115334321e-14,
  1.299336773842192e-15, -2.038341219666487e-17, -3.840853654652136e-19,  2.412510321026983e-20,  6.489380562711013e-01, -5.483411112749774e-03,  4.478686170511332e-05,
 -2.746065976049685e-07, -1.913826502073050e-09,  1.209818311436157e-10, -1.892548900109155e-12, -2.542212672412170e-14,  1.920040238079680e-15, -3.248690083839787e-17,
 -5.007435992511135e-19,  3.588376173327589e-20,  8.264126259818085e-01, -6.979871930942229e-03,  5.666291042373321e-05, -3.233072449639504e-07, -3.700689944258079e-09,
  1.949701242078187e-10, -3.184275458639683e-12, -3.239878527368933e-14,  2.953468533779225e-15, -5.603866860905028e-17, -5.875161347419221e-19,  5.523159082079557e-20,
  1.048324422087709e+00, -8.847004502653844e-03,  7.102248821944211e-05, -3.478772814226360e-07, -7.776435183123665e-09,  3.521875292851504e-10, -6.227990544117469e-12,
 -3.299720510834576e-14,  4.976144285283715e-15, -1.151029674696677e-16, -3.015547578941080e-19,  8.957034851736883e-20,  1.348106351781794e+00, -1.135461907599917e-02,
  8.853913531053455e-05, -2.326228868942815e-07, -2.144266522416132e-08,  8.859286520236750e-10, -1.897391381758953e-11,  7.945731237689262e-14,  1.011757206348784e-14,
 -3.823883982407028e-16,  5.357359105331114e-18,  8.644133642116702e-20,  1.252546957620074e-02, -1.025813868348562e-04,  8.308097436102886e-07, -6.136557207306155e-09,
  2.004305711946884e-11,  7.422829022802770e-13, -2.122785844830721e-14,  1.186310107307077e-16,  9.949950573647491e-18, -3.568196038868158e-19,  3.658140194460257e-21,
  1.233820818062447e-22,  3.719939672215430e-02, -3.046530127634187e-04,  2.467003213585130e-06, -1.819428733641723e-08,  5.798349428348012e-11,  2.258905103879929e-12,
 -6.430531841615468e-14,  3.646028230547160e-16,  2.990284134181035e-17, -1.077497764992321e-18,  1.115233840010619e-20,  3.696706223887192e-22,  7.465498045207332e-02,
 -6.113931651453715e-04,  4.949677390703860e-06, -3.641717727374173e-08,  1.114964791956829e-10,  4.705501162739978e-12, -1.330575040194738e-13,  7.712438650902941e-16,
  6.111468473126736e-17, -2.218820680810349e-18,  2.330812959433670e-20,  7.517585332149504e-22,  1.254817661603033e-01, -1.027617166425955e-03,  8.316373808637726e-06,
 -6.097905813303364e-08,  1.757068123258379e-10,  8.323984601978916e-12, -2.333491906958475e-13,  1.393987095959298e-15,  1.053369683247551e-16, -3.865894598705822e-18,
  4.146486633152604e-20,  1.285997851105892e-21,  1.905424300219523e-01, -1.560369147182416e-03,  1.262176585424197e-05, -9.211427534725990e-08,  2.424149496114042e-10,
  1.350882662072376e-11, -3.748151771893065e-13,  2.328335449807260e-15,  1.652953798700137e-16, -6.157520627622941e-18,  6.791638484174384e-20,  1.995643954500127e-21,
  2.710687282147680e-01, -2.219702872166665e-03,  1.794340572288232e-05, -1.301177857836970e-07,  2.977813891960671e-10,  2.090530695816024e-11, -5.733885521928324e-13,
  3.741874342206775e-15,  2.451667607152520e-16, -9.320981242867363e-18,  1.066611467779873e-19,  2.911073215735721e-21,  3.688216515571016e-01, -3.019983631517022e-03,
  2.439113107535753e-05, -1.753304052963996e-07,  3.176245854680246e-10,  3.160752141452177e-11, -8.564978511363086e-13,  5.944445627869466e-15,  3.514045148435472e-16,
 -1.374224598239225e-17,  1.650380026740026e-19,  4.066000213092674e-21,  4.863792039490763e-01, -3.982224542040435e-03,  3.212356586441816e-05, -2.280793721005861e-07,
  2.570772561725376e-10,  4.759357341509501e-11, -1.274786037336697e-12,  9.558561360451206e-15,  4.941576654548620e-16, -2.012012476555235e-17,  2.576718193926186e-19,
  5.476502722343805e-21,  6.276996179262592e-01, -5.138650782872597e-03,  4.137931657520846e-05, -2.884703757022051e-07,  2.495169186148433e-11,  7.280955858674805e-11,
 -1.932285463151966e-12,  1.599800518454312e-14,  6.894297888708080e-16, -2.984697334383443e-17,  4.174422217625060e-19,  7.043679276481996e-21,  7.993741081083480e-01,
 -6.542825442046384e-03,  5.254275318258223e-05, -3.556162997133587e-07, -5.919707087862468e-10,  1.164157246524492e-10, -3.080900306903330e-12,  2.913200230495401e-14,
  9.593117137666760e-16, -4.611614711361742e-17,  7.329330965631003e-19,  8.054412836003047e-21,  1.014043977847862e+00, -8.297155749356480e-03,  6.630737457170877e-05,
 -4.241105135639714e-07, -2.225282285080910e-09,  2.058668097727822e-10, -5.526612823672380e-12,  6.347982491649993e-14,  1.288894845741291e-15, -7.796769859975423e-17,
  1.525269975914428e-18,  3.703447310394231e-21,  1.304080168384248e+00, -1.066211252270326e-02,  8.419705878670969e-05, -4.574317668013407e-07, -7.956785842394347e-09,
  4.826983127957247e-10, -1.396947162012399e-11,  2.275019937739534e-13,  5.027080487145735e-16, -1.562488927493019e-16,  4.869397785007510e-18, -6.506515504214966e-20,
  1.212797957332422e-02, -9.622305575027598e-05,  7.594997661765564e-07, -5.723148025263218e-09,  3.020295442817394e-11,  2.979779514992923e-13, -1.513755799705654e-14,
  2.662322324627162e-16,  4.363935002301413e-19, -1.659192105373937e-19,  4.684243528871345e-21, -4.245849262259299e-23,  3.601890009159293e-02, -2.857716289511162e-04,
  2.255470667944465e-06, -1.698398852228735e-08,  8.897501782830574e-11,  9.139991055586822e-13, -4.579569519666723e-14,  8.063115075144758e-16,  1.221980417638005e-18,
 -4.990786199443602e-19,  1.414845968134466e-20, -1.296482974866750e-22,  7.228588580882919e-02, -5.735073688525415e-04,  4.525946236655502e-06, -3.404341494694828e-08,
  1.762779475776815e-10,  1.925989465591577e-12, -9.456226468713751e-14,  1.667906136058992e-15,  2.207730551911814e-18, -1.021409009458405e-18,  2.914532917078703e-20,
 -2.716166187407447e-22,  1.214998068367121e-01, -9.639546145876244e-04,  7.606050548299932e-06, -5.712159391292855e-08,  2.908151150808463e-10,  3.457622551823882e-12,
 -1.653486276949517e-13,  2.924301350941180e-15,  3.084301239607217e-18, -1.763953045435277e-18,  5.080462829842817e-20, -4.847637784623764e-22,  1.844960173371937e-01,
 -1.463733065477131e-03,  1.154708013688981e-05, -8.653247814841850e-08,  4.302143753548624e-10,  5.710116502337928e-12, -2.645151964581980e-13,  4.696506578774895e-15,
  3.263213928828118e-18, -2.775464608893653e-18,  8.096876307766314e-20, -7.972136719068013e-22,  2.624672726667686e-01, -2.082293136422367e-03,  1.642208253079713e-05,
 -1.227082071830551e-07,  5.901480311784405e-10,  9.011331448433226e-12, -4.024381854663859e-13,  7.185981177316914e-15,  1.597489950265510e-18, -4.131674604570547e-18,
  1.226532365990487e-19, -1.258022575411461e-21,  3.571188266172274e-01, -2.833142906326262e-03,  2.233509916900444e-05, -1.662339880320092e-07,  7.625098325240050e-10,
  1.391370454711802e-11, -5.966670147628320e-13,  1.074248085388623e-14, -4.269334690894677e-18, -5.952039341694777e-18,  1.809730130688196e-19, -1.957169452703571e-21,
  4.709471299672215e-01, -3.736051802849350e-03,  2.943762873040354e-05, -2.178981493950506e-07,  9.313575694180130e-10,  2.140646932262301e-11, -8.788696102192624e-13,
  1.601856412315573e-14, -1.958263217704092e-17, -8.430961865850668e-18,  2.651659555025047e-19, -3.073407906290345e-21,  6.077852960731995e-01, -4.821360843443337e-03,
  3.796045855738802e-05, -2.787556739483765e-07,  1.062798372272656e-09,  3.343416658809643e-11, -1.312156664081743e-12,  2.437196307555839e-14, -5.748204037313506e-17,
 -1.189614473687694e-17,  3.935459679026923e-19, -5.005613378698619e-21,  7.740164385612451e-01, -6.139561596091086e-03,  4.828321834948273e-05, -3.501566493887255e-07,
  1.075181989011138e-09,  5.440758069822498e-11, -2.043064528926791e-12,  3.914173864372209e-14, -1.574440851946823e-16, -1.689590440339721e-17,  6.076794568395381e-19,
 -8.811427340003322e-21,  9.818835434563904e-01, -7.787390000082032e-03,  6.111873788523128e-05, -4.333239767609520e-07,  7.242387037381539e-10,  9.703973115860316e-11,
 -3.511454002631803e-12,  7.121263513613809e-14, -4.813184070657741e-16, -2.394244396866190e-17,  1.022338625646577e-18, -1.818985794604915e-20,  1.262741882300633e+00,
 -1.001203097942652e-02,  7.820947569370575e-05, -5.235807891788181e-07, -1.147750203798740e-09,  2.216911611894179e-10, -7.985744110464255e-12,  1.853153021630203e-13,
 -2.338384499232291e-15, -2.095092828878500e-17,  1.989517210477078e-18, -5.443071665833904e-20  };
  constexpr double w[4608] = {  1.778800900294314e-04, -1.027497092314416e-05,  3.708711607444326e-07, -1.067816850715478e-08,  2.674133743458445e-10,
 -6.072249637502298e-12,  1.280086582074457e-13, -2.542824780740356e-15,  4.808115986973848e-17, -8.716998472311230e-19,  1.523514816384128e-20, -2.576996749404428e-22,
  1.351264753084716e-03, -1.076800958239091e-04,  5.336650236804222e-06, -2.074882525695274e-07,  6.887529172488887e-09, -2.037061025583220e-10,  5.505414915053851e-12,
 -1.382266013532156e-13,  3.261473617703728e-15, -7.293271006819639e-17,  1.555611332234449e-18, -3.179535212140114e-20,  4.536424216241372e-03, -5.040925571287432e-04,
  3.356840683383142e-05, -1.702126405244140e-06,  7.198381620358523e-08, -2.661273841118496e-09,  8.848175451939005e-11, -2.695616159501955e-12,  7.624879024320943e-14,
 -2.022131005927685e-15,  5.065507817675901e-17, -1.205048033743700e-18,  1.017299453743515e-02, -1.528570300863072e-03,  1.321495214370296e-04, -8.452457141992119e-06,
  4.411435326130016e-07, -1.977643487408911e-08,  7.856755357860564e-10, -2.824229307894162e-11,  9.322392271839578e-13, -2.856827660298006e-14,  8.196481991578256e-16,
 -2.215012325015624e-17,  1.770815371323920e-02, -3.447441754300369e-03,  3.738257726449637e-04, -2.926665044963962e-05,  1.834290760363489e-06, -9.722331003418041e-08,
  4.507120332384427e-09, -1.869256060838382e-10,  7.048286547080582e-12, -2.445514637917945e-13,  7.880692537801994e-15, -2.374305699342674e-16,  2.572044076211974e-02,
 -6.212090542774506e-03,  8.173961868835235e-04, -7.616201117119554e-05,  5.591309261469123e-06, -3.425281203750811e-07,  1.814427260386053e-08, -8.513208551421151e-10,
  3.599644594636525e-11, -1.389522556074989e-12,  4.946236628159401e-14, -1.635204588604715e-15,  3.240063947454969e-02, -9.323551618192698e-03,  1.442620316483638e-03,
 -1.557704928921583e-04,  1.308327190530886e-05, -9.068421689283824e-07,  5.382633824487182e-08, -2.805736184139583e-09,  1.307944645511486e-10, -5.528140356512633e-12,
  2.141192565113763e-13, -7.657362811311180e-15,  3.608915396196800e-02, -1.192934975632045e-02,  2.107101186708698e-03, -2.570125124986259e-04,  2.414325497403367e-05,
 -1.854975738392650e-06,  1.210772623990293e-07, -6.890815986116802e-09,  3.484742847376462e-10, -1.588476399709692e-11,  6.600316316111717e-13, -2.519537509294069e-14,
  3.567150363738310e-02, -1.311152953453540e-02,  2.570980435404488e-03, -3.456411549283692e-04,  3.552209244185373e-05, -2.965281115855283e-06,  2.089647927136179e-07,
 -1.276652382856862e-08,  6.894413655684004e-10, -3.340129104631630e-11,  1.468618143395811e-12, -5.907949374570628e-14,  3.078044948569179e-02, -1.222255739812898e-02,
  2.591526923973825e-03, -3.749897974169114e-04,  4.126166899424646e-05, -3.669138618161558e-06,  2.741389630891338e-07, -1.768001269980930e-08,  1.003893133300851e-09,
 -5.094992393414551e-11,  2.338930915016044e-12, -9.792327382096798e-14,  2.183207119800097e-02, -9.126814916363395e-03,  2.040870785072073e-03, -3.105916517322527e-04,
  3.582183517421145e-05, -3.327536735069712e-06,  2.588774396188983e-07, -1.733306353197797e-08,  1.018948440318358e-09, -5.340422666384865e-11,  2.525793777842788e-12,
 -1.087036639013760e-13,  9.947191201127352e-03, -4.275783465427040e-03,  9.844790555523890e-04, -1.540586563949336e-04,  1.823745808790040e-05, -1.735644242122205e-06,
  1.380986462999596e-07, -9.440877078540432e-09,  5.658045140574418e-10, -3.018921585507012e-11,  1.451668012763056e-12, -6.344007204772665e-14,  1.419943553619198e-04,
 -7.756071272669302e-06,  2.648784977220361e-07, -7.225604906025675e-09,  1.717125471789345e-10, -3.705850599162979e-12,  7.435796378082565e-14, -1.407768035708855e-15,
  2.540055755885000e-17, -4.399201299865018e-19,  7.352614566462493e-21, -1.190493797655536e-22,  9.924499512237576e-04, -7.334168128886373e-05,  3.393657863701250e-06,
 -1.238327729027974e-07,  3.873234960082721e-09, -1.082826367249564e-10,  2.773525189428409e-12, -6.614554152321681e-14,  1.485421554995686e-15, -3.167045883657903e-17,
  6.451008953911411e-19, -1.261071701609170e-20,  2.950905320006874e-03, -3.010731722859371e-04,  1.861082835049221e-05, -8.822527930118865e-07,  3.506353657062022e-08,
 -1.223204986675818e-09,  3.850432278948379e-11, -1.113783430256119e-12,  2.998785019247587e-14, -7.586718865835916e-16,  1.816639314106912e-17, -4.138674212189522e-19,
  5.667493755624418e-03, -7.816298808548581e-04,  6.272472537874877e-05, -3.752360227032718e-06,  1.842065694893151e-07, -7.802398519157570e-09,  2.939648040444029e-10,
 -1.005320707432697e-11,  3.165846014324910e-13, -9.278429167494450e-15,  2.551581314130656e-16, -6.622869936170385e-18,  8.224051151000061e-03, -1.479581467078036e-03,
  1.496393075695500e-04, -1.100367738093892e-05,  6.513358638284988e-07, -3.275044503128300e-08,  1.445715342080982e-09, -5.727807108069450e-11,  2.069021727105366e-12,
 -6.894517400008526e-14,  2.138607845920839e-15, -6.215116562866962e-17,  9.776630315136484e-03, -2.207222774798596e-03,  2.732177542569006e-04, -2.408930536723468e-05,
  1.681556920683422e-06, -9.834831202711949e-08,  4.990980906996364e-09, -2.250200010056210e-10,  9.166846624160226e-12, -3.417315087355729e-13,  1.177275375986944e-14,
 -3.774157732003132e-16,  1.000247841261588e-02, -2.728063352197397e-03,  4.015423573238369e-04, -4.142697684415408e-05,  3.337545716144315e-06, -2.226494696354166e-07,
  1.275675326246507e-08, -6.435310327082721e-10,  2.909949422794208e-11, -1.195475235493412e-12,  4.509076751438389e-14, -1.573013218467262e-15,  9.088382411296494e-03,
 -2.888596852828481e-03,  4.913541558084876e-04, -5.788936940125359e-05,  5.267636994601912e-06, -3.930478168983765e-07,  2.497147080219924e-08, -1.386134389487944e-09,
  6.849278894857641e-11, -3.055636889189955e-12,  1.244435780691507e-13, -4.662444750410784e-15,  7.455221030517292e-03, -2.670084978775439e-03,  5.103058805631382e-04,
 -6.698775098786195e-05,  6.734672577248289e-06, -5.509137204423807e-07,  3.810408016049300e-08, -2.288048410372574e-09,  1.216010566184142e-10, -5.804314927735410e-12,
  2.517086046057533e-13, -9.996615581514932e-15,  5.499318449021236e-03, -2.151385771897187e-03,  4.492962243221381e-04, -6.409353172569890e-05,  6.960031385831463e-06,
 -6.114092446298247e-07,  4.516919034412198e-08, -2.882853481633185e-09,  1.621165773424402e-10, -8.154262015014390e-12,  3.712221086604280e-13, -1.542182906139074e-14,
  3.472296769629950e-03, -1.441574979075598e-03,  3.200418263640738e-04, -4.837358678010383e-05,  5.543552415982505e-06, -5.118917868730087e-07,  3.960462988940524e-08,
 -2.638098187431630e-09,  1.543423643997833e-10, -8.053158048436851e-12,  3.792927026969558e-13, -1.626030480924079e-14,  1.478769005289457e-03, -6.341444071774180e-04,
  1.456385661762608e-04, -2.273442656076541e-05,  2.684972259624859e-06, -2.549566759207780e-07,  2.024307215884109e-08, -1.381112381595920e-09,  8.261481766894826e-11,
 -4.400077060430773e-12,  2.112183871288144e-13, -9.215571168346543e-15,  1.147182110660732e-04, -5.942229866425050e-06,  1.924908568203108e-07, -4.986096270277206e-09,
  1.126678677021698e-10, -2.315252590498819e-12,  4.429134026572129e-14, -8.004386078376112e-16,  1.380153934060060e-17, -2.286596962704428e-19,  3.659327755775672e-21,
 -5.678378252562173e-23,  7.452669899870832e-04, -5.122673975110248e-05,  2.218229746856648e-06, -7.611456290919315e-08,  2.247070779111984e-09, -5.947067862545231e-11,
  1.445599940135441e-12, -3.278728374319037e-14,  7.015324040231197e-16, -1.427461526107855e-17,  2.779086137264903e-19, -5.199834811100317e-21,  1.988702770548809e-03,
 -1.865761683801485e-04,  1.072032818620389e-05, -4.756718270000129e-07,  1.778351467423974e-08, -5.858784972142354e-10,  1.747265798541143e-11, -4.801493960469496e-13,
  1.231060846614681e-14, -2.972101777395171e-16,  6.804257950015551e-18, -1.484724938706958e-19,  3.317133241415477e-03, -4.196137512057359e-04,  3.125301742132208e-05,
 -1.748577855836139e-06,  8.073353685426577e-08, -3.230499301648174e-09,  1.154027631232280e-10, -3.753661825228313e-12,  1.127317367915511e-13, -3.158493148666947e-15,
  8.321514117427789e-17, -2.073475698155519e-18,  4.060832514167640e-03, -6.732600622891357e-04,  6.339482240340811e-05, -4.372320088894888e-06,  2.441148684159008e-07,
 -1.163031795465104e-08,  4.882983503826392e-10, -1.845975764756533e-11,  6.380686099820155e-13, -2.039681886032858e-14,  6.083131726431275e-16, -1.703313514076821e-17,
  3.979746742068609e-03, -8.362261702678240e-04,  9.706636475514516e-05, -8.076768713345804e-06,  5.348297161753557e-07, -2.979962221194583e-08,  1.445893831880204e-09,
 -6.252196971004952e-11,  2.449527701771333e-12, -8.803537243572269e-14,  2.930303051769490e-15, -9.094993100797263e-17,  3.308377341138864e-03, -8.509432214182560e-04,
  1.186694945102611e-04, -1.165787279217832e-05,  8.981689059814597e-07, -5.750959103203387e-08,  3.172645350583667e-09, -1.545309998787589e-10,  6.763310798345729e-12,
 -2.695204837972695e-13,  9.880328356359340e-15, -3.356177168664429e-16,  2.435022820225496e-03, -7.406189016795180e-04,  1.208290900285627e-04, -1.370143300810308e-05,
  1.203885497729979e-06, -8.698906031371198e-08,  5.365519837057678e-09, -2.897967931241018e-10,  1.396110555511689e-11, -6.083315997708882e-13,  2.423684016707113e-14,
 -8.896845953467427e-16,  1.635742150679011e-03, -5.686904928322559e-04,  1.055742737578492e-04, -1.349088503565690e-05,  1.323207053148308e-06, -1.058107931493722e-07,
  7.166931216940733e-09, -4.221253067135704e-10,  2.203715841363153e-11, -1.034610376396597e-12,  4.418177433396801e-14, -1.729798905905972e-15,  1.014452619869258e-03,
 -3.900448946982998e-04,  8.004788293849005e-05, -1.123422128574159e-05,  1.201691864833822e-06, -1.041070946764457e-07,  7.593235084356110e-09, -4.789268509655835e-10,
  2.663921192260553e-11, -1.326400713156616e-12,  5.981863389456366e-14, -2.463473998824200e-15,  5.613194144315795e-04, -2.311687321611008e-04,  5.089531354026499e-05,
 -7.632242204157500e-06,  8.682425553236457e-07, -7.962912412430286e-08,  6.122049047839716e-09, -4.054125862471948e-10,  2.358999303465071e-11, -1.224644771208244e-12,
  5.740766525435944e-14, -2.450290390160132e-15,  2.211178451536284e-04, -9.456848727756332e-05,  2.165660405716607e-05, -3.371264949641678e-06,  3.971033092878037e-07,
 -3.761382105952394e-08,  2.979443700975728e-09, -2.028253177879376e-10,  1.210704648255108e-11, -6.435414180221285e-13,  3.083394530749551e-14, -1.342903252354947e-15,
  9.368925721324181e-05, -4.614168416329573e-06,  1.421139829687349e-07, -3.502905566929275e-09,  7.540631329366132e-11, -1.478006469988794e-12,  2.700093345589845e-14,
 -4.664955753204917e-16,  7.697456082544942e-18, -1.221566161068150e-19,  1.874195303727142e-21, -2.790524288384607e-23,  5.708244323418642e-04, -3.660272919416197e-05,
  1.486674454045540e-06, -4.806357969595145e-08,  1.341582402030575e-09, -3.366397144398018e-11,  7.776345636307749e-13, -1.679407699143778e-14,  3.427472318625801e-16,
 -6.662512925908150e-18,  1.240887319745117e-19, -2.224061130174343e-21,  1.383589270816778e-03, -1.195710122587167e-04,  6.395803327121554e-06, -2.659723439498826e-07,
  9.364456226777494e-09, -2.916322129459425e-10,  8.246723514978672e-12, -2.154379913169981e-13,  5.262971060045254e-15, -1.213087340432656e-16,  2.656264389731585e-18,
 -5.553021559172471e-20,  2.031408296786801e-03, -2.356461903275814e-04,  1.629330925690439e-05, -8.527875116665843e-07,  3.703915326919519e-08, -1.400281039921560e-09,
  4.742956271915266e-11, -1.467200528624014e-12,  4.201692945786750e-14, -1.125158290301007e-15,  2.839233005470804e-17, -6.789019942421787e-19,  2.124563733700371e-03,
 -3.238445462184348e-04,  2.835221463347787e-05, -1.832106642532264e-06,  9.639056005242100e-08, -4.347307955654553e-09,  1.734400826023658e-10, -6.250724467131288e-12,
  2.065552505547908e-13, -6.328209950157802e-15,  1.812882927662768e-16, -4.886136653329200e-18,  1.732194966319076e-03, -3.373697270970141e-04,  3.661748622075245e-05,
 -2.868704044136576e-06,  1.798249516798007e-07, -9.527011410762470e-09,  4.411767409217069e-10, -1.826550474204132e-11,  6.871058560721532e-13, -2.376970622601975e-14,
  7.632686417354137e-16, -2.290175548825601e-17,  1.173658503073154e-03, -2.832460742960051e-04,  3.727809800030388e-05, -3.475496726397931e-06,  2.553150730156495e-07,
 -1.564930809823743e-08,  8.292414116698859e-10, -3.890953826467204e-11,  1.644771120977565e-12, -6.345203989910633e-14,  2.256492802176501e-15, -7.449952263792045e-17,
  6.965596810639607e-04, -2.017069384061563e-04,  3.142757659016413e-05, -3.417365699503917e-06,  2.889968463870474e-07, -2.016255403415179e-08,  1.204146096873965e-09,
 -6.312697103970799e-11,  2.958301426285523e-12, -1.256352132035961e-13,  4.887180106294170e-15, -1.754444364427045e-16,  3.785728750436868e-04, -1.272208169466979e-04,
  2.285452298318334e-05, -2.833480436948829e-06,  2.703217634089049e-07, -2.107447127805951e-08,  1.394517490709229e-09, -8.038760988204647e-11,  4.114046047987016e-12,
 -1.896237667718091e-13,  7.960416776039726e-15, -3.067610761161448e-16,  1.940388792617360e-04, -7.311573107241489e-05,  1.470642679924893e-05, -2.025671811598272e-06,
  2.129791877570863e-07, -1.816141149750284e-08,  1.305487563664991e-09, -8.124349152610537e-11,  4.463357745688441e-12, -2.197048192708542e-13,  9.803717843878450e-15,
 -3.997908296383833e-16,  9.246038449687131e-05, -3.772012146850798e-05,  8.224525843387687e-06, -1.222133212268636e-06,  1.378570553451099e-07, -1.254471237778450e-08,
  9.575135447403940e-10, -6.298548860821989e-11,  3.642338768822357e-12, -1.880035843964129e-13,  8.766085580553163e-15, -3.723051550625731e-16,  3.328154690846687e-05,
 -1.419043322304301e-05,  3.239114737907890e-06, -5.026504733036795e-07,  5.903190067819961e-08, -5.575908666962880e-09,  4.405142352926789e-10, -2.991371699250155e-11,
  1.781442304437012e-12, -9.448273445212181e-14,  4.517519407870122e-15, -1.963637949150170e-16,  7.726644404768723e-05, -3.626923501584338e-06,  1.064456567726337e-07,
 -2.501664037105930e-09,  5.139671205373101e-11, -9.624924390989519e-13,  1.681716178894519e-14, -2.781691801936625e-16,  4.398448015299293e-18, -6.694751879880604e-20,
  9.859287574474614e-22, -1.410141831192900e-23,  4.450026082361539e-04, -2.669676821110949e-05,  1.019381164845514e-06, -3.111057899186730e-08,  8.224221487623945e-10,
 -1.959575334588935e-11,  4.307559110338317e-13, -8.868998576574892e-15,  1.728458599308093e-16, -3.213053368714688e-18,  5.730286894964386e-20, -9.846617108009169e-22,
  9.905127584774684e-04, -7.900649249364504e-05,  3.940600303632241e-06, -1.538023670855983e-07,  5.105976901847662e-09, -1.504722541567162e-10,  4.038274189552195e-12,
 -1.003699380694933e-13,  2.337824782894012e-15, -5.147534357665670e-17,  1.078571623908645e-18, -2.161072659117547e-20,  1.296554624413286e-03, -1.379451729145919e-04,
  8.859280236794097e-06, -4.340046054999222e-07,  1.773989934233242e-08, -6.338466580445492e-10,  2.036114828147047e-11, -5.991010672557419e-13,  1.636052301119074e-14,
 -4.187221926618809e-16,  1.011883500933872e-17, -2.321494719970167e-19,  1.173429087086374e-03, -1.641371586399782e-04,  1.334854283081405e-05, -8.076061844328963e-07,
  4.001378136495860e-08, -1.707307688351465e-09,  6.468397444103432e-11, -2.220887488671405e-12,  7.011204047137801e-14, -2.057164893746971e-15,  5.656547136579383e-17,
 -1.466330849930733e-18,  8.043717832336010e-04, -1.446701741675338e-04,  1.464586697683797e-05, -1.078106356922145e-06,  6.386132670254939e-08, -3.211762561526552e-09,
  1.417282287159091e-10, -5.609862589680710e-12,  2.023300845492499e-13, -6.727838381100741e-15,  2.081277006981609e-16, -6.028869244226770e-18,  4.466987791939075e-04,
 -1.006436314827765e-04,  1.245335759872446e-05, -1.098402967980268e-06,  7.672520253660817e-08, -4.490596164664335e-09,  2.280292659782963e-10, -1.028512744503878e-11,
  4.190659010109475e-13, -1.562046079153867e-14,  5.378915504310865e-16, -1.723057389672094e-17,  2.133868855583936e-04, -5.851255204157642e-05,  8.668380158241645e-06,
 -9.004643127240993e-07,  7.304780791174662e-08, -4.906095782260542e-09,  2.829278805640727e-10, -1.436085951123594e-11,  6.531371930137332e-13, -2.697654237811510e-14,
  1.022515344175142e-15, -3.583045329800251e-17,  9.286560990928429e-05, -3.002192986896414e-05,  5.197317668675267e-06, -6.228942826055957e-07,  5.761686283690567e-08,
 -4.366618458785525e-09,  2.815421140580744e-10, -1.584652475366764e-11,  7.932968869357663e-13, -3.582561612553966e-14,  1.475748401282920e-15, -5.587896119100582e-17,
  3.866613393645774e-05, -1.423123471550270e-05,  2.796790839741720e-06, -3.770468444616873e-07,  3.887003365756311e-08, -3.255344160789300e-09,  2.301632712671259e-10,
 -1.410739322397915e-11,  7.642468559430392e-13, -3.713569359162352e-14,  1.637355680995484e-15, -6.603536183713303e-17,  1.556423925525016e-05, -6.279373458972294e-06,
  1.353743089409176e-06, -1.990377311796630e-07,  2.223260819090660e-08, -2.004954420610439e-09,  1.517683641244774e-10, -9.907191110460064e-12,  5.688766352295958e-13,
 -2.917165379692024e-14,  1.351964579886733e-15, -5.709755796818821e-17,  5.047041771750919e-06, -2.144363958813037e-06,  4.876554858014932e-07, -7.540530903145556e-08,
  8.825936394153890e-09, -8.310328526042624e-10,  6.546009489958784e-11, -4.432825468395202e-12,  2.632986682002411e-13, -1.393038312944558e-14,  6.645166302033106e-16,
 -2.882182506281584e-17,  6.428972630364632e-05, -2.882790805767004e-06,  8.078895919525976e-08, -1.813773948019486e-09,  3.562574499169143e-11, -6.384226870509139e-13,
  1.068458222240973e-14, -1.694350967547925e-16,  2.570704226340449e-18, -3.757425933953746e-20,  5.317708679136013e-22, -7.314304708773185e-24,  3.524419054497549e-04,
 -1.983784187769918e-05,  7.136867251364814e-07, -2.059985621345055e-08,  5.166017262525146e-10, -1.170551678841586e-11,  2.451931952956958e-13, -4.818959590187834e-15,
  8.978381906980362e-17, -1.597736980128081e-18,  2.731141605003852e-20, -4.503316701676542e-22,  7.275445297858005e-04, -5.367407786787965e-05,  2.500604383454601e-06,
 -9.173915214965796e-08,  2.875454469046525e-09, -8.027930667042110e-11,  2.046773333204590e-12, -4.844220621931164e-14,  1.076621372115456e-15, -2.266022363794075e-17,
  4.546031383453146e-19, -8.734246436504691e-21,  8.592672336422483e-04, -8.389338529047492e-05,  5.008559845446456e-06, -2.298242461614889e-07,  8.846301280372780e-09,
 -2.988787245709747e-10,  9.108999055317159e-12, -2.550089743829163e-13,  6.642081205152892e-15, -1.624894335132985e-16,  3.760674720794547e-18, -8.277914137653306e-20,
  6.816041951637710e-04, -8.736634783009858e-05,  6.596559843393891e-06, -3.735332247898421e-07,  1.742289154101544e-08, -7.030460553243342e-10,  2.528437719986475e-11,
 -8.266831686711496e-13,  2.492029935911364e-14, -6.998906108073974e-16,  1.846104011973710e-17, -4.599956154380344e-19,  3.974181810313062e-04, -6.578337918906787e-05,
  6.198654667249743e-06, -4.280258392303602e-07,  2.392335320456386e-08, -1.140607353314479e-09,  4.790078021002053e-11, -1.810372659899538e-12,  6.252528741786691e-14,
 -1.995979589695029e-15,  5.941373717545364e-17, -1.659536806514785e-18,  1.823125918229624e-04, -3.815943334007288e-05,  4.423586561788994e-06, -3.680388011282105e-07,
  2.438238493307082e-08, -1.359512838903232e-09,  6.601455492794410e-11, -2.856467788487570e-12,  1.119690381489816e-13, -4.025243237934727e-15,  1.339830984397287e-16,
 -4.157328967291726e-18,  7.017270089871204e-05, -1.811812548681556e-05,  2.540744069857606e-06, -2.511862167515794e-07,  1.948206775650600e-08, -1.255877758745221e-09,
  6.974528400284256e-11, -3.419029740849859e-12,  1.505619828295544e-13, -6.034878192577359e-15,  2.224360382166384e-16, -7.593772906590699e-18,  2.425969065487575e-05,
 -7.504877359134019e-06,  1.246389453980560e-06, -1.438405100835666e-07,  1.285572818428924e-08, -9.442272551214639e-10,  5.915603873226100e-11, -3.242776699409591e-12,
  1.584289483063119e-13, -6.995212255479398e-15,  2.821887096299636e-16, -1.047985295919128e-17,  8.068817048574878e-06, -2.889445586203458e-06,  5.528566224768869e-07,
 -7.272086309476577e-08,  7.330295827975784e-09, -6.014421502868380e-10,  4.173299136392236e-11, -2.514257556729457e-12,  1.340652919858030e-13, -6.419943289035424e-15,
  2.792688042711583e-16, -1.112355090461119e-17,  2.686754170591413e-06, -1.069800361654560e-06,  2.275914699846973e-07, -3.305077961069312e-08,  3.650039336332701e-09,
 -3.257485416264197e-10,  2.442324146118174e-11, -1.580348457900064e-12,  9.001249307790997e-14, -4.581416533194166e-15,  2.108641812560634e-16, -8.848744779799815e-18,
  7.719733905035055e-07, -3.266548571406222e-07,  7.396770834299521e-08, -1.139078727671413e-08,  1.328144667274554e-09, -1.246078234875365e-10,  9.782489249206978e-12,
 -6.603801036274739e-13,  3.911014935033155e-14, -2.063529240472286e-15,  9.818215602594824e-17, -4.248115377393112e-18,  5.392584550425057e-05, -2.314737342243290e-06,
  6.206347904563194e-08, -1.333437425009202e-09,  2.508053809660951e-11, -4.307445245156316e-13,  6.914714719783859e-15, -1.052654956566513e-16,  1.534394385051359e-18,
 -2.156240863721890e-20,  2.935926318577738e-22, -3.887738160168274e-24,  2.831212183738593e-04, -1.499254681218184e-05,  5.092796321306424e-07, -1.392802842482941e-08,
  3.318853649620859e-10, -7.161859896756055e-12,  1.431438416434451e-13, -2.688763986942086e-15,  4.794570661113131e-17, -8.176356552303215e-19,  1.340909464201377e-20,
 -2.123505438188379e-22,  5.468483624263415e-04, -3.739731801414951e-05,  1.630329110513914e-06, -5.630726022246035e-08,  1.668551849692064e-09, -4.418494107619202e-11,
  1.071335112355784e-12, -2.416750333234242e-14,  5.129336859760970e-16, -1.032747277631260e-17,  1.984999352702243e-19, -3.659058929982550e-21,  5.892463888515787e-04,
 -5.283791113508125e-05,  2.935404320352064e-06, -1.262817324658630e-07,  4.580998790488955e-09, -1.464477468856556e-10,  4.236958161421153e-12, -1.129063078965743e-13,
  2.805880062462294e-15, -6.562884660933800e-17,  1.454954255713901e-18, -3.073032366288620e-20,  4.148056965132167e-04, -4.867224767845383e-05,  3.411385931582674e-06,
 -1.807872167055311e-07,  7.938049625907828e-09, -3.028946796133930e-10,  1.033881555094248e-11, -3.218214828713677e-13,  9.260872994772491e-15, -2.488739918904337e-16,
  6.294724842501198e-18, -1.506942628533655e-19,  2.082575320869324e-04, -3.163171137598399e-05,  2.769642376455952e-06, -1.791672405443528e-07,  9.438230933088994e-09,
 -4.261361708645236e-10,  1.701364514910391e-11, -6.133480179371431e-13,  2.026423142709602e-14, -6.203988326114787e-16,  1.775135308056148e-17, -4.776127427155050e-19,
  7.968889505553610e-05, -1.542221464875363e-05,  1.669506596165129e-06, -1.306802190676189e-07,  8.192231833813887e-09, -4.342556425352490e-10,  2.012471676354550e-11,
 -8.338633671214305e-13,  3.139070735648066e-14, -1.086549856799632e-15,  3.490293285526467e-17, -1.047382747092455e-18,  2.481226230763450e-05, -5.997242589048857e-06,
  7.925573471388483e-07, -7.429515285978879e-08,  5.491488850990493e-09, -3.387834973753579e-10,  1.807022869087529e-11, -8.534317569100659e-13,  3.630579774705058e-14,
 -1.409186610762228e-15,  5.040575215509154e-17, -1.673295562703043e-18,  6.779286674472808e-06, -1.995230288000807e-06,  3.163595252286371e-07, -3.501134788442608e-08,
  3.012536602381089e-09, -2.137439706676249e-10,  1.297402094028719e-11, -6.908223502146539e-13,  3.285804937569833e-14, -1.415276294712364e-15,  5.579522675230640e-17,
 -2.028403500449136e-18,  1.773211623114543e-06, -6.150080628599403e-07,  1.141039733281257e-07, -1.459211060559839e-08,  1.433720243627484e-09, -1.149259146812826e-10,
  7.806681583500691e-12, -4.612528420219636e-13,  2.415904812563330e-14, -1.138009066854980e-15,  4.875741828817656e-17, -1.915032723170869e-18,  4.775530133680425e-07,
 -1.871989339682738e-07,  3.920749487893321e-08, -5.611889287815539e-09,  6.116109419826084e-10, -5.392741101637237e-11,  3.998803117540545e-12, -2.561427277013507e-13,
  1.445421215009080e-14, -7.294173446973139e-16,  3.330833315046310e-17, -1.387628939646091e-18,  1.192559537618530e-07, -5.022164678637743e-08,  1.131573340222955e-08,
 -1.734374323547491e-09,  2.013352840349360e-10, -1.881220444040528e-11,  1.471257611546081e-12, -9.896751283793074e-14,  5.841863935281603e-15, -3.072771306173421e-16,
  1.457791922220667e-17, -6.290479153502265e-19,  4.556740644561668e-05, -1.876013349628665e-06,  4.821236154737678e-08, -9.929619081844114e-10,  1.791233862920511e-11,
 -2.952559918640419e-13,  4.552404722158909e-15, -6.661481024186285e-17,  9.339921037505898e-19, -1.263359809494107e-20,  1.656746467410380e-22, -2.114331691983326e-24,
  2.303554531521132e-04, -1.150637113424446e-05,  3.698189736201741e-07, -9.599893730420782e-09,  2.176973232698338e-10, -4.480364118310232e-12,  8.555736567546843e-14,
 -1.537792413009931e-15,  2.627441921769256e-17, -4.298316736599016e-19,  6.769530020060075e-21, -1.030549880391844e-22,  4.196273673346434e-04, -2.666269279632526e-05,
  1.089629286324375e-06, -3.548362274798678e-08,  9.954665401631948e-10, -2.503405187594957e-11,  5.778858063826018e-13, -1.243728602984114e-14,  2.523050016506208e-16,
 -4.863297706068611e-18,  8.961883635211006e-20, -1.585966230748138e-21,  4.167689153680650e-04, -3.436155451036303e-05,  1.778489380162651e-06, -7.180920336261463e-08,
  2.457291248177118e-09, -7.438968808868011e-11,  2.044428212127693e-12, -5.188715492401701e-14,  1.230878772187195e-15, -2.753654910755595e-17,  5.849337263281972e-19,
 -1.185720448410898e-20,  2.634945865332266e-04, -2.828569260969549e-05,  1.840630663591321e-06, -9.131221558132970e-08,  3.774946988437167e-09, -1.362237898636515e-10,
  4.413262126987326e-12, -1.307814319273018e-13,  3.592195839620228e-15, -9.235580831983707e-17,  2.239403865936438e-18, -5.149313116930329e-20,  1.153502273969020e-04,
 -1.603541394944980e-05,  1.303047555335362e-06, -7.889546145680475e-08,  3.913874598659343e-09, -1.672119238155490e-10,  6.341903499611445e-12, -2.179063895761793e-13,
  6.881418558695304e-15, -2.018832921009843e-16,  5.547831907737376e-18, -1.436600242526688e-19,  3.723100712598720e-05, -6.632575628110754e-06,  6.685738511912479e-07,
 -4.912236010432115e-08,  2.908139831828639e-09, -1.462866686097386e-10,  6.459175000923829e-12, -2.558662530600135e-13,  9.235889153719401e-15, -3.073439582080934e-16,
  9.513756254890181e-18, -2.757086406621255e-19,  9.440635412406345e-06, -2.123603748033226e-06,  2.633365535455649e-07, -2.332330479222907e-08,  1.637813809824715e-09,
 -9.642916143303274e-11,  4.927396837074221e-12, -2.236729786027936e-13,  9.171798072450898e-15, -3.440175746259459e-16,  1.191816563319523e-17, -3.839964172131238e-19,
  2.034700953210188e-06, -5.661440558605534e-07,  8.526948665817263e-08, -9.010730351416755e-09,  7.436452512123887e-10, -5.079968595787934e-11,  2.978463091373606e-12,
 -1.536260949157972e-13,  7.095811704928930e-15, -2.974551556396510e-16,  1.143546724124914e-17, -4.061419524986049e-19,  4.128210102150454e-07, -1.379459143492955e-07,
  2.470366277423474e-08, -3.059320745350921e-09,  2.919727666241352e-10, -2.279479173917787e-11,  1.511635316470983e-12, -8.737377593525946e-14,  4.485149848447862e-15,
 -2.073972331503378e-16,  8.735500758287406e-18, -3.377483171110790e-19,  8.781696849423668e-08, -3.378678902267034e-08,  6.946994988837802e-09, -9.776054941412308e-10,
  1.049107575582072e-10, -9.121229967111400e-12,  6.677547457254750e-13, -4.227615269417338e-14,  2.360281643347535e-15, -1.179462270335249e-16,  5.337541831797732e-18,
 -2.205247141573714e-19,  1.863716116702295e-08, -7.804404499754820e-09,  1.748240061296325e-09, -2.664861938053849e-10,  3.077776500118301e-11, -2.862254847314589e-12,
  2.228751973207942e-13, -1.493168607558250e-14,  8.780840675449019e-16, -4.602527755288083e-17,  2.176433368129591e-18, -9.362959401239027e-20,  3.876561738951033e-05,
 -1.533517612989556e-06,  3.783916614423079e-08, -7.482474903961854e-10,  1.296453780022704e-11, -2.053821834731939e-13,  3.045409983851695e-15, -4.288693616558874e-17,
  5.790411841262398e-19, -7.547591909129823e-21,  9.542411235188063e-23, -1.174828631952297e-24,  1.895929294169128e-04, -8.955552208329163e-06,  2.728872939842518e-07,
 -6.735124847090949e-09,  1.455725988893529e-10, -2.861304851258171e-12,  5.227076529041410e-14, -9.000653027902281e-16,  1.475111493443342e-17, -2.317357846649744e-19,
  3.508241503940936e-21, -5.138612668991646e-23,  3.280515224657758e-04, -1.941178910293428e-05,  7.450210334875358e-07, -2.291188547764057e-08,  6.093792291631420e-10,
 -1.457142513708868e-11,  3.205956455752593e-13, -6.589547526207084e-15,  1.278855756024168e-16, -2.361868813709814e-18,  4.175887397721329e-20, -7.099351899585392e-22,
  3.031347232241531e-04, -2.301001351444870e-05,  1.111037704684189e-06, -4.215317312594148e-08,  1.362111792848173e-09, -3.908326536547521e-11,  1.021110537196128e-12,
 -2.469860619723131e-14,  5.596000527051756e-16, -1.197974077024655e-17,  2.439265208564955e-19, -4.747129717894667e-21,  1.740793157817613e-04, -1.709187144560903e-05,
  1.033098509353256e-06, -4.799936305321969e-08,  1.869078750928046e-09, -6.380714401627591e-11,  1.962457822910025e-12, -5.537181965140169e-14,  1.451796558395049e-15,
 -3.570929463432938e-17,  8.300156782315096e-19, -1.832897905567889e-20,  6.728609655724227e-05, -8.542614854560848e-06,  6.437104457265250e-07, -3.645740073402157e-08,
  1.702313285630754e-09, -6.878284527370461e-11,  2.476878689381911e-12, -8.106834679586518e-14,  2.445597344755481e-15, -6.870920093310478e-17,  1.812224366547462e-18,
 -4.513259000677452e-20,  1.854479186030570e-05, -3.028517711964734e-06,  2.835708179424924e-07, -1.951935484630898e-08,  1.089482948328889e-09, -5.192674970520698e-11,
  2.181335550820856e-12, -8.249425339457050e-14,  2.851409231551579e-15, -9.110152491033268e-17,  2.713940813178858e-18, -7.585662615372923e-20,  3.864791166593662e-06,
 -8.043458778906136e-07,  9.321020469676774e-08, -7.774031366157812e-09,  5.171445369235543e-10, -2.898280260824297e-11,  1.415406496004727e-12, -6.161716928094317e-14,
  2.430336966811440e-15, -8.791508170790968e-17,  2.944334883326815e-18, -9.190606446434241e-20,  6.581189301693973e-07, -1.719611214913317e-07,  2.447415657877253e-08,
 -2.458756934900713e-09,  1.938899874234725e-10, -1.270918065665032e-11,  7.175848032085600e-13, -3.575318881271419e-14,  1.599544630826850e-15, -6.510282687735173e-17,
  2.435252121638500e-18, -8.432052787883862e-20,  1.024414657515112e-07, -3.278104427921393e-08,  5.637458493593257e-09, -6.731108436765041e-10,  6.216014172919058e-11,
 -4.710585433338083e-12,  3.040437278509848e-13, -1.714546694020717e-14,  8.604568679782632e-16, -3.897085058689140e-17,  1.610359874105458e-18, -6.117607159696130e-20,
  1.680001280704158e-08, -6.320447476442197e-09,  1.271470296911188e-09, -1.753902346800656e-10,  1.848491478509740e-11, -1.581066331990815e-12,  1.140435813272167e-13,
 -7.123389457665074e-15,  3.928303106824591e-16, -1.941017733927496e-17,  8.693513831992683e-19, -3.557875679237805e-20,  2.952409043404653e-09, -1.228043262039612e-09,
  2.732030293033259e-10, -4.137708348995037e-11,  4.750514139174973e-12, -4.393769358033787e-13,  3.404119276776765e-14, -2.270051105734566e-15,  1.329225743984068e-16,
 -6.939550036118118e-18,  3.269452527734172e-19, -1.401689268761647e-20,  3.318470378217761e-05, -1.263482073743100e-06,  2.998107203623076e-08, -5.700784090273123e-10,
  9.500369139938995e-12, -1.448355670066280e-13,  2.067858837028953e-15, -2.805868039856366e-17,  3.651876137745039e-19, -4.592153459660524e-21,  5.603221886111685e-23,
 -6.658834813894885e-25,  1.576757238544408e-04, -7.060089406917482e-06,  2.043517956910677e-07, -4.803309947120470e-09,  9.909629949463688e-11, -1.862727681868477e-12,
  3.259349490972746e-14, -5.382998714110309e-16,  8.471395313783340e-18, -1.279286521850768e-19,  1.863430934305836e-21, -2.628382583951185e-23,  2.607912779216327e-04,
 -1.440535350560886e-05,  5.201625015898643e-07, -1.513050576746689e-08,  3.820427024751460e-10, -8.697172480841823e-12,  1.825860899548626e-13, -3.587767491012282e-15,
  6.667453535003500e-17, -1.180841745971705e-18,  2.004679731286848e-20, -3.276381712754748e-22,  2.261219906281155e-04, -1.582636089920246e-05,  7.139158123033370e-07,
 -2.548441842637700e-08,  7.784795749212355e-10, -2.119188959393024e-11,  5.267974657707765e-13, -1.215282181068465e-14,  2.631556351011417e-16, -5.393865243187926e-18,
  1.053256256535611e-19, -1.968692542178578e-21,  1.192014654091419e-04, -1.070530452316422e-05,  6.014722691871541e-07, -2.619012966694104e-08,  9.611570385880402e-10,
 -3.105592961740918e-11,  9.071220193558723e-13, -2.437710648855405e-14,  6.102272953352261e-16, -1.436132036978637e-17,  3.200084693362341e-19, -6.786480048776594e-21,
  4.118251601159092e-05, -4.766697072076234e-06,  3.329283840647982e-07, -1.763348804510053e-08,  7.748028442539392e-10, -2.960065127136548e-11,  1.011738968504874e-12,
 -3.153265531676726e-14,  9.083387279341840e-16, -2.442827944598938e-17,  6.180910324039162e-19, -1.479673574559934e-20,  9.817969985311943e-06, -1.464250227580314e-06,
  1.270999858736488e-07, -8.183846741018381e-09,  4.300843827458351e-10, -1.939860603400990e-11,  7.743687894103008e-13, -2.792626611637536e-14,  9.232590686172563e-16,
 -2.828900958445520e-17,  8.101203656679336e-19, -2.181461901411737e-20,  1.700636884944595e-06, -3.255964612370556e-07,  3.512741417348895e-08, -2.750552044507338e-09,
  1.728787010092690e-10, -9.200916977146763e-12,  4.285069020517796e-13, -1.785315981243556e-14,  6.760229536111370e-16, -2.354098492096303e-17,  7.608015705235042e-19,
 -2.296804482506492e-20,  2.299874753530361e-07, -5.603537848998575e-08,  7.496545224431271e-09, -7.128874142614124e-10,  5.351308853468163e-11, -3.354554833454415e-12,
  1.818434854448348e-13, -8.727703106966050e-15,  3.772318085502286e-16, -1.487151193653190e-17,  5.400540492028754e-19, -1.819192165151031e-20,  2.726220472610054e-08,
 -8.297075176403214e-09,  1.362517145949775e-09, -1.561020552661502e-10,  1.389126560776000e-11, -1.018091632324880e-12,  6.375011625441180e-14, -3.497014648650549e-15,
  1.711212926391668e-16, -7.572592989731141e-18,  3.063090808706295e-19, -1.140999490897194e-20,  3.365104284767344e-09, -1.232328628436366e-09,  2.415597753757807e-10,
 -3.254787773912894e-11,  3.358577053903721e-12, -2.818491268903600e-13,  1.998302990248816e-14, -1.228844522085632e-15,  6.681071262411368e-17, -3.258671428631160e-18,
  1.442295144412686e-19, -5.838931743422267e-21,  4.752900259534285e-10, -1.960974763795464e-10,  4.326913474692903e-11, -6.503397470368960e-12,  7.414591596207135e-13,
 -6.814131564120894e-14,  5.248549350423707e-15, -3.481292774130410e-16,  2.028430376035714e-17, -1.054180111362156e-18,  4.945709811350502e-20, -2.112089118764301e-21,
  2.857052513056531e-05, -1.048617027878880e-06,  2.396463307291245e-08, -4.387948814940222e-10,  7.042535329260902e-12, -1.034527483715987e-13,  1.423748704705123e-15,
 -1.863656142781031e-17,  2.340399334094845e-19, -2.841877536735215e-21,  3.352257575251326e-23, -3.840671652530266e-25,  1.323745827497653e-04, -5.631458318292604e-06,
  1.551208106388172e-07, -3.477927024089288e-09,  6.858528378547638e-11, -1.234511972449340e-12,  2.071474777816906e-14, -3.285070436987324e-16,  4.969407207027620e-18,
 -7.220850500873496e-20,  1.013019761116802e-21, -1.376947278184264e-23,  2.104735816484403e-04, -1.087822853843607e-05,  3.702197605927148e-07, -1.020154959042559e-08,
  2.448803038539081e-10, -5.313872965990542e-12,  1.065672880752600e-13, -2.003946249563566e-15,  3.569441296648526e-17, -6.067420334506206e-19,  9.898357831290290e-21,
 -1.556344740919201e-22,  1.725638477948807e-04, -1.115480073782057e-05,  4.707959731704557e-07, -1.583312098986194e-08,  4.577608508074850e-10, -1.183458304079078e-11,
  2.801654167254560e-13, -6.169220983992814e-15,  1.277627927831674e-16, -2.508883686442253e-18,  4.700821395335823e-20, -8.442986181457078e-22,  8.432864774164813e-05,
 -6.929747564614509e-06,  3.622462322415582e-07, -1.479540243007803e-08,  5.121178156796456e-10, -1.567109549951395e-11,  4.349463550013837e-13, -1.113685464206316e-14,
  2.662619433950280e-16, -5.997202347063726e-18,  1.281313736006264e-19, -2.609862012530201e-21,  2.634987002313878e-05, -2.776634586291694e-06,  1.797470334612854e-07,
 -8.903487794894703e-09,  3.681510462699134e-10, -1.329830689082656e-11,  4.313899902159243e-13, -1.280099148035162e-14,  3.520415746745610e-16, -9.060212876111882e-18,
  2.198474268299677e-19, -5.057181395253980e-21,  5.505776903395443e-06, -7.473294611871471e-07,  6.004547416954965e-08, -3.612465419332915e-09,  1.785710215311781e-10,
 -7.614989369208066e-12,  2.886000669611136e-13, -9.915839328661499e-15,  3.132679175354919e-16, -9.196741843078258e-18,  2.529374658658776e-19, -6.555415295961569e-21,
  8.029167329913855e-07, -1.406303673228843e-07,  1.407767188370171e-08, -1.032146131177248e-09,  6.115383026595071e-11, -3.084420435848592e-12,  1.367249001473571e-13,
 -5.441863060239496e-15,  1.974766029132995e-16, -6.608650006808158e-18,  2.057659044912223e-19, -5.998365205411877e-21,  8.697264156040179e-08, -1.961548076003648e-08,
  2.453942194671557e-09, -2.199583877064387e-10,  1.566020454608541e-11, -9.357871902744995e-13,  4.855878468808072e-14, -2.238990892532762e-15,  9.325922298417673e-17,
 -3.552682546278166e-18,  1.249717748866441e-19, -4.086911807225161e-21,  7.826355660747586e-09, -2.248000541684780e-09,  3.503601890893435e-10, -3.832000637577254e-11,
  3.271544817283839e-12, -2.309914587003618e-13,  1.398362501221361e-14, -7.438477217456908e-16,  3.539044679618308e-17, -1.526269318017078e-18,  6.029007535622161e-20,
 -2.197294237676502e-21,  7.109120098040037e-10, -2.520080346032005e-10,  4.790098445604434e-11, -6.278206758248401e-12,  6.320166142679108e-13, -5.187490002457079e-14,
  3.605190429000537e-15, -2.177322365113457e-16,  1.164548759371570e-17, -5.595978888925731e-19,  2.443300538494384e-20, -9.769116852281847e-22,  7.799936991509234e-11,
 -3.186443351470394e-11,  6.961716869164875e-12, -1.036867244135115e-12,  1.172397084127076e-13, -1.069383145425302e-14,  8.180724062142756e-16, -5.392404874019982e-17,
  3.124070430749570e-18, -1.615091152122865e-19,  7.540709520248471e-21, -3.205990022343505e-22,  2.472865394070431e-05, -8.761925571215329e-07,  1.931246239520045e-08,
 -3.409735078821724e-10,  5.276916163977486e-12, -7.478441104746502e-14,  9.930648560577900e-16, -1.255512801541102e-17,  1.522952819431732e-19, -1.785490739437493e-21,
  2.045093867578596e-23, -2.247774885801537e-25,  1.120904263629786e-04, -4.540492408611794e-06,  1.192347659086456e-07, -2.553904696107242e-09,  4.820513682880426e-11,
 -8.319160994860670e-13,  1.340163147292263e-14, -2.043048970209779e-16,  2.973820895958684e-18, -4.161294764066556e-20,  5.629829495452236e-22, -7.376838787380166e-24,
  1.721932829928052e-04, -8.346797746165780e-06,  2.682056075986910e-07, -7.011710145285001e-09,  1.602244348592647e-10, -3.318261890527517e-12,  6.364022569026604e-14,
 -1.146424209546725e-15,  1.959064420271877e-17, -3.198895740947706e-19,  5.019017096660765e-21, -7.597548354191421e-23,  1.344287975237812e-04, -8.039787997182331e-06,
  3.179735918278170e-07, -1.008851849669978e-08,  2.763926375236213e-10, -6.793557731543047e-12,  1.533068466194432e-13, -3.224985782480993e-15,  6.392488051237800e-17,
 -1.203454828892439e-18,  2.164909183865643e-20, -3.738310858390675e-22,  6.145046937223086e-05, -4.623260120600912e-06,  2.251060608507937e-07, -8.632670478021471e-09,
  2.820669449104972e-10, -8.180550229653156e-12,  2.158782006164281e-13, -5.269579762521377e-15,  1.203790654438012e-16, -2.595876217398503e-18,  5.319276161696118e-20,
 -1.040848771616781e-21,  1.756130230835379e-05, -1.682971143872929e-06,  1.010077779341406e-07, -4.680569783260620e-09,  1.821766007289062e-10, -6.223071534827922e-12,
  1.916166488097190e-13, -5.413807908901797e-15,  1.421346474282234e-16, -3.500249085868267e-18,  8.143919213113668e-20, -1.799689010664683e-21,  3.258543315504405e-06,
 -4.013201262736682e-07,  2.981564009979979e-08, -1.674740264354889e-09,  7.781788332098470e-11, -3.135460754663807e-12,  1.127447927648770e-13, -3.688125939756029e-15,
  1.112664235377730e-16, -3.127446624986177e-18,  8.254446820867519e-20, -2.057421723992916e-21,  4.056946740431417e-07, -6.466149326194207e-08,  5.988683152735983e-09,
 -4.102066569766982e-10,  2.286688201783766e-11, -1.091069444717584e-12,  4.595734010476273e-14, -1.744653836527320e-15,  6.058047560142661e-17, -1.945424476385881e-18,
  5.827114794016276e-20, -1.637933712408881e-21,  3.560853493885980e-08, -7.378942919022454e-09,  8.589481477658218e-10, -7.228135878844105e-11,  4.864217117608051e-12,
 -2.762294565377349e-13,  1.368286359549781e-14, -6.045349949425240e-16,  2.420705080536224e-17, -8.890678682785675e-19,  3.022924227303440e-20, -9.577741675860798e-22,
  2.436495184153898e-09, -6.549078117461776e-10,  9.624647184387109e-11, -9.995832013379505e-12,  8.149846097440102e-13, -5.521284615945858e-14,  3.219806471242159e-15,
 -1.655497250483223e-16,  7.635510076600169e-18, -3.200421106644439e-19,  1.231498252022348e-20, -4.381159492788041e-22,  1.597005085011140e-10, -5.442927928499019e-11,
  9.974804427329681e-12, -1.265561223330173e-12,  1.237742841271573e-13, -9.900525655019799e-15,  6.723258043128818e-16, -3.976645997805616e-17,  2.087158452249159e-18,
 -9.858929313116677e-20,  4.237876240265232e-21, -1.670487442464173e-22,  1.310083144236730e-11, -5.286954299524242e-12,  1.141260253477237e-12, -1.681215921146925e-13,
  1.882249126218478e-14, -1.701616070667727e-15,  1.291273466625263e-16, -8.449531465020427e-18,  4.862720001396075e-19, -2.498697053649140e-20,  1.160130912835275e-21,
 -4.907218837774119e-23,  2.150885551122596e-05, -7.367300798499508e-07,  1.568189695880400e-08, -2.673237243072609e-10,  3.993701658739321e-12, -5.467286887241399e-14,
  7.011095221599649e-16, -8.569681124543714e-18,  1.006437456381183e-19, -1.134742959135130e-21,  1.274488099253349e-23, -1.339576509892071e-25,  9.565909195534397e-05,
 -3.697249811152244e-06,  9.271826207352220e-08, -1.900021190105609e-09,  3.437006295650261e-11, -5.694132486953157e-13,  8.815822335007066e-15, -1.293288091372546e-16,
  1.813558641520422e-18, -2.444548054117747e-20,  3.195459423473673e-22, -4.037887724087468e-24,  1.426199868972495e-04, -6.498687967602264e-06,  1.974983701410170e-07,
 -4.905817554650769e-09,  1.068582865130791e-10, -2.114656892758384e-12,  3.882824338618413e-14, -6.707387827002847e-16,  1.100676406314855e-17, -1.727931829506700e-19,
  2.609547831441803e-21, -3.805934076350171e-23,  1.066844845276517e-04, -5.914233898187900e-06,  2.195339945512858e-07, -6.580296306957889e-09,  1.710450623425263e-10,
 -4.001402284078538e-12,  8.616061289479489e-14, -1.733037864571919e-15,  3.290483463268689e-17, -5.943253782799793e-19,  1.027108249002264e-20, -1.706173938281241e-22,
  4.599699678345886e-05, -3.170883823509729e-06,  1.439847757274701e-07, -5.190294700235868e-09,  1.602456385615684e-10, -4.408377392333298e-12,  1.106906975623476e-13,
 -2.577438369728154e-15,  5.628856155832686e-17, -1.162642735427139e-18,  2.285776501666125e-20, -4.298094869280114e-22,  1.214907592768808e-05, -1.058082830430489e-06,
  5.891063112408808e-08, -2.555157567021463e-09,  9.365780902571214e-11, -3.026625048159236e-12,  8.848401109869409e-14, -2.380757125459010e-15,  5.967721548647181e-17,
 -1.406313907944863e-18,  3.137306021457116e-20, -6.659788280209123e-22,  2.027652334886362e-06, -2.259757457107843e-07,  1.551507934802071e-08, -8.133199871405318e-10,
  3.551141121189910e-11, -1.351436102880368e-12,  4.608777737651539e-14, -1.434759238443987e-15,  4.131401496908440e-17, -1.111220986479019e-18,  2.812992463452250e-20,
 -6.738855453430143e-22,  2.186923844370722e-07, -3.156014562970402e-08,  2.698012037816222e-09, -1.723418812250018e-10,  9.024920735421714e-12, -4.067838986562026e-13,
  1.625935057950089e-14, -5.879452995733014e-16,  1.950970155334382e-17, -6.004246158853408e-19,  1.727915541319579e-20, -4.677331740482057e-22,  1.577434998608152e-08,
 -2.981023463009999e-09,  3.214001775843759e-10, -2.529899528338696e-11,  1.604215119590145e-12, -8.633403822623944e-14,  4.071829225206819e-15, -1.719699533168920e-16,
  6.604986135991125e-18, -2.333784608360210e-19,  7.654205607782978e-21, -2.344967849133383e-22,  8.261986049568591e-10, -2.059012524883173e-10,  2.834257114436346e-11,
 -2.779909709635435e-12,  2.154487363320605e-13, -1.394781113559695e-14,  7.806755117660485e-16, -3.866880916090327e-17,  1.723684381117913e-18, -7.002208130351702e-20,
  2.617874780045237e-21, -9.069296284160006e-23,  3.848856973337630e-11, -1.250928526507688e-11,  2.195536472065915e-12, -2.681545689393465e-13,  2.535857821465472e-14,
 -1.968648096807371e-15,  1.301604000817566e-16, -7.515876119780373e-18,  3.860068768031301e-19, -1.787838011518333e-20,  7.548810742356645e-22, -2.927536599452335e-23,
  2.263487171247941e-12, -8.995839604102356e-13,  1.913294683019852e-13, -2.781106241913315e-14,  3.076721766814107e-15, -2.751933345744980e-16,  2.068401239576294e-17,
 -1.341837848101948e-18,  7.662199266155537e-20, -3.909348749587543e-21,  1.803372819187399e-22, -7.583090218223592e-24,  1.879395997530776e-05, -6.230976990808654e-07,
  1.282407687728148e-08, -2.113333968461555e-10,  3.050807134944551e-12, -4.039621911197185e-14,  5.007456456099380e-16, -5.914762007707248e-18,  6.770863989496548e-20,
 -7.257628084240571e-22,  8.066632399037148e-24, -8.396218442337195e-26,  8.222132745371352e-05, -3.038152562180800e-06,  7.287585794239781e-08, -1.430833308922477e-09,
  2.483501434113532e-11, -3.954630121430291e-13,  5.890554504016289e-15, -8.321828000581259e-17,  1.126433743189038e-18, -1.461288224805907e-20,  1.849321904567177e-22,
 -2.262641626960282e-24,  1.194495415308399e-04, -5.128029150099036e-06,  1.476394209323776e-07, -3.489534550966492e-09,  7.254637936554991e-11, -1.373447822696506e-12,
  2.417010306648240e-14, -4.007769337712510e-16,  6.321733765240154e-18, -9.549299173130598e-20,  1.389256042914998e-21, -1.953846437925956e-23,  8.609848186363684e-05,
 -4.432718104239909e-06,  1.546733537904625e-07, -4.386032072089135e-09,  1.083053326944111e-10, -2.414124345615712e-12,  4.965080881253095e-14, -9.557813439627105e-16,
  1.739609583602419e-17, -3.017047785780000e-19,  5.012141434877335e-21, -8.013884031420732e-23,  3.527650408296805e-05, -2.230424408505717e-06,  9.458365162864789e-08,
 -3.208679379296752e-09,  9.370637672860706e-11, -2.447453992468943e-12,  5.851962433970133e-14, -1.300756075302647e-15,  2.717272930925926e-17, -5.378960531163770e-19,
  1.015055068619359e-20, -1.834826662849143e-22,  8.695845672244880e-06, -6.879198593502944e-07,  3.556233667567675e-08, -1.444815999187896e-09,  4.990615978103783e-11,
 -1.526505012540115e-12,  4.239059882958655e-14, -1.086547363872845e-15,  2.601011449041886e-17, -5.866402331047738e-19,  1.254956773655133e-20, -2.559090056311708e-22,
  1.321526877443396e-06, -1.329574292903911e-07,  8.435312788231843e-09, -4.126470384243892e-10,  1.692920215611966e-11, -6.084455756148840e-13,  1.967592906759788e-14,
 -5.827929316853205e-16,  1.601275788472744e-17, -4.120008858387123e-19,  9.999163278539969e-21, -2.301277745297184e-22,  1.253172628194457e-07, -1.629764163303954e-08,
  1.283788992163981e-09, -7.637017527205106e-11,  3.752497149483500e-12, -1.596031513675828e-13,  6.047230488094324e-15, -2.080709134392557e-16,  6.591059857741601e-18,
 -1.941897650250882e-19,  5.363497159532669e-21, -1.396641456284173e-22,  7.548220296579264e-09, -1.291232623767789e-09,  1.284154088031544e-10, -9.424833949616079e-12,
  5.615806848835781e-13, -2.857056486945160e-14,  1.280061957034500e-15, -5.156728287066397e-17,  1.895827126653996e-18, -6.431709658640801e-20,  2.030894567087909e-21,
 -6.005203310182930e-23,  3.061272586664049e-10, -7.003877969879906e-11,  8.969620032973685e-12, -8.263816220103156e-13,  6.060163053548844e-14, -3.733905500924367e-15,
  1.998596601825174e-16, -9.505366644811859e-18,  4.082534978035817e-19, -1.602838254476059e-20,  5.806976273591452e-22, -1.954248764901860e-23,  1.004510611752205e-11,
 -3.083075413525861e-12,  5.142773422209580e-13, -6.008589837887907e-14,  5.465023290587711e-15, -4.098792738618338e-16,  2.627917208691770e-17, -1.476165450108394e-18,
  7.395297202672122e-20, -3.349030686092450e-21,  1.385466715654059e-22, -5.274145088452411e-24,  4.048921479262870e-13, -1.578245732408647e-13,  3.295355299145243e-14,
 -4.712030268026779e-15,  5.137772683240779e-16, -4.536654431118934e-17,  3.370964728845489e-18, -2.164525867782108e-19,  1.224637042270448e-20, -6.196354737520059e-22,
  2.836815583989544e-23, -1.184693339812367e-24,  1.649178864998279e-05, -5.298766901827674e-07,  1.055626336081483e-08, -1.683830977684339e-10,  2.350817483195485e-12,
 -3.014293311392595e-14,  3.619428086714257e-16, -4.110531124021824e-18,  4.657995150531413e-20, -4.683812011920769e-22,  4.977538817246864e-24, -5.974568199421219e-26,
  7.113479013703036e-05, -2.517625428365126e-06,  5.785189481897144e-08, -1.089790594684261e-09,  1.816990770008287e-11, -2.784173406703146e-13,  3.995151895895520e-15,
 -5.433617059507782e-17,  7.125618650038760e-19, -8.882651925373454e-21,  1.084836680063639e-22, -1.308833299563211e-24,  1.010597931417223e-04, -4.096579100127217e-06,
  1.119155609557274e-07, -2.520467667894330e-09,  5.007522018967128e-11, -9.079978823481076e-13,  1.533140381701070e-14, -2.442409886554712e-16,  3.707032202645329e-18,
 -5.392395213094349e-20,  7.562063791221100e-22, -1.026729097901284e-23,  7.054627579741335e-05, -3.379691576295536e-06,  1.110322909606109e-07, -2.982745487848046e-09,
  7.005837782984779e-11, -1.489549031546189e-12,  2.929007084773663e-14, -5.401709230967765e-16,  9.430667049297564e-18, -1.571977556924508e-19,  2.512343426913447e-21,
 -3.866947196519623e-23,  2.765592105524584e-05, -1.605563042092966e-06,  6.367714880369549e-08, -2.035480285956608e-09,  5.629284281322262e-11, -1.397217978511574e-12,
  3.183965348048368e-14, -6.761480780865730e-16,  1.351823487138996e-17, -2.566360484698434e-19,  4.651062878639628e-21, -8.084060719469144e-23,  6.419859502519366e-06,
 -4.612042699995531e-07,  2.216242661348280e-08, -8.441524805637627e-10,  2.749984297326552e-11, -7.966848452276713e-13,  2.102611721411325e-14, -5.136665206187236e-16,
  1.174664217115851e-17, -2.536515352959391e-19,  5.204448557540860e-21, -1.019594978690100e-22,  8.987632815296705e-07, -8.145923525902330e-08,  4.777302017978532e-09,
 -2.181319875616805e-10,  8.410501890649580e-12, -2.855065079113922e-13,  8.755280789765052e-15, -2.467326645288359e-16,  6.467860302487865e-18, -1.591661852944530e-19,
  3.702661575181659e-21, -8.184225873862878e-23,  7.603862751897918e-08, -8.872124937724292e-09,  6.432567997904982e-10, -3.560342146207392e-11,  1.640195353963121e-12,
 -6.577896690937334e-14,  2.360717930139751e-15, -7.722877666754196e-17,  2.333445141941983e-18, -6.576061151495559e-20,  1.741674261919160e-21, -4.358874013473760e-23,
  3.891231118028369e-09, -5.981511309971776e-10,  5.468474937162831e-11, -3.731979232028795e-12,  2.084739908497568e-13, -1.000532379921467e-14,  4.250017640590011e-16,
 -1.630033841626462e-17,  5.725814298554672e-19, -1.861822396936924e-20,  5.650344811097104e-22, -1.609868249533555e-23,  1.241597723575811e-10, -2.580788937210283e-11,
  3.055055352406815e-12, -2.630259292641942e-13,  1.817150492184889e-14, -1.061466329133448e-15,  5.414338344948191e-17, -2.464605580207950e-18,  1.016902357571611e-19,
 -3.847819771110431e-21,  1.347380368449227e-22, -4.394016705993737e-24,  2.865818313509532e-12, -8.211142669762046e-13,  1.290596951090793e-13, -1.432450940459478e-14,
  1.245786798927211e-15, -8.981426492218260e-17,  5.559499254626455e-18, -3.026154582320009e-19,  1.473697844445405e-20, -6.505010949388010e-22,  2.629237883832938e-23,
 -9.799712705062355e-25,  7.561190538216071e-14, -2.874618963290950e-14,  5.864521563894649e-15, -8.216758062731383e-16,  8.801141976214574e-17, -7.650865501499456e-18,
  5.606983306835098e-19, -3.556350602740644e-20,  1.990134884672156e-21, -9.970794984166867e-23,  4.524401143919531e-24, -1.874318066045716e-25,  1.452923093472016e-05,
 -4.529124831399807e-07,  8.742879138116452e-09, -1.351572028858151e-10,  1.826311387771385e-12, -2.268334041307130e-14,  2.654262032940180e-16, -2.856246748297162e-18,
  3.270244956059754e-20, -3.182691775331868e-22,  2.600547406112709e-24, -4.956910814444181e-26,  6.191355366628609e-05, -2.102569743070828e-06,  4.635052939488040e-08,
 -8.388836025926492e-10,  1.344932609148671e-11, -1.984821372730801e-13,  2.750267026502867e-15, -3.591477523934973e-17,  4.586558722707604e-19, -5.519754326119026e-21,
  6.341442361344105e-23, -7.901662868443304e-25,  8.629013005106050e-05, -3.309877508094888e-06,  8.593683237842368e-08, -1.846656747831142e-09,  3.510322153772533e-11,
 -6.103094900166183e-13,  9.898583114465111e-15, -1.516195988856770e-16,  2.216629116516615e-18, -3.108310539767008e-20,  4.201867064549703e-22, -5.517031990921058e-24,
  5.860153902115522e-05, -2.617588374660248e-06,  8.109286072358312e-08, -2.066534697436530e-09,  4.622824129360063e-11, -9.385933221167746e-13,  1.766062057100762e-14,
 -3.124376880231983e-16,  5.234497319614567e-18, -8.391931798954989e-20,  1.292611707722964e-21, -1.913076282290671e-23,  2.211692786722596e-05, -1.180420008303775e-06,
  4.385213869904394e-08, -1.322486217973480e-09,  3.467707512844823e-11, -8.187764660531624e-13,  1.779544043124821e-14, -3.614411626969394e-16,  6.918984491072077e-18,
 -1.260483325321657e-19,  2.196253048191781e-21, -3.669591684295791e-23,  4.874647131469608e-06, -3.179985573520851e-07,  1.422385192221171e-08, -5.084279229981052e-10,
  1.563574462903607e-11, -4.293659411277028e-13,  1.077576933928821e-14, -2.510846684107776e-16,  5.487078470112429e-18, -1.134814734282200e-19,  2.234320446953016e-21,
 -4.205421639025652e-23,  6.355236267666405e-07, -5.179345405987845e-08,  2.810139210568666e-09, -1.198152287335698e-10,  4.343682803365419e-12, -1.393175837021384e-13,
  4.052131968304632e-15, -1.086687322027503e-16,  2.717880063441710e-18, -6.396955477728857e-20,  1.426312073994108e-21, -3.027298818972121e-23,  4.865576805422828e-08,
 -5.072003929892385e-09,  3.383357752457047e-10, -1.741390411916674e-11,  7.518507828229576e-13, -2.841860460144842e-14,  9.655742917018320e-16, -3.001770726271398e-17,
  8.645989997098071e-19, -2.329208934486578e-20,  5.911541385999803e-22, -1.420912447154503e-23,  2.153704250515476e-09, -2.953533417943554e-10,  2.475719778126480e-11,
 -1.567607635434433e-12,  8.194537588217583e-14, -3.703704069530609e-15,  1.489140839683904e-16, -5.429005942746919e-18,  1.819300583566804e-19, -5.661304037102106e-21,
  1.648825657634104e-22, -4.519778017266712e-24,  5.513200386404082e-11, -1.029913796572013e-11,  1.120199096644269e-12, -8.969744372283583e-14,  5.814503090878585e-15,
 -3.208554391788192e-16,  1.554560836341858e-17, -6.752344856585737e-19,  2.668873921660517e-20, -9.706924023444557e-22,  3.277006830862797e-23, -1.033123655978032e-24,
  9.016561748295136e-13, -2.379685361346044e-13,  3.491629197377306e-14, -3.654278484099272e-15,  3.020013676477689e-16, -2.081715329426083e-17,  1.238240389002088e-18,
 -6.503981387281048e-20,  3.067388477554192e-21, -1.315284209430121e-22,  5.178205209281576e-24, -1.884452447109430e-25,  1.489886154227151e-14, -5.482674776325690e-15,
  1.086068739221580e-15, -1.483496788934613e-16,  1.554483459369257e-17, -1.325737920899367e-18,  9.554354708894186e-20, -5.971128424183322e-21,  3.297869316878291e-22,
 -1.633015927031517e-23,  7.332530225228875e-25, -3.009038597056551e-26,  1.284785364489096e-05, -3.889925958714854e-07,  7.282399293869837e-09, -1.092446327129925e-10,
  1.430437399578396e-12, -1.716453060490627e-14,  1.984986271263676e-16, -1.977140551676249e-18,  2.261337763562689e-20, -2.553801063743747e-22,  6.189447165597849e-25,
 -3.893376403119592e-26,  5.418592220990636e-05, -1.768653680694031e-06,  3.745481319113636e-08, -6.521794413758580e-10,  1.006614359537235e-11, -1.430522676381408e-13,
  1.923385325605930e-15, -2.398944090811708e-17,  2.981492988475391e-19, -3.579128895203825e-21,  3.581276173448803e-23, -4.863640042963008e-25,  7.429761754775758e-05,
 -2.702324729564459e-06,  6.678224447230005e-08, -1.371058372006251e-09,  2.496624267409821e-11, -4.166010748749851e-13,  6.498704542614629e-15, -9.576904583142503e-17,
  1.349623402550272e-18, -1.828159924094488e-20,  2.379033512065147e-22, -3.026895994041378e-24,  4.928765734164697e-05, -2.056755612094151e-06,  6.018010350719015e-08,
 -1.456694734076784e-09,  3.107347114483893e-11, -6.032611285899318e-13,  1.086588812132626e-14, -1.847321558152766e-16,  2.972011102252948e-18, -4.577440677358106e-20,
  6.827903278410330e-22, -9.694346522972017e-24,  1.800821932971613e-05, -8.847592749277793e-07,  3.083765428064366e-08, -8.784911034819766e-10,  2.186619260937633e-11,
 -4.917676520275172e-13,  1.019739760745355e-14, -1.984023103963627e-16,  3.638587001022282e-18, -6.358210162963662e-20,  1.068027266735849e-21, -1.713754755968030e-23,
  3.796839764926374e-06, -2.249312723267227e-07,  9.380117264139151e-09, -3.149792425722058e-10,  9.153662567441678e-12, -2.385078771901589e-13,  5.694235246695575e-15,
 -1.266794050656362e-16,  2.646748156299911e-18, -5.243018831961261e-20,  9.916850469085288e-22, -1.792963447642503e-23,  4.656326003088967e-07, -3.406392481084510e-08,
  1.712063028050676e-09, -6.820468955285094e-11,  2.326394803751574e-12, -7.054156774559896e-14,  1.946436579663715e-15, -4.969663006794332e-17,  1.186088636986525e-18,
 -2.670048468008661e-20,  5.707480102664038e-22, -1.163060833218941e-23,  3.269823911954959e-08, -3.032918114780288e-09,  1.862046677098287e-10, -8.910211501746937e-12,
  3.605157485280428e-13, -1.284190393624899e-14,  4.129650616332922e-16, -1.219718924820028e-17,  3.347770235900515e-19, -8.617542577123059e-21,  2.094963490124803e-22,
 -4.833514322504753e-24,  1.274637792391481e-09, -1.548355356218535e-10,  1.188001594716658e-11, -6.967695153321979e-13,  3.403775977317656e-14, -1.446940337828240e-15,
  5.499618697272884e-17, -1.903506744822947e-18,  6.077605211377041e-20, -1.807601620196494e-21,  5.045792868827038e-23, -1.329042453173020e-24,  2.676537566457471e-11,
 -4.443544113612742e-12,  4.417862054263999e-13, -3.276222294860903e-14,  1.985668830234924e-15, -1.031819287104772e-16,  4.734610880800816e-18, -1.956954940409377e-19,
  7.390321825863321e-21, -2.577248203460018e-22,  8.368368971301239e-24, -2.544665921889937e-25,  3.152129313220312e-13, -7.547353942073699e-14,  1.023765915045373e-14,
 -1.002592314339615e-15,  7.823387732872380e-17, -5.127625488995432e-18,  2.916588177145986e-19, -1.471891091484192e-20,  6.696235172141633e-22, -2.779356173776983e-23,
  1.062356184245355e-24, -3.763649701417483e-26,  3.139803169056536e-15, -1.106713100314993e-15,  2.111325654344994e-16, -2.793332345012957e-17,  2.848337630140198e-18,
 -2.372844236049198e-19,  1.675524599813800e-20, -1.028586347603137e-21,  5.591996566324945e-23, -2.730503274225470e-24,  1.210817972130676e-25, -4.913559679282576e-27,
  1.140061595937307e-05, -3.356125611714735e-07,  6.098247436521472e-09, -8.886257597779534e-11,  1.130689227633521e-12, -1.299151322528271e-14,  1.519038403632472e-16,
 -1.398804460395146e-18,  1.351261793010759e-20, -2.578534586531852e-22, -5.112906237320058e-25, -6.723400345754433e-27,  4.766461681480567e-05, -1.497784001900996e-06,
  3.050813909571519e-08, -5.117118306355456e-10,  7.617402157405412e-12, -1.039834931835847e-13,  1.367631275876356e-15, -1.627137131849577e-17,  1.905735163170913e-19,
 -2.504050176381649e-21,  1.966648909710644e-23, -2.475169864649515e-25,  6.446145050341949e-05, -2.227669129291146e-06,  5.247650155525290e-08, -1.030611461504199e-09,
  1.799956720537385e-11, -2.884786974734953e-13,  4.334589290088686e-15, -6.150677047224747e-17,  8.349264325013761e-19, -1.097520770747128e-20,  1.371186027035950e-22,
 -1.686196269804658e-24,  4.192363720346978e-05, -1.637617056652803e-06,  4.532618617339601e-08, -1.043454961719428e-09,  2.124679419950309e-11, -3.951559563779663e-13,
  6.810370080661297e-15, -1.114559262035461e-16,  1.728014086324143e-18, -2.539003670495335e-20,  3.698473402683862e-22, -5.070079915631518e-24,  1.490332892665613e-05,
 -6.749476056191697e-07,  2.210877790358256e-08, -5.956939736435261e-10,  1.408822841294640e-11, -3.023891339966073e-13,  5.979343157362752e-15, -1.116226097545959e-16,
  1.966332712103290e-18, -3.281728479036337e-20,  5.342876455725335e-22, -8.254129168354467e-24,  3.026349384698338e-06, -1.628391902378481e-07,  6.342830686265505e-09,
 -2.003103416561758e-10,  5.505760701570876e-12, -1.363440568783543e-13,  3.095990874709044e-15, -6.584185625390555e-17,  1.317091800814364e-18, -2.495124740768234e-20,
  4.544469419867821e-22, -7.898182705958632e-24,  3.523565634860746e-07, -2.310127001598188e-08,  1.077475974219735e-09, -4.013682309795039e-11,  1.288896009477911e-12,
 -3.698855769242745e-14,  9.682321633547465e-16, -2.355229490044408e-17,  5.367259623610898e-19, -1.155126035542811e-20,  2.369031766694029e-22, -4.635394466579738e-24,
  2.298516452870292e-08, -1.889430945648913e-09,  1.068885018491214e-10, -4.755670964257890e-12,  1.803475977144087e-13, -6.056134937027377e-15,  1.842849717874830e-16,
 -5.171387444539901e-18,  1.352465232519962e-19, -3.325214244860800e-21,  7.741896198936310e-23, -1.713914374460667e-24,  8.030858796162362e-10, -8.579171584151542e-11,
  6.022292304463509e-12, -3.267810777700592e-13,  1.490441273270998e-14, -5.954352039080402e-16,  2.137342353627920e-17, -7.016797860382324e-19,  2.132516795117290e-20,
 -6.055798585246485e-22,  1.618545061443057e-23, -4.091978852944832e-25,  1.416676622947797e-11, -2.066083057250159e-12,  1.870288026560022e-13, -1.279969951888807e-14,
  7.231759381949698e-16, -3.529195501266863e-17,  1.529792445318307e-18, -6.002512875341614e-20,  2.160813876750328e-21, -7.209001125162436e-23,  2.246498652528797e-24,
 -6.574993590752653e-26,  1.231256545918367e-13, -2.629268439560620e-14,  3.265699721479789e-15, -2.969971642885410e-16,  2.174403596651749e-17, -1.347671188222126e-18,
  7.294489120133337e-20, -3.521341636232898e-21,  1.539173675137003e-22, -6.161270055547151e-24,  2.278756701005569e-25, -7.834686871937264e-27,  7.197216517291600e-16,
 -2.394913975949031e-16,  4.353629932856370e-17, -5.533217171286117e-18,  5.454411577864355e-19, -4.414490360732082e-20,  3.040470073186161e-21, -1.826470321186594e-22,
  9.742707818097357e-24, -4.678051424102603e-25,  2.043752386460412e-26, -8.184299000248314e-28,  1.014939381187299e-05, -2.908029609558527e-07,  5.132475421702326e-09,
 -7.266465660496208e-11,  9.043590176758778e-13, -9.775671266832257e-15,  1.173691376048361e-16, -1.118379450350436e-18,  3.957726086194706e-21, -2.651074963294190e-22,
  7.159313627959893e-25,  7.102680229314378e-26,  4.212545134654625e-05, -1.276356314206576e-06,  2.503561987125285e-08, -4.048308864046169e-10,  5.832286619523278e-12,
 -7.601671949077019e-14,  9.848394396607026e-16, -1.148022448056350e-17,  1.126700456026491e-19, -1.856380295416350e-21,  1.481864303265767e-23,  4.121288947225417e-26,
  5.631844822151924e-05, -1.852835051333085e-06,  4.166355717168179e-08, -7.836582312235170e-10,  1.314497834192578e-11, -2.024262658889313e-13,  2.933833666750463e-15,
 -4.018166387402837e-17,  5.230208030600923e-19, -6.721800461886322e-21,  8.102929204681145e-23, -9.297172783992799e-25,  3.602651901490093e-05, -1.319862063012631e-06,
  3.460973264390649e-08, -7.588090209875214e-10,  1.475443072037824e-11, -2.636601319835536e-13,  4.344418318227187e-15, -6.831601271316767e-17,  1.033833481138047e-18,
 -1.427860920996330e-20,  2.018045388840147e-22, -2.844514075046515e-24,  1.251686804562506e-05, -5.232524701672735e-07,  1.613597664932877e-08, -4.118149026574670e-10,
  9.254927932295522e-12, -1.902398705607383e-13,  3.582966018971262e-15, -6.409757215134142e-17,  1.095582560323701e-18, -1.727570813345740e-20,  2.721722565797231e-22,
 -4.182081959914378e-24,  2.463124928349887e-06, -1.203976854120544e-07,  4.389222648368499e-09, -1.305466959120504e-10,  3.394087836517108e-12, -8.012007091659149e-14,
  1.729000503969777e-15, -3.514120520756383e-17,  6.767100350263100e-19, -1.219809699743667e-20,  2.140480276668457e-22, -3.615926505122746e-24,  2.745706379615714e-07,
 -1.610645644991036e-08,  6.987073145982991e-10, -2.436373109146695e-11,  7.366936174955245e-13, -2.005128652649805e-14,  4.977499248613406e-16, -1.153755855049664e-17,
  2.516439048459604e-19, -5.168398380434481e-21,  1.017618536981778e-22, -1.917332359073166e-24,  1.683504886692496e-08, -1.221397689646048e-09,  6.379913603526526e-11,
 -2.640448757405003e-12,  9.385020581949588e-14, -2.974230808584477e-15,  8.561683600634260e-17, -2.282821641028343e-18,  5.692303383175416e-20, -1.335818681720548e-21,
  2.978786840095887e-23, -6.329283526905382e-25,  5.361638272184542e-10, -4.999716320423829e-11,  3.213638731173672e-12, -1.612219601160684e-13,  6.860812292036407e-15,
 -2.575426624423530e-16,  8.724036627443407e-18, -2.714902268518408e-19,  7.849445215396147e-21, -2.126382878948897e-22,  5.437495604415526e-24, -1.318430441339414e-25,
  8.142532127236138e-12, -1.030574533152138e-12,  8.474693226071656e-14, -5.337184575257875e-15,  2.804325004897262e-16, -1.282610157900273e-17,  5.240879483194416e-19,
 -1.948202367848613e-20,  6.672144400428259e-22, -2.125363045067929e-23,  6.344252764196750e-25, -1.783802259109949e-26,  5.389840875251217e-14, -1.007234544859785e-14,
  1.135632264921471e-15, -9.522731800184661e-17,  6.502494810244937e-18, -3.791231403610909e-19,  1.943557582628693e-20, -8.936325317746412e-22,  3.738055773655558e-23,
 -1.437829592182451e-24,  5.128146868350153e-26, -1.705670446228484e-27,  1.831313407202489e-16, -5.638952988699709e-17,  9.637477084416252e-18, -1.164692247711063e-18,
  1.100944670885115e-19, -8.599727916080643e-21,  5.745664780867353e-22, -3.361921080804342e-23,  1.752623417426129e-24, -8.247449719954715e-26,  3.539536238918622e-27,
 -1.395211411768620e-28,  9.063107933223143e-06, -2.529989923114819e-07,  4.341333120987852e-09, -5.961646943792796e-11,  7.345155478841735e-13, -7.328711753127987e-15,
  8.647672059933187e-17, -1.130941844760750e-18, -4.035856202391051e-21, -1.431694045690382e-22,  6.104417952198017e-24,  1.670760274976126e-25,  3.739192600183081e-05,
 -1.094024573130128e-06,  2.069125505600783e-08, -3.224954561012981e-10,  4.524135579710735e-12, -5.588797761290771e-14,  7.046876709458378e-16, -8.820235465366985e-18,
  5.783837207990007e-20, -1.130098557807723e-21,  2.376761133989911e-23,  3.451351454788445e-25,  4.951883806262363e-05, -1.553851357705207e-06,  3.339939836581375e-08,
 -6.022522234305188e-10,  9.718342062463472e-12, -1.438270886334358e-13,  2.010724833711639e-15, -2.676187448330805e-17,  3.309202570731197e-19, -4.148227962260088e-21,
  5.094982155190915e-23, -4.756009333244892e-25,  3.124833705488013e-05, -1.075760762514348e-06,  2.676315749065727e-08, -5.598473214246700e-10,  1.038643712382365e-11,
 -1.790348238457406e-13,  2.827254846103894e-15, -4.212186863398224e-17,  6.383378013974750e-19, -8.348526228248334e-21,  1.021985487980355e-22, -1.799943507127293e-24,
  1.065394337092065e-05, -4.116760051435874e-07,  1.197073660679965e-08, -2.900478692816574e-10,  6.182951923875240e-12, -1.223315101423848e-13,  2.198660745748154e-15,
 -3.720718353039192e-17,  6.314195086950279e-19, -9.416891411714061e-21,  1.341768544131566e-22, -2.319237164872406e-24,  2.042999589593059e-06, -9.073558669982476e-08,
  3.102100390306076e-09, -8.710107750225011e-11,  2.138063484212058e-12, -4.833810768232181e-14,  9.923851594993899e-16, -1.912936603129370e-17,  3.595862457713257e-19,
 -6.157582371920147e-21,  1.013962169075516e-22, -1.752255127962215e-24,  2.197199113607588e-07, -1.151262308812724e-08,  4.656687657871578e-10, -1.523119490919755e-11,
  4.330243872710156e-13, -1.121940676133800e-14,  2.642340785341386e-16, -5.816279396255632e-18,  1.222382553784008e-19, -2.392384328710454e-21,  4.487167730191757e-23,
 -8.275678666533038e-25,  1.280044628892217e-08, -8.161089822657287e-10,  3.947046063208227e-11, -1.521605157021223e-12,  5.063752437928167e-14, -1.518007029632536e-15,
  4.134009433866351e-17, -1.046012441748453e-18,  2.493192949768555e-20, -5.579560165201562e-22,  1.189561674731201e-23, -2.435366049075791e-25,  3.775385649262185e-10,
 -3.048915408229238e-11,  1.798480977500207e-12, -8.343137759755800e-14,  3.309344591513881e-15, -1.168152815687636e-16,  3.732367374791630e-18, -1.100177364205708e-19,
  3.026782719702904e-21, -7.815174273221378e-23,  1.910522800033927e-24, -4.443008515886992e-26,  5.057190070587626e-12, -5.483333182589237e-13,  4.095169904365276e-14,
 -2.368686318798414e-15,  1.155089074485174e-16, -4.944926050031235e-18,  1.901445260311328e-19, -6.685298073357809e-21,  2.174945211201667e-22, -6.603684800716253e-24,
  1.885118210879362e-25, -5.083885230287898e-27,  2.644465982458826e-14, -4.235259041201990e-15,  4.305250584457280e-16, -3.307636358605987e-17,  2.095281881308262e-18,
 -1.143858166581313e-19,  5.529773240840982e-21, -2.411981876118733e-22,  9.619259837325131e-24, -3.542813048858866e-25,  1.214468716544658e-26, -3.895604884593908e-28,
  5.292914254739039e-17, -1.467708623642963e-17,  2.320365451441880e-18, -2.634028399714215e-19,  2.364734715327738e-20, -1.768827295943138e-21,  1.138951230923023e-22,
 -6.455649869685765e-24,  3.273712148520384e-25, -1.503730543491764e-26,  6.317571683728300e-28, -2.443850543335215e-29,  8.116310665724675e-06, -2.209405913310805e-07,
  3.691947163877945e-09, -4.893511959255742e-11,  6.060424287763258e-13, -5.650573598220806e-15,  5.264863482558253e-17, -1.280761517353966e-18, -3.002721258772183e-21,
  2.460683859636993e-22,  1.273339172760003e-23,  7.586448767957086e-26,  3.332401043270827e-05, -9.428231323652817e-07,  1.722149585079922e-08, -2.582130673415112e-10,
  3.556444515010703e-12, -4.176018742037241e-14,  4.790059446657332e-16, -7.405553702902513e-18,  3.810997287506247e-20,  1.334580115187813e-22,  3.813989955165660e-23,
  1.561971671486164e-25,  4.379551546408873e-05, -1.313123653951184e-06,  2.701825204876601e-08, -4.673839805615869e-10,  7.269325253986614e-12, -1.034899118546232e-13,
  1.389788060422441e-15, -1.820411862815685e-17,  2.140075749683154e-19, -2.446470394986189e-21,  3.568962975758559e-23, -2.648254925381876e-25,  2.733461366650855e-05,
 -8.859530773238991e-07,  2.093486397560869e-08, -4.189859397191642e-10,  7.399591314487988e-12, -1.232785128808351e-13,  1.893429078875378e-15, -2.585636345204567e-17,
  3.943312279861585e-19, -5.618066486934968e-21,  4.029417764375335e-23, -9.650757747685781e-25,  9.178878102503964e-06, -3.283195685859107e-07,  9.011396867946114e-09,
 -2.081434458271469e-10,  4.190205218763924e-12, -8.006281440760712e-14,  1.395103713415702e-15, -2.156876668085392e-17,  3.675707286043879e-19, -5.749898829484002e-21,
  5.715327483949447e-23, -1.206438726441827e-24,  1.723804905589435e-06, -6.958396593500044e-08,  2.233983737761994e-09, -5.949318259847781e-11,  1.372030083059543e-12,
 -2.982828104996406e-14,  5.893349284666677e-16, -1.051836336793168e-17,  1.951788093798971e-19, -3.340520184472267e-21,  4.592278247654523e-23, -8.530592883078033e-25,
  1.801088655287061e-07, -8.415648398019284e-09,  3.180419318886979e-10, -9.801677419325083e-12,  2.608477984293647e-13, -6.458807771732471e-15,  1.453022794558129e-16,
 -2.997144649784957e-18,  6.118014189210251e-20, -1.163159406515933e-21,  1.989173115077249e-23, -3.682472993902480e-25,  1.006868633873138e-08, -5.616096641004938e-10,
  2.522137200005493e-11, -9.089236034074637e-13,  2.822429615117201e-14, -8.028815434112992e-16,  2.075202793824184e-17, -4.952844309216474e-19,  1.133343862017675e-20,
 -2.431807247956571e-22,  4.891121739118393e-24, -9.743429744334208e-26,  2.790878743791939e-10, -1.935631107168924e-11,  1.051217730795213e-12, -4.518453628278862e-14,
  1.666474493550715e-15, -5.541325088410911e-17,  1.671415475739631e-18, -4.655420822788766e-20,  1.220543323630086e-21, -3.005424054656957e-23,  6.999956784318767e-25,
 -1.564957393211394e-26,  3.375212098741962e-12, -3.091705538985828e-13,  2.101075110361134e-14, -1.115654709237605e-15,  5.037488353937970e-17, -2.017998855856990e-18,
  7.294801209181326e-20, -2.421621086603782e-21,  7.478156110781691e-23, -2.161417507109490e-24,  5.890308234267008e-26, -1.522310287053440e-27,  1.450120407801408e-14,
 -1.945123038422570e-15,  1.775777399559284e-16, -1.243673479411411e-17,  7.274118851745800e-19, -3.704148010319833e-20,  1.682243511780344e-21, -6.935598009046006e-23,
  2.628318576961263e-24, -9.238507257057255e-26,  3.034315017431803e-27, -9.358821523524661e-29,  1.778922768025980e-17, -4.285700092458595e-18,  6.155175178722662e-19,
 -6.473030227065975e-20,  5.459352767202427e-21, -3.875742816756012e-22,  2.387193865021657e-23, -1.302419072182984e-24,  6.389773898235467e-26, -2.851482561557019e-27,
  1.167970427428448e-28, -4.418190030984752e-30,  7.288122270139956e-06, -1.935972599079578e-07,  3.159365325240957e-09, -4.008612703442455e-11,  5.027534636625482e-13,
 -4.816456351751532e-15,  1.748054230607972e-17, -1.136952681583940e-18,  1.477613257706647e-20,  7.005381517646084e-22,  6.265440861557831e-24, -4.258533158345127e-25,
  2.980992432878314e-05, -8.165377966589007e-07,  1.443863298290116e-08, -2.074348219722907e-10,  2.820176008153472e-12, -3.259949790856826e-14,  2.915437417453401e-16,
 -5.817879642557715e-18,  6.940632734963254e-20,  1.491883005325570e-21,  2.031097683786651e-23, -1.120083915685824e-24,  3.894238957178312e-05, -1.117581149731792e-06,
  2.204462453140672e-08, -3.659812094233976e-10,  5.495477317454141e-12, -7.554982165448708e-14,  9.645403341715815e-16, -1.251241504053924e-17,  1.487774698336735e-19,
 -1.261893122597746e-21,  2.267965423287511e-23, -3.794877746103237e-25,  2.409652947354999e-05, -7.367452699018147e-07,  1.654341164159327e-08, -3.180708061390426e-10,
  5.336413004815184e-12, -8.527549090248619e-14,  1.317543730048983e-15, -1.622501913744192e-17,  2.140681626460865e-19, -4.494326391237068e-21,  2.585167269237423e-23,
  3.852876854525035e-25,  7.995425620774883e-06, -2.651903497751022e-07,  6.868478130166796e-09, -1.522747318109476e-10,  2.880963660540094e-12, -5.267597538072287e-14,
  9.273776006199921e-16, -1.276020523656998e-17,  1.921330828969126e-19, -4.168924739392960e-21,  3.129318876724359e-23,  7.429168187778833e-26,  1.477164122665409e-06,
 -5.423537292599861e-08,  1.634337203526644e-09, -4.163348231102845e-11,  8.962661136901496e-13, -1.861268721982486e-14,  3.663429845523717e-16, -5.903783491404769e-18,
  1.007382983156538e-19, -2.058156758877655e-21,  2.286706134154149e-23, -2.114018324158079e-25,  1.508786328084256e-07, -6.279556308986186e-09,  2.217447714977216e-10,
 -6.497047609172401e-12,  1.607435469508031e-13, -3.791261182582383e-15,  8.343117624410565e-17, -1.582667960640215e-18,  3.044410548240123e-20, -6.144946100184366e-22,
  9.198500227610516e-24, -1.389326463302676e-25,  8.166136703630526e-09, -3.968553193334055e-10,  1.657026536346407e-11, -5.628048817808780e-13,  1.620564227745394e-14,
 -4.371880540672357e-16,  1.087269050135259e-17, -2.419721054741575e-19,  5.266302106860893e-21, -1.122363663918630e-22,  2.080009345440012e-24, -3.845768597635805e-26,
  2.155924593044317e-10, -1.273413098656050e-11,  6.384277805970901e-13, -2.558247103394449e-14,  8.729409628149569e-16, -2.736334278503476e-17,  7.839645439508345e-19,
 -2.051359304199119e-20,  5.117159103418926e-22, -1.214133683576432e-23,  2.668764544379714e-25, -5.696356833064751e-27,  2.405871241831353e-12, -1.834808148477495e-13,
  1.138212684660000e-14, -5.563844993477644e-16,  2.317284272852471e-17, -8.688856061393526e-19,  2.956111706981249e-20, -9.238682051433523e-22,  2.706510564319163e-23,
 -7.454187370942511e-25,  1.932764459778273e-26, -4.781770208725199e-28,  8.836506335357348e-15, -9.683583288989369e-16,  7.936255760666835e-17, -5.052890243174276e-18,
  2.716108660910673e-19, -1.286684561027823e-20,  5.473903174871462e-22, -2.125852214473182e-23,  7.634055415256055e-25, -2.553881507174903e-26,  8.011851514218772e-28,
 -2.369909603986048e-29,  7.090682437133194e-18, -1.418637618884684e-18,  1.818867754056225e-19, -1.746512869123325e-20,  1.367725870136342e-21, -9.127912574991424e-23,
  5.334032420874574e-24, -2.781492777131557e-25,  1.312185317576570e-26, -5.658707212203779e-28,  2.249199053863275e-29, -8.286131755593153e-31,  6.561420062130511e-06,
 -1.701169441465569e-07,  2.723464519323171e-09, -3.279946553526892e-11,  4.084189166138450e-13, -4.701567187125363e-15, -3.858510847823235e-18, -2.584371239807026e-19,
  3.858966258787926e-20,  4.323061264313484e-22, -2.180686551076653e-23, -6.923097467087455e-25,  2.676004664220231e-05, -7.102658519747346e-07,  1.219972881951252e-08,
 -1.671979549483413e-10,  2.226480568775048e-12, -2.725391670019945e-14,  1.682448493078166e-16, -2.702258152438769e-18,  1.221684841636702e-19,  9.375433460675754e-22,
 -5.385186620852614e-23, -1.850687239283632e-24,  3.479893287218361e-05, -9.574036996208507e-07,  1.813432394141169e-08, -2.889937056041355e-10,  4.190214588527359e-12,
 -5.610365262905401e-14,  6.750529716803478e-16, -8.340355371358078e-18,  1.149976622921322e-19, -7.581716744694826e-22,  1.238803561658473e-24, -5.368826107282782e-25,
  2.139196107506788e-05, -6.183330443531734e-07,  1.318774855737638e-08, -2.447565703955512e-10,  3.913711371592402e-12, -5.847307886217507e-14,  9.365533584214724e-16,
 -1.170770230232665e-17,  7.837780036037587e-20, -2.768234723556636e-21,  6.612459135150077e-23,  1.113359662415222e-24,  7.033996934665516e-06, -2.168408587185487e-07,
  5.286599432800018e-09, -1.135088338232343e-10,  2.024109908631882e-12, -3.414106046208193e-14,  6.354720579341451e-16, -8.743781502380910e-18,  6.855196615536926e-20,
 -2.518954588375196e-21,  5.704056727048609e-23,  8.339867828068192e-25,  1.283518345636382e-06, -4.294074097554073e-08,  1.209900436098218e-09, -2.984401076738416e-11,
  6.001590374793070e-13, -1.150228061531521e-14,  2.362292347860950e-16, -3.697900758669373e-18,  4.226716137832734e-20, -1.181739385309720e-21,  2.376299516766531e-23,
  1.620756712982512e-25,  1.288694838944718e-07, -4.778857663644153e-09,  1.570248362280790e-10, -4.436283667503554e-12,  1.018429588776990e-13, -2.228749472940479e-15,
  4.988046956785749e-17, -9.006118252120615e-19,  1.387966073015333e-20, -3.255910027340333e-22,  6.111116175471450e-24, -2.146724140977847e-26,  6.806516911491783e-09,
 -2.874825040352396e-10,  1.112416707051063e-11, -3.612904264464848e-13,  9.606967396419240e-15, -2.417333439396587e-16,  5.947586976528992e-18, -1.247657925992318e-19,
  2.402486265103561e-21, -5.368376748001660e-23,  1.032087483294980e-24, -1.299377471142666e-26,  1.732142117160766e-10, -8.653028285224001e-12,  4.000286693651540e-13,
 -1.513779408220675e-14,  4.753838700935527e-16, -1.393110544223482e-17,  3.854036473248733e-19, -9.476111120394600e-21,  2.190935279393904e-22, -5.140242178819944e-24,
  1.093424384757105e-25, -2.051706021852767e-27,  1.819203532883349e-12, -1.139349843011763e-13,  6.461113617203473e-15, -2.933997153457888e-16,  1.121163054501482e-17,
 -3.922992532584087e-19,  1.264900163500815e-20, -3.711684358899708e-22,  1.024270894304823e-23, -2.710067773103965e-25,  6.691152453812353e-27, -1.559009315227917e-28,
  5.932186782507051e-15, -5.178737193484176e-16,  3.816914208266050e-17, -2.213781445898972e-18,  1.087631472550522e-19, -4.782073286981627e-21,  1.904957666205984e-22,
 -6.944037341073051e-24,  2.355792753534681e-25, -7.494413083672451e-27,  2.238857322394092e-28, -6.327460439402002e-30,  3.385474763388991e-18, -5.337650947761268e-19,
  6.028827361236145e-20, -5.216572826714927e-21,  3.747989209953860e-22, -2.329277389108658e-23,  1.280670375859376e-24, -6.334860551095180e-26,  2.854939723316659e-27,
 -1.182909987917937e-28,  4.538813734515183e-30, -1.620998441176612e-31,  5.922182325961339e-06, -1.497996930530303e-07,  2.365959399759444e-09, -2.702188041075067e-11,
  3.136314282737678e-13, -4.734395714774472e-15,  7.038883276584869e-18,  1.008519540505469e-18,  3.291601198057814e-20, -8.294986014471839e-22, -3.328656965190616e-23,
  3.782953358197090e-25,  2.410227388173323e-05, -6.201280157032955e-07,  1.038976794046306e-08, -1.357330538275536e-10,  1.718002166954667e-12, -2.366939644744113e-14,
  1.486291801650939e-16,  1.199901283721713e-18,  1.020908005697044e-19, -2.286368855733123e-21, -8.666777322766346e-23,  9.199208732994277e-25,  3.123900710417216e-05,
 -8.251409910433489e-07,  1.503428343346473e-08, -2.301188346525606e-10,  3.213278149757311e-12, -4.231485524185963e-14,  4.887607708042129e-16, -5.129052761473746e-18,
  8.370127758797035e-20, -1.079894721555898e-21, -1.315202113459254e-23,  2.753045381820402e-26,  1.911242640108668e-05, -5.235963225250558e-07,  1.059145532752737e-08,
 -1.903789571585307e-10,  2.943616710652443e-12, -3.971795320747457e-14,  6.329737368083810e-16, -1.020734695149184e-17,  3.489986502698941e-20,  4.573364179198275e-22,
  8.005350554787654e-23, -9.051081656688539e-25,  6.243307554519740e-06, -1.794928384493910e-07,  4.098740399313131e-09, -8.583667614635810e-11,  1.474959127293961e-12,
 -2.164623137362496e-14,  4.112221980654743e-16, -7.501720970281625e-18,  2.560736366539584e-20,  2.203745398324941e-22,  6.857098889065368e-23, -6.855986320548685e-25,
  1.129055373809715e-06, -3.454645403228628e-08,  9.027033673583967e-10, -2.180667887582711e-11,  4.190696050355738e-13, -6.954870121676530e-15,  1.466078176850439e-16,
 -2.830815953531659e-18,  1.814435374762885e-20, -1.461198932988893e-22,  2.504130587574156e-23, -2.355561967560977e-25,  1.119644186250736e-07, -3.710903748167235e-09,
  1.122845538246935e-10, -3.106145417625883e-12,  6.741614128460508e-14, -1.293215619183714e-15,  2.944710742669784e-17, -5.983026403397031e-19,  6.373380625220112e-21,
 -9.764292504285506e-23,  5.063304376297705e-24, -5.051297029333136e-26,  5.810377092308304e-09, -2.135403931134510e-10,  7.573615630406120e-12, -2.395523699179152e-13,
  5.955031944715279e-15, -1.337499421717235e-16,  3.291235191460649e-18, -7.176572304410268e-20,  1.102935641756370e-21, -2.105452193481826e-23,  6.352241089536946e-25,
 -7.908119122540727e-27,  1.440103422839635e-10, -6.068415550446972e-12,  2.562289872303867e-13, -9.335945999178413e-15,  2.712332261512459e-16, -7.217736074813284e-18,
  1.955576983396041e-19, -4.727570477182828e-21,  9.554345968306882e-23, -2.100087540146241e-24,  5.126381221474779e-26, -8.513995540864858e-28,  1.448178542292210e-12,
 -7.378401931842395e-14,  3.802874941480036e-15, -1.632540056240503e-16,  5.718555376527786e-18, -1.838500114444590e-19,  5.681570426005287e-21, -1.587407386581145e-22,
  4.022697903367319e-24, -1.016680629266499e-25,  2.506173247380168e-27, -5.363136864683481e-29,  4.337028316213440e-15, -2.951288360619684e-16,  1.954385994092117e-17,
 -1.043755289486329e-18,  4.662444078923975e-20, -1.890256693957335e-21,  7.079796072750113e-23, -2.421950666281353e-24,  7.698095687549048e-26, -2.329395011886786e-27,
  6.658659062037156e-29, -1.781114432905484e-30,  1.926557150838288e-18, -2.268478138502026e-19,  2.241621184262359e-20, -1.734348447290262e-21,  1.129384613740326e-22,
 -6.477019612536713e-24,  3.326920343956474e-25, -1.549214285354040e-26,  6.622789585245424e-28, -2.621671629655638e-29,  9.658989016873028e-31, -3.326202669170623e-32,
  5.358896329836621e-06, -1.320908421295641e-07,  2.068740936100177e-09, -2.274079369557684e-11,  2.233887320420914e-13, -4.143078498007500e-15,  4.401510686982367e-17,
  1.384476639175014e-18, -1.321741930178372e-20, -1.442128234282771e-21,  9.469133573758275e-24,  1.266381009999009e-24,  2.177829635594376e-05, -5.430924008245474e-07,
  8.910950155543435e-09, -1.118214303737859e-10,  1.284514619951155e-12, -1.942673208598865e-14,  2.116076302143519e-16,  2.626123693836676e-18, -2.304079057330718e-20,
 -3.911513528331408e-21,  2.398999810777490e-23,  3.341998349715278e-24,  2.816265668814627e-05, -7.150988157864125e-07,  1.255534746103848e-08, -1.848832935423648e-10,
  2.474050571442985e-12, -3.204448330257858e-14,  3.761715989300701e-16, -3.155495132895919e-18,  3.809491351504288e-20, -1.319913111358518e-21,  6.484857960215720e-24,
  7.248698297438411e-25,  1.717409252884963e-05, -4.472576867723708e-07,  8.565695652889049e-09, -1.489050777088343e-10,  2.278809422593620e-12, -2.779558807140357e-14,
  3.689925454934470e-16, -8.335216223588204e-18,  9.226054691111559e-20,  2.114761082463437e-21, -1.032657601638014e-23, -2.614701189078238e-24,  5.584919430271002e-06,
 -1.504516521682334e-07,  3.197556276066343e-09, -6.523398078837486e-11,  1.124285595113832e-12, -1.418083877127435e-14,  2.170721392044240e-16, -6.124959521523733e-18,
  6.969361888758728e-20,  1.732805890934006e-21, -4.489580870085731e-24, -2.186021016880507e-24,  1.003803896270631e-06, -2.826701911262352e-08,  6.772121572289078e-10,
 -1.604893670254834e-11,  3.090791224087481e-13, -4.320508823487608e-15,  7.588251406237382e-17, -2.173637858008967e-18,  2.657482046577072e-20,  4.529312127967292e-22,
  1.171106473035389e-24, -7.205733858649482e-25,  9.870486729652579e-08, -2.945128018558060e-09,  8.073899065331225e-11, -2.201312775309700e-12,  4.737216037960719e-14,
 -7.664574344469150e-16,  1.526681142119797e-17, -4.175063387140845e-19,  5.719875736104064e-21,  3.384984431950843e-23,  9.755976374870875e-25, -1.193339770762959e-25,
  5.061237391527997e-09, -1.630087564973007e-10,  5.194587065976044e-12, -1.619989246775498e-13,  3.925385590933500e-15, -7.542836718117989e-17,  1.692681441390700e-18,
 -4.443842169733442e-20,  7.087990004230408e-22, -3.677927367560679e-24,  2.087750155696613e-25, -1.090566049026895e-26,  1.232183426026136e-10, -4.402448736767819e-12,
  1.661886464277768e-13, -5.935604936345541e-15,  1.646253621067181e-16, -3.824724736533477e-18,  9.705378204061208e-20, -2.550845401133963e-21,  4.876323879226077e-23,
 -7.026998926877286e-25,  2.020792276447619e-26, -6.105765298764181e-28,  1.203361245596520e-12, -4.987965451947925e-14,  2.291884608572111e-15, -9.505119033449981e-17,
  3.108127457167873e-18, -8.907290429920534e-20,  2.603819806219069e-21, -7.307952415403238e-23,  1.710681800155389e-24, -3.690796540986436e-26,  9.485714997774330e-28,
 -2.303469320343569e-29,  3.404641751776831e-15, -1.785668512561768e-16,  1.049342897615814e-17, -5.267715260785191e-19,  2.148413383861130e-20, -7.888152032628659e-22,
  2.779946361789988e-23, -9.081053258687549e-25,  2.679380648742809e-26, -7.529737571906881e-28,  2.099485071088021e-29, -5.459987565035741e-31,  1.279231559810458e-18,
 -1.076634165733948e-19,  9.257332081702556e-21, -6.432447130303546e-22,  3.756723238845117e-23, -1.965570483318079e-24,  9.389890030512434e-26, -4.096674360011817e-27,
  1.647082523324491e-28, -6.186619168575078e-30,  2.181822369524160e-31, -7.210537793009245e-33,  4.861982537539781e-06, -1.165775756429076e-07,  1.814780910546641e-09,
 -1.976031897660434e-11,  1.537978871822638e-13, -2.712176647327559e-15,  7.015242825683507e-17,  3.010120840972745e-19, -4.689388478741565e-20, -1.999059793758787e-22,
  4.290157556185482e-23, -1.609081905206515e-26,  1.974046024487929e-05, -4.768504635637415e-07,  7.680539880875243e-09, -9.407958321099216e-11,  9.517848913256003e-13,
 -1.366592762772771e-14,  2.565000362327932e-16,  7.895671332701972e-20, -1.161700945734205e-19, -6.456104218474329e-22,  1.140242447350499e-22,  1.335602887441740e-26,
  2.548998551479596e-05, -6.229031540641598e-07,  1.055461909963264e-08, -1.499631686590540e-10,  1.916822418634046e-12, -2.397947358891491e-14,  2.984456697284883e-16,
 -2.587636164025086e-18,  2.289324038941137e-21, -5.152770529712841e-22,  2.884590227913920e-23,  7.999870261906285e-26,  1.551161897673458e-05, -3.852992189547440e-07,
  6.980613424721114e-09, -1.164827727358416e-10,  1.794547047580025e-12, -2.134446718931671e-14,  1.866240152140464e-16, -4.445081936140887e-18,  1.373288104208229e-19,
 -8.837354768744056e-23, -8.018087167940863e-23, -2.593539550983121e-26,  5.029721235117236e-06, -1.277166118407950e-07,  2.514090594458700e-09, -4.928436826267041e-11,
  8.804029971004274e-13, -1.072506275484890e-14,  8.491615415159046e-17, -3.101875048477306e-18,  1.086645575049997e-19,  1.211285441024770e-23, -6.592281385949265e-23,
 -1.269600216759332e-25,  9.004622168967000e-07, -2.354162065737974e-08,  5.117135308646505e-10, -1.171478113486188e-11,  2.365079400300431e-13, -3.119646437685749e-15,
  2.910464656460911e-17, -1.110368413698861e-18,  3.694480462115470e-20, -2.218491137511296e-23, -2.009720970488183e-23, -8.327976294707911e-26,  8.806567495786007e-08,
 -2.393047722699060e-09,  5.841965854828492e-11, -1.549670916139979e-12,  3.487200246744345e-14, -5.185017654546584e-16,  6.319558841796329e-18, -2.170213063204256e-19,
  6.497242620898755e-21, -1.602728126991726e-23, -2.744389632565682e-24, -2.337457911248400e-26,  4.481375751235334e-09, -1.282625314566744e-10,  3.583756605254371e-12,
 -1.094321592708950e-13,  2.735139823180103e-15, -4.725935070296545e-17,  7.523601087027597e-19, -2.314314230582043e-20,  6.212729249404773e-22, -3.600967750024221e-24,
 -1.477586250585403e-25, -3.278693293062571e-27,  1.078729144490243e-10, -3.318170424191144e-12,  1.085917815071469e-13, -3.808363077920246e-15,  1.064668976047400e-16,
 -2.195210943826983e-18,  4.450201452823993e-20, -1.287284869374327e-21,  3.224778903639660e-23, -3.486997303039556e-25,  2.166300719617265e-28, -2.404296372775589e-28,
  1.034327968109039e-12, -3.537800514880282e-14,  1.400198138931900e-15, -5.677536917987812e-17,  1.813411336572167e-18, -4.596005868716267e-20,  1.166293630865231e-21,
 -3.398729746860237e-23,  8.610954030385619e-25, -1.487815612537465e-26,  2.522275644782672e-28, -9.247187880489781e-30,  2.825155336482272e-15, -1.150610543281801e-16,
  5.811428304310871e-18, -2.801593224959691e-19,  1.073241187084697e-20, -3.501102355078117e-22,  1.122912530162378e-23, -3.604308467202302e-25,  1.032458390439304e-26,
 -2.563768068901965e-28,  6.443750219501026e-30, -1.793294735777932e-31,  9.591042747090198e-19, -5.661211246916684e-20,  4.158680642587120e-21, -2.646475936384975e-22,
  1.388342690485563e-23, -6.509472860655168e-25,  2.866650971500630e-26, -1.176777634448305e-27,  4.437769108248206e-29, -1.558337267133100e-30,  5.218240922667579e-32,
 -1.665615471159590e-33,  4.423261319806199e-06, -1.029695169339320e-07,  1.590928494953356e-09, -1.764218017688702e-11,  1.162104933284887e-13, -1.092328248281907e-15,
  5.870196371580032e-17, -1.013241112169805e-18, -2.755691911762422e-20,  1.064859713877495e-21,  1.263443845588739e-23, -1.044325366807273e-24,  1.794913778461906e-05,
 -4.196817051570306e-07,  6.635004042832346e-09, -8.070987871598980e-11,  7.380537888887295e-13, -7.894882389062667e-15,  2.090765779890708e-16, -3.204631885844085e-18,
 -6.837074275901161e-20,  2.755456438860106e-21,  3.514075059797343e-23, -2.772808430864264e-24,  2.315654064425337e-05, -5.451771002554220e-07,  8.924442935831543e-09,
 -1.227661802761295e-10,  1.502989718662832e-12, -1.768730267614879e-14,  2.257640224727509e-16, -2.600155284419093e-18,  2.591886688647179e-21,  4.163825689714113e-22,
  1.212160863335258e-23, -6.648688469104704e-25,  1.407390733449966e-05, -3.345884049498104e-07,  5.741702992916511e-09, -9.097540819866291e-11,  1.404842350762733e-12,
 -1.788650039169942e-14,  1.190653966919205e-16, -6.657970308255924e-19,  8.455141940790940e-20, -2.439776176825189e-21, -2.186875068783401e-23,  2.046611241438475e-24,
  4.555651968035312e-06, -1.097457682479003e-07,  2.000412997029712e-09, -3.682582969144850e-11,  6.812145616010757e-13, -9.353516781169905e-15,  4.336158305302501e-17,
 -8.897199059504400e-20,  6.747933848582707e-20, -1.982143554826354e-21, -2.007203730335383e-23,  1.701390135587592e-24,  8.136776526739442e-07, -1.995042995071275e-08,
  3.918816642672997e-10, -8.400075582060834e-12,  1.792492152579472e-13, -2.666786845696558e-15,  1.337747522939582e-17, -8.726905052333641e-20,  2.316463615952702e-20,
 -6.495160902551564e-22, -6.602368801852709e-24,  5.378817126668968e-25,  7.932283230972027e-08, -1.991332644388100e-09,  4.285114472851233e-11, -1.068096149280379e-12,
  2.564283688036122e-14, -4.175497702936243e-16,  2.916993813034306e-18, -3.898586767652757e-20,  4.077017315614749e-21, -1.060857108541769e-22, -9.817020420222902e-25,
  7.990963599800797e-26,  4.018311356008293e-09, -1.041676607755412e-10,  2.504621997736208e-12, -7.243220951719488e-14,  1.928973007454212e-15, -3.489593376546233e-17,
  3.544583356619465e-19, -6.551714483045965e-21,  3.815504572653052e-22, -9.089253011721704e-24, -6.043802680604060e-26,  5.526153737297958e-27,  9.608516001768031e-11,
 -2.606291147849091e-12,  7.182262070435330e-14, -2.408403811064416e-15,  7.087606915236411e-17, -1.454971054673677e-18,  2.095311409466537e-20, -4.665191792528063e-22,
  1.860711739379890e-23, -4.118387883676059e-25, -4.691637668763109e-28,  1.472710817798589e-28,  9.115191707207793e-13, -2.646976747616605e-14,  8.668120570651166e-16,
 -3.386687510417151e-17,  1.111230700652326e-18, -2.671619341574105e-20,  5.301838609520753e-22, -1.364703970100271e-23,  4.395208319583320e-25, -9.667311172253027e-27,
  7.651080819727808e-29, -2.106573420886808e-32,  2.440123410969732e-15, -7.954973450410317e-17,  3.288220320412428e-18, -1.526695902357792e-19,  5.769921437127589e-21,
 -1.714532885853800e-22,  4.656203064953159e-24, -1.402149707690529e-25,  4.305512745965787e-27, -1.066317114032250e-28,  2.019193791607071e-30, -4.411552302730266e-32,
  7.833580299392500e-19, -3.306187047565354e-20,  1.982311464666064e-21, -1.181452708863806e-22,  5.727800415697434e-24, -2.382155072593930e-25,  9.374881617196198e-27,
 -3.613517488736063e-28,  1.308159618772803e-29, -4.300152886267373e-31,  1.317648301839866e-32, -3.975662889467475e-34,  4.035540299420408e-06, -9.105852092133625e-08,
  1.389875915278377e-09, -1.589200543771925e-11,  1.057954902150427e-13, -8.679625900053042e-17,  2.395144138464022e-17, -1.267758407030155e-18,  9.886593505622701e-21,
  7.908426680164138e-22, -2.059462080325761e-23, -2.986835994466824e-25,  1.637070669925414e-05, -3.702853905700258e-07,  5.732919780445171e-09, -6.992529582963706e-11,
  6.221945807324831e-13, -4.105344859033101e-15,  1.042502857650991e-16, -3.757007548090459e-18,  2.946316290673295e-20,  2.077106412572383e-21, -5.402132425800693e-23,
 -8.212733065201545e-25,  2.110983706432855e-05, -4.792906137682969e-07,  7.584748995973142e-09, -1.012783026669361e-10,  1.197644770076347e-12, -1.311744190138826e-14,
  1.567182294919255e-16, -2.238914910805815e-18,  1.967375218554798e-20,  3.767665902615610e-22, -1.087541572365508e-23, -2.485191334149724e-25,  1.282101170103761e-05,
 -2.926656750679392e-07,  4.773554400567677e-09, -7.120641232716414e-11,  1.075405278548487e-12, -1.502991860247466e-14,  1.248605190291973e-16,  6.296249581593760e-19,
  5.574814823690022e-22, -1.786923276744371e-21,  4.317283202267473e-23,  5.746809802431293e-25,  4.146120057195507e-06, -9.533865312149366e-08,  1.617915830987358e-09,
 -2.736374371952471e-11,  5.053216541438687e-13, -8.166700337549920e-15,  6.008026700396713e-17,  9.115581278189724e-19, -1.819083039651394e-21, -1.491919489747544e-21,
  3.545978764223126e-23,  5.197690950843134e-25,  7.395712650729859e-07, -1.717376365577547e-08,  3.065858437929338e-10, -5.940939261014777e-12,  1.292643463707460e-13,
 -2.313596870985324e-15,  1.769229415071344e-17,  2.730178637575126e-19,  3.233402213608844e-22, -4.973387750314145e-22,  1.141137447430467e-23,  1.762988965729207e-25,
  7.197098479676902e-08, -1.693428139860593e-09,  3.223196475320377e-11, -7.209673837830537e-13,  1.796427427530382e-14, -3.495302074581840e-16,  3.062808360769041e-18,
  2.946070820349892e-20,  3.537998058723905e-22, -8.193826540284611e-23,  1.788521503127062e-24,  2.843211208461961e-26,  3.636884120306518e-09, -8.713301158344711e-11,
  1.798963537378552e-12, -4.673126832618743e-14,  1.307090186530143e-15, -2.751773334370913e-17,  2.922022842998606e-19,  4.308415694574601e-22,  6.829351928951468e-23,
 -6.932206833159559e-24,  1.420579106559202e-25,  2.190520598428651e-27,  8.665062118514324e-11, -2.130087054957859e-12,  4.884450119263303e-14, -1.483264013510632e-15,
  4.603754298304151e-17, -1.055053779832028e-18,  1.405118890267125e-20, -9.824525993578278e-23,  5.118060511810200e-24, -2.951538218282027e-25,  5.674878344655353e-27,
  7.043099930773699e-29,  8.173133784452580e-13, -2.089528571049178e-14,  5.513998016574766e-16, -1.977564511283363e-17,  6.801286794062576e-19, -1.728728796200523e-20,
  2.971315600331118e-22, -4.508736692021744e-24,  1.536974640204120e-25, -5.942146396504628e-27,  1.121053861219083e-28,  4.517681805852380e-31,  2.164847963924134e-15,
 -5.922948759780073e-17,  1.913544070287452e-18, -8.280699695678451e-20,  3.207531186359797e-21, -9.431207015848762e-23,  2.176195004335482e-24, -5.106431035951951e-26,
  1.598360146807500e-27, -4.983341883322165e-29,  1.052660471214053e-30, -1.104667560587928e-32,  6.756532842320085e-19, -2.161321910711317e-20,  9.891249720591994e-22,
 -5.513228150265669e-23,  2.588655324681492e-24, -9.869015078455700e-26,  3.357556656615108e-27, -1.149702743198606e-28,  4.035724152877993e-30, -1.324904430720529e-31,
  3.804884183494301e-33, -9.904919724986260e-35,  3.692377076314318e-06, -8.067353881648315e-08,  1.209341290687497e-09, -1.419308004372053e-11,  1.072071930980296e-13,
  1.181200056074495e-16, -4.036596356936825e-18, -6.640603370832099e-19,  2.281007419054889e-20, -3.783868476750304e-23, -1.593725701036303e-23,  3.653214140701026e-25,
  1.497620913494443e-05, -3.276147337003542e-07,  4.951186242245787e-09, -6.052421508655965e-11,  5.573731757466837e-13, -2.705884871632249e-15,  2.033252485623655e-17,
 -2.061348747900456e-18,  6.319085376438672e-20, -1.152555134699744e-22, -4.239585507644624e-23,  9.657526637738867e-25,  1.930676860062194e-05, -4.231669319083710e-07,
  6.476332855829238e-09, -8.403032282033694e-11,  9.682392663150435e-13, -1.002812969255349e-14,  1.042140424742412e-16, -1.486638829346216e-18,  2.441774950970244e-20,
 -1.024628720850510e-22, -9.642967996480066e-24,  2.158748804941380e-25,  1.172169838582185e-05, -2.576243974418729e-07,  4.012939074710945e-09, -5.623650513829616e-11,
  8.060051261996805e-13, -1.186661623221455e-14,  1.355682307441041e-16, -3.177559446567256e-20, -3.145016602191940e-20, -6.590856174451359e-23,  3.316023819414946e-23,
 -7.414107651666177e-25,  3.788750821844343e-06, -8.358320236224372e-08,  1.332947785670087e-09, -2.049889918022487e-11,  3.582674035108912e-13, -6.464327763227797e-15,
  7.878653528213831e-17,  2.846334812308507e-19, -2.862427556616419e-20, -5.297543879630936e-23,  2.808987677080828e-23, -6.158446706405517e-25,  6.753752775305045e-07,
 -1.497443651267816e-08,  2.462584642033661e-10, -4.217373418157985e-12,  8.780578311902307e-14, -1.809268102446345e-15,  2.346082969974888e-17,  9.110082930818285e-20,
 -8.843997911640194e-21, -2.836521588532477e-23,  9.265853482475134e-24, -1.979518599667572e-25,  6.566442234675546e-08, -1.465796531113275e-09,  2.508792977458266e-11,
 -4.851962012014302e-13,  1.177252180469199e-14, -2.670426409427711e-16,  3.708349589866169e-18,  8.429524671874378e-21, -1.216953922535111e-21, -7.654256795917675e-24,
  1.487160290986155e-24, -3.067524407705834e-26,  3.314033845407649e-09, -7.466819765646717e-11,  1.346757814056811e-12, -2.983363099632292e-14,  8.282909260755308e-16,
 -2.030188830124035e-17,  3.057249853943662e-19, -1.981166634595227e-22, -7.167451383585667e-23, -1.014281302106912e-24,  1.199719237478802e-25, -2.362049012124347e-27,
  7.881476645625010e-11, -1.799493825265670e-12,  3.482595792790339e-14, -8.978611344395103e-16,  2.814590640935702e-17, -7.404979203496391e-19,  1.232540784098355e-20,
 -5.821019068024253e-23, -1.214838517007069e-24, -6.384963843961151e-26,  4.708644170509956e-27, -8.766692757653690e-29,  7.412811593763255e-13, -1.727226298906750e-14,
  3.691317700026823e-16, -1.130724210763514e-17,  3.976157294708554e-19, -1.128182945731191e-20,  2.137729994699584e-22, -2.150729231261848e-24,  1.895201111623799e-26,
 -1.743634976196003e-27,  8.314790720328214e-29, -1.484870456776385e-30,  1.953316784936093e-15, -4.715039673826996e-17,  1.173610497975355e-18, -4.413937722159030e-20,
  1.751583449855469e-21, -5.485115963502602e-23,  1.245393912267668e-24, -2.140915851819545e-26,  4.496072065684994e-28, -1.709464233490541e-29,  5.803331952276331e-31,
 -1.099368195163762e-32,  6.016629003892472e-19, -1.576855458395766e-20,  5.226316316651603e-22, -2.600550524027486e-23,  1.219877119616925e-24, -4.567937458354468e-26,
  1.398357845141040e-27, -3.951968083487116e-29,  1.214476898244990e-30, -4.065423071448504e-32,  1.258138589533597e-33, -3.191055173175022e-35,  3.387995037516763e-06,
 -7.165079616224101e-08,  1.049363317776558e-09, -1.246902031381713e-11,  1.075022340514166e-13, -1.242514850449275e-16, -1.330448249618457e-17, -4.641119164693041e-20,
  1.396174120282336e-20, -3.500176582144599e-22, -5.912460573345136e-25,  2.530902154396113e-25,  1.374057806588977e-05, -2.907628224779773e-07,  4.276659456065351e-09,
 -5.202833238805151e-11,  5.045890605865614e-13, -2.695414410708623e-15, -1.153212534313593e-17, -3.465482035159477e-19,  3.910510500721457e-20, -9.467298645080225e-22,
 -1.557177487316127e-24,  6.765526794564359e-25,  1.771168863557299e-05, -3.751407873664003e-07,  5.554706598942899e-09, -7.001973039571064e-11,  7.897500822828184e-13,
 -7.943788784281350e-15,  7.255692140299249e-17, -8.188530082889208e-19,  1.623450420580774e-20, -2.869352529586985e-22, -2.440153811455925e-26,  1.642037337186665e-25,
  1.075142100735722e-05, -2.280179020885271e-07,  3.408212522337357e-09, -4.506460043625039e-11,  6.005681312308659e-13, -8.732054735093629e-15,  1.216746878673206e-16,
 -8.860911471230613e-19, -1.802472121362840e-20,  6.018907850094687e-22,  2.095568922012540e-24, -5.131651037623377e-25,  3.474312729155705e-06, -7.381527078753459e-08,
  1.117424009247073e-09, -1.569728525980590e-11,  2.480165915549006e-13, -4.576696205110001e-15,  7.487185789587850e-17, -5.002300907889531e-19, -1.708062341806756e-20,
  5.171011228526475e-22,  1.883998620685342e-24, -4.377354017757389e-25,  6.191274910469555e-07, -1.318546888309593e-08,  2.029853223315436e-10, -3.071069405823525e-12,
  5.729624847963744e-14, -1.246406281488759e-15,  2.230250976521536e-17, -1.545866862943206e-19, -5.388688871106352e-21,  1.625783729419725e-22,  7.298457843302168e-25,
 -1.440986296244938e-25,  6.016979336031748e-08, -1.285554795925651e-09,  2.023518205138128e-11, -3.347256828490097e-13,  7.318241560779354e-15, -1.795234636933256e-16,
  3.423466231576370e-18, -2.623096380736443e-20, -7.648261087863536e-22,  2.368825935544771e-23,  1.451049969842878e-25, -2.293915226716432e-26,  3.034922430592133e-09,
 -6.512915199039791e-11,  1.056145562439491e-12, -1.943731090868835e-14,  4.937986616119151e-16, -1.329618845360636e-17,  2.679312397008536e-19, -2.366014009027477e-21,
 -4.843749250908715e-23,  1.595530863142926e-24,  1.516080000300892e-26, -1.817145299899811e-27,  7.211522083611708e-11, -1.557352077668823e-12,  2.631522424579049e-14,
 -5.505831629275104e-16,  1.613440649933331e-17, -4.696618243165846e-19,  1.001845974590653e-20, -1.055446606966074e-22, -1.112815209926669e-24,  4.305426843271978e-26,
  7.987203875542038e-28, -6.866172939271123e-29,  6.773711020945725e-13, -1.476924087439668e-14,  2.650187521642982e-16, -6.491508648833721e-18,  2.185878487079249e-19,
 -6.843733423925569e-21,  1.564124920736279e-22, -2.039728860758982e-24, -2.943907567051557e-28,  2.424323314282936e-28,  1.913133586472743e-29, -1.121314396767136e-30,
  1.780713233451625e-15, -3.947750902287437e-17,  7.806492143517209e-19, -2.344669089141454e-20,  9.113977309315596e-22, -3.096065073049916e-23,  7.814871810305533e-25,
 -1.329465890421618e-26,  1.420991313407666e-28, -2.727205594551638e-30,  1.702401446076623e-31, -6.720641184400572e-33,  5.453642289826267e-19, -1.256314299844867e-20,
  3.025624338590789e-22, -1.228431805766452e-23,  5.702946903931430e-25, -2.206985517104893e-26,  6.715929754951708e-28, -1.663166444706421e-29,  3.887329998391818e-31,
 -1.099881832789320e-32,  3.712559361414043e-34, -1.141928151583002e-35,  3.117274911396498e-06, -6.382546258267461e-08,  9.099177419909449e-10, -1.078589443589164e-11,
  1.019312543716538e-13, -4.200258313102190e-16, -1.017408021500312e-17,  2.110583419209714e-19,  2.877991848627582e-21, -2.310680599904545e-22,  4.754043057352052e-24,
  1.219551903490919e-26,  1.264218740223407e-05, -2.589138607235684e-07,  3.698928571802624e-09, -4.440236445674980e-11,  4.477266193164381e-13, -2.977945246781982e-15,
 -8.653222672875217e-18,  3.926066101976792e-19,  9.099588595913242e-21, -6.273581352064943e-22,  1.275642480331099e-23,  3.297771616153781e-26,  1.629496736861296e-05,
 -3.338607642992530e-07,  4.785330402034853e-09, -5.856698030450388e-11,  6.466946291523156e-13, -6.428113239473742e-15,  5.541416534946648e-17, -4.538325732182839e-19,
  7.151878736609801e-21, -1.950906083987737e-22,  3.448208077786845e-24,  6.868540815889159e-27,  9.890670251670773e-06, -2.027642358494081e-07,  2.919817340464240e-09,
 -3.670332886554144e-11,  4.528665399321764e-13, -6.155076717262835e-15,  9.195471042402476e-17, -1.134324081744618e-18,  1.197301194772351e-21,  3.948393308657215e-22,
 -8.868074902369621e-24, -2.987630396699771e-26,  3.195824268872746e-06, -6.556823754953417e-08,  9.501466101131278e-10, -1.236931264304478e-11,  1.730705212020759e-13,
 -2.992669521314801e-15,  5.593847181429439e-17, -7.637565513901284e-19, -4.926065838627855e-22,  3.433261175158310e-22, -7.527648489724667e-24, -2.694108833511167e-26,
  5.694197110493548e-07, -1.169512713633524e-08,  1.708997930856995e-10, -2.326425056496206e-12,  3.729225887045017e-14, -7.772199506769290e-16,  1.642153715292564e-17,
 -2.374368252306038e-19, -1.291012288630024e-22,  1.092872842022065e-22, -2.398396557311711e-24, -9.810471468087049e-27,  5.532838320169362e-08, -1.137994889172057e-09,
  1.681622036181113e-11, -2.421826980046695e-13,  4.478974356819769e-15, -1.081524827467583e-16,  2.473201924328546e-18, -3.749081090724031e-20,  1.328665078598056e-23,
  1.625468839163338e-23, -3.598760996139887e-25, -1.796798487773229e-27,  2.789992599728730e-09, -5.749672768349114e-11,  8.625911452111121e-13, -1.333952160613959e-14,
  2.861368260966094e-16, -7.781975342487796e-18,  1.887081574585896e-19, -3.003543092844129e-21,  5.608442459930431e-24,  1.141100298857292e-24, -2.566170962777543e-26,
 -1.715179852959420e-28,  6.627036676645170e-11, -1.369503941482724e-12,  2.098659324590626e-14, -3.555721664838450e-16,  8.891902226480432e-18, -2.671772758501623e-19,
  6.813307508765973e-21, -1.149022732284697e-22,  4.651985835822340e-25,  3.424807770555493e-26, -7.902372809889058e-28, -8.249809291781844e-30,  6.221128590113674e-13,
 -1.291040073767602e-14,  2.041960989163782e-16, -3.904437420225357e-18,  1.146673315664713e-19, -3.764946551454934e-21,  1.010660825734084e-22, -1.839691260711058e-24,
  1.313567778683082e-26,  3.269398846218368e-28, -7.929906299165398e-30, -1.814086305707201e-31,  1.633807183019750e-15, -3.415088943330415e-17,  5.693247159859691e-19,
 -1.291709342515227e-20,  4.519907587578747e-22, -1.621418784193035e-23,  4.646870428344887e-25, -9.475411050685461e-27,  1.113564811712871e-28, -9.141384893106942e-32,
  9.318025782994357e-35, -1.495943644092594e-33,  4.992001279311350e-19, -1.060572411669083e-20,  1.977893525971846e-22, -5.951913770727440e-24,  2.583771379659000e-25,
 -1.041820077241369e-26,  3.362564449180083e-28, -8.447972409204900e-30,  1.680844455356806e-31, -3.127933687470454e-33,  8.283693054865649e-35, -3.028770430149243e-36,
  2.875750220966182e-06, -5.703683247941352e-08,  7.899579686259019e-10, -9.233354628523161e-12,  9.159354337259249e-14, -5.892717737206026e-16, -3.968933554015185e-18,
  2.056341336304969e-19, -2.204261628561183e-21, -6.242321885679978e-23,  3.179060368723881e-24, -5.833392483277036e-26,  1.166250612818524e-05, -2.313365436522404e-07,
  3.207091082415901e-09, -3.772239689540754e-11,  3.870755840112276e-13, -3.038193434982464e-15,  3.710101559269745e-18,  4.179202757655548e-19, -4.798329905352731e-21,
 -1.745537782356140e-22,  8.544539705960618e-24, -1.562312681031816e-25,  1.503187452331445e-05, -2.982227562823730e-07,  4.140589989776849e-09, -4.918003333991065e-11,
  5.305120173906194e-13, -5.230351274787629e-15,  4.504089681915400e-17, -3.115895528341581e-19,  2.472584573522816e-21, -7.271188899902211e-23,  2.336293511268164e-24,
 -4.034611798841948e-26,  9.123703415650326e-06, -1.810529066740710e-07,  2.519149648121522e-09, -3.033294418617391e-11,  3.493307306684387e-13, -4.314259362718398e-15,
  6.238609095649553e-17, -9.352386677918577e-19,  9.345737412689978e-21,  7.876097233502835e-23, -5.926553735092937e-24,  1.126875623586300e-25,  2.947874611774130e-06,
 -5.851782722326618e-08,  8.165710847322078e-10, -1.001324476839926e-11,  1.249418850112114e-13, -1.899191353048909e-15,  3.578195640107339e-17, -6.384417755292702e-19,
  6.707219227278464e-21,  7.424017424500196e-23, -5.058379519835952e-24,  9.564749772257741e-26,  5.252097152606716e-07, -1.043050706550762e-08,  1.461130407106698e-10,
 -1.834919164058548e-12,  2.516112894299978e-14, -4.603721326244722e-16,  1.017630920272779e-17, -1.967398807017724e-19,  2.154447735374442e-21,  2.311833068391399e-23,
 -1.622297548532845e-24,  3.079511805776886e-26,  5.102858473662351e-08, -1.014016800961751e-09,  1.427811569376833e-11, -1.849485533073813e-13,  2.826643999603964e-15,
 -6.090313349793374e-17,  1.497677850849512e-18, -3.043857219387124e-20,  3.489810193502227e-22,  3.211936668316445e-24, -2.461296853735226e-25,  4.708419249454248e-27,
  2.572889469430774e-09, -5.116883521340157e-11,  7.255706897165635e-13, -9.788186140797505e-15,  1.692150461174746e-16, -4.211078297671228e-18,  1.118781007250240e-19,
 -2.364094727936399e-21,  2.865961360055129e-23,  1.957188063886392e-25, -1.792746794658221e-26,  3.469102870770495e-28,  6.110405836268942e-11, -1.216613713096139e-12,
  1.742290368026135e-14, -2.482167619798055e-16,  4.935662445183662e-18, -1.396680879804201e-19,  3.945138411494101e-21, -8.651818892725099e-23,  1.126395414001714e-24,
  4.064948561826599e-27, -5.792959824473743e-28,  1.139573000472093e-29,  5.734791208738530e-13, -1.143800498290591e-14,  1.662474121864941e-16, -2.556904765936103e-18,
  5.973477763067282e-20, -1.901520566183115e-21,  5.672839118950971e-23, -1.298688839666636e-24,  1.861124001851553e-26, -1.223978256507957e-29, -6.767397073233060e-30,
  1.363178959071422e-31,  1.505476640741360e-15, -3.011449805082774e-17,  4.487430262951633e-19, -7.756578327616328e-21,  2.198024636271095e-22, -7.848007715830947e-24,
  2.482806820817417e-25, -6.042599418896999e-27,  9.959718131712642e-29, -6.474890190230513e-31, -1.502184692473023e-32,  3.104207511219526e-34,  4.595710041859234e-19,
 -9.252168410386716e-21,  1.455189661304289e-22, -3.116953410858288e-24,  1.143206217197660e-25, -4.665106493701900e-27,  1.614770486519759e-28, -4.424512670810779e-30,
  9.291697979333916e-32, -1.451873052585559e-33,  1.913816599358629e-35, -4.722427363522419e-37  };
  int offset = -12;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 12;
    if (std::isnan(t)) {
      fill_n(rr+offset, 12, 0.5);
      fill_n(ww+offset, 12, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 12; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=12; ++j) {
        const int boxof = it*144+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
