/* The statements-of-fact provided herein are intended to be compatible with
 * AMD ADL's library. AMD is the creator and copyright holder of the ADL
 * library this interface describes, and therefore also defined this interface
 * originally.
 * These free interfaces were created by Luke Dashjr <luke+freeadl@dashjr.org>
 * As interfaces/APIs cannot be copyrighted, there is no license needed in the
 * USA and probably many other jurisdictions.
 * If your jurisdiction rules otherwise, the header is offered by Luke Dashjr
 * under the MIT license, but you are responsible for determining who your
 * jurisdiction considers to be the copyright holder in such a case.
 *
 * THE INFORMATION IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE INFORMATION OR THE USE OR OTHER DEALINGS IN THE
 * INFORMATION.
 */

#ifndef ADL_DEFINES_H_
#define ADL_DEFINES_H_

enum {
	ADL_FALSE = 0,
	ADL_TRUE  = 1,
};

#define ADL_MAX_CHAR           4096
#define ADL_MAX_PATH            256
#define ADL_MAX_ADAPTERS        150
#define ADL_MAX_DISPLAYS        150
#define ADL_MAX_DEVICENAME       32
#define ADL_ADAPTER_INDEX_ALL    -1
#define ADL_MAIN_API_OPTION_NONE  0

enum {
	ADL_DDC_OPTION_SWITCHDDC2     = 1,
	ADL_DDC_OPTION_RESTORECOMMAND = 2,
};

enum {
	ADL_DL_I2C_ACTIONREAD               = 1,
	ADL_DL_I2C_ACTIONWRITE              = 2,
	ADL_DL_I2C_ACTIONREAD_REPEATEDSTART = 3,
};

enum {
	ADL_OK_WAIT                    = 4,
	ADL_OK_RESTART                 = 3,
	ADL_OK_MODE_CHANGE             = 2,
	ADL_OK_WARNING                 = 1,
	ADL_OK                         = 0,
	ADL_ERR                        = -1,
	ADL_ERR_NOT_INIT               = -2,
	ADL_ERR_INVALID_PARAM          = -3,
	ADL_ERR_INVALID_PARAM_SIZE     = -4,
	ADL_ERR_INVALID_ADL_IDX        = -5,
	ADL_ERR_INVALID_CONTROLLER_IDX = -6,
	ADL_ERR_INVALID_DIPLAY_IDX     = -7,
	ADL_ERR_NOT_SUPPORTED          = -8,
	ADL_ERR_NULL_POINTER           = -9,
	ADL_ERR_DISABLED_ADAPTER       = -10,
	ADL_ERR_INVALID_CALLBACK       = -11,
	ADL_ERR_RESOURCE_CONFLICT      = -12,
};

enum {
	ADL_DT_MONITOR            = 0,
	ADL_DT_TELEVISION         = 1,
	ADL_DT_LCD_PANEL          = 2,
	ADL_DT_DIGITAL_FLAT_PANEL = 3,
	ADL_DT_COMPONENT_VIDEO    = 4,
	ADL_DT_PROJECTOR          = 5,
};

enum {
	ADL_DOT_UNKNOWN   = 0,
	ADL_DOT_COMPOSITE = 1,
	ADL_DOT_SVIDEO    = 2,
	ADL_DOT_ANALOG    = 3,
	ADL_DOT_DIGITAL   = 4,
};

enum {
	ADL_DISPLAY_COLOR_BRIGHTNESS  = (1 << 0),
	ADL_DISPLAY_COLOR_CONTRAST    = (1 << 1),
	ADL_DISPLAY_COLOR_SATURATION  = (1 << 2),
	ADL_DISPLAY_COLOR_HUE         = (1 << 3),
	ADL_DISPLAY_COLOR_TEMPERATURE = (1 << 4),
	ADL_DISPLAY_COLOR_TEMPERATURE_SOURCE_EDID = (1 << 5),
	ADL_DISPLAY_COLOR_TEMPERATURE_SOURCE_USER = (1 << 6),
};

enum {
	ADL_DISPLAY_ADJUST_OVERSCAN  = (1 << 0),
	ADL_DISPLAY_ADJUST_VERT_POS  = (1 << 1),
	ADL_DISPLAY_ADJUST_HOR_POS   = (1 << 2),
	ADL_DISPLAY_ADJUST_VERT_SIZE = (1 << 3),
	ADL_DISPLAY_ADJUST_HOR_SIZE  = (1 << 4),
	ADL_DISPLAY_ADJUST_SIZEPOS   = (ADL_DISPLAY_ADJUST_VERT_POS | ADL_DISPLAY_ADJUST_HOR_POS | ADL_DISPLAY_ADJUST_VERT_SIZE | ADL_DISPLAY_ADJUST_HOR_SIZE),
	ADL_DISPLAY_CUSTOMMODES      = (1 << 5),
	ADL_DISPLAY_ADJUST_UNDERSCAN = (1 << 6),
};

enum {
	ADL_DESKTOPCONFIG_UNKNOWN    = 0,
	ADL_DESKTOPCONFIG_SINGLE     = (1 << 0),
	ADL_DESKTOPCONFIG_CLONE      = (1 << 2),
	ADL_DESKTOPCONFIG_BIGDESK_H  = (1 << 4),
	ADL_DESKTOPCONFIG_BIGDESK_V  = (1 << 5),
	ADL_DESKTOPCONFIG_BIGDESK_HR = (1 << 6),
	ADL_DESKTOPCONFIG_BIGDESK_VR = (1 << 7),
	ADL_DESKTOPCONFIG_RANDR12    = (1 << 8),
};

#define ADL_MAX_DISPLAY_NAME  256

enum {
	ADL_DISPLAYDDCINFOEX_FLAG_PROJECTORDEVICE  = (1 << 0),
	ADL_DISPLAYDDCINFOEX_FLAG_EDIDEXTENSION    = (1 << 1),
	ADL_DISPLAYDDCINFOEX_FLAG_DIGITALDEVICE    = (1 << 2),
	ADL_DISPLAYDDCINFOEX_FLAG_HDMIAUDIODEVICE  = (1 << 3),
	ADL_DISPLAYDDCINFOEX_FLAG_SUPPORTS_AI      = (1 << 4),
	ADL_DISPLAYDDCINFOEX_FLAG_SUPPORT_xvYCC601 = (1 << 5),
	ADL_DISPLAYDDCINFOEX_FLAG_SUPPORT_xvYCC709 = (1 << 6),
};

enum {
	ADL_DISPLAY_CONTYPE_UNKNOWN                 =  0,
	ADL_DISPLAY_CONTYPE_VGA                     =  1,
	ADL_DISPLAY_CONTYPE_DVI_D                   =  2,
	ADL_DISPLAY_CONTYPE_DVI_I                   =  3,
	ADL_DISPLAY_CONTYPE_ATICVDONGLE_NTSC        =  4,
	ADL_DISPLAY_CONTYPE_ATICVDONGLE_JPN         =  5,
	ADL_DISPLAY_CONTYPE_ATICVDONGLE_NONI2C_JPN  =  6,
	ADL_DISPLAY_CONTYPE_ATICVDONGLE_NONI2C_NTSC =  7,
	ADL_DISPLAY_CONTYPE_HDMI_TYPE_A             = 10,
	ADL_DISPLAY_CONTYPE_HDMI_TYPE_B             = 11,
	ADL_DISPLAY_CONTYPE_SVIDEO                  = 12,
	ADL_DISPLAY_CONTYPE_COMPOSITE               = 13,
	ADL_DISPLAY_CONTYPE_RCA_3COMPONENT          = 14,
	ADL_DISPLAY_CONTYPE_DISPLAYPORT             = 15,
};

enum {
	ADL_TV_STANDARDS = (1 << 0),
	ADL_TV_SCART     = (1 << 1),
};

enum {
	ADL_STANDARD_NTSC_M       = (1 <<  0),
	ADL_STANDARD_NTSC_JPN     = (1 <<  1),
	ADL_STANDARD_NTSC_N       = (1 <<  2),
	ADL_STANDARD_PAL_B        = (1 <<  3),
	ADL_STANDARD_PAL_COMB_N   = (1 <<  4),
	ADL_STANDARD_PAL_D        = (1 <<  5),
	ADL_STANDARD_PAL_G        = (1 <<  6),
	ADL_STANDARD_PAL_H        = (1 <<  7),
	ADL_STANDARD_PAL_I        = (1 <<  8),
	ADL_STANDARD_PAL_K        = (1 <<  9),
	ADL_STANDARD_PAL_K1       = (1 << 10),
	ADL_STANDARD_PAL_L        = (1 << 11),
	ADL_STANDARD_PAL_M        = (1 << 12),
	ADL_STANDARD_PAL_N        = (1 << 13),
	ADL_STANDARD_PAL_SECAM_D  = (1 << 14),
	ADL_STANDARD_PAL_SECAM_K  = (1 << 15),
	ADL_STANDARD_PAL_SECAM_K1 = (1 << 16),
	ADL_STANDARD_PAL_SECAM_L  = (1 << 17),
};

enum {
	ADL_CUSTOMIZEDMODEFLAG_MODESUPPORTED  = (1 << 0),
	ADL_CUSTOMIZEDMODEFLAG_NOTDELETETABLE = (1 << 1),
	ADL_CUSTOMIZEDMODEFLAG_INSERTBYDRIVER = (1 << 2),
	ADL_CUSTOMIZEDMODEFLAG_INTERLACED     = (1 << 3),
	ADL_CUSTOMIZEDMODEFLAG_BASEMODE       = (1 << 4),
};

enum {
	ADL_DISPLAY_CV_DONGLE_D1 = (1 << 0),
	ADL_DISPLAY_CV_DONGLE_D2 = (1 << 1),
	ADL_DISPLAY_CV_DONGLE_D3 = (1 << 2),
	ADL_DISPLAY_CV_DONGLE_D4 = (1 << 3),
	ADL_DISPLAY_CV_DONGLE_D5 = (1 << 4),
};

enum {
	ADL_DISPLAY_CV_DONGLE_480I    = (1 <<  0),
	ADL_DISPLAY_CV_DONGLE_480P    = (1 <<  1),
	ADL_DISPLAY_CV_DONGLE_540P    = (1 <<  2),
	ADL_DISPLAY_CV_DONGLE_720P    = (1 <<  3),
	ADL_DISPLAY_CV_DONGLE_1080I   = (1 <<  4),
	ADL_DISPLAY_CV_DONGLE_1080P   = (1 <<  5),
	ADL_DISPLAY_CV_DONGLE_16_9    = (1 <<  6),
	ADL_DISPLAY_CV_DONGLE_720P50  = (1 <<  7),
	ADL_DISPLAY_CV_DONGLE_1080I25 = (1 <<  8),
	ADL_DISPLAY_CV_DONGLE_576I25  = (1 <<  9),
	ADL_DISPLAY_CV_DONGLE_576P50  = (1 << 10),
	ADL_DISPLAY_CV_DONGLE_1080P24 = (1 << 11),
	ADL_DISPLAY_CV_DONGLE_1080P25 = (1 << 12),
	ADL_DISPLAY_CV_DONGLE_1080P30 = (1 << 13),
	ADL_DISPLAY_CV_DONGLE_1080P50 = (1 << 14),
};

enum {
	ADL_DISPLAY_FORMAT_FORCE_720P    = (1 <<  0),
	ADL_DISPLAY_FORMAT_FORCE_1080I   = (1 <<  1),
	ADL_DISPLAY_FORMAT_FORCE_1080P   = (1 <<  2),
	ADL_DISPLAY_FORMAT_FORCE_720P50  = (1 <<  3),
	ADL_DISPLAY_FORMAT_FORCE_1080I25 = (1 <<  4),
	ADL_DISPLAY_FORMAT_FORCE_576I25  = (1 <<  5),
	ADL_DISPLAY_FORMAT_FORCE_576P50  = (1 <<  6),
	ADL_DISPLAY_FORMAT_FORCE_1080P24 = (1 <<  7),
	ADL_DISPLAY_FORMAT_FORCE_1080P25 = (1 <<  8),
	ADL_DISPLAY_FORMAT_FORCE_1080P30 = (1 <<  9),
	ADL_DISPLAY_FORMAT_FORCE_1080P50 = (1 << 10),
};

enum {
	ADL_DISPLAY_FORMAT_CVDONGLEOVERIDE           = (1 << 0),
	ADL_DISPLAY_FORMAT_CVMODEUNDERSCAN           = (1 << 1),
	ADL_DISPLAY_FORMAT_FORCECONNECT_SUPPORTED    = (1 << 2),
	ADL_DISPLAY_FORMAT_RESTRICT_FORMAT_SELECTION = (1 << 3),
	ADL_DISPLAY_FORMAT_SETASPECRATIO             = (1 << 4),
	ADL_DISPLAY_FORMAT_FORCEMODES                = (1 << 5),
	ADL_DISPLAY_FORMAT_LCDRTCCOEFF               = (1 << 6),
};

enum {
	ADL_PM_PARAM_DONT_CHANGE = 0,
};

enum {
	ADL_BUSTYPE_PCI       = 0,
	ADL_BUSTYPE_AGP       = 1,
	ADL_BUSTYPE_PCIE      = 2,
	ADL_BUSTYPE_PCIE_GEN2 = 3,
};

enum {
	ADL_STEREO_OFF             = 0,
	ADL_STEREO_ACTIVE          = (1 << 1),
	ADL_STEREO_SUPPORTED       = (1 << 2),
	ADL_STEREO_BLUE_LINE       = (1 << 3),
	ADL_STEREO_PASSIVE         = (1 << 6),
	ADL_STEREO_PASSIVE_HORIZ   = (1 << 7),
	ADL_STEREO_PASSIVE_VERT    = (1 << 8),
	ADL_STEREO_AUTO_HORIZONTAL = (1 << 30),
	ADL_STEREO_AUTO_VERTICAL   = (1 << 31),
};

enum {
	ADL_WORKSTATION_LOADBALANCING_SUPPORTED = 1,
	ADL_WORKSTATION_LOADBALANCING_AVAILABLE = 2,
};

enum {
	ADL_WORKSTATION_LOADBALANCING_DISABLED  = 0,
	ADL_WORKSTATION_LOADBALANCING_ENABLED   = 1,
};

enum {
	ADL_CONTEXT_SPEED_UNFORCED  = 0,
	ADL_CONTEXT_SPEED_FORCEHIGH = 1,
	ADL_CONTEXT_SPEED_FORCELOW  = 2,
};

enum {
	ADL_ADAPTER_SPEEDCAPS_SUPPORTED = (1 << 0),
};

enum {
	ADL_GLSYNC_PORT_UNKNOWN   = 0,
	ADL_GLSYNC_PORT_BNC       = 1,
	ADL_GLSYNC_PORT_RJ45PORT1 = 2,
	ADL_GLSYNC_PORT_RJ45PORT2 = 3,
};

enum {
	ADL_GLSYNC_CONFIGMASK_NONE          = 0,
	ADL_GLSYNC_CONFIGMASK_SIGNALSOURCE  = (1 << 0),
	ADL_GLSYNC_CONFIGMASK_SYNCFIELD     = (1 << 1),
	ADL_GLSYNC_CONFIGMASK_SAMPLERATE    = (1 << 2),
	ADL_GLSYNC_CONFIGMASK_SYNCDELAY     = (1 << 3),
	ADL_GLSYNC_CONFIGMASK_TRIGGEREDGE   = (1 << 4),
	ADL_GLSYNC_CONFIGMASK_SCANRATECOEFF = (1 << 5),
	ADL_GLSYNC_CONFIGMASK_FRAMELOCKCNTL = (1 << 6),
};

enum {
	ADL_GLSYNC_FRAMELOCKCNTL_NONE               = 0,
	ADL_GLSYNC_FRAMELOCKCNTL_ENABLE             = (1 << 0),
	ADL_GLSYNC_FRAMELOCKCNTL_DISABLE            = (1 << 1),
	ADL_GLSYNC_FRAMELOCKCNTL_SWAP_COUNTER_RESET = (1 << 2),
	ADL_GLSYNC_FRAMELOCKCNTL_SWAP_COUNTER_ACK   = (1 << 3),
	ADL_GLSYNC_FRAMELOCKCNTL_STATE_ENABLE       = (1 << 0),
};

enum {
	ADL_GLSYNC_COUNTER_SWAP = (1 << 0),
};

enum {
	ADL_GLSYNC_SIGNALSOURCE_UNDEFINED = 0x0100,
	ADL_GLSYNC_SIGNALSOURCE_FREERUN   = 0x0101,
	ADL_GLSYNC_SIGNALSOURCE_BNCPORT   = 0x0102,
	ADL_GLSYNC_SIGNALSOURCE_RJ45PORT1 = 0x0103,
	ADL_GLSYNC_SIGNALSOURCE_RJ45PORT2 = 0x0104,
};

enum {
	ADL_GLSYNC_SIGNALTYPE_UNDEFINED =  0,
	ADL_GLSYNC_SIGNALTYPE_480I      =  1,
	ADL_GLSYNC_SIGNALTYPE_576I      =  2,
	ADL_GLSYNC_SIGNALTYPE_480P      =  3,
	ADL_GLSYNC_SIGNALTYPE_576P      =  4,
	ADL_GLSYNC_SIGNALTYPE_720P      =  5,
	ADL_GLSYNC_SIGNALTYPE_1080P     =  6,
	ADL_GLSYNC_SIGNALTYPE_1080I     =  7,
	ADL_GLSYNC_SIGNALTYPE_SDI       =  8,
	ADL_GLSYNC_SIGNALTYPE_TTL       =  9,
	ADL_GLSYNC_SIGNALTYPE_ANALOG    = 10,
};

enum {
	ADL_GLSYNC_SYNCFIELD_UNDEFINED = 0,
	ADL_GLSYNC_SYNCFIELD_BOTH      = 1,
	ADL_GLSYNC_SYNCFIELD_1         = 2,
};

enum {
	ADL_GLSYNC_TRIGGEREDGE_UNDEFINED = 0,
	ADL_GLSYNC_TRIGGEREDGE_RISING    = 1,
	ADL_GLSYNC_TRIGGEREDGE_FALLING   = 2,
	ADL_GLSYNC_TRIGGEREDGE_BOTH      = 3,
};

enum {
	ADL_GLSYNC_SCANRATECOEFF_UNDEFINED =  0,
	ADL_GLSYNC_SCANRATECOEFF_x5        =  1,
	ADL_GLSYNC_SCANRATECOEFF_x4        =  2,
	ADL_GLSYNC_SCANRATECOEFF_x3        =  3,
	ADL_GLSYNC_SCANRATECOEFF_x5_DIV_2  =  4,
	ADL_GLSYNC_SCANRATECOEFF_x2        =  5,
	ADL_GLSYNC_SCANRATECOEFF_x3_DIV_2  =  6,
	ADL_GLSYNC_SCANRATECOEFF_x5_DIV_4  =  7,
	ADL_GLSYNC_SCANRATECOEFF_x1        =  8,
	ADL_GLSYNC_SCANRATECOEFF_x4_DIV_5  =  9,
	ADL_GLSYNC_SCANRATECOEFF_x2_DIV_3  = 10,
	ADL_GLSYNC_SCANRATECOEFF_x1_DIV_2  = 11,
	ADL_GLSYNC_SCANRATECOEFF_x2_DIV_5  = 12,
	ADL_GLSYNC_SCANRATECOEFF_x1_DIV_3  = 13,
	ADL_GLSYNC_SCANRATECOEFF_x1_DIV_4  = 14,
	ADL_GLSYNC_SCANRATECOEFF_x1_DIV_5  = 15,
};

enum {
	ADL_GLSYNC_PORTSTATE_UNDEFINED = 0,
	ADL_GLSYNC_PORTSTATE_NOCABLE   = 1,
	ADL_GLSYNC_PORTSTATE_IDLE      = 2,
	ADL_GLSYNC_PORTSTATE_INPUT     = 3,
	ADL_GLSYNC_PORTSTATE_OUTPUT    = 4,
};

enum {
	ADL_GLSYNC_LEDTYPE_BNC        = 0,
	ADL_GLSYNC_LEDTYPE_RJ45_LEFT  = 0,
	ADL_GLSYNC_LEDTYPE_RJ45_RIGHT = 1,
};

enum {
	ADL_GLSYNC_LEDCOLOR_UNDEFINED   = 0,
	ADL_GLSYNC_LEDCOLOR_NOLIGHT     = 1,
	ADL_GLSYNC_LEDCOLOR_YELLOW      = 2,
	ADL_GLSYNC_LEDCOLOR_RED         = 3,
	ADL_GLSYNC_LEDCOLOR_GREEN       = 4,
	ADL_GLSYNC_LEDCOLOR_FLASH_GREEN = 5,
};

enum {
	ADL_GLSYNC_PORTCNTL_NONE   = 0,
	ADL_GLSYNC_PORTCNTL_OUTPUT = 1,
};

enum {
	ADL_GLSYNC_MODECNTL_NONE         = 0,
	ADL_GLSYNC_MODECNTL_GENLOCK      = 1,
	ADL_GLSYNC_MODECNTL_TIMINGSERVER = 2,
};

enum {
	ADL_GLSYNC_MODECNTL_STATUS_NONE             = 0,
	ADL_GLSYNC_MODECNTL_STATUS_GENLOCK          = (1 << 0),
	ADL_GLSYNC_MODECNTL_STATUS_SETMODE_REQUIRED = (1 << 1),
	ADL_GLSYNC_MODECNTL_STATUS_GENLOCK_ALLOWED  = (1 << 2),
};

#define ADL_MAX_GLSYNC_PORTS      8
#define ADL_MAX_GLSYNC_PORT_LEDS  8

enum {
	ADL_XFIREX_STATE_NOINTERCONNECT             = (1 <<  0),
	ADL_XFIREX_STATE_DOWNGRADEPIPES             = (1 <<  1),
	ADL_XFIREX_STATE_DOWNGRADEMEM               = (1 <<  2),
	ADL_XFIREX_STATE_REVERSERECOMMENDED         = (1 <<  3),
	ADL_XFIREX_STATE_3DACTIVE                   = (1 <<  4),
	ADL_XFIREX_STATE_MASTERONSLAVE              = (1 <<  5),
	ADL_XFIREX_STATE_NODISPLAYCONNECT           = (1 <<  6),
	ADL_XFIREX_STATE_NOPRIMARYVIEW              = (1 <<  7),
	ADL_XFIREX_STATE_DOWNGRADEVISMEM            = (1 <<  8),
	ADL_XFIREX_STATE_LESSTHAN8LANE_MASTER       = (1 <<  9),
	ADL_XFIREX_STATE_LESSTHAN8LANE_SLAVE        = (1 << 10),
	ADL_XFIREX_STATE_PEERTOPEERFAILED           = (1 << 11),
	ADL_XFIREX_STATE_MEMISDOWNGRADED            = (1 << 16),
	ADL_XFIREX_STATE_PIPESDOWNGRADED            = (1 << 17),
	ADL_XFIREX_STATE_XFIREXACTIVE               = (1 << 18),
	ADL_XFIREX_STATE_VISMEMISDOWNGRADED         = (1 << 19),
	ADL_XFIREX_STATE_INVALIDINTERCONNECTION     = (1 << 20),
	ADL_XFIREX_STATE_NONP2PMODE                 = (1 << 21),
	ADL_XFIREX_STATE_DOWNGRADEMEMBANKS          = (1 << 22),
	ADL_XFIREX_STATE_MEMBANKSDOWNGRADED         = (1 << 23),
	ADL_XFIREX_STATE_DUALDISPLAYSALLOWED        = (1 << 24),
	ADL_XFIREX_STATE_P2P_APERTURE_MAPPING       = (1 << 25),
	ADL_XFIREX_STATE_P2PFLUSH_REQUIRED = ADL_XFIREX_STATE_P2P_APERTURE_MAPPING,
	ADL_XFIREX_STATE_XSP_CONNECTED              = (1 << 26),
	ADL_XFIREX_STATE_ENABLE_CF_REBOOT_REQUIRED  = (1 << 27),
	ADL_XFIREX_STATE_DISABLE_CF_REBOOT_REQUIRED = (1 << 28),
	ADL_XFIREX_STATE_DRV_HANDLE_DOWNGRADE_KEY   = (1 << 29),
	ADL_XFIREX_STATE_CF_RECONFIG_REQUIRED       = (1 << 30),
	ADL_XFIREX_STATE_ERRORGETTINGSTATUS         = (1 << 31),
};

enum {
	ADL_DISPLAY_PIXELFORMAT_UNKNOWN           = 0,
	ADL_DISPLAY_PIXELFORMAT_RGB               = (1 << 0),
	ADL_DISPLAY_PIXELFORMAT_YCRCB444          = (1 << 1),
	ADL_DISPLAY_PIXELFORMAT_YCRCB422          = (1 << 2),
	ADL_DISPLAY_PIXELFORMAT_RGB_LIMITED_RANGE = (1 << 3),
	ADL_DISPLAY_PIXELFORMAT_RGB_FULL_RANGE = ADL_DISPLAY_PIXELFORMAT_RGB
};

enum {
	ADL_DL_DISPLAYCONFIG_CONTYPE_UNKNOWN      = 0,
	ADL_DL_DISPLAYCONFIG_CONTYPE_CV_NONI2C_JP = 1,
	ADL_DL_DISPLAYCONFIG_CONTYPE_CV_JPN       = 2,
	ADL_DL_DISPLAYCONFIG_CONTYPE_CV_NA        = 3,
	ADL_DL_DISPLAYCONFIG_CONTYPE_CV_NONI2C_NA = 4,
	ADL_DL_DISPLAYCONFIG_CONTYPE_VGA          = 5,
	ADL_DL_DISPLAYCONFIG_CONTYPE_DVI_D        = 6,
	ADL_DL_DISPLAYCONFIG_CONTYPE_DVI_I        = 7,
	ADL_DL_DISPLAYCONFIG_CONTYPE_HDMI_TYPE_A  = 8,
	ADL_DL_DISPLAYCONFIG_CONTYPE_HDMI_TYPE_B  = 9,
	ADL_DL_DISPLAYCONFIG_CONTYPE_DISPLAYPORT  = 10,
};

enum {
	ADL_DISPLAY_DISPLAYINFO_DISPLAYCONNECTED   = (1 << 0),
	ADL_DISPLAY_DISPLAYINFO_DISPLAYMAPPED      = (1 << 1),
	ADL_DISPLAY_DISPLAYINFO_NONLOCAL           = (1 << 2),
	ADL_DISPLAY_DISPLAYINFO_FORCIBLESUPPORTED  = (1 << 3),
	ADL_DISPLAY_DISPLAYINFO_GENLOCKSUPPORTED   = (1 << 4),
	ADL_DISPLAY_DISPLAYINFO_MULTIVPU_SUPPORTED = (1 << 5),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_SINGLE       = (1 << 8),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_CLONE        = (1 << 9),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_2VSTRETCH    = (1 << 10),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_2HSTRETCH    = (1 << 11),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_EXTENDED     = (1 << 12),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_NSTRETCH1GPU = (1 << 16),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_NSTRETCHNGPU = (1 << 17),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_RESERVED2    = (1 << 18),
	ADL_DISPLAY_DISPLAYINFO_MANNER_SUPPORTED_RESERVED3    = (1 << 19),
};

enum {
	ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_NOTACTIVE    = (1 << 0),
	ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_SINGLE       = (1 << 1),
	ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_CLONE        = (1 << 2),
	ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_NSTRETCH1GPU = (1 << 3),
	ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_NSTRETCHNGPU = (1 << 4),
	ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_2VSTRETCH    = (1 << 5),
	ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_2HSTRETCH    = (1 << 6),
	ADL_ADAPTER_DISPLAYCAP_MANNER_SUPPORTED_EXTENDED     = (1 << 7),
	ADL_ADAPTER_DISPLAYCAP_PREFERDISPLAY_SUPPORTED       = (1 << 8),
	ADL_ADAPTER_DISPLAYCAP_BEZEL_SUPPORTED               = (1 << 9),
};

enum {
	ADL_DISPLAY_DISPLAYMAP_MANNER_RESERVED  = (1 << 0),
	ADL_DISPLAY_DISPLAYMAP_MANNER_NOTACTIVE = (1 << 1),
	ADL_DISPLAY_DISPLAYMAP_MANNER_SINGLE    = (1 << 2),
	ADL_DISPLAY_DISPLAYMAP_MANNER_CLONE     = (1 << 3),
	ADL_DISPLAY_DISPLAYMAP_MANNER_RESERVED1 = (1 << 4),
	ADL_DISPLAY_DISPLAYMAP_MANNER_HSTRETCH  = (1 << 5),
	ADL_DISPLAY_DISPLAYMAP_MANNER_VSTRETCH  = (1 << 6),
	ADL_DISPLAY_DISPLAYMAP_MANNER_VLD       = (1 << 7),
};

enum {
	ADL_DISPLAY_DISPLAYMAP_OPTION_GPUINFO = 1,
};

enum {
	ADL_DISPLAY_DISPLAYTARGET_PREFERRED = 1,
};

enum {
	ADL_DISPLAY_POSSIBLEMAPRESULT_VALID          = 1,
	ADL_DISPLAY_POSSIBLEMAPRESULT_BEZELSUPPORTED = 2,
};

enum {
	ADL_DISPLAY_MODE_COLOURFORMAT_565          = (1 << 0),
	ADL_DISPLAY_MODE_COLOURFORMAT_8888         = (1 << 1),
	ADL_DISPLAY_MODE_ORIENTATION_SUPPORTED_000 = (1 << 2),
	ADL_DISPLAY_MODE_ORIENTATION_SUPPORTED_090 = (1 << 3),
	ADL_DISPLAY_MODE_ORIENTATION_SUPPORTED_180 = (1 << 4),
	ADL_DISPLAY_MODE_ORIENTATION_SUPPORTED_270 = (1 << 5),
	ADL_DISPLAY_MODE_REFRESHRATE_ROUNDED       = (1 << 6),
	ADL_DISPLAY_MODE_REFRESHRATE_ONLY          = (1 << 7),
};

enum {
	ADL_DISPLAY_MODE_PROGRESSIVE_FLAG = 0,
	ADL_DISPLAY_MODE_INTERLACED_FLAG  = 2,
};

#define ADL_OSMODEINFOXPOS_DEFAULT    -640
#define ADL_OSMODEINFOYPOS_DEFAULT       0
#define ADL_OSMODEINFOXRES_DEFAULT     640
#define ADL_OSMODEINFOYRES_DEFAULT     480
#define ADL_OSMODEINFOXRES_DEFAULT800  800
#define ADL_OSMODEINFOYRES_DEFAULT600  600
#define ADL_OSMODEINFOREFRESHRATE_DEFAULT  60
#define ADL_OSMODEINFOCOLOURDEPTH_DEFAULT     8
#define ADL_OSMODEINFOCOLOURDEPTH_DEFAULT16  16
#define ADL_OSMODEINFOCOLOURDEPTH_DEFAULT24  24
#define ADL_OSMODEINFOCOLOURDEPTH_DEFAULT32  32
#define ADL_OSMODEINFOORIENTATION_DEFAULT       0
#define ADL_OSMODEINFOORIENTATION_DEFAULT_WIN7  DISPLAYCONFIG_ROTATION_FORCE_UINT32
#define ADL_OSMODEFLAG_DEFAULT  0

enum ADLPurposeCode {
	ADL_PURPOSECODE_NORMAL = 0,
	ADL_PURPOSECODE_HIDE_MODE_SWITCH,
	ADL_PURPOSECODE_MODE_SWITCH,
	ADL_PURPOSECODE_ATTATCH_DEVICE,
	ADL_PURPOSECODE_DETACH_DEVICE,
	ADL_PURPOSECODE_SETPRIMARY_DEVICE,
	ADL_PURPOSECODE_GDI_ROTATION,
	ADL_PURPOSECODE_ATI_ROTATION,
};

enum ADLAngle {
	ADL_ANGLE_LANDSCAPE   =   0,
	ADL_ANGLE_ROTATERIGHT =  90,
	ADL_ANGLE_ROTATE180   = 180,
	ADL_ANGLE_ROTATELEFT  = 270,
};

enum ADLOrientationDataType {
	ADL_ORIENTATIONTYPE_OSDATATYPE,
	ADL_ORIENTATIONTYPE_NONOSDATATYPE
};

enum ADLPanningMode {
	ADL_PANNINGMODE_NO_PANNING              = 0,
	ADL_PANNINGMODE_AT_LEAST_ONE_NO_PANNING = 1,
	ADL_PANNINGMODE_ALLOW_PANNING           = 2,
};

enum ADLLARGEDESKTOPTYPE {
	ADL_LARGEDESKTOPTYPE_NORMALDESKTOP      = 0,
	ADL_LARGEDESKTOPTYPE_PSEUDOLARGEDESKTOP = 1,
	ADL_LARGEDESKTOPTYPE_VERYLARGEDESKTOP   = 2,
};

#define ADL_I2C_MAJOR_API_REV          1
#define ADL_I2C_MINOR_DEFAULT_API_REV  0
#define ADL_I2C_MINOR_OEM_API_REV      1

enum {
	ADL_DL_I2C_LINE_OEM        = 1,
	ADL_DL_I2C_LINE_OD_CONTROL = 2,
	ADL_DL_I2C_LINE_OEM2       = 3,
};

#define ADL_DL_I2C_MAXDATASIZE       0x00000040
#define ADL_DL_I2C_MAXWRITEDATASIZE  0x0000000C
#define ADL_DL_I2C_MAXADDRESSLENGTH  0x00000006
#define ADL_DL_I2C_MAXOFFSETLENGTH   0x00000004

enum {
	ADL_DL_DISPLAYPROPERTY_TYPE_UNKNOWN             = 0,
	ADL_DL_DISPLAYPROPERTY_TYPE_EXPANSIONMODE       = 1,
	ADL_DL_DISPLAYPROPERTY_TYPE_USEUNDERSCANSCALING = 2,
};

enum {
	ADL_DL_DISPLAYPROPERTY_EXPANSIONMODE_CENTER      = 0,
	ADL_DL_DISPLAYPROPERTY_EXPANSIONMODE_FULLSCREEN  = 1,
	ADL_DL_DISPLAYPROPERTY_EXPANSIONMODE_ASPECTRATIO = 2,
};

enum {
	ADL_DL_DISPLAY_DITHER_UNKNOWN  = 0,
	ADL_DL_DISPLAY_DITHER_DISABLED = 1,
	ADL_DL_DISPLAY_DITHER_ENABLED  = 2,
};

#define ADL_MAX_EDIDDATA_SIZE  256
#define ADL_MAX_EDID_EXTENSION_BLOCKS  3

enum {
	ADL_DL_CONTROLLER_OVERLAY_ALPHA       = 0,
	ADL_DL_CONTROLLER_OVERLAY_ALPHAPERPIX = 1,
};

enum {
	ADL_DL_DISPLAY_DATA_PACKET__INFO_PACKET_RESET = 0,
	ADL_DL_DISPLAY_DATA_PACKET__INFO_PACKET_SET   = 1,
};

enum {
	ADL_DL_DISPLAY_DATA_PACKET__TYPE__AVI        = (1 << 0),
	ADL_DL_DISPLAY_DATA_PACKET__TYPE__RESERVED   = (1 << 1),
	ADL_DL_DISPLAY_DATA_PACKET__TYPE__VENDORINFO = (1 << 2),
};

enum {
	ADL_GAMUT_MATRIX_SD = 1,
	ADL_GAMUT_MATRIX_HD = 2,
};

enum {
	ADL_DL_CLOCKINFO_FLAG_FULLSCREEN3DONLY   = (1 << 0),
	ADL_DL_CLOCKINFO_FLAG_ALWAYSFULLSCREEN3D = (1 << 1),
	ADL_DL_CLOCKINFO_FLAG_VPURECOVERYREDUCED = (1 << 2),
	ADL_DL_CLOCKINFO_FLAG_THERMALPROTECTION  = (1 << 3),
};

enum {
	ADL_DL_POWERXPRESS_GPU_INTEGRATED = 1,
	ADL_DL_POWERXPRESS_GPU_DISCRETE   = 2,
};

enum {
	ADL_DL_POWERXPRESS_SWITCH_RESULT_STARTED  = 1,
	ADL_DL_POWERXPRESS_SWITCH_RESULT_DECLINED = 2,
	ADL_DL_POWERXPRESS_SWITCH_RESULT_ALREADY  = 3,
};

#define ADL_DL_POWERXPRESS_VERSION_MAJOR  2
#define ADL_DL_POWERXPRESS_VERSION_MINOR  0
#define ADL_DL_POWERXPRESS_VERSION  (((ADL_DL_POWERXPRESS_VERSION_MAJOR) << 16) | ADL_DL_POWERXPRESS_VERSION_MINOR)

enum {
	ADL_DL_THERMAL_DOMAIN_OTHER = 0,
	ADL_DL_THERMAL_DOMAIN_GPU   = 1,
};

enum {
	ADL_DL_THERMAL_FLAG_INTERRUPT  = 1,
	ADL_DL_THERMAL_FLAG_FANCONTROL = 2,
};

enum {
	ADL_DL_FANCTRL_SUPPORTS_PERCENT_READ  = (1 << 0),
	ADL_DL_FANCTRL_SUPPORTS_PERCENT_WRITE = (1 << 1),
	ADL_DL_FANCTRL_SUPPORTS_RPM_READ      = (1 << 2),
	ADL_DL_FANCTRL_SUPPORTS_RPM_WRITE     = (1 << 3),
};

enum {
	ADL_DL_FANCTRL_SPEED_TYPE_PERCENT = 1,
	ADL_DL_FANCTRL_SPEED_TYPE_RPM     = 2,
};

enum {
	ADL_DL_FANCTRL_FLAG_USER_DEFINED_SPEED = 1,
};

#define ADL_DL_MAX_MVPU_ADAPTERS  4

enum {
	MVPU_ADAPTER_0 = (1 << 0),
	MVPU_ADAPTER_1 = (1 << 1),
	MVPU_ADAPTER_2 = (1 << 2),
	MVPU_ADAPTER_3 = (1 << 3),
};

#define ADL_DL_MAX_REGISTRY_PATH  256

enum {
	ADL_DL_MVPU_STATUS_OFF = 0,
	ADL_DL_MVPU_STATUS_ON  = 1,
};

enum {
	ADL_ASIC_UNDEFINED  = 0,
	ADL_ASIC_DISCRETE   = (1 << 0),
	ADL_ASIC_INTEGRATED = (1 << 1),
	ADL_ASIC_FIREGL     = (1 << 2),
	ADL_ASIC_FIREMV     = (1 << 3),
	ADL_ASIC_XGP        = (1 << 4),
	ADL_ASIC_FUSION     = (1 << 5),
};

enum {
	ADL_DL_TIMINGFLAG_DOUBLE_SCAN     = (1 << 0),
	ADL_DL_TIMINGFLAG_INTERLACED      = (1 << 1),
	ADL_DL_TIMINGFLAG_H_SYNC_POLARITY = (1 << 2),
	ADL_DL_TIMINGFLAG_V_SYNC_POLARITY = (1 << 3),
};

enum {
	ADL_DL_MODETIMING_STANDARD_CVT            = (1 << 0),
	ADL_DL_MODETIMING_STANDARD_GTF            = (1 << 1),
	ADL_DL_MODETIMING_STANDARD_DMT            = (1 << 2),
	ADL_DL_MODETIMING_STANDARD_CUSTOM         = (1 << 3),
	ADL_DL_MODETIMING_STANDARD_DRIVER_DEFAULT = (1 << 4),
};

enum {
	ADL_XSERVERINFO_XINERAMAACTIVE   = (1 << 0),
	ADL_XSERVERINFO_RANDR12SUPPORTED = (1 << 1),
};

enum {
	ADL_CONTROLLERVECTOR_0 = 1,
	ADL_CONTROLLERVECTOR_1 = 2,
};

enum {
	ADL_DISPLAY_SLSGRID_ORIENTATION_000 = (1 << 0),
	ADL_DISPLAY_SLSGRID_ORIENTATION_090 = (1 << 1),
	ADL_DISPLAY_SLSGRID_ORIENTATION_180 = (1 << 2),
	ADL_DISPLAY_SLSGRID_ORIENTATION_270 = (1 << 3),
};

enum {
	ADL_DISPLAY_SLSGRID_CAP_OPTION_RELATIVETO_LANDSCAPE    = (1 << 0),
	ADL_DISPLAY_SLSGRID_CAP_OPTION_RELATIVETO_CURRENTANGLE = (1 << 1),
	ADL_DISPLAY_SLSGRID_PORTAIT_MODE                       = (1 << 2),
};

enum {
	ADL_DISPLAY_SLSMAPCONFIG_GET_OPTION_RELATIVETO_LANDSCAPE    = 1,
	ADL_DISPLAY_SLSMAPCONFIG_GET_OPTION_RELATIVETO_CURRENTANGLE = 2,
};

enum {
	ADL_DISPLAY_SLSMAPCONFIG_CREATE_OPTION_RELATIVETO_LANDSCAPE    = 1,
	ADL_DISPLAY_SLSMAPCONFIG_CREATE_OPTION_RELATIVETO_CURRENTANGLE = 2,
};

enum {
	ADL_DISPLAY_SLSMAPCONFIG_REARRANGE_OPTION_RELATIVETO_LANDSCAPE    = 1,
	ADL_DISPLAY_SLSMAPCONFIG_REARRANGE_OPTION_RELATIVETO_CURRENTANGLE = 2,
};

enum {
	ADL_DISPLAY_SLSGRID_RELATIVETO_LANDSCAPE    = 0x10,
	ADL_DISPLAY_SLSGRID_RELATIVETO_CURRENTANGLE = 0x20,
};

enum {
	ADL_DISPLAY_SLSMAP_BEZELMODE       = (1 << 4),
	ADL_DISPLAY_SLSMAP_DISPLAYARRANGED = (1 << 1),
	ADL_DISPLAY_SLSMAP_CURRENTCONFIG   = (1 << 2),
};

enum {
	ADL_DISPLAY_SLSMAPINDEXLIST_OPTION_ACTIVE = 1,
};

enum {
	ADL_DISPLAY_BEZELOFFSET_STEPBYSTEPSET = (1 << 2),
	ADL_DISPLAY_BEZELOFFSET_COMMIT        = (1 << 3),
};

#endif /* ADL_DEFINES_H_ */
