#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cigerv2d(ConTxt, m, n, A, lda, rsrc, csrc)
int  ConTxt;
int  m;
int  n;
int  *A;
int  lda;
int  rsrc;
int  csrc;
#else
void igerv2d_(ConTxt, m, n, A, lda, rsrc, csrc)
int  *ConTxt;
int  *m;
int  *n;
int  *A;
int  *lda;
int  *rsrc;
int  *csrc;
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Locally-blocking point to point general integer receive.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to integer two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *
 *  RSRC    (input) Ptr to int
 *          The process row of the source of the matrix.
 *
 *  CSRC    (input) Ptr to int
 *          The process column of the source of the matrix.
 *
 *
 * ------------------------------------------------------------------------
 */
{
/*
 *  Prototypes and variable declarations
 */
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
   void iunpack00();
   void Srecv2dID();
   int tlda;
   BLACSCONTEXT *ctxt;

   MGetConTxt(Mpval(ConTxt), ctxt);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_RV, __FILE__, 'a', 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rsrc), Mpaddress(csrc));
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);
/*
 *  Receive the message.
 */
   Srecv2dID(ctxt, Mpval(rsrc), Mpval(csrc));
/*
 *  Unpack the buffer
 */
   iunpack00(Mpval(m), Mpval(n), (int *) A, tlda);
}
