//  Copyright (c) 2014 Anton Bikineev
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
   static const boost::array<boost::array<typename table_type<T>::type, 3>, 962> bessel_k_prime_int_data = {{
      {{ SC_(0.0), SC_(0.177219114266335964202880859375e-2), SC_(-564.26705890503944938767579913547914444248945617307) }}, 
      {{ SC_(0.0), SC_(0.22177286446094512939453125e-2), SC_(-450.90433365191537768820321413950713211111795723233) }}, 
      {{ SC_(0.0), SC_(0.7444499991834163665771484375e-2), SC_(-134.30682303430738211464350075539051302297649874874) }}, 
      {{ SC_(0.0), SC_(0.1433600485324859619140625e-1), SC_(-69.719596604788772780420388449105221075106674775932) }}, 
      {{ SC_(0.0), SC_(0.1760916970670223236083984375e-1), SC_(-56.747605077911761494847928942485415394515672427591) }}, 
      {{ SC_(0.0), SC_(0.6152711808681488037109375e-1), SC_(-16.148209870467353928313803586039211298833357390533) }}, 
      {{ SC_(0.0), SC_(0.11958599090576171875e0), SC_(-8.1979983109850254011244484732359277130188220912139) }}, 
      {{ SC_(0.0), SC_(0.15262925624847412109375e0), SC_(-6.3606452725304555965590517972251012830722624594999) }}, 
      {{ SC_(0.0), SC_(0.408089816570281982421875e0), SC_(-2.1321960830174616313341672168256801931362259279233) }}, 
      {{ SC_(0.0), SC_(0.6540834903717041015625e0), SC_(-1.1565762805442431109050120852982891923808991774078) }}, 
      {{ SC_(0.0), SC_(0.1097540378570556640625e1), SC_(-0.51180421118150678407111850473802395150979488737911) }}, 
      {{ SC_(0.0), SC_(0.30944411754608154296875e1), SC_(-0.035870846073100222567775139460938254201357238403855) }}, 
      {{ SC_(0.0), SC_(0.51139926910400390625e1), SC_(-0.0035634021394994144459276120940547504311283743308124) }}, 
      {{ SC_(0.0), SC_(0.95070552825927734375e1), SC_(-3.1367378117720984522644793879499313096092001772086e-05) }}, 
      {{ SC_(0.0), SC_(0.24750102996826171875e2), SC_(-4.5592142983856237448404334253399091132773842963972e-12) }}, 
      {{ SC_(0.0), SC_(0.637722015380859375e2), SC_(-3.1795308079040644509894337163510006422875797374616e-29) }}, 
      {{ SC_(0.0), SC_(0.1252804412841796875e3), SC_(-4.3833765076195517337404709329004854177992525949973e-56) }}, 
      {{ SC_(0.0), SC_(0.25554705810546875e3), SC_(-8.171153185119733731907215700781324087313196273862e-113) }}, 
      {{ SC_(0.0), SC_(0.503011474609375e3), SC_(-1.9610410514640769870616878418175098066922148164034e-220) }}, 
      {{ SC_(0.0), SC_(0.10074598388671875e4), SC_(-1.1544068163329804551680311089977817430745026305692e-439) }}, 
      {{ SC_(0.0), SC_(0.1185395751953125e4), SC_(-5.6290050931956485070753465854339963243045345223924e-517) }}, 
      {{ SC_(0.0), SC_(0.353451806640625e4), SC_(-2.0056192004130679476859275516857950580751539000044e-1537) }}, 
      {{ SC_(0.0), SC_(0.80715478515625e4), SC_(-5.1988746923438006571822452608036728315317688037626e-3508) }}, 
      {{ SC_(0.0), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2384200464655333806473812934794542968045682388646e-7051)) }}, 
      {{ SC_(0.0), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5865488666668272302158948598400493277484898536121e-13929)) }}, 
      {{ SC_(0.0), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6184312157757378250977280166736816786933907786721e-15797)) }}, 
      {{ SC_(0.1e1), SC_(0.177219114266335964202880859375e-2), SC_(-318407.24093988403283716622327788498668735878111682) }}, 
      {{ SC_(0.1e1), SC_(0.22177286446094512939453125e-2), SC_(-203324.30886650102282671546357187147244481049412212) }}, 
      {{ SC_(0.1e1), SC_(0.7444499991834163665771484375e-2), SC_(-18046.096713966837111926383334978114928772679560354) }}, 
      {{ SC_(0.1e1), SC_(0.1433600485324859619140625e-1), SC_(-4867.6126530474518428825812639081701032287340383263) }}, 
      {{ SC_(0.1e1), SC_(0.1760916970670223236083984375e-1), SC_(-3226.7724068746886393004717161425496197515372741622) }}, 
      {{ SC_(0.1e1), SC_(0.6152711808681488037109375e-1), SC_(-265.36469402952990171553286026164847301719062806564) }}, 
      {{ SC_(0.1e1), SC_(0.11958599090576171875e0), SC_(-70.804411666519349644733940672201002630982054503231) }}, 
      {{ SC_(0.1e1), SC_(0.15262925624847412109375e0), SC_(-43.686978561003354802613782475529249502661096099636) }}, 
      {{ SC_(0.1e1), SC_(0.408089816570281982421875e0), SC_(-6.3218910729050901313212384105168002574228931840538) }}, 
      {{ SC_(0.1e1), SC_(0.6540834903717041015625e0), SC_(-2.4793691355117662044189549199904574969327356790979) }}, 
      {{ SC_(0.1e1), SC_(0.1097540378570556640625e1), SC_(-0.83317797465061819621338302582157229034401798702659) }}, 
      {{ SC_(0.1e1), SC_(0.30944411754608154296875e1), SC_(-0.042745476010132948342285327125571022120438601647422) }}, 
      {{ SC_(0.1e1), SC_(0.51139926910400390625e1), SC_(-0.0039548539421187963785265657304810772112454837581585) }}, 
      {{ SC_(0.1e1), SC_(0.95070552825927734375e1), SC_(-3.3135131447398572033549046596185581695541095025294e-05) }}, 
      {{ SC_(0.1e1), SC_(0.24750102996826171875e2), SC_(-4.654003132120973910330382486129915942491142898761e-12) }}, 
      {{ SC_(0.1e1), SC_(0.637722015380859375e2), SC_(-3.2047482957012786078634776674341986362804068785944e-29) }}, 
      {{ SC_(0.1e1), SC_(0.1252804412841796875e3), SC_(-4.4009746680022794955892256279324092007537025223243e-56) }}, 
      {{ SC_(0.1e1), SC_(0.25554705810546875e3), SC_(-8.1871874944894166793340532995594900586832698000838e-113) }}, 
      {{ SC_(0.1e1), SC_(0.503011474609375e3), SC_(-1.9629932526598694364493932484617022901820787029041e-220) }}, 
      {{ SC_(0.1e1), SC_(0.10074598388671875e4), SC_(-1.1549801718723342286424505853964769853634059080364e-439) }}, 
      {{ SC_(0.1e1), SC_(0.1185395751953125e4), SC_(-5.631380908848274546758579410755282113144726314993e-517) }}, 
      {{ SC_(0.1e1), SC_(0.353451806640625e4), SC_(-2.005902979505538478295841832689903022639354889615e-1537) }}, 
      {{ SC_(0.1e1), SC_(0.80715478515625e4), SC_(-5.1991967716898108429971087826748985294137878820233e-3508) }}, 
      {{ SC_(0.1e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2385814421589235180320214001642941608513568636282e-7051)) }}, 
      {{ SC_(0.1e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5866203851644645722662401834106636705574505446343e-13929)) }}, 
      {{ SC_(0.1e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.618467215677702057808662836503017046047450093824e-15797)) }}, 
      {{ SC_(0.4e1), SC_(0.177219114266335964202880859375e-2), SC_(-10983692444317315.165150416008029081635418710640988) }}, 
      {{ SC_(0.4e1), SC_(0.22177286446094512939453125e-2), SC_(-3578978669139406.1528039756965024567835697596481499) }}, 
      {{ SC_(0.4e1), SC_(0.7444499991834163665771484375e-2), SC_(-8396969137152.9541908718514934906661629629077299591) }}, 
      {{ SC_(0.4e1), SC_(0.1433600485324859619140625e-1), SC_(-317071212176.20834010627371012509594276942337356133) }}, 
      {{ SC_(0.4e1), SC_(0.1760916970670223236083984375e-1), SC_(-113396910611.59301433770119413603766039771561556615) }}, 
      {{ SC_(0.4e1), SC_(0.6152711808681488037109375e-1), SC_(-217720766.28596624695438873986699104416207300227868) }}, 
      {{ SC_(0.4e1), SC_(0.11958599090576171875e0), SC_(-7845865.1155518293197347414850538849170357123663771) }}, 
      {{ SC_(0.4e1), SC_(0.15262925624847412109375e0), SC_(-2315743.9381627679323203266213045119362217382027192) }}, 
      {{ SC_(0.4e1), SC_(0.408089816570281982421875e0), SC_(-16846.07572065335815318267729024521441303537776785) }}, 
      {{ SC_(0.4e1), SC_(0.6540834903717041015625e0), SC_(-1575.1796557108295330492137708684645118520571226374) }}, 
      {{ SC_(0.4e1), SC_(0.1097540378570556640625e1), SC_(-114.54029008444287319775127760400796800548480811372) }}, 
      {{ SC_(0.4e1), SC_(0.30944411754608154296875e1), SC_(-0.44229971561233386817767514352350860962721823821973) }}, 
      {{ SC_(0.4e1), SC_(0.51139926910400390625e1), SC_(-0.017449058773107413749493685909981540439774532074338) }}, 
      {{ SC_(0.4e1), SC_(0.95070552825927734375e1), SC_(-7.4425873920361817017096070124335407936038112605473e-05) }}, 
      {{ SC_(0.4e1), SC_(0.24750102996826171875e2), SC_(-6.3323371984922724927107572682023510337870973837156e-12) }}, 
      {{ SC_(0.4e1), SC_(0.637722015380859375e2), SC_(-3.6077778435914884099043754328756871298273833085534e-29) }}, 
      {{ SC_(0.4e1), SC_(0.1252804412841796875e3), SC_(-4.6735619675626344223635967542390291638349188530899e-56) }}, 
      {{ SC_(0.4e1), SC_(0.25554705810546875e3), SC_(-8.4315075302797590390146509249854178682749834856253e-113) }}, 
      {{ SC_(0.4e1), SC_(0.503011474609375e3), SC_(-1.9925104081747598593357036700941687544447752690357e-220) }}, 
      {{ SC_(0.4e1), SC_(0.10074598388671875e4), SC_(-1.1636147448798338155700813766012832493011326011102e-439) }}, 
      {{ SC_(0.4e1), SC_(0.1185395751953125e4), SC_(-5.6671386771854849935328206881197785467035478991619e-517) }}, 
      {{ SC_(0.4e1), SC_(0.353451806640625e4), SC_(-2.0101644869168474643568944826109277299205560878898e-1537) }}, 
      {{ SC_(0.4e1), SC_(0.80715478515625e4), SC_(-5.2040303568785494878029900695452174102459710005928e-3508) }}, 
      {{ SC_(0.4e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2410029743453695294904082363058484365348132024276e-7051)) }}, 
      {{ SC_(0.4e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5876932964607492241095182648028442645972639968118e-13929)) }}, 
      {{ SC_(0.4e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6190072736044507830049193564957400063023573777032e-15797)) }}, 
      {{ SC_(0.7e1), SC_(0.177219114266335964202880859375e-2), SC_(-3315323993591126455859987019.5521097299329165631811) }}, 
      {{ SC_(0.7e1), SC_(0.22177286446094512939453125e-2), SC_(-551243141801203494936043640.13963587524905412197572) }}, 
      {{ SC_(0.7e1), SC_(0.7444499991834163665771484375e-2), SC_(-34192080230795750328765.530760999848176029597564373) }}, 
      {{ SC_(0.7e1), SC_(0.1433600485324859619140625e-1), SC_(-180793469547411428784.59219326366110191810523477698) }}, 
      {{ SC_(0.7e1), SC_(0.1760916970670223236083984375e-1), SC_(-34889558263749599681.031630304978099930857287106099) }}, 
      {{ SC_(0.7e1), SC_(0.6152711808681488037109375e-1), SC_(-1570467645142766.096606983479404590825289738785901) }}, 
      {{ SC_(0.7e1), SC_(0.11958599090576171875e0), SC_(-7708736743651.4500775221902568918844949153346520967) }}, 
      {{ SC_(0.7e1), SC_(0.15262925624847412109375e0), SC_(-1094478162897.0732521412106352041613956780865507252) }}, 
      {{ SC_(0.7e1), SC_(0.408089816570281982421875e0), SC_(-417264972.28653957754370884258958623298117914380298) }}, 
      {{ SC_(0.7e1), SC_(0.6540834903717041015625e0), SC_(-9506387.5451923690324201793109731315141860205388448) }}, 
      {{ SC_(0.7e1), SC_(0.1097540378570556640625e1), SC_(-147801.82349510813061065531542022914552685395560253) }}, 
      {{ SC_(0.7e1), SC_(0.30944411754608154296875e1), SC_(-28.887537147307173386155952903411642281062777832185) }}, 
      {{ SC_(0.7e1), SC_(0.51139926910400390625e1), SC_(-0.3211977551653224359819846920823669269394124086309) }}, 
      {{ SC_(0.7e1), SC_(0.95070552825927734375e1), SC_(-0.00040968554159001242446561600095020330283970668883094) }}, 
      {{ SC_(0.7e1), SC_(0.24750102996826171875e2), SC_(-1.2410081043497666839978215334633542599704721561071e-11) }}, 
      {{ SC_(0.7e1), SC_(0.637722015380859375e2), SC_(-4.680647212745947130532873058795184059401389424817e-29) }}, 
      {{ SC_(0.7e1), SC_(0.1252804412841796875e3), SC_(-5.3339778950073370002910256414986790129424582191839e-56) }}, 
      {{ SC_(0.7e1), SC_(0.25554705810546875e3), SC_(-8.9949465390038411715485285331256932311651702197894e-113) }}, 
      {{ SC_(0.7e1), SC_(0.503011474609375e3), SC_(-2.0590188106914723470971512345543109409703978159375e-220) }}, 
      {{ SC_(0.7e1), SC_(0.10074598388671875e4), SC_(-1.1828386303909201823209031002603556672438347405118e-439) }}, 
      {{ SC_(0.7e1), SC_(0.1185395751953125e4), SC_(-5.7466067939447929780878650300783597203934986672169e-517) }}, 
      {{ SC_(0.7e1), SC_(0.353451806640625e4), SC_(-2.0195716956097888490430340547500625033295625748797e-1537) }}, 
      {{ SC_(0.7e1), SC_(0.80715478515625e4), SC_(-5.214680067288115122908218261838621435999823160477e-3508) }}, 
      {{ SC_(0.7e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2463342859231349134036324059476964076492732625637e-7051)) }}, 
      {{ SC_(0.7e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.590054584826951403042828199794004714927867977358e-13929)) }}, 
      {{ SC_(0.7e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6201957931534244206403830282888034607321944639784e-15797)) }}, 
      {{ SC_(0.1e2), SC_(0.7444499991834163665771484375e-2), SC_(-477355122614691468111260858889880.58926726913455958) }}, 
      {{ SC_(0.1e2), SC_(0.1433600485324859619140625e-1), SC_(-353444703194792315374614508691.98554747933781047287) }}, 
      {{ SC_(0.1e2), SC_(0.1760916970670223236083984375e-1), SC_(-36804619552640744945858841591.304560823518892468403) }}, 
      {{ SC_(0.1e2), SC_(0.6152711808681488037109375e-1), SC_(-38838652403087978682641.711848010934898031011551029) }}, 
      {{ SC_(0.1e2), SC_(0.11958599090576171875e0), SC_(-25966391848547013887.975539235263628125888590214478) }}, 
      {{ SC_(0.1e2), SC_(0.15262925624847412109375e0), SC_(-1773342013046140336.1062244318926748285213369448988) }}, 
      {{ SC_(0.1e2), SC_(0.408089816570281982421875e0), SC_(-35408911289362.134703150868676724705163033296734387) }}, 
      {{ SC_(0.1e2), SC_(0.6540834903717041015625e0), SC_(-196308937624.0275735517611104717859529355678097762) }}, 
      {{ SC_(0.1e2), SC_(0.1097540378570556640625e1), SC_(-649816061.66550767822182413012756353208784820315824) }}, 
      {{ SC_(0.1e2), SC_(0.30944411754608154296875e1), SC_(-6036.3120015502460610464656620418329162540074430991) }}, 
      {{ SC_(0.1e2), SC_(0.51139926910400390625e1), SC_(-16.77105501440132662506256394602575401898929863048) }}, 
      {{ SC_(0.1e2), SC_(0.95070552825927734375e1), SC_(-0.0048920993505572960222402647401810804498324804265215) }}, 
      {{ SC_(0.1e2), SC_(0.24750102996826171875e2), SC_(-3.4689222049741036586790338104009980518135677358114e-11) }}, 
      {{ SC_(0.1e2), SC_(0.637722015380859375e2), SC_(-6.9941732925977905518953049214710822212998739942219e-29) }}, 
      {{ SC_(0.1e2), SC_(0.1252804412841796875e3), SC_(-6.5422186124251248496964517181857688013870791795035e-56) }}, 
      {{ SC_(0.1e2), SC_(0.25554705810546875e3), SC_(-9.9405609683986406553585077455704873743458935064821e-113) }}, 
      {{ SC_(0.1e2), SC_(0.503011474609375e3), SC_(-2.1661944754958489887879491888469702007883958539163e-220) }}, 
      {{ SC_(0.1e2), SC_(0.10074598388671875e4), SC_(-1.2131746224020067688796495659692520818309064206375e-439) }}, 
      {{ SC_(0.1e2), SC_(0.1185395751953125e4), SC_(-5.871617968780835883608085215749443424208719902646e-517) }}, 
      {{ SC_(0.1e2), SC_(0.353451806640625e4), SC_(-2.0341967672079613045483180534884678178084194432431e-1537) }}, 
      {{ SC_(0.1e2), SC_(0.80715478515625e4), SC_(-5.231181592239980221628729482174387337868421583968e-3508) }}, 
      {{ SC_(0.1e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2545842544614754760498290977177315036347968871034e-7051)) }}, 
      {{ SC_(0.1e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5937062394003284350480359970745605883730629890077e-13929)) }}, 
      {{ SC_(0.1e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6220336570536698526542996483154685205263505284311e-15797)) }}, 
      {{ SC_(0.13e2), SC_(0.6152711808681488037109375e-1), SC_(-2289176378976269396849287199275.4389217360542742894) }}, 
      {{ SC_(0.13e2), SC_(0.11958599090576171875e0), SC_(-208452203098761774660260463.71612961663756159436625) }}, 
      {{ SC_(0.13e2), SC_(0.15262925624847412109375e0), SC_(-6847513344878056238064052.7558950412749768843670892) }}, 
      {{ SC_(0.13e2), SC_(0.408089816570281982421875e0), SC_(-7157886034337033656.1374169337049971598861651888523) }}, 
      {{ SC_(0.13e2), SC_(0.6540834903717041015625e0), SC_(-9649414480722716.3378690088012327257197187937252838) }}, 
      {{ SC_(0.13e2), SC_(0.1097540378570556640625e1), SC_(-6784789248323.7827774790611589334412439974813174273) }}, 
      {{ SC_(0.13e2), SC_(0.30944411754608154296875e1), SC_(-2920918.6997297564902384838103332473508886033399507) }}, 
      {{ SC_(0.13e2), SC_(0.51139926910400390625e1), SC_(-1933.2995112558290568959967185372343783186245893615) }}, 
      {{ SC_(0.13e2), SC_(0.95070552825927734375e1), SC_(-0.11248945218182697577740974502870802741761402306663) }}, 
      {{ SC_(0.13e2), SC_(0.24750102996826171875e2), SC_(-1.3641508575326751063290338987256858903911721346514e-10) }}, 
      {{ SC_(0.13e2), SC_(0.637722015380859375e2), SC_(-1.2026575723671211714804900662543832960536265030518e-28) }}, 
      {{ SC_(0.13e2), SC_(0.1252804412841796875e3), SC_(-8.622199493068972640275007800895870357122826943754e-56) }}, 
      {{ SC_(0.13e2), SC_(0.25554705810546875e3), SC_(-1.137983912279632301235237161104302541876192841677e-112) }}, 
      {{ SC_(0.13e2), SC_(0.503011474609375e3), SC_(-2.3201240198527257131385551728108707136455226631626e-220) }}, 
      {{ SC_(0.13e2), SC_(0.10074598388671875e4), SC_(-1.2554591027874564909198311386870906858245269754536e-439) }}, 
      {{ SC_(0.13e2), SC_(0.1185395751953125e4), SC_(-6.0450891062543198166065999929065998757631089952653e-517) }}, 
      {{ SC_(0.13e2), SC_(0.353451806640625e4), SC_(-2.054152332548450846153475069585635268164968987823e-1537) }}, 
      {{ SC_(0.13e2), SC_(0.80715478515625e4), SC_(-5.2535903275059416269515540889871920526252350220644e-3508) }}, 
      {{ SC_(0.13e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2657666294517007664489042486592644105913848733088e-7051)) }}, 
      {{ SC_(0.13e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5986513376588069884606580095822410414790542700739e-13929)) }}, 
      {{ SC_(0.13e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6245222308361691290014816635810260153833522295116e-15797)) }}, 
      {{ SC_(0.16e2), SC_(0.15262925624847412109375e0), SC_(-51770170184935439768217724290971.719793026038290648) }}, 
      {{ SC_(0.16e2), SC_(0.408089816570281982421875e0), SC_(-2832480678214116605756831.7449874582847541311247443) }}, 
      {{ SC_(0.16e2), SC_(0.6540834903717041015625e0), SC_(-928102941328516043048.16750617601416985100854685514) }}, 
      {{ SC_(0.16e2), SC_(0.1097540378570556640625e1), SC_(-138450642498120894.01321470839811890478000161303469) }}, 
      {{ SC_(0.16e2), SC_(0.30944411754608154296875e1), SC_(-2727307047.6047405428895449491868575307587944877166) }}, 
      {{ SC_(0.16e2), SC_(0.51139926910400390625e1), SC_(-419811.51161832819548278091528591307492022860041498) }}, 
      {{ SC_(0.16e2), SC_(0.95070552825927734375e1), SC_(-4.5145079087894075362142346884772715470884425547862) }}, 
      {{ SC_(0.16e2), SC_(0.24750102996826171875e2), SC_(-7.4253383045245004704547347738213202327438062373064e-10) }}, 
      {{ SC_(0.16e2), SC_(0.637722015380859375e2), SC_(-2.3768829728903601357257158124087615937333701217617e-28) }}, 
      {{ SC_(0.16e2), SC_(0.1252804412841796875e3), SC_(-1.2208464308346300404866220271986862924488840787716e-55) }}, 
      {{ SC_(0.16e2), SC_(0.25554705810546875e3), SC_(-1.3494789878904930896463938535542930913110239121305e-112) }}, 
      {{ SC_(0.16e2), SC_(0.503011474609375e3), SC_(-2.5298834760159605088740100593772665710284338765039e-220) }}, 
      {{ SC_(0.16e2), SC_(0.10074598388671875e4), SC_(-1.3108805695414904078277919300536733662836112978456e-439) }}, 
      {{ SC_(0.16e2), SC_(0.1185395751953125e4), SC_(-6.2711349822379085411046315318530383624723503009108e-517) }}, 
      {{ SC_(0.16e2), SC_(0.353451806640625e4), SC_(-2.079592938410676985349322438432544037135155090438e-1537) }}, 
      {{ SC_(0.16e2), SC_(0.80715478515625e4), SC_(-5.2819816853499191215835769496268796765910344728379e-3508) }}, 
      {{ SC_(0.16e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2799000705051892189536330959734816657967634815435e-7051)) }}, 
      {{ SC_(0.16e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6048940497439807092359607184219908639753080495719e-13929)) }}, 
      {{ SC_(0.16e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6276633645249434284810260497120002514107459024021e-15797)) }}, 
      {{ SC_(0.19e2), SC_(0.408089816570281982421875e0), SC_(-1939191245963546262967600219571.6988547490991208774) }}, 
      {{ SC_(0.19e2), SC_(0.6540834903717041015625e0), SC_(-154405271556558266504987690.81583400210532760958734) }}, 
      {{ SC_(0.19e2), SC_(0.1097540378570556640625e1), SC_(-4883435242223023295837.2141660414750403899062522885) }}, 
      {{ SC_(0.19e2), SC_(0.30944411754608154296875e1), SC_(-4369647151816.5807407916737391513826955429591971981) }}, 
      {{ SC_(0.19e2), SC_(0.51139926910400390625e1), SC_(-154271802.15044536937154570552863502332927589281962) }}, 
      {{ SC_(0.19e2), SC_(0.95070552825927734375e1), SC_(-292.72602433857981818214869127467679628609884096022) }}, 
      {{ SC_(0.19e2), SC_(0.24750102996826171875e2), SC_(-5.4972860296716498914625412828731393657937621071928e-09) }}, 
      {{ SC_(0.19e2), SC_(0.637722015380859375e2), SC_(-5.3914173487808455012746223854154973854006572312627e-28) }}, 
      {{ SC_(0.19e2), SC_(0.1252804412841796875e3), SC_(-1.8568094909219880038810748483054639848313949823349e-55) }}, 
      {{ SC_(0.19e2), SC_(0.25554705810546875e3), SC_(-1.6576416571705167341276382465154646933308350225872e-112) }}, 
      {{ SC_(0.19e2), SC_(0.503011474609375e3), SC_(-2.8084329279366276933060699951851890788970561083712e-220) }}, 
      {{ SC_(0.19e2), SC_(0.10074598388671875e4), SC_(-1.3810354260465197285331071760287547374958871176663e-439) }}, 
      {{ SC_(0.19e2), SC_(0.1185395751953125e4), SC_(-6.5552312103388541840948796571082383546551174725329e-517) }}, 
      {{ SC_(0.19e2), SC_(0.353451806640625e4), SC_(-2.1107170437416726324359889333266703052777236402982e-1537) }}, 
      {{ SC_(0.19e2), SC_(0.80715478515625e4), SC_(-5.3164515176390581462857247493433713661896953337123e-3508) }}, 
      {{ SC_(0.19e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2970081992561116522665315159861214700282943164158e-7051)) }}, 
      {{ SC_(0.19e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6124396443226438494859896278693581722413406036281e-13929)) }}, 
      {{ SC_(0.19e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6314593949294223811755476125436142437905155860938e-15797)) }}, 
      {{ SC_(0.22e2), SC_(0.1097540378570556640625e1), SC_(-273567507990706498931971139.75282362042462887350463) }}, 
      {{ SC_(0.22e2), SC_(0.30944411754608154296875e1), SC_(-11068537556559422.496036482685168057091709479170705) }}, 
      {{ SC_(0.22e2), SC_(0.51139926910400390625e1), SC_(-88852664753.863442221238112146145667572032257984002) }}, 
      {{ SC_(0.22e2), SC_(0.95070552825927734375e1), SC_(-28866.968004731802160741807290825103521738562627877) }}, 
      {{ SC_(0.22e2), SC_(0.24750102996826171875e2), SC_(-5.4380379272592350152107961637699509536446929929665e-08) }}, 
      {{ SC_(0.22e2), SC_(0.637722015380859375e2), SC_(-1.4011736076661315545278714006244234460969211080796e-27) }}, 
      {{ SC_(0.22e2), SC_(0.1252804412841796875e3), SC_(-3.0327277070937567146058395530275538565313344122251e-55) }}, 
      {{ SC_(0.22e2), SC_(0.25554705810546875e3), SC_(-2.1091008699324159128483416950838430970090679044787e-112) }}, 
      {{ SC_(0.22e2), SC_(0.503011474609375e3), SC_(-3.1739508347189208310446567422939135318712810783592e-220) }}, 
      {{ SC_(0.22e2), SC_(0.10074598388671875e4), SC_(-1.4680047052926371802873980167523563854384176769562e-439) }}, 
      {{ SC_(0.22e2), SC_(0.1185395751953125e4), SC_(-6.9044355508865664897043139406055964426416997874159e-517) }}, 
      {{ SC_(0.22e2), SC_(0.353451806640625e4), SC_(-2.1477696015015210740350508446939009163788237281375e-1537) }}, 
      {{ SC_(0.22e2), SC_(0.80715478515625e4), SC_(-5.3571166553486953693609348836918508699371777331569e-3508) }}, 
      {{ SC_(0.22e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.3171196651710141760149001465312742337397514341269e-7051)) }}, 
      {{ SC_(0.22e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6212944959983963671978197048076565152784175046644e-13929)) }}, 
      {{ SC_(0.22e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.635913148542055714764458469524461642442283979926e-15797)) }}, 
      {{ SC_(0.25e2), SC_(0.30944411754608154296875e1), SC_(-41729098358824816367.531654303904514858752786596332) }}, 
      {{ SC_(0.25e2), SC_(0.51139926910400390625e1), SC_(-75724315461736.290472640765730196083672968985136938) }}, 
      {{ SC_(0.25e2), SC_(0.95070552825927734375e1), SC_(-4126624.249430058099093859743827049880078207173409) }}, 
      {{ SC_(0.25e2), SC_(0.24750102996826171875e2), SC_(-7.0643906010259470186673848613347677516199041790009e-07) }}, 
      {{ SC_(0.25e2), SC_(0.637722015380859375e2), SC_(-4.1643482972195352253468903896264828993995073276145e-27) }}, 
      {{ SC_(0.25e2), SC_(0.1252804412841796875e3), SC_(-5.3178886190804620477737626532158770815906964663127e-55) }}, 
      {{ SC_(0.25e2), SC_(0.25554705810546875e3), SC_(-2.7795327530969693291369188001213305521084456625436e-112) }}, 
      {{ SC_(0.25e2), SC_(0.503011474609375e3), SC_(-3.6518004666178007044186210479360824108573588622057e-220) }}, 
      {{ SC_(0.25e2), SC_(0.10074598388671875e4), SC_(-1.5744568976732275885992670337217796592504913121584e-439) }}, 
      {{ SC_(0.25e2), SC_(0.1185395751953125e4), SC_(-7.3276800998268647692604417584333403318008306406733e-517) }}, 
      {{ SC_(0.25e2), SC_(0.353451806640625e4), SC_(-2.1910452731818947586325883979465511464264539353135e-1537) }}, 
      {{ SC_(0.25e2), SC_(0.80715478515625e4), SC_(-5.4041155687137445586759532827860341286134457664739e-3508) }}, 
      {{ SC_(0.25e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.3402682255219835253427725149973742435369817524698e-7051)) }}, 
      {{ SC_(0.25e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6314660942879182904010929303912396455213934813636e-13929)) }}, 
      {{ SC_(0.25e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6410279450461977849642611156331880833233865462e-15797)) }}, 
      {{ SC_(0.28e2), SC_(0.30944411754608154296875e1), SC_(-223541481119546943565773.77238812949490661085705339) }}, 
      {{ SC_(0.28e2), SC_(0.51139926910400390625e1), SC_(-91328051744707544.652123318374534205924759494110627) }}, 
      {{ SC_(0.28e2), SC_(0.95070552825927734375e1), SC_(-822693275.5242087631582359380187569199057969266947) }}, 
      {{ SC_(0.28e2), SC_(0.24750102996826171875e2), SC_(-1.1854935611365514036505785383443316866729190727564e-05) }}, 
      {{ SC_(0.28e2), SC_(0.637722015380859375e2), SC_(-1.4124113665476923796445676488243428439766486148717e-26) }}, 
      {{ SC_(0.28e2), SC_(0.1252804412841796875e3), SC_(-1.0008037756307772952218495299728784823293653767184e-54) }}, 
      {{ SC_(0.28e2), SC_(0.25554705810546875e3), SC_(-3.7940015167787738318119650584499693396241466574168e-112) }}, 
      {{ SC_(0.28e2), SC_(0.503011474609375e3), SC_(-4.2774251594777351347198673166771658617522678943309e-220) }}, 
      {{ SC_(0.28e2), SC_(0.10074598388671875e4), SC_(-1.703783993941899631566185548014391220431437394766e-439) }}, 
      {{ SC_(0.28e2), SC_(0.1185395751953125e4), SC_(-7.8361512939747361305212762070103643170691014993883e-517) }}, 
      {{ SC_(0.28e2), SC_(0.353451806640625e4), SC_(-2.2408923350830720095143097122311787565315704403488e-1537) }}, 
      {{ SC_(0.28e2), SC_(0.80715478515625e4), SC_(-5.4576091532501692885292061883167808063027930434652e-3508) }}, 
      {{ SC_(0.28e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.3664928398359776281234804909442118061100108151808e-7051)) }}, 
      {{ SC_(0.28e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6429630541796104237749602570489257692109850962021e-13929)) }}, 
      {{ SC_(0.28e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.646807601440360378041044945401048496330886623631e-15797)) }}, 
      {{ SC_(0.31e2), SC_(0.30944411754608154296875e1), SC_(-1640236982737227798605513105.2881214516864645343434) }}, 
      {{ SC_(0.31e2), SC_(0.51139926910400390625e1), SC_(-150424707960029880305.45068169485722345223203510988) }}, 
      {{ SC_(0.31e2), SC_(0.95070552825927734375e1), SC_(-221590731975.24004453330307164730400609023437029559) }}, 
      {{ SC_(0.31e2), SC_(0.24750102996826171875e2), SC_(-0.00025306995657248261580226740957891309659224681774054) }}, 
      {{ SC_(0.31e2), SC_(0.637722015380859375e2), SC_(-5.4545776065765355727476521506594315116710188713781e-26) }}, 
      {{ SC_(0.31e2), SC_(0.1252804412841796875e3), SC_(-2.0207447059124495823522914705039373108318480947504e-54) }}, 
      {{ SC_(0.31e2), SC_(0.25554705810546875e3), SC_(-5.3635944812794373221435979845490523334605745757082e-112) }}, 
      {{ SC_(0.31e2), SC_(0.503011474609375e3), SC_(-5.1006307993575805863091265527664070588810247284445e-220) }}, 
      {{ SC_(0.31e2), SC_(0.10074598388671875e4), SC_(-1.8602804302571009850793812371180672711055310354359e-439) }}, 
      {{ SC_(0.31e2), SC_(0.1185395751953125e4), SC_(-8.4437803307009087901729105408645714828298735244045e-517) }}, 
      {{ SC_(0.31e2), SC_(0.353451806640625e4), SC_(-2.2977173488642354738881892443842860150149738523369e-1537) }}, 
      {{ SC_(0.31e2), SC_(0.80715478515625e4), SC_(-5.5177816478944763257972176637580727577052830273422e-3508) }}, 
      {{ SC_(0.31e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.3958377791903350631088933189075859744575429232595e-7051)) }}, 
      {{ SC_(0.31e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6557951282954426231640126213356050448139072138644e-13929)) }}, 
      {{ SC_(0.31e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6532564367860076196323499486018589342074947176568e-15797)) }}, 
      {{ SC_(0.34e2), SC_(0.51139926910400390625e1), SC_(-328678035141376004479093.02895716688943798989311409) }}, 
      {{ SC_(0.34e2), SC_(0.95070552825927734375e1), SC_(-78535569831698.020065027678249059741866901003361821) }}, 
      {{ SC_(0.34e2), SC_(0.24750102996826171875e2), SC_(-0.0067753238411528031951525513830459113313055439948589) }}, 
      {{ SC_(0.34e2), SC_(0.637722015380859375e2), SC_(-2.3928748300513971766068979044071342098142733664491e-25) }}, 
      {{ SC_(0.34e2), SC_(0.1252804412841796875e3), SC_(-4.3758379103735294610353452655731282838090916844577e-54) }}, 
      {{ SC_(0.34e2), SC_(0.25554705810546875e3), SC_(-7.8528364954696475566319427248735375479775152490362e-112) }}, 
      {{ SC_(0.34e2), SC_(0.503011474609375e3), SC_(-6.1919683563153717438286369297503338627087616975563e-220) }}, 
      {{ SC_(0.34e2), SC_(0.10074598388671875e4), SC_(-2.0493780828306995383518852372735975061025948664944e-439) }}, 
      {{ SC_(0.34e2), SC_(0.1185395751953125e4), SC_(-9.1678739875353997897519231873964323153980032565967e-517) }}, 
      {{ SC_(0.34e2), SC_(0.353451806640625e4), SC_(-2.3619906840424561820014346474726360414214577164765e-1537) }}, 
      {{ SC_(0.34e2), SC_(0.80715478515625e4), SC_(-5.5848416925972983371675307232265311162794956946164e-3508) }}, 
      {{ SC_(0.34e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.4283527507837718978871014447929518480577262702653e-7051)) }}, 
      {{ SC_(0.34e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6699732206800479061156813026343140156858111388875e-13929)) }}, 
      {{ SC_(0.34e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6603792775871613150958050960274229979112419957377e-15797)) }}, 
      {{ SC_(0.37e2), SC_(0.51139926910400390625e1), SC_(-929997097734757375914108536.91194181930238365891591) }}, 
      {{ SC_(0.37e2), SC_(0.95070552825927734375e1), SC_(-35818326839692910.232572072179156799711596268212725) }}, 
      {{ SC_(0.37e2), SC_(0.24750102996826171875e2), SC_(-0.22454475758844790783476687462532063012911745094225) }}, 
      {{ SC_(0.37e2), SC_(0.637722015380859375e2), SC_(-1.1895138610350592293727496258471892916551533162382e-24) }}, 
      {{ SC_(0.37e2), SC_(0.1252804412841796875e3), SC_(-1.015825180778943325378031057870706354278400016343e-53) }}, 
      {{ SC_(0.37e2), SC_(0.25554705810546875e3), SC_(-1.1906574134604491062178884977162193791160863889135e-111) }}, 
      {{ SC_(0.37e2), SC_(0.503011474609375e3), SC_(-7.6523344761349789515020431325546579744433304404247e-220) }}, 
      {{ SC_(0.37e2), SC_(0.10074598388671875e4), SC_(-2.2779551571517289191980410236280566265385395792574e-439) }}, 
      {{ SC_(0.37e2), SC_(0.1185395751953125e4), SC_(-1.0029925564582425213168108803987022721864611042488e-516) }}, 
      {{ SC_(0.37e2), SC_(0.353451806640625e4), SC_(-2.4342529973922420366574119310564969136809379938833e-1537) }}, 
      {{ SC_(0.37e2), SC_(0.80715478515625e4), SC_(-5.6590235338706442214697901076209156525030221963817e-3508) }}, 
      {{ SC_(0.37e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.4640930382736375883740917300324268280790516937591e-7051)) }}, 
      {{ SC_(0.37e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6855094022443588008576096608994048582227672193389e-13929)) }}, 
      {{ SC_(0.37e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6681814638111980522212240684691129179478201750845e-15797)) }}, 
      {{ SC_(0.4e2), SC_(0.51139926910400390625e1), SC_(-3338963200983143316808420230598.7422406937148868183) }}, 
      {{ SC_(0.4e2), SC_(0.95070552825927734375e1), SC_(-20625534091856759325.153248910820431574800918064066) }}, 
      {{ SC_(0.4e2), SC_(0.24750102996826171875e2), SC_(-9.1028088358418251680234816506659814561972328165202) }}, 
      {{ SC_(0.4e2), SC_(0.637722015380859375e2), SC_(-6.6836118347027771842091390905922896944789906198879e-24) }}, 
      {{ SC_(0.4e2), SC_(0.1252804412841796875e3), SC_(-2.5269255948292334070520278151115302162637776825505e-53) }}, 
      {{ SC_(0.4e2), SC_(0.25554705810546875e3), SC_(-1.8694429917428252226241506811131591248449772900623e-111) }}, 
      {{ SC_(0.4e2), SC_(0.503011474609375e3), SC_(-9.6275608457728276341680839156418369724029596452446e-220) }}, 
      {{ SC_(0.4e2), SC_(0.10074598388671875e4), SC_(-2.554743244448886972203980564016447807064474698151e-439) }}, 
      {{ SC_(0.4e2), SC_(0.1185395751953125e4), SC_(-1.1056658608826093680394497615344879503318731249082e-516) }}, 
      {{ SC_(0.4e2), SC_(0.353451806640625e4), SC_(-2.5151227940369883011098800558323175513058778154582e-1537) }}, 
      {{ SC_(0.4e2), SC_(0.80715478515625e4), SC_(-5.7405883880397339633815351417370007119421688235109e-3508) }}, 
      {{ SC_(0.4e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.5031196584341509495456350289667555127248812793141e-7051)) }}, 
      {{ SC_(0.4e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.7024169278944099483784991544653853693793666308474e-13929)) }}, 
      {{ SC_(0.4e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6766688555613534380265612383537440220361698452617e-15797)) }}, 
      {{ SC_(0.43e2), SC_(0.95070552825927734375e1), SC_(-14751470981781795117342.206559243263921600191401087) }}, 
      {{ SC_(0.43e2), SC_(0.24750102996826171875e2), SC_(-446.4891806253159523882574363612812235063651249585) }}, 
      {{ SC_(0.43e2), SC_(0.637722015380859375e2), SC_(-4.233763666839872384105458954598432131993398426424e-23) }}, 
      {{ SC_(0.43e2), SC_(0.1252804412841796875e3), SC_(-6.7325145575430846585913103554917629582161317284093e-53) }}, 
      {{ SC_(0.43e2), SC_(0.25554705810546875e3), SC_(-3.0393193136330068311064186789994907170477541436742e-111) }}, 
      {{ SC_(0.43e2), SC_(0.503011474609375e3), SC_(-1.2330826146776709270895628560382305428782566679454e-219) }}, 
      {{ SC_(0.43e2), SC_(0.10074598388671875e4), SC_(-2.8908656732737407085369043325253772506966386036777e-439) }}, 
      {{ SC_(0.43e2), SC_(0.1185395751953125e4), SC_(-1.228137337659943886994500950345142111874164409792e-516) }}, 
      {{ SC_(0.43e2), SC_(0.353451806640625e4), SC_(-2.6053052179496807854002052846934046858863225713023e-1537) }}, 
      {{ SC_(0.43e2), SC_(0.80715478515625e4), SC_(-5.8298259733030657922737308980843341607932632090959e-3508) }}, 
      {{ SC_(0.43e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.5454995347571058373140661485359338188390382342065e-7051)) }}, 
      {{ SC_(0.43e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.7207102553793366648911501018898244135468776654792e-13929)) }}, 
      {{ SC_(0.43e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6858478404126064957826967503455732509170372752387e-15797)) }}, 
      {{ SC_(0.46e2), SC_(0.95070552825927734375e1), SC_(-12917663347203686143836143.910805742895581704655586) }}, 
      {{ SC_(0.46e2), SC_(0.24750102996826171875e2), SC_(-26235.057710202278650539924850662186008741433512393) }}, 
      {{ SC_(0.46e2), SC_(0.637722015380859375e2), SC_(-3.0156867854089343237058938921516747812188476263389e-22) }}, 
      {{ SC_(0.46e2), SC_(0.1252804412841796875e3), SC_(-1.9202503812985560131703463254740169819405710994174e-52) }}, 
      {{ SC_(0.46e2), SC_(0.25554705810546875e3), SC_(-5.1162385357259218814379585073336770260558101085837e-111) }}, 
      {{ SC_(0.46e2), SC_(0.503011474609375e3), SC_(-1.6077475093930052657164489721995166598423341235489e-219) }}, 
      {{ SC_(0.46e2), SC_(0.10074598388671875e4), SC_(-3.3005525584724455924638535580342688289649145504404e-439) }}, 
      {{ SC_(0.46e2), SC_(0.1185395751953125e4), SC_(-1.3745689249476539405584614575190967881455015120684e-516) }}, 
      {{ SC_(0.46e2), SC_(0.353451806640625e4), SC_(-2.7056022462095521839411435730865310104730331173963e-1537) }}, 
      {{ SC_(0.46e2), SC_(0.80715478515625e4), SC_(-5.927056223173338451095346393985816542039985357571e-3508) }}, 
      {{ SC_(0.46e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.591305688686474794775130781662039882343320309422e-7051)) }}, 
      {{ SC_(0.46e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.7404050658960917907025134665504351612320771593753e-13929)) }}, 
      {{ SC_(0.46e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6957253414238011594678945835534568876412319193364e-15797)) }}, 
      {{ SC_(0.49e2), SC_(0.95070552825927734375e1), SC_(-13677119048020081769637857664.004679755744731957881) }}, 
      {{ SC_(0.49e2), SC_(0.24750102996826171875e2), SC_(-1829919.8337911038500181616492167542226106316593553) }}, 
      {{ SC_(0.49e2), SC_(0.637722015380859375e2), SC_(-2.4091155491341019251051477476213134709801586915375e-21) }}, 
      {{ SC_(0.49e2), SC_(0.1252804412841796875e3), SC_(-5.8601406376694995179250459524941405890984488660674e-52) }}, 
      {{ SC_(0.49e2), SC_(0.25554705810546875e3), SC_(-8.9167249449039720144703319084878032545363029340332e-111) }}, 
      {{ SC_(0.49e2), SC_(0.503011474609375e3), SC_(-2.1339744180391502000629280946419467146701524975424e-219) }}, 
      {{ SC_(0.49e2), SC_(0.10074598388671875e4), SC_(-3.8020950617098093543830635326665989348871235898462e-439) }}, 
      {{ SC_(0.49e2), SC_(0.1185395751953125e4), SC_(-1.5501807755899059080053982360752652725485301431675e-516) }}, 
      {{ SC_(0.49e2), SC_(0.353451806640625e4), SC_(-2.8169244924241460164438048123312445224362447071592e-1537) }}, 
      {{ SC_(0.49e2), SC_(0.80715478515625e4), SC_(-6.0326311954734093692278078699231482140946616761111e-3508) }}, 
      {{ SC_(0.49e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.6406174492518179553474257829835162835218380431621e-7051)) }}, 
      {{ SC_(0.49e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.7615182864919918135529022171048378859158392609952e-13929)) }}, 
      {{ SC_(0.49e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7063088258400746858178205556822115360901063089561e-15797)) }}, 
      {{ SC_(0.52e2), SC_(0.24750102996826171875e2), SC_(-150258349.48298965521429912649566332286572127204838) }}, 
      {{ SC_(0.52e2), SC_(0.637722015380859375e2), SC_(-2.1528420937982545309308124336084241462033188006075e-20) }}, 
      {{ SC_(0.52e2), SC_(0.1252804412841796875e3), SC_(-1.9124591299228762415276179510248192934684406939518e-51) }}, 
      {{ SC_(0.52e2), SC_(0.25554705810546875e3), SC_(-1.6088221227173773682509376149516801543260419158969e-110) }}, 
      {{ SC_(0.52e2), SC_(0.503011474609375e3), SC_(-2.8833802628518198753473420283435726540577353906032e-219) }}, 
      {{ SC_(0.52e2), SC_(0.10074598388671875e4), SC_(-4.4191253669027448430900956857887401202794330219532e-439) }}, 
      {{ SC_(0.52e2), SC_(0.1185395751953125e4), SC_(-1.7615463549207955715477300287834826367597256193556e-516) }}, 
      {{ SC_(0.52e2), SC_(0.353451806640625e4), SC_(-2.9403048610899170278392449864767842502890156215295e-1537) }}, 
      {{ SC_(0.52e2), SC_(0.80715478515625e4), SC_(-6.1469371928136573174899609668997058828924829672256e-3508) }}, 
      {{ SC_(0.52e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.6935206819428165591414953780241913938460794989048e-7051)) }}, 
      {{ SC_(0.52e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.784068114309897377446872510391181263746902485707e-13929)) }}, 
      {{ SC_(0.52e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7176063145009074540843639989335150961054395784331e-15797)) }}, 
      {{ SC_(0.55e2), SC_(0.24750102996826171875e2), SC_(-14413830415.043505622498237272304806634999080892398) }}, 
      {{ SC_(0.55e2), SC_(0.637722015380859375e2), SC_(-2.1464996996211206379833011948578327129626522316385e-19) }}, 
      {{ SC_(0.55e2), SC_(0.1252804412841796875e3), SC_(-6.6706142582159264121826823735445847276926891746691e-51) }}, 
      {{ SC_(0.55e2), SC_(0.25554705810546875e3), SC_(-3.004864584083453767723846822808713021733203118935e-110) }}, 
      {{ SC_(0.55e2), SC_(0.503011474609375e3), SC_(-3.9659877945884680536425554912980359884903202119623e-219) }}, 
      {{ SC_(0.55e2), SC_(0.10074598388671875e4), SC_(-5.1823426897188153001977915991297817970825407128731e-439) }}, 
      {{ SC_(0.55e2), SC_(0.1185395751953125e4), SC_(-2.016978896175023430703409277539108978367915911435e-516) }}, 
      {{ SC_(0.55e2), SC_(0.353451806640625e4), SC_(-3.0769143373632447110150563681035216189281522248719e-1537) }}, 
      {{ SC_(0.55e2), SC_(0.80715478515625e4), SC_(-6.2703971123999375125348312453069325185560504412597e-3508) }}, 
      {{ SC_(0.55e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.75010803774901283903544699700514766973488614337e-7051)) }}, 
      {{ SC_(0.55e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.808074042724642620167603612982730342429817871781e-13929)) }}, 
      {{ SC_(0.55e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7296263919703879232822407374814832664034636285938e-15797)) }}, 
      {{ SC_(0.58e2), SC_(0.24750102996826171875e2), SC_(-1603989324781.8613059589905098516400380552351596402) }}, 
      {{ SC_(0.58e2), SC_(0.637722015380859375e2), SC_(-2.3818199749807331061229379575504067327287212253734e-18) }}, 
      {{ SC_(0.58e2), SC_(0.1252804412841796875e3), SC_(-2.4852880984664790259110929628592264740680082063308e-50) }}, 
      {{ SC_(0.58e2), SC_(0.25554705810546875e3), SC_(-5.8092541451213583956214309790743040583347170105081e-110) }}, 
      {{ SC_(0.58e2), SC_(0.503011474609375e3), SC_(-5.5530641469438098153130349964319974095484016307095e-219) }}, 
      {{ SC_(0.58e2), SC_(0.10074598388671875e4), SC_(-6.1318535699122284348981617184105940457283225600075e-439) }}, 
      {{ SC_(0.58e2), SC_(0.1185395751953125e4), SC_(-2.3270397644903488747163583768764173678891352307339e-516) }}, 
      {{ SC_(0.58e2), SC_(0.353451806640625e4), SC_(-3.2280802469837084965584387996562996780057017166825e-1537) }}, 
      {{ SC_(0.58e2), SC_(0.80715478515625e4), SC_(-6.4034730451370018782740799734261468642567623641441e-3508) }}, 
      {{ SC_(0.58e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.8104792233753955355520282491947186123211010733431e-7051)) }}, 
      {{ SC_(0.58e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.8335568894232624343928408965025590678904601171011e-13929)) }}, 
      {{ SC_(0.58e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7423782174076034446389751732896351531311932177183e-15797)) }}, 
      {{ SC_(0.61e2), SC_(0.24750102996826171875e2), SC_(-205727990081990.5374214365803780584578675993561475) }}, 
      {{ SC_(0.61e2), SC_(0.637722015380859375e2), SC_(-2.9339998139627598638617329174552107215335862557709e-17) }}, 
      {{ SC_(0.61e2), SC_(0.1252804412841796875e3), SC_(-9.8847467781508994744717116173140904534335446352474e-50) }}, 
      {{ SC_(0.61e2), SC_(0.25554705810546875e3), SC_(-1.1624040153131934523520628245907386761375266054618e-109) }}, 
      {{ SC_(0.61e2), SC_(0.503011474609375e3), SC_(-7.9148143857148512750388962850545995108452710985144e-219) }}, 
      {{ SC_(0.61e2), SC_(0.10074598388671875e4), SC_(-7.3203630041953160939492553010522208138676250836544e-439) }}, 
      {{ SC_(0.61e2), SC_(0.1185395751953125e4), SC_(-2.7052102850120518653475252679675849458822285695168e-516) }}, 
      {{ SC_(0.61e2), SC_(0.353451806640625e4), SC_(-3.3953073804137612575423594258488461994743817713619e-1537) }}, 
      {{ SC_(0.61e2), SC_(0.80715478515625e4), SC_(-6.5466691463255843703828399656160397128105071410256e-3508) }}, 
      {{ SC_(0.61e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.8747412937362980710179754497998945385053913457506e-7051)) }}, 
      {{ SC_(0.61e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.8605388264856372237761800655715974006277741967001e-13929)) }}, 
      {{ SC_(0.61e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7558715361964252660069781536302351685807597625494e-15797)) }}, 
      {{ SC_(0.64e2), SC_(0.24750102996826171875e2), SC_(-30231557057292254.806826756836766232605862434079551) }}, 
      {{ SC_(0.64e2), SC_(0.637722015380859375e2), SC_(-4.0023885413168133146932069839198259075638739349785e-16) }}, 
      {{ SC_(0.64e2), SC_(0.1252804412841796875e3), SC_(-4.1943691089859731371373998397631983520432183278204e-49) }}, 
      {{ SC_(0.64e2), SC_(0.25554705810546875e3), SC_(-2.4071106589627185535873189544045677480372059884021e-109) }}, 
      {{ SC_(0.64e2), SC_(0.503011474609375e3), SC_(-1.1483389777474423005276705035363976319777945180197e-218) }}, 
      {{ SC_(0.64e2), SC_(0.10074598388671875e4), SC_(-8.8175508716798784642146182686013328481454828391758e-439) }}, 
      {{ SC_(0.64e2), SC_(0.1185395751953125e4), SC_(-3.1687838197836708380681044049701013199356389866298e-516) }}, 
      {{ SC_(0.64e2), SC_(0.353451806640625e4), SC_(-3.5803024454118403953932606699232935376435375864878e-1537) }}, 
      {{ SC_(0.64e2), SC_(0.80715478515625e4), SC_(-6.7005348028299924018018129895663115571157374041883e-3508) }}, 
      {{ SC_(0.64e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.9430089679276831935524603511515246469368335713528e-7051)) }}, 
      {{ SC_(0.64e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.8890434125263919607223046975257449165530939107103e-13929)) }}, 
      {{ SC_(0.64e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7701166923553576110729712559776270189707146594402e-15797)) }}, 
      {{ SC_(0.67e2), SC_(0.24750102996826171875e2), SC_(-5061777992457529851.7390091992143260326465507151343) }}, 
      {{ SC_(0.67e2), SC_(0.637722015380859375e2), SC_(-6.0317754176643425166044924813756167778331513629679e-15) }}, 
      {{ SC_(0.67e2), SC_(0.1252804412841796875e3), SC_(-1.8976187232997037166756563939493260804940923981923e-48) }}, 
      {{ SC_(0.67e2), SC_(0.25554705810546875e3), SC_(-5.1581809985088706413298769160254172046729928087796e-109) }}, 
      {{ SC_(0.67e2), SC_(0.503011474609375e3), SC_(-1.6959582073755216495099635587291329763194962697345e-218) }}, 
      {{ SC_(0.67e2), SC_(0.10074598388671875e4), SC_(-1.0716109184246349104842215983323268048553186074599e-438) }}, 
      {{ SC_(0.67e2), SC_(0.1185395751953125e4), SC_(-3.7400560529623726351030640662230470531974478937127e-516) }}, 
      {{ SC_(0.67e2), SC_(0.353451806640625e4), SC_(-3.7850023953787082536234091066973152288769647770207e-1537) }}, 
      {{ SC_(0.67e2), SC_(0.80715478515625e4), SC_(-6.8656681244479627373328136425871372353743336555496e-3508) }}, 
      {{ SC_(0.67e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.0154049699818194298414516919926570919397056061135e-7051)) }}, 
      {{ SC_(0.67e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.9190956269632617459294020571954725871539532297759e-13929)) }}, 
      {{ SC_(0.67e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7851246417495694875076256540067519504234091978718e-15797)) }}, 
      {{ SC_(0.7e2), SC_(0.24750102996826171875e2), SC_(-960719766377563642547.84784436439965607261717936572) }}, 
      {{ SC_(0.7e2), SC_(0.637722015380859375e2), SC_(-1.0018948309853140553793839732399474374038521342822e-13) }}, 
      {{ SC_(0.7e2), SC_(0.1252804412841796875e3), SC_(-9.1478005129071685822585014801797604042121991775186e-48) }}, 
      {{ SC_(0.7e2), SC_(0.25554705810546875e3), SC_(-1.1437112875547581040508453224386896980882218243944e-108) }}, 
      {{ SC_(0.7e2), SC_(0.503011474609375e3), SC_(-2.5495875855024647038175630884222826135491275025261e-218) }}, 
      {{ SC_(0.7e2), SC_(0.10074598388671875e4), SC_(-1.3140120163828277000968506238809976026387713024023e-438) }}, 
      {{ SC_(0.7e2), SC_(0.1185395751953125e4), SC_(-4.4479210253708017953989477643322660025768603401623e-516) }}, 
      {{ SC_(0.7e2), SC_(0.353451806640625e4), SC_(-4.011607279487438869633191688770704873886231134706e-1537) }}, 
      {{ SC_(0.7e2), SC_(0.80715478515625e4), SC_(-7.042719790380435288707526346406999737819404508234e-3508) }}, 
      {{ SC_(0.7e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.0920603958191974077351373685096064096349419355278e-7051)) }}, 
      {{ SC_(0.7e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.9507219064816815225818933615045945030757314244068e-13929)) }}, 
      {{ SC_(0.7e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8009069661287273247872110387701501847750932342624e-15797)) }}, 
      {{ SC_(0.73e2), SC_(0.24750102996826171875e2), SC_(-205719376526896502657652.96550991890838816063791109) }}, 
      {{ SC_(0.73e2), SC_(0.637722015380859375e2), SC_(-1.8300431219071119872880395867409742102142917730265e-12) }}, 
      {{ SC_(0.73e2), SC_(0.1252804412841796875e3), SC_(-4.6958048660578828796346820899034077665825783934045e-47) }}, 
      {{ SC_(0.73e2), SC_(0.25554705810546875e3), SC_(-2.6236852703230463989159054674929686721177502367006e-108) }}, 
      {{ SC_(0.73e2), SC_(0.503011474609375e3), SC_(-3.9014702654874034106876012771696386159778136815961e-218) }}, 
      {{ SC_(0.73e2), SC_(0.10074598388671875e4), SC_(-1.6256753185931080016278217071058734206460353005272e-438) }}, 
      {{ SC_(0.73e2), SC_(0.1185395751953125e4), SC_(-5.3300219828181147858062787897171456179634070597516e-516) }}, 
      {{ SC_(0.73e2), SC_(0.353451806640625e4), SC_(-4.2626183779380336824380883140647108026451658293156e-1537) }}, 
      {{ SC_(0.73e2), SC_(0.80715478515625e4), SC_(-7.2323972852147199789443100363498297809281819979803e-3508) }}, 
      {{ SC_(0.73e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.1731151079309191917184639095298319465383713817986e-7051)) }}, 
      {{ SC_(0.73e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.9839501837700855537119137483951258337511595368787e-13929)) }}, 
      {{ SC_(0.73e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.817475888015800256208872261271522867678161060716e-15797)) }}, 
      {{ SC_(0.76e2), SC_(0.24750102996826171875e2), SC_(-49478353255850169884934069.299878417564058220806436) }}, 
      {{ SC_(0.76e2), SC_(0.637722015380859375e2), SC_(-3.6677657057343833378790228611478009054081670021689e-11) }}, 
      {{ SC_(0.76e2), SC_(0.1252804412841796875e3), SC_(-2.565109608997742743110499398388763645670177075402e-46) }}, 
      {{ SC_(0.76e2), SC_(0.25554705810546875e3), SC_(-6.2264033726422710289672726231798445145431543554852e-108) }}, 
      {{ SC_(0.76e2), SC_(0.503011474609375e3), SC_(-6.0769241217951763607655077687262098816000800412697e-218) }}, 
      {{ SC_(0.76e2), SC_(0.10074598388671875e4), SC_(-2.0292695565475860494513194802911931028995921345127e-438) }}, 
      {{ SC_(0.76e2), SC_(0.1185395751953125e4), SC_(-6.4356646706199133752004959764845941040720194537884e-516) }}, 
      {{ SC_(0.76e2), SC_(0.353451806640625e4), SC_(-4.5408825254310089726335939548022782201008737968778e-1537) }}, 
      {{ SC_(0.76e2), SC_(0.80715478515625e4), SC_(-7.4354695627440530875708592525605793700698293761757e-3508) }}, 
      {{ SC_(0.76e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.2587181594514014603747134114494582948715924210721e-7051)) }}, 
      {{ SC_(0.76e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.0188099286053257564330261352245750063020523517253e-13929)) }}, 
      {{ SC_(0.76e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8348442864736215848869024786087057360126591539601e-15797)) }}, 
      {{ SC_(0.79e2), SC_(0.24750102996826171875e2), SC_(-13311377801888047309231869120.542790729005902613362) }}, 
      {{ SC_(0.79e2), SC_(0.637722015380859375e2), SC_(-8.0484077746939564571976121590206071184506511322372e-10) }}, 
      {{ SC_(0.79e2), SC_(0.1252804412841796875e3), SC_(-1.4901108972501235761543315633801893534378820456469e-45) }}, 
      {{ SC_(0.79e2), SC_(0.25554705810546875e3), SC_(-1.5284322081202891503901188222847649345982863995208e-107) }}, 
      {{ SC_(0.79e2), SC_(0.503011474609375e3), SC_(-9.6345135340008718538715982389228126878365004083811e-218) }}, 
      {{ SC_(0.79e2), SC_(0.10074598388671875e4), SC_(-2.5557376477668938366873901370154979501643660675242e-438) }}, 
      {{ SC_(0.79e2), SC_(0.1185395751953125e4), SC_(-7.8297837190005907655601672044981753284470473812561e-516) }}, 
      {{ SC_(0.79e2), SC_(0.353451806640625e4), SC_(-4.8496436926873884286440646192513168255119073983292e-1537) }}, 
      {{ SC_(0.79e2), SC_(0.80715478515625e4), SC_(-7.6527721802990117462670607408793544234827815552886e-3508) }}, 
      {{ SC_(0.79e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.3490282494167977009540233126435006038243581853711e-7051)) }}, 
      {{ SC_(0.79e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.0553321913727506552657665860597886292201998202501e-13929)) }}, 
      {{ SC_(0.79e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8530257137776636178810078824677341688051566573746e-15797)) }}, 
      {{ SC_(0.82e2), SC_(0.637722015380859375e2), SC_(-1.929664940040155693529466887952144814051447724959e-08) }}, 
      {{ SC_(0.82e2), SC_(0.1252804412841796875e3), SC_(-9.1994155998441512754636871834721249790632784175968e-45) }}, 
      {{ SC_(0.82e2), SC_(0.25554705810546875e3), SC_(-3.880523666220452737290266931254477983415313628438e-107) }}, 
      {{ SC_(0.82e2), SC_(0.503011474609375e3), SC_(-1.554745475514337721891632426144897014927362503757e-217) }}, 
      {{ SC_(0.82e2), SC_(0.10074598388671875e4), SC_(-3.2475999045999570181747261157749673369391101595774e-438) }}, 
      {{ SC_(0.82e2), SC_(0.1185395751953125e4), SC_(-9.5983710027436750265702531274004702246767579076882e-516) }}, 
      {{ SC_(0.82e2), SC_(0.353451806640625e4), SC_(-5.1926030950825285600618345570808515093818563886244e-1537) }}, 
      {{ SC_(0.82e2), SC_(0.80715478515625e4), SC_(-7.8852129511171532286208132853871491236357544988575e-3508) }}, 
      {{ SC_(0.82e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.4442142111498586191463295549950995161009635632053e-7051)) }}, 
      {{ SC_(0.82e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.0935496491108428955283035163133522638143765212297e-13929)) }}, 
      {{ SC_(0.82e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8720344130252226985727735707660611379569218277457e-15797)) }}, 
      {{ SC_(0.85e2), SC_(0.637722015380859375e2), SC_(-5.0447671615505518655123386164414515050269005768116e-07) }}, 
      {{ SC_(0.85e2), SC_(0.1252804412841796875e3), SC_(-6.0317262234008813937658078553988664012097242138782e-44) }}, 
      {{ SC_(0.85e2), SC_(0.25554705810546875e3), SC_(-1.0188732720454341381521059175302890088207242434688e-106) }}, 
      {{ SC_(0.85e2), SC_(0.503011474609375e3), SC_(-2.5536722931770409635190252307901838371333480641471e-217) }}, 
      {{ SC_(0.85e2), SC_(0.10074598388671875e4), SC_(-4.163682178034477865419644212672881655736983426055e-438) }}, 
      {{ SC_(0.85e2), SC_(0.1185395751953125e4), SC_(-1.1855944110337321358335194728357090546728991002798e-515) }}, 
      {{ SC_(0.85e2), SC_(0.353451806640625e4), SC_(-5.5739893359223912155589799460065075879733445391168e-1537) }}, 
      {{ SC_(0.85e2), SC_(0.80715478515625e4), SC_(-8.1337781676891146043172626859523144985078784468345e-3508) }}, 
      {{ SC_(0.85e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.5444555358678712478142893859896373579504424808833e-7051)) }}, 
      {{ SC_(0.85e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.1334966541759079954152078015386003001774040007563e-13929)) }}, 
      {{ SC_(0.85e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8918853367130211844771714641301138255390766751725e-15797)) }}, 
      {{ SC_(0.88e2), SC_(0.637722015380859375e2), SC_(-1.4352892326685192269933720541462535626083742663234e-05) }}, 
      {{ SC_(0.88e2), SC_(0.1252804412841796875e3), SC_(-4.1973246650065949973709196550419958201971684895847e-43) }}, 
      {{ SC_(0.88e2), SC_(0.25554705810546875e3), SC_(-2.7662078787178059924505957855573511486147491827993e-106) }}, 
      {{ SC_(0.88e2), SC_(0.503011474609375e3), SC_(-4.2691356322860956850905553978678973095694357478875e-217) }}, 
      {{ SC_(0.88e2), SC_(0.10074598388671875e4), SC_(-5.3859271482409235484034083878540429529372064477554e-438) }}, 
      {{ SC_(0.88e2), SC_(0.1185395751953125e4), SC_(-1.4755876549974846772926302013801419869024203613031e-515) }}, 
      {{ SC_(0.88e2), SC_(0.353451806640625e4), SC_(-5.9986403777420733686664189021548382857880737324782e-1537) }}, 
      {{ SC_(0.88e2), SC_(0.80715478515625e4), SC_(-8.3995394550628292156517670639450923693412327537556e-3508) }}, 
      {{ SC_(0.88e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.6499429337777740527854112012152307484800747131988e-7051)) }}, 
      {{ SC_(0.88e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.1752092856281561337229432353326859580022400449271e-13929)) }}, 
      {{ SC_(0.88e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.91259416631711777510013561133401775712156938498e-15797)) }},
      {{ SC_(-0.0), SC_(0.177219114266335964202880859375e-2), SC_(-564.26705890503944938767579913547914444248945617307) }}, 
      {{ SC_(-0.0), SC_(0.22177286446094512939453125e-2), SC_(-450.90433365191537768820321413950713211111795723233) }}, 
      {{ SC_(-0.0), SC_(0.7444499991834163665771484375e-2), SC_(-134.30682303430738211464350075539051302297649874874) }}, 
      {{ SC_(-0.0), SC_(0.1433600485324859619140625e-1), SC_(-69.719596604788772780420388449105221075106674775932) }}, 
      {{ SC_(-0.0), SC_(0.1760916970670223236083984375e-1), SC_(-56.747605077911761494847928942485415394515672427591) }}, 
      {{ SC_(-0.0), SC_(0.6152711808681488037109375e-1), SC_(-16.148209870467353928313803586039211298833357390533) }}, 
      {{ SC_(-0.0), SC_(0.11958599090576171875e0), SC_(-8.1979983109850254011244484732359277130188220912139) }}, 
      {{ SC_(-0.0), SC_(0.15262925624847412109375e0), SC_(-6.3606452725304555965590517972251012830722624594999) }}, 
      {{ SC_(-0.0), SC_(0.408089816570281982421875e0), SC_(-2.1321960830174616313341672168256801931362259279233) }}, 
      {{ SC_(-0.0), SC_(0.6540834903717041015625e0), SC_(-1.1565762805442431109050120852982891923808991774078) }}, 
      {{ SC_(-0.0), SC_(0.1097540378570556640625e1), SC_(-0.51180421118150678407111850473802395150979488737911) }}, 
      {{ SC_(-0.0), SC_(0.30944411754608154296875e1), SC_(-0.035870846073100222567775139460938254201357238403855) }}, 
      {{ SC_(-0.0), SC_(0.51139926910400390625e1), SC_(-0.0035634021394994144459276120940547504311283743308124) }}, 
      {{ SC_(-0.0), SC_(0.95070552825927734375e1), SC_(-3.1367378117720984522644793879499313096092001772086e-05) }}, 
      {{ SC_(-0.0), SC_(0.24750102996826171875e2), SC_(-4.5592142983856237448404334253399091132773842963972e-12) }}, 
      {{ SC_(-0.0), SC_(0.637722015380859375e2), SC_(-3.1795308079040644509894337163510006422875797374616e-29) }}, 
      {{ SC_(-0.0), SC_(0.1252804412841796875e3), SC_(-4.3833765076195517337404709329004854177992525949973e-56) }}, 
      {{ SC_(-0.0), SC_(0.25554705810546875e3), SC_(-8.171153185119733731907215700781324087313196273862e-113) }}, 
      {{ SC_(-0.0), SC_(0.503011474609375e3), SC_(-1.9610410514640769870616878418175098066922148164034e-220) }}, 
      {{ SC_(-0.0), SC_(0.10074598388671875e4), SC_(-1.1544068163329804551680311089977817430745026305692e-439) }}, 
      {{ SC_(-0.0), SC_(0.1185395751953125e4), SC_(-5.6290050931956485070753465854339963243045345223924e-517) }}, 
      {{ SC_(-0.0), SC_(0.353451806640625e4), SC_(-2.0056192004130679476859275516857950580751539000044e-1537) }}, 
      {{ SC_(-0.0), SC_(0.80715478515625e4), SC_(-5.1988746923438006571822452608036728315317688037626e-3508) }}, 
      {{ SC_(-0.0), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2384200464655333806473812934794542968045682388646e-7051)) }}, 
      {{ SC_(-0.0), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5865488666668272302158948598400493277484898536121e-13929)) }}, 
      {{ SC_(-0.0), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6184312157757378250977280166736816786933907786721e-15797)) }}, 
      {{ SC_(-0.1e1), SC_(0.177219114266335964202880859375e-2), SC_(-318407.24093988403283716622327788498668735878111682) }}, 
      {{ SC_(-0.1e1), SC_(0.22177286446094512939453125e-2), SC_(-203324.30886650102282671546357187147244481049412212) }}, 
      {{ SC_(-0.1e1), SC_(0.7444499991834163665771484375e-2), SC_(-18046.096713966837111926383334978114928772679560354) }}, 
      {{ SC_(-0.1e1), SC_(0.1433600485324859619140625e-1), SC_(-4867.6126530474518428825812639081701032287340383263) }}, 
      {{ SC_(-0.1e1), SC_(0.1760916970670223236083984375e-1), SC_(-3226.7724068746886393004717161425496197515372741622) }}, 
      {{ SC_(-0.1e1), SC_(0.6152711808681488037109375e-1), SC_(-265.36469402952990171553286026164847301719062806564) }}, 
      {{ SC_(-0.1e1), SC_(0.11958599090576171875e0), SC_(-70.804411666519349644733940672201002630982054503231) }}, 
      {{ SC_(-0.1e1), SC_(0.15262925624847412109375e0), SC_(-43.686978561003354802613782475529249502661096099636) }}, 
      {{ SC_(-0.1e1), SC_(0.408089816570281982421875e0), SC_(-6.3218910729050901313212384105168002574228931840538) }}, 
      {{ SC_(-0.1e1), SC_(0.6540834903717041015625e0), SC_(-2.4793691355117662044189549199904574969327356790979) }}, 
      {{ SC_(-0.1e1), SC_(0.1097540378570556640625e1), SC_(-0.83317797465061819621338302582157229034401798702659) }}, 
      {{ SC_(-0.1e1), SC_(0.30944411754608154296875e1), SC_(-0.042745476010132948342285327125571022120438601647422) }}, 
      {{ SC_(-0.1e1), SC_(0.51139926910400390625e1), SC_(-0.0039548539421187963785265657304810772112454837581585) }}, 
      {{ SC_(-0.1e1), SC_(0.95070552825927734375e1), SC_(-3.3135131447398572033549046596185581695541095025294e-05) }}, 
      {{ SC_(-0.1e1), SC_(0.24750102996826171875e2), SC_(-4.654003132120973910330382486129915942491142898761e-12) }}, 
      {{ SC_(-0.1e1), SC_(0.637722015380859375e2), SC_(-3.2047482957012786078634776674341986362804068785944e-29) }}, 
      {{ SC_(-0.1e1), SC_(0.1252804412841796875e3), SC_(-4.4009746680022794955892256279324092007537025223243e-56) }}, 
      {{ SC_(-0.1e1), SC_(0.25554705810546875e3), SC_(-8.1871874944894166793340532995594900586832698000838e-113) }}, 
      {{ SC_(-0.1e1), SC_(0.503011474609375e3), SC_(-1.9629932526598694364493932484617022901820787029041e-220) }}, 
      {{ SC_(-0.1e1), SC_(0.10074598388671875e4), SC_(-1.1549801718723342286424505853964769853634059080364e-439) }}, 
      {{ SC_(-0.1e1), SC_(0.1185395751953125e4), SC_(-5.631380908848274546758579410755282113144726314993e-517) }}, 
      {{ SC_(-0.1e1), SC_(0.353451806640625e4), SC_(-2.005902979505538478295841832689903022639354889615e-1537) }}, 
      {{ SC_(-0.1e1), SC_(0.80715478515625e4), SC_(-5.1991967716898108429971087826748985294137878820233e-3508) }}, 
      {{ SC_(-0.1e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2385814421589235180320214001642941608513568636282e-7051)) }}, 
      {{ SC_(-0.1e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5866203851644645722662401834106636705574505446343e-13929)) }}, 
      {{ SC_(-0.1e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.618467215677702057808662836503017046047450093824e-15797)) }}, 
      {{ SC_(-0.4e1), SC_(0.177219114266335964202880859375e-2), SC_(-10983692444317315.165150416008029081635418710640988) }}, 
      {{ SC_(-0.4e1), SC_(0.22177286446094512939453125e-2), SC_(-3578978669139406.1528039756965024567835697596481499) }}, 
      {{ SC_(-0.4e1), SC_(0.7444499991834163665771484375e-2), SC_(-8396969137152.9541908718514934906661629629077299591) }}, 
      {{ SC_(-0.4e1), SC_(0.1433600485324859619140625e-1), SC_(-317071212176.20834010627371012509594276942337356133) }}, 
      {{ SC_(-0.4e1), SC_(0.1760916970670223236083984375e-1), SC_(-113396910611.59301433770119413603766039771561556615) }}, 
      {{ SC_(-0.4e1), SC_(0.6152711808681488037109375e-1), SC_(-217720766.28596624695438873986699104416207300227868) }}, 
      {{ SC_(-0.4e1), SC_(0.11958599090576171875e0), SC_(-7845865.1155518293197347414850538849170357123663771) }}, 
      {{ SC_(-0.4e1), SC_(0.15262925624847412109375e0), SC_(-2315743.9381627679323203266213045119362217382027192) }}, 
      {{ SC_(-0.4e1), SC_(0.408089816570281982421875e0), SC_(-16846.07572065335815318267729024521441303537776785) }}, 
      {{ SC_(-0.4e1), SC_(0.6540834903717041015625e0), SC_(-1575.1796557108295330492137708684645118520571226374) }}, 
      {{ SC_(-0.4e1), SC_(0.1097540378570556640625e1), SC_(-114.54029008444287319775127760400796800548480811372) }}, 
      {{ SC_(-0.4e1), SC_(0.30944411754608154296875e1), SC_(-0.44229971561233386817767514352350860962721823821973) }}, 
      {{ SC_(-0.4e1), SC_(0.51139926910400390625e1), SC_(-0.017449058773107413749493685909981540439774532074338) }}, 
      {{ SC_(-0.4e1), SC_(0.95070552825927734375e1), SC_(-7.4425873920361817017096070124335407936038112605473e-05) }}, 
      {{ SC_(-0.4e1), SC_(0.24750102996826171875e2), SC_(-6.3323371984922724927107572682023510337870973837156e-12) }}, 
      {{ SC_(-0.4e1), SC_(0.637722015380859375e2), SC_(-3.6077778435914884099043754328756871298273833085534e-29) }}, 
      {{ SC_(-0.4e1), SC_(0.1252804412841796875e3), SC_(-4.6735619675626344223635967542390291638349188530899e-56) }}, 
      {{ SC_(-0.4e1), SC_(0.25554705810546875e3), SC_(-8.4315075302797590390146509249854178682749834856253e-113) }}, 
      {{ SC_(-0.4e1), SC_(0.503011474609375e3), SC_(-1.9925104081747598593357036700941687544447752690357e-220) }}, 
      {{ SC_(-0.4e1), SC_(0.10074598388671875e4), SC_(-1.1636147448798338155700813766012832493011326011102e-439) }}, 
      {{ SC_(-0.4e1), SC_(0.1185395751953125e4), SC_(-5.6671386771854849935328206881197785467035478991619e-517) }}, 
      {{ SC_(-0.4e1), SC_(0.353451806640625e4), SC_(-2.0101644869168474643568944826109277299205560878898e-1537) }}, 
      {{ SC_(-0.4e1), SC_(0.80715478515625e4), SC_(-5.2040303568785494878029900695452174102459710005928e-3508) }}, 
      {{ SC_(-0.4e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2410029743453695294904082363058484365348132024276e-7051)) }}, 
      {{ SC_(-0.4e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5876932964607492241095182648028442645972639968118e-13929)) }}, 
      {{ SC_(-0.4e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6190072736044507830049193564957400063023573777032e-15797)) }}, 
      {{ SC_(-0.7e1), SC_(0.177219114266335964202880859375e-2), SC_(-3315323993591126455859987019.5521097299329165631811) }}, 
      {{ SC_(-0.7e1), SC_(0.22177286446094512939453125e-2), SC_(-551243141801203494936043640.13963587524905412197572) }}, 
      {{ SC_(-0.7e1), SC_(0.7444499991834163665771484375e-2), SC_(-34192080230795750328765.530760999848176029597564373) }}, 
      {{ SC_(-0.7e1), SC_(0.1433600485324859619140625e-1), SC_(-180793469547411428784.59219326366110191810523477698) }}, 
      {{ SC_(-0.7e1), SC_(0.1760916970670223236083984375e-1), SC_(-34889558263749599681.031630304978099930857287106099) }}, 
      {{ SC_(-0.7e1), SC_(0.6152711808681488037109375e-1), SC_(-1570467645142766.096606983479404590825289738785901) }}, 
      {{ SC_(-0.7e1), SC_(0.11958599090576171875e0), SC_(-7708736743651.4500775221902568918844949153346520967) }}, 
      {{ SC_(-0.7e1), SC_(0.15262925624847412109375e0), SC_(-1094478162897.0732521412106352041613956780865507252) }}, 
      {{ SC_(-0.7e1), SC_(0.408089816570281982421875e0), SC_(-417264972.28653957754370884258958623298117914380298) }}, 
      {{ SC_(-0.7e1), SC_(0.6540834903717041015625e0), SC_(-9506387.5451923690324201793109731315141860205388448) }}, 
      {{ SC_(-0.7e1), SC_(0.1097540378570556640625e1), SC_(-147801.82349510813061065531542022914552685395560253) }}, 
      {{ SC_(-0.7e1), SC_(0.30944411754608154296875e1), SC_(-28.887537147307173386155952903411642281062777832185) }}, 
      {{ SC_(-0.7e1), SC_(0.51139926910400390625e1), SC_(-0.3211977551653224359819846920823669269394124086309) }}, 
      {{ SC_(-0.7e1), SC_(0.95070552825927734375e1), SC_(-0.00040968554159001242446561600095020330283970668883094) }}, 
      {{ SC_(-0.7e1), SC_(0.24750102996826171875e2), SC_(-1.2410081043497666839978215334633542599704721561071e-11) }}, 
      {{ SC_(-0.7e1), SC_(0.637722015380859375e2), SC_(-4.680647212745947130532873058795184059401389424817e-29) }}, 
      {{ SC_(-0.7e1), SC_(0.1252804412841796875e3), SC_(-5.3339778950073370002910256414986790129424582191839e-56) }}, 
      {{ SC_(-0.7e1), SC_(0.25554705810546875e3), SC_(-8.9949465390038411715485285331256932311651702197894e-113) }}, 
      {{ SC_(-0.7e1), SC_(0.503011474609375e3), SC_(-2.0590188106914723470971512345543109409703978159375e-220) }}, 
      {{ SC_(-0.7e1), SC_(0.10074598388671875e4), SC_(-1.1828386303909201823209031002603556672438347405118e-439) }}, 
      {{ SC_(-0.7e1), SC_(0.1185395751953125e4), SC_(-5.7466067939447929780878650300783597203934986672169e-517) }}, 
      {{ SC_(-0.7e1), SC_(0.353451806640625e4), SC_(-2.0195716956097888490430340547500625033295625748797e-1537) }}, 
      {{ SC_(-0.7e1), SC_(0.80715478515625e4), SC_(-5.214680067288115122908218261838621435999823160477e-3508) }}, 
      {{ SC_(-0.7e1), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2463342859231349134036324059476964076492732625637e-7051)) }}, 
      {{ SC_(-0.7e1), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.590054584826951403042828199794004714927867977358e-13929)) }}, 
      {{ SC_(-0.7e1), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6201957931534244206403830282888034607321944639784e-15797)) }}, 
      {{ SC_(-0.1e2), SC_(0.7444499991834163665771484375e-2), SC_(-477355122614691468111260858889880.58926726913455958) }}, 
      {{ SC_(-0.1e2), SC_(0.1433600485324859619140625e-1), SC_(-353444703194792315374614508691.98554747933781047287) }}, 
      {{ SC_(-0.1e2), SC_(0.1760916970670223236083984375e-1), SC_(-36804619552640744945858841591.304560823518892468403) }}, 
      {{ SC_(-0.1e2), SC_(0.6152711808681488037109375e-1), SC_(-38838652403087978682641.711848010934898031011551029) }}, 
      {{ SC_(-0.1e2), SC_(0.11958599090576171875e0), SC_(-25966391848547013887.975539235263628125888590214478) }}, 
      {{ SC_(-0.1e2), SC_(0.15262925624847412109375e0), SC_(-1773342013046140336.1062244318926748285213369448988) }}, 
      {{ SC_(-0.1e2), SC_(0.408089816570281982421875e0), SC_(-35408911289362.134703150868676724705163033296734387) }}, 
      {{ SC_(-0.1e2), SC_(0.6540834903717041015625e0), SC_(-196308937624.0275735517611104717859529355678097762) }}, 
      {{ SC_(-0.1e2), SC_(0.1097540378570556640625e1), SC_(-649816061.66550767822182413012756353208784820315824) }}, 
      {{ SC_(-0.1e2), SC_(0.30944411754608154296875e1), SC_(-6036.3120015502460610464656620418329162540074430991) }}, 
      {{ SC_(-0.1e2), SC_(0.51139926910400390625e1), SC_(-16.77105501440132662506256394602575401898929863048) }}, 
      {{ SC_(-0.1e2), SC_(0.95070552825927734375e1), SC_(-0.0048920993505572960222402647401810804498324804265215) }}, 
      {{ SC_(-0.1e2), SC_(0.24750102996826171875e2), SC_(-3.4689222049741036586790338104009980518135677358114e-11) }}, 
      {{ SC_(-0.1e2), SC_(0.637722015380859375e2), SC_(-6.9941732925977905518953049214710822212998739942219e-29) }}, 
      {{ SC_(-0.1e2), SC_(0.1252804412841796875e3), SC_(-6.5422186124251248496964517181857688013870791795035e-56) }}, 
      {{ SC_(-0.1e2), SC_(0.25554705810546875e3), SC_(-9.9405609683986406553585077455704873743458935064821e-113) }}, 
      {{ SC_(-0.1e2), SC_(0.503011474609375e3), SC_(-2.1661944754958489887879491888469702007883958539163e-220) }}, 
      {{ SC_(-0.1e2), SC_(0.10074598388671875e4), SC_(-1.2131746224020067688796495659692520818309064206375e-439) }}, 
      {{ SC_(-0.1e2), SC_(0.1185395751953125e4), SC_(-5.871617968780835883608085215749443424208719902646e-517) }}, 
      {{ SC_(-0.1e2), SC_(0.353451806640625e4), SC_(-2.0341967672079613045483180534884678178084194432431e-1537) }}, 
      {{ SC_(-0.1e2), SC_(0.80715478515625e4), SC_(-5.231181592239980221628729482174387337868421583968e-3508) }}, 
      {{ SC_(-0.1e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2545842544614754760498290977177315036347968871034e-7051)) }}, 
      {{ SC_(-0.1e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5937062394003284350480359970745605883730629890077e-13929)) }}, 
      {{ SC_(-0.1e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6220336570536698526542996483154685205263505284311e-15797)) }}, 
      {{ SC_(-0.13e2), SC_(0.6152711808681488037109375e-1), SC_(-2289176378976269396849287199275.4389217360542742894) }}, 
      {{ SC_(-0.13e2), SC_(0.11958599090576171875e0), SC_(-208452203098761774660260463.71612961663756159436625) }}, 
      {{ SC_(-0.13e2), SC_(0.15262925624847412109375e0), SC_(-6847513344878056238064052.7558950412749768843670892) }}, 
      {{ SC_(-0.13e2), SC_(0.408089816570281982421875e0), SC_(-7157886034337033656.1374169337049971598861651888523) }}, 
      {{ SC_(-0.13e2), SC_(0.6540834903717041015625e0), SC_(-9649414480722716.3378690088012327257197187937252838) }}, 
      {{ SC_(-0.13e2), SC_(0.1097540378570556640625e1), SC_(-6784789248323.7827774790611589334412439974813174273) }}, 
      {{ SC_(-0.13e2), SC_(0.30944411754608154296875e1), SC_(-2920918.6997297564902384838103332473508886033399507) }}, 
      {{ SC_(-0.13e2), SC_(0.51139926910400390625e1), SC_(-1933.2995112558290568959967185372343783186245893615) }}, 
      {{ SC_(-0.13e2), SC_(0.95070552825927734375e1), SC_(-0.11248945218182697577740974502870802741761402306663) }}, 
      {{ SC_(-0.13e2), SC_(0.24750102996826171875e2), SC_(-1.3641508575326751063290338987256858903911721346514e-10) }}, 
      {{ SC_(-0.13e2), SC_(0.637722015380859375e2), SC_(-1.2026575723671211714804900662543832960536265030518e-28) }}, 
      {{ SC_(-0.13e2), SC_(0.1252804412841796875e3), SC_(-8.622199493068972640275007800895870357122826943754e-56) }}, 
      {{ SC_(-0.13e2), SC_(0.25554705810546875e3), SC_(-1.137983912279632301235237161104302541876192841677e-112) }}, 
      {{ SC_(-0.13e2), SC_(0.503011474609375e3), SC_(-2.3201240198527257131385551728108707136455226631626e-220) }}, 
      {{ SC_(-0.13e2), SC_(0.10074598388671875e4), SC_(-1.2554591027874564909198311386870906858245269754536e-439) }}, 
      {{ SC_(-0.13e2), SC_(0.1185395751953125e4), SC_(-6.0450891062543198166065999929065998757631089952653e-517) }}, 
      {{ SC_(-0.13e2), SC_(0.353451806640625e4), SC_(-2.054152332548450846153475069585635268164968987823e-1537) }}, 
      {{ SC_(-0.13e2), SC_(0.80715478515625e4), SC_(-5.2535903275059416269515540889871920526252350220644e-3508) }}, 
      {{ SC_(-0.13e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2657666294517007664489042486592644105913848733088e-7051)) }}, 
      {{ SC_(-0.13e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.5986513376588069884606580095822410414790542700739e-13929)) }}, 
      {{ SC_(-0.13e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6245222308361691290014816635810260153833522295116e-15797)) }}, 
      {{ SC_(-0.16e2), SC_(0.15262925624847412109375e0), SC_(-51770170184935439768217724290971.719793026038290648) }}, 
      {{ SC_(-0.16e2), SC_(0.408089816570281982421875e0), SC_(-2832480678214116605756831.7449874582847541311247443) }}, 
      {{ SC_(-0.16e2), SC_(0.6540834903717041015625e0), SC_(-928102941328516043048.16750617601416985100854685514) }}, 
      {{ SC_(-0.16e2), SC_(0.1097540378570556640625e1), SC_(-138450642498120894.01321470839811890478000161303469) }}, 
      {{ SC_(-0.16e2), SC_(0.30944411754608154296875e1), SC_(-2727307047.6047405428895449491868575307587944877166) }}, 
      {{ SC_(-0.16e2), SC_(0.51139926910400390625e1), SC_(-419811.51161832819548278091528591307492022860041498) }}, 
      {{ SC_(-0.16e2), SC_(0.95070552825927734375e1), SC_(-4.5145079087894075362142346884772715470884425547862) }}, 
      {{ SC_(-0.16e2), SC_(0.24750102996826171875e2), SC_(-7.4253383045245004704547347738213202327438062373064e-10) }}, 
      {{ SC_(-0.16e2), SC_(0.637722015380859375e2), SC_(-2.3768829728903601357257158124087615937333701217617e-28) }}, 
      {{ SC_(-0.16e2), SC_(0.1252804412841796875e3), SC_(-1.2208464308346300404866220271986862924488840787716e-55) }}, 
      {{ SC_(-0.16e2), SC_(0.25554705810546875e3), SC_(-1.3494789878904930896463938535542930913110239121305e-112) }}, 
      {{ SC_(-0.16e2), SC_(0.503011474609375e3), SC_(-2.5298834760159605088740100593772665710284338765039e-220) }}, 
      {{ SC_(-0.16e2), SC_(0.10074598388671875e4), SC_(-1.3108805695414904078277919300536733662836112978456e-439) }}, 
      {{ SC_(-0.16e2), SC_(0.1185395751953125e4), SC_(-6.2711349822379085411046315318530383624723503009108e-517) }}, 
      {{ SC_(-0.16e2), SC_(0.353451806640625e4), SC_(-2.079592938410676985349322438432544037135155090438e-1537) }}, 
      {{ SC_(-0.16e2), SC_(0.80715478515625e4), SC_(-5.2819816853499191215835769496268796765910344728379e-3508) }}, 
      {{ SC_(-0.16e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2799000705051892189536330959734816657967634815435e-7051)) }}, 
      {{ SC_(-0.16e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6048940497439807092359607184219908639753080495719e-13929)) }}, 
      {{ SC_(-0.16e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6276633645249434284810260497120002514107459024021e-15797)) }}, 
      {{ SC_(-0.19e2), SC_(0.408089816570281982421875e0), SC_(-1939191245963546262967600219571.6988547490991208774) }}, 
      {{ SC_(-0.19e2), SC_(0.6540834903717041015625e0), SC_(-154405271556558266504987690.81583400210532760958734) }}, 
      {{ SC_(-0.19e2), SC_(0.1097540378570556640625e1), SC_(-4883435242223023295837.2141660414750403899062522885) }}, 
      {{ SC_(-0.19e2), SC_(0.30944411754608154296875e1), SC_(-4369647151816.5807407916737391513826955429591971981) }}, 
      {{ SC_(-0.19e2), SC_(0.51139926910400390625e1), SC_(-154271802.15044536937154570552863502332927589281962) }}, 
      {{ SC_(-0.19e2), SC_(0.95070552825927734375e1), SC_(-292.72602433857981818214869127467679628609884096022) }}, 
      {{ SC_(-0.19e2), SC_(0.24750102996826171875e2), SC_(-5.4972860296716498914625412828731393657937621071928e-09) }}, 
      {{ SC_(-0.19e2), SC_(0.637722015380859375e2), SC_(-5.3914173487808455012746223854154973854006572312627e-28) }}, 
      {{ SC_(-0.19e2), SC_(0.1252804412841796875e3), SC_(-1.8568094909219880038810748483054639848313949823349e-55) }}, 
      {{ SC_(-0.19e2), SC_(0.25554705810546875e3), SC_(-1.6576416571705167341276382465154646933308350225872e-112) }}, 
      {{ SC_(-0.19e2), SC_(0.503011474609375e3), SC_(-2.8084329279366276933060699951851890788970561083712e-220) }}, 
      {{ SC_(-0.19e2), SC_(0.10074598388671875e4), SC_(-1.3810354260465197285331071760287547374958871176663e-439) }}, 
      {{ SC_(-0.19e2), SC_(0.1185395751953125e4), SC_(-6.5552312103388541840948796571082383546551174725329e-517) }}, 
      {{ SC_(-0.19e2), SC_(0.353451806640625e4), SC_(-2.1107170437416726324359889333266703052777236402982e-1537) }}, 
      {{ SC_(-0.19e2), SC_(0.80715478515625e4), SC_(-5.3164515176390581462857247493433713661896953337123e-3508) }}, 
      {{ SC_(-0.19e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.2970081992561116522665315159861214700282943164158e-7051)) }}, 
      {{ SC_(-0.19e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6124396443226438494859896278693581722413406036281e-13929)) }}, 
      {{ SC_(-0.19e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6314593949294223811755476125436142437905155860938e-15797)) }}, 
      {{ SC_(-0.22e2), SC_(0.1097540378570556640625e1), SC_(-273567507990706498931971139.75282362042462887350463) }}, 
      {{ SC_(-0.22e2), SC_(0.30944411754608154296875e1), SC_(-11068537556559422.496036482685168057091709479170705) }}, 
      {{ SC_(-0.22e2), SC_(0.51139926910400390625e1), SC_(-88852664753.863442221238112146145667572032257984002) }}, 
      {{ SC_(-0.22e2), SC_(0.95070552825927734375e1), SC_(-28866.968004731802160741807290825103521738562627877) }}, 
      {{ SC_(-0.22e2), SC_(0.24750102996826171875e2), SC_(-5.4380379272592350152107961637699509536446929929665e-08) }}, 
      {{ SC_(-0.22e2), SC_(0.637722015380859375e2), SC_(-1.4011736076661315545278714006244234460969211080796e-27) }}, 
      {{ SC_(-0.22e2), SC_(0.1252804412841796875e3), SC_(-3.0327277070937567146058395530275538565313344122251e-55) }}, 
      {{ SC_(-0.22e2), SC_(0.25554705810546875e3), SC_(-2.1091008699324159128483416950838430970090679044787e-112) }}, 
      {{ SC_(-0.22e2), SC_(0.503011474609375e3), SC_(-3.1739508347189208310446567422939135318712810783592e-220) }}, 
      {{ SC_(-0.22e2), SC_(0.10074598388671875e4), SC_(-1.4680047052926371802873980167523563854384176769562e-439) }}, 
      {{ SC_(-0.22e2), SC_(0.1185395751953125e4), SC_(-6.9044355508865664897043139406055964426416997874159e-517) }}, 
      {{ SC_(-0.22e2), SC_(0.353451806640625e4), SC_(-2.1477696015015210740350508446939009163788237281375e-1537) }}, 
      {{ SC_(-0.22e2), SC_(0.80715478515625e4), SC_(-5.3571166553486953693609348836918508699371777331569e-3508) }}, 
      {{ SC_(-0.22e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.3171196651710141760149001465312742337397514341269e-7051)) }}, 
      {{ SC_(-0.22e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6212944959983963671978197048076565152784175046644e-13929)) }}, 
      {{ SC_(-0.22e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.635913148542055714764458469524461642442283979926e-15797)) }}, 
      {{ SC_(-0.25e2), SC_(0.30944411754608154296875e1), SC_(-41729098358824816367.531654303904514858752786596332) }}, 
      {{ SC_(-0.25e2), SC_(0.51139926910400390625e1), SC_(-75724315461736.290472640765730196083672968985136938) }}, 
      {{ SC_(-0.25e2), SC_(0.95070552825927734375e1), SC_(-4126624.249430058099093859743827049880078207173409) }}, 
      {{ SC_(-0.25e2), SC_(0.24750102996826171875e2), SC_(-7.0643906010259470186673848613347677516199041790009e-07) }}, 
      {{ SC_(-0.25e2), SC_(0.637722015380859375e2), SC_(-4.1643482972195352253468903896264828993995073276145e-27) }}, 
      {{ SC_(-0.25e2), SC_(0.1252804412841796875e3), SC_(-5.3178886190804620477737626532158770815906964663127e-55) }}, 
      {{ SC_(-0.25e2), SC_(0.25554705810546875e3), SC_(-2.7795327530969693291369188001213305521084456625436e-112) }}, 
      {{ SC_(-0.25e2), SC_(0.503011474609375e3), SC_(-3.6518004666178007044186210479360824108573588622057e-220) }}, 
      {{ SC_(-0.25e2), SC_(0.10074598388671875e4), SC_(-1.5744568976732275885992670337217796592504913121584e-439) }}, 
      {{ SC_(-0.25e2), SC_(0.1185395751953125e4), SC_(-7.3276800998268647692604417584333403318008306406733e-517) }}, 
      {{ SC_(-0.25e2), SC_(0.353451806640625e4), SC_(-2.1910452731818947586325883979465511464264539353135e-1537) }}, 
      {{ SC_(-0.25e2), SC_(0.80715478515625e4), SC_(-5.4041155687137445586759532827860341286134457664739e-3508) }}, 
      {{ SC_(-0.25e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.3402682255219835253427725149973742435369817524698e-7051)) }}, 
      {{ SC_(-0.25e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6314660942879182904010929303912396455213934813636e-13929)) }}, 
      {{ SC_(-0.25e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6410279450461977849642611156331880833233865462e-15797)) }}, 
      {{ SC_(-0.28e2), SC_(0.30944411754608154296875e1), SC_(-223541481119546943565773.77238812949490661085705339) }}, 
      {{ SC_(-0.28e2), SC_(0.51139926910400390625e1), SC_(-91328051744707544.652123318374534205924759494110627) }}, 
      {{ SC_(-0.28e2), SC_(0.95070552825927734375e1), SC_(-822693275.5242087631582359380187569199057969266947) }}, 
      {{ SC_(-0.28e2), SC_(0.24750102996826171875e2), SC_(-1.1854935611365514036505785383443316866729190727564e-05) }}, 
      {{ SC_(-0.28e2), SC_(0.637722015380859375e2), SC_(-1.4124113665476923796445676488243428439766486148717e-26) }}, 
      {{ SC_(-0.28e2), SC_(0.1252804412841796875e3), SC_(-1.0008037756307772952218495299728784823293653767184e-54) }}, 
      {{ SC_(-0.28e2), SC_(0.25554705810546875e3), SC_(-3.7940015167787738318119650584499693396241466574168e-112) }}, 
      {{ SC_(-0.28e2), SC_(0.503011474609375e3), SC_(-4.2774251594777351347198673166771658617522678943309e-220) }}, 
      {{ SC_(-0.28e2), SC_(0.10074598388671875e4), SC_(-1.703783993941899631566185548014391220431437394766e-439) }}, 
      {{ SC_(-0.28e2), SC_(0.1185395751953125e4), SC_(-7.8361512939747361305212762070103643170691014993883e-517) }}, 
      {{ SC_(-0.28e2), SC_(0.353451806640625e4), SC_(-2.2408923350830720095143097122311787565315704403488e-1537) }}, 
      {{ SC_(-0.28e2), SC_(0.80715478515625e4), SC_(-5.4576091532501692885292061883167808063027930434652e-3508) }}, 
      {{ SC_(-0.28e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.3664928398359776281234804909442118061100108151808e-7051)) }}, 
      {{ SC_(-0.28e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6429630541796104237749602570489257692109850962021e-13929)) }}, 
      {{ SC_(-0.28e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.646807601440360378041044945401048496330886623631e-15797)) }}, 
      {{ SC_(-0.31e2), SC_(0.30944411754608154296875e1), SC_(-1640236982737227798605513105.2881214516864645343434) }}, 
      {{ SC_(-0.31e2), SC_(0.51139926910400390625e1), SC_(-150424707960029880305.45068169485722345223203510988) }}, 
      {{ SC_(-0.31e2), SC_(0.95070552825927734375e1), SC_(-221590731975.24004453330307164730400609023437029559) }}, 
      {{ SC_(-0.31e2), SC_(0.24750102996826171875e2), SC_(-0.00025306995657248261580226740957891309659224681774054) }}, 
      {{ SC_(-0.31e2), SC_(0.637722015380859375e2), SC_(-5.4545776065765355727476521506594315116710188713781e-26) }}, 
      {{ SC_(-0.31e2), SC_(0.1252804412841796875e3), SC_(-2.0207447059124495823522914705039373108318480947504e-54) }}, 
      {{ SC_(-0.31e2), SC_(0.25554705810546875e3), SC_(-5.3635944812794373221435979845490523334605745757082e-112) }}, 
      {{ SC_(-0.31e2), SC_(0.503011474609375e3), SC_(-5.1006307993575805863091265527664070588810247284445e-220) }}, 
      {{ SC_(-0.31e2), SC_(0.10074598388671875e4), SC_(-1.8602804302571009850793812371180672711055310354359e-439) }}, 
      {{ SC_(-0.31e2), SC_(0.1185395751953125e4), SC_(-8.4437803307009087901729105408645714828298735244045e-517) }}, 
      {{ SC_(-0.31e2), SC_(0.353451806640625e4), SC_(-2.2977173488642354738881892443842860150149738523369e-1537) }}, 
      {{ SC_(-0.31e2), SC_(0.80715478515625e4), SC_(-5.5177816478944763257972176637580727577052830273422e-3508) }}, 
      {{ SC_(-0.31e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.3958377791903350631088933189075859744575429232595e-7051)) }}, 
      {{ SC_(-0.31e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6557951282954426231640126213356050448139072138644e-13929)) }}, 
      {{ SC_(-0.31e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6532564367860076196323499486018589342074947176568e-15797)) }}, 
      {{ SC_(-0.34e2), SC_(0.51139926910400390625e1), SC_(-328678035141376004479093.02895716688943798989311409) }}, 
      {{ SC_(-0.34e2), SC_(0.95070552825927734375e1), SC_(-78535569831698.020065027678249059741866901003361821) }}, 
      {{ SC_(-0.34e2), SC_(0.24750102996826171875e2), SC_(-0.0067753238411528031951525513830459113313055439948589) }}, 
      {{ SC_(-0.34e2), SC_(0.637722015380859375e2), SC_(-2.3928748300513971766068979044071342098142733664491e-25) }}, 
      {{ SC_(-0.34e2), SC_(0.1252804412841796875e3), SC_(-4.3758379103735294610353452655731282838090916844577e-54) }}, 
      {{ SC_(-0.34e2), SC_(0.25554705810546875e3), SC_(-7.8528364954696475566319427248735375479775152490362e-112) }}, 
      {{ SC_(-0.34e2), SC_(0.503011474609375e3), SC_(-6.1919683563153717438286369297503338627087616975563e-220) }}, 
      {{ SC_(-0.34e2), SC_(0.10074598388671875e4), SC_(-2.0493780828306995383518852372735975061025948664944e-439) }}, 
      {{ SC_(-0.34e2), SC_(0.1185395751953125e4), SC_(-9.1678739875353997897519231873964323153980032565967e-517) }}, 
      {{ SC_(-0.34e2), SC_(0.353451806640625e4), SC_(-2.3619906840424561820014346474726360414214577164765e-1537) }}, 
      {{ SC_(-0.34e2), SC_(0.80715478515625e4), SC_(-5.5848416925972983371675307232265311162794956946164e-3508) }}, 
      {{ SC_(-0.34e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.4283527507837718978871014447929518480577262702653e-7051)) }}, 
      {{ SC_(-0.34e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6699732206800479061156813026343140156858111388875e-13929)) }}, 
      {{ SC_(-0.34e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6603792775871613150958050960274229979112419957377e-15797)) }}, 
      {{ SC_(-0.37e2), SC_(0.51139926910400390625e1), SC_(-929997097734757375914108536.91194181930238365891591) }}, 
      {{ SC_(-0.37e2), SC_(0.95070552825927734375e1), SC_(-35818326839692910.232572072179156799711596268212725) }}, 
      {{ SC_(-0.37e2), SC_(0.24750102996826171875e2), SC_(-0.22454475758844790783476687462532063012911745094225) }}, 
      {{ SC_(-0.37e2), SC_(0.637722015380859375e2), SC_(-1.1895138610350592293727496258471892916551533162382e-24) }}, 
      {{ SC_(-0.37e2), SC_(0.1252804412841796875e3), SC_(-1.015825180778943325378031057870706354278400016343e-53) }}, 
      {{ SC_(-0.37e2), SC_(0.25554705810546875e3), SC_(-1.1906574134604491062178884977162193791160863889135e-111) }}, 
      {{ SC_(-0.37e2), SC_(0.503011474609375e3), SC_(-7.6523344761349789515020431325546579744433304404247e-220) }}, 
      {{ SC_(-0.37e2), SC_(0.10074598388671875e4), SC_(-2.2779551571517289191980410236280566265385395792574e-439) }}, 
      {{ SC_(-0.37e2), SC_(0.1185395751953125e4), SC_(-1.0029925564582425213168108803987022721864611042488e-516) }}, 
      {{ SC_(-0.37e2), SC_(0.353451806640625e4), SC_(-2.4342529973922420366574119310564969136809379938833e-1537) }}, 
      {{ SC_(-0.37e2), SC_(0.80715478515625e4), SC_(-5.6590235338706442214697901076209156525030221963817e-3508) }}, 
      {{ SC_(-0.37e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.4640930382736375883740917300324268280790516937591e-7051)) }}, 
      {{ SC_(-0.37e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.6855094022443588008576096608994048582227672193389e-13929)) }}, 
      {{ SC_(-0.37e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6681814638111980522212240684691129179478201750845e-15797)) }}, 
      {{ SC_(-0.4e2), SC_(0.51139926910400390625e1), SC_(-3338963200983143316808420230598.7422406937148868183) }}, 
      {{ SC_(-0.4e2), SC_(0.95070552825927734375e1), SC_(-20625534091856759325.153248910820431574800918064066) }}, 
      {{ SC_(-0.4e2), SC_(0.24750102996826171875e2), SC_(-9.1028088358418251680234816506659814561972328165202) }}, 
      {{ SC_(-0.4e2), SC_(0.637722015380859375e2), SC_(-6.6836118347027771842091390905922896944789906198879e-24) }}, 
      {{ SC_(-0.4e2), SC_(0.1252804412841796875e3), SC_(-2.5269255948292334070520278151115302162637776825505e-53) }}, 
      {{ SC_(-0.4e2), SC_(0.25554705810546875e3), SC_(-1.8694429917428252226241506811131591248449772900623e-111) }}, 
      {{ SC_(-0.4e2), SC_(0.503011474609375e3), SC_(-9.6275608457728276341680839156418369724029596452446e-220) }}, 
      {{ SC_(-0.4e2), SC_(0.10074598388671875e4), SC_(-2.554743244448886972203980564016447807064474698151e-439) }}, 
      {{ SC_(-0.4e2), SC_(0.1185395751953125e4), SC_(-1.1056658608826093680394497615344879503318731249082e-516) }}, 
      {{ SC_(-0.4e2), SC_(0.353451806640625e4), SC_(-2.5151227940369883011098800558323175513058778154582e-1537) }}, 
      {{ SC_(-0.4e2), SC_(0.80715478515625e4), SC_(-5.7405883880397339633815351417370007119421688235109e-3508) }}, 
      {{ SC_(-0.4e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.5031196584341509495456350289667555127248812793141e-7051)) }}, 
      {{ SC_(-0.4e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.7024169278944099483784991544653853693793666308474e-13929)) }}, 
      {{ SC_(-0.4e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6766688555613534380265612383537440220361698452617e-15797)) }}, 
      {{ SC_(-0.43e2), SC_(0.95070552825927734375e1), SC_(-14751470981781795117342.206559243263921600191401087) }}, 
      {{ SC_(-0.43e2), SC_(0.24750102996826171875e2), SC_(-446.4891806253159523882574363612812235063651249585) }}, 
      {{ SC_(-0.43e2), SC_(0.637722015380859375e2), SC_(-4.233763666839872384105458954598432131993398426424e-23) }}, 
      {{ SC_(-0.43e2), SC_(0.1252804412841796875e3), SC_(-6.7325145575430846585913103554917629582161317284093e-53) }}, 
      {{ SC_(-0.43e2), SC_(0.25554705810546875e3), SC_(-3.0393193136330068311064186789994907170477541436742e-111) }}, 
      {{ SC_(-0.43e2), SC_(0.503011474609375e3), SC_(-1.2330826146776709270895628560382305428782566679454e-219) }}, 
      {{ SC_(-0.43e2), SC_(0.10074598388671875e4), SC_(-2.8908656732737407085369043325253772506966386036777e-439) }}, 
      {{ SC_(-0.43e2), SC_(0.1185395751953125e4), SC_(-1.228137337659943886994500950345142111874164409792e-516) }}, 
      {{ SC_(-0.43e2), SC_(0.353451806640625e4), SC_(-2.6053052179496807854002052846934046858863225713023e-1537) }}, 
      {{ SC_(-0.43e2), SC_(0.80715478515625e4), SC_(-5.8298259733030657922737308980843341607932632090959e-3508) }}, 
      {{ SC_(-0.43e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.5454995347571058373140661485359338188390382342065e-7051)) }}, 
      {{ SC_(-0.43e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.7207102553793366648911501018898244135468776654792e-13929)) }}, 
      {{ SC_(-0.43e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6858478404126064957826967503455732509170372752387e-15797)) }}, 
      {{ SC_(-0.46e2), SC_(0.95070552825927734375e1), SC_(-12917663347203686143836143.910805742895581704655586) }}, 
      {{ SC_(-0.46e2), SC_(0.24750102996826171875e2), SC_(-26235.057710202278650539924850662186008741433512393) }}, 
      {{ SC_(-0.46e2), SC_(0.637722015380859375e2), SC_(-3.0156867854089343237058938921516747812188476263389e-22) }}, 
      {{ SC_(-0.46e2), SC_(0.1252804412841796875e3), SC_(-1.9202503812985560131703463254740169819405710994174e-52) }}, 
      {{ SC_(-0.46e2), SC_(0.25554705810546875e3), SC_(-5.1162385357259218814379585073336770260558101085837e-111) }}, 
      {{ SC_(-0.46e2), SC_(0.503011474609375e3), SC_(-1.6077475093930052657164489721995166598423341235489e-219) }}, 
      {{ SC_(-0.46e2), SC_(0.10074598388671875e4), SC_(-3.3005525584724455924638535580342688289649145504404e-439) }}, 
      {{ SC_(-0.46e2), SC_(0.1185395751953125e4), SC_(-1.3745689249476539405584614575190967881455015120684e-516) }}, 
      {{ SC_(-0.46e2), SC_(0.353451806640625e4), SC_(-2.7056022462095521839411435730865310104730331173963e-1537) }}, 
      {{ SC_(-0.46e2), SC_(0.80715478515625e4), SC_(-5.927056223173338451095346393985816542039985357571e-3508) }}, 
      {{ SC_(-0.46e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.591305688686474794775130781662039882343320309422e-7051)) }}, 
      {{ SC_(-0.46e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.7404050658960917907025134665504351612320771593753e-13929)) }}, 
      {{ SC_(-0.46e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.6957253414238011594678945835534568876412319193364e-15797)) }}, 
      {{ SC_(-0.49e2), SC_(0.95070552825927734375e1), SC_(-13677119048020081769637857664.004679755744731957881) }}, 
      {{ SC_(-0.49e2), SC_(0.24750102996826171875e2), SC_(-1829919.8337911038500181616492167542226106316593553) }}, 
      {{ SC_(-0.49e2), SC_(0.637722015380859375e2), SC_(-2.4091155491341019251051477476213134709801586915375e-21) }}, 
      {{ SC_(-0.49e2), SC_(0.1252804412841796875e3), SC_(-5.8601406376694995179250459524941405890984488660674e-52) }}, 
      {{ SC_(-0.49e2), SC_(0.25554705810546875e3), SC_(-8.9167249449039720144703319084878032545363029340332e-111) }}, 
      {{ SC_(-0.49e2), SC_(0.503011474609375e3), SC_(-2.1339744180391502000629280946419467146701524975424e-219) }}, 
      {{ SC_(-0.49e2), SC_(0.10074598388671875e4), SC_(-3.8020950617098093543830635326665989348871235898462e-439) }}, 
      {{ SC_(-0.49e2), SC_(0.1185395751953125e4), SC_(-1.5501807755899059080053982360752652725485301431675e-516) }}, 
      {{ SC_(-0.49e2), SC_(0.353451806640625e4), SC_(-2.8169244924241460164438048123312445224362447071592e-1537) }}, 
      {{ SC_(-0.49e2), SC_(0.80715478515625e4), SC_(-6.0326311954734093692278078699231482140946616761111e-3508) }}, 
      {{ SC_(-0.49e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.6406174492518179553474257829835162835218380431621e-7051)) }}, 
      {{ SC_(-0.49e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.7615182864919918135529022171048378859158392609952e-13929)) }}, 
      {{ SC_(-0.49e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7063088258400746858178205556822115360901063089561e-15797)) }}, 
      {{ SC_(-0.52e2), SC_(0.24750102996826171875e2), SC_(-150258349.48298965521429912649566332286572127204838) }}, 
      {{ SC_(-0.52e2), SC_(0.637722015380859375e2), SC_(-2.1528420937982545309308124336084241462033188006075e-20) }}, 
      {{ SC_(-0.52e2), SC_(0.1252804412841796875e3), SC_(-1.9124591299228762415276179510248192934684406939518e-51) }}, 
      {{ SC_(-0.52e2), SC_(0.25554705810546875e3), SC_(-1.6088221227173773682509376149516801543260419158969e-110) }}, 
      {{ SC_(-0.52e2), SC_(0.503011474609375e3), SC_(-2.8833802628518198753473420283435726540577353906032e-219) }}, 
      {{ SC_(-0.52e2), SC_(0.10074598388671875e4), SC_(-4.4191253669027448430900956857887401202794330219532e-439) }}, 
      {{ SC_(-0.52e2), SC_(0.1185395751953125e4), SC_(-1.7615463549207955715477300287834826367597256193556e-516) }}, 
      {{ SC_(-0.52e2), SC_(0.353451806640625e4), SC_(-2.9403048610899170278392449864767842502890156215295e-1537) }}, 
      {{ SC_(-0.52e2), SC_(0.80715478515625e4), SC_(-6.1469371928136573174899609668997058828924829672256e-3508) }}, 
      {{ SC_(-0.52e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.6935206819428165591414953780241913938460794989048e-7051)) }}, 
      {{ SC_(-0.52e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.784068114309897377446872510391181263746902485707e-13929)) }}, 
      {{ SC_(-0.52e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7176063145009074540843639989335150961054395784331e-15797)) }}, 
      {{ SC_(-0.55e2), SC_(0.24750102996826171875e2), SC_(-14413830415.043505622498237272304806634999080892398) }}, 
      {{ SC_(-0.55e2), SC_(0.637722015380859375e2), SC_(-2.1464996996211206379833011948578327129626522316385e-19) }}, 
      {{ SC_(-0.55e2), SC_(0.1252804412841796875e3), SC_(-6.6706142582159264121826823735445847276926891746691e-51) }}, 
      {{ SC_(-0.55e2), SC_(0.25554705810546875e3), SC_(-3.004864584083453767723846822808713021733203118935e-110) }}, 
      {{ SC_(-0.55e2), SC_(0.503011474609375e3), SC_(-3.9659877945884680536425554912980359884903202119623e-219) }}, 
      {{ SC_(-0.55e2), SC_(0.10074598388671875e4), SC_(-5.1823426897188153001977915991297817970825407128731e-439) }}, 
      {{ SC_(-0.55e2), SC_(0.1185395751953125e4), SC_(-2.016978896175023430703409277539108978367915911435e-516) }}, 
      {{ SC_(-0.55e2), SC_(0.353451806640625e4), SC_(-3.0769143373632447110150563681035216189281522248719e-1537) }}, 
      {{ SC_(-0.55e2), SC_(0.80715478515625e4), SC_(-6.2703971123999375125348312453069325185560504412597e-3508) }}, 
      {{ SC_(-0.55e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.75010803774901283903544699700514766973488614337e-7051)) }}, 
      {{ SC_(-0.55e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.808074042724642620167603612982730342429817871781e-13929)) }}, 
      {{ SC_(-0.55e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7296263919703879232822407374814832664034636285938e-15797)) }}, 
      {{ SC_(-0.58e2), SC_(0.24750102996826171875e2), SC_(-1603989324781.8613059589905098516400380552351596402) }}, 
      {{ SC_(-0.58e2), SC_(0.637722015380859375e2), SC_(-2.3818199749807331061229379575504067327287212253734e-18) }}, 
      {{ SC_(-0.58e2), SC_(0.1252804412841796875e3), SC_(-2.4852880984664790259110929628592264740680082063308e-50) }}, 
      {{ SC_(-0.58e2), SC_(0.25554705810546875e3), SC_(-5.8092541451213583956214309790743040583347170105081e-110) }}, 
      {{ SC_(-0.58e2), SC_(0.503011474609375e3), SC_(-5.5530641469438098153130349964319974095484016307095e-219) }}, 
      {{ SC_(-0.58e2), SC_(0.10074598388671875e4), SC_(-6.1318535699122284348981617184105940457283225600075e-439) }}, 
      {{ SC_(-0.58e2), SC_(0.1185395751953125e4), SC_(-2.3270397644903488747163583768764173678891352307339e-516) }}, 
      {{ SC_(-0.58e2), SC_(0.353451806640625e4), SC_(-3.2280802469837084965584387996562996780057017166825e-1537) }}, 
      {{ SC_(-0.58e2), SC_(0.80715478515625e4), SC_(-6.4034730451370018782740799734261468642567623641441e-3508) }}, 
      {{ SC_(-0.58e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.8104792233753955355520282491947186123211010733431e-7051)) }}, 
      {{ SC_(-0.58e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.8335568894232624343928408965025590678904601171011e-13929)) }}, 
      {{ SC_(-0.58e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7423782174076034446389751732896351531311932177183e-15797)) }}, 
      {{ SC_(-0.61e2), SC_(0.24750102996826171875e2), SC_(-205727990081990.5374214365803780584578675993561475) }}, 
      {{ SC_(-0.61e2), SC_(0.637722015380859375e2), SC_(-2.9339998139627598638617329174552107215335862557709e-17) }}, 
      {{ SC_(-0.61e2), SC_(0.1252804412841796875e3), SC_(-9.8847467781508994744717116173140904534335446352474e-50) }}, 
      {{ SC_(-0.61e2), SC_(0.25554705810546875e3), SC_(-1.1624040153131934523520628245907386761375266054618e-109) }}, 
      {{ SC_(-0.61e2), SC_(0.503011474609375e3), SC_(-7.9148143857148512750388962850545995108452710985144e-219) }}, 
      {{ SC_(-0.61e2), SC_(0.10074598388671875e4), SC_(-7.3203630041953160939492553010522208138676250836544e-439) }}, 
      {{ SC_(-0.61e2), SC_(0.1185395751953125e4), SC_(-2.7052102850120518653475252679675849458822285695168e-516) }}, 
      {{ SC_(-0.61e2), SC_(0.353451806640625e4), SC_(-3.3953073804137612575423594258488461994743817713619e-1537) }}, 
      {{ SC_(-0.61e2), SC_(0.80715478515625e4), SC_(-6.5466691463255843703828399656160397128105071410256e-3508) }}, 
      {{ SC_(-0.61e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.8747412937362980710179754497998945385053913457506e-7051)) }}, 
      {{ SC_(-0.61e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.8605388264856372237761800655715974006277741967001e-13929)) }}, 
      {{ SC_(-0.61e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7558715361964252660069781536302351685807597625494e-15797)) }}, 
      {{ SC_(-0.64e2), SC_(0.24750102996826171875e2), SC_(-30231557057292254.806826756836766232605862434079551) }}, 
      {{ SC_(-0.64e2), SC_(0.637722015380859375e2), SC_(-4.0023885413168133146932069839198259075638739349785e-16) }}, 
      {{ SC_(-0.64e2), SC_(0.1252804412841796875e3), SC_(-4.1943691089859731371373998397631983520432183278204e-49) }}, 
      {{ SC_(-0.64e2), SC_(0.25554705810546875e3), SC_(-2.4071106589627185535873189544045677480372059884021e-109) }}, 
      {{ SC_(-0.64e2), SC_(0.503011474609375e3), SC_(-1.1483389777474423005276705035363976319777945180197e-218) }}, 
      {{ SC_(-0.64e2), SC_(0.10074598388671875e4), SC_(-8.8175508716798784642146182686013328481454828391758e-439) }}, 
      {{ SC_(-0.64e2), SC_(0.1185395751953125e4), SC_(-3.1687838197836708380681044049701013199356389866298e-516) }}, 
      {{ SC_(-0.64e2), SC_(0.353451806640625e4), SC_(-3.5803024454118403953932606699232935376435375864878e-1537) }}, 
      {{ SC_(-0.64e2), SC_(0.80715478515625e4), SC_(-6.7005348028299924018018129895663115571157374041883e-3508) }}, 
      {{ SC_(-0.64e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.9430089679276831935524603511515246469368335713528e-7051)) }}, 
      {{ SC_(-0.64e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.8890434125263919607223046975257449165530939107103e-13929)) }}, 
      {{ SC_(-0.64e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7701166923553576110729712559776270189707146594402e-15797)) }}, 
      {{ SC_(-0.67e2), SC_(0.24750102996826171875e2), SC_(-5061777992457529851.7390091992143260326465507151343) }}, 
      {{ SC_(-0.67e2), SC_(0.637722015380859375e2), SC_(-6.0317754176643425166044924813756167778331513629679e-15) }}, 
      {{ SC_(-0.67e2), SC_(0.1252804412841796875e3), SC_(-1.8976187232997037166756563939493260804940923981923e-48) }}, 
      {{ SC_(-0.67e2), SC_(0.25554705810546875e3), SC_(-5.1581809985088706413298769160254172046729928087796e-109) }}, 
      {{ SC_(-0.67e2), SC_(0.503011474609375e3), SC_(-1.6959582073755216495099635587291329763194962697345e-218) }}, 
      {{ SC_(-0.67e2), SC_(0.10074598388671875e4), SC_(-1.0716109184246349104842215983323268048553186074599e-438) }}, 
      {{ SC_(-0.67e2), SC_(0.1185395751953125e4), SC_(-3.7400560529623726351030640662230470531974478937127e-516) }}, 
      {{ SC_(-0.67e2), SC_(0.353451806640625e4), SC_(-3.7850023953787082536234091066973152288769647770207e-1537) }}, 
      {{ SC_(-0.67e2), SC_(0.80715478515625e4), SC_(-6.8656681244479627373328136425871372353743336555496e-3508) }}, 
      {{ SC_(-0.67e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.0154049699818194298414516919926570919397056061135e-7051)) }}, 
      {{ SC_(-0.67e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.9190956269632617459294020571954725871539532297759e-13929)) }}, 
      {{ SC_(-0.67e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.7851246417495694875076256540067519504234091978718e-15797)) }}, 
      {{ SC_(-0.7e2), SC_(0.24750102996826171875e2), SC_(-960719766377563642547.84784436439965607261717936572) }}, 
      {{ SC_(-0.7e2), SC_(0.637722015380859375e2), SC_(-1.0018948309853140553793839732399474374038521342822e-13) }}, 
      {{ SC_(-0.7e2), SC_(0.1252804412841796875e3), SC_(-9.1478005129071685822585014801797604042121991775186e-48) }}, 
      {{ SC_(-0.7e2), SC_(0.25554705810546875e3), SC_(-1.1437112875547581040508453224386896980882218243944e-108) }}, 
      {{ SC_(-0.7e2), SC_(0.503011474609375e3), SC_(-2.5495875855024647038175630884222826135491275025261e-218) }}, 
      {{ SC_(-0.7e2), SC_(0.10074598388671875e4), SC_(-1.3140120163828277000968506238809976026387713024023e-438) }}, 
      {{ SC_(-0.7e2), SC_(0.1185395751953125e4), SC_(-4.4479210253708017953989477643322660025768603401623e-516) }}, 
      {{ SC_(-0.7e2), SC_(0.353451806640625e4), SC_(-4.011607279487438869633191688770704873886231134706e-1537) }}, 
      {{ SC_(-0.7e2), SC_(0.80715478515625e4), SC_(-7.042719790380435288707526346406999737819404508234e-3508) }}, 
      {{ SC_(-0.7e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.0920603958191974077351373685096064096349419355278e-7051)) }}, 
      {{ SC_(-0.7e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.9507219064816815225818933615045945030757314244068e-13929)) }}, 
      {{ SC_(-0.7e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8009069661287273247872110387701501847750932342624e-15797)) }}, 
      {{ SC_(-0.73e2), SC_(0.24750102996826171875e2), SC_(-205719376526896502657652.96550991890838816063791109) }}, 
      {{ SC_(-0.73e2), SC_(0.637722015380859375e2), SC_(-1.8300431219071119872880395867409742102142917730265e-12) }}, 
      {{ SC_(-0.73e2), SC_(0.1252804412841796875e3), SC_(-4.6958048660578828796346820899034077665825783934045e-47) }}, 
      {{ SC_(-0.73e2), SC_(0.25554705810546875e3), SC_(-2.6236852703230463989159054674929686721177502367006e-108) }}, 
      {{ SC_(-0.73e2), SC_(0.503011474609375e3), SC_(-3.9014702654874034106876012771696386159778136815961e-218) }}, 
      {{ SC_(-0.73e2), SC_(0.10074598388671875e4), SC_(-1.6256753185931080016278217071058734206460353005272e-438) }}, 
      {{ SC_(-0.73e2), SC_(0.1185395751953125e4), SC_(-5.3300219828181147858062787897171456179634070597516e-516) }}, 
      {{ SC_(-0.73e2), SC_(0.353451806640625e4), SC_(-4.2626183779380336824380883140647108026451658293156e-1537) }}, 
      {{ SC_(-0.73e2), SC_(0.80715478515625e4), SC_(-7.2323972852147199789443100363498297809281819979803e-3508) }}, 
      {{ SC_(-0.73e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.1731151079309191917184639095298319465383713817986e-7051)) }}, 
      {{ SC_(-0.73e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-4.9839501837700855537119137483951258337511595368787e-13929)) }}, 
      {{ SC_(-0.73e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.817475888015800256208872261271522867678161060716e-15797)) }}, 
      {{ SC_(-0.76e2), SC_(0.24750102996826171875e2), SC_(-49478353255850169884934069.299878417564058220806436) }}, 
      {{ SC_(-0.76e2), SC_(0.637722015380859375e2), SC_(-3.6677657057343833378790228611478009054081670021689e-11) }}, 
      {{ SC_(-0.76e2), SC_(0.1252804412841796875e3), SC_(-2.565109608997742743110499398388763645670177075402e-46) }}, 
      {{ SC_(-0.76e2), SC_(0.25554705810546875e3), SC_(-6.2264033726422710289672726231798445145431543554852e-108) }}, 
      {{ SC_(-0.76e2), SC_(0.503011474609375e3), SC_(-6.0769241217951763607655077687262098816000800412697e-218) }}, 
      {{ SC_(-0.76e2), SC_(0.10074598388671875e4), SC_(-2.0292695565475860494513194802911931028995921345127e-438) }}, 
      {{ SC_(-0.76e2), SC_(0.1185395751953125e4), SC_(-6.4356646706199133752004959764845941040720194537884e-516) }}, 
      {{ SC_(-0.76e2), SC_(0.353451806640625e4), SC_(-4.5408825254310089726335939548022782201008737968778e-1537) }}, 
      {{ SC_(-0.76e2), SC_(0.80715478515625e4), SC_(-7.4354695627440530875708592525605793700698293761757e-3508) }}, 
      {{ SC_(-0.76e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.2587181594514014603747134114494582948715924210721e-7051)) }}, 
      {{ SC_(-0.76e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.0188099286053257564330261352245750063020523517253e-13929)) }}, 
      {{ SC_(-0.76e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8348442864736215848869024786087057360126591539601e-15797)) }}, 
      {{ SC_(-0.79e2), SC_(0.24750102996826171875e2), SC_(-13311377801888047309231869120.542790729005902613362) }}, 
      {{ SC_(-0.79e2), SC_(0.637722015380859375e2), SC_(-8.0484077746939564571976121590206071184506511322372e-10) }}, 
      {{ SC_(-0.79e2), SC_(0.1252804412841796875e3), SC_(-1.4901108972501235761543315633801893534378820456469e-45) }}, 
      {{ SC_(-0.79e2), SC_(0.25554705810546875e3), SC_(-1.5284322081202891503901188222847649345982863995208e-107) }}, 
      {{ SC_(-0.79e2), SC_(0.503011474609375e3), SC_(-9.6345135340008718538715982389228126878365004083811e-218) }}, 
      {{ SC_(-0.79e2), SC_(0.10074598388671875e4), SC_(-2.5557376477668938366873901370154979501643660675242e-438) }}, 
      {{ SC_(-0.79e2), SC_(0.1185395751953125e4), SC_(-7.8297837190005907655601672044981753284470473812561e-516) }}, 
      {{ SC_(-0.79e2), SC_(0.353451806640625e4), SC_(-4.8496436926873884286440646192513168255119073983292e-1537) }}, 
      {{ SC_(-0.79e2), SC_(0.80715478515625e4), SC_(-7.6527721802990117462670607408793544234827815552886e-3508) }}, 
      {{ SC_(-0.79e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.3490282494167977009540233126435006038243581853711e-7051)) }}, 
      {{ SC_(-0.79e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.0553321913727506552657665860597886292201998202501e-13929)) }}, 
      {{ SC_(-0.79e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8530257137776636178810078824677341688051566573746e-15797)) }}, 
      {{ SC_(-0.82e2), SC_(0.637722015380859375e2), SC_(-1.929664940040155693529466887952144814051447724959e-08) }}, 
      {{ SC_(-0.82e2), SC_(0.1252804412841796875e3), SC_(-9.1994155998441512754636871834721249790632784175968e-45) }}, 
      {{ SC_(-0.82e2), SC_(0.25554705810546875e3), SC_(-3.880523666220452737290266931254477983415313628438e-107) }}, 
      {{ SC_(-0.82e2), SC_(0.503011474609375e3), SC_(-1.554745475514337721891632426144897014927362503757e-217) }}, 
      {{ SC_(-0.82e2), SC_(0.10074598388671875e4), SC_(-3.2475999045999570181747261157749673369391101595774e-438) }}, 
      {{ SC_(-0.82e2), SC_(0.1185395751953125e4), SC_(-9.5983710027436750265702531274004702246767579076882e-516) }}, 
      {{ SC_(-0.82e2), SC_(0.353451806640625e4), SC_(-5.1926030950825285600618345570808515093818563886244e-1537) }}, 
      {{ SC_(-0.82e2), SC_(0.80715478515625e4), SC_(-7.8852129511171532286208132853871491236357544988575e-3508) }}, 
      {{ SC_(-0.82e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.4442142111498586191463295549950995161009635632053e-7051)) }}, 
      {{ SC_(-0.82e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.0935496491108428955283035163133522638143765212297e-13929)) }}, 
      {{ SC_(-0.82e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8720344130252226985727735707660611379569218277457e-15797)) }}, 
      {{ SC_(-0.85e2), SC_(0.637722015380859375e2), SC_(-5.0447671615505518655123386164414515050269005768116e-07) }}, 
      {{ SC_(-0.85e2), SC_(0.1252804412841796875e3), SC_(-6.0317262234008813937658078553988664012097242138782e-44) }}, 
      {{ SC_(-0.85e2), SC_(0.25554705810546875e3), SC_(-1.0188732720454341381521059175302890088207242434688e-106) }}, 
      {{ SC_(-0.85e2), SC_(0.503011474609375e3), SC_(-2.5536722931770409635190252307901838371333480641471e-217) }}, 
      {{ SC_(-0.85e2), SC_(0.10074598388671875e4), SC_(-4.163682178034477865419644212672881655736983426055e-438) }}, 
      {{ SC_(-0.85e2), SC_(0.1185395751953125e4), SC_(-1.1855944110337321358335194728357090546728991002798e-515) }}, 
      {{ SC_(-0.85e2), SC_(0.353451806640625e4), SC_(-5.5739893359223912155589799460065075879733445391168e-1537) }}, 
      {{ SC_(-0.85e2), SC_(0.80715478515625e4), SC_(-8.1337781676891146043172626859523144985078784468345e-3508) }}, 
      {{ SC_(-0.85e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.5444555358678712478142893859896373579504424808833e-7051)) }}, 
      {{ SC_(-0.85e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.1334966541759079954152078015386003001774040007563e-13929)) }}, 
      {{ SC_(-0.85e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.8918853367130211844771714641301138255390766751725e-15797)) }}, 
      {{ SC_(-0.88e2), SC_(0.637722015380859375e2), SC_(-1.4352892326685192269933720541462535626083742663234e-05) }}, 
      {{ SC_(-0.88e2), SC_(0.1252804412841796875e3), SC_(-4.1973246650065949973709196550419958201971684895847e-43) }}, 
      {{ SC_(-0.88e2), SC_(0.25554705810546875e3), SC_(-2.7662078787178059924505957855573511486147491827993e-106) }}, 
      {{ SC_(-0.88e2), SC_(0.503011474609375e3), SC_(-4.2691356322860956850905553978678973095694357478875e-217) }}, 
      {{ SC_(-0.88e2), SC_(0.10074598388671875e4), SC_(-5.3859271482409235484034083878540429529372064477554e-438) }}, 
      {{ SC_(-0.88e2), SC_(0.1185395751953125e4), SC_(-1.4755876549974846772926302013801419869024203613031e-515) }}, 
      {{ SC_(-0.88e2), SC_(0.353451806640625e4), SC_(-5.9986403777420733686664189021548382857880737324782e-1537) }}, 
      {{ SC_(-0.88e2), SC_(0.80715478515625e4), SC_(-8.3995394550628292156517670639450923693412327537556e-3508) }}, 
      {{ SC_(-0.88e2), SC_(0.1622925e5), SC_(BOOST_MATH_SMALL_CONSTANT(-6.6499429337777740527854112012152307484800747131988e-7051)) }}, 
      {{ SC_(-0.88e2), SC_(0.3206622265625e5), SC_(BOOST_MATH_SMALL_CONSTANT(-5.1752092856281561337229432353326859580022400449271e-13929)) }}, 
      {{ SC_(-0.88e2), SC_(0.3636794921875e5), SC_(BOOST_MATH_SMALL_CONSTANT(-2.91259416631711777510013561133401775712156938498e-15797)) }},
   }};
