//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Device/AxisPropertyForm.h
//! @brief     Defines class AxisPropertyForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2022
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_DEVICE_AXISPROPERTYFORM_H
#define BORNAGAIN_GUI_VIEW_DEVICE_AXISPROPERTYFORM_H

#include <QGroupBox>

class QSpinBox;
class AxisProperty;
class DoubleSpinBox;

//! Use this to edit an AxisProperty.
//!
//! An AxisProperty handles values for a EquiDivision. The values will be already written into the
//! data element. For each change of values, a signal will be emitted. Use this e.g. to update
//! dependent values or to set the document to modified.
class AxisPropertyForm : public QGroupBox {
    Q_OBJECT
public:
    AxisPropertyForm(QWidget* parent, const QString& groupTitle, AxisProperty* axisProperty,
                     QString nbinsTooltip = "");

    //! Reload UI from data
    void updateData();

signals:
    void dataChanged();

private:
    QSpinBox* m_nbinsSpinBox;
    AxisProperty* m_axisProperty;
    DoubleSpinBox* m_minSpinBox;
    DoubleSpinBox* m_maxSpinBox;
};


#endif // BORNAGAIN_GUI_VIEW_DEVICE_AXISPROPERTYFORM_H
