%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

%if %{?fedora}%{!?fedora:0} >= 7 || %{?rhel}%{!?rhel:0} >= 6
%define python_bindings 1
%else
%define python_bindings 0
%endif

Name:		canl-c++
Version:	1.1.0
Release:	1%{?dist}
Summary:	EMI Common Authentication library - bindings for C++

Group:		System Environment/Libraries
License:	ASL 2.0
URL:		http://www.nordugrid.org/
Source0:	http://download.nordugrid.org/packages/canl-c++/releases/%{version}/src/%{name}-%{version}.tar.gz
BuildRoot:	%(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

%if %{?fedora}%{!?fedora:5} > 4 && %{?suse_version:0}%{!?suse_version:1}
BuildRequires:	nss-devel >= 3.10
%else
BuildRequires:	mozilla-nss-devel
%endif
BuildRequires:	openssl-devel
BuildRequires:	cppunit-devel
BuildRequires:	glibmm24-devel

%if %{?suse_version}%{!?suse_version:0}
BuildRequires:	libdb-4_5-devel
%else
%if %{?fedora}%{!?fedora:0} >= 15 || %{?rhel}%{!?rhel:0} >= 7
BuildRequires:	libdb-cxx-devel
%else
%if %{?fedora}%{!?fedora:0} == 14
BuildRequires:	libdb-devel
%else
BuildRequires:	db4-devel
%endif
%endif
%endif
%if %{?python_bindings}%{!?python_bindings:0}
BuildRequires:	python-devel
BuildRequires:	swig
%endif

%description
This is the C++ part of the EMI caNl -- the Common Authentication
Library.

%package devel
Group:		Development/Libraries
Summary:	EMI Common Authentication library - development files for C++
Requires:	%{name}%{?_isa} = %{version}-%{release}

%description devel
This package contains development libraries and header files for EMI caNl
C++ bindings.

%if %{?python_bindings}%{!?python_bindings:0}
%package python
Summary:	EMI Authentication Library c++ python bindings 
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description python
EMI Authentication Library c++ python bindings.
%endif

%prep
%setup -q

%build
%configure %{?python_bindings:--enable-python-bindings}%{!?python_bindings:--disable-python-bindings}

# Reduce overlinking
sed 's!CC -shared !CC \${wl}--as-needed -shared !g' -i libtool

make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}

find %{buildroot} -type f -name \*.la -exec rm -fv '{}' ';'

%check
#make check

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc README debian/copyright
%{_libdir}/libcanl_c++.so.*

%files devel
%{_libdir}/libcanl_c++.so
%dir %{_includedir}/%{name}
%{_includedir}/%{name}/canlxx.h
%{_libdir}/pkgconfig/%{name}.pc

%if %{?python_bindings}%{!?python_bindings:0}
%files python
%defattr(-,root,root,-)
%{python_sitearch}/canl
%endif

%changelog
* Tue Apr 29 2014 Anders Waananen <waananen@nbi.dk> - 1.1.0-1
- 1.1.0 Final Release

* Wed Nov 27 2013 Anders Waananen <waananen@nbi.dk> - 1.0.1-1
- 1.0.1 Final Release

* Wed Feb 20 2013 Anders Waananen <waananen@nbi.dk> - 1.0.0-1
- 1.0.0 Final release

* Sat Feb 02 2013 Anders Waananen <waananen@nbi.dk> - 1.0.0-0.rc3
- 1.0.0 Release candidate 3

* Wed Jan 23 2013 Anders Waananen <waananen@nbi.dk> - 1.0.0-0.rc2
- 1.0.0 Release candidate 2

* Thu Nov 22 2012 Anders Waananen <waananen@nbi.dk> - 1.0.0-0.rc1
- 1.0.0 release candidate 1

* Wed May 16 2012 Anders Waananen <waananen@nbi.dk> - 0.2.0-1
- Initial version
